/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.model.reflection.BlockInfo;
import ro.amiq.pssdt.model.reflection.BlockKind;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.util.VisitedCheck;
import ro.amiq.pssdt.parser.SemanticWalker;

public class RfBlock
extends RfMembersContainer {
    private BlockKind blockKind = BlockKind.ACTIVITY;
    private BlockInfo blockInfo;
    private RfNamedElement constraintScope;
    private String instanceScopeName;
    private RfNamedElement matchScope;
    private boolean isBlockArray;

    public RfBlock(String name) {
        super(name);
    }

    public void setConstraintScope(String instanceScopeName, RfNamedElement secondaryScope) {
        this.instanceScopeName = instanceScopeName;
        this.constraintScope = secondaryScope;
    }

    public RfNamedElement getConstraintScope() {
        return this.constraintScope;
    }

    public String getInstanceScopeName() {
        return this.instanceScopeName;
    }

    @Override
    public String getKindName() {
        if (this.blockKind == null) {
            return null;
        }
        return this.blockKind.toString();
    }

    public void setMatchScope(RfNamedElement matchScope) {
        this.matchScope = matchScope;
    }

    public RfNamedElement getMatchScope() {
        return this.matchScope;
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
        this.instanceScopeName = null;
        this.constraintScope = null;
        this.matchScope = null;
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter elementFilter) {
        RfNamedElement result;
        if (!(this.constraintScope == null || this.constraintScope == SemanticWalker.UNRESOLVED_ELEMENT || elementFilter instanceof RfNamedElement.InnerScopeElementFileter && this.isAnonymous() || (result = this.constraintScope.getLocalMember(null, classes, name, isAmbiguousCheck, elementFilter)) == null)) {
            return result;
        }
        return super.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (!(this.constraintScope == null || this.constraintScope == SemanticWalker.UNRESOLVED_ELEMENT || elementFilter instanceof RfNamedElement.InnerScopeElementFileter && this.isAnonymous())) {
            this.constraintScope.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
        }
        super.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
    }

    @Override
    protected void internalGetMember(Set<RfNamedElement> result, RfDefElement lexicalScope, Determinant determinant, VisitedCheck visited, String name, boolean isAmbiguousCheck, boolean isTransitiveImport, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter elementFilter) {
        if (!(this.constraintScope == null || this.constraintScope == SemanticWalker.UNRESOLVED_ELEMENT || elementFilter instanceof RfNamedElement.InnerScopeElementFileter && this.isAnonymous())) {
            this.constraintScope.internalGetMember(result, lexicalScope, null, visited, name, isAmbiguousCheck, isTransitiveImport, isFirst, classes, elementFilter);
            if (!result.isEmpty()) {
                return;
            }
        }
        super.internalGetMember(result, lexicalScope, determinant, visited, name, isAmbiguousCheck, isTransitiveImport, isFirst, classes, elementFilter);
    }

    @Override
    public List<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        List<RfNamedElement> result2 = super.getLocalMembers(determinant, classes);
        if (this.constraintScope == null || this.constraintScope == SemanticWalker.UNRESOLVED_ELEMENT) {
            return result2;
        }
        List<RfNamedElement> result = this.constraintScope.getLocalMembers(null, classes);
        if (result == null || result.isEmpty()) {
            return result2;
        }
        if (result2 == null || result2.isEmpty()) {
            return result;
        }
        result.addAll(result2);
        return result;
    }

    @Override
    public Collection<RfNamedElement> getLocalMembers() {
        Collection<RfNamedElement> result2 = super.getLocalMembers();
        if (this.constraintScope == null || this.constraintScope == SemanticWalker.UNRESOLVED_ELEMENT) {
            return result2;
        }
        Collection<RfNamedElement> result = this.constraintScope.getLocalMembers();
        if (result == null || result.isEmpty()) {
            return result2;
        }
        if (result2 == null || result2.isEmpty()) {
            return result;
        }
        result.addAll(result2);
        return result;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (this.isAnonymous()) {
            return;
        }
        super.performAdditionalSemanticChecks(project, currentLayer);
    }

    public String getSignature() {
        switch (this.blockKind) {
            case ACTIVITY: {
                return "activity " + this.getName();
            }
            case CONSTRAINT: 
            case DYNAMIC_CONSTRAINT: {
                return "constraint " + this.getName();
            }
            case SELECT: {
                return "select " + this.getName();
            }
        }
        return "[unknown]";
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    public Image getImage() {
        switch (this.blockKind) {
            case CONSTRAINT: 
            case DYNAMIC_CONSTRAINT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.PSS_ACTIVITY);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        switch (this.blockKind) {
            case CONSTRAINT: 
            case DYNAMIC_CONSTRAINT: {
                return "DUPLICATE_CONSTRAINT: Duplicate constraint ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
        }
        return "DUPLICATE_ACTIVITY: Duplicate activity ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public void setBlockKind(BlockKind blockKind) {
        this.blockKind = blockKind;
    }

    public BlockKind getBlockKind() {
        return this.blockKind;
    }

    protected void setBlockInfo(BlockInfo blockInfo) {
        this.blockInfo = blockInfo;
    }

    public BlockInfo getBlockInfo() {
        return this.blockInfo;
    }

    public void setBlockArray(boolean isBlockArray) {
        this.isBlockArray = isBlockArray;
    }

    public boolean isBlockArray() {
        return this.isBlockArray;
    }

    public boolean isActionHandle() {
        return this.constraintScope instanceof RfStruct && ((RfStruct)this.constraintScope).isAction(false);
    }

    public boolean isConstraint() {
        return this.blockKind == BlockKind.CONSTRAINT || this.blockKind == BlockKind.DYNAMIC_CONSTRAINT;
    }

    public boolean isDynamicConstraint() {
        return this.blockKind == BlockKind.DYNAMIC_CONSTRAINT;
    }
}

