/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfStruct;

public abstract class RfClassType
extends RfMembersContainer
implements IRfClassType {
    public static final RfStruct CIRCULAR_INHERITANCE = new RfStruct("[CIRCULAR INHERITANCE]"){

        @Override
        public void addChild(IRfClassType child) {
        }
    };
    private IRfClassType parent;
    private Set<IRfClassType> children;

    public RfClassType(String name) {
        super(name);
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
        if (this.hasNoDefs(false) && this.parent != null) {
            Collection<IRfClassType> parentChildren = this.parent.getChildren();
            if (parentChildren != null) {
                parentChildren.remove(this);
            }
            this.parent = null;
        }
    }

    @Override
    public void setParent(IRfClassType parent) {
        if (parent == null) {
            return;
        }
        this.parent = parent;
        IRfClassType grandParent = parent;
        do {
            if (grandParent != this) continue;
            this.parent = CIRCULAR_INHERITANCE;
            return;
        } while ((grandParent = grandParent.getParent()) != null);
        this.parent.addChild(this);
    }

    @Override
    public void addChild(IRfClassType child) {
        if (this.children == null) {
            this.children = new HashSet<IRfClassType>();
        }
        this.children.add(child);
    }

    @Override
    public IRfClassType getParent() {
        return this.parent;
    }

    @Override
    public boolean isPacked() {
        if (this.isAddrRegPkgMember() && "packed_s".equals(this.getName())) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.isPacked();
    }

    @Override
    public List<IRfClassType> getParentInterfaces() {
        return null;
    }

    @Override
    public Collection<IRfClassType> getChildren() {
        return this.children;
    }

    @Override
    public boolean isInterfaceClass() {
        return false;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.parent != null) {
            Collection<IRfClassType> parentChildren = this.parent.getChildren();
            if (parentChildren != null) {
                parentChildren.remove(this);
            }
            this.parent = null;
        }
        this.children = null;
    }

    @Override
    public boolean isLike(IRfClassType likeClassType) {
        if (this.parent == null || likeClassType == null) {
            return false;
        }
        if (this.parent == likeClassType) {
            return true;
        }
        return this.parent.isLike(likeClassType);
    }
}

