/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.IRfType;
import ro.amiq.pssdt.model.reflection.RfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedMethod;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public class RfCollectionType
extends RfMembersContainer
implements IRfType,
IRfAssociatedType {
    private IRfType keyElementType;
    private IRfType valueElementType;
    private DataType associatedDataType;
    private DataType.CollectionKind collectionKind;
    private RfField sizeField;
    private RfField sumField;

    public static RfCollectionType createInitCollection(RfProject project, DataType dataType, DataType.CollectionKind collectionKind) {
        switch (collectionKind) {
            case ARRAY: 
            case ARRAY_INIT: {
                collectionKind = DataType.CollectionKind.ARRAY_INIT;
                break;
            }
            case LIST: {
                collectionKind = DataType.CollectionKind.ARRAY_INIT;
                break;
            }
            case SET: 
            case SET_INIT: {
                collectionKind = DataType.CollectionKind.SET_INIT;
                break;
            }
            case MAP: 
            case MAP_INIT: {
                collectionKind = DataType.CollectionKind.MAP_INIT;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        RfCollectionType containerType = new RfCollectionType(project, collectionKind, dataType);
        return containerType;
    }

    public static RfCollectionType createArray(RfProject project, RfNamedElement valueElementType, DataType dataType) {
        return RfCollectionType.createVector(project, DataType.CollectionKind.ARRAY, valueElementType, dataType);
    }

    public static RfCollectionType createList(RfProject project, RfNamedElement valueElementType, DataType dataType) {
        return RfCollectionType.createVector(project, DataType.CollectionKind.LIST, valueElementType, dataType);
    }

    private static RfCollectionType createVector(RfProject project, DataType.CollectionKind collectionKind, RfNamedElement valueElementType, DataType dataType) {
        RfCollectionType containerType = new RfCollectionType(project, collectionKind, dataType);
        containerType.setAssociatedType(project, null, valueElementType);
        return containerType;
    }

    private void createListMethods(RfProject project, DataType.CollectionKind collectionKind, RfNamedElement valueElementType) {
        RfPredefinedMethod method;
        RfPredefinedField argument;
        RfPredefinedMethod method2;
        DataType dataType = this.getDataType();
        RfPredefinedType boolType = project.getPredefinedType("bool");
        RfPredefinedType intType = project.getPredefinedType("int");
        RfPredefinedType floatType = project.getPredefinedType("float64");
        String vectorName = collectionKind.toString().toLowerCase();
        if (collectionKind == DataType.CollectionKind.ARRAY && valueElementType.isNumericType()) {
            boolean isFloatType = valueElementType.isFloatType();
            RfPredefinedField field = new RfPredefinedField("sum", isFloatType ? DataType.FLOAT64 : DataType.INT, "The sum property shall return the sum of all elements in the array");
            field.setFieldModifier(FieldModifier.RAND);
            field.setAssociatedType(isFloatType ? floatType : intType);
            field.setEnclosingScope(this);
            this.sumField = field;
        }
        RfPredefinedField field = new RfPredefinedField("size", DataType.INT, "The size property shall return the number of elements in the array");
        field.setFieldModifier(FieldModifier.RAND);
        field.setAssociatedType(intType);
        field.setEnclosingScope(this);
        this.sizeField = field;
        if (collectionKind == DataType.CollectionKind.LIST) {
            method2 = new RfPredefinedMethod("clear", DataType.BOOL, true, "Removes all elements from the list");
            method2.setAssociatedType(boolType);
            this.addMember("main", false, method2);
        }
        if (collectionKind == DataType.CollectionKind.LIST) {
            method2 = new RfPredefinedMethod("delete", dataType.getValueDataType(), true, "Removes an element at the specified index and returns the element value. If the index is out-of-bounds, the tool shall report an error");
            this.addMember("main", false, method2);
            argument = new RfPredefinedField("index", DataType.INT, "");
            argument.setFieldModifier(FieldModifier.METHOD_PARAM);
            argument.setAssociatedType(intType);
            method2.addMember("main", false, argument);
            method2.setAssociatedType(valueElementType);
        }
        if (collectionKind == DataType.CollectionKind.LIST) {
            method2 = new RfPredefinedMethod("insert", DataType.BOOL, true, "Inserts an element to the list at the specified index. If the index is equal to the size of the list, insert is equivalent to push_back(). If the index is less than the size of the list, then elements at and beyond the index are moved. If the index is greater than the size of the list, the insert operation has no effect");
            method2.setAssociatedType(boolType);
            this.addMember("main", false, method2);
            argument = new RfPredefinedField("index", DataType.INT, "");
            argument.setFieldModifier(FieldModifier.METHOD_PARAM);
            argument.setAssociatedType(intType);
            method2.addMember("main", false, argument);
            argument = new RfPredefinedField("value", dataType.getValueDataType(), "");
            argument.setFieldModifier(FieldModifier.METHOD_PARAM);
            method2.addMember("main", false, argument);
            argument.setAssociatedType(valueElementType);
        }
        if (collectionKind == DataType.CollectionKind.LIST) {
            method2 = new RfPredefinedMethod("pop_front", dataType.getValueDataType(), true, "Removes the first element of the list. This is equivalent to delete(0)");
            this.addMember("main", false, method2);
            method2.setAssociatedType(valueElementType);
        }
        if (collectionKind == DataType.CollectionKind.LIST) {
            method2 = new RfPredefinedMethod("push_front", DataType.BOOL, true, "Inserts an element at the beginning of the list. This is equivalent to insert(0, value)");
            method2.setAssociatedType(boolType);
            this.addMember("main", false, method2);
            argument = new RfPredefinedField("value", dataType.getValueDataType(), "");
            argument.setFieldModifier(FieldModifier.METHOD_PARAM);
            method2.addMember("main", false, argument);
            argument.setAssociatedType(valueElementType);
        }
        if (collectionKind == DataType.CollectionKind.LIST) {
            method2 = new RfPredefinedMethod("pop_back", dataType.getValueDataType(), true, "Removes an element at the end of the list. This is equivalent to delete(size() - 1)");
            this.addMember("main", false, method2);
            method2.setAssociatedType(valueElementType);
        }
        if (collectionKind == DataType.CollectionKind.LIST) {
            method2 = new RfPredefinedMethod("push_back", DataType.BOOL, true, "Appends an element to the end of the list. This is equivalent to insert(size(), value)");
            method2.setAssociatedType(boolType);
            this.addMember("main", false, method2);
            argument = new RfPredefinedField("value", dataType.getValueDataType(), "");
            argument.setFieldModifier(FieldModifier.METHOD_PARAM);
            method2.addMember("main", false, argument);
            argument.setAssociatedType(valueElementType);
        }
        method2 = new RfPredefinedMethod("set", DataType.BOOL, true, "Sets the value of a specific " + vectorName + " element. If index is out-of-bounds, the tool shall report an error");
        method2.setAssociatedType(boolType);
        this.addMember("main", false, method2);
        argument = new RfPredefinedField("index", DataType.INT, "");
        argument.setFieldModifier(FieldModifier.METHOD_PARAM);
        argument.setAssociatedType(intType);
        method2.addMember("main", false, argument);
        argument = new RfPredefinedField("value", dataType.getValueDataType(), "");
        argument.setFieldModifier(FieldModifier.METHOD_PARAM);
        method2.addMember("main", false, argument);
        argument.setAssociatedType(valueElementType);
        if (collectionKind == DataType.CollectionKind.ARRAY && valueElementType.isNumericType()) {
            boolean isFloatType = valueElementType.isFloatType();
            RfPredefinedMethod method3 = new RfPredefinedMethod("sum", isFloatType ? DataType.FLOAT64 : DataType.INT, true, "The sum() function shall return the sum of all elements in the " + vectorName);
            method3.setAssociatedType(isFloatType ? floatType : intType);
            this.addMember("main", false, method3);
        }
        method = new RfPredefinedMethod("size", DataType.INT, true, "Returns the number of elements currently stored in the " + vectorName);
        method.setAssociatedType(intType);
        this.addMember("main", false, method);
        if (collectionKind == DataType.CollectionKind.ARRAY) {
            String listTypeName = dataType.getValueDataType() == null ? "" : dataType.getValueDataType().getTypeName();
            DataType listDataType = new DataType("list<" + listTypeName + ">");
            listDataType.setItemDataType(null, dataType.getValueDataType(), DataType.CollectionKind.LIST);
            method = new RfPredefinedMethod("to_list", listDataType, true, "Returns a list containing the elements of the " + vectorName);
            method.setAssociatedType(this);
            this.addMember("main", false, method);
        }
        String setTypeName = dataType.getValueDataType() == null ? "" : dataType.getValueDataType().getTypeName();
        DataType setDataType = new DataType("set<" + setTypeName + ">");
        setDataType.setItemDataType(dataType.getValueDataType(), null, DataType.CollectionKind.SET);
        method = new RfPredefinedMethod("to_set", setDataType, true, "Returns a set containing the unique elements of the " + vectorName);
        method.setAssociatedType(new RfAssociatedType.RfLazyCollectionType((RfNamedElement)((Object)this.getValueElementType())));
        this.addMember("main", false, method);
        if (collectionKind == DataType.CollectionKind.LIST) {
            method = new RfPredefinedMethod("shuffle", DataType.VOID, true, "Randomly reorders the elements of the " + vectorName);
            method.setAssociatedType(new RfAssociatedType.RfLazyCollectionType((RfNamedElement)((Object)this.getValueElementType())));
            this.addMember("main", false, method);
        }
    }

    public static RfCollectionType createSet(RfProject project, RfNamedElement keyElementType, DataType dataType) {
        RfCollectionType containerType = new RfCollectionType(project, DataType.CollectionKind.SET, dataType);
        containerType.setAssociatedType(project, keyElementType, null);
        return containerType;
    }

    public static RfCollectionType createMap(RfProject project, RfNamedElement keyElementType, RfNamedElement valueElementType, DataType dataType) {
        RfCollectionType containerType = new RfCollectionType(project, DataType.CollectionKind.MAP, dataType);
        containerType.setAssociatedType(project, keyElementType, valueElementType);
        return containerType;
    }

    private void createMapMethods(RfProject project, RfNamedElement keyElementType, RfNamedElement valueElementType) {
        DataType dataType = this.getDataType();
        RfPredefinedType boolType = project.getPredefinedType("bool");
        RfPredefinedType intType = project.getPredefinedType("int");
        RfPredefinedMethod method = new RfPredefinedMethod("clear", DataType.BOOL, true, "Removes all elements from the map");
        method.setAssociatedType(boolType);
        this.addMember("main", false, method);
        method = new RfPredefinedMethod("delete", dataType.getValueDataType(), true, "Removes an element at the specified key and returns the element value");
        this.addMember("main", false, method);
        RfPredefinedField argument = new RfPredefinedField("key", dataType.getKeyDataType(), "");
        argument.setFieldModifier(FieldModifier.METHOD_PARAM);
        method.addMember("main", false, argument);
        argument.setAssociatedType(keyElementType);
        method.setAssociatedType(valueElementType);
        method = new RfPredefinedMethod("insert", DataType.BOOL, true, "Inserts the specified key/value pair in the map. If the key currently exists in the map, the current value is replaced with the new value.");
        method.setAssociatedType(boolType);
        this.addMember("main", false, method);
        RfPredefinedField argument1 = new RfPredefinedField("key", DataType.INT, "");
        argument1.setFieldModifier(FieldModifier.METHOD_PARAM);
        method.addMember("main", false, argument1);
        RfPredefinedField argument2 = new RfPredefinedField("value", dataType.getValueDataType(), "");
        argument2.setFieldModifier(FieldModifier.METHOD_PARAM);
        method.addMember("main", false, argument2);
        argument1.setAssociatedType(keyElementType);
        argument2.setAssociatedType(valueElementType);
        method = new RfPredefinedMethod("exists", DataType.BOOL, true, "Checks if the specified key exists in the map");
        method.setAssociatedType(boolType);
        this.addMember("main", false, method);
        argument = new RfPredefinedField("key", DataType.INT, "");
        argument.setFieldModifier(FieldModifier.METHOD_PARAM);
        method.addMember("main", false, argument);
        argument.setAssociatedType(keyElementType);
        method = new RfPredefinedMethod("size", DataType.INT, true, "Returns the number of elements currently stored in the map");
        method.setAssociatedType(intType);
        this.addMember("main", false, method);
        String valueTypeName = dataType.getValueDataType() == null ? "" : dataType.getValueDataType().getTypeName();
        DataType valuesDataType = new DataType("list<" + valueTypeName + ">");
        valuesDataType.setItemDataType(null, dataType.getValueDataType(), DataType.CollectionKind.LIST);
        RfPredefinedMethod method2 = new RfPredefinedMethod("values", valuesDataType, true, "Returns a list containing the values in the map");
        method2.setAssociatedType(RfCollectionType.createList(project, valueElementType, valuesDataType));
        this.addMember("main", false, method2);
        String keyTypeName = dataType.getKeyDataType() == null ? "" : dataType.getKeyDataType().getTypeName();
        DataType keysDataType = new DataType("set<" + keyTypeName + ">");
        keysDataType.setItemDataType(dataType.getKeyDataType(), null, DataType.CollectionKind.SET);
        method2 = new RfPredefinedMethod("keys", keysDataType, true, "Returns a set container with the map keys");
        method2.setAssociatedType(RfCollectionType.createSet(project, keyElementType, keysDataType));
        this.addMember("main", false, method2);
    }

    private void createSetMethods(RfProject project, RfNamedElement keyElementType) {
        DataType dataType = this.getDataType();
        RfPredefinedType boolType = project.getPredefinedType("bool");
        RfPredefinedType intType = project.getPredefinedType("int");
        RfPredefinedMethod method = new RfPredefinedMethod("clear", DataType.BOOL, true, "Removes all elements from the set");
        method.setAssociatedType(boolType);
        this.addMember("main", false, method);
        method = new RfPredefinedMethod("delete", DataType.VOID, true, "Removes the specified key from the set");
        this.addMember("main", false, method);
        RfPredefinedField argument = new RfPredefinedField("key", dataType.getKeyDataType(), "");
        argument.setFieldModifier(FieldModifier.METHOD_PARAM);
        method.addMember("main", false, argument);
        argument.setAssociatedType(keyElementType);
        method = new RfPredefinedMethod("insert", DataType.BOOL, true, "Inserts the specified key in the set. If the key currently exists in the set container, \u2018false\u2019 is returned and the call has no effect. If the key does not currently exist, then \u2018true\u2019 is returned");
        method.setAssociatedType(boolType);
        this.addMember("main", false, method);
        argument = new RfPredefinedField("key", dataType.getKeyDataType(), "");
        argument.setFieldModifier(FieldModifier.METHOD_PARAM);
        method.addMember("main", false, argument);
        argument.setAssociatedType(keyElementType);
        method = new RfPredefinedMethod("exists", DataType.BOOL, true, "Checks if the specified key exists in the set");
        method.setAssociatedType(boolType);
        this.addMember("main", false, method);
        argument = new RfPredefinedField("key", dataType.getKeyDataType(), "");
        argument.setFieldModifier(FieldModifier.METHOD_PARAM);
        method.addMember("main", false, argument);
        argument.setAssociatedType(keyElementType);
        String listTypeName = dataType.getKeyDataType() == null ? "" : dataType.getKeyDataType().getTypeName();
        DataType listDataType = new DataType("list<" + listTypeName + ">");
        listDataType.setItemDataType(null, dataType.getKeyDataType(), DataType.CollectionKind.LIST);
        RfPredefinedMethod method2 = new RfPredefinedMethod("to_list", listDataType, true, "Returns a list containing the elements of the collection");
        method2.setAssociatedType(new RfAssociatedType.RfLazyCollectionType((RfNamedElement)((Object)this.getKeyElementType())));
        this.addMember("main", false, method2);
        method = new RfPredefinedMethod("size", DataType.INT, true, "Returns the number of elements currently stored in the set");
        method.setAssociatedType(intType);
        this.addMember("main", false, method);
    }

    private RfCollectionType(RfProject project, DataType.CollectionKind collectionKind, DataType dataType) {
        super(dataType.getTypeName());
        this.associatedDataType = dataType;
        this.collectionKind = collectionKind;
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter elementFilter) {
        if (this.collectionKind == DataType.CollectionKind.ARRAY || this.collectionKind == DataType.CollectionKind.LIST) {
            if ((classes == null || classes.contains(RfField.class)) && "size".equals(name)) {
                return this.sizeField;
            }
            if ((classes == null || classes.contains(RfField.class)) && "sum".equals(name)) {
                return this.sumField;
            }
        }
        return super.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
    }

    @Override
    public List<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        List<RfNamedElement> localMembers = super.getLocalMembers(determinant, classes);
        if (!classes.contains(RfField.class)) {
            return localMembers;
        }
        if (this.sizeField == null && this.sumField == null) {
            return localMembers;
        }
        if (localMembers == null) {
            localMembers = Collections.emptyList();
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>(localMembers.size() + 2);
        result.addAll(localMembers);
        if (this.sizeField != null) {
            result.add(this.sizeField);
        }
        if (this.sumField != null) {
            result.add(this.sumField);
        }
        return result;
    }

    public Image getImage() {
        return null;
    }

    public String getSignature() {
        return "";
    }

    @Override
    public String getContextType() {
        return "";
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return null;
    }

    public String getAssociatedTypeName() {
        return this.associatedDataType.getTypeName();
    }

    public RfNamedElement getAssociatedType() {
        switch (this.collectionKind) {
            case ARRAY: 
            case ARRAY_INIT: {
                return (RfNamedElement)((Object)this.valueElementType);
            }
            case LIST: {
                return (RfNamedElement)((Object)this.valueElementType);
            }
            case SET: 
            case SET_INIT: {
                return (RfNamedElement)((Object)this.keyElementType);
            }
            case MAP: 
            case MAP_INIT: {
                return (RfNamedElement)((Object)this.valueElementType);
            }
        }
        throw new UnsupportedOperationException();
    }

    public RfNamedElement getAssociatedBaseType() {
        switch (this.collectionKind) {
            case ARRAY: 
            case ARRAY_INIT: {
                return (RfNamedElement)((Object)this.valueElementType);
            }
            case LIST: {
                return (RfNamedElement)((Object)this.valueElementType);
            }
            case SET: 
            case SET_INIT: {
                return (RfNamedElement)((Object)this.keyElementType);
            }
            case MAP: 
            case MAP_INIT: {
                return (RfNamedElement)((Object)this.valueElementType);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        return this.associatedDataType;
    }

    @Override
    public String getAssociatedTypeArrayDim() {
        if (this.associatedDataType == null || this.associatedDataType.getArrayDim() == null) {
            return "";
        }
        return this.associatedDataType.getArrayDim();
    }

    @Override
    public boolean getAssociatedTypeArray() {
        return true;
    }

    public int getAssociatedTypeArrayDimAsInteger() {
        if (this.associatedDataType == null || this.associatedDataType.getArrayDim() == null) {
            return -1;
        }
        return this.associatedDataType.getArrayDimAsInteger();
    }

    public void setAssociatedType(RfNamedElement associatedType) {
        throw new UnsupportedOperationException();
    }

    public DataType.CollectionKind getCollectionKind() {
        return this.collectionKind;
    }

    @Override
    public boolean isStructType() {
        return this.valueElementType instanceof RfStruct;
    }

    @Override
    public boolean isComponentType() {
        return this.valueElementType instanceof RfStruct && ((RfStruct)this.valueElementType).isComponent();
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public void collectMembersForElab(Map<String, RfNamedElement> result, Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, boolean collectPredefinedAndActionQualifiedFields, IRfElementFilter elementFilter) {
        super.collectMembersForElab(result, determinant, classes, collectPredefinedAndActionQualifiedFields, elementFilter);
        if (this.sizeField != null) {
            result.put("size", this.sizeField);
        }
        if (this.sumField != null) {
            result.put("sum", this.sumField);
        }
    }

    public void setAssociatedType(RfProject project, RfNamedElement keyElementType, RfNamedElement valueElementType) {
        if (keyElementType instanceof RfTemplateParam.RfInstanceTypeParam) {
            this.associatedDataType = ((RfTemplateParam.RfInstanceTypeParam)keyElementType).getDataType();
            this.keyElementType = (IRfType)((Object)((RfTemplateParam.RfInstanceTypeParam)keyElementType).getAssociatedType());
        } else {
            this.keyElementType = (IRfType)((Object)keyElementType);
        }
        if (valueElementType instanceof RfTemplateParam.RfInstanceTypeParam) {
            this.associatedDataType = ((RfTemplateParam.RfInstanceTypeParam)valueElementType).getDataType();
            this.valueElementType = (IRfType)((Object)((RfTemplateParam.RfInstanceTypeParam)valueElementType).getAssociatedType());
        } else {
            this.valueElementType = (IRfType)((Object)valueElementType);
        }
        if (this.collectionKind == DataType.CollectionKind.ARRAY && valueElementType == null) {
            return;
        }
        if (this.collectionKind == DataType.CollectionKind.LIST && valueElementType == null) {
            return;
        }
        if (this.collectionKind == DataType.CollectionKind.SET && keyElementType == null) {
            return;
        }
        if (this.collectionKind == DataType.CollectionKind.MAP && (keyElementType == null || valueElementType == null)) {
            return;
        }
        if (this.members != null) {
            this.members.clear();
        }
        if (this.collectionKind == DataType.CollectionKind.LIST || this.collectionKind == DataType.CollectionKind.ARRAY) {
            this.createListMethods(project, this.collectionKind, valueElementType);
        }
        if (this.collectionKind == DataType.CollectionKind.MAP) {
            this.createMapMethods(project, keyElementType, valueElementType);
        }
        if (this.collectionKind == DataType.CollectionKind.SET) {
            this.createSetMethods(project, keyElementType);
        }
    }

    public IRfType getValueElementType() {
        return this.valueElementType;
    }

    public IRfType getKeyElementType() {
        return this.keyElementType;
    }

    public boolean isInitCollection() {
        return this.collectionKind == DataType.CollectionKind.ARRAY_INIT || this.collectionKind == DataType.CollectionKind.MAP_INIT || this.collectionKind == DataType.CollectionKind.SET_INIT;
    }

    public int getCollectionSize() {
        return this.associatedDataType.getArrayDimAsInteger();
    }

    public boolean isVectorType() {
        return this.collectionKind == DataType.CollectionKind.ARRAY || this.collectionKind == DataType.CollectionKind.ARRAY_INIT || this.collectionKind == DataType.CollectionKind.LIST;
    }

    public boolean isMapType() {
        return this.collectionKind == DataType.CollectionKind.MAP || this.collectionKind == DataType.CollectionKind.MAP_INIT;
    }

    public boolean isSetType() {
        return this.collectionKind == DataType.CollectionKind.SET || this.collectionKind == DataType.CollectionKind.SET_INIT;
    }

    @Override
    public int sizeof() {
        if (this.collectionKind != DataType.CollectionKind.ARRAY_INIT && this.collectionKind != DataType.CollectionKind.ARRAY) {
            throw new UnsupportedOperationException();
        }
        DataType dataType = this.getDataType();
        RfField dummyField = this.getItemField();
        return dataType.getArrayDimAsInteger() * SemanticUtils.nofBits(dummyField);
    }

    public RfField getItemField() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            throw new UnsupportedOperationException();
        }
        RfField dummyField = new RfField("[dummy item field]", this.isSetType() ? dataType.getKeyDataType() : dataType.getValueDataType());
        dummyField.setAssociatedType((RfNamedElement)((Object)(this.isSetType() ? this.keyElementType : this.valueElementType)));
        return dummyField;
    }
}

