/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public class RfCovergroup
extends RfMembersContainer {
    private boolean isInline;

    public RfCovergroup(String name) {
        super(name);
    }

    public String getSignature() {
        return "covergroup " + this.getName();
    }

    @Override
    public String getKindName() {
        return "covergroup";
    }

    public void setInline(boolean isInline) {
        this.isInline = isInline;
    }

    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVERGROUP);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_COVERGROUP: Duplicate cover group ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public Map<String, RfNamedElement> getPorts() {
        LinkedHashMap<String, RfNamedElement> result = new LinkedHashMap<String, RfNamedElement>();
        if (this.members != null && !this.members.isEmpty()) {
            for (RfNamedElement member : this.members) {
                FieldModifier fieldModifier;
                if (!(member instanceof RfField) || (fieldModifier = ((RfField)member).getFieldModifier()) != FieldModifier.COVERGROUP_PORT) continue;
                result.put(member.getName(), member);
            }
        }
        return result;
    }

    public static RfField getOption(RfProject project, String name) {
        List<RfField> result = RfCovergroup.getOptionsWithPrefix(project, name, 1);
        return result.isEmpty() ? null : result.get(0);
    }

    public static List<RfField> getOptionsWithPrefix(RfProject project, String prefix, int matchType) {
        ArrayList<RfField> result = new ArrayList<RfField>();
        RfPredefinedField field = null;
        if (DVTStringUtil.regionMatches((String)"weight", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("weight", new DataType("int").setInitialValue("1", null, BitVectorInt.ONE), "If set at the covergroup syntactic level, it specifies the weight of this covergroup instance for computing the over-all instance coverage. If set at the coverpoint (or cross) syntactic level, it specifies the weight of a coverpoint (or cross)for computing the instance coverage of the enclosing cover-group. The specified weight shall be a non-negative integral value.");
            field.setAssociatedType(project.getPredefinedType("int"));
            result.add(field);
        }
        if (matchType == 1 && !result.isEmpty()) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"goal", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("goal", new DataType("int").setInitialValue("100", null, BitVectorInt.from(true, 100)), "Specifies the target goal for a covergroup instance or for a coverpoint or cross.");
            field.setAssociatedType(project.getPredefinedType("int"));
            result.add(field);
        }
        if (matchType == 1 && !result.isEmpty()) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"name", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("name", new DataType("string").setInitialValue("unique value", null, null), "Specifies a name for the covergroup instance. If unspecified, a unique name for each instance is automatically generated by the tool.");
            field.setAssociatedType(project.getPredefinedType("string"));
            result.add(field);
        }
        if (matchType == 1 && !result.isEmpty()) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"comment", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("comment", new DataType("string").setInitialValue("\"\"", null, null), "A comment that appears with the covergroup instance or with a coverpoint or cross of a covergroup instance. The comment is saved in the coverage database and included in the coverage report.");
            field.setAssociatedType(project.getPredefinedType("string"));
            result.add(field);
        }
        if (matchType == 1 && !result.isEmpty()) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"at_least", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("at_least", new DataType("int").setInitialValue("1", null, BitVectorInt.ONE), "Minimum number of hits for each bin. A bit with a hit count that is less than number is not considered covered.");
            field.setAssociatedType(project.getPredefinedType("int"));
            result.add(field);
        }
        if (matchType == 1 && !result.isEmpty()) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"detect_overlap", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("detect_overlap", new DataType("bool").set(1, 0, false).setInitialValue("false", null, BitVectorInt.FALSE), "When true, a warning is issued if there is an overlap between the  range list of two bins of a coverpoint.");
            field.setAssociatedType(project.getPredefinedType("bool"));
            result.add(field);
        }
        if (matchType == 1 && !result.isEmpty()) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"auto_bin_max", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("auto_bin_max", new DataType("int").set(31, 0, true).setInitialValue("64", null, BitVectorInt.from(true, 64)), "Maximum number of automatically created bins when no bins are explicitly defined for a coverpoint.");
            field.setAssociatedType(project.getPredefinedType("int"));
            result.add(field);
        }
        if (matchType == 1 && !result.isEmpty()) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"per_instance", (String)prefix, (int)matchType)) {
            field = new RfPredefinedField("per_instance", new DataType("bool").setInitialValue("false", null, BitVectorInt.FALSE), "Each instance contributes to the overall coverage information for the covergroup type. When true, coverage information for this covergroup instance shall be saved in the coverage database and included in the coverage report. When false, implementations are not required to save instance-specific information.");
            field.setAssociatedType(project.getPredefinedType("bool"));
            result.add(field);
        }
        return result;
    }
}

