/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.IFileDocumentListener;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfImportElement;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPackageAlias;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfScopeDefElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.utils.Utils;

public class RfDefElement
implements IFileDocumentListener,
IRfScope,
IRfDefElement,
Comparable<RfDefElement>,
IRfBreadcrumbElement {
    private LineInfo startLine;
    private LineInfo endLine;
    private RfFileDef fileDef;
    private CommentBlock comment;
    private RfNamedElement namedElement;
    private List<RfDefElement> childrenDefs;
    private Position position;
    private boolean isIsLayer;
    private RfDefElement parentDef;
    private String packageName;
    private String componentName;
    private AST nodeAST;

    public RfDefElement(RfFileDef fileDef, String packageName, String componentName, LineInfo startInfo, LineInfo endInfo, boolean isIsLayer, CommentBlock comment) {
        this.fileDef = fileDef;
        this.startLine = startInfo;
        this.endLine = endInfo;
        this.comment = comment;
        this.isIsLayer = isIsLayer;
        this.packageName = DVTStringUtil.intern((String)packageName);
        this.componentName = DVTStringUtil.intern((String)componentName);
    }

    public void setParentDef(RfDefElement parentDef) {
        this.parentDef = parentDef;
    }

    public void addNamedElement(RfNamedElement namedElem) {
        this.namedElement = namedElem;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void addPackageAlias(RfPackageAlias packageAlias) {
        throw new UnsupportedOperationException();
    }

    public RfPackageAlias getPackageAlias(String name) {
        throw new UnsupportedOperationException();
    }

    public RfDefElement getEnclosingStructDef() {
        RfDefElement parentDefElement = this.parentDef;
        while (parentDefElement != null) {
            if (parentDefElement.getNamedElement() instanceof RfStruct) {
                return parentDefElement;
            }
            parentDefElement = parentDefElement.parentDef;
        }
        return null;
    }

    public RfDefElement getParentLexicalScope() {
        return this.parentDef;
    }

    public boolean isIs() {
        return this.isIsLayer;
    }

    @Override
    public RfNamedElement getNamedElement() {
        return this.namedElement;
    }

    public RfNamedElement getLastNamedElement() {
        return this.getNamedElement();
    }

    public RfNamedElement getEnclosingScope() {
        return this.getNamedElement();
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getEnclosingScope(clazz);
    }

    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getEnclosingScope(classes);
    }

    public RfFileDef getDefFile() {
        return this.fileDef;
    }

    public ParserPath getParserPath() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getParserPath();
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getLanguageSyntax();
    }

    public LanguageKind getLanguageKind() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getLanguageKind();
    }

    public IResource getFileAdapter() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getFileAdapter();
    }

    public void setDefComment(CommentBlock comment) {
        this.comment = comment;
    }

    public String getDefComment() {
        return this.comment == null ? "" : this.comment.toString();
    }

    public String getRawDefComment() {
        return this.comment == null ? "" : this.comment.toRawString();
    }

    public CommentBlock getCommentBlock() {
        return this.comment;
    }

    @Override
    public boolean connectPositionToDocument(IDocument document, Map<Position, Position> cachedPositions, List<Position> reflectionPositions) {
        block6: {
            if (document != null) break block6;
            return false;
        }
        try {
            if (this.startLine.realOffset > 0 && this.endLine.realOffset >= this.startLine.realOffset && Utils.documentLength(document) >= this.endLine.realOffset) {
                DVTPosition position = new DVTPosition(this.startLine.realOffset, this.endLine.realOffset - this.startLine.realOffset + 1);
                Position existingPosition = cachedPositions.get(position);
                if (existingPosition == null) {
                    this.position = position;
                    reflectionPositions.add((Position)position);
                    cachedPositions.put((Position)position, (Position)position);
                } else {
                    this.position = existingPosition;
                }
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public void removePosition() {
        this.position = null;
    }

    public boolean containsOffset(int offset) {
        return offset == -1 || this.startLine.realOffset <= offset && (this.endLine.realOffset == -1 || offset <= this.endLine.realOffset);
    }

    public int getStartLine() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position)) >= 0) {
            this.startLine.realOffset = result;
            int lineFromOffset = Utils.convertPositionToLine(this.fileDef.getDocument(), this.startLine.realOffset);
            this.startLine.line = lineFromOffset < 0 ? this.startLine.line : lineFromOffset;
        }
        return this.startLine == null ? -1 : this.startLine.line;
    }

    public int getEndLine() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position) + Utils.positionLength(this.position) - 1) >= 0) {
            this.endLine.realOffset = result;
            int lineFromOffset = Utils.convertPositionToLine(this.fileDef.getDocument(), this.endLine.realOffset);
            this.endLine.line = lineFromOffset < 0 ? this.endLine.line : lineFromOffset;
        }
        return this.endLine == null ? -1 : this.endLine.line;
    }

    public int getStartOffset() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position)) >= 0) {
            this.startLine.realOffset = result;
            int lineFromOffset = Utils.convertPositionToLine(this.fileDef.getDocument(), this.startLine.realOffset);
            this.startLine.line = lineFromOffset < 0 ? this.startLine.line : lineFromOffset;
        }
        return this.startLine == null ? -1 : this.startLine.realOffset;
    }

    public LineInfo getStartInfo() {
        return this.startLine;
    }

    public LineInfo getEndInfo() {
        return this.endLine;
    }

    public int getEndOffset() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position) + Utils.positionLength(this.position) - 1) >= 0) {
            this.endLine.realOffset = result;
            int lineFromOffset = Utils.convertPositionToLine(this.fileDef.getDocument(), this.endLine.realOffset);
            this.endLine.line = lineFromOffset < 0 ? this.endLine.line : lineFromOffset;
        }
        return this.endLine == null ? -1 : this.endLine.realOffset;
    }

    public RfProject getRfProject() {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getRfProject();
    }

    public void addChild(RfDefElement child) {
        if (this.childrenDefs == null) {
            this.childrenDefs = new ArrayList<RfDefElement>();
        }
        this.childrenDefs.add(child);
        child.setParentDef(this);
    }

    public void removeChild(RfDefElement child) {
        if (this.childrenDefs == null) {
            return;
        }
        this.childrenDefs.remove(child);
    }

    public Collection<RfDefElement> getChildren() {
        return this.childrenDefs;
    }

    public String getName() {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getName();
    }

    protected void cleanChildren() {
        if (this.namedElement != null) {
            this.namedElement.removeLayer(this);
        }
        if (this.childrenDefs == null) {
            return;
        }
        for (RfDefElement elem : this.childrenDefs) {
            if (elem.childrenDefs == this.childrenDefs) continue;
            elem.cleanChildren();
        }
        this.childrenDefs.clear();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    public boolean isPredefined() {
        if (this.fileDef != null) {
            return this.fileDef.isPredefined();
        }
        return false;
    }

    public boolean isInsideOtherDef(RfDefElement otherDef) {
        if (this.fileDef == null || !this.fileDef.equals(otherDef.getDefFile())) {
            return false;
        }
        return this.startLine.realOffset >= otherDef.startLine.realOffset && this.endLine.realOffset <= otherDef.endLine.realOffset;
    }

    public RfDefElement getKey() {
        return this;
    }

    public void deepClean() {
        this.comment = null;
        if (this.childrenDefs != null && !this.childrenDefs.isEmpty()) {
            for (RfDefElement layer : this.childrenDefs) {
                RfNamedElement namedElement;
                if (layer.getChildren() == this.childrenDefs || (namedElement = layer.getNamedElement()) == null || namedElement == this.namedElement) continue;
                namedElement.deepClean();
            }
            this.childrenDefs.clear();
        }
        this.childrenDefs = null;
        this.namedElement = null;
        this.position = null;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getSignalWithPrefix(prefix, matchType);
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getSignalsWithPrefix(prefix, matchType);
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getInstanceWithPrefix(prefix, matchType);
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getDesignsWithPrefix(prefix, matchType);
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getDesignWithPrefix(prefix, matchType);
    }

    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getConfigurationWithPrefix(prefix, matchType);
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getTypesWithPrefix(prefix, matchType);
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getTypeWithPrefix(prefix, matchType);
    }

    public boolean visit(RfDefElementVisitorAdapter visitor) throws Exception {
        if (!visitor.visitEntering(this)) {
            return false;
        }
        if (this.childrenDefs != null) {
            for (RfDefElement def : this.childrenDefs) {
                if (def.visit(visitor)) continue;
                return false;
            }
        }
        return visitor.visitLeaving(this);
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        DVTLogger.INSTANCE.logError("Unused API");
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, Determinant determinant, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        if (this.namedElement == null) {
            return;
        }
        this.namedElement.getElementsWithPrefix(result, this, determinant, prefix, matchType, local, isFirst, accessModifier, elementFilter);
    }

    public IRfLibraryElement getEnclosingLibrary() {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getEnclosingLibrary();
    }

    public boolean isPredefinedDef() {
        return false;
    }

    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public int compareTo(RfDefElement candidate) {
        int index2;
        RfFileDef module1 = this.getDefFile();
        RfFileDef module2 = candidate.getDefFile();
        if (module1 != null && module1 == module2) {
            return this.getStartOffset() - candidate.getStartOffset();
        }
        int index1 = module1 == null ? 0 : module1.getIndex();
        int n = index2 = module2 == null ? 0 : module2.getIndex();
        if (index1 >= 0 && index2 >= 0) {
            return index1 - index2;
        }
        if (index2 < 0) {
            return -1;
        }
        return 1;
    }

    public boolean contains(RfDefElement declaration) {
        if (declaration == null) {
            return false;
        }
        if (declaration.getDefFile() != this.getDefFile()) {
            return false;
        }
        if (this.getStartOffset() > declaration.getStartOffset()) {
            return false;
        }
        return this.getEndOffset() >= declaration.getEndOffset();
    }

    public RfNamedElement getMember(Determinant determinant, String name, boolean isAmbiguousCheck, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getMember(this, determinant, name, isAmbiguousCheck, isFirst, classes, filter);
    }

    public void addImportedElement(RfImportElement importedElement) {
        throw new UnsupportedOperationException();
    }

    public void setMatchScope(RfNamedElement assocType) {
        if (this.namedElement instanceof RfBlock && assocType instanceof RfEnumType) {
            ((RfBlock)this.namedElement).setMatchScope(assocType);
        }
    }

    public Determinant computeDeterminantForContentAssist() {
        if (this.packageName == null && this.componentName == null) {
            return RfPackage.ANY_DETERMINANT;
        }
        if (this.packageName != null) {
            RfPackage enclosingPackage = (RfPackage)this.getMember(RfPackage.ANY_DETERMINANT, this.packageName, false, true, Collections.singleton(RfPackage.class), null);
            if (enclosingPackage == null) {
                return RfPackage.ANY_DETERMINANT;
            }
            return enclosingPackage.getDeterminant(this.getLexicalScope(RfScopeDefElement.class));
        }
        if (this.componentName != null) {
            RfStruct enclosingComponent = (RfStruct)this.getMember(RfPackage.ANY_DETERMINANT, this.componentName, false, true, Collections.singleton(RfStruct.class), null);
            if (enclosingComponent == null) {
                return RfPackage.ANY_DETERMINANT;
            }
            return enclosingComponent.getDeterminant(this.getLexicalScope(RfScopeDefElement.class));
        }
        return RfPackage.ANY_DETERMINANT;
    }

    public RfScopeDefElement getLexicalScope(Class<RfScopeDefElement> clazz) {
        if (clazz.isInstance(this)) {
            return (RfScopeDefElement)this;
        }
        return this.parentDef == null ? null : this.parentDef.getLexicalScope(clazz);
    }

    public void setNodeAST(AST nodeAST) {
        this.nodeAST = nodeAST;
    }

    public AST getNodeAST() {
        return this.nodeAST;
    }

    public boolean isNonScopeLayer() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.componentName == null ? 0 : this.componentName.hashCode());
        result = 31 * result + (this.parentDef == null ? 0 : this.parentDef.hashCode());
        result = 31 * result + (this.endLine == null ? 0 : this.endLine.hashCode());
        result = 31 * result + (this.fileDef == null ? 0 : this.fileDef.hashCode());
        result = 31 * result + (this.isIsLayer ? 1231 : 1237);
        result = 31 * result + (this.namedElement == null ? 0 : this.namedElement.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.startLine == null ? 0 : this.startLine.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfDefElement other = (RfDefElement)obj;
        if (this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName)) {
            return false;
        }
        if (this.parentDef == null ? other.parentDef != null : !this.parentDef.equals(other.parentDef)) {
            return false;
        }
        if (this.endLine == null ? other.endLine != null : !this.endLine.equals((Object)other.endLine)) {
            return false;
        }
        if (this.fileDef == null ? other.fileDef != null : !this.fileDef.equals(other.fileDef)) {
            return false;
        }
        if (this.isIsLayer != other.isIsLayer) {
            return false;
        }
        if (this.namedElement == null ? other.namedElement != null : !this.namedElement.equals(other.namedElement)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        return !(this.startLine == null ? other.startLine != null : !this.startLine.equals((Object)other.startLine));
    }

    public Determinant extendDeterminant(Determinant determinant) {
        return this.parentDef == null ? determinant : this.parentDef.extendDeterminant(determinant);
    }

    public List<RfImportElement> getImportedElements() {
        return this.parentDef == null ? null : this.parentDef.getImportedElements();
    }

    public static class RfForwardDefElement
    extends RfDefElement {
        public RfForwardDefElement(RfFileDef fileDef, String packageName, String componentName, LineInfo startInfo, LineInfo endInfo, boolean isIsLayer, CommentBlock comment) {
            super(fileDef, packageName, componentName, startInfo, endInfo, isIsLayer, comment);
        }
    }
}

