/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.collections.AST;
import java.math.BigInteger;
import java.util.Collection;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public class RfEnumItem
extends RfField {
    public RfEnumItem(String name, DataType dataType) {
        super(name, dataType);
    }

    @Override
    public String getSignature() {
        return "enum item " + this.getName() + " : " + this.getEnclosingScope().getName() + " = " + this.getInitialValue(false);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_ENUM: Duplicate enum item ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENUM_ITEM);
    }

    @Override
    public DataType getDataType() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope instanceof RfEnumType) {
            return ((RfEnumType)enclosingScope).getItemDataType();
        }
        return super.getDataType();
    }

    DataType getSuperDataType() {
        return super.getDataType();
    }

    @Override
    public String getInitialValue(boolean forceComputeEnumValue) {
        BitVectorInt initialValue = this.getInitialValue(-1);
        return initialValue == null ? "" : initialValue.toString();
    }

    public void setInitialValue(String initialValueText, AST initialValueAST, BitVectorInt initialValue) {
        DataType initValueHolder = super.getDataType();
        initValueHolder.setInitialValue(initialValueText, initialValueAST, initialValue);
    }

    @Override
    public BitVectorInt getInitialValue(int index) {
        String name = this.getName();
        if (super.getInitialValue(index) != null) {
            BitVectorInt result = super.getInitialValue(index);
            return result.setEnumItemName(name);
        }
        DataType dataType = this.getDataType();
        RfNamedElement enumType = this.getEnclosingScope();
        Collection<RfNamedElement> enumItems = enumType.getLocalMembers();
        if (enumItems.isEmpty()) {
            return BitVectorInt.from(true, -1);
        }
        int value = 0;
        for (RfNamedElement enumItem : enumItems) {
            BitVectorInt initialValueInt;
            if (!(enumItem instanceof RfEnumItem)) continue;
            DataType initValueHolder = ((RfEnumItem)enumItem).getSuperDataType();
            if (initValueHolder != null && (initialValueInt = initValueHolder.getInitialValue(-1)) != null) {
                value = initialValueInt.intValue();
            }
            if (enumItem == this) {
                return new BitVectorInt(dataType.hasSign(), dataType.nofBits() - 1, 0).setValue(BigInteger.valueOf(value)).setEnumItemName(name);
            }
            ++value;
        }
        return new BitVectorInt(dataType.hasSign(), dataType.nofBits() - 1, 0).setValue(BigInteger.valueOf(value)).setEnumItemName(name);
    }

    @Override
    public int sizeof() {
        DataType dataType = this.getDataType();
        return dataType.nofBits();
    }
}

