/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.IRfType;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public class RfEnumType
extends RfMembersContainer
implements IRfType {
    private RfNamedElement itemAssocType;
    private DataType itemDataType;

    public RfEnumType(String name) {
        super(name);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
    }

    public Image getExtendImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_EXTEND);
    }

    public String getSignature() {
        return "enum type " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_TYPE: Duplicate type ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public RfEnumItem getEnumItem(int enumItemValue, String beforeEnumItemName) {
        if (this.members == null || this.members.isEmpty()) {
            return null;
        }
        int value = 0;
        for (RfNamedElement enumItem : this.members) {
            BitVectorInt initialValueInt;
            if (!(enumItem instanceof RfEnumItem)) continue;
            if (enumItem.getName().equals(beforeEnumItemName)) {
                return null;
            }
            DataType initValueHolder = ((RfEnumItem)enumItem).getSuperDataType();
            if (initValueHolder != null && (initialValueInt = initValueHolder.getInitialValue(-1)) != null) {
                value = initialValueInt.intValue();
            }
            if (value == enumItemValue) {
                return (RfEnumItem)enumItem;
            }
            ++value;
        }
        return null;
    }

    public RfEnumItem[] getEnumItems() {
        if (this.members == null || this.members.isEmpty()) {
            return new RfEnumItem[0];
        }
        ArrayList<RfEnumItem> enumItems = new ArrayList<RfEnumItem>(this.members.size());
        for (RfNamedElement enumItem : this.members) {
            if (!(enumItem instanceof RfEnumItem)) continue;
            enumItems.add((RfEnumItem)enumItem);
        }
        return enumItems.toArray(new RfEnumItem[enumItems.size()]);
    }

    public BigInteger[] getEnumValues() {
        if (this.members == null || this.members.isEmpty()) {
            return new BigInteger[]{BigInteger.ZERO};
        }
        BigInteger value = BigInteger.ZERO;
        ArrayList<BigInteger> values = new ArrayList<BigInteger>(this.members.size());
        for (RfNamedElement enumItem : this.members) {
            BitVectorInt initialValueInt;
            if (!(enumItem instanceof RfEnumItem)) continue;
            DataType initValueHolder = ((RfEnumItem)enumItem).getSuperDataType();
            if (initValueHolder != null && (initialValueInt = initValueHolder.getInitialValue(-1)) != null) {
                value = initialValueInt.bigIntegerValue();
            }
            values.add(value);
            value = value.add(BigInteger.ONE);
        }
        return values.toArray(new BigInteger[values.size()]);
    }

    public boolean hasEnumItem(String enumItemName) {
        if (this.members == null || this.members.isEmpty()) {
            return false;
        }
        return this.members.containsKey((Object)enumItemName);
    }

    public int getItemsCount() {
        if (this.members == null || this.members.isEmpty()) {
            return 0;
        }
        return this.members.size();
    }

    @Override
    public boolean isNumericType() {
        return true;
    }

    public void setItemAssociatedType(RfNamedElement assocType) {
        this.itemAssocType = assocType;
    }

    public RfNamedElement getItemAssociatedType() {
        return this.itemAssocType;
    }

    public void setItemDataType(DataType dataType) {
        this.itemDataType = dataType;
    }

    public DataType getItemDataType() {
        return this.itemDataType;
    }
}

