/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.utils.DVTArrayList;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTListElement;
import ro.amiq.pssdt.model.reflection.AmbiguousAccessError;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.util.VisitedCheck;

public class RfExtendDuplicate
extends RfNamedElement {
    private DVTArrayList<RfNamedElement> listMembers;

    public RfExtendDuplicate(String name) {
        super(name);
    }

    public String getSignature() {
        return null;
    }

    @Override
    public Collection<RfNamedElement> internalGetRawLocalMembers() {
        return this.listMembers == null ? null : this.listMembers.values();
    }

    @Override
    public Collection<RfNamedElement> getLocalMembers() {
        return this.listMembers == null ? null : this.listMembers.values();
    }

    protected void removeMember(RfNamedElement element) {
        this.listMembers.remove((IDVTListElement)element);
    }

    @Override
    protected void addMember(String packageName, boolean isExtendLayer, RfNamedElement element) {
        if (this.listMembers == null) {
            this.listMembers = new DVTArrayList();
        }
        this.listMembers.add((IDVTListElement)element);
        element.setEnclosingScope(this);
    }

    public void getActivities(List<RfDefElement> activities) {
        if (this.listMembers == null || this.listMembers.isEmpty()) {
            return;
        }
        for (RfNamedElement member : this.listMembers) {
            Collection declarations;
            if (!(member instanceof RfExecBlock) || !((RfExecBlock)member).isActivity() || (declarations = member.getDeclarations()) == null) continue;
            activities.addAll(declarations);
        }
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter elementFilter) {
        if (this.listMembers == null || this.listMembers.isEmpty()) {
            return null;
        }
        RfNamedElement candidate = null;
        for (RfNamedElement member : this.listMembers.values()) {
            if (member == null || classes != null && !classes.contains(member.getClass()) || elementFilter != null && !elementFilter.validElement((IRfNamedElement)member) || determinant != null && !determinant.contains(member.getPackageName())) continue;
            if (!isAmbiguousCheck) {
                return member;
            }
            if (candidate != null) {
                return new AmbiguousAccessError(candidate, member);
            }
            candidate = member;
        }
        return candidate;
    }

    @Override
    public List<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        if (this.listMembers == null || this.listMembers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfNamedElement member : this.listMembers.values()) {
            if (member == null || classes != null && !classes.contains(member.getClass()) || determinant != null && !determinant.contains(member.getPackageName())) continue;
            result.add(member);
        }
        return result;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (this.listMembers == null || this.listMembers.isEmpty()) {
            return;
        }
        for (RfNamedElement member : this.listMembers.values()) {
            if (member == null || clazz != null && !clazz.isInstance(member) || !elementFilter.validElement((IRfNamedElement)member) || prefix != null && !prefix.isEmpty() && !DVTStringUtil.regionMatches((String)member.getName(), (String)prefix, (int)matchType)) continue;
            result.add(member);
            if (result.size() != elementFilter.resultMaxSize()) continue;
            throw new MaxSizeReachedException();
        }
    }

    @Override
    public void collectMembersForElab(Map<String, RfNamedElement> result, Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, boolean collectPredefined, IRfElementFilter elementFilter) {
        if (this.listMembers == null || this.listMembers.isEmpty()) {
            return;
        }
        for (RfNamedElement member : this.listMembers.values()) {
            if (member == null || classes != null && !classes.contains(member.getClass()) || determinant != null && !determinant.contains(member.getPackageName()) || result.containsKey(member.getName())) continue;
            result.put(member.getName(), member);
        }
    }

    @Override
    protected void internalGetMember(Set<RfNamedElement> result, RfDefElement lexicalScope, Determinant determinant, VisitedCheck visited, String name, boolean isAmbiguousCheck, boolean isTransitiveImport, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return;
        }
        enclosingScope.internalGetMember(result, lexicalScope, determinant, visited, name, isAmbiguousCheck, isTransitiveImport, isFirst, classes, filter);
    }

    @Override
    public boolean hasLocalMembers() {
        return this.listMembers != null && !this.listMembers.isEmpty();
    }

    public Image getImage() {
        return null;
    }

    @Override
    public String getContextType() {
        return null;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return null;
    }
}

