/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.model.reflection.AccessKind;
import ro.amiq.pssdt.model.reflection.BlockKind;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumType;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public class RfField
extends RfAssociatedType
implements IRfFieldElement {
    public static final RfField ANY_FIELD = new RfField("[*]", null);
    private FieldModifier fieldModifier = FieldModifier.NONE;
    private AccessKind accessKind = AccessKind.PUBLIC;
    private boolean isRuntime;

    public RfField(String name, DataType dataType) {
        super(name, dataType);
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        super.performAdditionalSemanticChecks(project, currentLayer);
        if (currentLayer != null && currentLayer.isIs()) {
            RfNamedElement associateType;
            ParserPath parserPath;
            int startLine;
            int endOffset;
            int startOffset;
            RfNamedElement enclosingScope = this.getEnclosingScope();
            String name = this.getName();
            String enclosingName = enclosingScope.getName();
            if (enclosingScope instanceof RfStruct && ((RfStruct)enclosingScope).hasQualifier(1)) {
                boolean isAllowedUserRequestedFields;
                int startOffset2 = currentLayer.getStartOffset();
                int endOffset2 = startOffset2 + name.length();
                int startLine2 = currentLayer.getStartLine();
                ParserPath parserPath2 = currentLayer.getParserPath();
                RfNamedElement associateType2 = SemanticUtils.unwrap(this.getAssociatedType(), true, true);
                if (associateType2 instanceof RfCollectionType) {
                    associateType2 = ((RfCollectionType)associateType2).getAssociatedType();
                }
                if (associateType2 == null || associateType2 instanceof RfStruct && ((RfStruct)associateType2).hasQualifier(1)) {
                    return;
                }
                String fieldKind = null;
                switch (this.fieldModifier) {
                    case INPUT: 
                    case OUTPUT: 
                    case LOCK: 
                    case SHARE: 
                    case ACTION: 
                    case POOL: {
                        fieldKind = this.fieldModifier.toString().toLowerCase();
                        break;
                    }
                    default: {
                        fieldKind = associateType2 instanceof RfStruct && ((RfStruct)associateType2).isComponent() ? "non-pure component type instance" : "non-static attribute";
                    }
                }
                RfNamedElement enclosingBaseStruct = enclosingScope;
                if (enclosingBaseStruct instanceof RfTemplateInstance) {
                    enclosingBaseStruct = ((RfTemplateInstance)enclosingScope).getTemplateStruct();
                }
                boolean bl = isAllowedUserRequestedFields = enclosingBaseStruct instanceof RfTemplateStruct && "reg_c".equals(enclosingBaseStruct.getName()) && ("offset".equals(name) || "reset_mask".equals(name) || "reset_val".equals(name) || "access".equals(name));
                if (!(isAllowedUserRequestedFields || this.isInternal() || this.isStatic())) {
                    project.addSemanticError(1, "ILLEGAL_DECLARATION: ''{0}'' {1} is not allowed under ''{2}'' {3} type", null, startOffset2, endOffset2, null, startLine2, parserPath2, name, fieldKind, enclosingName, "pure component");
                }
                return;
            }
            boolean isIteratorVariable = this instanceof RfIteratorField;
            boolean isIndexVariable = this instanceof RfIndexField;
            if (!(isIteratorVariable || isIndexVariable || enclosingScope.isComponent() || this.isRef())) {
                startOffset = currentLayer.getStartOffset();
                endOffset = startOffset + name.length();
                startLine = currentLayer.getStartLine();
                parserPath = currentLayer.getParserPath();
                associateType = SemanticUtils.unwrap(this.getAssociatedType(), true, true);
                if (associateType instanceof RfCollectionType) {
                    associateType = ((RfCollectionType)associateType).getAssociatedType();
                }
                if (associateType instanceof RfStruct && ((RfStruct)associateType).isComponent()) {
                    project.addSemanticError(1, "ILLEGAL_DECLARATION: ''{0}'' {1} is not allowed under ''{2}'' {3} type", null, startOffset, endOffset, null, startLine, parserPath, name, "component instance", enclosingName, enclosingScope.getKindName());
                }
            }
            if (!(isIteratorVariable || isIndexVariable || enclosingScope.isAction(true) || this.isRef())) {
                startOffset = currentLayer.getStartOffset();
                endOffset = startOffset + name.length();
                startLine = currentLayer.getStartLine();
                parserPath = currentLayer.getParserPath();
                if (enclosingScope instanceof RfStruct || enclosingScope instanceof RfBlock && ((RfBlock)enclosingScope).getBlockKind() != BlockKind.ACTIVITY) {
                    if (enclosingScope.isAnonymous()) {
                        enclosingName = "anonymous block";
                    }
                    if ((associateType = SemanticUtils.unwrap(this.getAssociatedType(), true, true)) instanceof RfCollectionType) {
                        associateType = ((RfCollectionType)associateType).getAssociatedType();
                    }
                    if (associateType instanceof RfStruct && ((RfStruct)associateType).isAction(true)) {
                        project.addSemanticError(1, "ILLEGAL_DECLARATION: ''{0}'' {1} is not allowed under ''{2}'' {3} type", null, startOffset, endOffset, null, startLine, parserPath, name, "action handle", enclosingName, enclosingScope.getKindName());
                    }
                }
            }
        }
    }

    @Override
    public boolean isPublic() {
        return this.accessKind == AccessKind.PUBLIC;
    }

    @Override
    public boolean isProtected() {
        return this.accessKind == AccessKind.PROTECTED;
    }

    @Override
    public boolean isPrivate() {
        return this.accessKind == AccessKind.PRIVATE;
    }

    public boolean isArgument() {
        return this.fieldModifier == FieldModifier.METHOD_PARAM;
    }

    public String getSignature() {
        String initialValue = this.getInitialValue(false);
        initialValue = initialValue == null ? "" : " = " + initialValue;
        String associatedTypeName = this.getAssociatedTypeName();
        String associatedTypeArrayDim = this.getAssociatedTypeArrayDim();
        if (!associatedTypeArrayDim.startsWith("[")) {
            associatedTypeArrayDim = "";
        }
        switch (this.fieldModifier) {
            case CONST: 
            case STATIC_CONST: {
                return "field static const " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName + initialValue;
            }
            case RAND: {
                return "field rand " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case INPUT: {
                return "field input " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case OUTPUT: {
                return "field output " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case LOCK: {
                return "field lock " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case SHARE: {
                return "field share " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case ACTION: {
                return "field action " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case POOL: {
                return "field pool " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case COVERGROUP_PORT: {
                return "covergroup argument " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case COVERGROUP_INLINE: {
                return "covergroup inline instance " + this.getName();
            }
            case COVERPOINT: {
                return "coverpoint " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case COVERCROSS: {
                return "covercross " + this.getName() + associatedTypeArrayDim;
            }
            case METHOD_PARAM: {
                String direction = this.isOutput() ? "output " : (this.isInout() ? "inout " : "input ");
                return "function parameter " + direction + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName + initialValue;
            }
            case VARIADIC_PARAM: {
                return "function parameter " + this.getName() + " ... " + associatedTypeArrayDim + " : " + associatedTypeName + initialValue;
            }
            case SYMBOL_PARAM: {
                return "symbol parameter " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case ACTION_HANDLE: {
                return "action handle " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case INDEX: {
                return "index variable " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
            case ITERATOR: {
                return "iterator variable " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
            }
        }
        if (this.isFunctionVariable()) {
            return "variable " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName + initialValue;
        }
        if (this.isActionHandle()) {
            return "action handle " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
        }
        if (this.isInstance()) {
            return "component instance " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName;
        }
        return "field " + this.getName() + associatedTypeArrayDim + " : " + associatedTypeName + initialValue;
    }

    public String getInitialValue(boolean forceComputeEnumValue) {
        DataType dataType = this.getDataType();
        return dataType == null ? "" : dataType.getInitialValueText();
    }

    private boolean isFunctionVariable() {
        RfMethod enclosingMethod = this.getEnclosingScope(RfMethod.class);
        return enclosingMethod != null;
    }

    public boolean isLock() {
        return this.fieldModifier == FieldModifier.LOCK;
    }

    public boolean isShare() {
        return this.fieldModifier == FieldModifier.SHARE;
    }

    public boolean isCovercross() {
        return this.fieldModifier == FieldModifier.COVERCROSS;
    }

    public boolean isCoverpoint() {
        return this.fieldModifier == FieldModifier.COVERPOINT;
    }

    public boolean isLinkage() {
        return false;
    }

    public boolean isBuffer() {
        return false;
    }

    public boolean isInput() {
        if (this.fieldModifier == FieldModifier.METHOD_PARAM) {
            DataType dataType = this.getDataType();
            return dataType == null ? true : dataType.getDirection() == 1;
        }
        return this.fieldModifier == FieldModifier.INPUT;
    }

    public boolean isInout() {
        if (this.fieldModifier == FieldModifier.METHOD_PARAM) {
            DataType dataType = this.getDataType();
            return dataType == null ? false : dataType.getDirection() == 2;
        }
        return false;
    }

    public boolean isOutput() {
        if (this.fieldModifier == FieldModifier.METHOD_PARAM) {
            DataType dataType = this.getDataType();
            return dataType == null ? false : dataType.getDirection() == 3;
        }
        return this.fieldModifier == FieldModifier.OUTPUT;
    }

    public boolean isRef() {
        DataType dataType = this.getDataType();
        return dataType != null && dataType.isRef();
    }

    public boolean isPort() {
        return this.fieldModifier == FieldModifier.INPUT || this.fieldModifier == FieldModifier.OUTPUT || this.fieldModifier == FieldModifier.LOCK || this.fieldModifier == FieldModifier.SHARE;
    }

    public boolean isTypeParameter() {
        return false;
    }

    public boolean isParameterNoDataType() {
        return false;
    }

    public FieldModifier getFieldModifier() {
        return this.fieldModifier;
    }

    public int getFieldKind() {
        return -1;
    }

    public int getInterfaceKind() {
        return -1;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    public Image getImage() {
        switch (this.fieldModifier) {
            case RAND: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
            }
            case INPUT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INPUT_PORT);
            }
            case OUTPUT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_OUTPUT_PORT);
            }
            case LOCK: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_LOCK_RESOURCE);
            }
            case SHARE: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_SHARE_RESOURCE);
            }
            case ACTION: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_ACTIVITY_DATA_FIELD);
            }
            case POOL: {
                RfNamedElement associatedBaseType = this.getAssociatedBaseType();
                if (associatedBaseType instanceof RfStruct) {
                    RfStruct rfStruct = (RfStruct)associatedBaseType;
                    if (StructKind.BUFFER == rfStruct.getStructKind()) {
                        return DVTImages.imageCache.getImage(DVTImages.PSS_POOL_OF_BUFFER);
                    }
                    if (StructKind.STATE == rfStruct.getStructKind()) {
                        return DVTImages.imageCache.getImage(DVTImages.PSS_POOL_OF_STATE);
                    }
                    if (StructKind.STREAM == rfStruct.getStructKind()) {
                        return DVTImages.imageCache.getImage(DVTImages.PSS_POOL_OF_STREAM);
                    }
                    if (StructKind.RESOURCE == rfStruct.getStructKind()) {
                        return DVTImages.imageCache.getImage(DVTImages.PSS_POOL_OF_RESOURCE);
                    }
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
            }
            case COVERGROUP_PORT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
            }
            case COVERGROUP_INLINE: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVER_IMMEDIATE);
            }
            case COVERPOINT: {
                return DVTImages.imageCache.getImage(DVTImages.COVER_ITEM);
            }
            case COVERCROSS: {
                return DVTImages.imageCache.getImage(DVTImages.COVER_CROSS);
            }
            case METHOD_PARAM: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
            }
            case SYMBOL_PARAM: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
            }
            case ACTION_HANDLE: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_ACTION_HANDLE_FIELD);
            }
        }
        RfNamedElement associatedBaseType = this.getAssociatedBaseType();
        associatedBaseType = SemanticUtils.unwrap(associatedBaseType, true, true);
        if (associatedBaseType instanceof RfStruct) {
            RfStruct rfStruct = (RfStruct)associatedBaseType;
            if (StructKind.COMPONENT == rfStruct.getStructKind()) {
                return DVTImages.imageCache.getImage(DVTImages.PSS_COMPONENT_INSTANCE);
            }
            if (StructKind.ACTION == rfStruct.getStructKind() || StructKind.ACTION_ABSTRACT == rfStruct.getStructKind()) {
                return DVTImages.imageCache.getImage(DVTImages.PSS_ACTION_HANDLE_FIELD);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    @Override
    public void deepClean() {
        super.deepClean();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_FIELD: Duplicate attribute ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isEnumElement() {
        return false;
    }

    public boolean isPhysicalUnit() {
        return false;
    }

    public void setFieldModifier(FieldModifier fieldModifier) {
        this.fieldModifier = fieldModifier == null ? FieldModifier.NONE : fieldModifier;
    }

    public void setAccessKind(AccessKind accessKind) {
        this.accessKind = accessKind == null ? AccessKind.PUBLIC : accessKind;
    }

    public boolean isInstance() {
        if (this.isRef()) {
            return false;
        }
        RfNamedElement associatedType = this.getAssociatedType();
        associatedType = SemanticUtils.unwrap(associatedType, true, true);
        int i = 0;
        while (i < 20 && associatedType instanceof RfCollectionType) {
            if (((RfCollectionType)associatedType).getCollectionKind() != DataType.CollectionKind.ARRAY) {
                return false;
            }
            associatedType = ((RfCollectionType)associatedType).getAssociatedType();
            associatedType = SemanticUtils.unwrap(associatedType, true, true);
            ++i;
        }
        return associatedType instanceof RfStruct && ((RfStruct)associatedType).getStructKind() == StructKind.COMPONENT;
    }

    public boolean isActionHandle() {
        if (this.fieldModifier == FieldModifier.ACTION_HANDLE) {
            return true;
        }
        if (this instanceof RfPredefinedField && "this".equals(this.getName())) {
            return false;
        }
        RfNamedElement associatedType = this.getAssociatedType();
        if (associatedType instanceof RfCollectionType && ((RfCollectionType)associatedType).getCollectionKind() != DataType.CollectionKind.ARRAY) {
            return false;
        }
        RfNamedElement associatedBaseType = this.getAssociatedBaseType();
        if ((associatedBaseType = SemanticUtils.unwrap(associatedBaseType, true, true)) instanceof RfStruct && (((RfStruct)associatedBaseType).getStructKind() == StructKind.ACTION || ((RfStruct)associatedBaseType).getStructKind() == StructKind.ACTION_ABSTRACT)) {
            this.fieldModifier = FieldModifier.ACTION_HANDLE;
            return true;
        }
        return false;
    }

    public int getPoolSize() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            ScenarioUtils.print("*** Error: Internal error GPS_1");
            return 1;
        }
        int arrayDimAsInteger = dataType.getArrayDimAsInteger();
        return arrayDimAsInteger > 0 ? arrayDimAsInteger : 1;
    }

    public boolean isSymbolParam() {
        return this.fieldModifier == FieldModifier.SYMBOL_PARAM;
    }

    public boolean isMethodParam() {
        return this.fieldModifier == FieldModifier.METHOD_PARAM;
    }

    public boolean isPool() {
        return this.fieldModifier == FieldModifier.POOL;
    }

    public boolean isIndex() {
        return false;
    }

    public boolean isIterator() {
        return false;
    }

    public boolean isRand() {
        return this.fieldModifier == FieldModifier.RAND || this.fieldModifier == FieldModifier.RAND_ACTION || this.fieldModifier == FieldModifier.COVERPOINT || this.fieldModifier == FieldModifier.COVERCROSS || this.fieldModifier == FieldModifier.COVERGROUP_PORT;
    }

    public boolean isActionQualified() {
        return this.fieldModifier == FieldModifier.RAND_ACTION;
    }

    public boolean isConstant() {
        return this.fieldModifier == FieldModifier.CONST || this.fieldModifier == FieldModifier.STATIC_CONST;
    }

    public void setIsRuntime(boolean isRuntime) {
        this.isRuntime = isRuntime;
    }

    public boolean isRuntime() {
        return this.isRuntime;
    }

    public boolean isList() {
        DataType dataType = this.getDataType();
        return dataType != null && dataType.getContainerKind() == DataType.CollectionKind.LIST;
    }

    @Override
    public boolean isStatic() {
        return this.fieldModifier == FieldModifier.STATIC_CONST || this.fieldModifier == FieldModifier.CONST && this.getEnclosingScope() instanceof RfPackage;
    }

    @Override
    public int sizeof() {
        RfNamedElement assocType = this.getAssociatedType();
        if (assocType instanceof RfPredefinedEnumType) {
            return 32;
        }
        if (assocType instanceof RfCollectionType) {
            return assocType.sizeof();
        }
        if (assocType instanceof RfTypeAlias) {
            return assocType.sizeof();
        }
        if (assocType instanceof RfStruct) {
            return assocType.sizeof();
        }
        DataType dataType = this.getDataType();
        if (dataType == null) {
            throw new UnsupportedOperationException();
        }
        return dataType.nofBits();
    }

    public boolean isVariadic() {
        return this.getFieldModifier() == FieldModifier.VARIADIC_PARAM;
    }

    @Override
    public boolean isNonStandard() {
        if (this.isAddrRegPkgMember()) {
            String structName = SemanticUtils.getStructName(this.getEnclosingScope());
            if ("offset".equals(this.getName()) && "reg_c".equals(structName)) {
                return true;
            }
            if ("reset_val".equals(this.getName()) && "reg_c".equals(structName)) {
                return true;
            }
            if ("reset_mask".equals(this.getName()) && "reg_c".equals(structName)) {
                return true;
            }
        }
        return false;
    }

    public static class RfIndexField
    extends RfField {
        public RfIndexField(String name, DataType dataType) {
            super(name, dataType);
        }

        @Override
        public boolean isIndex() {
            return true;
        }
    }

    public static class RfIteratorField
    extends RfField {
        public RfIteratorField(String name, DataType dataType) {
            super(name, dataType);
        }

        @Override
        public boolean isIterator() {
            return true;
        }
    }
}

