/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.collections.AST;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTEditorCommon;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfClassType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfImportElement;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfScopeDefElement;
import ro.amiq.pssdt.model.reflection.RfTemplateInstanceDef;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.EAST;
import ro.amiq.pssdt.utils.Utils;

public class RfFileDef
extends RfScopeDefElement
implements IRfFileDef {
    public int index = -1;
    private ParserPath parserPath;
    private String name;
    private boolean predefined;
    private IBuildConfigParserConstants.LanguageSyntax languageSyntax;
    private Deque<RfDefElement> lexicalScopes;
    private String libraryName;
    private transient RfLibrary library;
    private Map<String, List<IdentifierPosition>> identifiers = new HashMap<String, List<IdentifierPosition>>();
    private transient RfDefElement cachedScope;
    private transient int cachedScopeOffset;

    public RfFileDef(String name, int index, ParserPath parserPath, RfLibrary enclosingLibrary, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        super(null, null, null, null, null, true, null);
        this.name = name;
        this.index = index;
        this.parserPath = parserPath;
        this.languageSyntax = languageSyntax;
        this.library = enclosingLibrary;
        this.libraryName = enclosingLibrary == null ? null : enclosingLibrary.getName();
        this.lexicalScopes = new ArrayDeque<RfDefElement>();
        this.lexicalScopes.push(this);
    }

    @Override
    public RfFileDef getDefFile() {
        return this;
    }

    @Override
    public RfProject getRfProject() {
        return this.library.getRfProject();
    }

    public void cleanUpFile() {
        this.cleanChildren();
        this.cachedScope = null;
        this.lexicalScopes.clear();
        this.lexicalScopes.push(this);
        this.identifiers.clear();
    }

    @Override
    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public RfProject.FileReference getFileReference() {
        return new RfProject.FileReference(this.parserPath, this.index);
    }

    @Override
    public void addNamedElement(RfNamedElement namedElem) {
    }

    @Override
    public RfNamedElement getNamedElement() {
        return null;
    }

    public IDocument getDocument() {
        RfProject rfProject = this.library.getRfProject();
        if (rfProject == null) {
            return null;
        }
        DVTEditor editor = rfProject.getEditor(this.parserPath);
        if (editor == null) {
            return null;
        }
        return editor.getDocument();
    }

    public void connectPositionToDocument(Map<Annotation, Position> aditions, boolean connectPositionsAfterEditorFocus, Set<DVTSemanticFoldingPosition> foldingPositions, List<Position> reflectionPositions) {
        try {
            IDocument document = this.getDocument();
            if (document == null) {
                return;
            }
            if (!document.containsPositionCategory("REFLECTION")) {
                return;
            }
            if (!connectPositionsAfterEditorFocus) {
                document.removePositionCategory("REFLECTION");
                document.addPositionCategory("REFLECTION");
            }
            RfFileDef.connectRecursive(this.getChildren(), document, new HashMap<Position, Position>(), aditions, connectPositionsAfterEditorFocus, reflectionPositions);
            Utils.connectPragmaCodePositions(document, this, foldingPositions);
            if (!connectPositionsAfterEditorFocus) {
                RfFileDef.connectIdentifiers(this.identifiers, document, reflectionPositions);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void connectRecursive(Collection<RfDefElement> children, IDocument document, Map<Position, Position> cachedPositions, Map<Annotation, Position> aditions, boolean connectPositionsAfterEditorFocus, List<Position> reflectionPositions) {
        try {
            RfDefElement[] childrenCopy;
            if (children == null) {
                return;
            }
            RfDefElement[] rfDefElementArray = childrenCopy = children.toArray(new RfDefElement[children.size()]);
            int n = childrenCopy.length;
            int n2 = 0;
            while (n2 < n) {
                RfNamedElement element;
                RfDefElement child = rfDefElementArray[n2];
                if (!connectPositionsAfterEditorFocus) {
                    child.connectPositionToDocument(document, cachedPositions, reflectionPositions);
                }
                if (child.getDefFile() != null && child.getParserPath() != null && ((element = child.getNamedElement()) instanceof RfExecBlock || element instanceof RfBlock && !element.isAnonymous() && ((RfBlock)element).isConstraint() || element instanceof RfMethod)) {
                    String message = "";
                    int kind = 0;
                    RfDefElement layerInLikeParent = element.getLayerInLikeParent();
                    if (layerInLikeParent != null) {
                        kind = 0;
                        message = "overrides " + layerInLikeParent.getNamedElement().getEnclosingScope(RfClassType.class).getName() + "." + element.getName();
                    }
                    if (layerInLikeParent != null && layerInLikeParent.getDefFile() != null && layerInLikeParent.getParserPath() != null) {
                        aditions.put((Annotation)new DVTEditorCommon.OverrideIndicator(kind, message, (IRfFileDef)layerInLikeParent.getDefFile(), layerInLikeParent.getStartLine(), "ro.amiq.pssdt.ui.editor.PSSEditor"), (Position)new DVTPosition(child.getStartOffset(), 0));
                    }
                }
                if (child.getChildren() != children) {
                    RfFileDef.connectRecursive(child.getChildren(), document, cachedPositions, aditions, connectPositionsAfterEditorFocus, reflectionPositions);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectIdentifiers(Map<String, List<IdentifierPosition>> identifiers, IDocument document, List<Position> reflectionPositions) {
        try {
            if (identifiers == null) {
                return;
            }
            int documentLength = document.getLength();
            Map<String, List<IdentifierPosition>> map = identifiers;
            synchronized (map) {
                Collection<List<IdentifierPosition>> idPositionsListOfList = identifiers.values();
                for (List<IdentifierPosition> idPositionsList : idPositionsListOfList) {
                    if (idPositionsList == null || idPositionsList.isEmpty()) continue;
                    for (IdentifierPosition idPosition : idPositionsList) {
                        if (idPosition.offset < 0 || idPosition.length < 0 || idPosition.offset + idPosition.length > documentLength) continue;
                        reflectionPositions.add((Position)idPosition);
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void disconnectPositionFromDocument() {
        try {
            IDocument document = this.getDocument();
            if (document == null) {
                return;
            }
            if (!document.containsPositionCategory("REFLECTION")) {
                return;
            }
            boolean isCloned = DVTUtilsCommon.INSTANCE.isOpenClonedEditorSharingSameDocument(document);
            if (isCloned) {
                return;
            }
            document.removePositionCategory("REFLECTION");
            document.addPositionCategory("REFLECTION");
            this.disconnectRecursive(this.getChildren());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void disconnectRecursive(Collection<RfDefElement> children) {
        if (children == null) {
            return;
        }
        for (RfDefElement child : children) {
            child.removePosition();
            if (child.getChildren() == children) continue;
            this.disconnectRecursive(child.getChildren());
        }
    }

    @Override
    public RfNamedElement getEnclosingScope() {
        return this.getEnclosingLibrary();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getFileAdapter();
        }
        return null;
    }

    @Override
    public IResource getFileAdapter() {
        if (this.library == null || this.library.getRfProject() == null || this.parserPath == null) {
            return null;
        }
        return Utils.getFileAdapter(this.library.getRfProject(), this.parserPath.path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void removeChildDef(RfDefElement elem) {
        this.lexicalScopes.peek().removeChild(elem);
    }

    public RfDefElement addChildDef(RfDefElement child) {
        this.lexicalScopes.peek().addChild(child);
        return child;
    }

    public void pushPhysicalScope(RfDefElement scope) {
        this.lexicalScopes.push(scope);
    }

    public RfDefElement popPhysicalScope() {
        return this.lexicalScopes.pop();
    }

    public RfDefElement peekPhysicalScope() {
        return this.lexicalScopes.peek();
    }

    public boolean stackContains(RfDefElement elem) {
        for (RfDefElement defElem : this.lexicalScopes) {
            if (elem != defElem) continue;
            return true;
        }
        return false;
    }

    public RfDefElement getScope(int line, int offset) {
        return this.getScope(offset);
    }

    public RfDefElement getScope(int offset) {
        this.cachedScopeOffset = offset;
        this.cachedScope = this.getScopeRecursive(offset, null, this.getChildren(), null);
        if (this.cachedScope == null) {
            this.cachedScope = this;
        }
        return this.cachedScope;
    }

    public RfDefElement getScope(int offset, Set<Class<? extends RfNamedElement>> clazzSet) {
        if (offset == this.cachedScopeOffset && this.cachedScope != null && (clazzSet == null || this.cachedScope.getNamedElement() != null && clazzSet.contains(this.cachedScope.getNamedElement().getClass()))) {
            return this.cachedScope;
        }
        this.cachedScopeOffset = offset;
        this.cachedScope = this.getScopeRecursive(offset, null, this.getChildren(), clazzSet);
        if (this.cachedScope == null) {
            this.cachedScope = this;
        }
        return this.cachedScope;
    }

    /*
     * Unable to fully structure code
     */
    private RfDefElement getScopeRecursive(int offset, RfDefElement result, Collection<RfDefElement> childList, Set<Class<? extends RfNamedElement>> clazzSet) {
        block10: {
            try {
                if (childList == null) {
                    return result;
                }
                layers = childList.toArray(new RfDefElement[childList.size()]);
                adaptiveStep = Math.max(100, layers.length / 100);
                i = layers.length - 1;
                while (i >= 0) {
                    block12: {
                        block11: {
                            child = null;
                            if (i - adaptiveStep < 0) break block11;
                            child = layers[i - adaptiveStep];
                            if (child.getChildren() == childList) break block12;
                            if (child.getStartOffset() <= offset) break block11;
                            i -= adaptiveStep;
                            break block12;
                        }
                        if ((child = layers[i]).isNonScopeLayer() || child.getChildren() == childList) break block12;
                        if (child.getEndOffset() < offset) break block10;
                        if (child.getStartOffset() > offset) break block12;
                        if (result == null) {
                            result = child;
                            namedElement = result.getNamedElement();
                            if (namedElement != null && clazzSet != null && clazzSet.contains(namedElement.getClass())) {
                                return result;
                            }
                            namedElement = (result = this.getScopeRecursive(offset, result, result.getChildren(), clazzSet)).getNamedElement();
                            if (namedElement != null && clazzSet != null && clazzSet.contains(namedElement.getClass())) {
                                return result;
                            }
                            break;
                        }
                        if (result.containsOffset(child.getStartOffset()) && result.containsOffset(child.getEndOffset())) {
                            result = child;
                            namedElement = result.getNamedElement();
                            if (namedElement != null && clazzSet != null && clazzSet.contains(namedElement.getClass())) {
                                return result;
                            }
                            namedElement = (result = this.getScopeRecursive(offset, result, result.getChildren(), clazzSet)).getNamedElement();
                            if (namedElement != null && clazzSet != null && clazzSet.contains(namedElement.getClass())) {
                                return result;
                            } else {
                                ** GOTO lbl37
                            }
                        }
                        break block12;
lbl37:
                        // 2 sources

                        break;
                    }
                    --i;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public RfLibrary getEnclosingLibrary() {
        return this.library;
    }

    @Override
    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return this.languageSyntax;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.file_content";
    }

    @Override
    public boolean isPredefined() {
        return this.predefined;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.parserPath = null;
        this.name = null;
        this.library = null;
        this.libraryName = null;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public RfLibrary restoreLibraryFromName(RfProject rfProject) {
        if (this.libraryName == null) {
            return null;
        }
        this.library = rfProject.getLocalLibrary(this.libraryName);
        return this.library;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentifier(AST id) {
        if (id == null || !(id instanceof EAST)) {
            return;
        }
        Map<String, List<IdentifierPosition>> map = this.identifiers;
        synchronized (map) {
            List<IdentifierPosition> list = this.identifiers.get(id.getText());
            if (list == null) {
                list = new ArrayList<IdentifierPosition>();
                this.identifiers.put(id.getText(), list);
            }
            IdentifierPosition idPosition = new IdentifierPosition((EAST)id);
            list.add(idPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IdentifierPosition> getIdentifiers(String name) {
        Map<String, List<IdentifierPosition>> map = this.identifiers;
        synchronized (map) {
            List<IdentifierPosition> result = this.identifiers.get(name);
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentifierPosition getIdentifier(String name, int offset) {
        Map<String, List<IdentifierPosition>> map = this.identifiers;
        synchronized (map) {
            List<IdentifierPosition> candidates = this.getIdentifiers(name);
            for (IdentifierPosition candidate : candidates) {
                if (candidate.getOffset() > offset || candidate.getOffset() + name.length() < offset) continue;
                return candidate;
            }
            return null;
        }
    }

    public boolean isInternalModule() {
        return false;
    }

    public void createVariableDependency(RfProject project, RfNamedElement element, String elementName) {
        if (element == null) {
            if (elementName != null) {
                project.addUndeclaredVarNameReference(this.getFileReference(), elementName);
            }
            return;
        }
        if (element.hasNoDefs(false) || element.isPredefined() || element.isAnonymous()) {
            return;
        }
        RfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            return;
        }
        RfFileDef fileDef = declaration.getDefFile();
        if (fileDef == null || fileDef == this) {
            return;
        }
        if (this.index >= fileDef.index) {
            fileDef.addDependentFileReference(project, this.getFileReference());
            if (element instanceof IRfAssociatedType) {
                this.createTypeDependency(project, (RfNamedElement)((IRfAssociatedType)((Object)element)).getAssociatedBaseType(), null);
            }
        }
    }

    public void createTypeDependency(RfProject project, RfNamedElement element, String elementName) {
        if (element == null) {
            if (elementName != null) {
                project.addUndeclaredTypeNameReference(this.getFileReference(), elementName);
            }
            return;
        }
        if (element.hasNoDefs(false) || element.isPredefined() || element.isAnonymous()) {
            return;
        }
        RfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            return;
        }
        RfFileDef fileDef = declaration.getDefFile();
        if (fileDef == null || fileDef == this) {
            return;
        }
        if (this.index >= fileDef.index) {
            fileDef.addDependentFileReference(project, this.getFileReference());
        }
    }

    private void addDependentFileReference(RfProject project, RfProject.FileReference reference) {
        project.addDependentFileReference(this.getFileReference(), reference);
    }

    public List<AST> getTemplateInstanceASTs() {
        ArrayList<AST> result = new ArrayList<AST>();
        this.collectTemplateInstancesRecursive(result, this.getChildren());
        return result;
    }

    private void collectTemplateInstancesRecursive(List<AST> result, Collection<RfDefElement> childList) {
        try {
            if (childList == null) {
                return;
            }
            for (RfDefElement rfDefElement : childList) {
                if (rfDefElement instanceof RfTemplateInstanceDef) {
                    result.addAll(((RfTemplateInstanceDef)rfDefElement).getNodesAST());
                }
                this.collectTemplateInstancesRecursive(result, rfDefElement.getChildren());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public List<RfImportElement> getImportedElements() {
        if (RfProject.IMPORT_MODE == RfProject.ImportMode.LEXICAL_SCOPE) {
            return this.importedElements;
        }
        RfProject project = this.library.getEnclosingScope(RfProject.class);
        Collection<RfFileDef> fileDefs = project.getFiles();
        if (fileDefs == null) {
            return this.importedElements;
        }
        ArrayList<RfImportElement> result = new ArrayList<RfImportElement>();
        for (RfFileDef fileDef : fileDefs) {
            if (fileDef.importedElements != null) {
                result.addAll(fileDef.importedElements);
            }
            if (fileDef == this) break;
        }
        return result;
    }

    public static class IdentifierPosition
    extends DVTPosition {
        private AST idAST;

        public IdentifierPosition(EAST id) {
            super(0, 0);
            this.offset = id.getOffset();
            this.length = id.getText().length();
            this.idAST = id;
        }

        public RfNamedElement getNamedElement() {
            return SemanticUtils.getTransientResult(RfNamedElement.class, this.idAST);
        }

        public RfDefElement getDefElement() {
            return SemanticUtils.getTransientScope(RfDefElement.class, this.idAST);
        }

        public String getText() {
            return this.idAST.getText();
        }

        public AST getIdAst() {
            return this.idAST;
        }
    }
}

