/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;

public enum RfKind implements IRfKind
{
    COMPONENT("component"),
    ACTION("action"),
    IMPORT_CLASS("import class"),
    BUFFER("buffer"),
    RESOURCE("resource"),
    STATE("state"),
    STREAM("stream"),
    STRUCT("struct"),
    BLOCK("block"),
    PACKAGE("package"),
    TYPE_ALIAS("type alias"),
    ENUM_TYPE("enum type"),
    ENUM_ITEM("enum item"),
    FIELD("field"),
    POOL("pool"),
    METHOD("method"),
    COVERSPEC("coverspec"),
    UNKNOWN("");

    private String fName;

    private RfKind(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public static RfKind of(IRfNamedElement element) {
        if (element instanceof RfStruct) {
            if (((RfStruct)element).getStructKind() == StructKind.COMPONENT) {
                return COMPONENT;
            }
            if (((RfStruct)element).getStructKind() == StructKind.ACTION) {
                return ACTION;
            }
            if (((RfStruct)element).getStructKind() == StructKind.ACTION_ABSTRACT) {
                return ACTION;
            }
            if (((RfStruct)element).getStructKind() == StructKind.IMPORT_CLASS) {
                return IMPORT_CLASS;
            }
            if (((RfStruct)element).getStructKind() == StructKind.BUFFER) {
                return BUFFER;
            }
            if (((RfStruct)element).getStructKind() == StructKind.RESOURCE) {
                return RESOURCE;
            }
            if (((RfStruct)element).getStructKind() == StructKind.STATE) {
                return STATE;
            }
            if (((RfStruct)element).getStructKind() == StructKind.STREAM) {
                return STREAM;
            }
        }
        if (element instanceof RfStruct) {
            return STRUCT;
        }
        if (element instanceof RfTypeAlias) {
            return TYPE_ALIAS;
        }
        if (element instanceof RfEnumType) {
            return ENUM_TYPE;
        }
        if (element instanceof RfEnumItem) {
            return ENUM_ITEM;
        }
        if (element instanceof RfPackage) {
            return PACKAGE;
        }
        if (element instanceof RfBlock) {
            return BLOCK;
        }
        if (element instanceof RfMethod) {
            return METHOD;
        }
        if (element instanceof RfField) {
            if (((RfField)element).isPool()) {
                return POOL;
            }
            return FIELD;
        }
        if (element instanceof RfCovergroup) {
            return COVERSPEC;
        }
        return UNKNOWN;
    }
}

