/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.ChecksKindWrapper;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTMixedLangBuildListener;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.IRfProjectContent;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.model.reflection.util.IdleHandler;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.pssdt.model.IPSSBuildListener;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.IPSSProject;
import ro.amiq.pssdt.model.PSSFileInfo;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.PSSModule;
import ro.amiq.pssdt.model.indexer.IdentifierIndexer;
import ro.amiq.pssdt.model.reflection.RfProject;

public class RfManager
implements IPSSBuildListener,
IDVTMixedLangBuildListener {
    private static volatile RfManager instance;
    private int versionChangedMessageCounter;
    private Set<IProject> fullBuildProjectLockMap = Collections.newSetFromMap(new ConcurrentHashMap());
    private BlockingQueue<SaveModuleRunnable> saveModuleInfoPipe = new ArrayBlockingQueue<SaveModuleRunnable>(500);
    private Thread saveModuleInfoThread = new Thread(){

        @Override
        public void run() {
            try {
                while (true) {
                    SaveModuleRunnable runnable = RfManager.this.saveModuleInfoPipe.take();
                    runnable.run();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
        }
    };
    private static final Object syncInstance;

    static {
        syncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RfManager getInstance() {
        if (instance == null) {
            Object object = syncInstance;
            synchronized (object) {
                instance = new RfManager();
                instance.init();
            }
        }
        return instance;
    }

    protected void init() {
        this.saveModuleInfoThread.start();
        IdleHandler.addIdleListener((IIdleListener)new IIdleListener(){

            public void platformIsIdle() {
            }

            public boolean isWriteDone() {
                return RfManager.this.saveModuleInfoPipe.isEmpty();
            }
        });
    }

    public String getRFDMDirName() {
        return "pss_rfdm";
    }

    public boolean hasDictionary(IProject project) {
        try {
            String file = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)this.getRFDMDirName(), (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
            return new File(file).exists();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public boolean preRestoreRfProject(RfProject rfProject) {
        block3: {
            try {
                IProject project = rfProject.getProject();
                if (project.exists() && project.isOpen() && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return this.initRFDM(rfProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initRFDM(RfProject rfProject) {
        IProject project = rfProject.getProject();
        DVTProblemManager.getInstance().clearWaivers(project);
        CompileWaiversManager.INSTANCE.loadWaivers(project);
        DVTNature.updateDeprecatedProject((IProject)project);
        try {
            block23: {
                String fileName = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)this.getRFDMDirName(), (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                if (fileName == null) {
                    return false;
                }
                File file = new File(fileName);
                if (!file.isFile()) {
                    return false;
                }
                Throwable throwable = null;
                Object var6_14 = null;
                try {
                    BufferedInputStream bif = new BufferedInputStream(new FileInputStream(file), 32768);
                    try {
                        try (ObjectInputStream ois = new ObjectInputStream(bif);){
                            Object fullBuildList = ois.readObject();
                            rfProject.setFullBuildFileInfos((List)fullBuildList);
                            Object rfProjectContent = ois.readObject();
                            rfProject.setRfProjectContent((IRfProjectContent)rfProjectContent);
                            Object rfCompiledFiles = ois.readObject();
                            rfProject.setRfCompiledFiles((RfCompiledFiles)rfCompiledFiles);
                        }
                        if (bif == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (bif == null) throw throwable;
                        bif.close();
                        throw throwable;
                    }
                    bif.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            IIdentifierIndexerExtension indexer = IdentifierIndexerManager.getInstance().getProjectIndexer(IdentifierIndexer.class, rfProject.getProject());
            indexer.read(BuildConfigManagerCommon.PersistenceModeWrapper.regular());
            return true;
        }
        catch (OptionalDataException e) {
            DVTLogger.INSTANCE.logError("RfProject.initRfDM()", (Throwable)e);
            this.openRebuildDialog(project);
            return false;
        }
        catch (InvalidClassException e) {
            DVTLogger.INSTANCE.logError("RfProject.initRfDM()", (Throwable)e);
            this.openRebuildDialog(project);
            return false;
        }
        catch (ClassNotFoundException e) {
            DVTLogger.INSTANCE.logError("RfProject.initRfDM()", (Throwable)e);
            this.openRebuildDialog(project);
            return false;
        }
        catch (ClassCastException e) {
            DVTLogger.INSTANCE.logError("RfProject.initRfDM()", (Throwable)e);
            this.openRebuildDialog(project);
            return false;
        }
        catch (FileNotFoundException e) {
            DVTLogger.INSTANCE.logError("RfProject.initRfDM()" + e.getMessage());
            return false;
        }
        catch (StackOverflowError e) {
            DVTLogger.INSTANCE.logError("RfProject.initRfDM()" + e.getMessage());
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.initRfDM()" + e.getMessage());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeRFDM(RfProject rfProject) {
        String file = BuildConfigManager.getModelPersistenceLocation((IProject)rfProject.getProject(), (String)this.getRFDMDirName(), (boolean)false, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
        if (file == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(file), 32768);
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(bof);){
                        oos.writeObject(rfProject.getFullBuildFileInfos());
                        oos.writeObject(rfProject.getRfProjectContent());
                        oos.writeObject(rfProject.getRfCompiledFiles());
                        IIdentifierIndexerExtension indexer = IdentifierIndexerManager.getInstance().getProjectIndexer(IdentifierIndexer.class, rfProject.getProject());
                        indexer.write(BuildConfigManagerCommon.PersistenceModeWrapper.regular(), (IRfSingleLangProject)rfProject);
                    }
                    if (bof == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bof == null) throw throwable;
                    bof.close();
                    throw throwable;
                }
                bof.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.writeRfDM()", (Throwable)e);
        }
    }

    private void openRebuildDialog(final IProject project) {
        if (this.fullBuildProjectLockMap.contains(project)) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RfManager.this.versionChangedMessageCounter != 0) {
                    return;
                }
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "DVT Version Changed", null, "DVT version changed. It is recommended to rebuild '" + project.getName() + "' project for refreshing dictionary, errors etc.", 4, new String[]{"Rebuild Now", "Later"}, 0);
                ++RfManager.this.versionChangedMessageCounter;
                if (dialog.open() != 0) {
                    --RfManager.this.versionChangedMessageCounter;
                    return;
                }
                --RfManager.this.versionChangedMessageCounter;
                if (RfManager.this.fullBuildProjectLockMap.contains(project)) {
                    return;
                }
                DVTBuildUtils.runInternalBuilder((IProject)project);
            }
        });
    }

    private final void saveModuleInfo(IProject project, PSSFileInfo fileInfo) {
        ObjectOutputStream oos = null;
        ParserPath parserPath = fileInfo.getParserPath();
        String file = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)(String.valueOf(Integer.toHexString(parserPath.hashCode())) + "_" + fileInfo.getFileIndex()), (boolean)false, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
        if (file == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(file), 32768);){
                oos = new ObjectOutputStream(bof);
                oos.writeObject(fileInfo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Error saving module '" + fileInfo.getParserPath() + "' ", (Throwable)e);
        }
    }

    public final RfProject getRfProject(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.pssdt.pssnature", true);
    }

    public final RfProject getRfProjectWithoutRestore(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.pssdt.pssnature", false);
    }

    public final void fullBuild(DVTFileInfo dvtFileInfo) {
        RfProject rfProject;
        PSSFileInfo info = PSSModelManager.getInstance().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        if (!this.fullBuildProjectLockMap.contains(project)) {
            this.fullBuildProjectLockMap.add(project);
        }
        if ((rfProject = this.getRfProject(project)) == null) {
            return;
        }
        rfProject.build(info, false);
        boolean saveRFDM = info.isSaveRFDM();
        if (saveRFDM) {
            this.saveModuleInfoPipe.add(new SaveModuleRunnable(project, info));
        }
    }

    public final void incrementalBuild(DVTFileInfo dvtFileInfo) {
        PSSFileInfo info = PSSModelManager.getInstance().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.build(info, true);
        boolean saveRFDM = info.isSaveRFDM();
        if (saveRFDM) {
            this.saveModuleInfoPipe.add(new SaveModuleRunnable(project, info));
        }
    }

    public final void postIncrementalBuild(DVTFileInfo dvtFileInfo) {
        PSSFileInfo info = PSSModelManager.getInstance().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postIncrementalBuild(info);
    }

    public final void clean(IDVTProject iDVTProject) {
        IPSSProject pssProject = PSSModelManager.getInstance().getIPSSProject(iDVTProject);
        if (pssProject == null) {
            return;
        }
        IProject project = pssProject.getProject();
        if (project == null) {
            return;
        }
        IdentifierIndexerManager.getInstance().getProjectIndexer(IdentifierIndexer.class, pssProject.getProject()).clean();
        RfProject rfProject = this.getRfProjectWithoutRestore(pssProject.getProject());
        if (rfProject == null) {
            return;
        }
        rfProject.clean();
        try {
            if (MemUtils.COLLECT_STATS) {
                MemUtils.forceGC();
            }
        }
        catch (Exception exception) {}
    }

    public final void remove(IDVTFile iDVTFile) {
        IPSSModule eModule = PSSModelManager.getInstance().getIPSSModule(iDVTFile);
        IProject project = eModule.getFile().getProject();
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.remove(eModule);
        BuildEventManager.getInstance().notifyIncrementalBuild(project, null, null);
    }

    public final void postFullBuild(IDVTProject dvtProject, boolean success) {
        IPSSProject PSSProject2 = PSSModelManager.getInstance().getIPSSProject(dvtProject);
        IProject project = dvtProject.getProject();
        if (!success) {
            this.clean(PSSProject2);
        } else {
            if (project == null) {
                return;
            }
            RfProject rfProject = this.getRfProject(project);
            if (rfProject == null) {
                return;
            }
            rfProject.postFullBuild(true, true);
        }
    }

    public final void activeTestChangedNotification(IProject project) {
    }

    public final void clean(IDVTFile dvtFile) {
        PSSModule pssFile = (PSSModule)PSSModelManager.getInstance().getIPSSModule(dvtFile);
        if (pssFile == null || pssFile.getResource() == null) {
            return;
        }
        IProject project = pssFile.getResource().getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.cleanIncremental(pssFile.getParserPath());
    }

    public final void postMixedLangFullBuildPreElab(IProject project) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangFullBuild(BuildConfigManager.getFullCompileChecks((IProject)project), true);
    }

    public final void postMixedLangIncrementalBuildPreElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangIncrementalBuild(changedFiles.get(LanguageKind.PSS), updateViewIds);
    }

    public final void performExtendedChecks(IProject project, ChecksKindWrapper checksKindWrapper) {
    }

    public final void postBuildConfigIncrementalBuild(IProject project) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postBuildConfigChecks();
    }

    public void postIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
    }

    class SaveModuleRunnable
    implements Runnable {
        private IProject project;
        private PSSFileInfo info;

        public SaveModuleRunnable(IProject project, PSSFileInfo info) {
            this.project = project;
            this.info = info;
        }

        @Override
        public void run() {
            RfManager.this.saveModuleInfo(this.project, this.info);
        }
    }
}

