/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfExtendDuplicate;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfImportElement;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfScopeDefElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfFieldWrapper;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public abstract class RfMembersContainer
extends RfNamedElement
implements IRfScope {
    protected DVTLinkedHashMap<String, RfNamedElement> members;

    public RfMembersContainer(String name) {
        super(name);
    }

    @Override
    public void deepClean() {
        if (this.members != null && !this.members.isEmpty()) {
            for (RfNamedElement member : this.members) {
                if (member == this) continue;
                member.deepClean();
            }
        }
        super.deepClean();
    }

    @Override
    public List<RfImportElement> getImportedElements(RfScopeDefElement lexicalScope) {
        if (lexicalScope instanceof RfFileDef) {
            return lexicalScope.getImportedElements();
        }
        if (RfProject.IMPORT_MODE == RfProject.ImportMode.LEXICAL_SCOPE) {
            return lexicalScope == null ? null : lexicalScope.getImportedElements();
        }
        ArrayList<RfImportElement> result = new ArrayList<RfImportElement>();
        for (RfDefElement tempLexicalScope : this.getLayers()) {
            List<RfImportElement> importedElements;
            if (tempLexicalScope instanceof RfScopeDefElement && (importedElements = ((RfScopeDefElement)tempLexicalScope).getImportedElements()) != null) {
                result.addAll(importedElements);
            }
            if (tempLexicalScope == lexicalScope) break;
        }
        return result;
    }

    public Determinant getDeterminant(RfScopeDefElement lexicalScope) {
        Determinant determinant = RfPackage.MAIN_DETERMINANT;
        RfDefElement tempLexicalScope2 = lexicalScope;
        RfNamedElement namedElement = null;
        while (tempLexicalScope2 != null && (namedElement = tempLexicalScope2.getNamedElement()) != null) {
            if (namedElement instanceof RfPackage) {
                determinant = Determinant.extend(determinant, namedElement.getName());
            }
            tempLexicalScope2 = tempLexicalScope2.getParentLexicalScope();
        }
        if (RfProject.IMPORT_MODE == RfProject.ImportMode.LEXICAL_SCOPE) {
            return lexicalScope == null ? determinant : lexicalScope.extendDeterminant(determinant);
        }
        for (RfDefElement tempLexicalScope2 : this.getLayers()) {
            if (!(tempLexicalScope2 instanceof RfScopeDefElement)) continue;
            determinant = ((RfScopeDefElement)tempLexicalScope2).extendDeterminant(determinant);
        }
        return determinant;
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter elementFilter) {
        if (this.members == null) {
            return null;
        }
        RfNamedElement member = (RfNamedElement)this.members.get((Object)name);
        if (member == null) {
            return null;
        }
        if (member instanceof RfExtendDuplicate) {
            return member.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
        }
        if (classes != null && !classes.contains(member.getClass())) {
            return null;
        }
        if ((determinant == null || this instanceof RfStruct || this instanceof RfEnumType || this instanceof RfPackage || determinant.contains(member.getPackageName())) && (this instanceof RfTemplateInstance || elementFilter == null || elementFilter.validElement((IRfNamedElement)member))) {
            return member;
        }
        return null;
    }

    @Override
    public void addMember(String packageName, boolean isExtendLayer, RfNamedElement namedElement) {
        if (this.members == null) {
            this.members = new DVTLinkedHashMap();
        } else if (isExtendLayer) {
            RfNamedElement existingMember = (RfNamedElement)this.members.get((Object)namedElement.getKey());
            if (existingMember instanceof RfExtendDuplicate) {
                existingMember.addMember(packageName, isExtendLayer, namedElement);
                return;
            }
            if (existingMember != null) {
                RfExtendDuplicate newMember = new RfExtendDuplicate(namedElement.getKey());
                ((RfNamedElement)newMember).addMember(existingMember.getPackageName(), isExtendLayer, existingMember);
                ((RfNamedElement)newMember).addMember(packageName, isExtendLayer, namedElement);
                this.members.remove((Object)namedElement.getKey());
                namedElement = newMember;
            }
        }
        this.members.put((Object)namedElement.getKey(), (IDVTMapElement)namedElement);
        namedElement.setEnclosingScope(this);
    }

    public void addExtendMembers(RfNamedElement otherContainer) {
        if (otherContainer == null || !(otherContainer instanceof RfMembersContainer)) {
            return;
        }
        DVTLinkedHashMap<String, RfNamedElement> otherMembers = ((RfMembersContainer)otherContainer).members;
        if (otherMembers == null || otherMembers.isEmpty()) {
            return;
        }
        for (RfNamedElement member : otherMembers) {
            member.setEnclosingScope(this);
            this.addMember(member.getPackageName(), true, member);
        }
    }

    @Override
    public Collection<RfNamedElement> internalGetRawLocalMembers() {
        return this.members == null ? null : this.members.values();
    }

    @Override
    public Collection<RfNamedElement> getLocalMembers() {
        return this.members == null ? null : this.members.values();
    }

    @Override
    public boolean hasLocalMembers() {
        return this.members != null && !this.members.isEmpty();
    }

    @Override
    public List<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        if (this.members == null) {
            return Collections.emptyList();
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfNamedElement member : this.members.values()) {
            if (member == null) continue;
            if (member instanceof RfExtendDuplicate) {
                result.addAll(member.getLocalMembers(determinant, classes));
            }
            if (classes != null && !classes.contains(member.getClass())) continue;
            result.add(member);
        }
        return result;
    }

    @Override
    public void collectMembersForElab(Map<String, RfNamedElement> result, Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, boolean collectPredefinedAndActionQualifiedFields, IRfElementFilter elementFilter) {
        if (this.members == null) {
            return;
        }
        for (RfNamedElement member : this.members.values()) {
            if (member == null || member instanceof RfField && ((RfField)member).isActionQualified()) continue;
            if (member instanceof RfFieldWrapper) {
                member = ((RfFieldWrapper)member).getWrappedElement();
            }
            if (classes != null && !classes.contains(member.getClass()) || determinant != null && !determinant.contains(member.getPackageName()) || elementFilter != null && !elementFilter.validElement((IRfNamedElement)member)) continue;
            int duplicateCount = 0;
            String name = member.getName();
            while (result.containsKey(name)) {
                name = Utils.append(member.getName(), "@", ++duplicateCount);
            }
            result.put(name, member);
        }
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (this.members == null) {
            return;
        }
        for (RfNamedElement member : this.members.values()) {
            if (member == null) continue;
            if (member instanceof RfExtendDuplicate) {
                member.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
                continue;
            }
            if (clazz != null && !clazz.isInstance(member) || !elementFilter.validElement((IRfNamedElement)member) || prefix != null && !prefix.isEmpty() && !DVTStringUtil.regionMatches((String)member.getName(), (String)prefix, (int)matchType)) continue;
            result.add(member);
            if (result.size() != elementFilter.resultMaxSize()) continue;
            throw new MaxSizeReachedException();
        }
    }

    protected void swapElement(RfNamedElement element) {
        if (this.members != null) {
            this.members.swap((Object)element.getKey());
        }
    }

    @Override
    public RfNamedElement getNamedElement() {
        return this;
    }
}

