/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.MethodKind;
import ro.amiq.pssdt.model.reflection.RfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfMethodDef;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.ArgInfo;
import ro.amiq.pssdt.parser.SemanticWalker;

public class RfMethod
extends RfMembersContainer
implements IRfAssociatedType {
    public static final int PURE = 1;
    public static final int TARGET = 2;
    public static final int SOLVE = 4;
    private MethodKind methodKind;
    private DataType associatedDataType;
    protected RfNamedElement associatedType;
    private int qualifiers;

    public RfMethod(String name, DataType dataType) {
        super(name);
        this.associatedDataType = dataType;
        this.methodKind = MethodKind.METHOD;
    }

    public void setQualifiers(int qualifiers) {
        this.qualifiers = qualifiers;
    }

    public boolean hasQualifier(int qualifier) {
        return (this.qualifiers & qualifier) == qualifier;
    }

    public void setDataType(DataType dataType) {
        this.associatedDataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.associatedDataType;
    }

    public String getInitialValue() {
        return null;
    }

    public boolean isArgumentsCheck() {
        return true;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_FUNCTION: Duplicate function ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public void setMethodKind(MethodKind methodKind) {
        this.methodKind = methodKind;
    }

    public MethodKind getMethodKind() {
        return this.methodKind;
    }

    @Override
    public boolean getAssociatedTypeArray() {
        if (this.associatedDataType == null) {
            return false;
        }
        return this.associatedDataType.getArrayDim() != null;
    }

    @Override
    public String getAssociatedTypeArrayDim() {
        if (this.associatedDataType == null || this.associatedDataType.getArrayDim() == null) {
            return "";
        }
        return this.associatedDataType.getArrayDim();
    }

    public String getAssociatedTypeName() {
        if (this.associatedDataType == null) {
            return this.associatedType == null ? "" : this.associatedType.getName();
        }
        return this.associatedDataType.getTypeName();
    }

    public RfNamedElement getAssociatedBaseType() {
        if (this.associatedType instanceof RfCollectionType) {
            return ((RfCollectionType)this.associatedType).getAssociatedBaseType();
        }
        return this.associatedType;
    }

    public RfNamedElement getAssociatedType() {
        if (this.associatedType instanceof RfAssociatedType.RfLazyCollectionType) {
            DataType dataType = this.getDataType();
            if (dataType == null) {
                this.associatedType = SemanticWalker.UNRESOLVED_ELEMENT;
                return this.associatedType;
            }
            DataType.CollectionKind containerKind = dataType.getContainerKind();
            if (containerKind == DataType.CollectionKind.LIST || containerKind == DataType.CollectionKind.SET) {
                RfProject rfProject = this.getRfProject();
                RfNamedElement keyElementType = containerKind == DataType.CollectionKind.SET ? ((RfAssociatedType.RfLazyCollectionType)this.associatedType).getBaseType() : null;
                RfNamedElement valueElementType = containerKind == DataType.CollectionKind.LIST ? ((RfAssociatedType.RfLazyCollectionType)this.associatedType).getBaseType() : null;
                this.associatedType = RfCollectionType.createInitCollection(rfProject, dataType, containerKind);
                ((RfCollectionType)this.associatedType).setAssociatedType(rfProject, keyElementType, valueElementType);
                return this.associatedType;
            }
            this.associatedType = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        return this.associatedType;
    }

    public void setAssociatedType(RfNamedElement namedElement) {
        if (namedElement instanceof RfTemplateParam.RfInstanceTypeParam) {
            this.associatedDataType = ((RfTemplateParam.RfInstanceTypeParam)namedElement).getDataType();
            this.associatedType = ((RfTemplateParam.RfInstanceTypeParam)namedElement).getAssociatedType();
        } else {
            this.associatedType = namedElement;
        }
    }

    public Image getImage() {
        switch (this.methodKind) {
            case SYMBOL: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_SYMBOL);
            }
            case METHOD: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
    }

    public String getSignature() {
        String accessStatic = SemanticUtils.hasStaticAccess(this) ? "static " : "";
        switch (this.methodKind) {
            case SYMBOL: {
                return "symbol " + this.getName() + "(" + this.getArgs(true, true, false) + ")";
            }
        }
        return "function " + accessStatic + this.getName() + "(" + this.getArgs(true, true, false) + ")" + " : " + this.getAssociatedTypeName();
    }

    @Override
    public String getContextType() {
        return null;
    }

    public List<RfField> getArguments() {
        ArrayList<RfField> result = new ArrayList<RfField>();
        if (this.members != null && !this.members.isEmpty()) {
            for (RfNamedElement member : this.members) {
                FieldModifier fieldModifier;
                if (!(member instanceof RfField) || (fieldModifier = ((RfField)member).getFieldModifier()) != FieldModifier.SYMBOL_PARAM && fieldModifier != FieldModifier.METHOD_PARAM && fieldModifier != FieldModifier.VARIADIC_PARAM) continue;
                result.add((RfField)member);
            }
        }
        return result;
    }

    public String getArgs(boolean addName, boolean hasType, boolean asTemplateVariables) {
        StringBuilder result = new StringBuilder();
        List<RfField> arguments = this.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return result.toString();
        }
        Iterator argIt = arguments.iterator();
        while (argIt.hasNext()) {
            RfNamedElement arg = (RfNamedElement)argIt.next();
            if (addName && asTemplateVariables) {
                result.append("${").append(arg.getName()).append("}");
            } else if (addName) {
                result.append(arg.getName());
            }
            if (addName && hasType) {
                result.append(" : ");
            }
            if (hasType) {
                result.append(((RfField)arg).getAssociatedTypeName());
            }
            if (!argIt.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public boolean isSymbol() {
        return this.methodKind != null && this.methodKind == MethodKind.SYMBOL;
    }

    public String getForeignMethodName() {
        ArrayList<RfMethod> hids = new ArrayList<RfMethod>();
        RfNamedElement enclosing = this;
        do {
            hids.add((RfMethod)enclosing);
        } while (!(enclosing instanceof RfPackage) && (!(enclosing instanceof RfStruct) || !((RfStruct)enclosing).isComponent()) && (enclosing = enclosing.getEnclosingScope()) != null);
        Collections.reverse(hids);
        StringBuilder result = new StringBuilder();
        for (RfNamedElement rfNamedElement : hids) {
            if (result.length() > 0) {
                result.append("____");
            }
            result.append(rfNamedElement.getName());
        }
        return result.toString();
    }

    public Class<?>[] getForeignMethodParameterTypes() {
        List<RfField> arguments = this.getArguments();
        ArrayList<Class<Object>> result = new ArrayList<Class<Object>>();
        if (arguments == null || arguments.isEmpty()) {
            return null;
        }
        for (RfField argument : arguments) {
            RfNamedElement assocType = argument.getAssociatedType();
            if (assocType instanceof RfTypeAlias) {
                assocType = ((RfTypeAlias)assocType).getAssociatedType();
            }
            if (assocType != null) {
                if (assocType.getName().equals("string")) {
                    result.add(String.class);
                }
                if (assocType.getName().equals("int")) {
                    result.add(Integer.TYPE);
                }
                if (!assocType.getName().equals("bit")) continue;
                result.add(Integer.TYPE);
                continue;
            }
            result.add(Object.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    @Override
    public boolean isStructType() {
        return this.associatedType instanceof RfStruct || this.associatedType instanceof RfCollectionType && ((RfCollectionType)this.associatedType).isStructType();
    }

    @Override
    public boolean isComponentType() {
        return this.associatedType instanceof RfStruct || this.associatedType instanceof RfCollectionType && ((RfCollectionType)this.associatedType).isComponentType();
    }

    @Override
    public boolean isContainerType() {
        return this.associatedDataType.getContainerKind() != null || this.associatedType instanceof RfCollectionType;
    }

    public AST getNodeAST() {
        Collection declarations = this.getDeclarations();
        if (declarations == null || declarations.isEmpty()) {
            return null;
        }
        for (RfDefElement declaration : declarations) {
            if (declaration.getNodeAST() == null) continue;
            return declaration.getNodeAST();
        }
        return null;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (!(currentLayer instanceof RfMethodDef)) {
            return;
        }
        Collection declarations = this.getDeclarations();
        if (declarations == null) {
            return;
        }
        DataType currDataType = ((RfMethodDef)currentLayer).getDataType();
        boolean isPure = this.hasQualifier(1);
        ParserPath parserPath = currentLayer.getParserPath();
        List<ArgInfo> currArgInfos = ((RfMethodDef)currentLayer).getArgInfos();
        boolean hasDefault = false;
        RfDefElement declaration = (RfDefElement)declarations.get(0);
        boolean isDeclarationLayer = currentLayer == declaration;
        int i = 0;
        while (i < currArgInfos.size()) {
            ArgInfo currArgInfo = currArgInfos.get(i);
            int startOffset = currArgInfo.getStartOffset();
            int endOffset = startOffset + currArgInfo.getName().length();
            int startLine = currArgInfo.getStartLine();
            DataType currArgDataType = currArgInfo.getDataType();
            int currDirection = currArgDataType.getRawDirection();
            if (isDeclarationLayer && isPure && (currDirection == 2 || currDirection == 3)) {
                project.addSemanticError(1, "ILLEGAL_DECLARATION: Pure-function ''{1}'' illegal argument ''{0}'' direction (only input arguments are allowed)", null, startOffset, endOffset, null, startLine, parserPath, currArgInfo.getName(), this.getName());
                return;
            }
            if (isDeclarationLayer && hasDefault && !currArgInfo.hasDefault()) {
                project.addSemanticError(1, "FUNCTION_SIGNATURE: Argument ''{0}'' following an argument with default value must also have default value", null, startOffset, endOffset, null, startLine, parserPath, currArgInfo.getName());
                return;
            }
            if (!isDeclarationLayer && currArgInfo.hasDefault()) {
                int declStartLine = declaration.getStartLine();
                ParserPath declParserPath = declaration.getParserPath();
                project.addSemanticError(1, "FUNCTION_SIGNATURE: Argument ''{0}'' default value should be provided in prototype\n    at line {1,number,#######} in {2}", null, startOffset, endOffset, null, startLine, parserPath, currArgInfo.getName(), declStartLine, declParserPath);
                return;
            }
            hasDefault |= currArgInfo.hasDefault();
            ++i;
        }
        int startOffset = currentLayer.getStartOffset();
        int endOffset = startOffset + this.getName().length();
        int startLine = currentLayer.getStartLine();
        ParserPath parserPath2 = currentLayer.getParserPath();
        if (isPure && currDataType != null && "void".equals(currDataType.getTypeName())) {
            project.addSemanticError(1, "ILLEGAL_DECLARATION: Pure-function ''{0}'' illegal ''void'' return type", null, startOffset, endOffset, null, startLine, parserPath2, this.getName());
            return;
        }
        boolean hasErrors = false;
        for (RfDefElement declaration2 : declarations) {
            if (declaration2 == currentLayer) break;
            int prevStartLine = declaration2.getStartLine();
            ParserPath prevParserPath = declaration2.getParserPath();
            if (declaration2.isIs() && currentLayer.isIs()) {
                project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath2, this.getName(), prevStartLine, prevParserPath);
                hasErrors = true;
                continue;
            }
            if (declaration2.isIs() || currentLayer.isIs()) continue;
            project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath2, this.getName(), prevStartLine, prevParserPath);
            hasErrors = true;
        }
        if (hasErrors) {
            return;
        }
        List<ArgInfo> currArgInfos2 = ((RfMethodDef)currentLayer).getArgInfos();
        for (RfDefElement declaration3 : declarations) {
            if (declaration3 == currentLayer) break;
            int prevStartLine = declaration3.getStartLine();
            ParserPath prevParserPath = declaration3.getParserPath();
            DataType prevDataType = ((RfMethodDef)declaration3).getDataType();
            List<ArgInfo> prevArgInfos = ((RfMethodDef)declaration3).getArgInfos();
            if (currDataType != null && !currDataType.equals(prevDataType)) {
                project.addSemanticError(1, "FUNCTION_SIGNATURE: Return type of function definition ''{0}'' does not match prototype\n    at line {1,number,#######} in {2}", null, startOffset, endOffset, null, startLine, parserPath2, this.getName(), prevStartLine, prevParserPath);
                return;
            }
            if (currArgInfos2.size() != prevArgInfos.size()) {
                project.addSemanticError(1, "FUNCTION_SIGNATURE: Number of arguments of function definition ''{0}'' does not match prototype\n    at line {1,number,#######} in {2}", null, startOffset, endOffset, null, startLine, parserPath2, this.getName(), prevStartLine, prevParserPath);
                return;
            }
            int i2 = 0;
            while (i2 < currArgInfos2.size()) {
                ArgInfo currArgInfo = currArgInfos2.get(i2);
                ArgInfo prevArgInfo = prevArgInfos.get(i2);
                startOffset = currArgInfo.getStartOffset();
                endOffset = startOffset + currArgInfo.getName().length();
                startLine = currArgInfo.getStartLine();
                if (!currArgInfo.getName().equals(prevArgInfo.getName())) {
                    project.addSemanticError(1, "FUNCTION_SIGNATURE: Argument ''{0}'' of function definition ''{1}'' does not match prototype\n    at line {2,number,#######} in {3}", null, startOffset, endOffset, null, startLine, parserPath2, currArgInfo.getName(), this.getName(), prevStartLine, prevParserPath);
                    return;
                }
                DataType currArgDataType = currArgInfo.getDataType();
                DataType prevArgDataType = prevArgInfo.getDataType();
                currArgDataType.setInitialValue(prevArgDataType);
                if (!currArgDataType.equals(prevArgDataType)) {
                    project.addSemanticError(1, "FUNCTION_SIGNATURE: Argument ''{0}'' type of function definition ''{1}'' does not match prototype\n    at line {2,number,#######} in {3}", null, startOffset, endOffset, null, startLine, parserPath2, currArgInfo.getName(), this.getName(), prevStartLine, prevParserPath);
                    return;
                }
                int currDirection = currArgDataType.getRawDirection();
                int prevDirection = prevArgDataType.getRawDirection();
                if (prevDirection != 0 && currDirection != prevDirection) {
                    project.addSemanticError(1, "FUNCTION_SIGNATURE: Argument ''{0}'' direction of function definition ''{1}'' does not match prototype\n    at line {2,number,#######} in {3}", null, startOffset, endOffset, null, startLine, parserPath2, currArgInfo.getName(), this.getName(), prevStartLine, prevParserPath);
                    return;
                }
                if (currArgInfo.hasDefault()) {
                    project.addSemanticError(1, "FUNCTION_SIGNATURE: Argument ''{0}'' default value should be provided in prototype\n    at line {1,number,#######} in {2}", null, startOffset, endOffset, null, startLine, parserPath2, currArgInfo.getName(), prevStartLine, prevParserPath);
                    return;
                }
                ++i2;
            }
        }
    }

    public boolean isVariadic() {
        List<RfField> arguments = this.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return false;
        }
        return Utils.last(arguments).isVariadic();
    }

    public int getAssociatedTypeArrayDimAsInteger() {
        if (this.associatedDataType == null || this.associatedDataType.getArrayDim() == null) {
            return -1;
        }
        return this.associatedDataType.getArrayDimAsInteger();
    }

    @Override
    public int sizeof() {
        RfNamedElement assocType = this.getAssociatedType();
        if (assocType instanceof RfPredefinedEnumType) {
            return 32;
        }
        if (assocType instanceof RfCollectionType) {
            return assocType.sizeof();
        }
        if (assocType instanceof RfTypeAlias) {
            return assocType.sizeof();
        }
        if (assocType instanceof RfStruct) {
            return assocType.sizeof();
        }
        DataType dataType = this.getDataType();
        if (dataType == null) {
            throw new UnsupportedOperationException();
        }
        return dataType.nofBits();
    }
}

