/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.pssdt.model.reflection.AmbiguousAccessError;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfClassType;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfExtendDuplicate;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfImportElement;
import ro.amiq.pssdt.model.reflection.RfKind;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumItem;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumType;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfScopeDefElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.TransitiveAccessError;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.model.reflection.util.NoDuplicatesCollectionWrapper;
import ro.amiq.pssdt.model.reflection.util.VisitedCheck;

public abstract class RfNamedElement
implements IDVTMapElement<String>,
IRfNamedElement {
    public static final String ANONYMOUS_PREFIX = "[anonymous:";
    public static final String ANONYMOUS_SUFIX = "]";
    private String name;
    private boolean isEscaped;
    private List<RfDefElement> layers;
    private boolean unsortedLayers;
    private RfNamedElement enclosingScope;
    private boolean isConstraintUsed;

    static {
        DVTRfUtils.MEMBERS_TYPES.add(RfPackage.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfStruct.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfTemplateStruct.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfTemplateInstance.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfEnumType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfPredefinedEnumType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfTypeAlias.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfField.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfTemplateParam.RfTemplateTypeParam.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfTemplateParam.RfTemplateValueParam.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfField.RfIteratorField.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfField.RfIndexField.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPredefinedField.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfLibrary.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPackage.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfBlock.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfEnumItem.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPredefinedEnumItem.class);
    }

    public RfNamedElement(String name) {
        String unescapedName;
        this.name = unescapedName = DVTStringUtil.unescapeIdentifier((String)name, (boolean)true);
        this.isEscaped = unescapedName != null && name.length() > unescapedName.length();
    }

    public boolean isPublic() {
        return true;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (currentLayer != null && currentLayer.isIs()) {
            if (this instanceof RfField && (((RfField)this).isIndex() || ((RfField)this).isIterator())) {
                RfNamedElement enclosingBlock = this.enclosingScope;
                while ((enclosingBlock = enclosingBlock.getEnclosingScope()) instanceof RfBlock) {
                    RfNamedElement existing = enclosingBlock.getLocalMember(null, RfProject.FIELD_CLASSES, this.name, false, null);
                    if (existing == null || existing == this || existing.getEnclosingScope() != enclosingBlock) continue;
                    RfDefElement layer = existing.getDeclaration();
                    if (layer == null) {
                        return;
                    }
                    int startOffset = currentLayer.getStartOffset();
                    int endOffset = startOffset + this.getName().length();
                    int startLine = currentLayer.getStartLine();
                    ParserPath parserPath = currentLayer.getParserPath();
                    int prevStartLine = layer.getStartLine();
                    ParserPath prevParserPath = layer.getParserPath();
                    project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
                }
                return;
            }
            List<RfDefElement> layers = this.getLayers();
            if (layers.size() > 1) {
                for (RfDefElement layer : layers) {
                    if (layer == currentLayer) break;
                    int startOffset = currentLayer.getStartOffset();
                    int endOffset = startOffset + this.getName().length();
                    int startLine = currentLayer.getStartLine();
                    ParserPath parserPath = currentLayer.getParserPath();
                    int prevStartLine = layer.getStartLine();
                    ParserPath prevParserPath = layer.getParserPath();
                    project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
                }
            }
        }
    }

    @Deprecated
    public final IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, boolean isFirst, boolean isLast, boolean recursiveCall) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    @Deprecated
    public final IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    public void deepClean() {
        this.enclosingScope = null;
        if (this.layers != null && !this.layers.isEmpty()) {
            for (RfDefElement layer : this.layers) {
                layer.deepClean();
            }
            this.layers.clear();
        }
        this.layers = null;
    }

    public final RfNamedElement getMember(RfDefElement lexicalScope, Determinant determinant, String name, boolean isAmbiguousCheck, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        if (this instanceof RfLibrary) {
            determinant = RfPackage.ANY_DETERMINANT;
        } else if (this instanceof RfPackage) {
            determinant = ((RfPackage)this).getDeterminant(SemanticUtils.getLexicalScope(lexicalScope));
        }
        LinkedHashSet<RfNamedElement> result = new LinkedHashSet<RfNamedElement>();
        this.internalGetMember(result, lexicalScope, determinant, new VisitedCheck(), name, isAmbiguousCheck, false, isFirst, classes, filter);
        if (result.isEmpty()) {
            this.internalGetMember(result, lexicalScope, determinant, new VisitedCheck(), name, isAmbiguousCheck, true, isFirst, classes, filter);
        }
        if (result.isEmpty()) {
            return null;
        }
        Iterator iterator = result.iterator();
        if (result.size() == 2) {
            return isAmbiguousCheck ? new AmbiguousAccessError((RfNamedElement)iterator.next(), (RfNamedElement)iterator.next()) : (RfNamedElement)iterator.next();
        }
        return (RfNamedElement)iterator.next();
    }

    protected void internalGetMember(Set<RfNamedElement> result, RfDefElement lexicalScope, Determinant determinant, VisitedCheck visited, String name, boolean isAmbiguousCheck, boolean isTransitiveImport, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter elementFilter) {
        boolean hasLocalElements;
        if (visited.isVisited(this, 7)) {
            return;
        }
        boolean isResultEmpty = result.isEmpty();
        if (!visited.isVisited(this, 1)) {
            visited.visit(this, 1);
            RfNamedElement candidate = this.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
            if (candidate == null && this instanceof RfClassType) {
                IRfClassType parent = (RfClassType)this;
                while (candidate == null && (parent = parent.getParent()) != null) {
                    if (visited.isVisited(parent, 1)) break;
                    visited.visit(parent, 1);
                    candidate = parent.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
                }
            }
            if (candidate != null) {
                this.internalAddMember(result, candidate, isTransitiveImport);
                if (!isAmbiguousCheck && !result.isEmpty() || result.size() > 1) {
                    return;
                }
            }
        }
        boolean bl = hasLocalElements = !result.isEmpty() && isResultEmpty;
        if (hasLocalElements) {
            return;
        }
        if (!visited.isVisited(this, 2)) {
            visited.visit(this, 2);
            List<RfImportElement> importedElements = this.getImportedElements(SemanticUtils.getLexicalScope(lexicalScope));
            if ((isFirst || isTransitiveImport) && importedElements != null && !importedElements.isEmpty()) {
                boolean isRelevantImportLayer = false;
                for (RfImportElement importedElement : importedElements) {
                    if (importedElement == null || visited.isVisited(importedElement, 2)) continue;
                    RfMembersContainer importedScope = importedElement.getElement();
                    if (importedElement.isWildcard()) {
                        if (importedScope.isEnclosingOf(this)) continue;
                        if ((classes == null || classes.contains(importedScope.getClass())) && name.equals(importedScope.getName())) {
                            this.internalAddMember(result, importedScope, isTransitiveImport);
                            isRelevantImportLayer = true;
                            if (!isAmbiguousCheck && !result.isEmpty() || result.size() > 1) {
                                return;
                            }
                        }
                        Determinant tempDeterminant = importedScope.getDeterminant(SemanticUtils.getLexicalScope(lexicalScope));
                        visited.visit(importedScope, 4);
                        int beforeSize = result.size();
                        importedScope.internalGetMember(result, null, tempDeterminant, visited, name, isAmbiguousCheck, isTransitiveImport, false, classes, elementFilter);
                        isRelevantImportLayer = result.size() > beforeSize;
                        visited.remove(importedScope, 4);
                        if (!isAmbiguousCheck && !result.isEmpty() || result.size() > 1) {
                            return;
                        }
                    } else if (classes == null || classes.contains(importedScope.getClass())) {
                        if (name.equals(importedScope.getName())) {
                            this.internalAddMember(result, importedScope, isTransitiveImport);
                            isRelevantImportLayer = true;
                            if (!isAmbiguousCheck && !result.isEmpty() || result.size() > 1) {
                                return;
                            }
                        }
                        visited.visit(importedScope, 2);
                    }
                    boolean isEnclosingScopeImport = this.isEnclosingElement(lexicalScope, importedElement.getElement());
                    if (!isRelevantImportLayer || elementFilter == null || isEnclosingScopeImport || elementFilter.validImport((IRfNamedElement)importedElement)) continue;
                    elementFilter.setImportLayer((IRfNamedElement)importedElement);
                }
            }
        }
        if (!result.isEmpty()) {
            return;
        }
        if (!isFirst) {
            return;
        }
        if (this instanceof RfPredefinedType) {
            return;
        }
        if (elementFilter instanceof InnerScopeElementFileter) {
            return;
        }
        if (!visited.isVisited(this, 4)) {
            RfDefElement enclosingLexicalScope;
            visited.visit(this, 4);
            RfNamedElement enclosing = null;
            RfDefElement rfDefElement = enclosingLexicalScope = lexicalScope == null ? null : lexicalScope.getParentLexicalScope();
            enclosing = enclosingLexicalScope == null || enclosingLexicalScope instanceof RfFileDef ? (this instanceof RfPackage ? this.getEnclosingScope() : (RfNamedElement)this.getEnclosingScope(RfPackage.class)) : enclosingLexicalScope.getNamedElement();
            if (enclosing == null || enclosing instanceof RfProject || this instanceof RfPredefinedType) {
                return;
            }
            if (enclosing instanceof RfLibrary) {
                determinant = RfPackage.ANY_DETERMINANT;
            } else if (enclosing instanceof RfPackage && !((RfPackage)enclosing).isMainPackage()) {
                determinant = Determinant.extend(determinant, enclosing.getName());
            }
            if (this instanceof RfClassType && enclosing instanceof RfClassType) {
                elementFilter = EnclosingScopeElementFileter.create(elementFilter);
            } else if (this instanceof RfCovergroup && !((RfCovergroup)this).isInline()) {
                elementFilter = EnclosingScopeElementFileter.create(elementFilter);
            }
            enclosing.internalGetMember(result, enclosingLexicalScope, determinant, visited, name, isAmbiguousCheck, isTransitiveImport, isFirst, classes, elementFilter);
        }
    }

    private boolean isEnclosingElement(RfDefElement lexicalScope, RfMembersContainer namedElement) {
        if (lexicalScope == null) {
            return false;
        }
        RfDefElement tempLexicalScope = lexicalScope;
        do {
            if (tempLexicalScope.getNamedElement() != namedElement) continue;
            return true;
        } while ((tempLexicalScope = tempLexicalScope.getParentLexicalScope()) != null);
        return false;
    }

    protected boolean isEnclosingOf(RfNamedElement rfNamedElement) {
        RfNamedElement enclosingScope = rfNamedElement;
        do {
            if (enclosingScope != this) continue;
            return true;
        } while ((enclosingScope = enclosingScope.getEnclosingScope()) != null);
        return false;
    }

    protected void internalAddMember(Set<RfNamedElement> result, RfNamedElement candidate, boolean isTransitiveImport) {
        RfNamedElement rfNamedElement = candidate = isTransitiveImport ? new TransitiveAccessError(candidate) : candidate;
        if (result.isEmpty()) {
            result.add(candidate);
            return;
        }
        RfNamedElement candidateEnclosingScope = candidate.getEnclosingScope();
        if (!(candidateEnclosingScope instanceof RfTemplateInstance)) {
            result.add(candidate);
            return;
        }
        RfNamedElement existing = result.iterator().next();
        RfNamedElement existingEnclosingScope = existing.getEnclosingScope();
        if (!(existingEnclosingScope instanceof RfTemplateInstance)) {
            result.add(candidate);
            return;
        }
        result.add(candidate);
    }

    public List<RfImportElement> getImportedElements(RfScopeDefElement lexicalScope) {
        return null;
    }

    public RfNamedElement getEnclosingScope() {
        return this.enclosingScope;
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        RfNamedElement scope = this;
        do {
            if (!clazz.isInstance(scope)) continue;
            return (T)scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        return null;
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    public RfProject getRfProject() {
        if (this.enclosingScope == null) {
            return null;
        }
        return this.enclosingScope.getRfProject();
    }

    public String getName() {
        return this.name;
    }

    public String getElabName() {
        return this.getName();
    }

    public String getLowerCaseName() {
        return this.name == null ? null : this.name.toLowerCase();
    }

    public String getNameForNoDuplicateList() {
        return this.getName();
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public RfDefElement getDeclaration() {
        List<RfDefElement> sortedLayers = this.getLayers();
        if (sortedLayers == null || sortedLayers.isEmpty()) {
            return null;
        }
        return sortedLayers.get(0);
    }

    public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
        return null;
    }

    public String getComment() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return "";
        }
        String comment = declaration.getDefComment();
        if (comment == null) {
            return "";
        }
        return comment;
    }

    public String getRawUntrimmedComment(String inlineAboveDelimiter) {
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return "";
        }
        CommentBlock declarationCommentBlock = declaration.getCommentBlock();
        if (declarationCommentBlock == null) {
            return "";
        }
        return declarationCommentBlock.toRawUntrimmedString(inlineAboveDelimiter);
    }

    public boolean checkEquals(Object obj) {
        return obj == this;
    }

    public boolean isPredefined() {
        return false;
    }

    public Image testGetImage(String imageName) {
        return null;
    }

    public List<RfDefElement> getDeclarations() {
        return this.getLayers();
    }

    public IResource getFileAdapter() {
        return null;
    }

    public boolean hasNoDefs(boolean rawDefs) {
        return this.layers == null || this.layers.isEmpty();
    }

    public int getLine() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getStartLine();
        }
        return 0;
    }

    public IRfLibraryElement getEnclosingLibrary() {
        return null;
    }

    public List<? extends IRfInstanceElement> getBindInstances(long useCacheTimestamp) {
        return null;
    }

    public List<Hid> getHids(HidQualifier[] qualifiers, boolean local) {
        return null;
    }

    public List<IHidOperator> getHidOperators(HidOperatorQualifier[] qualifiers, boolean local) {
        return null;
    }

    public boolean visitHidObject(IRfSingleLangProject project, IHidVisitor<?> visitor) {
        return false;
    }

    public IHidHolder getHidHolder() {
        return null;
    }

    public String getNameForDiagram() {
        return this.getName();
    }

    public LibraryPackageScope getLibPkgScope() {
        return null;
    }

    public boolean isDirtyElement() {
        return false;
    }

    public Collection<RfNamedElement> internalGetRawLocalMembers() {
        return null;
    }

    public Collection<RfNamedElement> getLocalMembers() {
        return null;
    }

    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter filter) {
        return null;
    }

    @Deprecated
    public final void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        DVTLogger.INSTANCE.logError("Unused API");
    }

    public final void getElementsWithPrefix(Collection<IRfNamedElement> result, RfDefElement lexicalScope, Determinant determinant, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        try {
            Collection<IRfNamedElement> noDuplicatesResultWrapper = NoDuplicatesCollectionWrapper.wrap(result);
            this.internalGetMembers(new VisitedCheck(), lexicalScope, noDuplicatesResultWrapper, determinant, null, prefix, matchType, local, isFirst, accessModifier, elementFilter);
        }
        catch (MaxSizeReachedException maxSizeReachedException) {}
    }

    protected <T extends IRfNamedElement> void internalGetMembers(VisitedCheck visited, RfDefElement lexicalScope, Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        Assert.isNotNull((Object)elementFilter);
        if (visited.isVisited(this, 7)) {
            return;
        }
        if (!visited.isVisited(this, 1)) {
            visited.visit(this, 1);
            this.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
            if (local == 1) {
                return;
            }
            if (this instanceof RfClassType) {
                IRfClassType parentClass = ((RfClassType)this).getParent();
                IRfNamedElement.AccessModifier accessModifier2 = accessModifier = accessModifier == IRfNamedElement.AccessModifier.SHOW_PRIVATE ? IRfNamedElement.AccessModifier.SHOW_PROTECTED : accessModifier;
                if (parentClass != null) {
                    ((RfNamedElement)((Object)parentClass)).internalGetMembers(visited, null, result, determinant, null, prefix, matchType, 2, isFirst, accessModifier, elementFilter);
                }
            }
        }
        if (local == 1) {
            return;
        }
        if (local == 2) {
            return;
        }
        if (!visited.isVisited(this, 2)) {
            List<RfImportElement> importedElements;
            visited.visit(this, 2);
            if (isFirst && local > 2 && (importedElements = this.getImportedElements(null)) != null && !importedElements.isEmpty()) {
                for (RfImportElement importedElement : importedElements) {
                    if (importedElement == null || visited.isVisited(importedElement, 2) || elementFilter != null && importedElement.getElement() != this.enclosingScope && !elementFilter.validImport((IRfNamedElement)importedElement)) continue;
                    RfMembersContainer importedScope = importedElement.getElement();
                    if (importedElement.isWildcard()) {
                        if (importedScope.isEnclosingOf(this)) continue;
                        if ((clazz == null || clazz.isInstance(importedScope)) && elementFilter.validElement((IRfNamedElement)importedScope) && (prefix == null || prefix.isEmpty() || DVTStringUtil.regionMatches((String)importedScope.getName(), (String)prefix, (int)matchType))) {
                            result.add(importedScope);
                            if (result.size() == elementFilter.resultMaxSize()) {
                                throw new MaxSizeReachedException();
                            }
                        }
                        Determinant tempDeterminant = importedScope.getDeterminant(SemanticUtils.getLexicalScope(lexicalScope));
                        visited.visit(importedScope, 4);
                        importedScope.internalGetMembers(visited, null, result, tempDeterminant, null, prefix, matchType, 1, isFirst, accessModifier, elementFilter);
                        visited.remove(importedScope, 4);
                        continue;
                    }
                    if (clazz != null && !clazz.isInstance(importedScope)) continue;
                    visited.visit(importedScope, 2);
                    if (!elementFilter.validElement((IRfNamedElement)importedScope) || prefix != null && !prefix.isEmpty() && !DVTStringUtil.regionMatches((String)importedScope.getName(), (String)prefix, (int)matchType)) continue;
                    result.add(importedScope);
                    if (result.size() != elementFilter.resultMaxSize()) continue;
                    throw new MaxSizeReachedException();
                }
            }
        }
        if (local > 3) {
            if (elementFilter instanceof InnerScopeElementFileter) {
                return;
            }
            if (!isFirst) {
                return;
            }
            if (this instanceof RfPredefinedType) {
                return;
            }
            if (elementFilter instanceof InnerScopeElementFileter) {
                return;
            }
            if (!visited.isVisited(this, 4)) {
                RfDefElement enclosingLexicalScope;
                visited.visit(this, 4);
                RfNamedElement enclosing = null;
                RfDefElement rfDefElement = enclosingLexicalScope = lexicalScope == null ? null : lexicalScope.getParentLexicalScope();
                if (enclosingLexicalScope == null || enclosingLexicalScope instanceof RfFileDef) {
                    enclosing = this instanceof RfPackage ? this.getEnclosingScope() : (RfNamedElement)this.getEnclosingScope(RfPackage.class);
                    enclosingLexicalScope = null;
                } else {
                    enclosing = enclosingLexicalScope.getNamedElement();
                }
                if (enclosing == null || enclosing instanceof RfProject || this instanceof RfPredefinedType) {
                    return;
                }
                if (enclosing instanceof RfLibrary) {
                    determinant = RfPackage.ANY_DETERMINANT;
                } else if (enclosing instanceof RfPackage && !((RfPackage)enclosing).isMainPackage()) {
                    determinant = Determinant.extend(determinant, enclosing.getName());
                }
                if (this instanceof RfClassType && enclosing instanceof RfClassType) {
                    elementFilter = EnclosingScopeElementFileter.create(elementFilter);
                } else if (this instanceof RfCovergroup && !((RfCovergroup)this).isInline()) {
                    elementFilter = EnclosingScopeElementFileter.create(elementFilter);
                }
                enclosing.internalGetMembers(visited, enclosingLexicalScope, result, determinant, clazz, prefix, matchType, local, isFirst, accessModifier, elementFilter);
            }
        }
    }

    public boolean hasLocalMembers() {
        return false;
    }

    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    public Class<? extends IRfNamedElement> getCustomClass() {
        return this.getClass();
    }

    @Deprecated
    public final <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        DVTLogger.INSTANCE.logError("Unused API");
    }

    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
    }

    public boolean hasReferenceToIdentifierName(String name) {
        return false;
    }

    public String getKindName() {
        return RfKind.of(this).getName();
    }

    public boolean isNonStandard() {
        return false;
    }

    public String elementPathName() {
        return this.getName();
    }

    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        return this.getLocalMember(RfPackage.ANY_DETERMINANT, classes, name, false, null);
    }

    public String getKey() {
        return this.getName();
    }

    protected void addMember(String packageName, boolean isExtendLayer, RfNamedElement element) {
    }

    protected void removeDirtyElements(Iterator<? extends RfNamedElement> iterator, boolean isRemoveImports, ParserPath parserPath, RfProject project) {
        while (iterator.hasNext()) {
            List<RfTemplateParam> parameters;
            Collection<RfNamedElement> children;
            RfNamedElement member = iterator.next();
            if (member instanceof RfMembersContainer && (children = member.internalGetRawLocalMembers()) != null && !children.isEmpty()) {
                this.removeDirtyElements(children.iterator(), isRemoveImports, parserPath, project);
            }
            if (member instanceof RfTemplateStruct && (parameters = ((RfTemplateStruct)member).getParameters()) != null && !parameters.isEmpty()) {
                this.removeDirtyElements(parameters.iterator(), isRemoveImports, parserPath, project);
            }
            if (member instanceof RfExtendDuplicate) {
                children = member.internalGetRawLocalMembers();
                if (children != null && !children.isEmpty()) {
                    this.removeDirtyElements(children.iterator(), isRemoveImports, parserPath, project);
                }
                if (children == null || !children.isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (member.isPredefined() || !member.hasNoDefs(false)) continue;
            iterator.remove();
        }
    }

    protected void removeDirtyElements(ParserPath parserPath, boolean isRemoveImports, RfProject project) {
        Collection<RfNamedElement> members = this.getLocalMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        this.removeDirtyElements(members.iterator(), isRemoveImports, parserPath, project);
    }

    protected boolean internalCheckExisting(RfNamedElement existing, RfNamedElement element) {
        return false;
    }

    public abstract String getContextType();

    public abstract String getSemanticErrorCodeForDuplicate();

    public void setEnclosingScope(RfNamedElement enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    public void addLayer(RfProject project, RfDefElement layer) {
        layer.addNamedElement(this);
        if (this.layers == null) {
            this.layers = new ArrayList<RfDefElement>();
        }
        this.layers.add(layer);
        this.unsortedLayers = true;
    }

    private void sortLayers() {
        if (this.layers == null) {
            return;
        }
        Collections.sort(this.layers);
    }

    protected void reorderLayers() {
        this.sortLayers();
    }

    protected void removeLayer(RfDefElement layer) {
        this.isConstraintUsed = false;
        if (this.layers == null || this.layers.isEmpty() || layer == null) {
            return;
        }
        this.unsortedLayers = true;
        this.layers.remove(layer);
    }

    public List<RfDefElement> getLayers() {
        if (this.layers == null) {
            return Collections.emptyList();
        }
        if (this.unsortedLayers) {
            this.sortLayers();
        }
        this.unsortedLayers = false;
        return this.layers;
    }

    public List<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        return null;
    }

    public Collection<RfNamedElement> getMembersForElab(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter elementFilter) {
        LinkedHashMap<String, RfNamedElement> result = new LinkedHashMap<String, RfNamedElement>();
        this.collectMembersForElab(result, determinant, classes, true, elementFilter);
        return result.values();
    }

    public void collectMembersForElab(Map<String, RfNamedElement> result, Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, boolean collectPredefinedAndActionQualifiedFields, IRfElementFilter elementFilter) {
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public boolean isAnonymous() {
        return this.name.startsWith(ANONYMOUS_PREFIX) && this.name.endsWith(ANONYMOUS_SUFIX);
    }

    public RfDefElement getLayerInLikeParent() {
        String name = this.getName();
        IRfClassType parent = this.getEnclosingScope(RfStruct.class);
        while (parent != null && (parent = parent.getParent()) != null) {
            RfNamedElement parentConstraint = parent.getLocalMember(null, Collections.singleton(this.getClass()), name, false, null);
            if (parentConstraint == null) continue;
            return parentConstraint.getDeclaration();
        }
        return null;
    }

    public String getPackageName() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null && declaration.isIs()) {
            return declaration.getPackageName();
        }
        return "main";
    }

    public String toString() {
        return String.valueOf(this.getName()) + " : " + super.toString();
    }

    @Deprecated
    public final Collection<? extends IRfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    @Deprecated
    public final IRfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    public final IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    public void setConstraintUsed() {
        this.isConstraintUsed = true;
    }

    public boolean isConstraintUsed() {
        return this.isConstraintUsed;
    }

    public String printScope() {
        StringBuilder result = new StringBuilder();
        this.printScope(result, false);
        return result.toString();
    }

    public void printScope(StringBuilder result, boolean appendThis) {
        RfNamedElement scope = this.getEnclosingScope();
        if (scope instanceof RfProject) {
            return;
        }
        if (scope != null) {
            scope.printScope(result, true);
        }
        if (appendThis && this.name != null && !this.name.isEmpty()) {
            result.append(this.name).append('.');
        }
    }

    public String getFullNameLabel() {
        return String.valueOf(this.printScope()) + this.getName();
    }

    public boolean isAction(boolean includeAbstract) {
        return false;
    }

    public boolean isComponent() {
        return false;
    }

    public int sizeof() {
        throw new UnsupportedOperationException();
    }

    public boolean isCoreLibMember() {
        String packageName = this.getPackageName();
        if ("std_pkg".equals(packageName)) {
            return true;
        }
        if ("addr_reg_pkg".equals(packageName)) {
            return true;
        }
        if ("executor_pkg".equals(packageName)) {
            return true;
        }
        return this.enclosingScope instanceof RfTemplateInstance && ((RfTemplateInstance)this.enclosingScope).getTemplateStruct().isCoreLibMember();
    }

    public boolean isPackageMember(String packageName) {
        String candidateName = this.getPackageName();
        if (packageName.equals(candidateName)) {
            return true;
        }
        return this.enclosingScope instanceof RfTemplateInstance && ((RfTemplateInstance)this.enclosingScope).getTemplateStruct().isPackageMember(packageName);
    }

    public boolean isExecutorPkgMember() {
        return this.isPackageMember("executor_pkg");
    }

    public boolean isAddrRegPkgMember() {
        return this.isPackageMember("addr_reg_pkg");
    }

    public boolean isCoreLibInstanceOf(String ... names) {
        return false;
    }

    public boolean isNumericType() {
        return false;
    }

    public boolean isFloatType() {
        return false;
    }

    public boolean isInternal() {
        return this.name.startsWith("___internal_");
    }

    public void getQualifiedName(StringBuilder name) {
        if (this.enclosingScope == null) {
            name.append(this.getName());
        } else if (this.enclosingScope instanceof RfPackage && ((RfPackage)this.enclosingScope).isMainPackage()) {
            name.append(this.getName());
        } else {
            this.enclosingScope.getQualifiedName(name);
            name.append("::").append(this.getName());
        }
    }

    public boolean isStatic() {
        return false;
    }

    public IHidBuilders getHidBuilders() {
        return HidUtils.DEFAULT_BUILDERS;
    }

    public static class EnclosingScopeElementFileter
    implements IRfElementFilter {
        private IRfElementFilter prevFilter;

        public static IRfElementFilter create(IRfElementFilter prevFilter) {
            if (prevFilter instanceof InnerScopeElementFileter) {
                throw new UnsupportedOperationException();
            }
            if (prevFilter instanceof EnclosingScopeElementFileter) {
                return prevFilter;
            }
            return new EnclosingScopeElementFileter(prevFilter);
        }

        private EnclosingScopeElementFileter(IRfElementFilter prevFilter) {
            this.prevFilter = prevFilter;
        }

        public boolean validElement(IRfNamedElement candidate) {
            if (candidate instanceof RfPackage || candidate instanceof RfStruct || candidate instanceof RfEnumType || candidate instanceof RfTypeAlias || candidate instanceof RfPredefinedType || candidate instanceof RfCovergroup || candidate instanceof RfTemplateParam.RfTemplateTypeParam) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            if (candidate instanceof RfTemplateParam.RfTemplateValueParam) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            if (candidate instanceof RfField && (((RfField)candidate).getFieldModifier() == FieldModifier.CONST || ((RfField)candidate).getFieldModifier() == FieldModifier.STATIC_CONST)) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            if (candidate instanceof RfPredefinedField && "pss_top".equals(candidate.getName()) && ((RfField)candidate).isInstance()) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            if (candidate instanceof RfMethod) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            return false;
        }

        public int resultMaxSize() {
            return this.prevFilter == null ? 0 : this.prevFilter.resultMaxSize();
        }

        public boolean allowEnumElement() {
            return this.prevFilter == null ? true : this.prevFilter.allowEnumElement();
        }
    }

    public static class InnerScopeElementFileter
    implements IRfElementFilter {
        private IRfElementFilter prevFilter;

        public static IRfElementFilter create(IRfElementFilter prevFilter) {
            if (prevFilter instanceof InnerScopeElementFileter) {
                return prevFilter;
            }
            return new InnerScopeElementFileter(prevFilter);
        }

        private InnerScopeElementFileter(IRfElementFilter prevFilter) {
            this.prevFilter = prevFilter;
        }

        public boolean validElement(IRfNamedElement candidate) {
            return this.prevFilter == null || this.prevFilter.validElement(candidate);
        }

        public int resultMaxSize() {
            return this.prevFilter == null ? 0 : this.prevFilter.resultMaxSize();
        }

        public boolean allowEnumElement() {
            return this.prevFilter == null ? true : this.prevFilter.allowEnumElement();
        }
    }
}

