/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfImportElement;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfScopeDefElement;
import ro.amiq.pssdt.model.reflection.RfStruct;

public class RfPackage
extends RfMembersContainer
implements IRfPackageElement {
    public static final String MAIN_PACKAGE_NAME = "main";
    public static final String STD_PACKAGE_NAME = "std_pkg";
    public static final String ADDR_REG_PACKAGE_NAME = "addr_reg_pkg";
    public static final String EXECUTOR_PACKAGE_NAME = "executor_pkg";
    public static final Determinant MAIN_DETERMINANT = new Determinant(null);
    public static final Determinant ANY_DETERMINANT = new Determinant(null){

        @Override
        public boolean contains(String packageName) {
            return true;
        }
    };

    public RfPackage(String name) {
        super(name);
    }

    public String getSignature() {
        return "package " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
    }

    public IRfNamedElement getImportedSymbol(String symbolName) {
        return null;
    }

    public <T extends IRfNamedElement> void getMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
    }

    @Override
    public boolean isPredefined() {
        return this.isMainPackage() || this.isCoreLibPackage();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_PACKAGE: Duplicate package ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public boolean isMainPackage() {
        return MAIN_PACKAGE_NAME.equals(this.getName());
    }

    public boolean isCoreLibPackage() {
        String name = this.getName();
        return ADDR_REG_PACKAGE_NAME.equals(name) || EXECUTOR_PACKAGE_NAME.equals(name) || STD_PACKAGE_NAME.equals(name);
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter elementFilter) {
        RfDefElement declaration;
        RfNamedElement pssTopComp;
        if (this.isMainPackage() && "pss_top".equals(name) && (classes == null || classes.contains(RfField.class) && !classes.contains(RfStruct.class)) && (pssTopComp = super.getLocalMember(determinant, Collections.singleton(RfStruct.class), name, isAmbiguousCheck, elementFilter)) != null && (declaration = pssTopComp.getDeclaration()) != null && declaration.isIs()) {
            RfPredefinedField pssTopCompInst = new RfPredefinedField(name, new DataType(name), "Implicit 'pss_top' component instance");
            pssTopCompInst.setAssociatedType(pssTopComp);
            if (elementFilter == null || elementFilter.validElement((IRfNamedElement)pssTopCompInst)) {
                return pssTopCompInst;
            }
        }
        return super.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
    }

    @Override
    public List<RfImportElement> getImportedElements(RfScopeDefElement lexicalScope) {
        return super.getImportedElements(lexicalScope);
    }

    @Override
    public List<RfDefElement> getLayers() {
        return super.getLayers();
    }

    @Override
    public void getQualifiedName(StringBuilder name) {
        if (this.isMainPackage()) {
            return;
        }
        name.append(this.getName());
    }
}

