/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfProject;

public class RfPredefinedEnumItem
extends RfEnumItem {
    private String comment;

    public RfPredefinedEnumItem(String name, DataType dataType, String comment) {
        super(name, dataType);
        this.comment = comment;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public String getComment() {
        return "PREDEFINED: " + this.comment;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (currentLayer != null && currentLayer.isIs()) {
            int startOffset = currentLayer.getStartOffset();
            int endOffset = startOffset + this.getName().length();
            int startLine = currentLayer.getStartLine();
            ParserPath parserPath = currentLayer.getParserPath();
            project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName());
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_ENUM: Duplicate predefined enum item ''{0}''";
    }
}

