/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;

public class RfPredefinedEnumType
extends RfEnumType {
    private String comment;

    public RfPredefinedEnumType(String name, String comment) {
        super(name);
        this.comment = comment;
    }

    public boolean hasNonPredefinedMembers() {
        for (RfNamedElement member : this.members) {
            if (member.isPredefined()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public String getComment() {
        return "PREDEFINED: " + this.comment;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (currentLayer != null && currentLayer.isIs()) {
            int startOffset = currentLayer.getStartOffset();
            int endOffset = startOffset + this.getName().length();
            int startLine = currentLayer.getStartLine();
            ParserPath parserPath = currentLayer.getParserPath();
            project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName());
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_TYPE: Duplicate predefined type ''{0}''";
    }
}

