/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfProject;

public class RfPredefinedMethod
extends RfMethod {
    private String comment;
    private boolean argumentsCheck;

    public RfPredefinedMethod(String name, DataType dataType, boolean argumentsCheck, String comment) {
        super(name, dataType);
        this.comment = comment;
        this.argumentsCheck = argumentsCheck;
    }

    @Override
    public boolean isArgumentsCheck() {
        return this.argumentsCheck;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public String getComment() {
        return "PREDEFINED: " + this.comment;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (currentLayer != null && currentLayer.isIs()) {
            int startOffset = currentLayer.getStartOffset();
            int endOffset = startOffset + this.getName().length();
            int startLine = currentLayer.getStartLine();
            ParserPath parserPath = currentLayer.getParserPath();
            project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName());
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_FUNCTION: Duplicate predefined function ''{0}''";
    }
}

