/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.IRfType;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.StructKind;

public class RfPredefinedType
extends RfNamedElement
implements IRfType,
IRfScope {
    private String comment;
    private StructKind structKind;

    public RfPredefinedType(String name, String comment) {
        super(name);
        this.comment = comment;
    }

    public RfPredefinedType(StructKind structKind, String comment) {
        super(structKind.toString());
        this.comment = comment;
        this.structKind = structKind;
    }

    public StructKind getStructKind() {
        return this.structKind;
    }

    public boolean isGenericType() {
        return this.structKind != null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
    }

    public String getSignature() {
        return "type " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.unknown";
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return null;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public RfNamedElement getNamedElement() {
        return this;
    }

    @Override
    public int sizeof() {
        if ("int".equals(this.getName())) {
            return 32;
        }
        if ("bit".equals(this.getName())) {
            return 1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNumericType() {
        String name = this.getName();
        if ("int".equals(name)) {
            return true;
        }
        if ("bit".equals(name)) {
            return true;
        }
        return this.isFloatType();
    }

    @Override
    public boolean isFloatType() {
        String name = this.getName();
        if ("float32".equals(name)) {
            return true;
        }
        return "float64".equals(name);
    }

    @Override
    public void getQualifiedName(StringBuilder name) {
        name.append(this.getName());
    }
}

