/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.collections.AST;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigUtils;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemKinds;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTRfManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfProjectContent;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfGUIUtils;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.custompragma.TranslatePragma;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.pssdt.builders.PSSBuilderUtils;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.PSSFileInfo;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.floatingwidgets.PSSFNotificationProvider;
import ro.amiq.pssdt.model.reflection.AccessKind;
import ro.amiq.pssdt.model.reflection.BlockInfo;
import ro.amiq.pssdt.model.reflection.BlockKind;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfFileListener;
import ro.amiq.pssdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.pssdt.model.reflection.MethodKind;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfImportElement;
import ro.amiq.pssdt.model.reflection.RfInactiveCodeFileInfo;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfMethodDef;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPackageAlias;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumItem;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumType;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedMethod;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProjectContent;
import ro.amiq.pssdt.model.reflection.RfPropTypeOverride;
import ro.amiq.pssdt.model.reflection.RfScopeDefElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.pssdt.model.reflection.semantic.RfSemanticError;
import ro.amiq.pssdt.model.reflection.semantic.SemanticErrorsManager;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.model.reflection.util.NullProtectedList;
import ro.amiq.pssdt.model.reflection.views.PSSQuickViewersUtil;
import ro.amiq.pssdt.parser.ArgInfo;
import ro.amiq.pssdt.parser.EAST;
import ro.amiq.pssdt.parser.PSSFileInstance;
import ro.amiq.pssdt.parser.PSSFileInstancesMap;
import ro.amiq.pssdt.parser.PSSParser;
import ro.amiq.pssdt.parser.RfWalker;
import ro.amiq.pssdt.parser.SemanticWalker;
import ro.amiq.pssdt.parser.TypesWalker;
import ro.amiq.pssdt.r2lparser.R2LUtils;
import ro.amiq.pssdt.ui.namechecker.NameCheckerWarningsManager;
import ro.amiq.pssdt.ui.syntaxerrors.SyntaxErrorsManager;

public class RfProject
extends RfNamedElement
implements IRfSingleLangProject {
    private static final String TEMP_LIBRARY_NAME = "non-top-files";
    public static final String EXTENSIONS_PREFIX = "__extensions__";
    public static final String INTERNAL_PREFIX = "___internal_";
    public static final String DEBUG_PREFIX = "DEBUG PSS: ";
    public static final String DEBUG_EXPRESSION_PATH = "<expression>";
    public static final Set<Class<? extends IRfNamedElement>> PARAMETER_CLASSES = new HashSet<Class>(Arrays.asList(RfTemplateParam.RfTemplateTypeParam.class, RfTemplateParam.RfTemplateValueParam.class));
    public static final Set<Class<? extends IRfNamedElement>> FIELD_CLASSES = new HashSet<Class>(Arrays.asList(RfField.class, RfField.RfIteratorField.class, RfField.RfIndexField.class, RfPredefinedField.class));
    public static final Set<Class<? extends IRfNamedElement>> METHOD_CLASSES = new HashSet<Class>(Arrays.asList(RfMethod.class, RfPredefinedMethod.class));
    public static final Set<Class<? extends IRfNamedElement>> STRUCT_CLASSES = new HashSet<Class>(Arrays.asList(RfStruct.class, RfTemplateStruct.class));
    public static final Set<Class<? extends IRfNamedElement>> PACKAGE_STRUCT_CLASSES = new HashSet<Class>(Arrays.asList(RfPackage.class, RfStruct.class, RfTemplateStruct.class));
    public static final Set<Class<? extends IRfNamedElement>> LABELED_CLASSES = new HashSet<Class>(Arrays.asList(RfField.class, RfField.RfIteratorField.class, RfField.RfIndexField.class, RfPredefinedField.class, RfMethod.class, RfPredefinedMethod.class, RfStruct.class, RfTemplateStruct.class, RfTemplateParam.RfTemplateTypeParam.class, RfTemplateParam.RfTemplateValueParam.class, RfPackage.class, RfStruct.class, RfTemplateStruct.class));
    public static final ImportMode IMPORT_MODE = ImportMode.SEMANTIC_SCOPE;
    private RfProjectContent fRfProjectContent = new RfProjectContent();
    private transient RfCompiledFiles fRfCompiledFiles = new RfCompiledFiles();
    private transient RfFileDef fCurrentFileDef;
    private transient Map<ParserPath, RfInactiveCodeFileInfo> fInactiveCodeInfos;
    private transient long fLastFullBuildStartTime;
    private transient long fLastFullBuildDuration;
    private transient long fLastFullBuildStartMemory;
    private transient long fLastFullBuildMemoryAllocation;
    private transient RfPackage fPackageMain = new RfPackage("main");
    private transient String fEnclosingPackageName;
    private transient String fEnclosingComponentName;
    private transient String fPrevEnclosingComponentName;
    private transient Determinant fCurrentDeterminant;
    private transient Determinant fBeforeExtendDeterminant;
    private transient boolean fIsExtendLayer;
    private transient boolean fIsMethodImplLayer;
    private transient RfStruct fRootAction;
    private transient IProject fProject;
    private transient Set<ParserPath> fIncrementalParserPaths;
    private transient boolean fIncrementalBuild;
    private transient Map<ParserPath, DVTEditor> fParserPathToEditorMap;
    private transient Deque<RfNamedElement> fScopeStack;
    private transient List<ReparseInfo> fReparseStack;
    private transient String fBuildConfig;
    private transient boolean fIsAllowNonStandardEnumInExpr;
    private transient RfMixedLangProject fMixedLangProjectParent;
    private transient RfLibrary fCurrentLibrary;
    private transient boolean fBuildPending;
    private transient RfGUIUtils fGUIUtils;
    private transient IProgressMonitor fBuildProgressMonitor;
    private transient int fNofBuildCanceledQueries;
    private transient boolean fCachedBuildCanceled;
    private transient RfProjectState fProjectState = RfProjectState.NEW;
    private transient Object fSemanticErrorsLock = new Object();
    private transient Map<String, Collection<RfSemanticError>> fSemanticErrors;
    private transient List<FileReference> fFullBuildFileReferences;
    private transient List<FileReference> fRestoreFileReferences;
    private transient Object fRestoreModulesLock = new Object();
    private transient Map<FileReference, PSSFileInfo> fFileReferenceToPSSFileInfoMap;
    private transient EAST fStaticConstOverrideAST;
    private transient RfPredefinedStruct fStructBaseParent;
    private transient RfPredefinedStruct fComponentBaseParent;
    private transient RfPredefinedStruct fActionBaseParent;
    private transient RfPredefinedStruct fStateBaseParent;
    private transient RfPredefinedStruct fStreamBaseParent;
    private transient RfPredefinedStruct fBufferBaseParent;
    private transient RfPredefinedStruct fResourceBaseParent;
    private transient ChangedFilesManager fChangedFilesManager;
    private transient int fMaxNofSemanticProblemsPerFile;
    private transient Map<ParserPath, List<IRfFileListener>> fParserPathToListenerMap;
    private String[] fPredefinedLibrariesFiles;
    private static transient AtomicInteger fCount1 = new AtomicInteger(0);
    private static transient AtomicInteger fCount2 = new AtomicInteger(0);
    private static transient AtomicInteger fCount3 = new AtomicInteger(0);
    private static transient AtomicInteger fCount4 = new AtomicInteger(0);
    private Map<String, Set<FileReference>> fUndeclaredVarNameReferences;
    private Map<String, Set<FileReference>> fUndeclaredTypeNameReferences;
    private List<RfNamedElement> fAddedVarsInCurrentFile;
    private List<RfNamedElement> fAddedTypesInCurrentFile;
    private Map<FileReference, Set<FileReference>> fDependentFileReferences;

    private int getMaxSemanticIssuesPerFile() {
        return TestHelper.isTestMode() && TestHelper.isUsingMaxIntSemanticIssuesPerFile() ? Integer.MAX_VALUE : this.fMaxNofSemanticProblemsPerFile;
    }

    public IRfProjectContent getRfProjectContent() {
        return this.fRfProjectContent;
    }

    public void setRfProjectContent(IRfProjectContent rfProjectContent) {
        this.fRfProjectContent = (RfProjectContent)rfProjectContent;
    }

    public void restoreInvocationsInfo(IRfProjectContent rfProjectContent, RfCompiledFiles compiledFiles, Map<String, BCFileInstance> buildConfigFiles) {
        if (compiledFiles == null) {
            return;
        }
        PSSFileInstancesMap fileInstancesMap = this.fRfProjectContent.fFileInstancesMap;
        if (fileInstancesMap == null) {
            return;
        }
        for (ParserPath parserPath : compiledFiles.fCompiledFiles) {
            List<PSSFileInstance> fileInstances = fileInstancesMap.getFileInstances(parserPath);
            if (fileInstances == null) continue;
            for (PSSFileInstance fileInstance : fileInstances) {
                BuildConfigUtils.sendIndexToBCFiles((int)(fileInstance.getIndex() - 1), (LanguageKind)LanguageKind.PSS, (int)fileInstance.getInvocNumber(), buildConfigFiles);
            }
        }
    }

    public RfCompiledFiles getRfCompiledFiles() {
        this.fRfCompiledFiles.fCompiledFiles = new LinkedHashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return this.fRfCompiledFiles;
    }

    public void setRfCompiledFiles(RfCompiledFiles rfCompiledFiles) {
        this.fRfCompiledFiles = rfCompiledFiles;
    }

    public void setBuildProgressMonitor(IProgressMonitor buildProgressMonitor) {
        this.fBuildProgressMonitor = buildProgressMonitor;
        this.fNofBuildCanceledQueries = 0;
        this.fCachedBuildCanceled = false;
    }

    public boolean isCompiled(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null || this.fRfProjectContent.fParserPath2FileDefMap.isEmpty()) {
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                return this.fRfCompiledFiles.fCompiledFiles.contains(parserPath);
            }
            return false;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.containsKey(parserPath);
    }

    private boolean isBuildCanceled() {
        if (this.fGUIUtils.isCancelChecking()) {
            return true;
        }
        if (this.fBuildProgressMonitor == null) {
            return false;
        }
        return this.fBuildProgressMonitor.isCanceled();
    }

    public void checkBuildCanceled() throws BuildCancelException {
        if (this.fNofBuildCanceledQueries % 5000 == 0) {
            this.fCachedBuildCanceled = this.isBuildCanceled();
        }
        ++this.fNofBuildCanceledQueries;
        if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.fCachedBuildCanceled = true;
            throw new BuildCancelException();
        }
        if (this.fCachedBuildCanceled) {
            DVTLogger.INSTANCE.logDebug("### PSS SEMANTIC CANCELED BY USER ###");
            throw new BuildCancelException();
        }
    }

    public void setLastFullBuildStartTime() {
        this.fLastFullBuildStartTime = System.currentTimeMillis();
    }

    public long getLastFullBuildDuration() {
        return this.fLastFullBuildDuration;
    }

    private void updateDuration() {
        long tmp = System.currentTimeMillis();
        this.fLastFullBuildDuration = (tmp - this.fLastFullBuildStartTime) / 1000L;
    }

    public void setLastFullBuildStartMemory() {
        this.fLastFullBuildStartMemory = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
    }

    public long getLastFullBuildMemoryAllocation() {
        return Math.round((double)this.fLastFullBuildMemoryAllocation / 1048576.0);
    }

    private void updateMemoryAllocation() {
        long tmp = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
        this.fLastFullBuildMemoryAllocation = tmp - this.fLastFullBuildStartMemory;
    }

    public RfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        super("");
        this.init(project, null, true);
        this.compilePredefinedLibraries();
        this.setMixedLangProjectParent(rfMixedLangProject);
    }

    public Set<ParserPath> getCompiledFilesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ParserPath> result = new LinkedHashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return result;
    }

    public Set<IResource> getCompiledFileResourcesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        Collection<RfFileDef> fileDefs = this.fRfProjectContent.fParserPath2FileDefMap.values();
        if (fileDefs == null || fileDefs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (RfFileDef fileDef : fileDefs) {
            IResource adapter = fileDef.getFileAdapter();
            if (adapter == null) continue;
            result.add(adapter);
        }
        return result;
    }

    public boolean hasSomethingToCompile() {
        return this.fRfProjectContent.fParserPath2FileDefMap != null && !this.fRfProjectContent.fParserPath2FileDefMap.keySet().isEmpty();
    }

    public void setMixedLangProjectParent(RfMixedLangProject rfMixedLangProject) {
        this.fMixedLangProjectParent = rfMixedLangProject;
    }

    public void init(IProject project, IDVTRfManager rfManager, boolean shouldRunSemanticChecks) {
        EAST.setStringConversion(0, PSSParser._tokenNames);
        this.fProject = project;
        this.fGUIUtils = new RfGUIUtils();
        this.fIncrementalBuild = false;
        this.fEnclosingPackageName = null;
        this.fEnclosingComponentName = null;
        this.fPrevEnclosingComponentName = null;
        this.fCurrentDeterminant = null;
        this.fIsExtendLayer = false;
        this.fIsMethodImplLayer = false;
        this.fRootAction = null;
        this.fSemanticErrorsLock = new Object();
        this.fSemanticErrors = new HashMap<String, Collection<RfSemanticError>>();
        this.fFullBuildFileReferences = new ArrayList<FileReference>();
        this.fFileReferenceToPSSFileInfoMap = new LinkedHashMap<FileReference, PSSFileInfo>();
        if (this.fRfProjectContent == null) {
            this.fRfProjectContent = new RfProjectContent();
        }
        if (this.fRfCompiledFiles == null) {
            this.fRfCompiledFiles = new RfCompiledFiles();
        }
        this.fRfProjectContent.init(this);
        if (this.fScopeStack == null) {
            this.fScopeStack = new ArrayDeque<RfNamedElement>();
            this.fScopeStack.push(this);
        }
        this.fReparseStack = new ArrayList<ReparseInfo>();
        this.fStaticConstOverrideAST = null;
        this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        this.fIsAllowNonStandardEnumInExpr = BuildConfigManager.getPssUseEnumInExpressions((IProject)this.fProject);
        this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
        this.fInactiveCodeInfos = new HashMap<ParserPath, RfInactiveCodeFileInfo>();
        ro.amiq.pssdt.utils.Utils.cleanSemanticMarkers(this.fProject);
    }

    public PSSFileInstancesMap getFileInstancesMap() {
        if (this.fRfProjectContent.fFileInstancesMap == null) {
            this.fRfProjectContent.fFileInstancesMap = new PSSFileInstancesMap(this);
        }
        return this.fRfProjectContent.fFileInstancesMap;
    }

    public boolean isAllowNonStandardEnumInExpr() {
        return this.fIsAllowNonStandardEnumInExpr;
    }

    public void restoreMixedLangProjectPreElab(IProgressMonitor monitor) {
        this.setBuildProgressMonitor(monitor);
        try {
            ro.amiq.pssdt.utils.Utils.refreshMarkers(this);
            for (ParserPath parserPath : this.fRfCompiledFiles.fCompiledFiles) {
                this.checkCustomPragmas(parserPath);
            }
            ro.amiq.pssdt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, false);
            this.startNameChecking(this.fRfCompiledFiles.fCompiledFiles, 1);
            if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                for (Map.Entry entry : this.fParserPathToEditorMap.entrySet()) {
                    ParserPath parserPath = (ParserPath)entry.getKey();
                    DVTEditor editor = (DVTEditor)entry.getValue();
                    this.checkCustomPragmas(parserPath);
                    this.connectFileToDocument(parserPath, editor, false);
                    ro.amiq.pssdt.utils.Utils.startHighlight(this.getFileDefUsingParserPath(parserPath), editor);
                }
            }
            this.updateBreadcrumbs();
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception exception) {
            DVTLogger.INSTANCE.logError((Throwable)exception);
        }
        this.setBuildProgressMonitor(null);
    }

    private void updateBreadcrumbs() {
        Job updateBCJob = new Job("Updating Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    ro.amiq.pssdt.utils.Utils.startUpdateScopeBreadcrumb((DVTEditor)editor);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    public void removeMixedLangProject() {
        IProject project = this.fProject;
        PSSModelManager.getInstance().saveUnfinishedJobs(project);
        this.clean();
        this.fProjectState = RfProjectState.NEW;
        PSSModelManager.getInstance().cbClean(project);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getSignature() {
        return "";
    }

    @Override
    protected void removeDirtyElements(ParserPath parserPath, boolean isRemoveImports, RfProject project) {
        if (this.fRfProjectContent.fLibraries == null) {
            return;
        }
        this.removeDirtyElements(this.fRfProjectContent.fLibraries.values().iterator(), isRemoveImports, parserPath, project);
    }

    public void addIdentifier(AST id) {
        if (this.fCurrentFileDef == null || this.fCurrentFileDef.isInternalModule()) {
            return;
        }
        this.fCurrentFileDef.addIdentifier(id);
    }

    public void addListenerUsingResourcePath(IResource resource, IRfFileListener listener) {
        try {
            ParserPath parserPath;
            if (this.fParserPathToListenerMap == null) {
                this.fParserPathToListenerMap = new HashMap<ParserPath, List<IRfFileListener>>();
            }
            if ((parserPath = this.resource2parser(resource)) == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                listeners = new ArrayList<IRfFileListener>();
                this.fParserPathToListenerMap.put(parserPath, listeners);
            }
            listeners.add(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void removeListenerUsingResourcePath(IResource resource, IRfFileListener listener) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            ParserPath parserPath = this.resource2parser(resource);
            if (parserPath == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyParsingEndUsingParserPath(Set<ParserPath> incrementalParserPaths) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            for (ParserPath incrementalParserPath : incrementalParserPaths) {
                List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(incrementalParserPath);
                if (listeners == null) {
                    return;
                }
                for (IRfFileListener listener : listeners) {
                    listener.notifyFileReparse(this.getFileDefUsingParserPath(incrementalParserPath));
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void connectFileToDocument(ParserPath parserPath, DVTEditor editor, boolean connectPositionsAfterEditorFocus) {
        try {
            if (parserPath == null || editor == null) {
                return;
            }
            if (this.fParserPathToEditorMap == null) {
                this.fParserPathToEditorMap = new HashMap<ParserPath, DVTEditor>();
            }
            this.fParserPathToEditorMap.put(parserPath, editor);
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                return;
            }
            HashMap<Annotation, Position> aditions = new HashMap<Annotation, Position>();
            HashSet<DVTSemanticFoldingPosition> foldingPositions = new HashSet<DVTSemanticFoldingPosition>();
            ArrayList<Position> reflectionPositions = new ArrayList<Position>();
            fileDef.connectPositionToDocument(aditions, connectPositionsAfterEditorFocus, foldingPositions, reflectionPositions);
            IDocument document = editor.getDocument();
            this.connectInactiveCodeInfos(parserPath, document);
            if (DVTFileUtils.getInstance().shouldIncrementalBuild(document, null, this.getProject())) {
                DVTEditor.addOverrideIndications(aditions, (DVTEditor)editor);
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            if (document != null && document.getNumberOfLines() < ro.amiq.pssdt.utils.Utils.getCodeFoldingNofLines()) {
                DVTEditor.addSemanticFolding(foldingPositions, (DVTEditor)editor);
            }
            if (!connectPositionsAfterEditorFocus && document != null) {
                DVTDocumentUtils.addDocumentPositions((IDocument)document, (String)"REFLECTION", reflectionPositions);
            }
            CustomPragmaUtils.notifyListeners((IProject)this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void connectInactiveCodeInfos(ParserPath parserPath, IDocument document) {
        this.addInactiveCodeInfos(parserPath, document);
        ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
    }

    public void addInactiveCodeInfos(ParserPath parserPath, IDocument document) {
        if (document == null) {
            return;
        }
        if (document.containsPositionCategory("__dvt_inactive_code_position")) {
            try {
                document.removePositionCategory("__dvt_inactive_code_position");
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (this.fInactiveCodeInfos == null) {
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
            return;
        }
        RfInactiveCodeFileInfo infoForFile = this.fInactiveCodeInfos.get(parserPath);
        if (infoForFile == null) {
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
            return;
        }
        document.addPositionCategory("__dvt_inactive_code_position");
        infoForFile.connectToDocument(document);
    }

    public void disconnectFileFromDocument(ParserPath parserPath) {
        try {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                if (this.fParserPathToEditorMap != null) {
                    this.fParserPathToEditorMap.remove(parserPath);
                }
                return;
            }
            fileDef.disconnectPositionFromDocument();
            if (this.fParserPathToEditorMap != null) {
                this.fParserPathToEditorMap.remove(parserPath);
            }
            this.internalRemoveNonTopFile(parserPath, fileDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void internalRemoveNonTopFile(ParserPath parserPath, RfFileDef fileDef) {
        try {
            String libraryName = fileDef.getLibraryName();
            if (!TEMP_LIBRARY_NAME.equals(libraryName)) {
                return;
            }
            PSSQuickViewersUtil.getInstance().removeWaitEditorJob((IFile)fileDef.getFileAdapter());
            RfLibrary library = this.getLocalLibrary(TEMP_LIBRARY_NAME);
            if (library == null) {
                return;
            }
            this.cleanFile(parserPath, true);
            library.removeDirtyElements(parserPath, true, this);
            RfPackage mainPackage = this.getMainPackage();
            if (mainPackage != null) {
                mainPackage.removeDirtyElements(parserPath, false, this);
            }
            this.cleanSemanticProblems(Collections.singletonList(fileDef.getFileReference()), null);
            ro.amiq.pssdt.utils.Utils.refreshMarkers(this);
            ro.amiq.pssdt.utils.Utils.cleanSemanticMarkers(this.fProject);
            ro.amiq.pssdt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, false);
            List emptyList = Collections.emptyList();
            SyntaxErrorsManager.getInstance().reparsed(0, 2, fileDef.getFileAdapter(), emptyList, emptyList, emptyList);
            if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
                this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath);
            }
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                this.fRfCompiledFiles.fCompiledFiles.remove(parserPath);
            }
            this.fScopeStack.clear();
            this.fReparseStack.clear();
            DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyViewsWithBuildEvents(BuildEvents.INCREMENTAL_BUILD, this.fProject, ViewsUtils.ALL_BUT_DH_VIEWS);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfFileDef getFile(IResource file) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        ParserPath parserPath = this.resource2parser(file);
        if (parserPath == null) {
            return null;
        }
        return this.getFile(parserPath);
    }

    public RfFileDef getFile(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        if (parserPath == null) {
            return null;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
    }

    public Collection<RfFileDef> getFiles() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        RfFileDef[] result = new RfFileDef[this.fRfProjectContent.fParserPath2FileDefMap.size()];
        this.fRfProjectContent.fParserPath2FileDefMap.values().toArray(result);
        Arrays.sort(result, (o1, o2) -> o1.getIndex() - o2.getIndex());
        return Arrays.asList(result);
    }

    public void postFullBuild(boolean reportToConsole, boolean saveRFDM) {
        try {
            this.fCurrentFileDef = null;
            this.fGUIUtils.resetTimer();
            if (saveRFDM) {
                RfManager.getInstance().writeRFDM(this);
            }
            this.staticOverrides(true);
            this.computeRootAction(reportToConsole);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public final void postBuildConfigChecks() {
        this.staticOverrides(true);
        this.computeRootAction(false);
    }

    public void staticOverrides(boolean reportError) {
        if (this.fStaticConstOverrideAST != null) {
            IPath bcTopPath = PSSBuilderUtils.getPSSTopPath(this.fProject);
            ParserPath parserPath = new ParserPath(bcTopPath.toOSString());
            FileReference fileReference = new FileReference(parserPath, 0);
            PSSFileInfo info = this.fFileReferenceToPSSFileInfoMap.get(fileReference);
            if (info == null) {
                return;
            }
            List<PSSFileInstance> fileInstances = this.getFileInstancesMap().getFileInstances(parserPath);
            if (fileInstances == null || fileInstances.isEmpty()) {
                return;
            }
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                return;
            }
            RfWalker rfWalker = new RfWalker(this, fileInstances.get(0), false, fileDef);
            rfWalker.staticConstOverrideEval(reportError);
        }
    }

    private void computeRootAction(boolean reportToConsole) {
        List topConfigProperties = BuildConfigManager.getTopConfigurationProperties((IProject)this.fProject);
        if (topConfigProperties == null || topConfigProperties.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < topConfigProperties.size()) {
            BuildConfigProperty topConfigProperty = (BuildConfigProperty)topConfigProperties.get(i);
            int line = (Integer)topConfigProperty.getAttribute("ATTRIBUTE_LINE");
            String file = (String)topConfigProperty.getAttribute("ATTRIBUTE_FILE");
            if (i == topConfigProperties.size() - 1) {
                RfLibrary library;
                String rootActionName = topConfigProperty.getValue();
                int index = rootActionName.indexOf(46);
                String rootComponentName = "pss_top";
                if (index > 0) {
                    rootComponentName = rootActionName.substring(0, index);
                    rootActionName = rootActionName.substring(index + 1);
                }
                if ((library = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)"work")) != null) {
                    RfMembersContainer rootComponent = (RfMembersContainer)library.getLocalType(this, new HashSet<Class<? extends IRfNamedElement>>(Arrays.asList(RfStruct.class)), rootComponentName, null);
                    if (rootComponent == null) {
                        String message = "BUILD_CONFIG: ".concat("Cannot find root component '" + rootComponentName + "' specified by -top directive");
                        DVTProblem problem = new DVTProblem(this.fProject, DVTProblemKinds.BUILDCONFIG_ERROR, file, reportToConsole, line, new String[]{message});
                        DVTProblemManager.getInstance().reportProblem(problem);
                    } else {
                        RfNamedElement rootAction = rootComponent.getLocalMember(null, Collections.singleton(RfStruct.class), rootActionName, false, null);
                        if (rootAction == null) {
                            String message = "BUILD_CONFIG: ".concat("Cannot find root action '" + rootActionName + "' specified by -top directive");
                            DVTProblem problem = new DVTProblem(this.fProject, DVTProblemKinds.BUILDCONFIG_ERROR, file, reportToConsole, line, new String[]{message});
                            DVTProblemManager.getInstance().reportProblem(problem);
                        } else {
                            this.fRootAction = (RfStruct)rootAction;
                            this.consolePrint("*** Root action set to '" + rootComponentName + "." + rootActionName + "'");
                        }
                    }
                }
            } else {
                String message = "BUILD_CONFIG: ".concat("Ignored -top specification '" + topConfigProperty.getValue() + "'");
                DVTProblem problem = new DVTProblem(this.fProject, DVTProblemKinds.BUILDCONFIG_WARNING, file, reportToConsole, line, new String[]{message});
                DVTProblemManager.getInstance().reportProblem(problem);
            }
            ++i;
        }
    }

    public RfStruct testGetRootAction() {
        return this.fRootAction;
    }

    public void postMixedLangFullBuild(FullChecksAndLibs fullChecksAndLibs, boolean reportToConsole) {
        try {
            try {
                boolean shouldReportCustomPragmas = false;
                long timeToCheckCustomPragmas = System.currentTimeMillis();
                for (ParserPath parserPath : this.getRfCompiledFiles().fCompiledFiles) {
                    if (!this.checkCustomPragmas(parserPath)) continue;
                    shouldReportCustomPragmas = true;
                }
                timeToCheckCustomPragmas += System.currentTimeMillis();
                if (reportToConsole && shouldReportCustomPragmas) {
                    this.consolePrint("Full build step 1 (CP) [" + timeToCheckCustomPragmas + " ms] ...");
                }
                ro.amiq.pssdt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, reportToConsole);
                this.startNameChecking(this.fRfCompiledFiles.fCompiledFiles, 1);
                if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                    for (Map.Entry entry : this.fParserPathToEditorMap.entrySet()) {
                        ParserPath parserPath = (ParserPath)entry.getKey();
                        DVTEditor editor = (DVTEditor)entry.getValue();
                        this.checkCustomPragmas(parserPath);
                        this.connectFileToDocument(parserPath, editor, false);
                        ro.amiq.pssdt.utils.Utils.startHighlight(this.getFileDefUsingParserPath(parserPath), editor);
                    }
                }
                this.updateBreadcrumbs();
                DVTProblemsUiUpdater dVTProblemsUiUpdater = DVTProblemsUiUpdaterRegistry.get((String)PSSProblemCategories.PSS_NAME_CHECKING.getId());
                dVTProblemsUiUpdater.update(this.fProject);
                dVTProblemsUiUpdater.scheduleObjectionsClear(this.fProject);
            }
            catch (BuildCancelException buildCancelException) {
                this.fBuildPending = false;
                ro.amiq.pssdt.utils.Utils.connectActiveOpenEditor(this);
                this.setBuildProgressMonitor(null);
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fBuildPending = false;
                ro.amiq.pssdt.utils.Utils.connectActiveOpenEditor(this);
                this.setBuildProgressMonitor(null);
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
        }
        finally {
            this.fBuildPending = false;
            ro.amiq.pssdt.utils.Utils.connectActiveOpenEditor(this);
            this.setBuildProgressMonitor(null);
            this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        }
    }

    public void postMixedLangIncrementalBuild(Set<FileCompileInfo> changedFiles, Set<String> updateViewsIds) {
        block15: {
            try {
                if (updateViewsIds != null) {
                    if (TestHelper.isTestMode()) {
                        updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
                    } else {
                        updateViewsIds.addAll(ViewsUtils.ALL_BUT_DH_VIEWS);
                    }
                }
                this.staticOverrides(true);
                Set<ParserPath> changedParserPaths = this.resource2parser(changedFiles);
                this.startNameChecking(changedParserPaths, 0);
                if (changedParserPaths != null && !changedParserPaths.isEmpty() && this.fParserPathToEditorMap != null) {
                    for (ParserPath parserPath : changedParserPaths) {
                        DVTEditor editor = this.fParserPathToEditorMap.get(parserPath);
                        this.checkCustomPragmas(parserPath);
                        this.connectFileToDocument(parserPath, editor, false);
                        ro.amiq.pssdt.utils.Utils.startHighlight(this.getFileDefUsingParserPath(parserPath), this.fParserPathToEditorMap.get(parserPath));
                    }
                }
                this.updateBreadcrumbs();
                ro.amiq.pssdt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, false);
            }
            catch (BuildCancelException buildCancelException) {
                Utils.asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
                if (this.fBuildPending && this.fIncrementalParserPaths != null) {
                    this.notifyParsingEndUsingParserPath(this.fIncrementalParserPaths);
                    this.fIncrementalParserPaths.clear();
                }
                this.fBuildPending = false;
                this.setBuildProgressMonitor(null);
                break block15;
            }
            catch (Exception e) {
                try {
                    this.updateFNotificationTracker(changedFiles);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                catch (Throwable throwable) {
                    Utils.asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
                    if (this.fBuildPending && this.fIncrementalParserPaths != null) {
                        this.notifyParsingEndUsingParserPath(this.fIncrementalParserPaths);
                        this.fIncrementalParserPaths.clear();
                    }
                    this.fBuildPending = false;
                    this.setBuildProgressMonitor(null);
                    throw throwable;
                }
                Utils.asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
                if (this.fBuildPending && this.fIncrementalParserPaths != null) {
                    this.notifyParsingEndUsingParserPath(this.fIncrementalParserPaths);
                    this.fIncrementalParserPaths.clear();
                }
                this.fBuildPending = false;
                this.setBuildProgressMonitor(null);
                break block15;
            }
            Utils.asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
            if (this.fBuildPending && this.fIncrementalParserPaths != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalParserPaths);
                this.fIncrementalParserPaths.clear();
            }
            this.fBuildPending = false;
            this.setBuildProgressMonitor(null);
        }
    }

    private void updateFNotificationTracker(Set<FileCompileInfo> changedFiles) {
        if (changedFiles == null) {
            return;
        }
        for (FileCompileInfo changedFile : changedFiles) {
            if (changedFile == null) continue;
            FIncrementalNotificationTracker.INSTANCE.addDirtyResource(this.fProject, (FNotificationDirtyResource)new FIncrementalDirtyFile(changedFile.getFile(), FNotificationDirtyReason.UNEXPECTED_EXCEPTION, (DVTFNotificationProvider)PSSFNotificationProvider.getInstance()));
        }
    }

    public PSSFileInfo getFileInfo(FileReference fileReference) {
        if (this.fFileReferenceToPSSFileInfoMap == null || !this.fFileReferenceToPSSFileInfoMap.containsKey(fileReference)) {
            return null;
        }
        return this.fFileReferenceToPSSFileInfoMap.get(fileReference);
    }

    public Collection<PSSFileInfo> getFileInfos() {
        if (this.fFileReferenceToPSSFileInfoMap == null) {
            return null;
        }
        return this.fFileReferenceToPSSFileInfoMap.values();
    }

    private void consolePrint(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(message);
    }

    @Deprecated
    protected boolean isSemanticErrorCheck() {
        return true;
    }

    @Deprecated
    protected boolean isSemanticWarningCheck() {
        return true;
    }

    public void cleanIncremental(ParserPath parserPath) {
        try {
            this.fBuildPending = true;
            if (this.fIncrementalParserPaths == null) {
                this.fIncrementalParserPaths = new HashSet<ParserPath>();
            }
            this.fIncrementalParserPaths.add(parserPath);
            this.cleanFile(parserPath, true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<FileReference> getFullBuildFileInfos() {
        return this.fFullBuildFileReferences;
    }

    public void setFullBuildFileInfos(List<FileReference> fullBuildFileInfos) {
        this.fFullBuildFileReferences = fullBuildFileInfos;
    }

    private void cleanSemanticProblems() {
        try {
            if (this.fSemanticErrors == null) {
                this.fSemanticErrors = new HashMap<String, Collection<RfSemanticError>>();
            } else {
                this.fSemanticErrors.clear();
            }
            SemanticErrorsManager.getInstance().clean(this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void cleanSemanticProblems(Collection<FileReference> fileReferences, ParserPath skipParserPath) {
        try {
            if (this.fSemanticErrors == null) {
                return;
            }
            HashSet<ParserPath> alreadyDeleted = new HashSet<ParserPath>();
            if (fileReferences != null) {
                for (FileReference fileReference : fileReferences) {
                    if (skipParserPath != null && skipParserPath.equals((Object)fileReference.parserPath) || alreadyDeleted.contains(fileReference.parserPath)) continue;
                    alreadyDeleted.add(fileReference.parserPath);
                    String resourcePath = this.parser2resource(fileReference.parserPath);
                    this.fSemanticErrors.remove(resourcePath);
                }
            }
            SemanticErrorsManager.getInstance().clean(this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void build(PSSFileInfo info, boolean incrementalBuild) {
        try {
            List<PSSFileInstance> fileInstances;
            if (!incrementalBuild) {
                this.fIsAllowNonStandardEnumInExpr = BuildConfigManager.getPssUseEnumInExpressions((IProject)this.fProject);
            }
            long time = 0L;
            ParserPath parserPath = info.getParserPath();
            FileReference fileReference = new FileReference(parserPath, info.getFileIndex());
            boolean isTopFile = !incrementalBuild || this.isCompiled(parserPath);
            AST ast = info.getAST();
            this.fFileReferenceToPSSFileInfoMap.put(new FileReference(parserPath, info.getFileIndex()), info);
            if (incrementalBuild) {
                this.initNewDefinedElementsInCurrentFile(true);
                this.cleanSemanticProblems(Collections.singletonList(fileReference), null);
            }
            if ((fileInstances = this.getFileInstancesMap().getFileInstances(parserPath)) != null && !fileInstances.isEmpty()) {
                time = System.currentTimeMillis();
                int reparseCount = 0;
                while (reparseCount < (incrementalBuild ? 1 : 2)) {
                    if (reparseCount > 0) {
                        this.cleanFile(parserPath, false);
                        this.cleanSemanticProblems(Collections.singletonList(fileReference), null);
                    }
                    for (PSSFileInstance pSSFileInstance : fileInstances) {
                        this.startModule(parserPath, IBuildConfigParserConstants.LanguageSyntax.PSS, !isTopFile);
                        this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
                        boolean isCompileForceTrue = reparseCount == 0 & !incrementalBuild;
                        RfWalker rfWalker = new RfWalker(this, pSSFileInstance, isCompileForceTrue, this.fCurrentFileDef);
                        rfWalker.model(ast);
                        if (reparseCount != 0 || isCompileForceTrue) continue;
                        TypesWalker typesWalker = new TypesWalker(this, pSSFileInstance, isCompileForceTrue, this.fCurrentFileDef);
                        typesWalker.model(ast);
                    }
                    ++reparseCount;
                }
                DVTLogger.INSTANCE.logDebug("DEBUG PSS: Register Elements [" + (System.currentTimeMillis() - time) + " ms]");
            }
            time = System.currentTimeMillis();
            this.removeDirtyElements(parserPath, true, this);
            DVTLogger.INSTANCE.logDebug("DEBUG PSS: Remove Dirty Elements [" + (System.currentTimeMillis() - time) + " ms]");
            if (fileInstances != null && !fileInstances.isEmpty()) {
                time = System.currentTimeMillis();
                for (PSSFileInstance fileInstance : fileInstances) {
                    this.startModule(parserPath, IBuildConfigParserConstants.LanguageSyntax.PSS, !isTopFile);
                    this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
                    TypesWalker typesWalker = new TypesWalker(this, fileInstance, false, this.fCurrentFileDef);
                    typesWalker.model(ast);
                    SemanticWalker semanticWalker = new SemanticWalker(this, fileInstance, this.fCurrentFileDef);
                    semanticWalker.model(ast);
                }
                DVTLogger.INSTANCE.logDebug("DEBUG PSS: Types and Semantic [" + (System.currentTimeMillis() - time) + " ms]");
            }
            if (incrementalBuild) {
                List<FileReference> dependentFileReferences = null;
                time = System.currentTimeMillis();
                dependentFileReferences = this.getSemanticDependentFileReferences(fileReference);
                this.cleanSemanticProblems(dependentFileReferences, parserPath);
                Collections.sort(dependentFileReferences);
                DVTLogger.INSTANCE.logDebug("DEBUG PSS: Collect Dependencies [" + (System.currentTimeMillis() - time) + " ms]");
                if (dependentFileReferences != null && !dependentFileReferences.isEmpty()) {
                    for (FileReference dependentFileReference : dependentFileReferences) {
                        ParserPath parserPath2 = dependentFileReference.parserPath;
                        List<PSSFileInstance> dependentFileInstances = this.getFileInstancesMap().getFileInstances(parserPath2);
                        if (dependentFileInstances == null || dependentFileInstances.isEmpty()) continue;
                        PSSFileInfo info2 = this.getFileInfo(dependentFileReference);
                        AST ast2 = info2.getAST();
                        time = System.currentTimeMillis();
                        for (PSSFileInstance fileInstance : dependentFileInstances) {
                            this.startModule(parserPath2, IBuildConfigParserConstants.LanguageSyntax.PSS, !isTopFile);
                            this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath2);
                            TypesWalker typesWalker = new TypesWalker(this, fileInstance, false, this.fCurrentFileDef);
                            typesWalker.model(ast2);
                            SemanticWalker semanticWalker = new SemanticWalker(this, fileInstance, this.fCurrentFileDef);
                            semanticWalker.model(ast2);
                        }
                        DVTLogger.INSTANCE.logDebug("DEBUG PSS: Types and Semantic for Dependencies [" + (System.currentTimeMillis() - time) + " ms]");
                    }
                }
            }
            if (incrementalBuild) {
                this.fIncrementalBuild = true;
                if (this.fIncrementalParserPaths == null) {
                    this.fIncrementalParserPaths = new HashSet<ParserPath>();
                }
                this.fIncrementalParserPaths.add(parserPath);
            } else {
                if (this.fFullBuildFileReferences == null) {
                    this.fFullBuildFileReferences = new ArrayList<FileReference>();
                }
                this.fFullBuildFileReferences.add(new FileReference(info.getParserPath(), info.getFileIndex()));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
    }

    public void postIncrementalBuild(PSSFileInfo info) {
        try {
            this.fIncrementalBuild = false;
            this.fGUIUtils.resetTimer();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void clean() {
        this.fBuildPending = true;
        this.fIncrementalBuild = false;
        this.fEnclosingPackageName = null;
        this.fEnclosingComponentName = null;
        this.fCurrentDeterminant = RfPackage.MAIN_DETERMINANT;
        this.fIsExtendLayer = false;
        this.fIsMethodImplLayer = false;
        this.fRootAction = null;
        this.fDependentFileReferences = null;
        if (this.fChangedFilesManager != null) {
            this.fChangedFilesManager.clear();
        }
        this.fChangedFilesManager = null;
        this.fCurrentLibrary = null;
        this.fPackageMain = new RfPackage("main");
        if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
            for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
                fileDef.deepClean();
            }
            this.fRfProjectContent.fParserPath2FileDefMap.clear();
        }
        this.fScopeStack.clear();
        this.fScopeStack.push(this);
        this.fReparseStack.clear();
        this.deepClean();
        this.fFileReferenceToPSSFileInfoMap = new LinkedHashMap<FileReference, PSSFileInfo>();
        if (this.fRfProjectContent.fLibraries == null) {
            this.fRfProjectContent.fLibraries = new DVTLinkedHashMap();
        } else {
            this.fRfProjectContent.fLibraries.clear();
        }
        if (this.fRfProjectContent.fFileInstancesMap == null) {
            this.fRfProjectContent.fFileInstancesMap = new PSSFileInstancesMap(this);
        } else {
            this.fRfProjectContent.fFileInstancesMap.clear();
        }
        this.cleanSemanticProblems();
        this.fFullBuildFileReferences = new ArrayList<FileReference>();
        if (this.fInactiveCodeInfos != null) {
            this.fInactiveCodeInfos.clear();
        }
        this.compilePredefinedLibraries();
        this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
    }

    private void compilePredefinedLibraries() {
    }

    public boolean isPredefinedLibraryFile(ParserPath filePath) {
        if (filePath == null) {
            return true;
        }
        if (this.fPredefinedLibrariesFiles == null) {
            return false;
        }
        String path = filePath.path;
        String[] stringArray = this.fPredefinedLibrariesFiles;
        int n = this.fPredefinedLibrariesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String libraryPath = stringArray[n2];
            if (libraryPath != null && libraryPath.equals(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void remove(IPSSModule pssFile) {
        ParserPath parserPath = pssFile.getParserPath();
        if (parserPath != null) {
            this.removeFile(parserPath);
        }
    }

    public void removeFile(ParserPath parserPath) {
        if (parserPath != null) {
            RfFileDef file = this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath);
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                this.fRfCompiledFiles.fCompiledFiles.remove(parserPath);
            }
            if (file == null) {
                return;
            }
            file.cleanUpFile();
        }
    }

    public void cleanFile(ParserPath parserPath, boolean cleanCStylePreprocCodeInfo) {
        if (parserPath != null) {
            RfFileDef file = this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
            if (file == null) {
                return;
            }
            if (this.fInactiveCodeInfos != null) {
                if (!cleanCStylePreprocCodeInfo) {
                    List<RfInactiveCodeFileInfo.RfInactiveCodeLineInfo> lineInfos;
                    RfInactiveCodeFileInfo inactiveCodeInfos = this.fInactiveCodeInfos.get(parserPath);
                    if (inactiveCodeInfos != null && (lineInfos = inactiveCodeInfos.getLineInfos()) != null && !lineInfos.isEmpty()) {
                        Iterator<RfInactiveCodeFileInfo.RfInactiveCodeLineInfo> iterator = lineInfos.iterator();
                        while (iterator.hasNext()) {
                            RfInactiveCodeFileInfo.RfInactiveCodeLineInfo lineInfo = iterator.next();
                            if (lineInfo.isCStyle()) continue;
                            iterator.remove();
                        }
                    }
                } else {
                    this.fInactiveCodeInfos.remove(parserPath);
                }
            }
            file.cleanUpFile();
        }
    }

    @Override
    protected void addMember(String packageName, boolean isExtendLayer, RfNamedElement element) {
        if (this.fCurrentLibrary == null) {
            return;
        }
        this.fCurrentLibrary.addMember("main", isExtendLayer, element);
    }

    public void setStaticConstOverride(EAST staticConstOverrideAST) {
        this.fStaticConstOverrideAST = staticConstOverrideAST;
    }

    public EAST getStaticConstOverrideAST() {
        return this.fStaticConstOverrideAST;
    }

    public void startModule(ParserPath parserPath, IBuildConfigParserConstants.LanguageSyntax languageSyntax, boolean isNonTopFile) {
        try {
            boolean isNotCompiled;
            this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
            this.fScopeStack.clear();
            this.fReparseStack.clear();
            this.fEnclosingPackageName = "main";
            this.fEnclosingComponentName = null;
            this.fCurrentDeterminant = RfPackage.MAIN_DETERMINANT;
            this.fIsExtendLayer = false;
            this.fIsMethodImplLayer = false;
            boolean bl = isNotCompiled = this.fIncrementalBuild && !this.isCompiled(parserPath);
            if (this.fRfProjectContent.fLibraries.containsKey((Object)"work")) {
                this.fCurrentLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)"work");
            } else {
                this.fCurrentLibrary = new RfLibrary("work", this);
                this.fRfProjectContent.fLibraries.put((Object)"work", (IDVTMapElement)this.fCurrentLibrary);
                this.fCurrentLibrary.addMember("main", this.fIsExtendLayer, this.fPackageMain);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, new RfPredefinedType("chandle", "The chandle data type represents storage for pointers passed using the PI"));
                RfPredefinedType intType = new RfPredefinedType("int", "2-state signed integer type (32-bit default or user-defined bit size)");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, intType);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, new RfPredefinedType("bit", "2-state unsigned integer type (user-defined bit size)"));
                RfPredefinedType boolType = new RfPredefinedType("bool", "boolean type");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, boolType);
                RfPredefinedType float32Type = new RfPredefinedType("float32", "float 32-bit type");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, float32Type);
                RfPredefinedType float64Type = new RfPredefinedType("float64", "float 64-bit type");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, float64Type);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, new RfPredefinedType("void", ""));
                RfPredefinedType stringType = new RfPredefinedType("string", "string type");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, stringType);
                RfPredefinedType genericType = new RfPredefinedType(StructKind.GENERIC, "Generic type");
                RfPredefinedMethod method = new RfPredefinedMethod("get_symbol", DataType.STRING, false, "Returns the value of the specified environment variable");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method);
                RfPredefinedField arg = new RfPredefinedField("name", DataType.STRING, null);
                arg.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg.setAssociatedType(stringType);
                method.addMember("main", this.fIsExtendLayer, arg);
                method = new RfPredefinedMethod("getenv", DataType.STRING, false, "Returns the value of the specified environment variable");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method);
                arg = new RfPredefinedField("name", DataType.STRING, null);
                arg.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg.setAssociatedType(stringType);
                method.addMember("main", this.fIsExtendLayer, arg);
                method = new RfPredefinedMethod("random", DataType.INT, false, "Console print formatted message");
                method.setAssociatedType(intType);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method);
                arg = new RfPredefinedField("min", DataType.INT, null);
                arg.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg.setAssociatedType(intType);
                method.addMember("main", this.fIsExtendLayer, arg);
                arg = new RfPredefinedField("max", DataType.INT, null);
                arg.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg.setAssociatedType(intType);
                method.addMember("main", this.fIsExtendLayer, arg);
                method = new RfPredefinedMethod("print", DataType.VOID, false, "Console print formatted message");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method);
                arg = new RfPredefinedField("message", DataType.STRING, null);
                arg.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg.setAssociatedType(stringType);
                method.addMember("main", this.fIsExtendLayer, arg);
                DataType dataType = new DataType("list<generic>");
                dataType.setItemDataType(null, new DataType("generic"), DataType.CollectionKind.LIST);
                arg = new RfPredefinedField("args", dataType, null);
                arg.setFieldModifier(FieldModifier.VARIADIC_PARAM);
                arg.setAssociatedType(RfCollectionType.createList(this, genericType, dataType));
                method.addMember("main", this.fIsExtendLayer, arg);
                method = new RfPredefinedMethod("appendf", DataType.STRING, false, "Append formatted strings");
                method.setAssociatedType(stringType);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method);
                arg = new RfPredefinedField("text", DataType.STRING, null);
                arg.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg.setAssociatedType(stringType);
                method.addMember("main", this.fIsExtendLayer, arg);
                dataType = new DataType("list<generic>");
                dataType.setItemDataType(null, new DataType("generic"), DataType.CollectionKind.LIST);
                arg = new RfPredefinedField("args", dataType, null);
                arg.setFieldModifier(FieldModifier.VARIADIC_PARAM);
                arg.setAssociatedType(RfCollectionType.createList(this, genericType, dataType));
                method.addMember("main", this.fIsExtendLayer, arg);
                RfPredefinedEnumType messageVerbosityType = new RfPredefinedEnumType("message_verbosity_e", "Message verbosity");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, messageVerbosityType);
                DataType intDataType = new DataType("int").set(31, 0, true);
                messageVerbosityType.setItemDataType(intDataType);
                messageVerbosityType.setItemAssociatedType(intType);
                RfPredefinedEnumItem enumItem = new RfPredefinedEnumItem("NONE", intDataType, "");
                enumItem.setAssociatedType(messageVerbosityType);
                messageVerbosityType.addMember("main", this.fIsExtendLayer, enumItem);
                enumItem = new RfPredefinedEnumItem("LOW", intDataType, "");
                enumItem.setAssociatedType(messageVerbosityType);
                messageVerbosityType.addMember("main", this.fIsExtendLayer, enumItem);
                enumItem = new RfPredefinedEnumItem("MEDIUM", intDataType, "");
                enumItem.setAssociatedType(messageVerbosityType);
                messageVerbosityType.addMember("main", this.fIsExtendLayer, enumItem);
                enumItem = new RfPredefinedEnumItem("HIGH", intDataType, "");
                enumItem.setAssociatedType(messageVerbosityType);
                messageVerbosityType.addMember("main", this.fIsExtendLayer, enumItem);
                RfPredefinedMethod method2 = new RfPredefinedMethod("message", DataType.VOID, false, "Console print formatted message");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method2);
                RfPredefinedField arg2 = new RfPredefinedField("verbosity", new DataType("message_verbosity_e"), null);
                arg2.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg2.setAssociatedType(messageVerbosityType);
                method2.addMember("main", this.fIsExtendLayer, arg2);
                arg2 = new RfPredefinedField("message", DataType.STRING, null);
                arg2.setFieldModifier(FieldModifier.METHOD_PARAM);
                arg2.setAssociatedType(stringType);
                method2.addMember("main", this.fIsExtendLayer, arg2);
                DataType dataType2 = new DataType("list<generic>");
                dataType2.setItemDataType(null, new DataType("generic"), DataType.CollectionKind.LIST);
                arg2 = new RfPredefinedField("args", dataType2, null);
                arg2.setFieldModifier(FieldModifier.VARIADIC_PARAM);
                arg2.setAssociatedType(RfCollectionType.createList(this, genericType, dataType2));
                method2.addMember("main", this.fIsExtendLayer, arg2);
                method = new RfPredefinedMethod("is_before", DataType.BOOL, true, "Returns true if the first argument action is scheduled before the second argument action, false otherwise");
                method.setAssociatedType(boolType);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method);
                RfPredefinedField argument = new RfPredefinedField("a1", new DataType("struct"), "");
                argument.setFieldModifier(FieldModifier.METHOD_PARAM);
                argument.setAssociatedType(genericType);
                method.addMember("main", this.fIsExtendLayer, argument);
                argument = new RfPredefinedField("a2", new DataType("struct"), "");
                argument.setFieldModifier(FieldModifier.METHOD_PARAM);
                argument.setAssociatedType(genericType);
                method.addMember("main", this.fIsExtendLayer, argument);
                method = new RfPredefinedMethod("is_parallel", DataType.BOOL, true, "Returns true if the first argument action is scheduled before the second argument action, false otherwise");
                method.setAssociatedType(boolType);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, method);
                argument = new RfPredefinedField("a1", new DataType("struct"), "");
                argument.setFieldModifier(FieldModifier.METHOD_PARAM);
                argument.setAssociatedType(genericType);
                method.addMember("main", this.fIsExtendLayer, argument);
                argument = new RfPredefinedField("a2", new DataType("struct"), "");
                argument.setFieldModifier(FieldModifier.METHOD_PARAM);
                argument.setAssociatedType(genericType);
                method.addMember("main", this.fIsExtendLayer, argument);
                this.fStructBaseParent = new RfPredefinedStruct("___internal_base_struct", "The parent of struct type (including buffer, state, stream, and resource)");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, this.fStructBaseParent);
                this.fComponentBaseParent = new RfPredefinedStruct("___internal_base_component", "The parent of component type");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, this.fComponentBaseParent);
                this.fActionBaseParent = new RfPredefinedStruct("___internal_base_action", "The parent of action type");
                this.fPackageMain.addMember("main", this.fIsExtendLayer, this.fActionBaseParent);
                this.fStateBaseParent = new RfPredefinedStruct("___internal_base_state", "The parent of state type");
                this.fStateBaseParent.setParent(this.fStructBaseParent);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, this.fStateBaseParent);
                this.fStreamBaseParent = new RfPredefinedStruct("___internal_base_stream", "The parent of stream type");
                this.fStreamBaseParent.setParent(this.fStructBaseParent);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, this.fStreamBaseParent);
                this.fBufferBaseParent = new RfPredefinedStruct("___internal_base_buffer", "The parent of buffer type");
                this.fBufferBaseParent.setParent(this.fStructBaseParent);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, this.fBufferBaseParent);
                this.fResourceBaseParent = new RfPredefinedStruct("___internal_base_resource", "The parent of resource type");
                this.fResourceBaseParent.setParent(this.fStructBaseParent);
                this.fPackageMain.addMember("main", this.fIsExtendLayer, this.fResourceBaseParent);
            }
            if (isNonTopFile) {
                if (this.fRfProjectContent.fLibraries.containsKey((Object)TEMP_LIBRARY_NAME)) {
                    this.fCurrentLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)TEMP_LIBRARY_NAME);
                } else {
                    this.fCurrentLibrary = new RfLibrary(TEMP_LIBRARY_NAME, this);
                    this.fRfProjectContent.fLibraries.put((Object)TEMP_LIBRARY_NAME, (IDVTMapElement)this.fCurrentLibrary);
                }
                RfNamedElement enclosingScope = this.fPackageMain.getEnclosingScope();
                this.fCurrentLibrary.addMember("main", this.fIsExtendLayer, this.fPackageMain);
                this.fPackageMain.setEnclosingScope(enclosingScope);
            }
            if (this.fCurrentFileDef == null) {
                int index = isNotCompiled ? -1 : this.fRfProjectContent.fParserPath2FileDefMap.size();
                this.fCurrentFileDef = new RfFileDef(Path.fromOSString((String)parserPath.path).lastSegment(), index, parserPath, this.fCurrentLibrary, languageSyntax);
                this.fRfProjectContent.fParserPath2FileDefMap.put(parserPath, this.fCurrentFileDef);
            } else {
                String libraryName = this.fCurrentFileDef.getLibraryName();
                this.fCurrentLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)libraryName);
            }
            this.fScopeStack.push(this.fCurrentLibrary);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfPredefinedStruct getBaseParent(StructKind structKind) {
        switch (structKind) {
            case COMPONENT: {
                return this.fComponentBaseParent;
            }
            case ACTION: 
            case ACTION_ABSTRACT: {
                return this.fActionBaseParent;
            }
            case RESOURCE: {
                return this.fResourceBaseParent;
            }
            case BUFFER: {
                return this.fBufferBaseParent;
            }
            case STATE: {
                return this.fStateBaseParent;
            }
            case STREAM: {
                return this.fStreamBaseParent;
            }
            case STRUCT: {
                return this.fStructBaseParent;
            }
        }
        return null;
    }

    public RfPredefinedType getPredefinedType(String name) {
        return (RfPredefinedType)this.fPackageMain.getLocalMember(null, Collections.singleton(RfPredefinedType.class), name, false, null);
    }

    public ElementContainer startPackage(AST id, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            String name;
            RfNamedElement enclosing = this.fScopeStack.peek();
            this.fEnclosingPackageName = name = id.getText();
            this.fCurrentDeterminant = new Determinant(this.fEnclosingPackageName);
            RfPackage member = (RfPackage)enclosing.getLocalMember(this.fCurrentDeterminant, Collections.singleton(RfPackage.class), name, false, null);
            if (member == null) {
                member = new RfPackage(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedTypeName(member);
            }
            RfScopeDefElement layer = new RfScopeDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, true, comment);
            member.addLayer(this, layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endPackage(ElementContainer container) {
        try {
            this.fEnclosingPackageName = "main";
            this.fCurrentDeterminant = RfPackage.MAIN_DETERMINANT;
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Determinant startImportPackage(RfNamedElement importedType, boolean isWhildcard, RfMembersContainer currentPackageOrComponent, RfDefElement currentScopeLayer, AST tid, ParserPath parserPath) {
        RfNamedElement currentScope;
        RfNamedElement rfNamedElement = currentScope = currentScopeLayer instanceof RfFileDef ? this.fPackageMain : currentScopeLayer.getNamedElement();
        if (currentScope instanceof RfMembersContainer && importedType instanceof RfMembersContainer) {
            RfImportElement importElement = new RfImportElement(isWhildcard, (RfMembersContainer)importedType);
            currentScopeLayer.addImportedElement(importElement);
            LineInfo lineInfo = new LineInfo(tid.getLine(), tid.getOffset(), -1);
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, lineInfo, lineInfo, true, null);
            importElement.addLayer(this, layer);
            this.fCurrentFileDef.addChildDef(layer);
        }
        this.fCurrentDeterminant = currentPackageOrComponent.getDeterminant((RfScopeDefElement)currentScopeLayer);
        return this.fCurrentDeterminant;
    }

    public Determinant startImportElement(RfMembersContainer importedType, boolean isWhildcard, RfDefElement currentScopeLayer, LineInfo lineInfo) {
        RfImportElement importElement = new RfImportElement(isWhildcard, importedType);
        currentScopeLayer.addImportedElement(importElement);
        RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, lineInfo, lineInfo, true, null);
        importElement.addLayer(this, layer);
        this.fCurrentFileDef.addChildDef(layer);
        Determinant determinant = importedType.getDeterminant((RfScopeDefElement)currentScopeLayer);
        return determinant;
    }

    public ElementContainer startBlock(BlockKind blockKind, BlockInfo blockInfo, AST id, boolean isBlockArray, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            BlockKind blockKind2 = blockKind = enclosing instanceof RfExecBlock ? BlockKind.ACTIVITY : blockKind;
            if (id != null) {
                startLine = new LineInfo(id.getLine(), id.getOffset(), -1);
            }
            String name = id == null ? this.getAnonymousName(RfBlock.class, enclosing) : id.getText();
            RfBlock member = (RfBlock)enclosing.getLocalMember(null, Collections.singleton(RfBlock.class), name, false, null);
            if (member == null) {
                member = new RfBlock(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                if (id != null) {
                    this.addNewDefinedVarName(member);
                }
                if (id != null && this.isAnonymousBlock(enclosing)) {
                    RfNamedElement namedEnclosingScope = enclosing;
                    while (this.isAnonymousBlock(namedEnclosingScope)) {
                        namedEnclosingScope = namedEnclosingScope.getEnclosingScope();
                    }
                    namedEnclosingScope.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                    member.setEnclosingScope(enclosing);
                }
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, true, comment);
            member.addLayer(this, layer);
            member.setBlockInfo(blockInfo);
            member.setBlockArray(isBlockArray);
            member.setBlockKind(blockKind);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private boolean isAnonymousBlock(RfNamedElement namedEnclosingScope) {
        return namedEnclosingScope instanceof RfBlock && namedEnclosingScope.isAnonymous() || namedEnclosingScope instanceof RfExecBlock && ((RfExecBlock)namedEnclosingScope).isActivity();
    }

    public void endBlock(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getAnonymousName(Class<? extends RfNamedElement> class1, RfNamedElement enclosing) {
        StringBuilder result = new StringBuilder("[anonymous:");
        ArrayList<RfNamedElement> enclosingElements = new ArrayList<RfNamedElement>();
        RfNamedElement enclosingTmp = enclosing;
        while (enclosingTmp != null) {
            if (enclosingTmp instanceof RfLibrary || enclosingTmp instanceof RfProject) break;
            enclosingElements.add(enclosingTmp);
            enclosingTmp = enclosingTmp.getEnclosingScope();
        }
        Collections.reverse(enclosingElements);
        for (RfNamedElement element : enclosingElements) {
            result.append(element.getName()).append('.');
        }
        Collection<RfNamedElement> members = enclosing.getLocalMembers();
        int elementIndex = 0;
        if (members != null && !members.isEmpty()) {
            for (RfNamedElement member : members) {
                if (member.getClass() != class1 || !member.isAnonymous() || member.hasNoDefs(false)) continue;
                ++elementIndex;
            }
        }
        result.append(elementIndex).append("]");
        return result.toString();
    }

    public ElementContainer startStruct(AST id, AST node, StructKind structKind, boolean isTemplateType, int qualifiers, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = id.getText();
            this.fEnclosingComponentName = structKind == StructKind.COMPONENT ? name : null;
            RfStruct member = (RfStruct)enclosing.getLocalMember(this.fCurrentDeterminant, isTemplateType ? Collections.singleton(RfTemplateStruct.class) : SemanticUtils.MEMBER_STRUCTS, name, false, null);
            if (member == null) {
                member = isTemplateType ? new RfTemplateStruct(name) : new RfStruct(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedTypeName(member);
            }
            member.setParent(this.getBaseParent(structKind));
            member.setQualifiers(qualifiers);
            RfDefElement declaration = member.getDeclaration();
            if (declaration instanceof RfDefElement.RfForwardDefElement) {
                member.removeLayer(declaration);
            }
            RfScopeDefElement layer = new RfScopeDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, true, comment);
            layer.setNodeAST(node);
            member.addLayer(this, layer);
            member.setStructKind(structKind);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endStruct(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.fEnclosingComponentName = null;
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement.RfForwardDefElement createForwardDefInCurrentScope(LineInfo lineInfo) {
        return new RfDefElement.RfForwardDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, lineInfo, lineInfo, false, null);
    }

    public ElementContainer startExtend(AST id, AST node, RfNamedElement extendedType, StructKind structKind, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement member;
            this.fIsExtendLayer = true;
            this.fPrevEnclosingComponentName = this.fEnclosingComponentName;
            RfNamedElement enclosing = this.enclosingScope();
            String name = id.getText();
            if (extendedType instanceof RfPackageAlias) {
                extendedType = ((RfPackageAlias)extendedType).getAssociatedType();
                name = extendedType.getName();
            }
            this.fEnclosingComponentName = structKind == StructKind.COMPONENT ? name : null;
            RfNamedElement rfNamedElement = member = extendedType != null && extendedType.hasNoDefs(false) ? null : extendedType;
            if (member == null && structKind == StructKind.ENUM_TYPE) {
                member = new RfEnumType(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
            } else if (member == null) {
                member = new RfStruct(name);
                ((RfStruct)member).setStructKind(structKind);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
            }
            this.fBeforeExtendDeterminant = this.fCurrentDeterminant;
            this.fCurrentDeterminant = Determinant.extend(this.fCurrentDeterminant, member.getPackageName());
            RfScopeDefElement layer = new RfScopeDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, false, comment);
            layer.setNodeAST(node);
            member.addLayer(this, layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endExtend(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.fIsExtendLayer = false;
            this.fEnclosingComponentName = this.fPrevEnclosingComponentName;
            this.fCurrentDeterminant = this.fBeforeExtendDeterminant;
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startPackageAlias(RfDefElement currentScopeLayer, AST id, DataType dataType, LineInfo startLine, CommentBlock comment) {
        try {
            String name = id.getText();
            RfPackageAlias member = currentScopeLayer.getPackageAlias(name);
            if (member == null) {
                member = new RfPackageAlias(name, dataType);
                currentScopeLayer.addPackageAlias(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, startLine, true, comment);
            member.addLayer(this, layer);
            member.setDataType(dataType);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startTypeAlias(AST id, DataType dataType, LineInfo startLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = id.getText();
            RfTypeAlias member = (RfTypeAlias)enclosing.getLocalMember(this.fCurrentDeterminant, Collections.singleton(RfTypeAlias.class), name, false, null);
            if (member == null) {
                member = new RfTypeAlias(name, dataType);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedTypeName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, startLine, true, comment);
            member.addLayer(this, layer);
            member.setDataType(dataType);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startEnumType(AST id, DataType dataType, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = id.getText();
            RfEnumType member = (RfEnumType)enclosing.getLocalMember(this.fCurrentDeterminant, SemanticUtils.MEMBER_ENUM_TYPES, name, false, null);
            if (member == null) {
                member = new RfEnumType(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedTypeName(member);
            }
            member.setItemDataType(dataType);
            RfDefElement declaration = member.getDeclaration();
            if (declaration instanceof RfDefElement.RfForwardDefElement) {
                member.removeLayer(declaration);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, true, comment);
            member.addLayer(this, layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endEnumType(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startCovergroup(AST id, boolean isInline, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = id == null ? this.getAnonymousName(RfCovergroup.class, enclosing) : id.getText();
            RfCovergroup member = (RfCovergroup)enclosing.getLocalMember(this.fCurrentDeterminant, Collections.singleton(RfCovergroup.class), name, false, null);
            if (member == null) {
                member = new RfCovergroup(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedTypeName(member);
            }
            member.setInline(isInline);
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, true, comment);
            member.addLayer(this, layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endCovergroup(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startEnumItem(AST id, DataType dataType, LineInfo startLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = id.getText();
            RfEnumItem member = (RfEnumItem)enclosing.getLocalMember(this.fCurrentDeterminant, SemanticUtils.MEMBER_ENUM_ITEMS, name, false, null);
            if (member == null) {
                member = new RfEnumItem(name, dataType);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedVarName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, startLine, true, comment);
            member.addLayer(this, layer);
            member.setAssociatedType(enclosing);
            member.setDataType(dataType);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startOverride(AST hid, boolean isInstanceOverride, LineInfo startLine, LineInfo endLine) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = String.valueOf(isInstanceOverride ? "__override__inst__" : "__override__type__") + SemanticUtils.getTextMeta(hid).replace("\\s+", "");
            RfNamedElement member = enclosing.getLocalMember(this.fCurrentDeterminant, null, name, false, null);
            if (member == null) {
                member = new RfPropTypeOverride(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, startLine, true, null);
            member.addLayer(this, layer);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startField(AST id, FieldModifier modifier, LineInfo startLine, CommentBlock comment) {
        return this.startField(id, AccessKind.PUBLIC, modifier, null, startLine, comment);
    }

    public ElementContainer startField(AST id, AccessKind access, FieldModifier modifier, DataType dataType, LineInfo startLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = id.getText();
            RfField member = (RfField)enclosing.getLocalMember(this.fCurrentDeterminant, FIELD_CLASSES, name, false, null);
            if (member == null || modifier == FieldModifier.ITERATOR && !(member instanceof RfField.RfIteratorField) || modifier == FieldModifier.INDEX && !(member instanceof RfField.RfIndexField)) {
                member = modifier == FieldModifier.ITERATOR ? new RfField.RfIteratorField(name, null) : (modifier == FieldModifier.INDEX ? new RfField.RfIndexField(name, null) : new RfField(name, null));
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedVarName(member);
            } else if (modifier == FieldModifier.METHOD_PARAM || modifier == FieldModifier.VARIADIC_PARAM || modifier == FieldModifier.SYMBOL_PARAM || modifier == FieldModifier.COVERGROUP_PORT) {
                ((RfMembersContainer)enclosing).swapElement(member);
            }
            boolean isIsLayer = modifier != FieldModifier.METHOD_PARAM && modifier != FieldModifier.VARIADIC_PARAM || !this.fIsMethodImplLayer;
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, startLine, isIsLayer, comment);
            member.addLayer(this, layer);
            member.setFieldModifier(modifier);
            member.setAccessKind(access);
            member.setDataType(dataType);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startParameter(AST id, StructKind structKind, final DataType dataType, int index, boolean isTypeParameter, LineInfo startLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = id.getText();
            RfTemplateParam parameter = (RfTemplateParam)enclosing.getLocalMember(this.fCurrentDeterminant, PARAMETER_CLASSES, name, false, new IRfElementFilter(){

                public boolean validElement(IRfNamedElement candidate) {
                    return candidate instanceof RfTemplateParam.RfTemplateTypeParam && dataType == null || candidate instanceof RfTemplateParam.RfTemplateValueParam && dataType != null;
                }

                public boolean allowEnumElement() {
                    return false;
                }

                public int resultMaxSize() {
                    return 1;
                }
            });
            if (parameter == null) {
                parameter = RfTemplateParam.create(index, name, isTypeParameter, dataType, structKind);
                ((RfTemplateStruct)enclosing).addMember(this.fEnclosingPackageName, this.fIsExtendLayer, parameter);
                this.addNewDefinedVarName(parameter);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, startLine, true, comment);
            parameter.addLayer(this, layer);
            parameter.setDataType(dataType);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startMethod(AST id, AST node, MethodKind methodKind, boolean isIsLayer, DataType dataType, List<ArgInfo> argInfos, int qualifiers, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            this.fIsMethodImplLayer = !isIsLayer;
            String name = id.getText();
            RfMethod member = (RfMethod)enclosing.getLocalMember(this.fCurrentDeterminant, METHOD_CLASSES, name, false, null);
            if (member == null) {
                member = new RfMethod(name, dataType);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
                this.addNewDefinedVarName(member);
            }
            RfMethodDef layer = new RfMethodDef(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, isIsLayer, comment);
            member.addLayer(this, layer);
            member.setMethodKind(methodKind);
            member.setDataType(dataType);
            member.setQualifiers(qualifiers);
            layer.setNodeAST(node);
            layer.setDataType(dataType);
            layer.setArgInfos(argInfos);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endMethod(ElementContainer container) {
        try {
            this.fIsMethodImplLayer = false;
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startExecBlock(AST node, ExecBlockKind execBlockKind, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            String name = node.getType() == 159 || node.getType() == 160 || node.getType() == 161 ? execBlockKind.toString() : node.getText();
            RfExecBlock member = (RfExecBlock)enclosing.getLocalMember(this.fCurrentDeterminant, Collections.singleton(RfExecBlock.class), name, false, null);
            if (member == null) {
                member = new RfExecBlock(name);
                enclosing.addMember(this.fEnclosingPackageName, this.fIsExtendLayer, member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, this.fEnclosingPackageName, this.fEnclosingComponentName, startLine, endLine, true, comment);
            member.addLayer(this, layer);
            member.setExecBlockKind(execBlockKind);
            layer.setNodeAST(node);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endExecBlock(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private RfNamedElement enclosingScope() {
        RfNamedElement enclosing = this.fScopeStack.peek();
        if (enclosing instanceof RfLibrary) {
            enclosing = this.fPackageMain;
        }
        return enclosing;
    }

    protected void pushReparse(RfDefElement layer, RfNamedElement element) {
        this.pushScope(layer, element);
        this.fReparseStack.add(new ReparseInfo(layer.getStartInfo(), layer.getParserPath()));
    }

    protected void popReparse(RfDefElement layer) {
        this.popScope(layer);
        this.fReparseStack.remove(this.fReparseStack.size() - 1);
    }

    protected void pushScope(RfDefElement layer, RfNamedElement element) {
        RfDefElement addedElem = layer;
        this.fScopeStack.push(element);
        if (!this.fCurrentFileDef.stackContains(layer)) {
            addedElem = this.fCurrentFileDef.addChildDef(layer);
        }
        this.fCurrentFileDef.pushPhysicalScope(addedElem);
    }

    protected void popScope(RfDefElement defElement) {
        if (defElement == null) {
            return;
        }
        RfNamedElement namedElement = defElement.getLastNamedElement();
        if (!this.fScopeStack.isEmpty() && this.fScopeStack.peek() == namedElement) {
            this.fScopeStack.pop();
            this.fCurrentFileDef.popPhysicalScope();
        }
    }

    public DVTEditor getEditor(ParserPath parserPath) {
        if (this.fParserPathToEditorMap == null) {
            return null;
        }
        return this.fParserPathToEditorMap.get(parserPath);
    }

    public Collection<? extends RfNamedElement> getLocalTypes(RfNamedElement element, boolean includePredefined, boolean hideDuplicates) {
        if (element instanceof RfProject) {
            if (this.fRfProjectContent.fLibraries == null) {
                return Collections.emptyList();
            }
            return this.fRfProjectContent.fLibraries.values();
        }
        NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfPackage.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfStruct.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfTemplateStruct.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfTypeAlias.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfCovergroup.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfEnumType.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfPredefinedEnumType.class)));
        return elements;
    }

    public Collection<RfLibrary> getLibraries() {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        return this.fRfProjectContent.fLibraries.values();
    }

    public Collection<RfLibrary> getLibrariesByNames(Set<String> libraryNames) {
        if (libraryNames == null) {
            return this.fRfProjectContent.fLibraries.values();
        }
        ArrayList<RfLibrary> result = new ArrayList<RfLibrary>();
        for (String libraryName : libraryNames) {
            RfLibrary library = this.getLocalLibrary(libraryName);
            if (library == null) continue;
            result.add(library);
        }
        return result;
    }

    public RfPackage getMainPackage() {
        if (this.fPackageMain != null) {
            return this.fPackageMain;
        }
        RfLibrary library = this.getLocalLibrary("work");
        if (library == null) {
            return null;
        }
        this.fPackageMain = (RfPackage)library.getLocalMember(RfPackage.ANY_DETERMINANT, Collections.singleton(RfPackage.class), "main", false, null);
        return this.fPackageMain;
    }

    public RfPackage getPackage(String name) {
        RfLibrary library = this.getLocalLibrary("work");
        if (library == null) {
            return null;
        }
        return (RfPackage)library.getLocalMember(RfPackage.ANY_DETERMINANT, Collections.singleton(RfPackage.class), name, false, null);
    }

    public RfLibrary getLocalLibrary(String name) {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        return (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)name);
    }

    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        return new NullProtectedList<RfLibrary>((Collection<RfLibrary>)resultMap.values());
    }

    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        return resultMap.isEmpty() ? null : (RfLibrary)resultMap.values().iterator().next();
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter filter) {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        RfLibrary member = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)name);
        if (classes == null || classes.contains(RfLibrary.class)) {
            return member;
        }
        return null;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        if (this.fRfProjectContent.fLibraries == null || classes != null && !classes.contains(RfLibrary.class)) {
            return null;
        }
        RfNamedElement candidate = (RfNamedElement)this.fRfProjectContent.fLibraries.get((Object)name);
        return candidate;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.pssdt.templates.contextType.component";
    }

    public Map<ParserPath, DVTEditor> getFileEditors() {
        return this.fParserPathToEditorMap;
    }

    public static IPath getExtensionsPath(IProject project, String ext) {
        IPath stateLocation = ro.amiq.pssdt.utils.Utils.getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append(String.valueOf(project.getName()) + EXTENSIONS_PREFIX + ext);
        return topLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSemanticError(int messageType, String pattern, LibraryPackageScope libraryPackageScope, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        if (this.fProject == null) {
            return true;
        }
        String resourcePath = this.parser2resource(parserPath);
        if (resourcePath != null && DEBUG_EXPRESSION_PATH.equals(resourcePath)) {
            return true;
        }
        Object object = this.fSemanticErrorsLock;
        synchronized (object) {
            boolean maxSizeReached;
            Collection<RfSemanticError> errors = this.fSemanticErrors.get(resourcePath);
            if (errors == null) {
                errors = new LinkedHashSet<RfSemanticError>();
                this.fSemanticErrors.put(resourcePath, errors);
            }
            int maxSemanticIssuesPerFile = this.getMaxSemanticIssuesPerFile();
            int nofProblems = errors.size();
            boolean bl = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
            if (maxSizeReached && nofProblems <= 2 * maxSemanticIssuesPerFile) {
                nofProblems = 0;
                for (RfSemanticError problem : errors) {
                    if (messageType != problem.getSeverity()) continue;
                    ++nofProblems;
                }
                boolean bl2 = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
            }
            if (!maxSizeReached) {
                String message = MessageFormat.format(pattern, arguments);
                if (!this.fReparseStack.isEmpty()) {
                    message = DVTStringUtil.appendString((Object[])new Object[]{message, "\n    at line ", line, " in ", parserPath});
                    ReparseInfo reparseInfo = this.fReparseStack.get(0);
                    line = reparseInfo.lineInfo.line;
                    parserPath = reparseInfo.parserPath;
                    int prevLine = line;
                    ParserPath prevParserPath = parserPath;
                    int i = 1;
                    while (i < this.fReparseStack.size()) {
                        reparseInfo = this.fReparseStack.get(i);
                        if (prevLine != reparseInfo.lineInfo.line || !prevParserPath.equals((Object)reparseInfo.parserPath)) {
                            message = DVTStringUtil.appendString((Object[])new Object[]{message, "\n    at line ", reparseInfo.lineInfo.line, " in ", reparseInfo.parserPath});
                            prevLine = reparseInfo.lineInfo.line;
                            prevParserPath = reparseInfo.parserPath;
                        }
                        ++i;
                    }
                    offsetEnd = -1;
                    offsetStart = -1;
                    resourcePath = this.parser2resource(parserPath);
                }
                RfSemanticError error = new RfSemanticError(messageType, message, this.getFileIndex(parserPath), line, resourcePath);
                if (offsetStart != -1 && offsetEnd != -1) {
                    error.setOffsetStart(offsetStart);
                    error.setOffsetEnd(offsetEnd);
                }
                error.setAttributes(attributes);
                errors.add(error);
            }
        }
        return true;
    }

    public final int getFileIndex(ParserPath parserPath) {
        RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return -1;
        }
        return fileDef.getIndex();
    }

    public RfFileDef getFileDefUsingParserPath(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
    }

    public RfMixedLangProject getMixedLangProjectParent() {
        return this.fMixedLangProjectParent;
    }

    public String getNature() {
        return "ro.amiq.pssdt.pssnature";
    }

    public String getBuildConfig() {
        return this.fBuildConfig;
    }

    public RfProjectState getProjectState() {
        return this.fProjectState;
    }

    public void setProjectState(RfProjectState state) {
        this.fProjectState = state;
    }

    public String parser2resource(ParserPath parserPath) {
        return DVTFileUtils.getInstance().parser2resource(this.fProject, parserPath);
    }

    public ParserPath resource2parser(IResource file) {
        return DVTFileUtils.getInstance().resource2parser(file);
    }

    private Set<ParserPath> resource2parser(Set<FileCompileInfo> changedFiles) {
        return DVTFileUtils.getInstance().resource2parser(changedFiles);
    }

    public RfNamedElement getSemanticScope() {
        return this.fScopeStack != null ? this.fScopeStack.peek() : null;
    }

    public boolean isUndeclaredIdentifierChecks() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        try {
            RfLibrary library;
            Collection<RfLibrary> libraries = this.getLibraries();
            if (libraries == null) return true;
            Iterator<RfLibrary> iterator = libraries.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((library = iterator.next()).visitHidObject(rfProject, visitor));
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public static void debugDelay() {
    }

    public void computeFilesIncludedByMatchingTop(Map<StringMatcher, Set<String>> expanded) {
        for (ParserPath parserPath : this.getCompiledFilesSet()) {
            for (Map.Entry<StringMatcher, Set<String>> entry : expanded.entrySet()) {
                if (!entry.getKey().match(parserPath.path)) continue;
                entry.getValue().add(parserPath.path);
            }
        }
    }

    public Set<String> computeFilesInMacroReparseStack(IRfDefElement declaration) {
        return null;
    }

    public ElementType computeElementType(IRfNamedElement namedElement, ElementPath instancePath) {
        if (namedElement instanceof RfPackage) {
            return new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).getStructKind() == StructKind.COMPONENT) {
            return new ElementType(ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).getStructKind() == StructKind.ACTION) {
            return new ElementType(ElementType.ElementTypeName.ACTION, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfStruct) {
            return new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfEnumType || namedElement instanceof RfTypeAlias) {
            return new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfCovergroup) {
            return new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfField) {
            if (((RfField)namedElement).isCovercross()) {
                return new ElementType(ElementType.ElementTypeName.COVER_CROSS, ElementType.ElementTypeLanguage.PSS);
            }
            if (((RfField)namedElement).isCoverpoint()) {
                return new ElementType(ElementType.ElementTypeName.COVER_POINT, ElementType.ElementTypeLanguage.PSS);
            }
            return new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfMethod) {
            return new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfExecBlock && ((RfExecBlock)namedElement).isActivity()) {
            return new ElementType(ElementType.ElementTypeName.ACTIVITY, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfExecBlock) {
            return new ElementType(ElementType.ElementTypeName.EXEC_BLOCK, ElementType.ElementTypeLanguage.PSS);
        }
        if (namedElement instanceof RfBlock) {
            if (((RfBlock)namedElement).isConstraint()) {
                return new ElementType(ElementType.ElementTypeName.CONSTRAINT, ElementType.ElementTypeLanguage.PSS);
            }
            return new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.PSS);
        }
        return null;
    }

    public ElementType computeElementType(IRfDefElement defElement, IRfNamedElement namedElement, ElementPath instancePath) {
        IRfNamedElement rfNamedElement = defElement.getNamedElement();
        if (rfNamedElement == null) {
            return this.computeElementType(namedElement, instancePath);
        }
        return this.computeElementType(rfNamedElement, instancePath);
    }

    public IIdleListener getIdleListener() {
        return null;
    }

    @Override
    public void deepClean() {
        if (this.fFileReferenceToPSSFileInfoMap != null && !this.fFileReferenceToPSSFileInfoMap.isEmpty()) {
            for (PSSFileInfo info : this.fFileReferenceToPSSFileInfoMap.values()) {
                info.setAST(null);
            }
        }
        if (this.fRfProjectContent != null) {
            this.fRfProjectContent.deepClean();
        }
        this.getFileInstancesMap();
        super.deepClean();
    }

    public boolean preRestore() {
        this.clean();
        boolean result = RfManager.getInstance().preRestoreRfProject(this);
        if (this.fRfProjectContent == null) {
            this.fRfProjectContent = new RfProjectContent();
        }
        this.fRfProjectContent.init(this);
        if (this.fRfCompiledFiles == null) {
            this.fRfCompiledFiles = new RfCompiledFiles();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restore(IProgressMonitor monitor) {
        try {
            var2_2 = this.fRestoreModulesLock;
            synchronized (var2_2) {
                if (this.fFullBuildFileReferences == null) {
                    return;
                }
                {
                    this.fRestoreFileReferences = new ArrayList<FileReference>(this.fFullBuildFileReferences);
                    this.fFullBuildFileReferences.clear();
                }
            }
            monitor.beginTask("", this.fRestoreFileReferences.size());
            index = 0;
            {
                for (FileReference fileReference : this.fRestoreFileReferences) {
                    ++index;
                    if (monitor.isCanceled()) {
                        this.clean();
                        break;
                    }
                    monitor.subTask("Load from dictionary (" + index + "/" + this.fRestoreFileReferences.size() + ") module: " + fileReference);
                    info = this.loadFileInfo(this.fProject, fileReference.parserPath, fileReference.fileIndex);
                    if (info == null) {
                        return;
                    }
                    ** try [egrp 5[TRYBLOCK] [7 : 208->309)] { 
lbl24:
                    // 1 sources

                    info.setProject(this.fProject);
                    this.build(info, false);
                    monitor.worked(1);
                }
                monitor.beginTask("", 1);
                monitor.subTask("Resolve types");
                this.postFullBuild(false, false);
                this.postMixedLangFullBuild(null, false);
                monitor.worked(1);
                BuildEventManager.getInstance().notifyFullBuild(this.getProject());
                var3_6 = this.fRestoreModulesLock;
                synchronized (var3_6) {
                    this.fRestoreFileReferences = null;
                    return;
                }
            }
        }
lbl41:
        // 2 sources

        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        finally {
            ro.amiq.pssdt.utils.Utils.connectActiveOpenEditor(this);
            monitor.done();
        }
    }

    private final PSSFileInfo loadFileInfo(IProject project, ParserPath parserPath, int fileIndex) {
        String fileName;
        ObjectInputStream ois;
        block14: {
            block13: {
                ois = null;
                try {
                    fileName = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)(String.valueOf(Integer.toHexString(parserPath.hashCode())) + "_" + fileIndex), (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                    if (fileName != null) break block13;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logDebug("Error loading module '" + parserPath + "' info (" + e.getMessage() + ").");
                    return null;
                }
            }
            File file = new File(fileName);
            if (file.exists()) break block14;
            return null;
        }
        Throwable throwable = null;
        Object var8_10 = null;
        try (BufferedInputStream bif = new BufferedInputStream(new FileInputStream(fileName), 32768);){
            ois = new ObjectInputStream(bif);
            PSSFileInfo readObject = (PSSFileInfo)ois.readObject();
            return readObject;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void debugIncrement1() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount1.incrementAndGet();
        }
    }

    public static void debugIncrement2() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount2.incrementAndGet();
        }
    }

    public static void debugIncrement3() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount3.incrementAndGet();
        }
    }

    public static void incrementTime1(int time) {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount4.addAndGet(time);
        }
    }

    public void accept(IRfNamedElementVisitor visitor) {
    }

    public boolean accept(RfDefElementVisitorAdapter visitor) throws Exception {
        if (this.fRfCompiledFiles == null) {
            return false;
        }
        for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
            if (fileDef.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    public void syncCancelSave() {
    }

    public void getSortCandidatesForContentAssist(IRfNamedElement[] sortedCandidates, String prefix) {
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
    }

    public boolean isLintingEnabled() {
        return false;
    }

    public void stopLintTracking() {
    }

    public DVTPFModel getPFModel() {
        return null;
    }

    public void addUndeclaredVarNameReference(FileReference reference, String name) {
        if (this.fUndeclaredVarNameReferences == null) {
            this.fUndeclaredVarNameReferences = new HashMap<String, Set<FileReference>>();
        }
        this.addUndeclaredNameReference(this.fUndeclaredVarNameReferences, reference, name);
    }

    public void addUndeclaredTypeNameReference(FileReference reference, String name) {
        if (this.fUndeclaredTypeNameReferences == null) {
            this.fUndeclaredTypeNameReferences = new HashMap<String, Set<FileReference>>();
        }
        this.addUndeclaredNameReference(this.fUndeclaredTypeNameReferences, reference, name);
    }

    private final void addUndeclaredNameReference(Map<String, Set<FileReference>> undeclaredNameReferences, FileReference reference, String name) {
        Set<FileReference> references = undeclaredNameReferences.get(name);
        if (references == null) {
            references = new HashSet<FileReference>();
            undeclaredNameReferences.put(name, references);
        }
        references.add(reference);
    }

    private void cleanUndeclaredReferences(FileReference reference) {
        this.cleanUndeclaredNameReference(this.fUndeclaredVarNameReferences, reference);
        this.cleanUndeclaredNameReference(this.fUndeclaredTypeNameReferences, reference);
    }

    private final void cleanUndeclaredNameReference(Map<String, Set<FileReference>> undeclaredNameReferences, FileReference reference) {
        if (undeclaredNameReferences == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(undeclaredNameReferences.keySet());
        for (String name : names) {
            Set<FileReference> references = undeclaredNameReferences.get(name);
            if (references == null) continue;
            references.remove(reference);
            if (!references.isEmpty()) continue;
            undeclaredNameReferences.remove(name);
        }
    }

    public void addNewDefinedVarName(RfNamedElement element) {
        if (this.fAddedVarsInCurrentFile == null) {
            return;
        }
        this.fAddedVarsInCurrentFile.add(element);
    }

    public void addNewDefinedTypeName(RfNamedElement type) {
        if (this.fAddedTypesInCurrentFile == null) {
            return;
        }
        this.fAddedTypesInCurrentFile.add(type);
    }

    private void initNewDefinedElementsInCurrentFile(boolean incremental) {
        if (incremental) {
            this.fAddedVarsInCurrentFile = new ArrayList<RfNamedElement>();
            this.fAddedTypesInCurrentFile = new ArrayList<RfNamedElement>();
        } else {
            this.fAddedVarsInCurrentFile = null;
            this.fAddedTypesInCurrentFile = null;
        }
    }

    public Set<FileReference> getPotentialyDependentModuleReferences(int fileIndex) {
        HashSet<FileReference> result = new HashSet<FileReference>();
        this.getNewDefinedNamesReferences(result, this.fAddedVarsInCurrentFile, this.fUndeclaredVarNameReferences, fileIndex);
        this.getNewDefinedNamesReferences(result, this.fAddedTypesInCurrentFile, this.fUndeclaredTypeNameReferences, fileIndex);
        return result;
    }

    private final void getNewDefinedNamesReferences(Set<FileReference> result, Collection<? extends RfNamedElement> addedElementsInCurrentFile, Map<String, Set<FileReference>> undeclaredNameReferences, int fileIndex) {
        if (addedElementsInCurrentFile == null || undeclaredNameReferences == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : addedElementsInCurrentFile) {
            Set<FileReference> references;
            if (rfNamedElement instanceof RfEnumType) {
                this.getNewDefinedNamesReferences(result, ((RfEnumType)rfNamedElement).getLocalMembers(), this.fUndeclaredVarNameReferences, fileIndex);
            }
            if (rfNamedElement instanceof RfField && !(rfNamedElement instanceof RfEnumItem) && ((RfField)rfNamedElement).getAssociatedType() instanceof RfEnumType) {
                this.getNewDefinedNamesReferences(result, ((RfEnumType)((RfField)rfNamedElement).getAssociatedType()).getLocalMembers(), this.fUndeclaredVarNameReferences, fileIndex);
            }
            if ((references = undeclaredNameReferences.get(rfNamedElement.getName())) == null) continue;
            for (FileReference reference : references) {
                if (reference.fileIndex < fileIndex) continue;
                result.add(reference);
            }
        }
    }

    public void addDependentFileReference(FileReference current, FileReference reference) {
        Set<FileReference> references;
        if (this.fDependentFileReferences == null) {
            this.fDependentFileReferences = new HashMap<FileReference, Set<FileReference>>();
        }
        if ((references = this.fDependentFileReferences.get(current)) == null) {
            references = new HashSet<FileReference>();
            this.fDependentFileReferences.put(current, references);
        }
        references.add(reference);
    }

    public List<FileReference> getSemanticDependentFileReferences(FileReference current) {
        Set<FileReference> result = this.getPotentialyDependentModuleReferences(current.fileIndex);
        if (this.fDependentFileReferences != null) {
            Set<FileReference> dependencies = this.fDependentFileReferences.get(current);
            Set<ParserPath> compiledFilesSet = this.getCompiledFilesSet();
            if (dependencies != null && !dependencies.isEmpty() && compiledFilesSet != null) {
                for (FileReference dependency : dependencies) {
                    if (!compiledFilesSet.contains(dependency.parserPath)) continue;
                    result.add(dependency);
                }
            }
        }
        ArrayList<FileReference> sorted = new ArrayList<FileReference>(result);
        Collections.sort(sorted);
        return sorted;
    }

    public boolean testIsPredefinedLibraryFile(ParserPath parserPath) {
        return this.isPredefinedLibraryFile(parserPath);
    }

    public void setPFModel(DVTPFModel powerFormatModel) {
    }

    public Image getImage() {
        return null;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return null;
    }

    public void addInactiveCode(boolean isCStyle, boolean ifBranch, LineInfo ifLine, LineInfo elseLine, LineInfo endLine) {
        if (this.fCurrentFileDef == null) {
            return;
        }
        ParserPath parserPath = this.fCurrentFileDef.getParserPath();
        this.addInactiveCode(isCStyle, ifBranch, ifLine, elseLine, endLine, parserPath);
    }

    public void addInactiveCode(boolean isCStyle, boolean ifBranch, LineInfo ifLine, LineInfo elseLine, LineInfo endLine, ParserPath parserPath) {
        RfInactiveCodeFileInfo infosForFile;
        if (endLine == null || ifLine == null) {
            return;
        }
        if (ifBranch && (elseLine == null || elseLine.line == -1)) {
            return;
        }
        if (this.fInactiveCodeInfos == null) {
            this.fInactiveCodeInfos = new HashMap<ParserPath, RfInactiveCodeFileInfo>();
        }
        if ((infosForFile = this.fInactiveCodeInfos.get(parserPath)) == null) {
            infosForFile = new RfInactiveCodeFileInfo();
            this.fInactiveCodeInfos.put(parserPath, infosForFile);
        }
        if (ifBranch) {
            infosForFile.addLineInfo(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(elseLine.line, endLine.line, isCStyle));
        } else if (elseLine != null && elseLine.line != -1) {
            infosForFile.addLineInfo(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(ifLine.line, elseLine.line, isCStyle));
        } else {
            infosForFile.addLineInfo(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(ifLine.line, endLine.line, isCStyle));
        }
    }

    private boolean checkCustomPragmas(ParserPath parserPath) {
        if (parserPath == null) {
            return false;
        }
        LibraryPackageScope libPkgScope = new LibraryPackageScope("[dummy]", null, RfElementPath.UNKNOWN_ELEMENT_PATH);
        List<CustomPragmaUsage> customPragmas = ro.amiq.pssdt.utils.Utils.getCustomPragmas(this, parserPath);
        if (customPragmas == null || customPragmas.isEmpty()) {
            return false;
        }
        ArrayDeque<CustomPragmaUsage> workingPragmas = new ArrayDeque<CustomPragmaUsage>();
        ArrayList<CustomPragmaUsage> sortedPragmas = new ArrayList<CustomPragmaUsage>();
        for (CustomPragmaUsage pragma : customPragmas) {
            int errorType;
            int n = errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
            if (pragma.getKind() == CustomPragmaUsage.Kind.START) {
                if (workingPragmas.size() < 3) {
                    workingPragmas.push(pragma);
                    continue;
                }
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_NESTING_EXCEEDED: More than 3 nested custom pragmas found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, new Object[0]);
                continue;
            }
            if (workingPragmas.isEmpty()) {
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_UNEXPECTED_END: No ''{0}'' start found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getStartPragma());
                sortedPragmas.add(pragma);
                continue;
            }
            CustomPragmaUsage stackPragma = (CustomPragmaUsage)workingPragmas.pop();
            if (!stackPragma.getPragmaName().equals(pragma.getPragmaName())) {
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_MISMATCH: Expecting ''{0}'' found ''{1}''", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, stackPragma.getPragma().getEndPragma(), pragma.getPragma().getEndPragma());
                workingPragmas.push(stackPragma);
                sortedPragmas.add(pragma);
                continue;
            }
            stackPragma.setValid();
            pragma.setValid();
            sortedPragmas.add(stackPragma);
            sortedPragmas.add(pragma);
        }
        while (!workingPragmas.isEmpty()) {
            CustomPragmaUsage pragma;
            pragma = (CustomPragmaUsage)workingPragmas.pop();
            sortedPragmas.add(pragma);
            int errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
            this.addSemanticError(errorType, "CUSTOM_PRAGMA_NO_END: No matching ''{0}'' end pragma found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getEndPragma());
        }
        ro.amiq.pssdt.utils.Utils.setCustomPragmas(this, parserPath, sortedPragmas);
        return true;
    }

    public List<RfNamedElement> getAllElements(int searchFor) {
        RfElementVisitor visitor = new RfElementVisitor(searchFor);
        try {
            this.accept(visitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return visitor.getResult();
    }

    private void startNameChecking(Set<ParserPath> parserPaths, int buildKind) {
        NameCheckerWarningsManager.getInstance().clean();
        if (parserPaths == null || parserPaths.isEmpty()) {
            return;
        }
        for (ParserPath parserPath : parserPaths) {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) continue;
            NameCheckerWarningsManager.getInstance().build(buildKind, fileDef, this.fProject);
        }
    }

    public Set<ParserPath> getRawCompiledFilesSet() {
        if (this.fRfCompiledFiles == null) {
            return null;
        }
        return this.fRfCompiledFiles.fCompiledFiles;
    }

    public List<RfNamedElement> getAllPackages() {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        if (this.fRfProjectContent.fLibraries != null) {
            for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
                result.addAll(library.getLocalMembers());
            }
        }
        return result;
    }

    @Override
    public void getQualifiedName(StringBuilder name) {
    }

    public IProgressMonitor getBuildProgressMonitor() {
        return this.fBuildProgressMonitor;
    }

    public ChangedFilesManager getChangedFilesManager() {
        if (this.fChangedFilesManager == null) {
            this.fChangedFilesManager = new ChangedFilesManager();
        }
        return this.fChangedFilesManager;
    }

    public static class ElementContainer {
        public RfNamedElement element;
        public RfDefElement def;

        public ElementContainer(RfNamedElement element) {
            this.element = element;
        }

        public ElementContainer(RfDefElement def) {
            this.element = def == null ? null : def.getNamedElement();
            this.def = def;
        }

        public ElementContainer(RfDefElement def, RfNamedElement element) {
            this.element = def == null ? element : def.getNamedElement();
            this.def = def;
        }
    }

    public static class FileReference
    implements Comparable<FileReference>,
    Serializable {
        private static final long serialVersionUID = 21101L;
        public ParserPath parserPath;
        public int fileIndex;

        public FileReference(ParserPath parserPath, int fileIndex) {
            this.parserPath = parserPath;
            this.fileIndex = fileIndex;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.parserPath == null ? 0 : this.parserPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileReference other = (FileReference)obj;
            return !(this.parserPath == null ? other.parserPath != null : !this.parserPath.equals((Object)other.parserPath));
        }

        @Override
        public int compareTo(FileReference o) {
            return this.fileIndex - o.fileIndex;
        }

        public String toString() {
            return this.parserPath.toString();
        }
    }

    public static enum ImportMode {
        SEMANTIC_SCOPE,
        LEXICAL_SCOPE;

    }

    static class ReparseInfo {
        private LineInfo lineInfo;
        private ParserPath parserPath;

        public ReparseInfo(LineInfo lineInfo, ParserPath parserPath) {
            this.lineInfo = lineInfo;
            this.parserPath = parserPath;
        }
    }

    public static class RfElementVisitor
    extends RfDefElementVisitorAdapter {
        private List<RfNamedElement> result = new ArrayList<RfNamedElement>();
        private int search;

        public RfElementVisitor(int search) {
            this.search = search;
        }

        public boolean isSearchedElement(IRfNamedElement element) {
            switch (this.search) {
                case 0: {
                    return element instanceof RfStruct || element instanceof RfEnumType;
                }
                case 1: {
                    return element instanceof RfField;
                }
                case 2: {
                    return element instanceof RfMethod;
                }
                case 3: {
                    return element instanceof RfField && ((RfField)element).isPool();
                }
            }
            return false;
        }

        @Override
        public boolean visit(RfDefElement defElement) {
            RfNamedElement namedElement = defElement.getNamedElement();
            if (namedElement == null) {
                return true;
            }
            if (this.isSearchedElement(namedElement)) {
                this.result.add(namedElement);
            }
            return true;
        }

        public List<RfNamedElement> getResult() {
            return this.result;
        }
    }
}

