/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.model.reflection.util.RfNameTypeScopeHelper;

public class RfScopeUtil {
    public static IRfScopeElement getScopeElementOfDef(RfProject rfProject, List<RfNameTypeScopeHelper> elementScope) {
        if (elementScope == null) {
            return null;
        }
        if (rfProject == null) {
            return null;
        }
        RfNamedElement scope = rfProject;
        for (RfNameTypeScopeHelper typeScopeHelper : elementScope) {
            RfNamedElement candidate = null;
            int elementKind = typeScopeHelper.getElementKind();
            String elementName = typeScopeHelper.getElementName();
            if (scope instanceof RfNamedElement && elementKind == 1024) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, Collections.singleton(RfLibrary.class), elementName, false, null);
            } else if (scope instanceof RfNamedElement && elementKind == 4096) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, Collections.singleton(RfBlock.class), elementName, false, null);
            } else if (scope instanceof RfNamedElement && elementKind == 32) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, Collections.singleton(RfBlock.class), elementName, false, null);
            } else if (scope instanceof RfNamedElement && elementKind == 512) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, Collections.singleton(RfPackage.class), elementName, false, null);
            } else if (scope instanceof RfNamedElement && elementKind == 64) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, Collections.singleton(RfStruct.class), elementName, false, null);
            } else if (scope instanceof RfNamedElement && elementKind == 2048) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, SemanticUtils.MEMBER_ENUM_TYPES, elementName, false, null);
            } else if (scope instanceof RfNamedElement && elementKind == 4) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, SemanticUtils.MEMBER_METHODS, elementName, false, null);
            } else if (scope instanceof RfNamedElement && elementKind == 2) {
                candidate = ((RfNamedElement)scope).getLocalMember(null, SemanticUtils.MEMBER_FIELDS, elementName, false, null);
            } else if (scope instanceof RfProject && elementKind == 16384) {
                if (elementName == null || elementName.isEmpty()) continue;
                candidate = ((RfProject)scope).getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)((RfProject)scope), elementName, 1);
            } else if (!(scope instanceof RfNamedElement) && scope instanceof IRfLibraryElement && elementKind == 16384) {
                candidate = ((IRfLibraryElement)scope).getDesignWithPrefix(elementName, 1);
            } else {
                return scope;
            }
            if (candidate == null) {
                return scope;
            }
            scope = candidate;
        }
        return scope;
    }

    public static List<RfNameTypeScopeHelper> getDefOfScopeElement(IRfScopeElement elementScope) {
        if (elementScope == null) {
            return null;
        }
        ArrayList<RfNameTypeScopeHelper> result = new ArrayList<RfNameTypeScopeHelper>();
        IRfScopeElement scope = elementScope;
        do {
            if (scope instanceof RfProject) {
                return result;
            }
            if (!(scope instanceof IRfNamedElement)) {
                return result;
            }
            result.add(0, new RfNameTypeScopeHelper((IRfNamedElement)scope));
        } while ((scope = ((IRfNamedElement)scope).getEnclosingScope()) != null);
        return result;
    }
}

