/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfClassType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfExtendDuplicate;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;
import ro.amiq.pssdt.model.reflection.StructKind;

public class RfStruct
extends RfClassType {
    public static final int PURE = 1;
    public static final String PSS_TOP_COMPONENT_NAME = "pss_top";
    public static final String PSS_BASE_COMPONENT_NAME = "___internal_base_component";
    public static final String PSS_BASE_ACTION_NAME = "___internal_base_action";
    public static final String PSS_BASE_RESOURCE_NAME = "___internal_base_resource";
    public static final String PSS_BASE_BUFFER_NAME = "___internal_base_buffer";
    public static final String PSS_BASE_STATE_NAME = "___internal_base_state";
    public static final String PSS_BASE_STREAM_NAME = "___internal_base_stream";
    public static final String PSS_BASE_STRUCT_NAME = "___internal_base_struct";
    private StructKind structKind = StructKind.STRUCT;
    private int qualifiers;

    public RfStruct(String name) {
        super(name);
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (currentLayer != null && currentLayer.isIs()) {
            RfNamedElement enclosingStruct;
            List<RfDefElement> layers = this.getLayers();
            if (layers.size() > 1) {
                for (RfDefElement layer : layers) {
                    if (layer == currentLayer) break;
                    if (!layer.isIs()) continue;
                    int startOffset = currentLayer.getStartOffset();
                    int endOffset = startOffset + this.getName().length();
                    int startLine = currentLayer.getStartLine();
                    ParserPath parserPath = currentLayer.getParserPath();
                    int prevStartLine = layer.getStartLine();
                    ParserPath prevParserPath = layer.getParserPath();
                    project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
                }
            }
            if ((enclosingStruct = this.getEnclosingScope()) instanceof RfStruct && ((RfStruct)enclosingStruct).hasQualifier(1)) {
                int startOffset = currentLayer.getStartOffset();
                int endOffset = startOffset + this.getName().length();
                int startLine = currentLayer.getStartLine();
                ParserPath parserPath = currentLayer.getParserPath();
                project.addSemanticError(1, "ILLEGAL_DECLARATION: ''{0}'' {1} is not allowed under ''{2}'' {3} type", null, startOffset, endOffset, null, startLine, parserPath, this.getName(), DVTStringUtil.appendString((Object[])new Object[]{this.structKind.toString(), " type"}), enclosingStruct.getName(), "pure component");
                return;
            }
        }
    }

    public void setQualifiers(int qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    public boolean hasQualifier(int qualifier) {
        return (this.qualifiers & qualifier) == qualifier;
    }

    @Override
    public String getKindName() {
        if (this.structKind == null) {
            return null;
        }
        return this.structKind.toString();
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter elementFilter) {
        RfProject project;
        if (this.structKind == StructKind.ACTION && (classes == null || classes.contains(RfPredefinedField.class)) && "comp".equals(name)) {
            RfPredefinedField compField = new RfPredefinedField("comp", new DataType(this.getName()), "The comp field is a handle to the component context in which the action is executing");
            compField.setAssociatedType(this.getEnclosingScope());
            compField.setEnclosingScope(this);
            if (elementFilter == null || elementFilter.validElement((IRfNamedElement)compField)) {
                return compField;
            }
        }
        if (this.structKind == StructKind.STATE && (classes == null || classes.contains(RfPredefinedField.class)) && "initial".equals(name)) {
            RfPredefinedField initField = new RfPredefinedField("initial", DataType.BOOL, "Prior to execution of an action that outputs a state object to the pool, the pool contains the initial object. The initial flag is true for the initial object and false for all other objects subsequently residing in the pool.");
            project = this.getRfProject();
            if (project != null) {
                initField.setAssociatedType(project.getPredefinedType("bool"));
            }
            initField.setEnclosingScope(this);
            initField.setFieldModifier(FieldModifier.RAND);
            if (elementFilter == null || elementFilter.validElement((IRfNamedElement)initField)) {
                return initField;
            }
        }
        if (this.structKind == StructKind.STATE && (classes == null || classes.contains(RfPredefinedField.class)) && "prev".equals(name)) {
            RfPredefinedField prevField = new RfPredefinedField("prev", new DataType(this.getName()), "Within the context of a state type, reference can be made to attributes of the previous state, relating them in Boolean expressions to attributes values of this state. This is done by using the built-in reference variable prev");
            prevField.setAssociatedType(this);
            prevField.setEnclosingScope(this);
            if (elementFilter == null || elementFilter.validElement((IRfNamedElement)prevField)) {
                return prevField;
            }
        }
        if (this.structKind == StructKind.RESOURCE && (classes == null || classes.contains(RfPredefinedField.class)) && "instance_id".equals(name)) {
            RfPredefinedField instanceIdField = new RfPredefinedField("instance_id", DataType.INT, "Each object in a resource pool has a unique instance_id value, ranging from 0 to the pool\u2019s size - 1");
            instanceIdField.setFieldModifier(FieldModifier.RAND);
            project = this.getRfProject();
            if (project != null) {
                instanceIdField.setAssociatedType(project.getPredefinedType("int"));
            }
            instanceIdField.setEnclosingScope(this);
            if (elementFilter == null || elementFilter.validElement((IRfNamedElement)instanceIdField)) {
                return instanceIdField;
            }
        }
        return super.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
    }

    @Override
    public void collectMembersForElab(Map<String, RfNamedElement> result, Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, boolean collectPredefinedAndActionQualifiedFields, IRfElementFilter elementFilter) {
        IRfClassType parent;
        if (collectPredefinedAndActionQualifiedFields) {
            RfProject project;
            if (this.structKind == StructKind.ACTION) {
                RfPredefinedField compField = new RfPredefinedField("comp", new DataType(this.getName()), "The comp field is a handle to the component context in which the action is executing");
                compField.setAssociatedType(this.getEnclosingScope());
                compField.setEnclosingScope(this);
                if (elementFilter == null || elementFilter.validElement((IRfNamedElement)compField)) {
                    result.put(compField.getName(), compField);
                }
            }
            if (this.structKind == StructKind.STATE) {
                RfPredefinedField initField = new RfPredefinedField("initial", DataType.BOOL, "Prior to execution of an action that outputs a state object to the pool, the pool contains the initial object. The initial flag is true for the initial object and false for all other objects subsequently residing in the pool.");
                project = this.getRfProject();
                if (project != null) {
                    initField.setAssociatedType(project.getPredefinedType("bool"));
                }
                initField.setEnclosingScope(this);
                if (elementFilter == null || elementFilter.validElement((IRfNamedElement)initField)) {
                    result.put(initField.getName(), initField);
                }
            }
            if (this.structKind == StructKind.STATE) {
                RfPredefinedField prevField = new RfPredefinedField("prev", new DataType(this.getName()), "Within the context of a state type, reference can be made to attributes of the previous state, relating them in boolean expressions to attributes values of this state. This is done by using the built-in reference variable prev");
                prevField.setAssociatedType(this);
                prevField.setEnclosingScope(this);
                if (elementFilter == null || elementFilter.validElement((IRfNamedElement)prevField)) {
                    result.put(prevField.getName(), prevField);
                }
            }
            if (this.structKind == StructKind.RESOURCE) {
                RfPredefinedField instanceIdField = new RfPredefinedField("instance_id", DataType.INT, "Each object in a resource pool has a unique instance_id value, ranging from 0 to the pool\u2019s size - 1");
                instanceIdField.setFieldModifier(FieldModifier.RAND);
                project = this.getRfProject();
                if (project != null) {
                    instanceIdField.setAssociatedType(project.getPredefinedType("int"));
                }
                instanceIdField.setEnclosingScope(this);
                if (elementFilter == null || elementFilter.validElement((IRfNamedElement)instanceIdField)) {
                    result.put(instanceIdField.getName(), instanceIdField);
                }
            }
        }
        if ((parent = this.getParent()) instanceof RfClassType) {
            ((RfClassType)parent).collectMembersForElab(result, determinant, classes, false, elementFilter);
        }
        super.collectMembersForElab(result, determinant, classes, collectPredefinedAndActionQualifiedFields, elementFilter);
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (clazz == null || clazz == RfField.class || clazz == RfField.RfIteratorField.class || clazz == RfPredefinedField.class) {
            RfProject project;
            if (this.structKind == StructKind.ACTION && (prefix == null || prefix.isEmpty() || DVTStringUtil.regionMatches((String)"comp", (String)prefix, (int)matchType))) {
                RfPredefinedField compField = new RfPredefinedField("comp", new DataType(this.getName()), "The comp field is a handle to the component context in which the action is executing");
                compField.setAssociatedType(this.getEnclosingScope());
                compField.setEnclosingScope(this);
                if (elementFilter.validElement((IRfNamedElement)compField)) {
                    result.add(compField);
                }
                if (result.size() == elementFilter.resultMaxSize()) {
                    throw new MaxSizeReachedException();
                }
            }
            if (this.structKind == StructKind.STATE && (prefix == null || prefix.isEmpty() || DVTStringUtil.regionMatches((String)"initial", (String)prefix, (int)matchType))) {
                RfPredefinedField initField = new RfPredefinedField("initial", DataType.BOOL, "Prior to execution of an action that outputs a state object to the pool, the pool contains the initial object. The initial flag is true for the initial object and false for all other objects subsequently residing in the pool.");
                project = this.getRfProject();
                if (project != null) {
                    initField.setAssociatedType(project.getPredefinedType("bool"));
                }
                initField.setEnclosingScope(this);
                if (elementFilter.validElement((IRfNamedElement)initField)) {
                    result.add(initField);
                }
                if (result.size() == elementFilter.resultMaxSize()) {
                    throw new MaxSizeReachedException();
                }
            }
            if (this.structKind == StructKind.STATE && (prefix == null || prefix.isEmpty() || DVTStringUtil.regionMatches((String)"prev", (String)prefix, (int)matchType))) {
                RfPredefinedField prevField = new RfPredefinedField("prev", new DataType(this.getName()), "Within the context of a state type, reference can be made to attributes of the previous state, relating them in Boolean expressions to attributes values of this state. This is done by using the built-in reference variable prev");
                prevField.setAssociatedType(this);
                prevField.setEnclosingScope(this);
                if (elementFilter.validElement((IRfNamedElement)prevField)) {
                    result.add(prevField);
                }
                if (result.size() == elementFilter.resultMaxSize()) {
                    throw new MaxSizeReachedException();
                }
            }
            if (this.structKind == StructKind.RESOURCE && (prefix == null || prefix.isEmpty() || DVTStringUtil.regionMatches((String)"instance_id", (String)prefix, (int)matchType))) {
                RfPredefinedField instanceIdField = new RfPredefinedField("instance_id", DataType.INT, "Each object in a resource pool has a unique instance_id value, ranging from 0 to the pool\u2019s size - 1");
                instanceIdField.setFieldModifier(FieldModifier.RAND);
                project = this.getRfProject();
                if (project != null) {
                    instanceIdField.setAssociatedType(project.getPredefinedType("int"));
                }
                instanceIdField.setEnclosingScope(this);
                if (elementFilter.validElement((IRfNamedElement)instanceIdField)) {
                    result.add(instanceIdField);
                }
                if (result.size() == elementFilter.resultMaxSize()) {
                    throw new MaxSizeReachedException();
                }
            }
        }
        super.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
    }

    @Override
    public List<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        List<RfNamedElement> result2;
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (classes == null) {
            RfProject project;
            if (this.structKind == StructKind.ACTION) {
                RfPredefinedField compField = new RfPredefinedField("comp", new DataType(this.getName()), "The comp field is a handle to the component context in which the action is executing");
                compField.setAssociatedType(this.getEnclosingScope());
                compField.setEnclosingScope(this);
                result.add(compField);
            }
            if (this.structKind == StructKind.STATE) {
                RfPredefinedField initField = new RfPredefinedField("initial", DataType.BOOL, "Prior to execution of an action that outputs a state object to the pool, the pool contains the initial object. The initial flag is true for the initial object and false for all other objects subsequently residing in the pool.");
                project = this.getRfProject();
                if (project != null) {
                    initField.setAssociatedType(project.getPredefinedType("bool"));
                }
                initField.setEnclosingScope(this);
                result.add(initField);
            }
            if (this.structKind == StructKind.STATE) {
                RfPredefinedField prevField = new RfPredefinedField("prev", new DataType(this.getName()), "Within the context of a state type, reference can be made to attributes of the previous state, relating them in Boolean expressions to attributes values of this state. This is done by using the built-in reference variable prev");
                prevField.setAssociatedType(this);
                prevField.setEnclosingScope(this);
                result.add(prevField);
            }
            if (this.structKind == StructKind.RESOURCE) {
                RfPredefinedField instanceIdField = new RfPredefinedField("instance_id", DataType.INT, "Each object in a resource pool has a unique instance_id value, ranging from 0 to the pool\u2019s size - 1");
                instanceIdField.setFieldModifier(FieldModifier.RAND);
                project = this.getRfProject();
                if (project != null) {
                    instanceIdField.setAssociatedType(project.getPredefinedType("int"));
                }
                instanceIdField.setEnclosingScope(this);
                result.add(instanceIdField);
            }
        }
        if ((result2 = super.getLocalMembers(determinant, classes)) != null && !result2.isEmpty()) {
            result.addAll(result2);
        }
        return result;
    }

    public String getSignature() {
        RfNamedElement enclosing = this.getEnclosingScope();
        String enclosingName = enclosing == null ? "" : String.valueOf(enclosing.getName()) + "::";
        switch (this.structKind) {
            case COMPONENT: {
                return "component " + this.getName();
            }
            case ACTION_ABSTRACT: {
                return "abstract action " + enclosingName + this.getName();
            }
            case ACTION: {
                return "action " + enclosingName + this.getName();
            }
            case STATE: {
                return "state " + enclosingName + this.getName();
            }
            case STREAM: {
                return "stream " + enclosingName + this.getName();
            }
            case BUFFER: {
                return "buffer " + enclosingName + this.getName();
            }
            case RESOURCE: {
                return "resource " + enclosingName + this.getName();
            }
            case IMPORT_CLASS: {
                return "import class " + enclosingName + this.getName();
            }
        }
        return "struct " + enclosingName + this.getName();
    }

    public Image getImage() {
        switch (this.structKind) {
            case COMPONENT: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_COMPONENT);
            }
            case ACTION: 
            case ACTION_ABSTRACT: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_ACTION);
            }
            case IMPORT_CLASS: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
            }
            case BUFFER: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_BUFFER);
            }
            case RESOURCE: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_RESOURCE);
            }
            case STATE: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_STATE);
            }
            case STREAM: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_STREAM);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
    }

    public Image getExtendImage() {
        switch (this.structKind) {
            case COMPONENT: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_COMPONENT_EXTEND);
            }
            case ACTION: 
            case ACTION_ABSTRACT: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_ACTION_EXTEND);
            }
            case IMPORT_CLASS: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
            }
            case BUFFER: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_BUFFER_EXTEND);
            }
            case RESOURCE: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_RESOURCE_EXTEND);
            }
            case STATE: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_STATE_EXTEND);
            }
            case STREAM: {
                return DVTImages.imageCache.getImage(DVTImages.PSS_STRUCT_STREAM_EXTEND);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        switch (this.structKind) {
            case COMPONENT: {
                return "DUPLICATE_COMPONENT: Duplicate component ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
            case ACTION: 
            case ACTION_ABSTRACT: {
                return "DUPLICATE_ACTION: Duplicate action ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
            case IMPORT_CLASS: {
                return "DUPLICATE_IMPORT_CLASS: Duplicate import class ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
        }
        return "DUPLICATE_STRUCT: Duplicate struct ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    public void setStructKind(StructKind kind) {
        this.structKind = kind;
    }

    @Override
    public StructKind getStructKind() {
        return this.structKind;
    }

    @Override
    public boolean isComponent() {
        return this.structKind == StructKind.COMPONENT;
    }

    @Override
    public boolean isAction(boolean includeAbstract) {
        return this.structKind == StructKind.ACTION || includeAbstract && this.structKind == StructKind.ACTION_ABSTRACT;
    }

    public List<RfDefElement> getActivities() {
        RfStruct parentStruct;
        if (this.members != null && !this.members.isEmpty()) {
            ArrayList<RfDefElement> activities = new ArrayList<RfDefElement>();
            for (RfNamedElement member : this.members) {
                Collection declarations;
                if (member instanceof RfExtendDuplicate) {
                    ((RfExtendDuplicate)member).getActivities(activities);
                    continue;
                }
                if (!(member instanceof RfExecBlock) || !((RfExecBlock)member).isActivity() || (declarations = member.getDeclarations()) == null) continue;
                activities.addAll(declarations);
            }
            if (!activities.isEmpty()) {
                Collections.sort(activities);
                return activities;
            }
        }
        if ((parentStruct = (RfStruct)this.getParent()) == null) {
            return Collections.emptyList();
        }
        return parentStruct.getActivities();
    }

    public RfStruct getEnclosingComponent() {
        RfNamedElement candidate = this.getEnclosingScope();
        while (candidate instanceof RfExtendDuplicate) {
            candidate = candidate.getEnclosingScope();
        }
        if (candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.COMPONENT) {
            return (RfStruct)candidate;
        }
        return null;
    }

    public boolean isTemplateStuct() {
        return this.getClass() == RfTemplateStruct.class;
    }

    public boolean isCompoundAction() {
        if (this.structKind != StructKind.ACTION) {
            return false;
        }
        List<RfDefElement> members = this.getActivities();
        return members != null && !members.isEmpty();
    }

    @Override
    public int sizeof() {
        int sizeof;
        if (this.structKind != StructKind.STRUCT) {
            throw new UnsupportedOperationException();
        }
        IRfClassType parent = this.getParent();
        int n = sizeof = parent == null ? 0 : ((RfStruct)parent).sizeof();
        if (sizeof < 0) {
            throw new UnsupportedOperationException();
        }
        List<RfNamedElement> localMembers = this.getLocalMembers(null, Collections.singleton(RfField.class));
        for (RfNamedElement localMember : localMembers) {
            sizeof += localMember.sizeof();
        }
        return sizeof;
    }

    public boolean isBinEndianPacking() {
        if (this.structKind != StructKind.STRUCT) {
            throw new UnsupportedOperationException();
        }
        IRfClassType parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return ((RfStruct)parent).isBinEndianPacking();
    }

    @Override
    public boolean isCoreLibInstanceOf(String ... names) {
        String packageName = this.getPackageName();
        if ("addr_reg_pkg".equals(packageName) && this.contains(names, this.getName())) {
            return true;
        }
        if ("executor_pkg".equals(packageName) && this.contains(names, this.getName())) {
            return true;
        }
        if ("std_pkg".equals(packageName) && this.contains(names, this.getName())) {
            return true;
        }
        IRfClassType parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return ((RfNamedElement)((Object)parent)).isCoreLibInstanceOf(names);
    }

    private final boolean contains(String[] names, String name) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

