/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.util.VisitedCheck;

public class RfTemplateInstance
extends RfTemplateStruct {
    private List<RfNamedElement> instanceParameters;
    private RfTemplateStruct templateStruct;
    private String unqualifiedName;

    public RfTemplateInstance(RfTemplateStruct templateStruct, List<RfNamedElement> instanceParameters) {
        super(DVTStringUtil.appendString((Object[])new Object[]{templateStruct.getName(), RfTemplateInstance.toString(instanceParameters, true)}));
        this.unqualifiedName = DVTStringUtil.appendString((Object[])new Object[]{templateStruct.getName(), RfTemplateInstance.toString(instanceParameters, false)});
        this.instanceParameters = instanceParameters;
        this.templateStruct = templateStruct;
        this.setStructKind(templateStruct.getStructKind());
    }

    @Override
    public boolean hasQualifier(int qualifier) {
        return this.templateStruct.hasQualifier(qualifier);
    }

    public RfNamedElement getParameterReplacement(RfTemplateParam templateParam) {
        return this.instanceParameters.get(templateParam.getIndex());
    }

    @Override
    public List<RfTemplateParam> getParameters() {
        return this.templateStruct.getParameters();
    }

    @Override
    public void addLayer(RfProject project, RfDefElement layer) {
        super.rawAddLayer(project, layer);
    }

    @Override
    public StructKind getStructKind() {
        return this.templateStruct.getStructKind();
    }

    @Override
    public boolean isComponent() {
        return this.templateStruct.isComponent();
    }

    @Override
    public boolean isLike(IRfClassType likeClassType) {
        return super.isLike(likeClassType);
    }

    public RfTemplateStruct getTemplateStruct() {
        return this.templateStruct;
    }

    public RfNamedElement getInstanceParameter(int index) {
        RfNamedElement instanceParam = this.instanceParameters.get(index);
        if (instanceParam instanceof RfTemplateParam.RfInstanceTypeParam) {
            return ((RfTemplateParam.RfInstanceTypeParam)instanceParam).getAssociatedType();
        }
        return instanceParam;
    }

    public List<RfNamedElement> getInstanceParameters() {
        return this.instanceParameters;
    }

    @Override
    public List<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        return super.getLocalMembers(determinant, classes);
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        super.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isAmbiguousCheck, IRfElementFilter elementFilter) {
        if (classes == null || classes.contains(RfTemplateParam.RfTemplateTypeParam.class) || classes.contains(RfTemplateParam.RfTemplateValueParam.class)) {
            List<RfTemplateParam> templateParameters = this.templateStruct.getParameters();
            for (RfTemplateParam templateParameter : templateParameters) {
                if (!name.equals(templateParameter.getName()) || elementFilter != null && !elementFilter.validElement((IRfNamedElement)templateParameter)) continue;
                return this.instanceParameters.get(templateParameter.getIndex());
            }
        }
        return super.getLocalMember(determinant, classes, name, isAmbiguousCheck, elementFilter);
    }

    @Override
    public void collectMembersForElab(Map<String, RfNamedElement> result, Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, boolean collectPredefinedAndActionQualifiedFields, IRfElementFilter elementFilter) {
        super.collectMembersForElab(result, determinant, classes, collectPredefinedAndActionQualifiedFields, elementFilter);
    }

    @Override
    public String getElabName() {
        return this.unqualifiedName;
    }

    @Override
    public String getNameForDiagram() {
        return this.getElabName();
    }

    private static String toString(List<RfNamedElement> instanceParameters, boolean qualified) {
        StringBuilder instanceName = new StringBuilder();
        boolean isFirst = true;
        for (RfNamedElement instanceParameter : instanceParameters) {
            instanceName.append(isFirst ? "<" : ", ");
            if (qualified) {
                instanceParameter.getQualifiedName(instanceName);
            } else {
                instanceName.append(instanceParameter.getName());
            }
            isFirst = false;
        }
        return instanceName.append(">").toString();
    }

    @Override
    protected void internalGetMember(Set<RfNamedElement> result, RfDefElement lexicalScope, Determinant determinant, VisitedCheck visited, String name, boolean isAmbiguousCheck, boolean isTransitiveImport, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        super.internalGetMember(result, lexicalScope, determinant, visited, name, isAmbiguousCheck, isTransitiveImport, isFirst, classes, filter);
    }

    @Override
    public RfStruct getEnclosingComponent() {
        return this.templateStruct.getEnclosingComponent();
    }

    @Override
    public int sizeof() {
        if (this.templateStruct.getStructKind() != StructKind.STRUCT) {
            throw new UnsupportedOperationException();
        }
        boolean isAddrRegPkgMember = this.templateStruct.isAddrRegPkgMember();
        if (isAddrRegPkgMember && "packed_s".equals(this.templateStruct.getName())) {
            return 0;
        }
        if (isAddrRegPkgMember && "sized_addr_handle_s".equals(this.templateStruct.getName())) {
            if (this.instanceParameters == null || this.instanceParameters.isEmpty() || !(this.instanceParameters.get(0) instanceof RfTemplateParam.RfInstanceValueParam)) {
                throw new UnsupportedOperationException();
            }
            return ((RfTemplateParam.RfInstanceValueParam)this.instanceParameters.get(0)).getValue().bigIntegerValue().intValueExact();
        }
        return super.sizeof();
    }

    @Override
    public boolean isPacked() {
        return this.templateStruct.isPacked();
    }

    @Override
    public boolean isBinEndianPacking() {
        if (this.templateStruct.getStructKind() != StructKind.STRUCT) {
            throw new UnsupportedOperationException();
        }
        boolean isAddrRegPkgMember = this.templateStruct.isAddrRegPkgMember();
        if (isAddrRegPkgMember && "packed_s".equals(this.templateStruct.getName())) {
            if (this.instanceParameters == null || this.instanceParameters.isEmpty() || !(this.instanceParameters.get(0) instanceof RfTemplateParam.RfInstanceValueParam)) {
                throw new UnsupportedOperationException();
            }
            return "BIG_ENDIAN".equals(((RfTemplateParam.RfInstanceValueParam)this.instanceParameters.get(0)).getName());
        }
        return false;
    }

    @Override
    public boolean isCoreLibInstanceOf(String ... names) {
        return this.templateStruct.isCoreLibInstanceOf(names);
    }

    public boolean isSizeofStruct() {
        return this.templateStruct.isCoreLibInstanceOf("sizeof_s");
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (this.equals(obj)) {
            return true;
        }
        if (obj instanceof RfTemplateStruct && this.templateStruct.equals(obj)) {
            return true;
        }
        return obj instanceof RfTemplateInstance && this.templateStruct.equals(((RfTemplateInstance)obj).getTemplateStruct());
    }
}

