/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.collections.AST;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.RfWalker;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public class RfTemplateParam
extends RfField {
    private int index;

    public RfTemplateParam(int index, String name, DataType dataType) {
        super(name, dataType);
        this.index = index;
    }

    @Override
    public boolean isParameter() {
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public static RfTemplateParam create(int index, String name, boolean isTypeParameter, DataType dataType, StructKind structKind) {
        if (isTypeParameter) {
            return new RfTemplateTypeParam(index, name, structKind);
        }
        return new RfTemplateValueParam(index, name, dataType);
    }

    public RfNamedElement getDefault() {
        return null;
    }

    public static class RfInstanceTypeParam
    extends RfTypeAlias {
        public RfInstanceTypeParam(DataType dataType, RfNamedElement associatedType) {
            super(null, dataType);
            this.setAssociatedType(associatedType);
        }

        @Override
        public void setAssociatedType(RfNamedElement associatedType) {
            super.setAssociatedType(associatedType == null ? RfWalker.UNRESOLVED_ELEMENT : associatedType);
        }

        @Override
        public String getName() {
            RfNamedElement associatedType = this.getAssociatedType();
            String assocTypeName = null;
            assocTypeName = associatedType == this ? this.getAssociatedTypeName() : associatedType.getName();
            int nofBits = SemanticUtils.nofBits(this);
            return nofBits >= 0 ? DVTStringUtil.appendString((Object[])new Object[]{assocTypeName, "[", nofBits, "]"}) : assocTypeName;
        }

        @Override
        public void getQualifiedName(StringBuilder name) {
            RfNamedElement associatedType = this.getAssociatedType();
            if (associatedType == this) {
                name.append(this.getAssociatedTypeName());
            } else {
                associatedType.getQualifiedName(name);
            }
            int nofBits = SemanticUtils.nofBits(this);
            if (nofBits >= 0) {
                name.append("[").append(nofBits).append("]");
            }
        }
    }

    public static class RfInstanceValueParam
    extends RfField {
        private BitVectorInt value;

        public RfInstanceValueParam(BitVectorInt value) {
            super(null, new DataType("<unknown>"));
            this.value = value;
            this.setFieldModifier(FieldModifier.CONST);
        }

        @Override
        public void setDataType(DataType dataType) {
            super.setDataType(dataType);
        }

        @Override
        public String getName() {
            return this.value == null ? "null" : (this.value.getEnumItemName() != null ? this.value.getEnumItemName() : this.value.toString());
        }

        public BitVectorInt getValue() {
            return this.value;
        }

        public void setValue(BitVectorInt value) {
            this.value = value;
        }

        public AST getReplacementAST() {
            return this.getDataType().getInitialValueAST();
        }

        @Override
        public void getQualifiedName(StringBuilder name) {
            name.append(this.getName());
        }
    }

    public static class RfTemplateTypeParam
    extends RfTemplateParam
    implements IRfClassType {
        private StructKind structKind;
        private IRfClassType parent;

        public RfTemplateTypeParam(int index, String name, StructKind structKind) {
            super(index, name, null);
            this.structKind = structKind;
        }

        @Override
        public String getSignature() {
            return "parameter type " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName();
        }

        @Override
        public Image getImage() {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_PARAM);
        }

        @Override
        public boolean isTypeParameter() {
            return true;
        }

        @Override
        public void setParent(IRfClassType classType) {
            this.parent = classType;
        }

        @Override
        public String getAssociatedTypeName() {
            return this.getAssociatedType().getName();
        }

        @Override
        public RfNamedElement getAssociatedType() {
            if (super.getAssociatedType() != null) {
                return super.getAssociatedType();
            }
            if (this.parent != null) {
                return (RfNamedElement)((Object)this.parent);
            }
            return this;
        }

        @Override
        public StructKind getStructKind() {
            return this.structKind;
        }

        @Override
        public IRfClassType getParent() {
            return this.parent;
        }

        @Override
        public List<IRfClassType> getParentInterfaces() {
            return null;
        }

        @Override
        public Collection<IRfClassType> getChildren() {
            return null;
        }

        @Override
        public void addChild(IRfClassType child) {
        }

        @Override
        public boolean isInterfaceClass() {
            return false;
        }

        @Override
        public RfNamedElement getDefault() {
            return super.getAssociatedType();
        }

        @Override
        public boolean isLike(IRfClassType likeClassType) {
            if (this.parent == null) {
                return false;
            }
            return this.parent.isLike(likeClassType);
        }

        @Override
        public boolean isPacked() {
            if (this.isAddrRegPkgMember() && "packed_s".equals(this.getName())) {
                return true;
            }
            if (this.parent == null) {
                return false;
            }
            return this.parent.isPacked();
        }
    }

    public static class RfTemplateValueParam
    extends RfTemplateParam {
        public RfTemplateValueParam(int index, String name, DataType dataType) {
            super(index, name, dataType);
        }

        @Override
        public String getSignature() {
            return "parameter value " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName();
        }

        @Override
        public Image getImage() {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PARAM);
        }

        @Override
        public RfNamedElement getDefault() {
            DataType dataType = this.getDataType();
            if (dataType == null) {
                return null;
            }
            AST initialValueAST = dataType.getInitialValueAST();
            if (initialValueAST == null) {
                return null;
            }
            BitVectorInt initialValueInt = dataType.getInitialValue(-1);
            RfInstanceValueParam instanceValueParam = new RfInstanceValueParam(initialValueInt);
            instanceValueParam.setDataType(dataType);
            instanceValueParam.setAssociatedType(this.getAssociatedType());
            return instanceValueParam;
        }
    }
}

