/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.pssdt.model.ASTUtils;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.RfTemplateInstanceDef;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.PSSFileInstance;
import ro.amiq.pssdt.parser.RfWalker;
import ro.amiq.pssdt.parser.SemanticWalker;
import ro.amiq.pssdt.parser.TypesWalker;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public class RfTemplateStruct
extends RfStruct {
    private DVTLinkedHashMap<String, RfTemplateInstance> templateInstances = new DVTLinkedHashMap();

    public RfTemplateStruct(String name) {
        super(name);
    }

    @Override
    public void addLayer(RfProject project, RfDefElement layer) {
        super.addLayer(project, layer);
        Iterator iterator = this.templateInstances.iterator();
        while (iterator.hasNext()) {
            RfTemplateInstance templateInstance = (RfTemplateInstance)iterator.next();
            if (templateInstance.hasNoDefs(false)) {
                iterator.remove();
                continue;
            }
            RfTemplateInstanceDef templateInstanceLayer = new RfTemplateInstanceDef(layer.getDefFile(), layer.getPackageName(), layer.getStartInfo(), layer);
            project.pushReparse(templateInstanceLayer, templateInstance);
            templateInstance.addLayer(project, templateInstanceLayer);
            this.reparseLayerAST(project, templateInstance, templateInstanceLayer, layer);
            project.popReparse(templateInstanceLayer);
        }
    }

    public void rawAddLayer(RfProject project, RfDefElement layer) {
        super.addLayer(project, layer);
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.templateInstances.clear();
    }

    @NotNull
    public List<RfTemplateParam> getParameters() {
        List<RfNamedElement> result = this.getLocalMembers(null, RfProject.PARAMETER_CLASSES);
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RfTemplateParam> parameters = new ArrayList<RfTemplateParam>(result.size());
        block0: while (true) {
            for (RfNamedElement parameter : result) {
                if (((RfTemplateParam)parameter).getIndex() != parameters.size()) continue;
                parameters.add((RfTemplateParam)parameter);
                continue block0;
            }
            break;
        }
        return parameters;
    }

    public RfTemplateParam getParameter(int index) {
        return this.getParameters().get(index);
    }

    @Override
    public String getSignature() {
        List<RfTemplateParam> parameters = this.getParameters();
        StringBuilder structSignature = new StringBuilder(super.getSignature());
        int i = 0;
        while (i < parameters.size()) {
            structSignature.append(i == 0 ? "<" : ", ");
            structSignature.append(parameters.get(i).getName());
            ++i;
        }
        return !parameters.isEmpty() ? structSignature.append(">").toString() : structSignature.toString();
    }

    public String getSignatureWithoutType() {
        List<RfTemplateParam> parameters = this.getParameters();
        StringBuilder structSignature = new StringBuilder(this.getName());
        int i = 0;
        while (i < parameters.size()) {
            structSignature.append(i == 0 ? "<" : ", ");
            structSignature.append(parameters.get(i).getName());
            ++i;
        }
        return !parameters.isEmpty() ? structSignature.append(">").toString() : structSignature.toString();
    }

    public RfNamedElement getTemplateInstance(RfProject project, AST id, List<RfNamedElement> partialInstanceParameters, RfFileDef fileDef, ParserPath parserPath) {
        RfNamedElement enclosingScope;
        List<RfTemplateParam> parameters;
        ArrayList<RfNamedElement> instanceParameters = new ArrayList<RfNamedElement>();
        int size = partialInstanceParameters.size();
        if (size > (parameters = this.getParameters()).size()) {
            project.addSemanticError(1, "TEMPLATE_INSTANCE_PARAMETERS: Expecting ''{1}'' parameter{1,choice,0#s|1#|1<s} when instantiating ''{0}'', found ''{2}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, this.getName(), parameters.size(), size);
            size = parameters.size();
        }
        int i = 0;
        while (i < size) {
            RfNamedElement parameterValue = partialInstanceParameters.get(i);
            if (SemanticUtils.valid(parameterValue)) {
                boolean isType;
                RfTemplateParam parameter = parameters.get(i);
                boolean bl = isType = parameterValue instanceof RfStruct || parameterValue instanceof RfEnumType || parameterValue instanceof RfTypeAlias || parameterValue instanceof RfTemplateParam.RfTemplateTypeParam;
                if (parameterValue instanceof RfTemplateParam.RfInstanceValueParam) {
                    DataType dataType = ((RfTemplateParam.RfInstanceValueParam)parameterValue).getDataType();
                    dataType.setValueParamDataType(parameter.getDataType());
                    ((RfTemplateParam.RfInstanceValueParam)parameterValue).setAssociatedType(parameter.getAssociatedType());
                }
                if (parameter instanceof RfTemplateParam.RfTemplateTypeParam) {
                    if (!isType) {
                        project.addSemanticError(1, "ILLEGAL_PARAMETER_OVERRIDE: Expecting a type when overriding parameter ''{0}'', found value ''{1}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, parameter.getName(), parameterValue.getName());
                        instanceParameters.add(SemanticWalker.UNRESOLVED_ELEMENT);
                    } else {
                        RfNamedElement replacementValue = parameterValue;
                        while (replacementValue instanceof RfTemplateParam.RfInstanceTypeParam && ((RfTemplateParam.RfInstanceTypeParam)replacementValue).getAssociatedType() instanceof RfTemplateParam.RfTemplateTypeParam) {
                            replacementValue = ((RfTemplateParam.RfInstanceTypeParam)replacementValue).getAssociatedType();
                        }
                        if (replacementValue == null) {
                            replacementValue = SemanticWalker.UNRESOLVED_ELEMENT;
                        }
                        instanceParameters.add(replacementValue);
                    }
                } else if (isType) {
                    project.addSemanticError(1, "ILLEGAL_PARAMETER_OVERRIDE: Expecting a value when overriding parameter ''{0}'', found type ''{1}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, parameter.getName(), parameterValue.getName());
                    instanceParameters.add(SemanticWalker.UNRESOLVED_ELEMENT);
                } else {
                    this.reparseInstanceValueParamAST(project, instanceParameters, parameters, i, parameterValue);
                    instanceParameters.add(parameterValue);
                }
            }
            ++i;
        }
        if (instanceParameters.size() < parameters.size()) {
            i = instanceParameters.size();
            while (i < parameters.size()) {
                RfTemplateParam parameter = parameters.get(i);
                RfNamedElement defaultValue = parameter.getDefault();
                if (defaultValue == null) {
                    project.addSemanticError(1, "MISSING_PARAMETER_OVERRIDE: Expecting override or default value for parameter ''{0}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, parameter.getName());
                    defaultValue = SemanticWalker.UNRESOLVED_ELEMENT;
                }
                this.reparseInstanceValueParamAST(project, instanceParameters, parameters, i, defaultValue);
                instanceParameters.add(defaultValue);
                ++i;
            }
        }
        if ((enclosingScope = this.getEnclosingScopeStructOrPackage()) == null) {
            return null;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return null;
        }
        RfTemplateInstance templateInstance = new RfTemplateInstance(this, instanceParameters);
        RfTemplateInstance existingTemplateInstance = (RfTemplateInstance)enclosingScope.getLocalMember(this.getDeterminant(SemanticUtils.getLexicalScope(declaration)), Collections.singleton(RfTemplateInstance.class), templateInstance.getName(), false, null);
        if (existingTemplateInstance == null) {
            enclosingScope.addMember(enclosingScope.getPackageName(), false, templateInstance);
            this.templateInstances.put(null, (IDVTMapElement)templateInstance);
        } else {
            templateInstance = existingTemplateInstance;
        }
        List<RfDefElement> templateStructLayers = this.getLayers();
        if (templateStructLayers.isEmpty()) {
            return null;
        }
        List<RfDefElement> templateInstanceLayers = templateInstance.getLayers();
        if (templateInstanceLayers != null && !templateInstanceLayers.isEmpty()) {
            for (RfDefElement layerCandidate : templateInstanceLayers) {
                if (!(layerCandidate instanceof RfTemplateInstanceDef) || fileDef.getIndex() < ((RfTemplateInstanceDef)layerCandidate).getStructLayerDefFile().getIndex()) continue;
                return templateInstance;
            }
        }
        for (RfDefElement templateStructLayer : templateStructLayers) {
            RfTemplateInstanceDef templateInstanceLayer = new RfTemplateInstanceDef(fileDef, templateStructLayer.getPackageName(), SemanticUtils.getLineInfo(id), templateStructLayer);
            if (templateInstanceLayers != null && templateInstanceLayers.contains(templateInstanceLayer)) continue;
            templateInstance.addLayer(project, templateInstanceLayer);
            project.pushReparse(templateInstanceLayer, templateInstance);
            try {
                RfDefElement declaration2 = enclosingScope.getDeclaration();
                if (declaration2 != null) {
                    templateInstanceLayer.setParentDef(declaration2);
                }
                this.reparseLayerAST(project, templateInstance, templateInstanceLayer, templateStructLayer);
            }
            finally {
                project.popReparse(templateInstanceLayer);
            }
        }
        return templateInstance;
    }

    private void reparseInstanceValueParamAST(RfProject project, List<RfNamedElement> instanceParameters, final List<RfTemplateParam> templateParameters, final int currParamIndex, RfNamedElement parameterValue) {
        if (!(parameterValue instanceof RfTemplateParam.RfInstanceValueParam)) {
            return;
        }
        AST replacementAST = ((RfTemplateParam.RfInstanceValueParam)parameterValue).getReplacementAST();
        if (replacementAST == null) {
            return;
        }
        int type = replacementAST.getType();
        if (replacementAST == null || type == 276 || type == 277 || type == 183 || type == 204 || type == 207 || type == 208 || type == 209 || type == 96 || type == 36 || type == 60 || type == 281) {
            return;
        }
        final AtomicBoolean dependsOnPrevParam = new AtomicBoolean(false);
        ASTUtils.ASTRunnable runnable = new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                int type = node.getType();
                if (type == 276 || type == 277) {
                    int i = 0;
                    while (i < currParamIndex) {
                        RfNamedElement templateParam = (RfNamedElement)templateParameters.get(i);
                        if (templateParam.getName().equals(node.getText())) {
                            dependsOnPrevParam.set(true);
                            throw new ASTUtils.StopScanning();
                        }
                        ++i;
                    }
                }
            }
        };
        ASTUtils.scanBelowAST(runnable, replacementAST);
        if (!dependsOnPrevParam.get()) {
            return;
        }
        RfTemplateInstance partialTemplateInstance = new RfTemplateInstance(this, instanceParameters);
        RfDefElement declaration = this.getDeclaration();
        PSSFileInstance fileInstance = project.getFileInstancesMap().getFileInstances(declaration.getParserPath()).get(0);
        RfWalker rfWalker = new RfWalker(project, fileInstance, false, declaration.getDefFile());
        rfWalker.setTemplateReparse(partialTemplateInstance, declaration);
        try {
            BitVectorInt initialValue = rfWalker.c2_expression(replacementAST, false, null, true);
            DataType dt = ((RfTemplateParam.RfInstanceValueParam)parameterValue).getDataType();
            dt.setInitialValue(dt.getInitialValueText(), dt.getInitialValueAST(), initialValue);
            ((RfTemplateParam.RfInstanceValueParam)parameterValue).setValue(initialValue);
        }
        catch (RecognitionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void reparseLayerAST(RfProject project, RfTemplateInstance templateInstance, RfTemplateInstanceDef templateInstanceLayer, RfDefElement templateStructLayer) {
        try {
            AST templateAST = templateStructLayer.getNodeAST();
            if (templateAST == null) {
                return;
            }
            RfFileDef reparseFileDef = templateInstanceLayer.getDefFile();
            PSSFileInstance reparseFileInstance = project.getFileInstancesMap().getFileInstances(reparseFileDef.getParserPath()).get(0);
            RfWalker rfWalker = new RfWalker(project, reparseFileInstance, false, reparseFileDef);
            TypesWalker typeWalker = new TypesWalker(project, reparseFileInstance, false, reparseFileDef);
            SemanticWalker semanticWalker = new SemanticWalker(project, reparseFileInstance, reparseFileDef);
            AST instanceAST = rfWalker.getASTFactory().dupTree(templateAST);
            SemanticUtils.setTransientScope(instanceAST, templateInstanceLayer);
            rfWalker.setTemplateReparse(templateInstance, templateInstanceLayer);
            rfWalker.reparse_template_instance(instanceAST, templateInstance);
            typeWalker.setTemplateReparse(templateInstance, templateInstanceLayer);
            typeWalker.reparse_template_instance(instanceAST, templateInstance);
            semanticWalker.setTemplateReparse(templateInstance, templateInstanceLayer);
            semanticWalker.reparse_template_instance(instanceAST, templateInstance);
            templateInstanceLayer.addNodeAST(instanceAST);
        }
        catch (RecognitionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private final RfNamedElement getEnclosingScopeStructOrPackage() {
        RfNamedElement enclosing = this.getEnclosingScope();
        do {
            if (!(enclosing instanceof RfStruct) && !(enclosing instanceof RfPackage)) continue;
            return enclosing;
        } while ((enclosing = enclosing.getEnclosingScope()) != null);
        return null;
    }

    public int indexOfParameter(String name) {
        if (name == null) {
            return -1;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return -1;
        }
        List<RfNamedElement> result = this.getLocalMembers(this.getDeterminant(SemanticUtils.getLexicalScope(declaration)), RfProject.PARAMETER_CLASSES);
        if (result == null || result.isEmpty()) {
            return -1;
        }
        for (RfNamedElement parameter : result) {
            if (!name.equals(parameter.getName())) continue;
            return ((RfTemplateParam)parameter).getIndex();
        }
        return -1;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (this.equals(obj)) {
            return true;
        }
        return obj instanceof RfTemplateInstance && this.equals(((RfTemplateInstance)obj).getTemplateStruct());
    }
}

