/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.pssdt.model.reflection.csv.SLNTableRow;

public abstract class SLNTableData {
    public static final String PACKAGE_DEF_KEY = "package";
    public static final String SIZE_CONST_DEF_KEY = "size_const";
    public static final String STRUCT_DEF_KEY = "struct";
    protected Map<Integer, String> columnNames = new HashMap<Integer, String>();
    protected List<SLNTableRow> tableLines = new ArrayList<SLNTableRow>();
    protected Map<String, String> definitions = new HashMap<String, String>();

    protected SLNTableData() {
    }

    public boolean hasColumn(String columnName) {
        if (this.columnNames == null || columnName == null) {
            return false;
        }
        for (String name : this.columnNames.values()) {
            if (!columnName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<SLNTableRow> getLines() {
        return this.tableLines;
    }

    public Map<String, String> getDefinitions() {
        return this.definitions;
    }

    public boolean hasDefinitions() {
        return !this.definitions.isEmpty();
    }

    public String getDefinition(String key) {
        return this.definitions.get(key);
    }

    public abstract void processData();

    public void processData(String rawData, char lineSeparator, char columnSeparator) {
        if (rawData == null) {
            return;
        }
        rawData = rawData.trim();
        ArrayList<String> columnValues = new ArrayList<String>();
        char pch = '\u0000';
        int nofOpens = 0;
        boolean inString = false;
        StringBuilder cellSB = new StringBuilder();
        int i = 0;
        while (i < rawData.length()) {
            char ch = rawData.charAt(i);
            if (inString) {
                cellSB.append(ch);
                if ('\"' == ch && '\\' != pch) {
                    inString = false;
                }
                pch = ch;
            } else {
                if ('(' == ch || '{' == ch || '[' == ch) {
                    cellSB.append(ch);
                    ++nofOpens;
                } else if (')' == ch || '}' == ch || ']' == ch) {
                    cellSB.append(ch);
                    --nofOpens;
                } else if ('\"' == ch && '\\' != pch) {
                    cellSB.append(ch);
                    inString = true;
                } else if (nofOpens == 0 && (lineSeparator == ch || columnSeparator == ch)) {
                    String cellValue = cellSB.toString().trim();
                    cellSB = new StringBuilder();
                    this.putValues(lineSeparator, ch, columnValues, cellValue);
                } else {
                    cellSB.append(ch);
                }
                pch = ch;
            }
            ++i;
        }
        if (cellSB.length() > 0) {
            String cellValue = cellSB.toString().trim();
            this.putValues(lineSeparator, lineSeparator, columnValues, cellValue);
        }
    }

    protected void putValues(char lineSeparator, char ch, List<String> columnValues, String cellValue) {
        if (this.tableLines.isEmpty() && cellValue.startsWith("#")) {
            this.columnNames.put(this.columnNames.size() + 1, cellValue.substring(1, cellValue.length()));
        } else if (this.tableLines.isEmpty() && this.columnNames.isEmpty()) {
            int index = 0;
            index = this.indexOfTag(cellValue, PACKAGE_DEF_KEY);
            if (index > 0) {
                this.definitions.put(PACKAGE_DEF_KEY, cellValue.substring(index).trim());
            } else {
                index = this.indexOfTag(cellValue, SIZE_CONST_DEF_KEY);
                if (index > 0) {
                    this.definitions.put(SIZE_CONST_DEF_KEY, cellValue.substring(index).trim());
                } else {
                    index = this.indexOfTag(cellValue, STRUCT_DEF_KEY);
                    if (index > 0) {
                        this.definitions.put(STRUCT_DEF_KEY, cellValue.substring(index).trim());
                    }
                }
            }
        } else {
            columnValues.add(cellValue);
            if (lineSeparator == ch) {
                this.tableLines.add(new SLNTableRow(this.tableLines.size(), this.columnNames, new ArrayList<String>(columnValues)));
                columnValues.clear();
            }
        }
    }

    protected int indexOfTag(String tag, String prefix) {
        int index = 0;
        if (tag.length() > 0 && tag.charAt(0) == '@') {
            index = 1;
        }
        if ((index = tag.indexOf(prefix, index)) < 0) {
            return 0;
        }
        return tag.indexOf(58, index + prefix.length()) + 1;
    }
}

