/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.csv;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class SLNTableRow {
    private int rowIndex;
    private Map<Integer, String> columnNames;
    private List<String> columnValues;

    public SLNTableRow(int rowIndex, Map<Integer, String> columnNames, List<String> columnValues) {
        this.rowIndex = rowIndex;
        this.columnNames = columnNames;
        this.columnValues = columnValues;
    }

    public SLNTableRow changeRawIndex(int rowIndex) {
        return new SLNTableRow(rowIndex, this.columnNames, this.columnValues);
    }

    public int getNofColumns() {
        return this.columnValues.size();
    }

    public String replace(String prefix, String input) {
        String result = input;
        int nofNames = this.columnNames.size();
        int nofValues = this.columnValues.size();
        int i = 0;
        while (i < Math.max(nofNames, nofValues)) {
            String columnValue = i < nofValues ? this.columnValues.get(i).trim() : "";
            String columnName = this.columnNames.get(i + 1);
            String quoteReplacement = Matcher.quoteReplacement(columnValue);
            result = result.replaceAll("<" + prefix + (i + 1) + ">", quoteReplacement);
            if (columnName != null) {
                result = result.replaceAll("<" + prefix + columnName + ">", quoteReplacement);
            }
            ++i;
        }
        result = result.replaceAll("<" + prefix + "0>", Integer.toString(this.rowIndex));
        result = result.replaceAll("<" + prefix + "row_index>", Integer.toString(this.rowIndex));
        return result;
    }

    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    public String getColumnValue(int index) {
        if (index >= 1 && index <= this.columnValues.size()) {
            return this.columnValues.get(index - 1);
        }
        return "";
    }

    public String toString() {
        StringBuilder result = new StringBuilder(Integer.toString(this.rowIndex)).append(": ");
        boolean first = true;
        for (String columnValue : this.columnValues) {
            if (!first) {
                result.append(" | ");
            }
            result.append(columnValue);
            first = false;
        }
        return result.toString();
    }
}

