/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.csv;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ro.amiq.pssdt.model.reflection.csv.SLNTableDataCSV;

public class SLNTablesFromCSVFile {
    private Map<String, SLNTableDataCSV> tables = new HashMap<String, SLNTableDataCSV>();

    public static SLNTablesFromCSVFile readTablesFromFile(String filePath, String sheetName) throws Exception {
        SLNTablesFromCSVFile csvTables;
        block31: {
            if (filePath == null) {
                return null;
            }
            csvTables = null;
            String trimmedFilePath = filePath.trim();
            String trimmedSheetName = null;
            if (sheetName != null) {
                trimmedSheetName = sheetName.trim();
            }
            if (trimmedFilePath.endsWith(".xls")) {
                Throwable throwable = null;
                Object var6_11 = null;
                try (BufferedReader reader = SLNTablesFromCSVFile.xls2CSV(trimmedFilePath, trimmedSheetName);){
                    csvTables = SLNTablesFromCSVFile.readCSV(reader);
                    break block31;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (trimmedFilePath.endsWith(".xlsx")) {
                Throwable throwable = null;
                Object var6_13 = null;
                try (BufferedReader reader = SLNTablesFromCSVFile.xlsx2CSV(trimmedFilePath, trimmedSheetName);){
                    csvTables = SLNTablesFromCSVFile.readCSV(reader);
                    break block31;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var6_15 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(trimmedFilePath));){
                csvTables = SLNTablesFromCSVFile.readCSV(reader);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        return csvTables;
    }

    private static final SLNTablesFromCSVFile readCSV(BufferedReader reader) throws Exception {
        String line;
        SLNTablesFromCSVFile result = new SLNTablesFromCSVFile();
        SLNTableDataCSV tableData = null;
        boolean singleColumnCornerCase = false;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("//") || line.startsWith("--")) continue;
            if (line.indexOf(44) != -1) {
                int trimTo = -1;
                int i = line.length() - 1;
                while (i >= 0) {
                    char ch = line.charAt(i);
                    if (ch != ',' && !Character.isWhitespace(ch)) {
                        trimTo = i;
                        break;
                    }
                    --i;
                }
                line = line.substring(0, trimTo + 1);
            }
            if (line.isEmpty()) {
                singleColumnCornerCase = false;
            }
            if (line.startsWith("//") || line.startsWith("--")) continue;
            if (line.indexOf(44) == -1 && !singleColumnCornerCase) {
                int index;
                if (line.startsWith("#")) {
                    singleColumnCornerCase = true;
                    if (tableData != null) {
                        tableData.append(String.valueOf(line) + "\n");
                        continue;
                    }
                }
                if (line.startsWith("table") && (index = line.indexOf(":", "table".length())) > 0) {
                    line = line.substring(index + 1).trim();
                }
                tableData = new SLNTableDataCSV(line);
                result.tables.put(line, tableData);
                continue;
            }
            if (tableData == null) continue;
            tableData.append(String.valueOf(line) + "\n");
        }
        for (SLNTableDataCSV csvTableData : result.tables.values()) {
            if (csvTableData == null) continue;
            csvTableData.processData();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BufferedReader xlsx2CSV(String filePath, String sheetName) throws Exception {
        BufferedReader result = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(new File(filePath)));
            try {
                try (XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileInputStream);){
                    XSSFSheet sheet = null;
                    sheet = sheetName != null ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
                    if (sheet != null) {
                        result = SLNTablesFromCSVFile.rows2CSV(sheet.iterator(), filePath, sheetName);
                    }
                }
                if (fileInputStream == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileInputStream == null) throw throwable;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BufferedReader xls2CSV(String filePath, String sheetName) throws Exception {
        BufferedReader result = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(new File(filePath)));
            try {
                try (HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fileInputStream);){
                    HSSFSheet sheet = null;
                    sheet = sheetName != null ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
                    if (sheet != null) {
                        result = SLNTablesFromCSVFile.rows2CSV(sheet.iterator(), filePath, sheetName);
                    }
                }
                if (fileInputStream == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileInputStream == null) throw throwable;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static final BufferedReader rows2CSV(Iterator<Row> rowIterator, String filePath, String sheetName) throws Exception {
        StringBuilder content = new StringBuilder();
        DataFormatter df = new DataFormatter();
        while (rowIterator != null && rowIterator.hasNext()) {
            Row row = rowIterator.next();
            short minColIx = row.getFirstCellNum();
            short maxColIx = row.getLastCellNum();
            short colIx = minColIx;
            while (colIx < maxColIx) {
                Cell cell = row.getCell((int)colIx);
                if (cell != null) {
                    content.append(df.formatCellValue(cell));
                }
                if (colIx != maxColIx - 1) {
                    content.append(',');
                }
                colIx = (short)(colIx + 1);
            }
            content.append('\n');
        }
        char[] chars = new char[content.length()];
        content.getChars(0, content.length(), chars, 0);
        return new BufferedReader(new CharArrayReader(chars));
    }

    public SLNTableDataCSV getTableData(String name) {
        return this.tables.get(name);
    }

    public Set<String> getTablesKeys() {
        return this.tables.keySet();
    }
}

