/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.RfClassType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ConstraintDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfDummyField;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class ActionInstance
extends InstancesContainer {
    private static final long serialVersionUID = 1L;
    public static final int MAX_TRAVERSAL_INDEX = Integer.MAX_VALUE;
    public static final String INFERRED_ACTION_NAME = "[inferred]";
    public static final String ANONYMOUS_ACTION_NAME = "[anonymous]";
    public static final String PARALLEL_ACTION_NAME = "[parallel]";
    public static final String SEQUENCE_ACTION_NAME = "[sequence]";
    public static final String SCHEDULE_ACTION_NAME = "[schedule]";
    public static final String SYMBOL_ACTION_NAME = "[symbol]";
    public static final String WRAPPER_SUFFIX = "@wrapper";
    protected List<ActionInstance> childrenActionInstances;
    protected ComponentInstance parentComponentInstance;
    protected ActionInstance parentActionInstance;
    protected transient RfField rfActionHandle;
    private boolean inferred;
    private int traversalIndex;
    private boolean isSkipCompound;
    private transient StringBuilder bodyTargetCode;

    public ActionInstance(String instanceName, int instanceIndex, BigInteger runtimeId, RfStruct rfAction, ComponentInstance parentComponentInstance, Scenario scenario) {
        super(instanceName, -1, -1, runtimeId, rfAction, false, scenario);
        this.rfActionHandle = rfAction == null ? null : new RfDummyField(rfAction);
        this.instanceIndex = instanceIndex;
        this.parentComponentInstance = parentComponentInstance;
        this.createSubInstances(new IdentityHashMap<RfNamedElement, InstancesContainer>(), false);
        this.traversalIndex = 0;
    }

    public ActionInstance(String instanceName, int instanceIndex, BigInteger runtimeId, RfField rfActionHandle, RfStruct rfAction, ComponentInstance parentComponentInstance, Scenario scenario) {
        super(instanceName, -1, -1, runtimeId, rfAction, rfActionHandle.isRef(), scenario);
        this.rfActionHandle = rfActionHandle;
        this.instanceIndex = instanceIndex;
        this.parentComponentInstance = parentComponentInstance;
        this.createSubInstances(new IdentityHashMap<RfNamedElement, InstancesContainer>(), false);
        this.traversalIndex = 0;
    }

    public boolean isTraversed() {
        return this.traversalIndex > 0;
    }

    public void setTraversalIndex(int traversalIndex) {
        this.traversalIndex = traversalIndex;
    }

    public int getTraversalIndex() {
        return this.traversalIndex;
    }

    public void collectBeforeCandidatesDown(List<ActionInstance> beforeCandidates) {
        InstanceVisitor<ActionInstance> visitor = instance -> {
            if (instance instanceof ISchedulingInstance) {
                return true;
            }
            beforeCandidates.add((ActionInstance)instance);
            return true;
        };
        this.accept(visitor);
    }

    public String getDiagramInstanceName() {
        String actionInstanceName = this.getDiagramName();
        if (actionInstanceName.startsWith("[") && actionInstanceName.endsWith("]")) {
            int index = actionInstanceName.indexOf(58);
            return actionInstanceName.substring(1, index).trim();
        }
        return actionInstanceName;
    }

    @Override
    public RfField getRfField() {
        return this.rfActionHandle;
    }

    public RfStruct getRfAction() {
        return this.typeInstance == null ? null : (RfStruct)this.typeInstance.rfInstanceType;
    }

    @Override
    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
        if (this instanceof ISchedulingInstance) {
            return;
        }
        if (this.typeInstance == null) {
            return;
        }
        super.createSubInstances(backPointersMap, isVariableInstance);
        this.typeInstance.createSubInstances(backPointersMap, isVariableInstance, true, this.runtimeId);
    }

    @Override
    public void clean() {
        super.clean();
        this.traversalIndex = 0;
        this.parentActionInstance = null;
    }

    @Override
    public InstancePath getInstancePath() {
        return new InstancePath(this.getParentComponentInstance().getInstancePath(), false, this);
    }

    @Override
    public InstancePath getHierarchicalPath() {
        ActionInstance parentActionInstance = this.getParentActionInstance();
        if (parentActionInstance != null) {
            return new InstancePath(parentActionInstance.getHierarchicalPath(), false, this);
        }
        return new InstancePath(this.parentComponentInstance.getHierarchicalPath(), false, this);
    }

    public List<ActionInstance> getActionInstances(InstancesContainer instance, boolean keepClosestToMax, int maxTraversalIndex) {
        ArrayList<ActionInstance> result = new ArrayList<ActionInstance>();
        this.collectActionInstances(result, instance, keepClosestToMax, maxTraversalIndex);
        return result;
    }

    @Override
    public FieldInstance getFieldInstance(InstancesContainer instance) {
        FieldInstance fieldInstance = this.typeInstance.getFieldInstance(instance);
        if (fieldInstance != null) {
            return fieldInstance;
        }
        ComponentInstance parentComponentInstance = this.getParentComponentInstance();
        if (parentComponentInstance == null) {
            return null;
        }
        fieldInstance = parentComponentInstance.getFieldInstance(instance);
        return fieldInstance;
    }

    @Override
    public Expression.Value getRepeatIndexValue(RfField.RfIndexField rfIndexField) {
        if (this.parentActionInstance == null) {
            return null;
        }
        return this.parentActionInstance.getRepeatIndexValue(rfIndexField);
    }

    @Override
    public Expression.Value getRepeatIteratorValue(RfField.RfIteratorField rfIteratorField) {
        if (this.parentActionInstance == null) {
            return null;
        }
        return this.parentActionInstance.getRepeatIteratorValue(rfIteratorField);
    }

    private void collectActionInstances(List<ActionInstance> result, InstancesContainer instance, boolean keepClosestToMax, int maxTraversalIndex) {
        String instanceName = instance.getDiagramName();
        if (maxTraversalIndex < Integer.MAX_VALUE) {
            this.collectActionInstances(result, Collections.singletonList(this), instance, maxTraversalIndex, instanceName, false);
        }
        if (result.isEmpty()) {
            this.collectActionInstances(result, this.childrenActionInstances, instance, maxTraversalIndex, instanceName, true);
        }
        if (result.isEmpty() && this.parentActionInstance != null) {
            this.collectActionInstances(result, this.parentActionInstance.childrenActionInstances, instance, maxTraversalIndex, instanceName, true);
        }
        if (keepClosestToMax && result.size() > 1 && maxTraversalIndex < Integer.MAX_VALUE) {
            int highestTraversalIndex = 0;
            for (ActionInstance actionInstance : result) {
                if (actionInstance.traversalIndex <= highestTraversalIndex) continue;
                highestTraversalIndex = actionInstance.traversalIndex;
            }
            Iterator<ActionInstance> iterator = result.iterator();
            while (iterator.hasNext()) {
                ActionInstance actionInstance = iterator.next();
                if (actionInstance.traversalIndex >= highestTraversalIndex) continue;
                iterator.remove();
            }
        }
    }

    private void collectActionInstances(List<ActionInstance> result, List<ActionInstance> actionInstanceCandidatess, InstancesContainer instance, int maxTraversalIndex, String instanceName, boolean recursive) {
        if (actionInstanceCandidatess == null || actionInstanceCandidatess.isEmpty()) {
            return;
        }
        for (ActionInstance actionInstance : actionInstanceCandidatess) {
            String actionHandleName;
            if (recursive && actionInstance == this) continue;
            if (actionInstance.isAnonymousSchedulingInstance()) {
                if (!recursive) continue;
                this.collectActionInstances(result, actionInstance.childrenActionInstances, instance, maxTraversalIndex, instanceName, true);
                continue;
            }
            boolean isSchedulingInstance = actionInstance instanceof ISchedulingInstance;
            if (!isSchedulingInstance && maxTraversalIndex < Integer.MAX_VALUE && (!actionInstance.isTraversed() || actionInstance.getTraversalIndex() > maxTraversalIndex)) continue;
            String actionInstanceName = actionInstance.getDiagramName();
            RfField rfField = actionInstance.getRfField();
            String string = actionHandleName = rfField == null ? null : ScenarioUtils.getDeduplicateName(rfField);
            if (!instanceName.equals(actionInstanceName) && !instanceName.equals(actionHandleName)) continue;
            result.add(actionInstance);
        }
    }

    protected boolean isAnonymousSchedulingInstance() {
        return false;
    }

    public ComponentInstance getRootComponentInstance() {
        ComponentInstance result = this.parentComponentInstance;
        while (result.getParentComponentInstance() != null) {
            result = result.getParentComponentInstance();
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.getRfAction() == null) {
            return this.getDiagramName();
        }
        return this.getInstancePath().toString();
    }

    public boolean isOrphan() {
        if (this.isInferred() && this.parentActionInstance != null) {
            ActionInstance parentActionInstance = this.getParentActionInstance();
            if (parentActionInstance == null) {
                return false;
            }
            return parentActionInstance.isOrphan();
        }
        return this.parentActionInstance == null;
    }

    public void setInferred(boolean inferred) {
        this.inferred = inferred;
    }

    public boolean isInferred() {
        if (this.inferred) {
            return true;
        }
        if (this.parentActionInstance == null) {
            return false;
        }
        return this.parentActionInstance.isInferred();
    }

    protected boolean canScheduleBefore(ActionInstance candidate) {
        boolean isCompoundParent;
        if (candidate.isInitialStateObject()) {
            return false;
        }
        if (this == candidate) {
            return false;
        }
        SchedulingParent commonSchedulingParent = ActionInstance.getCommonSchedulingParent(this, candidate);
        boolean bl = isCompoundParent = commonSchedulingParent != null && this == commonSchedulingParent.child1 && commonSchedulingParent.child1 == commonSchedulingParent.child2;
        if (commonSchedulingParent != null && !isCompoundParent && !commonSchedulingParent.canScheduleBefore()) {
            return false;
        }
        return this.scenario.canScheduleBefore(this, candidate);
    }

    protected boolean canScheduleParallel(ActionInstance candidate) {
        boolean isCompoundParent;
        if (candidate.isInitialStateObject()) {
            return false;
        }
        if (this == candidate) {
            return false;
        }
        SchedulingParent commonSchedulingParent = ActionInstance.getCommonSchedulingParent(this, candidate);
        boolean bl = isCompoundParent = commonSchedulingParent != null && this == commonSchedulingParent.child1 && commonSchedulingParent.child1 == commonSchedulingParent.child2;
        if (isCompoundParent) {
            return false;
        }
        if (commonSchedulingParent != null && !commonSchedulingParent.canScheduleParallel()) {
            return false;
        }
        return this.scenario.canScheduleParallel(this, candidate);
    }

    protected boolean canScheduleSequential(ActionInstance candidate) {
        if (this == candidate) {
            return false;
        }
        SchedulingParent commonSchedulingParent = ActionInstance.getCommonSchedulingParent(this, candidate);
        if (commonSchedulingParent != null && !commonSchedulingParent.canScheduleSequential()) {
            return false;
        }
        return this.scenario.canScheduleSequential(this, candidate);
    }

    public void scheduleBefore(ActionInstance candidate) {
        if (this == candidate) {
            return;
        }
        this.visitBeforeDown(candidate);
    }

    public void scheduleParallel(ActionInstance candidate) {
        if (this == candidate) {
            return;
        }
        this.scenario.scheduleParallel(this, candidate);
    }

    public void scheduleSequential(ActionInstance candidate) {
        if (this == candidate) {
            return;
        }
        this.scenario.scheduleSequential(this, candidate);
    }

    public void scheduleSchedule(ActionInstance candidate) {
        if (this == candidate) {
            return;
        }
        this.scenario.scheduleSchedule(this, candidate);
    }

    public void insertBefore(ActionInstance a1, ActionInstance a2, boolean reverse) {
        ScenarioUtils.print("*** Error: Internal error ISB_3");
    }

    public void insertBefore(ActionInstance candidate, boolean reverse) {
        this.internalCheckObsoleteScenario(candidate);
        if (candidate.parentActionInstance == null) {
            ScenarioUtils.print("*** Error: Internal error ISB_1");
            return;
        }
        if (this.parentActionInstance != null) {
            ScenarioUtils.print("*** Error: Internal error ISB_2");
            return;
        }
        if (!(this instanceof ISchedulingInstance) && !(candidate instanceof ISchedulingInstance)) {
            if (reverse) {
                candidate.scheduleBefore(this);
                this.scenario.scheduler.insertBefore(candidate, this);
            } else {
                this.scheduleBefore(candidate);
                this.scenario.scheduler.insertBefore(this, candidate);
            }
        }
        candidate.parentActionInstance.insertBefore(this, candidate, reverse);
    }

    protected void collectBeforeCandidates(List<ActionInstance> beforeCandidates, ActionInstance candidate) {
        if (this.parentActionInstance == null) {
            return;
        }
        this.parentActionInstance.collectBeforeCandidates(beforeCandidates, candidate);
    }

    public void insertParallel(ActionInstance candidate) {
        if (this.parentActionInstance == null && candidate.parentActionInstance == null) {
            ScenarioUtils.print("*** Error: Internal error ISP_1");
            return;
        }
        this.scenario.scheduler.insertParallel(this, candidate);
        if (this.parentActionInstance == null) {
            candidate.insertParallel(this);
        } else if (this.parentActionInstance instanceof ParallelActionInstance) {
            this.parentActionInstance.addChildAction(candidate);
        } else {
            int index = this.parentActionInstance.childrenActionInstances.indexOf(this);
            ParallelActionInstance parallel = new ParallelActionInstance(PARALLEL_ACTION_NAME, this.runtimeId, this.scenario);
            this.parentActionInstance.childrenActionInstances.set(index, parallel);
            parallel.parentActionInstance = this.parentActionInstance;
            parallel.addChildAction(this);
            parallel.addChildAction(candidate);
        }
    }

    public void addChildAction(ActionInstance actionInstance) {
        this.internalCheckObsoleteScenario(actionInstance);
        if (this.childrenActionInstances == null) {
            this.childrenActionInstances = new ArrayList<ActionInstance>();
        }
        this.hierarchicalSeeding(actionInstance, this.childrenActionInstances.size());
        this.childrenActionInstances.add(actionInstance);
        actionInstance.parentActionInstance = this;
        if (actionInstance instanceof ISchedulingInstance) {
            return;
        }
        boolean isCompoundParallel = this instanceof ParallelActionInstance || this.isFirstChild(actionInstance);
        this.visitBeforeUp(actionInstance, actionInstance, !isCompoundParallel);
        this.visitParallelUp(actionInstance, actionInstance, isCompoundParallel);
        this.visitScheduleDown(actionInstance);
    }

    public void visitBeforeUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundBefore) {
        if (isCompoundBefore) {
            this.scheduleBefore(actionInstance);
        }
        if (this.parentActionInstance != null) {
            this.parentActionInstance.visitBeforeUp(actionInstance, this, isCompoundBefore && !this.isFirstChild(prevParentActionInstance));
        }
    }

    public void visitBeforeDown(ActionInstance actionInstance) {
        if (this == actionInstance) {
            return;
        }
        if (!Solver.inSameRuntime(this, actionInstance)) {
            return;
        }
        this.scenario.scheduleBefore(this, actionInstance);
        if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
            return;
        }
        for (ActionInstance child : this.childrenActionInstances) {
            child.visitBeforeDown(actionInstance);
        }
    }

    public void visitParallelUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundParallel) {
        if (!Solver.inSameRuntime(this, actionInstance)) {
            return;
        }
        if (isCompoundParallel) {
            this.scheduleParallel(actionInstance);
        }
        if (this.parentActionInstance != null) {
            this.parentActionInstance.visitParallelUp(actionInstance, this, isCompoundParallel);
        }
    }

    public void visitParallelDown(ActionInstance actionInstance) {
        if (!Solver.inSameRuntime(this, actionInstance)) {
            return;
        }
        this.scheduleParallel(actionInstance);
        if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
            return;
        }
        for (ActionInstance child : this.childrenActionInstances) {
            child.visitParallelDown(actionInstance);
        }
    }

    public void visitScheduleDown(ActionInstance actionInstance) {
        if (this == actionInstance) {
            return;
        }
        if (!Solver.inSameRuntime(this, actionInstance)) {
            return;
        }
        if (!(actionInstance instanceof ISchedulingInstance)) {
            this.scenario.scheduleSchedule(this, actionInstance);
            return;
        }
        if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
            return;
        }
        for (ActionInstance child : this.childrenActionInstances) {
            child.visitScheduleDown(actionInstance);
        }
    }

    protected boolean isFirstChild(ActionInstance actionInstance) {
        if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
            return false;
        }
        return this.childrenActionInstances.get(0) == actionInstance;
    }

    public List<ActionInstance> getChildren() {
        return this.childrenActionInstances;
    }

    public boolean accept(InstanceVisitor<ActionInstance> visitor) {
        boolean continueVisit = visitor.visit(this);
        if (!continueVisit) {
            return false;
        }
        if (this.childrenActionInstances != null && !this.childrenActionInstances.isEmpty()) {
            for (ActionInstance child : this.childrenActionInstances) {
                continueVisit = child.accept(visitor);
                if (continueVisit) continue;
                return false;
            }
        }
        visitor.postVisit(this);
        return true;
    }

    public boolean isParentInstanceOf(ActionInstance actionInstance) {
        ActionInstance parentInstance = actionInstance;
        do {
            if (parentInstance != this) continue;
            return true;
        } while ((parentInstance = parentInstance.parentActionInstance) != null);
        return false;
    }

    public Set<ActionInstance> getHierarchicalInstances() {
        Set<ActionInstance> result = Collections.newSetFromMap(new IdentityHashMap());
        ActionInstance parentActionInstance = this;
        while ((parentActionInstance = parentActionInstance.parentActionInstance) != null) {
            if (parentActionInstance instanceof ISchedulingInstance) continue;
            result.add(parentActionInstance);
        }
        InstanceVisitor<ActionInstance> visitor = instance -> {
            if (!(instance instanceof ISchedulingInstance)) {
                result.add((ActionInstance)instance);
            }
            return true;
        };
        this.accept(visitor);
        return result;
    }

    @Override
    public ComponentInstance getParentComponentInstance() {
        if (this instanceof ISchedulingInstance) {
            if (this.parentActionInstance == null) {
                return null;
            }
            return this.parentActionInstance.getParentComponentInstance();
        }
        return this.parentComponentInstance;
    }

    protected static SchedulingParent getCommonSchedulingParent(ActionInstance a1, ActionInstance a2) {
        IdentityHashMap<ActionInstance, Child> parentsMap = new IdentityHashMap<ActionInstance, Child>();
        boolean isParallelCandidate = true;
        ActionInstance parent = a1;
        ActionInstance child = a1;
        while ((parent = parent.parentActionInstance) != null) {
            if (parent instanceof ISchedulingInstance) {
                if (parent instanceof SequenceActionInstance && parent.childrenActionInstances.get(0) != child) {
                    isParallelCandidate = false;
                }
                parentsMap.put(parent, new Child(child, isParallelCandidate));
            }
            child = parent;
        }
        isParallelCandidate = true;
        parent = a2;
        child = a2;
        while ((parent = parent.parentActionInstance) != null) {
            if (parent instanceof ISchedulingInstance) {
                Child child2;
                if (parent instanceof SequenceActionInstance && parent.childrenActionInstances.get(0) != child) {
                    isParallelCandidate = false;
                }
                if ((child2 = (Child)parentsMap.get(parent)) != null) {
                    return new SchedulingParent((ISchedulingInstance)((Object)parent), child2.childInstance, child, child2.isParallelCandidate && isParallelCandidate);
                }
            }
            child = parent;
        }
        return null;
    }

    public static ISchedulingInstance getSchedulingParentInstance(ActionInstance a1) {
        if (a1 instanceof ISchedulingInstance) {
            return (ISchedulingInstance)((Object)a1);
        }
        ActionInstance parent = a1;
        while ((parent = parent.parentActionInstance) != null) {
            if (!(parent instanceof ISchedulingInstance)) continue;
            return (ISchedulingInstance)((Object)parent);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this instanceof ISchedulingInstance) {
            return;
        }
        int key = ScenarioUtils.getKeyOfRf(this.rfActionHandle);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this instanceof ISchedulingInstance) {
            return;
        }
        int key = in.readInt();
        this.rfActionHandle = (RfField)ScenarioUtils.getRfOfKey(key);
    }

    @Override
    public ActionInstance getParentActionInstance() {
        ActionInstance parentActionInstance = this;
        while ((parentActionInstance = parentActionInstance.parentActionInstance) != null) {
            if (parentActionInstance instanceof ISchedulingInstance) continue;
            return parentActionInstance;
        }
        return null;
    }

    public int getRepeatIndex() {
        return this.arraySize;
    }

    public boolean isBefore(ActionInstance actionInstance) {
        return this.scenario.isBefore(this, actionInstance);
    }

    public boolean isParallel(ActionInstance actionInstance) {
        return this.scenario.isParallel(this, actionInstance);
    }

    public List<Expression.Id> getConstraintsVarPathPrefix() {
        LinkedList<Expression.Id> prefix = new LinkedList<Expression.Id>();
        ActionInstance parentActionInstance = this;
        do {
            if (!(parentActionInstance instanceof ISchedulingInstance)) {
                return prefix;
            }
            if (parentActionInstance.isAnonymousSchedulingInstance()) continue;
            RfField rfField = new RfField(parentActionInstance.getName(), null);
            prefix.add(0, new Expression.Id(rfField));
        } while ((parentActionInstance = parentActionInstance.parentActionInstance) != null);
        return prefix;
    }

    public boolean isCompound() {
        if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
            return false;
        }
        for (ActionInstance child : this.childrenActionInstances) {
            if (child instanceof ISchedulingInstance) {
                if (!child.isCompound()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean isCompoundAction() {
        RfStruct rfAction = this.getRfAction();
        if (rfAction == null) {
            return false;
        }
        return rfAction.isCompoundAction();
    }

    public void setSkipCompound() {
        this.isSkipCompound = true;
    }

    public boolean isSkipCompound() {
        return this.isSkipCompound;
    }

    public final void targetCode(ExecBlockKind execKind) {
        RfStruct rfAction;
        if (this instanceof ISchedulingInstance) {
            return;
        }
        if (execKind == ExecBlockKind.BODY && this.isCompound()) {
            return;
        }
        ArrayList<ConstraintDescriptor.ExecStmtDescriptor> execStmtDescriptors = new ArrayList<ConstraintDescriptor.ExecStmtDescriptor>();
        HashSet<String> existingExecStmtKinds = new HashSet<String>();
        RfClassType rfParentAction = rfAction = this.getRfAction();
        do {
            List<ConstraintDescriptor.ExecStmtDescriptor> parentExecStmtDescriptors;
            if ((parentExecStmtDescriptors = this.scenario.execStmtDescriptors.get(rfParentAction)) == null || parentExecStmtDescriptors.isEmpty()) continue;
            for (ConstraintDescriptor.ExecStmtDescriptor execStmtDescriptor : parentExecStmtDescriptors) {
                String execKindName;
                if (execStmtDescriptor.getExecKind() != execKind || !(execStmtDescriptor instanceof ConstraintDescriptor.TargetExecStmtDescriptor)) continue;
                String string = execKindName = execKind == ExecBlockKind.FILE ? ((ConstraintDescriptor.TargetExecStmtDescriptor)execStmtDescriptor).getText() : execKind.toString();
                if (rfAction != rfParentAction && existingExecStmtKinds.contains(execKindName)) continue;
                existingExecStmtKinds.add(execKindName);
                execStmtDescriptors.add(execStmtDescriptor);
            }
        } while ((rfParentAction = (RfClassType)rfParentAction.getParent()) != null);
        if (execStmtDescriptors.isEmpty()) {
            return;
        }
        for (ConstraintDescriptor.ExecStmtDescriptor execStmtDescriptor : execStmtDescriptors) {
            String targetCode = ((ConstraintDescriptor.TargetExecStmtDescriptor)execStmtDescriptor).getExecTargetCode(this.scenario, this, execKind);
            if (targetCode == null) continue;
            if (execKind == ExecBlockKind.FILE) {
                String fileName = ((ConstraintDescriptor.TargetExecStmtDescriptor)execStmtDescriptor).getText();
                if (fileName.startsWith("\"") && fileName.endsWith("\"")) {
                    fileName = fileName.substring(1, fileName.length() - 1);
                }
                this.scenario.getSolver().putTargetCode(fileName, targetCode);
                continue;
            }
            if (execKind == ExecBlockKind.HEADER) {
                this.scenario.getSolver().putTargetCode(execKind.toString(), targetCode);
                continue;
            }
            if (execKind == ExecBlockKind.DECLARATION) {
                this.scenario.getSolver().putTargetCode(execKind.toString(), targetCode);
                continue;
            }
            if (execKind != ExecBlockKind.BODY) continue;
            if (this.bodyTargetCode == null) {
                this.bodyTargetCode = new StringBuilder();
            }
            this.bodyTargetCode.append("\n").append(targetCode).append("\n");
        }
    }

    public final String getTargetCode(String targetLanguage, IPath externTemplateDirLocation) {
        String templateFileName = String.valueOf(targetLanguage.toLowerCase()) + ".target.body.ftl";
        String targetCode = Solver.getTargetCode(templateFileName, externTemplateDirLocation, this);
        return targetCode;
    }

    public final String getBodyTargetCode(String indent) {
        return this.bodyTargetCode == null ? "" : DVTStringUtil.replaceAll((Pattern)Utils.NEW_LINE_WS, (CharSequence)this.bodyTargetCode, (String)("\n" + indent));
    }

    public final boolean isSequenceActionInstance() {
        return this instanceof SequenceActionInstance;
    }

    public final boolean isParallelActionInstance() {
        return this instanceof ParallelActionInstance;
    }

    @Override
    public ExecBlockKind solvedState() {
        ExecBlockKind currentSolveState = this.getCurrentSolveState();
        if (!this.isCompoundAction() && currentSolveState == ExecBlockKind.SOLVE) {
            return ExecBlockKind.PRE_SOLVE;
        }
        return currentSolveState;
    }

    @Override
    public void preSolve() {
        ExecBlockKind currentSolveState = this.getCurrentSolveState();
        if (currentSolveState != ExecBlockKind.NONE) {
            return;
        }
        this.setCurrentSolveState(ExecBlockKind.PRE_SOLVE);
        this.applyExecDescriptors(null, null, ExecBlockKind.PRE_SOLVE, this.getRfAction());
        this.preSolveFields();
    }

    @Override
    public boolean solve() {
        ExecBlockKind currentSolveState = this.getCurrentSolveState();
        if (currentSolveState != ExecBlockKind.PRE_SOLVE) {
            return false;
        }
        boolean hasSolution = this.scenario.solver.checkConnectConstraint(false, false, true, this);
        this.setCurrentSolveState(ExecBlockKind.SOLVE);
        return hasSolution;
    }

    @Override
    public void postSolve() {
        ExecBlockKind currentSolveState = this.getCurrentSolveState();
        if (currentSolveState != ExecBlockKind.SOLVE && currentSolveState != ExecBlockKind.SOLVE_COMPOUND) {
            return;
        }
        this.setCurrentSolveState(ExecBlockKind.POST_SOLVE);
        this.assignExecutor();
        this.postSolveFields();
        this.applyExecDescriptors(null, null, ExecBlockKind.POST_SOLVE, this.getRfAction());
    }

    public void postActivity() {
        ExecBlockKind currentSolveState = this.getCurrentSolveState();
        if (currentSolveState != ExecBlockKind.POST_SOLVE) {
            return;
        }
        this.applyExecDescriptors(null, null, ExecBlockKind.POST_ACTIVITY, this.getRfAction());
    }

    protected final void assignExecutor() {
        ComponentInstance executorInstance2;
        InstancesContainer claimInstance = this.scenario.executorAssignments.get(this);
        if (claimInstance == null) {
            return;
        }
        List<ComponentInstance> allocatableExecutors = this.parentComponentInstance.getAllocatableExecutors(claimInstance, -1, null);
        if (allocatableExecutors.isEmpty()) {
            throw new Solver.EvaluationException(Utils.append("Executor claim '", claimInstance, "' cannot be assigned to an executor (executor unavailable)"), claimInstance.getRfField().getDeclaration());
        }
        ArrayList<ComponentInstance> executorMatches = new ArrayList<ComponentInstance>();
        for (ComponentInstance executorInstance2 : allocatableExecutors) {
            FieldInstance executorTraitInstance;
            FieldInstance claimTraitInstance = claimInstance.getFieldInstance("trait");
            if (!claimTraitInstance.deepCompare(executorTraitInstance = executorInstance2.getFieldInstance("trait"), false, true, -1, null)) continue;
            executorMatches.add(executorInstance2);
        }
        if (executorMatches.isEmpty()) {
            throw new Solver.EvaluationException(Utils.append("Executor claim '", claimInstance, "' cannot be assigned to an executor (trait mismatch)"), claimInstance.getRfField().getDeclaration());
        }
        executorInstance2 = (ComponentInstance)this.scenario.getSolver().pickCandidate(executorMatches);
        this.scenario.executorAssignments.put(this, executorInstance2);
        ScenarioUtils.printNote(Utils.append("Executor claim '", claimInstance, "' assigned to '", executorInstance2.getInstancePath(), "'"), false, claimInstance.getRfField().getDeclaration());
    }

    @NotNull
    public final List<PortInstance> getPortInstances() {
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PortInstance> portInstances = new ArrayList<PortInstance>();
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if (!fieldInstance.isPort()) continue;
            if (fieldInstance.isArrayType()) {
                Map<String, FieldInstance> fieldInstanceItems = fieldInstance.getFieldInstances();
                for (FieldInstance fieldInstanceItem : fieldInstanceItems.values()) {
                    if (!fieldInstanceItem.isPort()) continue;
                    portInstances.add((PortInstance)fieldInstanceItem);
                }
                continue;
            }
            portInstances.add((PortInstance)fieldInstance);
        }
        return portInstances;
    }

    public String getRuntimeBranchLabel(boolean breakOnParallel) {
        if (this.parentActionInstance == null) {
            return null;
        }
        return this.parentActionInstance.getRuntimeBranchLabel(breakOnParallel);
    }

    @Override
    protected Collection<? extends InstancesContainer> getMembers() {
        throw new UnsupportedOperationException();
    }

    public void collectConcurrentActions(List<ActionInstance> actionInstances, List<ActionInstance> parallelActions, ActionInstance childActionInstance) {
        if (this.parentActionInstance == null) {
            return;
        }
        this.parentActionInstance.collectConcurrentActions(actionInstances, parallelActions, this);
        Iterator<ActionInstance> iterator = actionInstances.iterator();
        while (iterator.hasNext()) {
            ActionInstance candidate = iterator.next();
            if (!this.isParallel(candidate)) continue;
            parallelActions.add(candidate);
            iterator.remove();
        }
    }

    public boolean isRuntimeSchedulingAction() {
        return false;
    }

    public boolean isActionQualifiedFieldWrapper() {
        RfStruct rfAction = this.getRfAction();
        return rfAction != null && ScenarioUtils.getDeduplicateName(rfAction).endsWith(WRAPPER_SUFFIX);
    }

    @Override
    protected boolean isValueCopyAssignment() {
        return false;
    }

    public void putRepeatIndexValue(RfField.RfIndexField rfIndexField, int indexValue) {
        throw new UnsupportedOperationException();
    }

    public void putRepeatIteratorValue(RfField.RfIteratorField rfIteratorField, InstancesContainer iteratorValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toStringVariableValue() {
        return this.getHierarchicalPath().toString();
    }

    static abstract class AbstractSchedulingInstance
    extends ActionInstance
    implements ISchedulingInstance {
        private static final long serialVersionUID = 1L;
        private transient RfField.RfIndexField rfIndexField;
        private Expression.Value indexValue;
        private transient RfField.RfIteratorField rfIteratorField;
        private Expression.Value iteratorValue;

        protected AbstractSchedulingInstance(String instanceName, int instanceIndex, BigInteger runtimeId, RfStruct rfAction, ComponentInstance parentComponentInstance, Scenario scenario) {
            super(instanceName, instanceIndex, runtimeId, rfAction, parentComponentInstance, scenario);
        }

        @Override
        public void putRepeatIndexValue(RfField.RfIndexField rfIndexField, int indexValue) {
            Assert.isTrue((this.rfIndexField == null ? 1 : 0) != 0);
            this.rfIndexField = rfIndexField;
            this.indexValue = Expression.Value.from(BigInteger.valueOf(indexValue), 32, true);
        }

        @Override
        public void putRepeatIteratorValue(RfField.RfIteratorField rfIteratorField, InstancesContainer iteratorValue) {
            Assert.isTrue((this.rfIteratorField == null ? 1 : 0) != 0);
            this.rfIteratorField = rfIteratorField;
            this.iteratorValue = Expression.Value.from(iteratorValue, -1, false);
        }

        @Override
        public Expression.Value getRepeatIndexValue(RfField.RfIndexField rfIndexField) {
            if (this.rfIndexField == rfIndexField) {
                return this.indexValue;
            }
            return super.getRepeatIndexValue(rfIndexField);
        }

        @Override
        public Expression.Value getRepeatIteratorValue(RfField.RfIteratorField rfIteratorField) {
            if (this.rfIteratorField == rfIteratorField) {
                return this.iteratorValue;
            }
            return super.getRepeatIteratorValue(rfIteratorField);
        }

        @Override
        public FieldInstance getFieldInstance(InstancesContainer instance) {
            if (this.typeInstance == null) {
                return this.parentActionInstance.getFieldInstance(instance);
            }
            FieldInstance fieldInstance = this.typeInstance.getFieldInstance(instance);
            if (fieldInstance != null) {
                return fieldInstance;
            }
            return this.parentActionInstance.getFieldInstance(instance);
        }

        @Override
        public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
        }

        @Override
        public FieldInstance createFieldInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, String instanceName, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance) {
            return null;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeInt(ScenarioUtils.getKeyOfRf(this.rfIndexField));
            out.writeInt(ScenarioUtils.getKeyOfRf(this.rfIteratorField));
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.rfIndexField = (RfField.RfIndexField)ScenarioUtils.getRfOfKey(in.readInt());
            this.rfIteratorField = (RfField.RfIteratorField)ScenarioUtils.getRfOfKey(in.readInt());
        }
    }

    static class Child {
        private ActionInstance childInstance;
        private boolean isParallelCandidate;

        public Child(ActionInstance childInstance, boolean isParallelCandidate) {
            this.childInstance = childInstance;
            this.isParallelCandidate = isParallelCandidate;
        }
    }

    public static class ParallelActionInstance
    extends AbstractSchedulingInstance {
        private static final long serialVersionUID = 1L;

        public ParallelActionInstance(String instanceName, BigInteger runtimeId, Scenario scenario) {
            super(instanceName, -1, runtimeId, null, null, scenario);
            scenario.addSchedulingInstance(this);
        }

        @Override
        protected boolean isAnonymousSchedulingInstance() {
            return ActionInstance.PARALLEL_ACTION_NAME.equals(this.name);
        }

        @Override
        public void scheduleBefore(ActionInstance candidate) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                if (!Solver.inSameRuntime(child, candidate)) continue;
                child.scheduleBefore(candidate);
            }
        }

        @Override
        public void scheduleParallel(ActionInstance candidate) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                if (!Solver.inSameRuntime(child, candidate)) continue;
                child.scheduleParallel(candidate);
            }
        }

        @Override
        protected void collectBeforeCandidates(List<ActionInstance> beforeCandidates, ActionInstance prevParentActionInstance) {
            if (this.parentActionInstance != null) {
                this.parentActionInstance.collectBeforeCandidates(beforeCandidates, this);
            }
        }

        @Override
        public void visitBeforeUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundBefore) {
            if (this.parentActionInstance != null) {
                this.parentActionInstance.visitBeforeUp(actionInstance, this, isCompoundBefore);
            }
        }

        @Override
        public void visitBeforeDown(ActionInstance actionInstance) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                child.visitBeforeDown(actionInstance);
            }
        }

        @Override
        public void visitParallelUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundParallel) {
            if (this.childrenActionInstances != null && !this.childrenActionInstances.isEmpty()) {
                for (ActionInstance child : this.childrenActionInstances) {
                    if (child == prevParentActionInstance) continue;
                    child.visitParallelDown(actionInstance);
                }
            }
            if (this.parentActionInstance != null) {
                this.parentActionInstance.visitParallelUp(actionInstance, this, isCompoundParallel);
            }
        }

        @Override
        public void visitParallelDown(ActionInstance actionInstance) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                child.visitParallelDown(actionInstance);
            }
        }

        @Override
        public void insertBefore(ActionInstance a1, ActionInstance a2, boolean reverse) {
            if (reverse) {
                int index = this.childrenActionInstances.indexOf(a2);
                SequenceActionInstance sequence = new SequenceActionInstance(ActionInstance.SEQUENCE_ACTION_NAME, this.runtimeId, this.scenario);
                this.childrenActionInstances.set(index, sequence);
                sequence.parentActionInstance = this;
                sequence.addChildAction(a2);
                sequence.addChildAction(a1);
            } else {
                this.parentActionInstance.insertBefore(a1, this, reverse);
            }
        }

        @Override
        public String getRuntimeBranchLabel(boolean breakOnParallel) {
            if (breakOnParallel) {
                return null;
            }
            return this.parentActionInstance.getRuntimeBranchLabel(true);
        }

        @Override
        public void collectConcurrentActions(List<ActionInstance> actionInstances, List<ActionInstance> parallelActions, ActionInstance childActionInstance) {
            if (this.parentActionInstance == null) {
                return;
            }
            for (ActionInstance actionInstance : this.childrenActionInstances) {
                if (actionInstance == childActionInstance || !Solver.inSameRuntime(actionInstance, childActionInstance)) continue;
                List<ActionInstance> concurrentActionInstances = Solver.getChildrenRecursive(actionInstance);
                for (ActionInstance concurrentActionInstance : concurrentActionInstances) {
                    actionInstances.add(concurrentActionInstance);
                }
            }
            this.parentActionInstance.collectConcurrentActions(actionInstances, parallelActions, this);
        }

        @Override
        public void visitScheduleDown(ActionInstance actionInstance) {
            if (!Solver.inSameRuntime(this, actionInstance)) {
                return;
            }
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                child.visitScheduleDown(actionInstance);
            }
        }
    }

    public static class RuntimeBranchActionInstance
    extends SequenceActionInstance {
        private static final long serialVersionUID = 1L;
        private String branchLabel;

        public RuntimeBranchActionInstance(String instanceName, String branchLabel, BigInteger runtimeId, Scenario scenario) {
            super(instanceName, runtimeId, scenario);
            this.branchLabel = branchLabel;
        }

        @Override
        protected boolean isAnonymousSchedulingInstance() {
            return true;
        }

        @Override
        public String getRuntimeBranchLabel(boolean breakOnParallel) {
            return this.branchLabel;
        }

        @Override
        public boolean isRuntimeSchedulingAction() {
            return true;
        }
    }

    public static class RuntimeIfActionInstance
    extends ParallelActionInstance {
        private static final long serialVersionUID = 1L;

        public RuntimeIfActionInstance(String instanceName, BigInteger runtimeId, Scenario scenario) {
            super(instanceName, runtimeId, scenario);
        }

        @Override
        protected boolean isAnonymousSchedulingInstance() {
            return true;
        }

        @Override
        public boolean isRuntimeSchedulingAction() {
            return true;
        }
    }

    public static class RuntimeMatchActionInstance
    extends ParallelActionInstance {
        private static final long serialVersionUID = 1L;

        public RuntimeMatchActionInstance(String instanceName, BigInteger runtimeId, Scenario scenario) {
            super(instanceName, runtimeId, scenario);
        }

        @Override
        protected boolean isAnonymousSchedulingInstance() {
            return true;
        }

        @Override
        public boolean isRuntimeSchedulingAction() {
            return true;
        }
    }

    public static class RuntimeWhileActionInstance
    extends ParallelActionInstance {
        private static final long serialVersionUID = 1L;

        public RuntimeWhileActionInstance(String instanceName, BigInteger runtimeId, Scenario scenario) {
            super(instanceName, runtimeId, scenario);
        }

        @Override
        protected boolean isAnonymousSchedulingInstance() {
            return true;
        }

        @Override
        public boolean isRuntimeSchedulingAction() {
            return true;
        }
    }

    public static class ScheduleActionInstance
    extends AbstractSchedulingInstance {
        private static final long serialVersionUID = 1L;

        public ScheduleActionInstance(String instanceName, BigInteger runtimeId, Scenario scenario) {
            super(instanceName, -1, runtimeId, null, null, scenario);
            scenario.addSchedulingInstance(this);
        }

        @Override
        protected boolean isAnonymousSchedulingInstance() {
            return ActionInstance.SCHEDULE_ACTION_NAME.equals(this.name);
        }

        @Override
        public void scheduleBefore(ActionInstance candidate) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                if (!Solver.inSameRuntime(child, candidate)) continue;
                child.scheduleBefore(candidate);
            }
        }

        @Override
        public void scheduleParallel(ActionInstance candidate) {
            ScenarioUtils.print("*** Error: Internal error SPS_1");
        }

        @Override
        public void insertBefore(ActionInstance a1, ActionInstance a2, boolean reverse) {
            int index = this.childrenActionInstances.indexOf(a2);
            SequenceActionInstance sequence = new SequenceActionInstance(ActionInstance.SEQUENCE_ACTION_NAME, this.runtimeId, this.scenario);
            sequence.parentActionInstance = this;
            this.childrenActionInstances.set(index, sequence);
            if (!reverse) {
                sequence.addChildAction(a1);
                sequence.addChildAction(a2);
            } else {
                sequence.addChildAction(a2);
                sequence.addChildAction(a1);
            }
        }

        @Override
        protected void collectBeforeCandidates(List<ActionInstance> beforeCandidates, ActionInstance prevParentActionInstance) {
            if (this.parentActionInstance != null) {
                this.parentActionInstance.collectBeforeCandidates(beforeCandidates, this);
            }
        }

        @Override
        public void visitBeforeUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundBefore) {
            if (this.parentActionInstance != null) {
                this.parentActionInstance.visitBeforeUp(actionInstance, this, false);
            }
        }

        @Override
        public void visitBeforeDown(ActionInstance actionInstance) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                child.visitBeforeDown(actionInstance);
            }
        }

        @Override
        public void visitParallelUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundParallel) {
            if (this.parentActionInstance != null) {
                this.parentActionInstance.visitParallelUp(actionInstance, this, false);
            }
        }

        @Override
        public void visitParallelDown(ActionInstance actionInstance) {
        }

        @Override
        public void collectConcurrentActions(List<ActionInstance> actionInstances, List<ActionInstance> parallelActions, ActionInstance childActionInstance) {
            if (this.parentActionInstance == null) {
                return;
            }
            this.parentActionInstance.collectConcurrentActions(actionInstances, parallelActions, this);
        }

        @Override
        public void visitScheduleDown(ActionInstance actionInstance) {
            if (!Solver.inSameRuntime(this, actionInstance)) {
                return;
            }
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                child.visitScheduleDown(actionInstance);
            }
        }
    }

    static class SchedulingParent {
        private ISchedulingInstance parent;
        private ActionInstance child1;
        private ActionInstance child2;
        private boolean parallelSchedulingAllowed;

        public SchedulingParent(ISchedulingInstance parent, ActionInstance child1, ActionInstance child2, boolean parallelSchedulingAllowed) {
            this.parent = parent;
            this.child1 = child1;
            this.child2 = child2;
            this.parallelSchedulingAllowed = parent instanceof ScheduleActionInstance || parallelSchedulingAllowed;
        }

        public boolean canScheduleBefore() {
            int indexOf2;
            if (this.parent instanceof ParallelActionInstance) {
                return false;
            }
            if (this.parent instanceof ScheduleActionInstance) {
                return true;
            }
            int indexOf1 = ((ActionInstance)((Object)this.parent)).childrenActionInstances.indexOf(this.child1);
            return indexOf1 < (indexOf2 = ((ActionInstance)((Object)this.parent)).childrenActionInstances.indexOf(this.child2));
        }

        public boolean canScheduleParallel() {
            return this.parent instanceof ParallelActionInstance || this.parent instanceof ScheduleActionInstance && this.parallelSchedulingAllowed;
        }

        public boolean canScheduleSequential() {
            return !this.isParallelSchedulingParent();
        }

        public boolean isParallelSchedulingParent() {
            return this.parent instanceof ParallelActionInstance;
        }
    }

    public static class SequenceActionInstance
    extends AbstractSchedulingInstance {
        private static final long serialVersionUID = 1L;

        public SequenceActionInstance(String instanceName, BigInteger runtimeId, Scenario scenario) {
            super(instanceName, -1, runtimeId, null, null, scenario);
            scenario.addSchedulingInstance(this);
        }

        @Override
        protected boolean isAnonymousSchedulingInstance() {
            return ActionInstance.SEQUENCE_ACTION_NAME.equals(this.name);
        }

        @Override
        public void insertBefore(ActionInstance a1, ActionInstance a2, boolean reverse) {
            int index = this.childrenActionInstances.indexOf(a2);
            if (reverse) {
                int insertIndex = index + 1;
                if (insertIndex < this.childrenActionInstances.size()) {
                    this.childrenActionInstances.add(insertIndex, a1);
                    a1.parentActionInstance = this;
                } else {
                    this.addChildAction(a1);
                }
            } else {
                int insertIndex = index;
                if (insertIndex == 0 && this.parentActionInstance instanceof ParallelActionInstance && !this.parentActionInstance.isRuntimeSchedulingAction()) {
                    this.parentActionInstance.insertBefore(a1, this, reverse);
                } else {
                    this.childrenActionInstances.add(insertIndex, a1);
                    a1.parentActionInstance = this;
                }
            }
        }

        @Override
        public void scheduleBefore(ActionInstance candidate) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                if (!Solver.inSameRuntime(child, candidate)) continue;
                child.scheduleBefore(candidate);
            }
        }

        @Override
        public void scheduleParallel(ActionInstance candidate) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                if (!Solver.inSameRuntime(child, candidate)) continue;
                child.scheduleParallel(candidate);
                break;
            }
        }

        @Override
        protected void collectBeforeCandidates(List<ActionInstance> beforeCandidates, ActionInstance prevParentActionInstance) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                if (child == prevParentActionInstance) {
                    if (this.parentActionInstance != null) {
                        this.parentActionInstance.collectBeforeCandidates(beforeCandidates, this);
                    }
                    return;
                }
                child.collectBeforeCandidatesDown(beforeCandidates);
            }
        }

        @Override
        public void visitBeforeUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundBefore) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            boolean isFirstChild = true;
            for (ActionInstance child : this.childrenActionInstances) {
                if (child == prevParentActionInstance) {
                    if (this.parentActionInstance != null) {
                        this.parentActionInstance.visitBeforeUp(actionInstance, this, isCompoundBefore && !isFirstChild);
                    }
                    return;
                }
                isFirstChild = false;
                child.visitBeforeDown(actionInstance);
            }
        }

        @Override
        public void visitBeforeDown(ActionInstance actionInstance) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                child.visitBeforeDown(actionInstance);
            }
        }

        @Override
        public void visitParallelUp(ActionInstance actionInstance, ActionInstance prevParentActionInstance, boolean isCompoundParallel) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            boolean isFirstChild = true;
            for (ActionInstance child : this.childrenActionInstances) {
                if (child == prevParentActionInstance) {
                    if (this.parentActionInstance != null && isCompoundParallel && isFirstChild) {
                        this.parentActionInstance.visitParallelUp(actionInstance, this, true);
                    }
                    return;
                }
                isFirstChild = false;
            }
        }

        @Override
        public void visitParallelDown(ActionInstance actionInstance) {
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            ((ActionInstance)this.childrenActionInstances.get(0)).visitParallelDown(actionInstance);
        }

        @Override
        public void collectConcurrentActions(List<ActionInstance> actionInstances, List<ActionInstance> parallelActions, ActionInstance childActionInstance) {
            if (this.parentActionInstance == null) {
                return;
            }
            this.parentActionInstance.collectConcurrentActions(actionInstances, parallelActions, this);
        }

        @Override
        public void visitScheduleDown(ActionInstance actionInstance) {
            if (!Solver.inSameRuntime(this, actionInstance)) {
                return;
            }
            if (this.childrenActionInstances == null || this.childrenActionInstances.isEmpty()) {
                return;
            }
            for (ActionInstance child : this.childrenActionInstances) {
                child.visitScheduleDown(actionInstance);
            }
        }
    }
}

