/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import antlr.collections.AST;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.MethodCallContext;
import ro.amiq.pssdt.model.reflection.elaboration.Pool;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.SchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Stack;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.parser.ModelWalker;

public abstract class ActivityDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean SEQUENTIAL_LOOP = true;
    protected String label;
    protected int line;
    protected ParserPath parserPath;
    protected ActionInstance parentActionInstance;
    protected List<Integer> options;
    protected BigInteger runtimeId;
    protected PostRunnable traversePostRunnable;

    protected ActivityDescriptor(ActionInstance parentActionInstance, String label, int line, ParserPath parserPath) {
        this.parentActionInstance = parentActionInstance;
        this.label = label;
        this.line = line;
        this.parserPath = parserPath;
        this.runtimeId = parentActionInstance == null ? Solver.DEFAULT_RUNTIME_ID : parentActionInstance.runtimeId;
    }

    protected void addTraversePostRunnable(PostRunnable traversePostRunnable) {
        this.traversePostRunnable = traversePostRunnable;
    }

    private final void traversePostRunnable(Solver solver) {
        if (this.traversePostRunnable == null) {
            return;
        }
        this.traversePostRunnable.run(solver);
    }

    public void setOptions(List<Integer> options) {
        this.options = options;
    }

    public List<Integer> getOptions(Solver solver) {
        return this.options;
    }

    protected static void solveScenario(Solver solver, int depthLevel, AtomicInteger solutionCost) {
        ActivityDescriptor nextDescriptor = solver.peekActivityDescriptor();
        List<Integer> remainingOptions = nextDescriptor == null ? null : nextDescriptor.getOptions(solver);
        int nofPrevOptions = ActivityDescriptor.nofRemainingOptions(remainingOptions);
        solver.updateRemainingOptions(nofPrevOptions);
        boolean hasBacktrakingOptions = nofPrevOptions > 1;
        Scenario.Snapshot snapshot = hasBacktrakingOptions ? solver.getScenario().snapshot() : null;
        block3: while (true) {
            try {
                while (true) {
                    solver.checkInterrupted();
                    nextDescriptor = solver.popActivityDescriptor();
                    if (nextDescriptor == null) break block3;
                    solutionCost.incrementAndGet();
                    nextDescriptor.solve(solver);
                    solver.remainingOptions.set(depthLevel, ActivityDescriptor.nofRemainingOptions(remainingOptions));
                    ActivityDescriptor.solveScenario(solver, depthLevel + 1, solutionCost);
                }
            }
            catch (Solver.GoToLevelException e) {
                if (depthLevel != e.getDepthLevel()) {
                    throw e;
                }
                if (!hasBacktrakingOptions) {
                    solver.print("*** Error: Internal error SOL_1");
                    throw new Solver.InterruptException();
                }
                if (remainingOptions == null || remainingOptions.isEmpty()) {
                    solver.print("*** Error: Internal error SOL_2");
                    throw new Solver.InterruptException();
                }
                solver.setScenario(Scenario.restore(snapshot, solver));
                nextDescriptor = solver.peekActivityDescriptor();
                nextDescriptor.setOptions(remainingOptions);
                solver.remainingOptions.set(depthLevel, ActivityDescriptor.nofRemainingOptions(remainingOptions));
                continue;
            }
            catch (Solver.SolverException e) {
                int[] levelCandidates;
                if (!hasBacktrakingOptions) {
                    throw e;
                }
                remainingOptions = nextDescriptor == null ? null : nextDescriptor.options;
                int nofCurrOptions = ActivityDescriptor.nofRemainingOptions(remainingOptions);
                if (remainingOptions == null || remainingOptions.isEmpty()) {
                    throw e;
                }
                if (nofCurrOptions >= nofPrevOptions) {
                    solver.print("*** Error: Internal error SOL_3");
                    throw new Solver.InterruptException();
                }
                solver.remainingOptions.removeUpperLevelsOptions(depthLevel);
                if (solutionCost.get() > solver.CONFIG_SOLUTION_COST + depthLevel && (levelCandidates = solver.remainingOptions.getLowerLevelsWithOptions(depthLevel, 4)).length > 0) {
                    int index = solver.pickIndex(levelCandidates.length);
                    throw new Solver.GoToLevelException(levelCandidates[index]);
                }
                solver.setScenario(Scenario.restore(snapshot, solver));
                nextDescriptor = solver.peekActivityDescriptor();
                nextDescriptor.setOptions(remainingOptions);
                solver.remainingOptions.set(depthLevel, ActivityDescriptor.nofRemainingOptions(remainingOptions));
                continue;
            }
            break;
        }
    }

    private static int nofRemainingOptions(List<Integer> remainingOptions) {
        return remainingOptions == null ? 0 : remainingOptions.size();
    }

    protected abstract void traverse(Solver var1, ActionInstance var2);

    protected ActionInstance createActionInstance(Solver solver) {
        return this.parentActionInstance;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    protected static void writeAST(ObjectOutputStream out, AST ast) throws IOException {
        int key = ScenarioUtils.getKeyOfAst(ast);
        out.writeInt(key);
    }

    protected static void writeRfElement(ObjectOutputStream out, RfNamedElement rfElement) throws IOException {
        int key = ScenarioUtils.getKeyOfRf(rfElement);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    protected static AST readAST(ObjectInputStream in) throws IOException {
        int key = in.readInt();
        return ScenarioUtils.getAstOfKey(key);
    }

    protected static RfNamedElement readRfElement(ObjectInputStream in) throws IOException {
        int key = in.readInt();
        return ScenarioUtils.getRfOfKey(key);
    }

    private final void solve(Solver solver) {
        ActionInstance actionInstance = this.createActionInstance(solver);
        this.traverse(solver, actionInstance);
        this.traversePostRunnable(solver);
    }

    public String getInstanceName() {
        if (this.label == null) {
            return "[anonymous]";
        }
        return this.label;
    }

    protected void pushActivityDescriptor(Scenario scenario) {
        scenario.pushActivityDescriptor(this);
    }

    protected void push0ActivityDescriptor(Scenario scenario) {
        scenario.push0ActivityDescriptor(this);
    }

    public static class ConnectHierarchicalAndPool
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private PortInstance portInstance;
        private List<PortInstance> connectCandidates;

        public ConnectHierarchicalAndPool(PortInstance portInstance) {
            super(null, null, -1, null);
            this.portInstance = portInstance;
            this.connectCandidates = new ArrayList<PortInstance>();
        }

        @Override
        public List<Integer> getOptions(Solver solver) {
            solver.connectUsingPortBindDescriptors(this.portInstance.getParentActionInstance(), this.portInstance);
            if (!this.portInstance.requiresBind(this.runtimeId)) {
                return this.options;
            }
            solver.collectPoolConnectCandidates(this.connectCandidates, this.portInstance);
            this.options = Utils.getIndexesList(this.connectCandidates);
            return this.options;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            block5: {
                PortInstance connectCandidate;
                block6: {
                    boolean solutionFound;
                    if (this.options == null || this.options.isEmpty()) {
                        return;
                    }
                    do {
                        if (this.options.isEmpty()) {
                            solver.logError(Utils.append("*** Error: All pool item candidates are used, cannot satisfy connection of '", this.portInstance, "'"));
                            throw new Solver.SolverException();
                        }
                        int index = solver.pickIndex(this.options.size());
                        int connectIndex = (Integer)this.options.remove(index);
                        connectCandidate = this.connectCandidates.get(connectIndex);
                        if (connectCandidate instanceof PoolItem && this.portInstance.isState()) {
                            this.portInstance.connectToPoolItem(connectCandidate);
                            break block5;
                        }
                        if (!(connectCandidate instanceof PoolItem) || !this.portInstance.isLockOrShare()) break block6;
                    } while (!(solutionFound = solver.checkResourceConnectConstraints(this.portInstance, connectCandidate)));
                    solver.postConnectConstraints(this.portInstance, connectCandidate);
                    this.portInstance.connectTo(connectCandidate);
                    break block5;
                }
                if (!(connectCandidate instanceof PoolItem)) {
                    solver.postConnectConstraints(this.portInstance, connectCandidate);
                    this.portInstance.connectHierarchicalTo(connectCandidate);
                }
            }
        }
    }

    public static class ConnectPortToExisting
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private PortInstance portInstance;
        private List<PortInstance> connectCandidates;

        public ConnectPortToExisting(PortInstance portInstance) {
            super(null, null, -1, null);
            this.portInstance = portInstance;
            this.connectCandidates = new ArrayList<PortInstance>();
        }

        @Override
        public List<Integer> getOptions(Solver solver) {
            if (this.options != null) {
                return this.options;
            }
            if (!this.portInstance.isInitialStateObject() && !this.portInstance.requiresBind(this.runtimeId)) {
                return this.options;
            }
            if (this.portInstance.isInitialStateObject()) {
                ((PoolItem)Utils.first(this.portInstance.getPoolBinds())).getPool().collectInitialStatePoolConnectOptions(this.connectCandidates);
            } else if (this.portInstance.isState()) {
                ((PoolItem)Utils.first(this.portInstance.getPoolBinds())).getPool().collectStatePoolConnectOptions(this.connectCandidates, this.portInstance);
            } else {
                solver.collectConnectFieldInstanceCandidates(this.connectCandidates, this.portInstance);
            }
            this.options = Utils.getIndexesList(this.connectCandidates);
            return this.options;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            block6: while (this.options != null && !this.options.isEmpty()) {
                Object prevScheduler;
                int index = solver.pickIndex(this.options.size());
                int connectIndex = (Integer)this.options.remove(index);
                PortInstance connectCandidate = this.connectCandidates.get(connectIndex);
                boolean solutionFound = solver.checkConnectConstraint(true, true, this.portInstance, connectCandidate);
                if (!solutionFound) continue;
                if (this.portInstance.isState() && this.portInstance.isOutput() && connectCandidate.isOutput()) {
                    Scenario scenario = solver.getScenario();
                    prevScheduler = scenario.scheduler;
                    try {
                        scenario.scheduler = scenario.scheduler.copy();
                        this.portInstance.scheduleConnectTo(connectCandidate);
                        break;
                    }
                    catch (SchedulerProxy.SchedulingException schedulingException) {
                        scenario.scheduler = prevScheduler;
                        if (!this.options.isEmpty()) continue;
                        throw new Solver.SolverException();
                    }
                }
                if (this.portInstance.isState() && connectCandidate.hasBinds(this.runtimeId)) {
                    if (connectCandidate.isInput()) continue;
                    if (this.portInstance.hasPoolConnectedOutput()) {
                        for (FieldInstance fieldInstance : connectCandidate.getBinds()) {
                            if (fieldInstance.hasPoolConnectedOutput()) continue block6;
                        }
                    }
                    Scenario scenario = solver.getScenario();
                    prevScheduler = scenario.scheduler;
                    try {
                        scenario.scheduler = scenario.scheduler.copy();
                        solver.postConnectConstraints(this.portInstance, connectCandidate);
                        this.portInstance.connectTo(connectCandidate);
                        break;
                    }
                    catch (SchedulerProxy.SchedulingException schedulingException) {
                        scenario.scheduler = prevScheduler;
                        if (!this.options.isEmpty()) continue;
                        throw new Solver.SolverException();
                    }
                }
                Scenario scenario = solver.getScenario();
                prevScheduler = scenario.scheduler;
                try {
                    scenario.scheduler = scenario.scheduler.copy();
                    this.portInstance.scheduleConnectTo(connectCandidate);
                    if (this.portInstance.isLockOrShare()) {
                        solver.checkResourcePoolSchedulingConsistency();
                    }
                    solver.postConnectConstraints(this.portInstance, connectCandidate);
                    this.portInstance.addBind(connectCandidate);
                    connectCandidate.addBind(this.portInstance);
                    break;
                }
                catch (SchedulerProxy.SchedulingException | Solver.SolverException runtimeException) {
                    scenario.scheduler = prevScheduler;
                    if (!this.options.isEmpty()) continue;
                    throw new Solver.SolverException();
                }
            }
            if (!this.portInstance.isLockOrShare() && !this.portInstance.isInitialStateObject() && this.portInstance.requiresBind(this.runtimeId)) {
                solver.pushActivityDescriptor(new ConnectPortToInferedActionsPath(this.portInstance));
            }
        }
    }

    public static class ConnectPortToInferedAction
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private PortInstance fieldInstance1;
        private PortInstance fieldInstance2;
        private PortInstance poolItem;

        public ConnectPortToInferedAction(PortInstance fieldInstance1, PortInstance fieldInstance2, PortInstance poolItem) {
            super(null, null, -1, null);
            this.fieldInstance1 = fieldInstance1;
            this.fieldInstance2 = fieldInstance2;
            this.poolItem = poolItem;
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance actionInstance;
            Scenario scenario = solver.getScenario();
            if (scenario.problemsLogger != null) {
                scenario.problemsLogger.clear();
            }
            if ((actionInstance = this.fieldInstance2.getParentActionInstance()).isInferred() && actionInstance.instanceIndex == -1) {
                String instanceName = solver.getActionInstanceName("[inferred]", scenario.actionInstances.size(), actionInstance.getRfAction());
                actionInstance.setName(instanceName);
                actionInstance.setInferred(true);
                scenario.addActionInstance(actionInstance);
                actionInstance.parentComponentInstance.addChildActionInstance(actionInstance);
                if (scenario.inferenceCount >= solver.CONFIG_INFERENCE_LIMIT) {
                    solver.print(Utils.append("*** FATAL: Max inference limit reached (", scenario.inferenceCount, ")"));
                    throw new Solver.NoInferringCandidatesException();
                }
                solver.printDebug1(Utils.append("*** Warning: Infer new action '", actionInstance.getDiagramName(), "' to provide connections with '", this.fieldInstance1, "' (connect to '", this.fieldInstance2, "')"));
                ++scenario.inferenceCount;
                if (this.fieldInstance1.isState() || this.fieldInstance1.isStream()) {
                    scenario.setInferredActionAnchor(actionInstance, this.fieldInstance1.getParentActionInstance());
                }
            } else {
                actionInstance = null;
            }
            solver.postConnectConstraints(this.fieldInstance1, this.fieldInstance2);
            this.fieldInstance1.connectTo(this.fieldInstance2);
            if (this.fieldInstance1.isState() && !this.fieldInstance1.isInitialStateObject()) {
                this.fieldInstance1.connectToPoolItem(this.poolItem);
            }
            if (this.fieldInstance2.isState() && !this.fieldInstance2.isInitialStateObject()) {
                this.fieldInstance2.connectToPoolItem(this.poolItem);
            }
            return actionInstance;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            if (actionInstance == null) {
                return;
            }
            solver.pushTraversedActionHandles(Collections.newSetFromMap(new IdentityHashMap()));
            solver.pushActivityDescriptor(new TraversalEndDescriptor(actionInstance));
            solver.traverseFirstLevel(actionInstance);
        }
    }

    public static class ConnectPortToInferedActionsPath
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private PortInstance portInstance;
        private List<Solver.InferenceSolution> connectCandidates;

        public ConnectPortToInferedActionsPath(PortInstance portInstance) {
            super(null, null, -1, null);
            this.portInstance = portInstance;
            this.connectCandidates = new ArrayList<Solver.InferenceSolution>();
        }

        @Override
        public List<Integer> getOptions(Solver solver) {
            if (this.options != null) {
                return this.options;
            }
            if (!this.portInstance.requiresBind(this.runtimeId)) {
                return this.options;
            }
            this.connectCandidates = solver.collectInferenceCandidates(this.portInstance, false);
            if (this.connectCandidates == null || this.connectCandidates.isEmpty()) {
                this.connectCandidates = solver.collectInferenceCandidates(this.portInstance, true);
            }
            if (this.connectCandidates.isEmpty()) {
                solver.print(Utils.append("*** Error: No candidates to infer in order to satisfy connection of '", this.portInstance, "'"));
                throw new Solver.SolverException();
            }
            this.options = Utils.getIndexesList(this.connectCandidates);
            return this.options;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            if (!this.portInstance.requiresBind(this.runtimeId)) {
                return;
            }
            if (this.options == null || this.options.isEmpty()) {
                return;
            }
            int index = solver.pickIndex(this.options.size());
            int connectIndex = (Integer)this.options.remove(index);
            Scenario scenario = solver.getScenario();
            if (scenario.problemsLogger != null) {
                scenario.problemsLogger.clear();
            }
            Solver.InferenceSolution inferenceSolution = this.connectCandidates.get(connectIndex);
            int size = inferenceSolution.inferenceConnects.size();
            boolean solutionFound = solver.checkConnectConstraint(inferenceSolution.inferenceConnects, new Stack<ActionInstance>(), 0);
            if (!solutionFound) {
                throw new Solver.SolverException();
            }
            int i = 0;
            while (i < size) {
                Solver.InferenceConnect inferenceConnect = inferenceSolution.inferenceConnects.get(size - i - 1);
                solver.pushActivityDescriptor(new ConnectPortToInferedAction(inferenceConnect.fieldInstance1, inferenceConnect.fieldInstance2, inferenceConnect.poolItem));
                ++i;
            }
        }
    }

    public static class DummyDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;

        public DummyDescriptor() {
            super(null, null, -1, null);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
        }
    }

    public static class DynamicConstraintDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private String dynamicConstraintName;

        public DynamicConstraintDescriptor(Solver solver, ActionInstance parentActionInstance, String dynamicConstraintName, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.dynamicConstraintName = dynamicConstraintName;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            solver.useDynamicConstraintDescriptor(this.parentActionInstance, this.dynamicConstraintName);
        }
    }

    public static class ForeachDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private Expression expression;
        private transient AST activityAST;
        private transient RfField.RfIndexField rfIndexField;
        private transient RfField.RfIteratorField rfIteratorField;

        public ForeachDescriptor(Solver solver, ActionInstance parentActionInstance, Expression expression, RfField.RfIndexField rfIndexField, RfField.RfIteratorField rfIteratorField, AST activityAST, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.activityAST = activityAST;
            this.expression = expression;
            this.rfIndexField = rfIndexField;
            this.rfIteratorField = rfIteratorField;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            ForeachDescriptor.writeAST(out, this.activityAST);
            ForeachDescriptor.writeRfElement(out, this.rfIndexField);
            ForeachDescriptor.writeRfElement(out, this.rfIteratorField);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = ForeachDescriptor.readAST(in);
            this.rfIndexField = (RfField.RfIndexField)ForeachDescriptor.readRfElement(in);
            this.rfIteratorField = (RfField.RfIteratorField)ForeachDescriptor.readRfElement(in);
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.SequenceActionInstance actionInstance = new ActionInstance.SequenceActionInstance("[sequence]", this.runtimeId, solver.getScenario());
            this.parentActionInstance.addChildAction(actionInstance);
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
            modelWalker.addConstraintDescriptors(this.activityAST, actionInstance, false);
            ActionInstance hierarchicalParentActionInstance = actionInstance.getParentActionInstance();
            if (this.rfIteratorField != null) {
                List<Expression.ExprAndDep<Expression.Value>> value = this.expression.evaluate(solver.getScenario(), actionInstance);
                if (value == null || value.size() != 1) {
                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.expression.toString(false), "' expression"), this.line, this.parserPath);
                }
                solver.getScenario().pushRepeatId();
                ActivityDescriptor activityDescriptor = new IndexedEndDescriptor(this.rfIndexField, this.rfIteratorField);
                activityDescriptor.parentActionInstance = actionInstance;
                solver.pushActivityDescriptor(activityDescriptor);
                InstancesContainer collectionInstance = ((Expression.Value)value.get((int)0).expr).getRefValue();
                Map<String, FieldInstance> fieldInstances = collectionInstance.getFieldInstances();
                ArrayList<FieldInstance> itemFieldInstances = new ArrayList<FieldInstance>(fieldInstances.values());
                Collections.reverse(itemFieldInstances);
                for (FieldInstance itemFieldInstance : itemFieldInstances) {
                    if (itemFieldInstance.arrayItemIndex < 0) continue;
                    solver.checkInterrupted();
                    int index = itemFieldInstance.arrayItemIndex;
                    activityDescriptor = new IndexedDescriptor(solver, actionInstance, this.rfIndexField, index, this.rfIteratorField, itemFieldInstance, this.activityAST, this.label, this.line, this.parserPath);
                    activityDescriptor.parentActionInstance = actionInstance;
                    solver.pushActivityDescriptor(activityDescriptor);
                }
            } else {
                int nofRepeats = solver.evalForeach(hierarchicalParentActionInstance, this.expression, false, this.line, this.parserPath);
                solver.getScenario().pushRepeatId();
                ActivityDescriptor activityDescriptor = new IndexedEndDescriptor(this.rfIndexField, this.rfIteratorField);
                activityDescriptor.parentActionInstance = actionInstance;
                solver.pushActivityDescriptor(activityDescriptor);
                int i = 0;
                while (i < nofRepeats) {
                    solver.checkInterrupted();
                    int index = nofRepeats - 1 - i;
                    activityDescriptor = new IndexedDescriptor(solver, actionInstance, this.rfIndexField, index, this.activityAST, this.label, this.line, this.parserPath);
                    activityDescriptor.parentActionInstance = actionInstance;
                    solver.pushActivityDescriptor(activityDescriptor);
                    ++i;
                }
            }
        }
    }

    public static class IfDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private Expression expression;
        private boolean isRuntime;
        private transient AST ifBranchAST;
        private transient AST elseBranchAST;

        public IfDescriptor(Solver solver, ActionInstance parentActionInstance, Expression expression, AST ifBranchAST, AST elseBranchAST, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.expression = expression;
            this.ifBranchAST = ifBranchAST;
            this.elseBranchAST = elseBranchAST;
            this.isRuntime = expression.isRuntime();
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            IfDescriptor.writeAST(out, this.ifBranchAST);
            IfDescriptor.writeAST(out, this.elseBranchAST);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.ifBranchAST = IfDescriptor.readAST(in);
            this.elseBranchAST = IfDescriptor.readAST(in);
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.AbstractSchedulingInstance actionInstance = null;
            actionInstance = this.isRuntime ? new ActionInstance.RuntimeIfActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario()) : new ActionInstance.SequenceActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario());
            this.parentActionInstance.addChildAction(actionInstance);
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            try {
                this.expression.evaluateUnintActionHandles(solver);
                ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
                if (this.isRuntime) {
                    BigInteger nextRuntimeId = solver.getScenario().getNextRuntimeId(this.runtimeId);
                    ActionInstance.RuntimeBranchActionInstance trueBranchInstance = new ActionInstance.RuntimeBranchActionInstance("[sequence]", "true", nextRuntimeId, solver.getScenario());
                    actionInstance.addChildAction(trueBranchInstance);
                    nextRuntimeId = solver.getScenario().getNextRuntimeId(this.runtimeId);
                    ActionInstance.RuntimeBranchActionInstance falseBranchInstance = new ActionInstance.RuntimeBranchActionInstance("[sequence]", "false", nextRuntimeId, solver.getScenario());
                    actionInstance.addChildAction(falseBranchInstance);
                    modelWalker.addUninitActionHandles(this.ifBranchAST, trueBranchInstance);
                    modelWalker.addUninitActionHandles(this.elseBranchAST, falseBranchInstance);
                    modelWalker.addConstraintDescriptors(this.ifBranchAST, trueBranchInstance, false);
                    modelWalker.addConstraintDescriptors(this.elseBranchAST, falseBranchInstance, false);
                    modelWalker.addActivityDescriptors(this.ifBranchAST, trueBranchInstance, false);
                    modelWalker.addActivityDescriptors(this.elseBranchAST, falseBranchInstance, false);
                } else {
                    AST activityAST;
                    ActionInstance hierarchicalParentActionInstance = actionInstance.getParentActionInstance();
                    boolean isIfBranch = solver.evalIfElse(hierarchicalParentActionInstance, this.expression);
                    AST aST = activityAST = isIfBranch ? this.ifBranchAST : this.elseBranchAST;
                    if (activityAST == null) {
                        return;
                    }
                    modelWalker.addConstraintDescriptors(activityAST, actionInstance, false);
                    modelWalker.addActivityDescriptors(activityAST, actionInstance, false);
                }
            }
            catch (Solver.EvaluationException e) {
                solver.print(e.getErrorMessage(solver.getScenario(), -1, this.parserPath));
                throw new Solver.InterruptException();
            }
        }

        @Override
        public String getInstanceName() {
            if (this.isRuntime) {
                return this.label == null ? "if " + this.expression.toString(true) : this.label;
            }
            return this.label == null ? "[sequence]" : this.label;
        }
    }

    public static class IndexedDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private int currentIndex;
        private InstancesContainer currentIterator;
        private transient AST activityAST;
        private transient RfField.RfIndexField rfIndexField;
        private transient RfField.RfIteratorField rfIteratorField;

        public IndexedDescriptor(Solver solver, ActionInstance parentActionInstance, RfField.RfIndexField rfIndexField, int currentIndex, RfField.RfIteratorField rfIteratorField, InstancesContainer currentIterator, AST activityAST, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.activityAST = activityAST;
            this.rfIndexField = rfIndexField;
            this.rfIteratorField = rfIteratorField;
            this.currentIndex = currentIndex;
            this.currentIterator = currentIterator;
        }

        public IndexedDescriptor(Solver solver, ActionInstance parentActionInstance, RfField.RfIndexField rfIndexField, int currentIndex, AST activityAST, String label, int line, ParserPath parserPath) {
            this(solver, parentActionInstance, rfIndexField, currentIndex, null, null, activityAST, label, line, parserPath);
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.AbstractSchedulingInstance actionInstance = null;
            if (this.parentActionInstance instanceof ActionInstance.SequenceActionInstance) {
                actionInstance = new ActionInstance.SequenceActionInstance(this.label == null ? "[sequence]" : this.label, this.runtimeId, solver.getScenario());
            } else if (this.parentActionInstance instanceof ActionInstance.ParallelActionInstance) {
                actionInstance = new ActionInstance.ParallelActionInstance(this.label == null ? "[parallel]" : this.label, this.runtimeId, solver.getScenario());
            } else if (this.parentActionInstance instanceof ActionInstance.ScheduleActionInstance) {
                actionInstance = new ActionInstance.ScheduleActionInstance(this.label == null ? "[schedule]" : this.label, this.runtimeId, solver.getScenario());
            }
            if (actionInstance == null) {
                solver.print("*** Error: Internal error CAI_1");
                throw new Solver.InterruptException();
            }
            this.parentActionInstance.addChildAction(actionInstance);
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            IndexedDescriptor.writeAST(out, this.activityAST);
            IndexedDescriptor.writeRfElement(out, this.rfIndexField);
            IndexedDescriptor.writeRfElement(out, this.rfIteratorField);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = IndexedDescriptor.readAST(in);
            this.rfIndexField = (RfField.RfIndexField)IndexedDescriptor.readRfElement(in);
            this.rfIteratorField = (RfField.RfIteratorField)IndexedDescriptor.readRfElement(in);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            Scenario scenario = solver.getScenario();
            scenario.incrementRepeatId();
            actionInstance.putRepeatIndexValue(this.rfIndexField, this.currentIndex);
            actionInstance.putRepeatIteratorValue(this.rfIteratorField, this.currentIterator);
            ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
            modelWalker.addUninitActionHandles(this.activityAST, actionInstance);
            modelWalker.addActivityDescriptors(this.activityAST, actionInstance, false);
        }
    }

    public static class IndexedEndDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private transient RfField.RfIndexField rfIndexField;
        private transient RfField.RfIteratorField rfIteratorField;

        public IndexedEndDescriptor(RfField.RfIndexField rfIndexField, RfField.RfIteratorField rfIteratorField) {
            super(null, null, -1, null);
            this.rfIndexField = rfIndexField;
            this.rfIteratorField = rfIteratorField;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            Scenario scenario = solver.getScenario();
            scenario.popRepeatId();
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            IndexedEndDescriptor.writeRfElement(out, this.rfIndexField);
            IndexedEndDescriptor.writeRfElement(out, this.rfIteratorField);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.rfIndexField = (RfField.RfIndexField)IndexedEndDescriptor.readRfElement(in);
            this.rfIteratorField = (RfField.RfIteratorField)IndexedEndDescriptor.readRfElement(in);
        }
    }

    public static class ItemSelectTraversalDescriptor
    extends TraversalDescriptor {
        private static final long serialVersionUID = 1L;

        private ItemSelectTraversalDescriptor(ActionInstance parentActionInstance, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            if (actionInstance != null) {
                super.traverse(solver, actionInstance);
            }
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            if (this.itemSelectExpr == null) {
                return super.createActionInstance(solver);
            }
            this.itemSelectExpr.evaluateUnintActionHandles(solver);
            boolean isItemSelected = solver.evalIfElse(this.parentActionInstance, this.itemSelectExpr);
            if (isItemSelected) {
                return super.createActionInstance(solver);
            }
            return null;
        }
    }

    public static abstract class JoinSpecification
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public abstract String getName();

        public static class JoinBranchSpecification
        extends JoinSpecification {
            private static final long serialVersionUID = 1L;
            private Set<String> labels;

            public JoinBranchSpecification(Set<String> labels) {
                this.labels = labels;
            }

            @Override
            public String getName() {
                return "join_branch " + this.labels;
            }
        }

        public static class JoinFirstSpecification
        extends JoinSpecification {
            private static final long serialVersionUID = 1L;
            private Expression expression;

            public JoinFirstSpecification(Expression expression) {
                this.expression = expression;
            }

            @Override
            public String getName() {
                return "join_first " + this.expression.toString();
            }
        }

        public static class JoinNoneSpecification
        extends JoinSpecification {
            private static final long serialVersionUID = 1L;

            @Override
            public String getName() {
                return "join_none";
            }
        }

        public static class JoinSelectSpecification
        extends JoinSpecification {
            private static final long serialVersionUID = 1L;
            private Expression expression;

            public JoinSelectSpecification(Expression expression) {
                this.expression = expression;
            }

            @Override
            public String getName() {
                return "join_select " + this.expression.toString();
            }
        }
    }

    public static class MatchDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private List<MatchBranch> matchBranches = new ArrayList<MatchBranch>();
        private Expression expression;
        private boolean isRuntime;

        public MatchDescriptor(Solver solver, ActionInstance parentActionInstance, Expression expression, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.expression = expression;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        public void addBranch(Expression expression, AST activityAST) {
            this.matchBranches.add(new MatchBranch(expression, activityAST));
            this.isRuntime |= expression != null && expression.isRuntime();
        }

        public void addBranch(Expression expression, ActivityDescriptor activityDescriptor) {
            this.matchBranches.add(new MatchBranch(expression, activityDescriptor));
            this.isRuntime |= expression != null && expression.isRuntime();
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance actionInstance = this.parentActionInstance;
            if (this.isRuntime) {
                actionInstance = new ActionInstance.RuntimeMatchActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario());
                this.parentActionInstance.addChildAction(actionInstance);
                solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            }
            return actionInstance;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            try {
                if (this.matchBranches.isEmpty()) {
                    return;
                }
                ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
                if (this.isRuntime) {
                    for (MatchBranch matchBranch : this.matchBranches) {
                        if (matchBranch.expression != null) {
                            matchBranch.expression.evaluateUnintActionHandles(solver);
                        }
                        BigInteger newRuntimeId = solver.getScenario().getNextRuntimeId(this.runtimeId);
                        ActionInstance.RuntimeBranchActionInstance branchInstance = new ActionInstance.RuntimeBranchActionInstance("[sequence]", matchBranch.getMatchExpression(), newRuntimeId, solver.getScenario());
                        actionInstance.addChildAction(branchInstance);
                        modelWalker.addUninitActionHandles(matchBranch.activityAST, branchInstance);
                        modelWalker.addConstraintDescriptors(matchBranch.activityAST, branchInstance, true);
                        modelWalker.addActivityDescriptors(matchBranch.activityAST, branchInstance, true);
                    }
                } else {
                    boolean skipDefaultBranch = false;
                    ActionInstance hierarchicalParentActionInstance = actionInstance.getParentActionInstance();
                    ArrayList<MatchBranch> matchChoices = new ArrayList<MatchBranch>();
                    for (MatchBranch matchBranch : this.matchBranches) {
                        solver.checkInterrupted();
                        if (matchBranch.expression != null) {
                            matchBranch.expression.evaluateUnintActionHandles(solver);
                            if (!solver.evalIfElse(hierarchicalParentActionInstance, matchBranch.expression)) continue;
                        }
                        if (matchBranch.expression == null && skipDefaultBranch) continue;
                        skipDefaultBranch = true;
                        matchChoices.add(matchBranch);
                    }
                    if (matchChoices.isEmpty()) {
                        return;
                    }
                    if (matchChoices.size() == 1) {
                        if (((MatchBranch)matchChoices.get((int)0)).activityDescriptor != null) {
                            solver.pushActivityDescriptor(((MatchBranch)matchChoices.get((int)0)).activityDescriptor);
                        } else {
                            modelWalker.addConstraintDescriptors(((MatchBranch)matchChoices.get((int)0)).activityAST, actionInstance, true);
                            modelWalker.addActivityDescriptors(((MatchBranch)matchChoices.get((int)0)).activityAST, actionInstance, true);
                        }
                        return;
                    }
                    SelectDescriptor selectDescriptor = new SelectDescriptor(solver, actionInstance, this.label, this.line, this.parserPath);
                    for (MatchBranch matchBranch : matchChoices) {
                        if (matchBranch.activityDescriptor != null) {
                            selectDescriptor.addBranch(null, (Expression)new Expression.IntExpression("1", BigInteger.ONE, true, this.line, this.parserPath), matchBranch.activityDescriptor);
                            continue;
                        }
                        selectDescriptor.addBranch(null, (Expression)new Expression.IntExpression("1", BigInteger.ONE, true, this.line, this.parserPath), matchBranch.activityAST);
                    }
                    solver.pushActivityDescriptor(selectDescriptor);
                }
            }
            catch (Solver.EvaluationException e) {
                solver.print(e.getErrorMessage(solver.getScenario(), -1, this.parserPath));
                throw new Solver.InterruptException();
            }
        }

        @Override
        public String getInstanceName() {
            if (this.isRuntime) {
                return this.label == null ? "match " + this.expression.toString(true) : this.label;
            }
            return this.label == null ? "[sequence]" : this.label;
        }

        public static class MatchBranch
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private Expression expression;
            private ActivityDescriptor activityDescriptor;
            private transient AST activityAST;

            public MatchBranch(Expression expression, AST activityAST) {
                this.expression = expression;
                this.activityAST = activityAST;
            }

            public MatchBranch(Expression expression, ActivityDescriptor activityDescriptor) {
                this.expression = expression;
                this.activityDescriptor = activityDescriptor;
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.defaultWriteObject();
                MatchDescriptor.writeAST(out, this.activityAST);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                in.defaultReadObject();
                this.activityAST = MatchDescriptor.readAST(in);
            }

            public String getMatchExpression() {
                if (this.expression == null) {
                    return "default";
                }
                return ((Expression.InRange)this.expression).getRangeHrText();
            }
        }
    }

    public static class ParallelDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private JoinSpecification joinSpec;
        private transient AST activityAST;

        public ParallelDescriptor(Solver solver, ActionInstance parentActionInstance, AST activityAST, String label, JoinSpecification joinSpec, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.activityAST = activityAST;
            this.joinSpec = joinSpec;
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.ParallelActionInstance actionInstance = new ActionInstance.ParallelActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario());
            this.parentActionInstance.addChildAction(actionInstance);
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            ParallelDescriptor.writeAST(out, this.activityAST);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = ParallelDescriptor.readAST(in);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            block13: {
                JoinSpecification tempJoinSpec;
                Stack<ActivityDescriptor> activityDescriptors;
                block12: {
                    activityDescriptors = solver.getScenario().activityDescriptors;
                    int descriptorsSize = activityDescriptors.size();
                    ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
                    modelWalker.addUninitActionHandles(this.activityAST, actionInstance);
                    modelWalker.addConstraintDescriptors(this.activityAST, actionInstance, false);
                    modelWalker.addActivityDescriptors(this.activityAST, actionInstance, false);
                    if (this.joinSpec == null) {
                        return;
                    }
                    tempJoinSpec = this.joinSpec;
                    IdentityHashMap<ActivityDescriptor, String> descriptorLabelsMap = null;
                    if (tempJoinSpec instanceof JoinSpecification.JoinSelectSpecification) {
                        List<Expression.ExprAndDep<Expression.Value>> value = ((JoinSpecification.JoinSelectSpecification)tempJoinSpec).expression.evaluate(solver.getScenario(), actionInstance);
                        int nofActivities = activityDescriptors.size() - descriptorsSize;
                        int nofSelectActivities = ((Expression.Value)value.get((int)0).expr).getIntValue().intValueExact();
                        ArrayList descriptors = new ArrayList(nofActivities);
                        ListIterator<ActivityDescriptor> iterator = activityDescriptors.listIterator(descriptorsSize);
                        while (iterator.hasNext()) {
                            ActivityDescriptor descriptor = iterator.next();
                            descriptors.add(descriptor);
                        }
                        descriptorLabelsMap = new IdentityHashMap<ActivityDescriptor, String>();
                        int i = 0;
                        while (i < nofSelectActivities) {
                            int index = solver.pickIndex(nofActivities - i);
                            descriptorLabelsMap.put((ActivityDescriptor)descriptors.remove(index), Integer.toString(index));
                            ++i;
                        }
                        tempJoinSpec = new JoinSpecification.JoinBranchSpecification(new HashSet<String>(descriptorLabelsMap.values()));
                    }
                    if (!(tempJoinSpec instanceof JoinSpecification.JoinBranchSpecification)) break block12;
                    ActionInstance.SequenceActionInstance sequenceJoinBranch = new ActionInstance.SequenceActionInstance("[sequence]", actionInstance.runtimeId, actionInstance.scenario);
                    actionInstance.addChildAction(sequenceJoinBranch);
                    ActionInstance.ParallelActionInstance parallelJoinBranch = new ActionInstance.ParallelActionInstance("[parallel]", actionInstance.runtimeId, actionInstance.scenario);
                    sequenceJoinBranch.addChildAction(parallelJoinBranch);
                    for (ActivityDescriptor descriptor : activityDescriptors) {
                        String descriptorLabel;
                        String string = descriptorLabel = descriptorLabelsMap == null ? descriptor.label : (String)descriptorLabelsMap.get(descriptor);
                        if (descriptorLabel == null || !((JoinSpecification.JoinBranchSpecification)tempJoinSpec).labels.contains(descriptorLabel)) continue;
                        descriptor.parentActionInstance = parallelJoinBranch;
                    }
                    if (actionInstance.parentActionInstance instanceof ActionInstance.ParallelActionInstance) {
                        List<ActionInstance> childrenActionInstances = actionInstance.parentActionInstance.childrenActionInstances;
                        int i = childrenActionInstances.size() - 1;
                        while (i >= 0) {
                            if (childrenActionInstances.get(i) != actionInstance) {
                                ActionInstance childActionInstance = childrenActionInstances.remove(i);
                                childActionInstance.parentActionInstance = parallelJoinBranch;
                                if (parallelJoinBranch.childrenActionInstances == null) {
                                    parallelJoinBranch.childrenActionInstances = new ArrayList();
                                }
                                parallelJoinBranch.childrenActionInstances.add(childActionInstance);
                            }
                            --i;
                        }
                    }
                    ArrayList<ActionInstance> enclosingSequenceActionInstances = new ArrayList<ActionInstance>();
                    enclosingSequenceActionInstances.add(sequenceJoinBranch);
                    this.collectEnclosingSequenceActions(enclosingSequenceActionInstances, actionInstance);
                    for (ActivityDescriptor descriptor : activityDescriptors) {
                        if (descriptor instanceof RemoveEmptyBlockDescriptor || descriptor instanceof TraversalEndDescriptor) continue;
                        if (descriptor.parentActionInstance instanceof ActionInstance.SequenceActionInstance) {
                            int index = enclosingSequenceActionInstances.indexOf(descriptor.parentActionInstance) - 1;
                            descriptor.parentActionInstance = (ActionInstance)enclosingSequenceActionInstances.get(index);
                        }
                        if (!(descriptor.parentActionInstance instanceof ActionInstance.ParallelActionInstance) || descriptor.parentActionInstance != actionInstance.parentActionInstance) continue;
                        descriptor.parentActionInstance = parallelJoinBranch;
                    }
                    break block13;
                }
                if (!(tempJoinSpec instanceof JoinSpecification.JoinFirstSpecification) && !(tempJoinSpec instanceof JoinSpecification.JoinNoneSpecification) || !(actionInstance.parentActionInstance instanceof ActionInstance.SequenceActionInstance)) break block13;
                String instanceName = Utils.append("if (", tempJoinSpec.getName(), ")");
                ActionInstance.RuntimeIfActionInstance joinActionInstance = new ActionInstance.RuntimeIfActionInstance(instanceName, this.runtimeId, solver.getScenario());
                actionInstance.addChildAction(joinActionInstance);
                ActionInstance.SequenceActionInstance joinActionsContainer = new ActionInstance.SequenceActionInstance("[sequence]", actionInstance.runtimeId, actionInstance.scenario);
                joinActionInstance.addChildAction(joinActionsContainer);
                ListIterator<ActivityDescriptor> iterator = activityDescriptors.listIterator(activityDescriptors.size());
                while (iterator.hasPrevious()) {
                    ActivityDescriptor descriptor = iterator.previous();
                    if (descriptor instanceof RemoveEmptyBlockDescriptor || descriptor instanceof TraversalEndDescriptor || descriptor.parentActionInstance != actionInstance.parentActionInstance) continue;
                    descriptor.parentActionInstance = joinActionsContainer;
                }
            }
        }

        private void collectEnclosingSequenceActions(List<ActionInstance> result, ActionInstance actionInstance) {
            ActionInstance parentActionInstance = actionInstance;
            while ((parentActionInstance = parentActionInstance.parentActionInstance) != null) {
                if (!(parentActionInstance instanceof ActionInstance.SequenceActionInstance)) continue;
                result.add(parentActionInstance);
            }
        }

        @Override
        public String getInstanceName() {
            return this.label == null ? "[parallel]" : this.label;
        }
    }

    public static interface PostRunnable
    extends Serializable {
        public void run(Solver var1);
    }

    public static class RemoveEmptyBlockDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;

        public RemoveEmptyBlockDescriptor(Solver solver, ActionInstance parentActionInstance, int line, ParserPath parserPath) {
            super(parentActionInstance, null, line, parserPath);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            solver.getScenario().free((ISchedulingInstance)((Object)actionInstance));
            if (!(this.parentActionInstance instanceof ISchedulingInstance)) {
                return;
            }
            if (this.parentActionInstance.parentActionInstance == null) {
                return;
            }
            if (this.parentActionInstance.childrenActionInstances == null || this.parentActionInstance.childrenActionInstances.isEmpty()) {
                this.parentActionInstance.parentActionInstance.childrenActionInstances.remove(this.parentActionInstance);
            }
        }
    }

    public static class RepeatDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private Expression expression;
        private String subBlockLabel;
        private transient AST activityAST;
        private transient RfField.RfIndexField rfIndexField;

        public RepeatDescriptor(Solver solver, ActionInstance parentActionInstance, Expression expression, RfField.RfIndexField rfIndexField, AST activityAST, String label, String subBlockLabel, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.activityAST = activityAST;
            this.expression = expression;
            this.rfIndexField = rfIndexField;
            this.subBlockLabel = subBlockLabel;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            RepeatDescriptor.writeAST(out, this.activityAST);
            RepeatDescriptor.writeRfElement(out, this.rfIndexField);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = RepeatDescriptor.readAST(in);
            this.rfIndexField = (RfField.RfIndexField)RepeatDescriptor.readRfElement(in);
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.SequenceActionInstance actionInstance = new ActionInstance.SequenceActionInstance("[sequence]", this.runtimeId, solver.getScenario());
            this.parentActionInstance.addChildAction(actionInstance);
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            List<ActivityDescriptor> activityDescriptors = this.generateDescriptors(solver, actionInstance);
            for (ActivityDescriptor activityDescriptor : activityDescriptors) {
                solver.pushActivityDescriptor(activityDescriptor);
            }
        }

        public List<ActivityDescriptor> generateDescriptors(Solver solver, ActionInstance actionInstance) {
            ArrayList<ActivityDescriptor> descriptors = new ArrayList<ActivityDescriptor>();
            ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
            modelWalker.addConstraintDescriptors(this.activityAST, actionInstance, false);
            ActionInstance hierarchicalParentActionInstance = actionInstance.getParentActionInstance();
            int nofRepeats = solver.evalRepeat(hierarchicalParentActionInstance, this.expression);
            solver.getScenario().pushRepeatId();
            ActivityDescriptor activityDescriptor = new IndexedEndDescriptor(this.rfIndexField, null);
            activityDescriptor.parentActionInstance = actionInstance;
            solver.pushActivityDescriptor(activityDescriptor);
            int i = 0;
            while (i < nofRepeats) {
                solver.checkInterrupted();
                int index = nofRepeats - 1 - i;
                activityDescriptor = new IndexedDescriptor(solver, actionInstance, this.rfIndexField, index, this.activityAST, this.subBlockLabel == null ? null : Utils.append(this.subBlockLabel, "[", index, "]"), this.line, this.parserPath);
                activityDescriptor.parentActionInstance = actionInstance;
                descriptors.add(activityDescriptor);
                ++i;
            }
            return descriptors;
        }
    }

    public static class ReplicateDescriptor
    extends RepeatDescriptor {
        private static final long serialVersionUID = 1L;

        public ReplicateDescriptor(Solver solver, ActionInstance parentActionInstance, Expression expression, RfField.RfIndexField rfIndexField, AST activityAST, String label, String subBlockLabel, int line, ParserPath parserPath) {
            super(solver, parentActionInstance, expression, rfIndexField, activityAST, label, subBlockLabel, line, parserPath);
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            return this.parentActionInstance;
        }
    }

    public static class ScheduleDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private JoinSpecification joinSpec;
        private transient AST activityAST;

        public ScheduleDescriptor(Solver solver, ActionInstance parentActionInstance, AST activityAST, String label, JoinSpecification joinSpec, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.activityAST = activityAST;
            this.joinSpec = joinSpec;
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.ScheduleActionInstance actionInstance = new ActionInstance.ScheduleActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario());
            this.parentActionInstance.addChildAction(actionInstance);
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            ScheduleDescriptor.writeAST(out, this.activityAST);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = ScheduleDescriptor.readAST(in);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            block13: {
                JoinSpecification tempJoinSpec;
                Stack<ActivityDescriptor> activityDescriptors;
                block12: {
                    activityDescriptors = solver.getScenario().activityDescriptors;
                    int descriptorsSize = activityDescriptors.size();
                    ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
                    modelWalker.addUninitActionHandles(this.activityAST, actionInstance);
                    modelWalker.addConstraintDescriptors(this.activityAST, actionInstance, false);
                    modelWalker.addActivityDescriptors(this.activityAST, actionInstance, false);
                    if (this.joinSpec == null) {
                        return;
                    }
                    tempJoinSpec = this.joinSpec;
                    IdentityHashMap<ActivityDescriptor, String> descriptorLabelsMap = null;
                    if (tempJoinSpec instanceof JoinSpecification.JoinSelectSpecification) {
                        List<Expression.ExprAndDep<Expression.Value>> value = ((JoinSpecification.JoinSelectSpecification)tempJoinSpec).expression.evaluate(solver.getScenario(), actionInstance);
                        int nofActivities = activityDescriptors.size() - descriptorsSize;
                        int nofSelectActivities = ((Expression.Value)value.get((int)0).expr).getIntValue().intValueExact();
                        ArrayList descriptors = new ArrayList(nofActivities);
                        ListIterator<ActivityDescriptor> iterator = activityDescriptors.listIterator(descriptorsSize);
                        while (iterator.hasNext()) {
                            ActivityDescriptor descriptor = iterator.next();
                            descriptors.add(descriptor);
                        }
                        descriptorLabelsMap = new IdentityHashMap<ActivityDescriptor, String>();
                        int i = 0;
                        while (i < nofSelectActivities) {
                            int index = solver.pickIndex(nofActivities - i);
                            descriptorLabelsMap.put((ActivityDescriptor)descriptors.remove(index), Integer.toString(index));
                            ++i;
                        }
                        tempJoinSpec = new JoinSpecification.JoinBranchSpecification(new HashSet<String>(descriptorLabelsMap.values()));
                    }
                    if (!(tempJoinSpec instanceof JoinSpecification.JoinBranchSpecification)) break block12;
                    ActionInstance.SequenceActionInstance sequenceJoinBranch = new ActionInstance.SequenceActionInstance("[sequence]", actionInstance.runtimeId, actionInstance.scenario);
                    actionInstance.addChildAction(sequenceJoinBranch);
                    ActionInstance.ScheduleActionInstance scheduleJoinBranch = new ActionInstance.ScheduleActionInstance("[schedule]", actionInstance.runtimeId, actionInstance.scenario);
                    sequenceJoinBranch.addChildAction(scheduleJoinBranch);
                    for (ActivityDescriptor descriptor : activityDescriptors) {
                        String descriptorLabel;
                        String string = descriptorLabel = descriptorLabelsMap == null ? descriptor.label : (String)descriptorLabelsMap.get(descriptor);
                        if (descriptorLabel == null || !((JoinSpecification.JoinBranchSpecification)tempJoinSpec).labels.contains(descriptorLabel)) continue;
                        descriptor.parentActionInstance = scheduleJoinBranch;
                    }
                    if (actionInstance.parentActionInstance instanceof ActionInstance.ScheduleActionInstance) {
                        List<ActionInstance> childrenActionInstances = actionInstance.parentActionInstance.childrenActionInstances;
                        int i = childrenActionInstances.size() - 1;
                        while (i >= 0) {
                            if (childrenActionInstances.get(i) != actionInstance) {
                                ActionInstance childActionInstance = childrenActionInstances.remove(i);
                                childActionInstance.parentActionInstance = scheduleJoinBranch;
                                if (scheduleJoinBranch.childrenActionInstances == null) {
                                    scheduleJoinBranch.childrenActionInstances = new ArrayList();
                                }
                                scheduleJoinBranch.childrenActionInstances.add(childActionInstance);
                            }
                            --i;
                        }
                    }
                    ArrayList<ActionInstance> enclosingSequenceActionInstances = new ArrayList<ActionInstance>();
                    enclosingSequenceActionInstances.add(sequenceJoinBranch);
                    this.collectEnclosingSequenceActions(enclosingSequenceActionInstances, actionInstance);
                    for (ActivityDescriptor descriptor : activityDescriptors) {
                        if (descriptor instanceof RemoveEmptyBlockDescriptor || descriptor instanceof TraversalEndDescriptor) continue;
                        if (descriptor.parentActionInstance instanceof ActionInstance.SequenceActionInstance) {
                            int index = enclosingSequenceActionInstances.indexOf(descriptor.parentActionInstance) - 1;
                            descriptor.parentActionInstance = (ActionInstance)enclosingSequenceActionInstances.get(index);
                        }
                        if (!(descriptor.parentActionInstance instanceof ActionInstance.ScheduleActionInstance) || descriptor.parentActionInstance != actionInstance.parentActionInstance) continue;
                        descriptor.parentActionInstance = scheduleJoinBranch;
                    }
                    break block13;
                }
                if (!(tempJoinSpec instanceof JoinSpecification.JoinFirstSpecification) && !(tempJoinSpec instanceof JoinSpecification.JoinNoneSpecification) || !(actionInstance.parentActionInstance instanceof ActionInstance.SequenceActionInstance)) break block13;
                ActionInstance.SequenceActionInstance joinActionsContainer = new ActionInstance.SequenceActionInstance("[sequence]", actionInstance.runtimeId, actionInstance.scenario);
                actionInstance.addChildAction(joinActionsContainer);
                ListIterator<ActivityDescriptor> iterator = activityDescriptors.listIterator(activityDescriptors.size());
                while (iterator.hasPrevious()) {
                    ActivityDescriptor descriptor = iterator.previous();
                    if (descriptor instanceof RemoveEmptyBlockDescriptor || descriptor instanceof TraversalEndDescriptor || descriptor.parentActionInstance != actionInstance.parentActionInstance) continue;
                    descriptor.parentActionInstance = joinActionsContainer;
                }
            }
        }

        private void collectEnclosingSequenceActions(List<ActionInstance> result, ActionInstance actionInstance) {
            ActionInstance parentActionInstance = actionInstance;
            while ((parentActionInstance = parentActionInstance.parentActionInstance) != null) {
                if (!(parentActionInstance instanceof ActionInstance.SequenceActionInstance)) continue;
                result.add(parentActionInstance);
            }
        }

        @Override
        public String getInstanceName() {
            return this.label == null ? "[schedule]" : this.label;
        }
    }

    @Deprecated
    public static class SchedulingRunnable
    implements PostRunnable {
        private static final long serialVersionUID = 1L;
        private Set<String> ignoreLabels;
        private ActionInstance beforeActionInstance;
        private ActionInstance afterActionInstance;

        public SchedulingRunnable(ActionInstance beforeActionInstance, ActionInstance afterActionInstance, Set<String> ignoreLabels) {
            this.beforeActionInstance = beforeActionInstance;
            this.afterActionInstance = afterActionInstance;
            this.ignoreLabels = ignoreLabels;
        }

        @Override
        public void run(Solver solver) {
            Set<ActionInstance> afterInstances = SchedulingRunnable.getChildren(this.afterActionInstance, Collections.emptySet(), this.ignoreLabels);
            if (afterInstances.isEmpty()) {
                return;
            }
            Set<ActionInstance> beforeInstances = SchedulingRunnable.getChildren(this.beforeActionInstance, afterInstances, this.ignoreLabels);
            if (beforeInstances.isEmpty()) {
                return;
            }
            Scenario scenario = solver.getScenario();
            for (ActionInstance afterInstance : afterInstances) {
                for (ActionInstance beforeInstance : beforeInstances) {
                    scenario.scheduleBefore(beforeInstance, afterInstance);
                }
            }
        }

        private static final Set<ActionInstance> getChildren(ActionInstance actionInstance, final Set<ActionInstance> ignoreInstances, final Set<String> ignoreLabels) {
            final LinkedHashSet<ActionInstance> childrenInstances = new LinkedHashSet<ActionInstance>();
            InstanceVisitor<ActionInstance> visitor = new InstanceVisitor<ActionInstance>(){
                private int ignoreChildren;

                @Override
                public boolean visit(ActionInstance candidate) {
                    if (candidate instanceof ISchedulingInstance) {
                        return true;
                    }
                    if (ignoreLabels.contains(candidate.getName())) {
                        ++this.ignoreChildren;
                        return true;
                    }
                    if (this.ignoreChildren > 0) {
                        return true;
                    }
                    if (ignoreInstances.contains(candidate)) {
                        return true;
                    }
                    childrenInstances.add(candidate);
                    return true;
                }

                @Override
                public void postVisit(ActionInstance instance) {
                    InstanceVisitor.super.postVisit(instance);
                    if (ignoreLabels.contains(instance.getName())) {
                        --this.ignoreChildren;
                    }
                }
            };
            actionInstance.accept(visitor);
            return childrenInstances;
        }
    }

    public static class SelectDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private List<SelectBranch> selectBranches = new ArrayList<SelectBranch>();
        private transient AST activityAST;

        public SelectDescriptor(Solver solver, ActionInstance parentActionInstance, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            SelectDescriptor.writeAST(out, this.activityAST);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = SelectDescriptor.readAST(in);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            try {
                if (this.selectBranches.isEmpty()) {
                    return;
                }
                ArrayList<SelectBranch> filteredSelectBranches = new ArrayList<SelectBranch>();
                int totalWeight = 0;
                ActionInstance hierarchicalParentActionInstance = actionInstance.getParentActionInstance();
                for (SelectBranch selectBranch : this.selectBranches) {
                    solver.checkInterrupted();
                    selectBranch.weightValue = 1;
                    if (selectBranch.weight != null) {
                        try {
                            selectBranch.weight.evaluateUnintActionHandles(solver);
                            List value = Expression.filterVacuous(selectBranch.weight.evaluate(solver.getScenario(), actionInstance));
                            if (value == null || value.size() != 1 || !Expression.Value.isInteger((Expression.Value)value.get((int)0).expr)) {
                                throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", selectBranch.weight.toString(false), "' expression", this.line, this.parserPath));
                            }
                            selectBranch.weightValue = ((Expression.Value)value.get((int)0).expr).getIntValue().intValueExact();
                        }
                        catch (Exception exception) {
                            solver.logError("*** Error: Cannot evaluate weight expression");
                            throw new Solver.SolverException();
                        }
                    }
                    if (selectBranch.expression != null) {
                        selectBranch.expression.evaluateUnintActionHandles(solver);
                        if (!solver.evalIfElse(hierarchicalParentActionInstance, selectBranch.expression)) continue;
                    }
                    totalWeight += selectBranch.weightValue * 100;
                    filteredSelectBranches.add(selectBranch);
                }
                int selectedIndex = solver.pickIndex(totalWeight);
                int indexRange = 0;
                ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
                for (SelectBranch selectBranch : filteredSelectBranches) {
                    solver.checkInterrupted();
                    if (selectedIndex >= (indexRange += selectBranch.weightValue * 100)) continue;
                    if (selectBranch.activityDescriptor != null) {
                        solver.pushActivityDescriptor(selectBranch.activityDescriptor);
                    } else {
                        modelWalker.addConstraintDescriptors(selectBranch.activityAST, actionInstance, true);
                        modelWalker.addActivityDescriptors(selectBranch.activityAST, actionInstance, true);
                    }
                    break;
                }
            }
            catch (Solver.EvaluationException e) {
                solver.print(e.getErrorMessage(solver.getScenario(), -1, this.parserPath));
                throw new Solver.InterruptException();
            }
        }

        public void addBranch(Expression expression, Expression weight, AST activityAST) {
            this.selectBranches.add(new SelectBranch(weight, expression, activityAST));
        }

        public void addBranch(Expression expression, Expression weight, ActivityDescriptor activityDescriptor) {
            this.selectBranches.add(new SelectBranch(weight, expression, activityDescriptor));
        }

        public static class SelectBranch
        implements Serializable {
            private static final long serialVersionUID = 1L;
            protected Expression weight;
            protected Expression expression;
            protected ActivityDescriptor activityDescriptor;
            protected transient AST activityAST;
            protected transient int weightValue;

            public SelectBranch(Expression weight, Expression expression, AST activityAST) {
                this.weight = weight;
                this.expression = expression;
                this.activityAST = activityAST;
            }

            public SelectBranch(Expression weight, Expression expression, ActivityDescriptor activityDescriptor) {
                this.weight = weight;
                this.expression = expression;
                this.activityDescriptor = activityDescriptor;
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.defaultWriteObject();
                SelectDescriptor.writeAST(out, this.activityAST);
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                in.defaultReadObject();
                this.activityAST = SelectDescriptor.readAST(in);
            }
        }
    }

    public static class SequenceDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private transient AST activityAST;

        public SequenceDescriptor(Solver solver, ActionInstance parentActionInstance, AST activityAST, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.activityAST = activityAST;
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.SequenceActionInstance actionInstance = new ActionInstance.SequenceActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario());
            this.parentActionInstance.addChildAction(actionInstance);
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            SequenceDescriptor.writeAST(out, this.activityAST);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = SequenceDescriptor.readAST(in);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
            modelWalker.addUninitActionHandles(this.activityAST, actionInstance);
            modelWalker.addConstraintDescriptors(this.activityAST, actionInstance, false);
            modelWalker.addActivityDescriptors(this.activityAST, actionInstance, false);
        }

        @Override
        public String getInstanceName() {
            return this.label == null ? "[sequence]" : this.label;
        }
    }

    public static class SymbolDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private List<Expression> arguments;
        private transient RfMethod rfSymbol;

        public SymbolDescriptor(Solver solver, ActionInstance parentActionInstance, RfMethod rfSymbol, List<Expression> arguments, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.rfSymbol = rfSymbol;
            this.arguments = arguments;
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            SymbolDescriptor.writeRfElement(out, this.rfSymbol);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.rfSymbol = (RfMethod)SymbolDescriptor.readRfElement(in);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            MethodCallContext symbolCallInstance = MethodCallContext.createSymbolContext(solver, actionInstance, this.rfSymbol, this.arguments);
            solver.getScenario().pushSymbolCallContext(symbolCallInstance);
            solver.getScenario().pushActivityDescriptor(new SymbolEndDescriptor());
            ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
            RfDefElement declaration = this.rfSymbol.getDeclaration();
            AST activityAST = declaration.getNodeAST();
            modelWalker.addConstraintDescriptors(activityAST, actionInstance, false);
            modelWalker.addActivityDescriptors(activityAST, actionInstance, false);
        }
    }

    private static class SymbolEndDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;

        public SymbolEndDescriptor() {
            super(null, null, -1, null);
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            solver.getScenario().popSymbolCallContext();
        }
    }

    public static class TraversalDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        protected Expression itemSelectExpr;
        private transient RfField rfActionHandle;
        private transient AST constraintsAST;

        public TraversalDescriptor(Solver solver, ActionInstance parentActionInstance, RfField rfActionHandle, Expression itemSelectExpr, AST constraintsAST, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.constraintsAST = constraintsAST;
            this.rfActionHandle = rfActionHandle;
            this.itemSelectExpr = itemSelectExpr;
            this.options = this.getParentComponentInstanceOptions(solver, rfActionHandle, parentActionInstance);
        }

        public TraversalDescriptor(Solver solver, ActionInstance parentActionInstance, RfField rfActionHandle, ComponentInstance parentComponentInstance, int line, ParserPath parserPath) {
            super(parentActionInstance, null, line, parserPath);
            this.rfActionHandle = rfActionHandle;
            this.options = new ArrayList();
            this.options.add(parentComponentInstance.instanceIndex);
        }

        private TraversalDescriptor(ActionInstance parentActionInstance, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
        }

        public TraversalDescriptor(TraversalDescriptor traversalDescriptor) {
            super(traversalDescriptor.parentActionInstance, traversalDescriptor.label, traversalDescriptor.line, traversalDescriptor.parserPath);
            this.rfActionHandle = traversalDescriptor.rfActionHandle;
            this.constraintsAST = traversalDescriptor.constraintsAST;
            this.options = new ArrayList(traversalDescriptor.options);
        }

        public RfField getRfActionHandle() {
            return this.rfActionHandle;
        }

        public void setItemSelectExpr(Expression itemSelectExpr) {
            this.itemSelectExpr = itemSelectExpr;
        }

        @Override
        protected final void pushActivityDescriptor(Scenario scenario) {
            int arraySize = this.rfActionHandle.getAssociatedTypeArrayDimAsInteger();
            if (arraySize <= 0) {
                scenario.pushActivityDescriptor(this);
                return;
            }
            int i = 0;
            while (i < arraySize) {
                ItemSelectTraversalDescriptor activityDescriptor = new ItemSelectTraversalDescriptor(this.parentActionInstance, this.label, this.line, this.parserPath);
                String rfHandleName = Utils.append(ScenarioUtils.getDeduplicateName(this.rfActionHandle), "[", i, "]");
                activityDescriptor.itemSelectExpr = this.itemSelectExpr == null ? null : new Expression.Logic(Expression.Logic.Operator.EQ, this.itemSelectExpr, new Expression.IntExpression(Integer.toString(i), BigInteger.valueOf(i), true, this.line, this.parserPath), this.line, this.parserPath);
                activityDescriptor.rfActionHandle = new RfField(rfHandleName, null);
                activityDescriptor.rfActionHandle.setAssociatedType(this.rfActionHandle.getAssociatedBaseType());
                activityDescriptor.rfActionHandle.setEnclosingScope(this.rfActionHandle.getEnclosingScope());
                activityDescriptor.constraintsAST = this.constraintsAST;
                activityDescriptor.options = new ArrayList(this.options);
                activityDescriptor.parentActionInstance = this.parentActionInstance;
                scenario.pushActivityDescriptor(activityDescriptor);
                ++i;
            }
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            solver.addTraversedActionHandle(this.rfActionHandle, actionInstance, this.line, this.parserPath);
            solver.pushTraversedActionHandles(Collections.newSetFromMap(new IdentityHashMap()));
            solver.pushActivityDescriptor(new TraversalEndDescriptor(actionInstance));
            solver.traverseFirstLevel(actionInstance);
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            Scenario scenario = solver.getScenario();
            RfNamedElement associatedType = Utils.getAssociatedType(this.rfActionHandle);
            int arraySize = this.rfActionHandle.getAssociatedTypeArrayDimAsInteger();
            if (arraySize > 1) {
                solver.logError(Utils.append("*** Error: Array of actions '", this.parentActionInstance.getHierarchicalPath(), ".", this.rfActionHandle.getElabName(), "' is not supported"));
            }
            RfStruct rfAction = Solver.getBaseStructType(associatedType);
            String instanceName = this.label;
            int instanceIndex = scenario.actionInstances.size();
            boolean inferred = this.parentActionInstance.isInferred();
            if (instanceName == null) {
                instanceName = inferred ? "[inferred]" : "[anonymous]";
            }
            instanceName = solver.getActionInstanceName(instanceName, instanceIndex, rfAction);
            ComponentInstance parentComponentInstance = null;
            int index = solver.pickIndex(this.options.size());
            int parentComponentInstanceIndex = (Integer)this.options.remove(index);
            parentComponentInstance = solver.getScenario().getComponentInstance(parentComponentInstanceIndex);
            ActionInstance actionInstance = new ActionInstance(instanceName, instanceIndex, this.runtimeId, this.rfActionHandle, rfAction, parentComponentInstance, scenario);
            actionInstance.parentActionInstance = this.parentActionInstance;
            actionInstance.arraySize = scenario.peekRepeatId();
            actionInstance.setInferred(inferred);
            solver.printDebug1(Utils.append("*** Info: Parent component instance for '", actionInstance, "' is '", parentComponentInstance, "'"));
            parentComponentInstance.addChildActionInstance(actionInstance);
            ActionInstance parentActionInstance2 = actionInstance;
            while ((parentActionInstance2 = parentActionInstance2.getParentActionInstance()) != null) {
                if (parentActionInstance2.getRfAction() != actionInstance.getRfAction()) continue;
                solver.logError(Utils.append("*** Error: Infinite recursion in activity block for action '", actionInstance, "'"));
                throw new Solver.SolverException();
            }
            ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
            modelWalker.addInlineConstraintDescriptors(this.constraintsAST, actionInstance);
            scenario.addActionInstance(actionInstance);
            this.parentActionInstance.addChildAction(actionInstance);
            actionInstance.setTraversalIndex(scenario.actionInstanceTraversalIndex + 1);
            actionInstance.preSolve();
            boolean solutionFound = actionInstance.solve();
            if (!solutionFound) {
                throw new Solver.SolverException();
            }
            actionInstance.setTraversalIndex(0);
            return actionInstance;
        }

        private List<Integer> getParentComponentInstanceOptions(Solver solver, RfField rfActionHandle, ActionInstance parentActionInstance) {
            ComponentInstance parentCompoundComponentInstance;
            ArrayList<Integer> parentComponentIndexes = new ArrayList<Integer>();
            RfStruct rfAction = Solver.getBaseStructType(Utils.getAssociatedType(rfActionHandle));
            RfStruct rfComponent = rfAction.getEnclosingComponent();
            ActionInstance parentCompoundActionInstance = parentActionInstance instanceof ISchedulingInstance ? parentActionInstance.getParentActionInstance() : parentActionInstance;
            ComponentInstance componentInstance = parentCompoundComponentInstance = parentCompoundActionInstance == null ? null : parentCompoundActionInstance.getParentComponentInstance();
            if (parentCompoundComponentInstance != null && parentCompoundComponentInstance.getRfComponent() == rfComponent) {
                parentComponentIndexes.add(parentCompoundComponentInstance.instanceIndex);
            } else {
                this.collectComponentIndexes(solver, parentComponentIndexes, rfComponent);
                if (parentComponentIndexes.isEmpty()) {
                    solver.logError(Utils.append("*** Error: No instance of '", rfComponent.getElabName(), "' component (cannot traverse action ", rfAction.getElabName(), ")"));
                    throw new Solver.SolverException();
                }
            }
            return parentComponentIndexes;
        }

        private void collectComponentIndexes(Solver solver, List<Integer> componentIndexes, RfStruct rfComponent) {
            InstanceVisitor<ComponentInstance> visitor = instance -> {
                solver.checkInterrupted();
                RfStruct rfCandidate = instance.getRfComponent();
                if (rfComponent == rfCandidate) {
                    componentIndexes.add(instance.instanceIndex);
                } else if (rfCandidate instanceof RfTemplateInstance && rfComponent == ((RfTemplateInstance)rfCandidate).getTemplateStruct()) {
                    componentIndexes.add(instance.instanceIndex);
                } else if (rfCandidate.isLike(rfComponent)) {
                    componentIndexes.add(instance.instanceIndex);
                }
                return true;
            };
            solver.getScenario().rootComponent.accept(visitor);
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            TraversalDescriptor.writeRfElement(out, this.rfActionHandle);
            TraversalDescriptor.writeAST(out, this.constraintsAST);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.rfActionHandle = (RfField)TraversalDescriptor.readRfElement(in);
            this.constraintsAST = TraversalDescriptor.readAST(in);
        }
    }

    public static class TraversalEndDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private ActionInstance actionInstance;

        public TraversalEndDescriptor(ActionInstance actionInstance) {
            super(null, null, -1, null);
            this.actionInstance = actionInstance;
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            return this.actionInstance;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            solver.getScenario().popTraversedActionHandles();
            List<PortInstance> portInstances = actionInstance.getPortInstances();
            if (portInstances != null && !portInstances.isEmpty()) {
                for (PortInstance portInstance : portInstances) {
                    if (portInstance.isState()) continue;
                    solver.pushActivityDescriptor(new ConnectHierarchicalAndPool(portInstance));
                    if (portInstance.isLockOrShare() || !portInstance.requiresBind(this.runtimeId)) continue;
                    solver.push0ActivityDescriptor(new ConnectPortToExisting(portInstance));
                }
                for (PortInstance portInstance : portInstances) {
                    if (!portInstance.isState()) continue;
                    solver.pushActivityDescriptor(new ConnectHierarchicalAndPool(portInstance));
                    if (!portInstance.requiresBind(this.runtimeId)) continue;
                    solver.push0ActivityDescriptor(new ConnectPortToExisting(portInstance));
                }
            }
            if (actionInstance.instanceIndex == 0) {
                ArrayList<Pool> poolCandidates = new ArrayList<Pool>();
                solver.collectStateObjectPools(poolCandidates);
                for (Pool poolCandidate : poolCandidates) {
                    solver.pushActivityDescriptor(new ConnectPortToExisting(poolCandidate.getInitialStateObject()));
                }
            }
            actionInstance.postActivity();
        }
    }

    public static class WhileDescriptor
    extends ActivityDescriptor {
        private static final long serialVersionUID = 1L;
        private Expression expression;
        private boolean isRepeatWhile;
        private int nofRepeats;
        private boolean isRuntime;
        private transient AST activityAST;

        public WhileDescriptor(Solver solver, ActionInstance parentActionInstance, boolean isRepeatWhile, Expression expression, AST activityAST, String label, int line, ParserPath parserPath) {
            super(parentActionInstance, label, line, parserPath);
            this.activityAST = activityAST;
            this.expression = expression;
            this.isRepeatWhile = isRepeatWhile;
            this.isRuntime = expression.isRuntime();
        }

        @Override
        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            WhileDescriptor.writeAST(out, this.activityAST);
        }

        @Override
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.activityAST = WhileDescriptor.readAST(in);
        }

        @Override
        protected ActionInstance createActionInstance(Solver solver) {
            ActionInstance.SequenceActionInstance actionInstance = null;
            if (this.isRuntime && this.nofRepeats == 0) {
                ActionInstance.RuntimeWhileActionInstance runtimeActionInstance = new ActionInstance.RuntimeWhileActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario());
                this.parentActionInstance.addChildAction(runtimeActionInstance);
                BigInteger newRuntimeId = solver.getScenario().getNextRuntimeId(this.runtimeId);
                actionInstance = new ActionInstance.SequenceActionInstance("[sequence]", newRuntimeId, solver.getScenario());
                runtimeActionInstance.addChildAction(actionInstance);
            } else {
                actionInstance = new ActionInstance.SequenceActionInstance(this.getInstanceName(), this.runtimeId, solver.getScenario());
                this.parentActionInstance.addChildAction(actionInstance);
            }
            solver.pushActivityDescriptor(new RemoveEmptyBlockDescriptor(solver, actionInstance, this.line, this.parserPath));
            return actionInstance;
        }

        @Override
        protected void traverse(Solver solver, ActionInstance actionInstance) {
            try {
                ActionInstance hierarchicalParentActionInstance = actionInstance.getParentActionInstance();
                ModelWalker modelWalker = new ModelWalker(solver, this.parserPath);
                this.expression.evaluateUnintActionHandles(solver);
                modelWalker.addUninitActionHandles(this.activityAST, actionInstance);
                if (this.nofRepeats == 0) {
                    modelWalker.addConstraintDescriptors(this.activityAST, actionInstance, false);
                }
                if (!this.isRepeatWhile && !this.evalExpression(solver, hierarchicalParentActionInstance)) {
                    return;
                }
                if (this.nofRepeats >= 1) {
                    solver.print(Utils.append("*** Warning: Repeat count inside '", actionInstance.getParentActionInstance(), "' activity description could not be determined (assuming 1)"));
                    return;
                }
                if (this.nofRepeats >= solver.CONFIG_REPEAT_LIMIT) {
                    solver.logWarning(Utils.append("*** Warning: Repeat count ", this.nofRepeats, " exceeds ", solver.CONFIG_REPEAT_LIMIT, ". Limited to ", solver.CONFIG_REPEAT_LIMIT, "."));
                    return;
                }
                solver.checkInterrupted();
                ++this.nofRepeats;
                this.isRepeatWhile = false;
                solver.pushActivityDescriptor(this);
                modelWalker.addActivityDescriptors(this.activityAST, actionInstance, false);
            }
            catch (Solver.EvaluationException e) {
                solver.print(e.getErrorMessage(solver.getScenario(), -1, this.parserPath));
                throw new Solver.InterruptException();
            }
        }

        protected boolean evalExpression(Solver solver, ActionInstance hierarchicalParentActionInstance) {
            if (this.isRuntime) {
                return this.nofRepeats == 0;
            }
            return solver.evalIfElse(hierarchicalParentActionInstance, this.expression);
        }

        @Override
        public String getInstanceName() {
            if (this.isRuntime && this.nofRepeats == 0) {
                return this.label == null ? String.valueOf(this.isRepeatWhile ? "do - " : "") + "while " + this.expression.toString(true) : this.label;
            }
            return this.label == null ? "[sequence]" : this.label;
        }
    }
}

