/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Pool;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfFieldWrapper;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public abstract class BindDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ParserPath parserPath;
    private int line;

    protected BindDescriptor(int line, ParserPath parserPath) {
        this.line = line;
        this.parserPath = parserPath;
    }

    public abstract boolean validBindDescriptor();

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public int getLine() {
        return this.line;
    }

    public static class PoolBindDescriptor
    extends BindDescriptor {
        private static final long serialVersionUID = 1L;
        private transient RfStruct rfComponent;
        private Expression.Hid hid1;
        private Expression.Hid hid2;

        public PoolBindDescriptor(RfStruct rfComponent, Expression.Hid hid1, Expression.Hid hid2, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.rfComponent = rfComponent;
            this.hid1 = hid1;
            this.hid2 = hid2;
        }

        public RfField getRfPool() {
            return this.hid1.getLastField();
        }

        @Override
        public boolean validBindDescriptor() {
            return (this.hid1.size() == 1 || this.hid1.size() > 1) && this.hid2.size() > 1;
        }

        public boolean canBind(FieldInstance fieldInstance) {
            RfStruct rfAction;
            int size = this.hid2.size();
            boolean isStatePrevInput = fieldInstance.isState() && fieldInstance.isInput() && fieldInstance.getRawName().endsWith(".prev");
            RfField rfNamedElement = Utils.last(this.hid2.ids).getRfField();
            RfField rfField = fieldInstance.getRfField();
            if (rfNamedElement == RfField.ANY_FIELD && size == 1) {
                return true;
            }
            ActionInstance parentActionInstance = fieldInstance.getParentActionInstance();
            RfStruct rfStruct = rfAction = parentActionInstance == null ? null : parentActionInstance.getRfAction();
            if (!(rfNamedElement == RfField.ANY_FIELD || rfNamedElement == rfField || isStatePrevInput && fieldInstance.getRawName().equals(Utils.append(rfNamedElement.getName(), ".prev")))) {
                return false;
            }
            if (rfNamedElement != RfField.ANY_FIELD && rfNamedElement instanceof RfFieldWrapper && ((RfFieldWrapper)rfNamedElement).getWrappedElement() != rfAction) {
                return false;
            }
            InstancesContainer currentInstanceScope = null;
            int i = 0;
            while (i < size - 1) {
                RfNamedElement rfNamedElement2 = this.hid2.ids.get(i).getRfField();
                if (rfNamedElement2 instanceof RfFieldWrapper) {
                    rfNamedElement2 = ((RfFieldWrapper)rfNamedElement2).getWrappedElement();
                }
                if (rfNamedElement2 instanceof RfStruct && ((RfStruct)rfNamedElement2).getStructKind() == StructKind.COMPONENT) {
                    RfStruct rfComponent = (RfStruct)rfNamedElement2;
                    parentComponentInstance = fieldInstance.getParentComponentInstance();
                    if ((parentComponentInstance = parentComponentInstance.getParentComponentInstance(rfComponent)) == null) {
                        return false;
                    }
                    currentInstanceScope = parentComponentInstance;
                } else if (rfNamedElement2 instanceof RfStruct && ((RfStruct)rfNamedElement2).getStructKind() == StructKind.ACTION) {
                    rfAction = (RfStruct)rfNamedElement2;
                    ActionInstance parentActionInstance2 = fieldInstance.getParentActionInstance();
                    if (parentActionInstance2 == null || rfAction != parentActionInstance2.getRfAction()) {
                        return false;
                    }
                    currentInstanceScope = parentActionInstance2;
                } else {
                    if (rfNamedElement2 instanceof RfField && rfNamedElement2 == RfField.ANY_FIELD) {
                        return true;
                    }
                    if (rfNamedElement2 instanceof RfField) {
                        RfNamedElement rfComponentInstance = rfNamedElement2;
                        parentComponentInstance = fieldInstance.getParentComponentInstance();
                        if ((parentComponentInstance = parentComponentInstance.getParentComponentInstance((RfField)rfComponentInstance)) == null) {
                            return false;
                        }
                        currentInstanceScope = parentComponentInstance;
                    }
                }
                ++i;
            }
            if (currentInstanceScope == null) {
                return false;
            }
            Expression.Id id = Utils.last(this.hid2.ids);
            if (id.getRfField() instanceof RfFieldWrapper) {
                return false;
            }
            if (id.getRfField() == RfField.ANY_FIELD) {
                return true;
            }
            if ((currentInstanceScope = currentInstanceScope.getFieldInstance(id.toInstance(ScenarioUtils.getScenario(), currentInstanceScope, -1, null))) == null) {
                return false;
            }
            return currentInstanceScope == fieldInstance || isStatePrevInput && currentInstanceScope.getParentActionInstance() == fieldInstance.getParentActionInstance() && fieldInstance.getRawName().equals(Utils.append(currentInstanceScope.getRawName(), ".prev"));
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfComponent);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfComponent = (RfStruct)ScenarioUtils.getRfOfKey(key);
        }

        public boolean isDefault() {
            return Utils.last(this.hid2.ids).getRfField() == RfField.ANY_FIELD;
        }

        public Pool getPoolInstance(Scenario scenario, ComponentInstance componentInstance) {
            InstancePath poolInstancePath = this.hid1.getHierarchicalPath(scenario, false, componentInstance);
            return InstancePath.getPoolInScope(poolInstancePath, componentInstance);
        }
    }

    public static class PortBindDescriptor
    extends BindDescriptor {
        private static final long serialVersionUID = 1L;
        private InstancesContainer actionInstance;
        private Expression.Hid hid1;
        private Expression.Hid hid2;

        public PortBindDescriptor(ActionInstance actionInstance, Expression.Hid hid1, Expression.Hid hid2, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.actionInstance = actionInstance;
            this.hid1 = hid1;
            this.hid2 = hid2;
        }

        public RfField getRfField1() {
            return this.hid1.getLastField();
        }

        public RfField getRfField2() {
            return this.hid2.getLastField();
        }

        public List<InstancesContainer> getInstancesHid1(Scenario scenario) {
            return this.getInstancesHid(scenario, this.hid1, this.actionInstance);
        }

        public List<InstancesContainer> getInstancesHid2(Scenario scenario) {
            return this.getInstancesHid(scenario, this.hid2, this.actionInstance);
        }

        private List<InstancesContainer> getInstancesHid(Scenario scenario, Expression.Hid hid, InstancesContainer currentInstanceScope) {
            InstancePath hierarchicalPath = hid.getHierarchicalPath(scenario, false, currentInstanceScope);
            return InstancePath.getInstanceInScope(hierarchicalPath, currentInstanceScope, false, Integer.MAX_VALUE);
        }

        @Override
        public boolean validBindDescriptor() {
            return (this.hid1.size() == 1 || this.hid1.size() > 1) && this.hid2.size() > 1;
        }

        public boolean isHierarchicalBind() {
            return this.hid1.size() == 1;
        }
    }
}

