/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.MethodCallInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Pool;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.RegionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.ByteArray;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.ListUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfDummyField;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public class ComponentInstance
extends InstancesContainer {
    private static final long serialVersionUID = 1L;
    private transient RfField rfComponentInstance;
    private List<ActionInstance> actionInstances;
    private List<ComponentInstance> childrenInstances;
    private ComponentInstance parentComponentInstance;
    private List<Pool> poolInstances;
    private List<RegionInstance> regionInstances;
    private List<ComponentInstance> executorInstances;
    private boolean isPure;
    private Expression.Value.HndlValue handleValue;
    private transient InstancePath instancePath;

    public ComponentInstance(RfField rfComponentInstance, RfNamedElement rfComponent, int arraySize, int arrayItemIndex, ComponentInstance parentComponentInstance, Scenario scenario) {
        super(ScenarioUtils.getDeduplicateName(rfComponentInstance), arraySize, arrayItemIndex, Solver.DEFAULT_RUNTIME_ID, rfComponent, rfComponentInstance.isRef(), scenario);
        this.rfComponentInstance = rfComponentInstance;
        this.parentComponentInstance = parentComponentInstance;
        this.isPure = Utils.isPure(rfComponent);
        scenario.addRecoverableInstance(this);
    }

    public ComponentInstance(RfStruct rootComponent, int arraySize, int arrayItemIndex, ComponentInstance parentComponentInstance, Scenario scenario) {
        super(ScenarioUtils.getDeduplicateName(rootComponent), arraySize, arrayItemIndex, Solver.DEFAULT_RUNTIME_ID, rootComponent, false, scenario);
        this.rfComponentInstance = new RfDummyField(rootComponent);
        this.parentComponentInstance = parentComponentInstance;
        this.isPure = Utils.isPure(rootComponent);
        scenario.addRecoverableInstance(this);
    }

    public RfStruct getRfComponent() {
        if (this.typeInstance.rfInstanceType instanceof RfStruct) {
            return (RfStruct)this.typeInstance.rfInstanceType;
        }
        return null;
    }

    public boolean isPure() {
        return this.isPure;
    }

    @Override
    public RfField getRfField() {
        return this.rfComponentInstance;
    }

    public void addChildActionInstance(ActionInstance actionInstance) {
        if (this.actionInstances == null) {
            this.actionInstances = new ArrayList<ActionInstance>();
        }
        this.hierarchicalSeeding(actionInstance, this.actionInstances.size());
        this.actionInstances.add(actionInstance);
        actionInstance.parentComponentInstance = this;
    }

    public List<ActionInstance> getActionInstances() {
        return this.actionInstances;
    }

    public void addChildComponentInstance(ComponentInstance componentInstance) {
        componentInstance.parentComponentInstance = this;
        if (componentInstance.isPure()) {
            this.scenario.getSolver().addPureComponentInstance(this.instanceIndex, componentInstance);
            return;
        }
        if (this.childrenInstances == null) {
            this.childrenInstances = new ArrayList<ComponentInstance>();
        }
        this.hierarchicalSeeding(componentInstance, this.childrenInstances.size());
        this.childrenInstances.add(componentInstance);
    }

    public List<ComponentInstance> getComponentInstances(boolean isIncludingPure) {
        if (!isIncludingPure) {
            return this.childrenInstances == null ? Collections.emptyList() : this.childrenInstances;
        }
        return ListUtils.concat(this.childrenInstances, this.scenario.getSolver().getPureComponentInstance(this.instanceIndex));
    }

    @Override
    public ComponentInstance getParentComponentInstance() {
        if (this.isArrayItem()) {
            return this.parentComponentInstance.getParentComponentInstance();
        }
        return this.parentComponentInstance;
    }

    @Override
    public ActionInstance getParentActionInstance() {
        return null;
    }

    public void addPool(Pool pool) {
        if (this.poolInstances == null) {
            this.poolInstances = new ArrayList<Pool>();
        }
        this.hierarchicalSeeding(pool, this.poolInstances.size());
        this.poolInstances.add(pool);
    }

    public void collectPoolCandidates(Set<Pool> result, FieldInstance candidate) {
        if (this.poolInstances == null || this.poolInstances.isEmpty()) {
            return;
        }
        for (Pool pool : this.poolInstances) {
            if (!Solver.equals(pool.getRfPoolType(), candidate.getRfFieldType())) continue;
            result.add(pool);
        }
    }

    public ComponentInstance getComponentInstance(InstancesContainer instance) {
        List<ComponentInstance> componentInstances = this.getComponentInstances(true);
        for (ComponentInstance componentInstance : componentInstances) {
            if (instance == componentInstance) {
                return componentInstance;
            }
            if (!instance.name.equals(componentInstance.name)) continue;
            if (!instance.isArrayItem()) {
                return componentInstance;
            }
            return componentInstance.getComponentInstance(instance.arrayItemIndex);
        }
        return null;
    }

    public ComponentInstance getComponentInstance(int arrayItemIndex) {
        List<ComponentInstance> componentInstances = this.getComponentInstances(true);
        if (componentInstances == null || componentInstances.isEmpty() || arrayItemIndex >= componentInstances.size() || arrayItemIndex < 0) {
            ScenarioUtils.printError(Utils.append("Index ", arrayItemIndex, " is out of bounds (", this.typeInstance.typeCategory.toString().toLowerCase(), " size is ", Math.max(0, this.arraySize), ")"), true, this.getRfField().getDeclaration());
            throw new Solver.InterruptException();
        }
        return componentInstances.get(arrayItemIndex);
    }

    public PoolItem getPoolItemInstance(InstancesContainer instance) {
        if (this.poolInstances == null || this.poolInstances.isEmpty()) {
            return null;
        }
        for (Pool poolInstance : this.poolInstances) {
            FieldInstance poolInstanceCandidate;
            if (!instance.name.equals(poolInstance.name) || (poolInstanceCandidate = poolInstance.getFieldInstance(instance.arrayItemIndex)) == null) continue;
            return (PoolItem)poolInstanceCandidate;
        }
        return null;
    }

    public Pool getPoolInstance(InstancesContainer instance) {
        if (this.poolInstances == null || this.poolInstances.isEmpty()) {
            return null;
        }
        for (Pool poolInstance : this.poolInstances) {
            if (!poolInstance.name.equals(instance.name)) continue;
            return poolInstance;
        }
        return null;
    }

    @Override
    public Collection<? extends InstancesContainer> debuggerGetMembers() {
        List<ComponentInstance> componentInstances;
        ArrayList<InstancesContainer> result = new ArrayList<InstancesContainer>();
        if (this.typeInstance != null) {
            result.addAll(this.typeInstance.fieldInstances.values());
        }
        if ((componentInstances = this.getComponentInstances(true)) != null && !componentInstances.isEmpty()) {
            result.addAll(componentInstances);
        }
        if (this.regionInstances != null) {
            result.addAll(this.regionInstances);
        }
        return result;
    }

    public void addExecutor(ComponentInstance executorInstance, int line, ParserPath parserPath) {
        if (this.executorInstances == null) {
            this.executorInstances = new ArrayList<ComponentInstance>();
        }
        for (InstancesContainer instancesContainer : this.executorInstances) {
            if (instancesContainer != executorInstance) continue;
            ScenarioUtils.printError(Utils.append("Executor '", executorInstance, "' is already added to the executor group '", this, "'"), true, line, parserPath);
            throw new Solver.InterruptException();
        }
        this.executorInstances.add(executorInstance);
    }

    public Expression.Value.HndlValue addRegion(RegionInstance regionInstance, boolean isAllocatable, int line, ParserPath parserPath) {
        ByteArray concatByteArray;
        ByteArray beforeByteArray;
        RegionInstance afterCandidate;
        BigInteger regionSize;
        if (this.regionInstances == null) {
            this.regionInstances = new ArrayList<RegionInstance>();
        }
        if (BigInteger.ZERO.compareTo(regionSize = Utils.intValue(regionInstance.getFieldInstance("size"))) >= 0) {
            ScenarioUtils.printWarning(Utils.append("Ignored negative or zero size address region"), true, line, parserPath);
            return null;
        }
        BigInteger regionStartAddress = Utils.intValue(regionInstance.getFieldInstance("addr"));
        boolean isOpaqueRegion = false;
        if (regionStartAddress == null) {
            regionStartAddress = this.regionInstances.isEmpty() ? BigInteger.ZERO : Utils.last(this.regionInstances).nextOpaqueAddress();
            isOpaqueRegion = true;
        }
        regionInstance.initRegion(regionStartAddress, regionSize, isAllocatable);
        BigInteger regionEndAddress = regionStartAddress.add(regionSize).subtract(BigInteger.ONE);
        IntDomain domain = new IntDomain();
        for (RegionInstance existingRegionInstance : this.regionInstances) {
            BigInteger lowerAddress = existingRegionInstance.getLowerAddress();
            BigInteger upperAddress = existingRegionInstance.getUpperAddress();
            domain.addSubdomain(lowerAddress, upperAddress);
            domain.subDomainsSort();
            domain.updateBounds();
            IntDomain overlap = domain.intersect(regionStartAddress, regionEndAddress);
            if (overlap.isEmpty()) continue;
            ScenarioUtils.printWarning(Utils.append("Address range [", Utils.formatNumber(16, regionStartAddress, 64, 4), "..", Utils.formatNumber(16, regionEndAddress, 64, 4), "] is overllaping with other region address range"), true, line, parserPath);
        }
        int beforeCandidateIndex = -1;
        int afterCandidateIndex = -1;
        if (!isOpaqueRegion) {
            BigInteger nextStartAddress1 = regionInstance.nextOpaqueAddress();
            FieldInstance regionTrait = regionInstance.getFieldInstance("trait");
            int i = 0;
            while (i < this.regionInstances.size()) {
                FieldInstance memoryTrait;
                RegionInstance memoryRegion = this.regionInstances.get(i);
                BigInteger nextStartAddress2 = memoryRegion.nextOpaqueAddress();
                if (nextStartAddress1.equals(memoryRegion.getLowerAddress()) && memoryRegion.isAllocatable() == isAllocatable && regionTrait.deepCompare(memoryTrait = memoryRegion.getFieldInstance("trait"), false, true, line, parserPath)) {
                    afterCandidateIndex = i;
                }
                if (nextStartAddress2.equals(regionInstance.getLowerAddress()) && memoryRegion.isAllocatable() == isAllocatable && regionTrait.deepCompare(memoryTrait = memoryRegion.getFieldInstance("trait"), false, true, line, parserPath)) {
                    beforeCandidateIndex = i;
                }
                ++i;
            }
        }
        RegionInstance beforeCandidate = beforeCandidateIndex < 0 ? null : this.regionInstances.get(beforeCandidateIndex);
        RegionInstance regionInstance2 = afterCandidate = afterCandidateIndex < 0 ? null : this.regionInstances.get(afterCandidateIndex);
        if (beforeCandidate != null && afterCandidate != null) {
            beforeByteArray = beforeCandidate.getByteArray();
            ByteArray afterByteArray = afterCandidate.getByteArray();
            beforeCandidate.initRegion(beforeCandidate.getLowerAddress(), beforeCandidate.getSize().add(regionInstance.getSize()).add(afterCandidate.getSize()), isAllocatable);
            ByteArray concatByteArray2 = beforeCandidate.getByteArray();
            concatByteArray2.put(beforeByteArray);
            concatByteArray2.put(concatByteArray2.length - afterByteArray.length, afterByteArray);
            this.regionInstances.remove(afterCandidateIndex);
            afterCandidate.setVariableValue(Expression.Value.from(beforeCandidate, -1, false));
            regionInstance.setVariableValue(Expression.Value.from(beforeCandidate, -1, false));
            regionInstance.setParentInstance(this);
            return regionInstance.getRegionHandle(BigInteger.ZERO);
        }
        if (beforeCandidate != null) {
            beforeByteArray = beforeCandidate.getByteArray();
            beforeCandidate.initRegion(beforeCandidate.getLowerAddress(), beforeCandidate.getSize().add(regionInstance.getSize()), isAllocatable);
            concatByteArray = beforeCandidate.getByteArray();
            concatByteArray.put(beforeByteArray);
            regionInstance.setVariableValue(Expression.Value.from(beforeCandidate, -1, false));
            regionInstance.setParentInstance(this);
            return regionInstance.getRegionHandle(BigInteger.ZERO);
        }
        if (afterCandidate != null) {
            ByteArray afterByteArray = afterCandidate.getByteArray();
            afterCandidate.initRegion(regionInstance.getLowerAddress(), afterCandidate.getSize().add(regionInstance.getSize()), isAllocatable);
            concatByteArray = afterCandidate.getByteArray();
            concatByteArray.put(concatByteArray.length - afterByteArray.length, afterByteArray);
            regionInstance.setVariableValue(Expression.Value.from(afterCandidate, -1, false));
            return regionInstance.getRegionHandle(BigInteger.ZERO);
        }
        this.regionInstances.add(regionInstance);
        regionInstance.setParentInstance(this);
        Collections.sort(this.regionInstances, (o1, o2) -> o1.getLowerAddress().compareTo(o2.getLowerAddress()));
        return regionInstance.getRegionHandle(BigInteger.ZERO);
    }

    public ActionInstance getActionInstance(InstancesContainer instance) {
        if (this.actionInstances == null || this.actionInstances.isEmpty()) {
            return null;
        }
        String instanceName = instance.getDiagramName();
        for (ActionInstance actionInstance : this.actionInstances) {
            if (instance == actionInstance) {
                return actionInstance;
            }
            String actionInstanceName = actionInstance.getDiagramName();
            String actionHandleName = ScenarioUtils.getDeduplicateName(actionInstance.getRfField());
            if (!instanceName.equals(actionInstanceName) && !instanceName.equals(actionHandleName)) continue;
            return actionInstance;
        }
        return null;
    }

    @Override
    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
        super.createSubInstances(backPointersMap, isVariableInstance);
        RfNamedElement rfComponentOrArray = this.typeInstance.rfInstanceType;
        Collection<RfNamedElement> rfFields = rfComponentOrArray.getMembersForElab(null, SemanticUtils.MEMBER_FIELDS, null);
        if (rfFields == null || rfFields.isEmpty()) {
            return;
        }
        backPointersMap.put(rfComponentOrArray, this);
        for (RfNamedElement rfField : rfFields) {
            if (rfField.isStatic()) continue;
            RfNamedElement rfFieldType = Utils.getAssociatedType((RfField)rfField);
            RfNamedElement rfFieldBaseType = Utils.getBaseElementType(rfFieldType);
            int arraySize = Utils.getAssociatedTypeArrayDim((RfField)rfField);
            boolean isRef = ((RfField)rfField).isRef();
            if (rfFieldType instanceof RfCollectionType && ((RfCollectionType)rfFieldType).getCollectionKind() == DataType.CollectionKind.ARRAY && arraySize <= 0) {
                ScenarioUtils.printError(Utils.append("Wrong array dimension '", arraySize, "' for '", this.getHierarchicalPath(), ".", rfField.getElabName(), "'"), true, rfField.getDeclaration());
                throw new Solver.InterruptException();
            }
            if (isRef) {
                this.createRefFieldInstance(null, (RfField)rfField, rfFieldType, arraySize, -1, false);
                continue;
            }
            if (rfFieldBaseType instanceof RfStruct && ((RfStruct)rfFieldBaseType).getStructKind() == StructKind.COMPONENT) {
                this.createComponentInstance(backPointersMap, (RfField)rfField, rfFieldType, arraySize, -1);
                continue;
            }
            if (((RfField)rfField).getFieldModifier() == FieldModifier.POOL) {
                this.createPoolInstance(backPointersMap, (RfField)rfField, rfFieldBaseType, arraySize);
                continue;
            }
            this.createFieldInstance(backPointersMap, null, (RfField)rfField, rfFieldType, arraySize, -1, false);
        }
        backPointersMap.remove(rfComponentOrArray, this);
    }

    private void createComponentInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex) {
        ComponentInstance componentInstance = new ComponentInstance(rfField, rfFieldType, arraySize, arrayItemIndex, this, this.scenario);
        this.addChildComponentInstance(componentInstance);
        if (componentInstance.isRefTypeInstance()) {
            return;
        }
        InstancesContainer backPointer = backPointersMap.get(rfFieldType);
        if (backPointer != null) {
            ScenarioUtils.printError(Utils.append("Infinite recursion detected for '", rfFieldType.getElabName(), "' instantiation"), true, rfField.getDeclaration());
            throw new Solver.InterruptException();
        }
        backPointersMap.clear();
        backPointersMap.put(rfFieldType, componentInstance);
        componentInstance.createSubInstances(backPointersMap, false);
        backPointersMap.remove(rfFieldType, componentInstance);
        if (componentInstance.isArrayType()) {
            RfNamedElement rfItemFieldType = Utils.getAssociatedType((RfCollectionType)rfFieldType);
            int itemArraySize = rfItemFieldType instanceof RfCollectionType ? Utils.getAssociatedTypeArrayDim((RfCollectionType)rfItemFieldType) : -1;
            int i = 0;
            while (i < arraySize) {
                componentInstance.createComponentInstance(backPointersMap, rfField, rfItemFieldType, itemArraySize, i);
                ++i;
            }
        }
    }

    private void createPoolInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, RfField rfField, RfNamedElement rfFieldType, int poolSize) {
        Pool poolInstance = new Pool(backPointersMap, this, rfField, rfFieldType, poolSize, this.scenario);
        poolInstance.parentComponentInstance = this;
        this.addPool(poolInstance);
        poolInstance.getInitialStateObject();
    }

    @Override
    public InstancePath getInstancePath() {
        if (this.instancePath != null) {
            return this.instancePath;
        }
        this.instancePath = new InstancePath(this.parentComponentInstance == null ? null : this.parentComponentInstance.getInstancePath(), this.isArrayItem(), this);
        return this.instancePath;
    }

    @Override
    public InstancePath getHierarchicalPath() {
        return this.getInstancePath();
    }

    public boolean accept(InstanceVisitor<ComponentInstance> visitor) {
        boolean continueVisit;
        boolean bl = continueVisit = this.isArrayType() || visitor.visit(this);
        if (!continueVisit) {
            return false;
        }
        List<ComponentInstance> componentInstances = this.getComponentInstances(true);
        for (ComponentInstance child : componentInstances) {
            continueVisit = child.accept(visitor);
            if (continueVisit) continue;
            return false;
        }
        visitor.postVisit(this);
        return true;
    }

    public ComponentInstance getParentComponentInstance(RfField instanceCandidate) {
        if (this.rfComponentInstance == instanceCandidate) {
            return this;
        }
        if (this.parentComponentInstance == null) {
            return null;
        }
        return this.parentComponentInstance.getParentComponentInstance(instanceCandidate);
    }

    public ComponentInstance getParentComponentInstance(RfStruct componentCandidate) {
        if (this.typeInstance.rfInstanceType == componentCandidate) {
            return this;
        }
        if (this.parentComponentInstance == null) {
            return null;
        }
        return this.parentComponentInstance.getParentComponentInstance(componentCandidate);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int key = ScenarioUtils.getKeyOfRf(this.rfComponentInstance);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int key = in.readInt();
        this.rfComponentInstance = (RfField)ScenarioUtils.getRfOfKey(key);
    }

    protected boolean canInsertBefore(ActionInstance actionInstance1, ActionInstance actionInstance2) {
        if (this.poolInstances == null || this.poolInstances.isEmpty()) {
            return true;
        }
        for (Pool pool : this.poolInstances) {
            if (pool.canInsertBefore(actionInstance1, actionInstance2)) continue;
            return false;
        }
        return true;
    }

    public void checkResourcePoolSchedulingConsistency() {
        if (this.poolInstances == null || this.poolInstances.isEmpty()) {
            return;
        }
        for (Pool pool : this.poolInstances) {
            pool.checkResourcePoolSchedulingConsistency();
        }
    }

    protected void applyInitExecDescriptors(Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap) {
        this.applyExecDescriptors(model, variableSolverMap, ExecBlockKind.INIT_DOWN, this.getRfComponent());
        List<ComponentInstance> componentInstances = this.getComponentInstances(false);
        if (componentInstances != null && !componentInstances.isEmpty()) {
            for (ComponentInstance componentInstance : componentInstances) {
                componentInstance.applyInitExecDescriptors(model, variableSolverMap);
            }
        }
        this.applyExecDescriptors(model, variableSolverMap, ExecBlockKind.INIT_UP, this.getRfComponent());
    }

    public void collectStateObjectPools(List<Pool> pools) {
        if (this.poolInstances == null || this.poolInstances.isEmpty()) {
            return;
        }
        for (Pool pool : this.poolInstances) {
            if (!pool.isState()) continue;
            pools.add(pool);
        }
    }

    public List<Pool> getPoolInstances() {
        return this.poolInstances;
    }

    @Override
    public InstancesContainer getRange(int lsb, int msb) {
        if (lsb != msb || this.arraySize <= 0) {
            throw new Solver.EvaluationException("Cannot evaluate '" + this.toString() + "[" + lsb + "]' variable instance");
        }
        return this.childrenInstances.get(lsb);
    }

    @Override
    protected Collection<? extends InstancesContainer> getMembers() {
        List<ComponentInstance> componentInstances = this.getComponentInstances(true);
        return componentInstances;
    }

    @Override
    protected boolean isValueCopyAssignment() {
        return false;
    }

    public final AllocatableRegions getAllocatableRegions(InstancesContainer claimInstance, int line, ParserPath parserPath) {
        List<ComponentInstance> componentInstances = this.getComponentInstances(false);
        if (!componentInstances.isEmpty()) {
            AllocatableRegions allocatableRegions = new AllocatableRegions(Collections.newSetFromMap(new IdentityHashMap()), new IntDomain());
            for (ComponentInstance componentInstance : componentInstances) {
                if (componentInstance.regionInstances == null || componentInstance.regionInstances.isEmpty()) continue;
                for (RegionInstance regionInstance : componentInstance.regionInstances) {
                    if (!regionInstance.isAllocatable()) continue;
                    regionInstance.getFullAllocatableDomain(allocatableRegions, claimInstance);
                }
            }
            if (!allocatableRegions.allocatableDomain.isEmpty()) {
                this.scenario.removeAllocatedRegions(allocatableRegions, claimInstance.getParentActionInstance());
                if (allocatableRegions.allocatableDomain.isEmpty()) {
                    throw new Solver.EvaluationException(Utils.append("No allocatable region available to resolve claim '", claimInstance.toString(), "'"), line, parserPath);
                }
                return allocatableRegions;
            }
        }
        if (this.parentComponentInstance == null) {
            throw new Solver.EvaluationException(Utils.append("No allocatable region available to resolve claim '", claimInstance.toString(), "'"), line, parserPath);
        }
        return this.parentComponentInstance.getAllocatableRegions(claimInstance, line, parserPath);
    }

    public final List<ComponentInstance> getAllocatableExecutors(InstancesContainer claimInstance, int line, ParserPath parserPath) {
        List<ComponentInstance> componentInstances = this.getComponentInstances(false);
        if (!componentInstances.isEmpty()) {
            ArrayList<ComponentInstance> allocatableExecutors = new ArrayList<ComponentInstance>();
            for (ComponentInstance componentInstance : componentInstances) {
                if (componentInstance.executorInstances == null || componentInstance.executorInstances.isEmpty()) continue;
                for (ComponentInstance executorInstance : componentInstance.executorInstances) {
                    FieldInstance claimTraitInstance = claimInstance.getFieldInstance("trait");
                    FieldInstance executorTraitInstance = executorInstance.getFieldInstance("trait");
                    if (claimTraitInstance.getRfFieldType() != executorTraitInstance.getRfFieldType()) continue;
                    allocatableExecutors.add(executorInstance);
                }
            }
            if (!allocatableExecutors.isEmpty()) {
                return allocatableExecutors;
            }
        }
        if (this.parentComponentInstance == null) {
            throw new Solver.EvaluationException(Utils.append("No allocatable executor available to resolve claim '", claimInstance.toString(), "'"), line, parserPath);
        }
        return this.parentComponentInstance.getAllocatableExecutors(claimInstance, line, parserPath);
    }

    public void setHandle(Expression.Value.HndlValue handleValue, int line, ParserPath parserPath) {
        if (this.parentComponentInstance != null && this.parentComponentInstance.getRfComponent().isCoreLibInstanceOf("reg_group_c")) {
            throw new Solver.EvaluationException(Utils.append("Cannot set the handle of inner register group '", this, "'"), line, parserPath);
        }
        this.handleValue = handleValue;
    }

    public Expression.Value.HndlValue getHandle(int line, ParserPath parserPath) {
        try {
            if (this.handleValue != null) {
                return this.handleValue;
            }
            Expression.InlineInit pathExpr = new Expression.InlineInit(Utils.getNodeStructTypeField(true), Expression.InlineInit.Kind.ARRAY_INIT, line, parserPath);
            this.handleValue = this.getHandle(pathExpr, line, parserPath);
            return this.handleValue;
        }
        catch (Expression.ReturnException e) {
            this.handleValue = (Expression.Value.HndlValue)e.getReturnValue().get((int)0).expr;
            return this.handleValue;
        }
    }

    private final Expression.Value.HndlValue getHandle(Expression.InlineInit pathExpr, int line, ParserPath parserPath) {
        if (this.parentComponentInstance == null) {
            return null;
        }
        if (this.handleValue != null) {
            return this.handleValue;
        }
        try {
            boolean isArrayItem = this.isArrayItem();
            String registerName = isArrayItem ? this.parentComponentInstance.getName() : this.getName();
            Expression.StringExpression nameExpr = new Expression.StringExpression(Utils.append("\"", registerName, "\""), line, parserPath);
            int index = Math.max(this.arrayItemIndex, 0);
            Expression.IntExpression indexExpr = new Expression.IntExpression(Integer.toString(index), BigInteger.valueOf(index), false, line, parserPath);
            Expression.InlineInit pathItem = new Expression.InlineInit(Utils.getNodeStructTypeField(false), Expression.InlineInit.Kind.STRUCT_INIT, line, parserPath);
            pathItem.addItem(new Expression.StringExpression("name", line, parserPath), nameExpr);
            pathItem.addItem(new Expression.StringExpression("index", line, parserPath), indexExpr);
            pathExpr.addItem0(pathItem);
            RfStruct rfComponent = this.getRfComponentBaseType(line, parserPath);
            String registerTypeName = rfComponent.getName();
            ComponentInstance parentInstance = isArrayItem ? this.parentComponentInstance.parentComponentInstance : this.parentComponentInstance;
            Expression.Value.HndlValue hndlValue = parentInstance.getHandleOffset(pathExpr, registerTypeName, isArrayItem, nameExpr, indexExpr, line, parserPath);
            return hndlValue;
        }
        finally {
            pathExpr.removeItem0();
        }
    }

    private final Expression.Value.HndlValue getHandleOffset(Expression.InlineInit pathExpr, String registerTypeName, boolean isArrayItem, Expression.StringExpression nameExpr, Expression.IntExpression indexExpr, int line, ParserPath parserPath) {
        Expression.Value.HndlValue handleValue = this.getHandle(pathExpr, line, parserPath);
        if (handleValue == null) {
            throw new Solver.EvaluationException(Utils.append("Cannot determine the handle of inner register or register group '", registerTypeName, "'"), line, parserPath);
        }
        RfStruct rfComponent = this.getRfComponentBaseType(line, parserPath);
        RfMethod rfMethod = Utils.getMethod(rfComponent, "get_offset_of_path");
        if (rfMethod != null && rfMethod.getNodeAST() != null) {
            MethodCallInstance methodInstance = new MethodCallInstance(this, rfMethod, Collections.singletonList(pathExpr), line, parserPath);
            Expression.Value offsetValue = methodInstance.evaluateMethodCall(this);
            BigInteger offset = offsetValue.getIntValue();
            if (offset.compareTo(BigInteger.ZERO) < 0) {
                throw new Solver.EvaluationException(Utils.append("Negative offset not allowed for '", nameExpr, "'"), rfMethod.getDeclaration());
            }
            Expression.Value.HndlValue newHandleValue = Expression.Value.HndlValue.from(handleValue, offset, line, parserPath);
            throw new Expression.ReturnException(Collections.singletonList(new Expression.ExprAndDep<Expression.Value.HndlValue>(newHandleValue, null, LazyString.create(() -> this.toString()), line)));
        }
        if (isArrayItem) {
            rfMethod = Utils.getMethod(rfComponent, "get_offset_of_instance_array");
            if (rfMethod == null || rfMethod.getNodeAST() == null) {
                throw new Solver.EvaluationException(Utils.append("'", registerTypeName, "' must implement get_offset_of_instance_array() or get_offset_of_path() to get the '", this.getName(), "' offset"), line, parserPath);
            }
            MethodCallInstance methodInstance = new MethodCallInstance(this, rfMethod, Arrays.asList(nameExpr, indexExpr), line, parserPath);
            Expression.Value offsetValue = methodInstance.evaluateMethodCall(this);
            BigInteger offset = offsetValue.getIntValue();
            if (offset.compareTo(BigInteger.ZERO) < 0) {
                throw new Solver.EvaluationException(Utils.append("Negative offset not allowed for '", nameExpr, "'"), rfMethod.getDeclaration());
            }
            return Expression.Value.HndlValue.from(handleValue, offset, line, parserPath);
        }
        rfMethod = Utils.getMethod(rfComponent, "get_offset_of_instance");
        if (rfMethod == null || rfMethod.getNodeAST() == null) {
            throw new Solver.EvaluationException(Utils.append("'", registerTypeName, "' must implement get_offset_of_instance() or get_offset_of_path() to get the '", this.getName(), "' offset"), line, parserPath);
        }
        MethodCallInstance methodInstance = new MethodCallInstance(this, rfMethod, Collections.singletonList(nameExpr), line, parserPath);
        Expression.Value offsetValue = methodInstance.evaluateMethodCall(this);
        BigInteger offset = offsetValue.getIntValue();
        if (offset.compareTo(BigInteger.ZERO) < 0) {
            throw new Solver.EvaluationException(Utils.append("Negative offset not allowed for '", nameExpr, "'"), rfMethod.getDeclaration());
        }
        return Expression.Value.HndlValue.from(handleValue, offset, line, parserPath);
    }

    private RfStruct getRfComponentBaseType(int line, ParserPath parserPath) {
        RfNamedElement rfFieldType = this.getRfFieldType();
        RfNamedElement rfNamedElement = rfFieldType = rfFieldType instanceof RfCollectionType ? Utils.getArrayItemType((RfCollectionType)rfFieldType) : rfFieldType;
        if (!(rfFieldType instanceof RfStruct)) {
            throw new Solver.EvaluationException("Internal error RHD_1", line, parserPath);
        }
        RfStruct rfComponent = (RfStruct)rfFieldType;
        return rfComponent;
    }

    @Override
    public String toStringVariableValue() {
        return this.getInstancePath().toString();
    }

    protected static class AllocatableRegions {
        protected Set<RegionInstance> regionInstances;
        protected IntDomain allocatableDomain;

        public AllocatableRegions(Set<RegionInstance> regionInstances, IntDomain allocatableDomain) {
            this.regionInstances = regionInstances;
            this.allocatableDomain = allocatableDomain;
        }
    }
}

