/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.Disable;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class ConstraintDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Expression.CspConstraint DEFAULT_DISABLE = new Expression.CspConstraint(null, LazyString.create(() -> "[disable]"));
    protected String name;
    protected Expression expression;
    protected String debugInfo;
    protected boolean isInline;
    protected int maxTraversalIndex;
    protected boolean keepClosestToMax;

    public ConstraintDescriptor(String name, Expression expression, boolean isInline, int maxTraversalIndex, boolean keepClosestToMax) {
        this.name = name;
        this.expression = expression;
        this.isInline = isInline;
        this.keepClosestToMax = keepClosestToMax;
        this.maxTraversalIndex = isInline ? maxTraversalIndex : Integer.MAX_VALUE;
    }

    public void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String toString() {
        if (this.debugInfo != null) {
            return String.valueOf(this.debugInfo) + (this.name == null ? "" : "(" + this.name + ") ") + this.expression.toString();
        }
        return "constraint " + (this.name == null ? "" : "(" + this.name + ") ") + this.expression.toString();
    }

    public String customizeText(String hrText) {
        if (this.debugInfo != null) {
            return String.valueOf(this.debugInfo) + (this.name == null ? "" : "(" + this.name + ") ") + hrText;
        }
        return "constraint " + (this.name == null ? "" : "(" + this.name + ") ") + hrText;
    }

    public void setMaxTraversalIndex(int maxTraversalIndex) {
        this.maxTraversalIndex = maxTraversalIndex;
    }

    public void apply(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, Map<Variable, Expression.CspConstraint> cspDefaultConstraintsMap, Map<AbstractConstraint, Text> cspToReadableTextMap) {
        if (this.isInline && currentInstanceScope instanceof ActionInstance && !((ActionInstance)currentInstanceScope).isTraversed()) {
            return;
        }
        List<Expression.CspConstraint> cspConstraints = Expression.toConstraint(scenario, model, this.expression, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, false, this.keepClosestToMax, this.maxTraversalIndex);
        if (cspConstraints == null || cspConstraints.isEmpty()) {
            return;
        }
        for (Expression.CspConstraint cspConstraint : cspConstraints) {
            Expression.CspConstraint existingDefaultConstraint;
            boolean isDefaultConstraint = cspConstraint.constraint.isDefault();
            if (!isDefaultConstraint) continue;
            Variable hid = cspConstraint.constraint.getVariables()[0];
            if (cspConstraint.constraint instanceof Disable) {
                existingDefaultConstraint = cspDefaultConstraintsMap.get(hid);
                if (existingDefaultConstraint != null) {
                    existingDefaultConstraint.constraint.unpost();
                    continue;
                }
                InstancesContainer.GeneratedVar generatedVar = variableSolverMap.get(hid.getName());
                InstancesContainer instance = generatedVar.getInstance();
                if (instance == null || !instance.isArrayType() && !instance.isStructType()) continue;
                block1: for (Map.Entry<Variable, Expression.CspConstraint> defaultConstraintEntry : cspDefaultConstraintsMap.entrySet()) {
                    generatedVar = variableSolverMap.get(defaultConstraintEntry.getKey().getName());
                    InstancesContainer instanceCandidate = generatedVar.getInstance();
                    while (instanceCandidate instanceof FieldInstance) {
                        if (instance == instanceCandidate) {
                            defaultConstraintEntry.getValue().constraint.unpost();
                            continue block1;
                        }
                        instanceCandidate = ((FieldInstance)instanceCandidate).getParentInstance();
                    }
                }
                continue;
            }
            existingDefaultConstraint = cspDefaultConstraintsMap.put(hid, cspConstraint);
            if (existingDefaultConstraint == null || existingDefaultConstraint.constraint == null) continue;
            existingDefaultConstraint.constraint.unpost();
        }
        for (Expression.CspConstraint cspConstraint : cspConstraints) {
            cspConstraint.constraint.post();
        }
    }

    public static class ExecStmtDescriptor
    extends ConstraintDescriptor {
        private static final long serialVersionUID = 1L;
        private ExecBlockKind execKind;

        public ExecStmtDescriptor(ExecBlockKind execKind, Expression expression) {
            super(null, expression, false, Integer.MAX_VALUE, false);
            this.execKind = execKind;
        }

        public ExecBlockKind getExecKind() {
            return this.execKind;
        }

        @Override
        public String toString() {
            if (this.debugInfo != null) {
                return String.valueOf(this.debugInfo) + (this.name == null ? "" : "(" + this.name + ") ") + this.expression.toString();
            }
            return "assign " + (this.name == null ? "" : "(" + this.name + ") ") + this.expression.toString();
        }

        @Override
        public String customizeText(String hrText) {
            if (this.debugInfo != null) {
                return String.valueOf(this.debugInfo) + (this.name == null ? "" : "(" + this.name + ") ") + hrText;
            }
            return "assign " + (this.name == null ? "" : "(" + this.name + ") ") + hrText;
        }

        @Override
        public void apply(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, Map<Variable, Expression.CspConstraint> cspDefaultConstraintsMap, Map<AbstractConstraint, Text> cspToReadableTextMap) {
            try {
                scenario.stackTrace.push(new Scenario.TraceElement(this.expression.line, this.expression.parserPath));
                this.expression.evaluateUnintActionHandles(scenario.getSolver());
                this.expression.evaluate(scenario, currentInstanceScope);
            }
            finally {
                scenario.stackTrace.pop();
            }
        }
    }

    public static class TargetExecStmtDescriptor
    extends ExecStmtDescriptor {
        private static final long serialVersionUID = 1L;
        private String text;

        public TargetExecStmtDescriptor(ExecBlockKind execKind, String text, Expression expression) {
            super(execKind, expression);
            this.text = text;
        }

        @Override
        public void apply(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, Map<Variable, Expression.CspConstraint> cspDefaultConstraintsMap, Map<AbstractConstraint, Text> cspToReadableTextMap) {
        }

        public String getExecTargetCode(Scenario scenario, InstancesContainer currentInstanceScope, ExecBlockKind execKind) {
            if (execKind != ExecBlockKind.FILE && !this.text.equals(scenario.getSolver().CONFIG_TARGET_LANGUAGE)) {
                return null;
            }
            if (this.expression instanceof Expression.StringExpression) {
                List<Expression.ExprAndDep<Expression.Value>> value = this.expression.evaluate(scenario, currentInstanceScope);
                return value.get(0).toString();
            }
            if (this.expression instanceof Expression.ListExpression) {
                StringBuilder result = new StringBuilder();
                List<Expression> expressions = ((Expression.ListExpression)this.expression).getExpressions();
                for (Expression expression : expressions) {
                    List<Expression.ExprAndDep<Expression.Value>> value = expression.evaluate(scenario, currentInstanceScope);
                    Expression.ExprAndDep<Expression.Value> exprAndDep = value.get(0);
                    if (expression instanceof Expression.StringExpression) {
                        result.append(((Expression.Value)exprAndDep.expr).getStringValue());
                        continue;
                    }
                    result.append(((Expression.Value)exprAndDep.expr).getIntValue());
                }
                String targetCode = result.toString();
                if (execKind == ExecBlockKind.FILE) {
                    return targetCode;
                }
                targetCode = DVTStringUtil.replaceAll((Pattern)Utils.STRING_NEW_LINE_WS, (CharSequence)targetCode, (String)"");
                return targetCode.trim();
            }
            return null;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class TestConstraintDescriptor
    extends ConstraintDescriptor {
        private static final long serialVersionUID = 1L;
        private transient IntVariable boolVariable;

        public TestConstraintDescriptor(int maxTraversalIndex, Expression expression) {
            super(null, expression, true, maxTraversalIndex, true);
        }

        @Override
        public void apply(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, Map<Variable, Expression.CspConstraint> cspDefaultConstraintsMap, Map<AbstractConstraint, Text> cspToReadableTextMap) {
            List<Expression.ExprAndDep<IntVariable>> arExprs = this.expression.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, true, this.maxTraversalIndex, true);
            if (arExprs == null || arExprs.isEmpty()) {
                return;
            }
            for (Expression.ExprAndDep<IntVariable> arExpr : arExprs) {
                if (arExpr.isVacuous()) continue;
                this.boolVariable = (IntVariable)arExpr.expr;
                return;
            }
        }

        public boolean isTrue() {
            if (this.boolVariable == null) {
                return false;
            }
            return !this.boolVariable.value().equals(BigInteger.ZERO);
        }
    }

    public static class Text {
        public LazyString lazyText;
        public int line;
        public ParserPath parserPath;

        public Text(LazyString text, int line, ParserPath parserPath) {
            this.lazyText = text;
            this.line = line;
            this.parserPath = parserPath;
        }
    }

    public static class ValueConstraintDescriptor
    extends ConstraintDescriptor {
        private static final long serialVersionUID = 1L;
        private transient IntVariable intVariable;

        public ValueConstraintDescriptor(int maxTraversalIndex, Expression expression) {
            super(null, expression, true, maxTraversalIndex, true);
        }

        @Override
        public void apply(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, Map<Variable, Expression.CspConstraint> cspDefaultConstraintsMap, Map<AbstractConstraint, Text> cspToReadableTextMap) {
            List<Expression.ExprAndDep<IntVariable>> arExprs = this.expression.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, true, this.maxTraversalIndex, true);
            if (arExprs == null || arExprs.isEmpty()) {
                return;
            }
            for (Expression.ExprAndDep<IntVariable> arExpr : arExprs) {
                if (arExpr.isVacuous()) continue;
                this.intVariable = (IntVariable)arExpr.expr;
                return;
            }
        }

        public BigInteger getValue() {
            if (this.intVariable == null) {
                return BigInteger.ZERO;
            }
            return this.intVariable.value();
        }
    }
}

