/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import antlr.collections.AST;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageExpression;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public abstract class CoverageDescriptor {
    private int line;
    private ParserPath parserPath;

    protected CoverageDescriptor(int line, ParserPath parserPath) {
        this.line = line;
        this.parserPath = parserPath;
    }

    public int getLine() {
        return this.line;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public abstract void apply(Scenario var1, InstancesContainer var2);

    public static class InlineCoverageDescriptor
    extends CoverageDescriptor {
        private AST id;
        private CoverageExpression.InlineCovergroup expr;

        public InlineCoverageDescriptor(AST id, CoverageExpression.InlineCovergroup expr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.id = id;
            this.expr = expr;
        }

        public String toString() {
            return Utils.append("inline covergroup ", this.id.getText(), " ", this.expr.toString(false));
        }

        @Override
        public void apply(Scenario scenario, InstancesContainer currentInstanceScope) {
            this.expr.evaluate(scenario, currentInstanceScope);
        }
    }

    public static class InstanceCoverageDescriptor
    extends CoverageDescriptor {
        private AST id;
        private CoverageExpression.InstanceCovergroup expr;

        public InstanceCoverageDescriptor(AST id, CoverageExpression.InstanceCovergroup expr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.id = id;
            this.expr = expr;
        }

        public String toString() {
            return Utils.append("instance covergroup ", this.id.getText(), " ", this.expr.toString(false));
        }

        @Override
        public void apply(Scenario scenario, InstancesContainer currentInstanceScope) {
            this.expr.evaluate(scenario, currentInstanceScope);
        }
    }
}

