/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import antlr.collections.AST;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.ConstraintDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageModel;
import ro.amiq.pssdt.model.reflection.elaboration.CovergroupCallContext;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.NestedBlockContext;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.BinKind;
import ro.amiq.pssdt.parser.EAST;

public abstract class CoverageExpression
extends Expression {
    public static final String COVERPOINT_NAME_PREFIX = "cp@";
    private static final long serialVersionUID = 1L;

    protected CoverageExpression(int line, ParserPath parserPath) {
        super(line, parserPath);
    }

    @Override
    public List<Expression.ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRand() {
        return false;
    }

    @Override
    public boolean isRuntime() {
        return false;
    }

    @Override
    public boolean isUninitActionHandle() {
        return false;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public List<Expression.ExpressionError> getErrors() {
        return null;
    }

    @Override
    public void cleanErrors() {
    }

    public static class BinDefault
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;

        public BinDefault(int line, ParserPath parserPath) {
            super(line, parserPath);
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> "default");
        }
    }

    public static class BinDomainSize
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;

        public BinDomainSize(int line, ParserPath parserPath) {
            super(line, parserPath);
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> "");
        }
    }

    public static class BinRange
    extends Expression.InRange {
        private static final long serialVersionUID = 1L;
        private List<Range> ranges = new ArrayList<Range>();

        public BinRange(int line, ParserPath parserPath) {
            super(null, line, parserPath);
        }

        @Override
        public void addInRange(Expression left, Expression right) {
            this.ranges.add(new Range(left, right));
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        public IntDomain toIntDomain(Scenario scenario, InstancesContainer currentInstanceScope, IntDomain variableDomain) {
            IntDomain newDomain = new IntDomain();
            for (Range range : this.ranges) {
                BigInteger left = range.left == null ? variableDomain.getLowerBound() : ((Expression.Value)range.left.evaluate((Scenario)scenario, (InstancesContainer)currentInstanceScope).get((int)0).expr).getIntValue();
                BigInteger right = range.right == null ? variableDomain.getUpperBound() : ((Expression.Value)range.right.evaluate((Scenario)scenario, (InstancesContainer)currentInstanceScope).get((int)0).expr).getIntValue();
                BigInteger lowerBound = left.min(right);
                BigInteger upperBound = left.max(right);
                newDomain.addSubdomain(lowerBound, upperBound);
            }
            newDomain.subDomainsSort();
            newDomain.updateBounds();
            return newDomain;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> this.ranges.toString());
        }

        static class Range
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private Expression left;
            private Expression right;

            public Range(Expression left, Expression right) {
                this.left = left;
                this.right = right;
            }

            public String toString() {
                if (this.left == null && this.right == null) {
                    ScenarioUtils.print("*** Error: Internal error BIN_1");
                    throw new Solver.InterruptException();
                }
                if (this.left == null) {
                    return Utils.append("..", this.right.toString(false));
                }
                if (this.right == null) {
                    return Utils.append(this.left.toString(false), "..");
                }
                return Utils.append(this.left.toString(false), "..", this.right.toString(false));
            }
        }
    }

    public static class BinWith
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private Expression expr;
        private Expression withExpr;

        public BinWith(Expression expr, Expression withExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.expr = expr;
            this.withExpr = withExpr;
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append(this.expr.toString(false), " with ", this.withExpr.toString(false)));
        }
    }

    public static class CoverageOption
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private AST id;
        private Expression expr;
        private boolean isTypeOption;

        public CoverageOption(AST id, Expression expr, boolean isTypeOption, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.id = id;
            this.expr = expr;
            this.isTypeOption = isTypeOption;
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                CoverageModel covergeModel = scenario.getSolver().getCovergeModel();
                List<Expression.ExprAndDep<Expression.Value>> optionValue = this.expr.evaluate(scenario, currentInstanceScope);
                covergeModel.setOption(this.id.getText(), (Expression.Value)optionValue.get((int)0).expr);
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return null;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("option.", this.id.getText(), " = ", this.expr.toString(false)));
        }
    }

    public static class Covercross
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private AST id;
        private List<AST> crossItems;
        private Expression iffExpr;
        private Expression.ListExpression bodyExpr;

        public Covercross(AST id, List<AST> crossItems, Expression iffExpr, Expression.ListExpression bodyExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.id = id;
            this.crossItems = crossItems;
            this.iffExpr = iffExpr;
            this.bodyExpr = bodyExpr;
        }

        /*
         * Unable to fully structure code
         */
        private void evaluateOptionsAndBins(Scenario scenario, InstancesContainer currentInstanceScope, RfField rfCovercross, FieldInstance coverpointInstance, CoverageModel covergeModel) {
            try {
                if (!covergeModel.startCoverpoint(rfCovercross, coverpointInstance)) {
                    return;
                }
                try {
                    crossItemDomains = new ArrayList<InstancesContainer.GeneratedVar>(this.crossItems.size());
                    restoreValues = new IdentityHashMap<Object, Expression.Value>(this.crossItems.size());
                    try {
                        model = new Model((BooleanSupplier)LambdaMetafactory.metafactory(null, null, null, ()Z, isCanceled(), ()Z)((IProgressMonitor)scenario.solver.getMonitor()), scenario.stringVariableMapping);
                        variableSolverMap = new LinkedHashMap<String, InstancesContainer.GeneratedVar>();
                        for (AST crossItem : this.crossItems) {
                            rfField = SemanticUtils.getTransientResult(RfField.class, crossItem);
                            hid = new Expression.Hid(Collections.singletonList(new Expression.Id(rfField)), this.line, this.parserPath);
                            varInstancePaths = hid.getVarInstancePaths(scenario, false, currentInstanceScope, false, 0x7FFFFFFF, true);
                            if (varInstancePaths == null || varInstancePaths.size() != 1) {
                                throw new Solver.EvaluationException(Utils.append(new Object[]{"Fail to evaluate variable '", rfField.getElabName(), "'"}), this.line, this.parserPath);
                            }
                            instance = varInstancePaths.get(0).getInstance();
                            restoreValues.put(instance, instance.getVariableValue());
                            instance.setVariableValue(null);
                            variable = instance.getVariable(model, null, varInstancePaths.get(0), variableSolverMap, true);
                            crossItemDomains.add(new InstancesContainer.GeneratedVar(instance, variable, null));
                        }
                        cspToReadableTextMap = new HashMap<AbstractConstraint, ConstraintDescriptor.Text>();
                        expressions = this.bodyExpr.getExpressions();
                        for (Expression expression : expressions) {
                            if (!(expression instanceof CoverageOption)) continue;
                            expression.evaluate(scenario, currentInstanceScope);
                        }
                        excludeBinDomainExprs = new ArrayList<Expression>();
                        illegalBinDomainExprs = new ArrayList<Expression>();
                        for (Expression expression : expressions) {
                            if (!(expression instanceof CovercrossBin) || ((CovercrossBin)expression).getBinKind() == BinKind.BIN) continue;
                            excludeBinDomainExprs.add(((CovercrossBin)expression).binExpr);
                            if (((CovercrossBin)expression).getBinKind() != BinKind.ILLEGAL) continue;
                            illegalBinDomainExprs.add(((CovercrossBin)expression).binExpr);
                        }
                        hasAutoBins = true;
                        for (Expression expression : expressions) {
                            if (!(expression instanceof CovercrossBin) || ((CovercrossBin)expression).getBinKind() != BinKind.BIN) continue;
                            model.getSolver().internalPreSolve();
                            if (expression instanceof CovercrossBin && ((CovercrossBin)expression).binExpr != null) {
                                Covercross.toConstraint(scenario, model, ((CovercrossBin)expression).binExpr, variableSolverMap, cspToReadableTextMap, null, currentInstanceScope, false, false, 0x7FFFFFFF);
                                for (Expression excludeBinDomainExpr : excludeBinDomainExprs) {
                                    Covercross.toConstraint(scenario, model, Expression.not(excludeBinDomainExpr), variableSolverMap, cspToReadableTextMap, null, currentInstanceScope, false, false, 0x7FFFFFFF);
                                }
                                if (!model.getSolver().evaluateDomains()) {
                                    throw new Solver.EvaluationException(Utils.append(new Object[]{"Expression '", ((CovercrossBin)expression).binExpr.toString(false), "' is always false"}), expression.line, expression.parserPath);
                                }
                            }
                            ((CovercrossBin)expression).setBinDomains(crossItemDomains);
                            expression.evaluate(scenario, currentInstanceScope);
                            model.getConstraints().clear();
                            model.getSolver().reset();
                            hasAutoBins = false;
                        }
                        if (hasAutoBins) {
                            expression = new CovercrossBin(BinKind.BIN, this.id, null, null, this.line, this.parserPath);
                            ((CovercrossBin)expression).setBinDomains(crossItemDomains);
                            expression.evaluate(scenario, currentInstanceScope);
                        }
                    }
                    finally {
                        var22_24 = restoreValues.entrySet().iterator();
                        if (true) ** GOTO lbl79
                    }
                    {
                    }
                    do {
                        restoreValueEntry = var22_24.next();
                        ((InstancesContainer)restoreValueEntry.getKey()).setVariableValue((Expression.Value)restoreValueEntry.getValue());
lbl79:
                        // 2 sources

                    } while (var22_24.hasNext());
                }
                catch (Solver.EvaluationException e) {
                    ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    ScenarioUtils.printError(Utils.append(new Object[]{"Cannot evaluate cross '", rfCovercross.getElabName(), "' options and bins"}), true, this.line, this.parserPath);
                }
            }
            finally {
                covergeModel.endCoverpoint(rfCovercross, coverpointInstance);
            }
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            FieldInstance coverpointInstance;
            CoverageModel covergeModel;
            RfField rfCoverpoint;
            block6: {
                rfCoverpoint = SemanticUtils.getTransientResult(RfField.class, this.id);
                covergeModel = scenario.getSolver().getCovergeModel();
                coverpointInstance = FieldInstance.create(rfCoverpoint, new RfStruct("[cross container]"), true, -1, -1, currentInstanceScope.runtimeId, scenario);
                currentInstanceScope.addChildFieldInstance(this.id.getText(), coverpointInstance, false);
                this.evaluateOptionsAndBins(scenario, currentInstanceScope, rfCoverpoint, coverpointInstance, covergeModel);
                if (this.iffExpr == null) break block6;
                List<Expression.ExprAndDep<Expression.Value>> iffExprValue = this.iffExpr.evaluate(scenario, currentInstanceScope);
                if (!Expression.Value.isInteger((Expression.Value)iffExprValue.get((int)0).expr) || ((Expression.Value)iffExprValue.get((int)0).expr).getIntValue().compareTo(BigInteger.ZERO) != 0) break block6;
                return null;
            }
            try {
                LinkedHashMap<RfField, Expression.Value> crossItemValues = new LinkedHashMap<RfField, Expression.Value>();
                for (AST aST : this.crossItems) {
                    Expression.Hid hid = new Expression.Hid(Collections.singletonList(new Expression.Id(SemanticUtils.getTransientResult(RfField.class, aST))), this.line, this.parserPath);
                    List<Expression.ExprAndDep<Expression.Value>> crossItemValue = hid.evaluate(scenario, currentInstanceScope);
                    crossItemValues.put(hid.getLastField(), (Expression.Value)crossItemValue.get((int)0).expr);
                }
                for (Map.Entry entry : crossItemValues.entrySet()) {
                    RfField rfItemField = (RfField)entry.getKey();
                    FieldInstance itemFieldInstance = FieldInstance.create(rfItemField, null, true, -1, -1, currentInstanceScope.runtimeId, scenario);
                    coverpointInstance.addChildFieldInstance(ScenarioUtils.getDeduplicateName(rfItemField), itemFieldInstance, false);
                    itemFieldInstance.setVariableValue((Expression.Value)entry.getValue());
                }
                covergeModel.addCovercrossSample(rfCoverpoint, coverpointInstance, crossItemValues);
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                ScenarioUtils.printError(Utils.append("Cannot evaluate cross '", rfCoverpoint.getElabName(), "' sample"), true, this.line, this.parserPath);
            }
            return null;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                StringBuilder sb = new StringBuilder();
                sb.append(this.id.getText()).append(": cross ");
                int i = 0;
                while (i < this.crossItems.size()) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.crossItems.get(i).getText());
                    ++i;
                }
                if (this.iffExpr != null) {
                    sb.append(" iff ").append(this.iffExpr.toString(true));
                }
                if (this.bodyExpr != null && !this.bodyExpr.isEmpty()) {
                    sb.append(" ").append(this.bodyExpr.toString(false));
                }
                return sb.toString();
            });
        }
    }

    public static class CovercrossBin
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private BinKind binKind;
        private AST id1;
        private AST id2;
        private Expression binExpr;
        private transient List<InstancesContainer.GeneratedVar> crossItemVariables;

        public CovercrossBin(BinKind binKind, AST id1, AST id2, Expression binExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.binKind = binKind;
            this.id1 = id1;
            this.id2 = id2;
            this.binExpr = binExpr;
        }

        public BinKind getBinKind() {
            return this.binKind;
        }

        public void setBinDomains(List<InstancesContainer.GeneratedVar> crossItemVariables) {
            this.crossItemVariables = crossItemVariables;
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            Solver solver = scenario.getSolver();
            CoverageModel covergeModel = solver.getCovergeModel();
            try {
                BigInteger nofBins = BigInteger.ONE;
                for (InstancesContainer.GeneratedVar crossItemDomain : this.crossItemVariables) {
                    nofBins = nofBins.multiply(crossItemDomain.getIntVariable().getDomain().size());
                }
                this.crossItemsIterator(scenario, currentInstanceScope, 0, covergeModel, null, new AtomicInteger(0));
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                ScenarioUtils.printError("Cannot evaluate coverpoint bins specification", true, this.line, this.parserPath);
            }
            return null;
        }

        private void crossItemsIterator(Scenario scenario, InstancesContainer currentInstanceScope, int index, CoverageModel covergeModel, CrossDomain currentDomain, AtomicInteger binCount) {
            if (index >= this.crossItemVariables.size()) {
                BigInteger value;
                if (this.binExpr != null && (value = ((Expression.Value)this.binExpr.evaluate((Scenario)scenario, (InstancesContainer)currentInstanceScope).get((int)0).expr).getIntValue()).equals(BigInteger.ZERO)) {
                    return;
                }
                Expression expr = new Expression(-1, null){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public LazyString toString(boolean enclosed) {
                        return LazyString.create(() -> "");
                    }

                    @Override
                    public List<Expression.ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
                        ArrayList<Expression.ExprAndDep<IntVariable>> result = new ArrayList<Expression.ExprAndDep<IntVariable>>();
                        for (InstancesContainer.GeneratedVar crossItemVariable : crossItemVariables) {
                            IntVariable intVariable = crossItemVariable.instance.getVariable(model, null, crossItemVariable.instance.getHierarchicalPath(), variableSolverMap, false);
                            result.add(new Expression.ExprAndDep<IntVariable>(intVariable, Collections.emptyList(), Collections.emptyList(), LazyString.create(() -> intVariable.getName()), this.line));
                        }
                        return result;
                    }

                    @Override
                    public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
                        return null;
                    }

                    @Override
                    public boolean isRand() {
                        return true;
                    }

                    @Override
                    public boolean isRuntime() {
                        return false;
                    }

                    @Override
                    public boolean isUninitActionHandle() {
                        return false;
                    }

                    @Override
                    public boolean isIndex() {
                        return false;
                    }

                    @Override
                    public boolean isConstant() {
                        return false;
                    }

                    @Override
                    public List<Expression.ExpressionError> getErrors() {
                        return null;
                    }

                    @Override
                    public void cleanErrors() {
                    }
                };
                covergeModel.addCovercrossBin(this.binKind, expr, Utils.append(this.id1.getText(), "[", binCount.get(), "]"), currentDomain, this.line, this.parserPath);
                binCount.incrementAndGet();
                return;
            }
            InstancesContainer.GeneratedVar variable = this.crossItemVariables.get(index);
            IntDomain domain = (IntDomain)variable.getIntVariable().getDomain();
            Iterator domainIterator = domain.iterator();
            Solver solver = scenario.getSolver();
            while (domainIterator.hasNext()) {
                solver.checkInterrupted();
                CrossDomain crossDomain = index == 0 ? new CrossDomain() : new CrossDomain(currentDomain);
                BigInteger intValue = (BigInteger)domainIterator.next();
                Expression.Value value = Expression.Value.from(intValue, variable.instance.nofBits(), variable.instance.hasSign());
                variable.instance.setVariableValue(value);
                crossDomain.values.add(value);
                this.crossItemsIterator(scenario, currentInstanceScope, index + 1, covergeModel, crossDomain, binCount);
            }
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                StringBuilder sb = new StringBuilder().append(this.binKind.name().toLowerCase()).append(" ");
                sb.append(this.id1.getText()).append(" ");
                sb.append(this.id2.getText());
                sb.append(" = ").append(this.binExpr.toString(false));
                return sb.toString();
            });
        }
    }

    public static class Coverpoint
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private AST id;
        private Expression expr;
        private Expression iffExpr;
        private Expression.ListExpression bodyExpr;

        public Coverpoint(AST id, Expression expr, Expression iffExpr, Expression.ListExpression bodyExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.id = id;
            this.expr = expr;
            this.iffExpr = iffExpr;
            this.bodyExpr = bodyExpr;
        }

        private RfField getCoverpoint() {
            try {
                return this.id == null ? ((Expression.Hid)this.expr).getLastField() : SemanticUtils.getTransientResult(RfField.class, this.id);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                ScenarioUtils.printError("Cannot evaluate coverpoint", true, this.line, this.parserPath);
                return null;
            }
        }

        private void evaluateOptionsAndBins(Scenario scenario, InstancesContainer currentInstanceScope, RfField rfCoverpoint, FieldInstance coverpointInstance, CoverageModel covergeModel) {
            try {
                if (!covergeModel.startCoverpoint(rfCoverpoint, coverpointInstance)) {
                    return;
                }
                try {
                    List<Expression> expressions = this.bodyExpr.getExpressions();
                    for (Expression expression : expressions) {
                        if (!(expression instanceof CoverageOption)) continue;
                        expression.evaluate(scenario, currentInstanceScope);
                    }
                    ArrayList<IntDomain> excludedBinDomains = new ArrayList<IntDomain>();
                    ArrayList<IntDomain> validBinDomains = new ArrayList<IntDomain>();
                    for (Expression expression : expressions) {
                        if (!(expression instanceof CoverpointBin) || ((CoverpointBin)expression).getBinKind() == BinKind.BIN) continue;
                        ((CoverpointBin)expression).setBinDomains(excludedBinDomains, validBinDomains);
                        ((CoverpointBin)expression).setCoverpointExpr(this.expr);
                        expression.evaluate(scenario, currentInstanceScope);
                    }
                    boolean hasAutoBins = true;
                    CoverpointBin defaultExpression = null;
                    for (Expression expression : expressions) {
                        if (!(expression instanceof CoverpointBin) || ((CoverpointBin)expression).getBinKind() != BinKind.BIN) continue;
                        ((CoverpointBin)expression).setBinDomains(excludedBinDomains, validBinDomains);
                        ((CoverpointBin)expression).setCoverpointExpr(this.expr);
                        if (!((CoverpointBin)expression).isDefault()) {
                            expression.evaluate(scenario, currentInstanceScope);
                        } else {
                            defaultExpression = (CoverpointBin)expression;
                        }
                        hasAutoBins = false;
                    }
                    if (defaultExpression != null) {
                        defaultExpression.setBinDomains(excludedBinDomains, validBinDomains);
                        defaultExpression.evaluate(scenario, currentInstanceScope);
                    } else if (hasAutoBins) {
                        EAST autoId = new EAST();
                        autoId.setText("auto");
                        CoverpointBin expression = new CoverpointBin(BinKind.BIN, (AST)autoId, null, null, this.line, this.parserPath);
                        expression.setBinDomains(excludedBinDomains, validBinDomains);
                        expression.setCoverpointExpr(this.expr);
                        ((Expression)expression).evaluate(scenario, currentInstanceScope);
                    }
                }
                catch (Solver.EvaluationException e) {
                    ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    ScenarioUtils.printError(Utils.append("Cannot evaluate coverpoint '", rfCoverpoint.getElabName(), "' options and bins"), true, this.line, this.parserPath);
                }
            }
            finally {
                covergeModel.endCoverpoint(rfCoverpoint, coverpointInstance);
            }
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            FieldInstance coverpointInstance;
            CoverageModel covergeModel;
            RfField rfCoverpoint;
            block7: {
                rfCoverpoint = this.getCoverpoint();
                if (rfCoverpoint == null) {
                    return null;
                }
                covergeModel = scenario.getSolver().getCovergeModel();
                String coverpointName = this.id != null ? this.id.getText() : ScenarioUtils.getDeduplicateName(rfCoverpoint);
                RfNamedElement rfFieldType = Utils.getAssociatedType(rfCoverpoint);
                coverpointInstance = currentInstanceScope.getFieldInstance(CoverageExpression.COVERPOINT_NAME_PREFIX + coverpointName);
                if (coverpointInstance == null) {
                    coverpointInstance = FieldInstance.create(rfCoverpoint, rfFieldType, false, -1, -1, currentInstanceScope.runtimeId, scenario);
                    currentInstanceScope.addChildFieldInstance(CoverageExpression.COVERPOINT_NAME_PREFIX + coverpointName, coverpointInstance, false);
                }
                this.evaluateOptionsAndBins(scenario, currentInstanceScope, rfCoverpoint, coverpointInstance, covergeModel);
                if (this.iffExpr == null) break block7;
                List<Expression.ExprAndDep<Expression.Value>> iffExprValue = this.iffExpr.evaluate(scenario, currentInstanceScope);
                if (!Expression.Value.isInteger((Expression.Value)iffExprValue.get((int)0).expr) || ((Expression.Value)iffExprValue.get((int)0).expr).getIntValue().compareTo(BigInteger.ZERO) != 0) break block7;
                return null;
            }
            try {
                List<Expression.ExprAndDep<Expression.Value>> exprValue = this.expr.evaluate(scenario, currentInstanceScope);
                if (coverpointInstance != null) {
                    coverpointInstance.setVariableValue((Expression.Value)exprValue.get((int)0).expr);
                }
                covergeModel.addCoverpointSample(rfCoverpoint, coverpointInstance, (Expression.Value)exprValue.get((int)0).expr);
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                ScenarioUtils.printError(Utils.append("Cannot evaluate coverpoint '", rfCoverpoint.getElabName(), "' sample"), true, this.line, this.parserPath);
            }
            return null;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                StringBuilder sb = new StringBuilder();
                if (this.id != null) {
                    sb.append(this.id.getText()).append(": ");
                }
                sb.append("coverpoint ").append(this.expr.toString(false));
                if (this.iffExpr != null) {
                    sb.append(" iff ").append(this.iffExpr.toString(true));
                }
                if (this.bodyExpr != null && !this.bodyExpr.isEmpty()) {
                    sb.append(" ").append(this.bodyExpr.toString(false));
                }
                return sb.toString();
            });
        }
    }

    public static class CoverpointBin
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private BinKind binKind;
        private AST id;
        private Expression coverpointExpr;
        private Expression nofBinsExpr;
        private Expression binExpr;
        private transient List<IntDomain> excludedBinDomains;
        private transient List<IntDomain> validBinDomains;

        public CoverpointBin(BinKind binsKind, AST id, Expression nofBinsExpr, Expression binExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.binKind = binsKind;
            this.id = id;
            this.nofBinsExpr = nofBinsExpr;
            this.binExpr = binExpr;
        }

        public void setCoverpointExpr(Expression coverpointExpr) {
            this.coverpointExpr = coverpointExpr;
        }

        public boolean isDefault() {
            return this.binExpr instanceof BinDefault;
        }

        public void setBinDomains(List<IntDomain> excludedBinDomains, List<IntDomain> validBinDomains) {
            this.excludedBinDomains = excludedBinDomains;
            this.validBinDomains = validBinDomains;
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            Solver solver = scenario.getSolver();
            CoverageModel covergeModel = solver.getCovergeModel();
            try {
                BigInteger nofBinValues;
                BigInteger nofLastBinValues;
                BigInteger nofValues;
                Expression binRangeExpr = this.binExpr instanceof BinWith ? ((BinWith)this.binExpr).expr : this.binExpr;
                Expression binWithExpr = this.binExpr instanceof BinWith ? ((BinWith)this.binExpr).withExpr : new Expression.IntExpression("1", BigInteger.ONE, true, this.line, this.parserPath);
                InstancesContainer coverpointInstance = covergeModel.getCoverpointInstance();
                IntDomain variableDomain = this.getVariableDomain(solver, coverpointInstance);
                boolean isEnumType = coverpointInstance.isEnumType();
                BigInteger nofBins = null;
                nofBins = isEnumType ? variableDomain.size() : (this.nofBinsExpr instanceof BinDomainSize ? variableDomain.size() : (this.nofBinsExpr != null ? ((Expression.Value)this.nofBinsExpr.evaluate((Scenario)scenario, (InstancesContainer)currentInstanceScope).get((int)0).expr).getIntValue() : BigInteger.valueOf(covergeModel.getAutoBinMax())));
                if (binRangeExpr instanceof BinRange) {
                    IntDomain binRangeDomain = ((BinRange)binRangeExpr).toIntDomain(scenario, currentInstanceScope, variableDomain);
                    if (binRangeDomain.isEmpty()) {
                        throw new Solver.EvaluationException("Empty bins domain is not supported", this.line, this.parserPath);
                    }
                    List binSubDomains = binRangeDomain.getSubDomains();
                    for (IntDomain.IntSubDomain binSubDomain : binSubDomains) {
                        if (variableDomain.contains(binSubDomain.getLowerBound()) && variableDomain.contains(binSubDomain.getUpperBound())) continue;
                        ScenarioUtils.printWarning(Utils.append("Bins subdomain [", binSubDomain, "] contains values out of variable domain ", variableDomain), true, this.line, this.parserPath);
                    }
                    variableDomain = (IntDomain)variableDomain.intersect((IDomain)binRangeDomain);
                } else if (binRangeExpr instanceof BinDefault) {
                    variableDomain = this.getDefaultDomain(variableDomain);
                } else if (!(binRangeExpr instanceof Expression.Hid) && binRangeExpr != null) {
                    throw new UnsupportedOperationException();
                }
                if (this.binExpr instanceof BinWith) {
                    Iterator valueIterator = variableDomain.iterator();
                    IntDomain newVariableDomain = new IntDomain();
                    while (valueIterator.hasNext()) {
                        solver.checkInterrupted();
                        BigInteger currentValue = (BigInteger)valueIterator.next();
                        coverpointInstance.setVariableValue(Expression.Value.from(currentValue, coverpointInstance.nofBits(), coverpointInstance.hasSign()));
                        if (((Expression.Value)binWithExpr.evaluate((Scenario)scenario, (InstancesContainer)currentInstanceScope).get((int)0).expr).getIntValue().equals(BigInteger.ZERO)) continue;
                        newVariableDomain.append(currentValue);
                    }
                    variableDomain = newVariableDomain;
                }
                if ((nofValues = variableDomain.size()).compareTo(nofBins) < 0) {
                    nofBins = nofValues;
                }
                if ((nofLastBinValues = nofValues.subtract((nofBinValues = nofValues.divide(nofBins)).multiply(nofBins)).add(nofBinValues)).compareTo(BigInteger.ZERO) < 0) {
                    nofLastBinValues = BigInteger.ZERO;
                }
                BigInteger offset = variableDomain.getLowerBound();
                RfEnumItem[] enumItems = isEnumType ? ((RfEnumType)coverpointInstance.getRfFieldType()).getEnumItems() : null;
                int nofBinIntValue = nofBins.intValue();
                int i = 0;
                while (i < nofBinIntValue) {
                    boolean isLastBin = i == nofBinIntValue - 1;
                    IntDomain binDomain = variableDomain.getBinsDomain(offset, isLastBin ? nofLastBinValues : nofBinValues);
                    if (!binDomain.isEmpty()) {
                        offset = variableDomain.next(binDomain.getUpperBound());
                        switch (this.binKind) {
                            case IGNORE: {
                                this.excludedBinDomains.add(binDomain);
                                break;
                            }
                            case ILLEGAL: {
                                this.excludedBinDomains.add(binDomain);
                                if (enumItems != null) {
                                    covergeModel.addCoverpointBin(this.binKind, this.coverpointExpr, enumItems[i].getElabName(), binDomain, this.line, this.parserPath);
                                    break;
                                }
                                if (nofBinIntValue == 1) {
                                    covergeModel.addCoverpointBin(this.binKind, this.coverpointExpr, this.id.getText(), binDomain, this.line, this.parserPath);
                                    break;
                                }
                                covergeModel.addCoverpointBin(this.binKind, this.coverpointExpr, Utils.append(this.id.getText(), "[", i, "]"), binDomain, this.line, this.parserPath);
                                break;
                            }
                            case BIN: {
                                this.validBinDomains.add(binDomain);
                                for (IntDomain excludedBinsDomain : this.excludedBinDomains) {
                                    if ((binDomain = binDomain.remove(excludedBinsDomain.getLowerBound(), excludedBinsDomain.getUpperBound())).isEmpty()) break;
                                }
                                if (binDomain.isEmpty()) break;
                                if (enumItems != null) {
                                    covergeModel.addCoverpointBin(this.binKind, this.coverpointExpr, enumItems[i].getElabName(), binDomain, this.line, this.parserPath);
                                    break;
                                }
                                if (nofBinIntValue == 1) {
                                    covergeModel.addCoverpointBin(this.binKind, this.coverpointExpr, this.id.getText(), binDomain, this.line, this.parserPath);
                                    break;
                                }
                                covergeModel.addCoverpointBin(this.binKind, this.coverpointExpr, Utils.append(this.id.getText(), "[", i, "]"), binDomain, this.line, this.parserPath);
                                break;
                            }
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                ScenarioUtils.printError("Cannot evaluate coverpoint bins specification", true, this.line, this.parserPath);
            }
            return null;
        }

        private IntDomain getVariableDomain(Solver solver, InstancesContainer coverpointInstance) {
            int debugLevel = solver.CONFIG_DEBUG_LEVEL;
            try {
                solver.CONFIG_DEBUG_LEVEL = 0;
                IntVariable coverpointVariable = coverpointInstance.getVariable(new Model(null, null), null, coverpointInstance.getHierarchicalPath(), new HashMap<String, InstancesContainer.GeneratedVar>(), false);
                IntDomain intDomain = (IntDomain)coverpointVariable.getDomain();
                return intDomain;
            }
            finally {
                solver.CONFIG_DEBUG_LEVEL = debugLevel;
            }
        }

        private IntDomain getDefaultDomain(IntDomain variableDomain) {
            IntDomain defaultDomain = variableDomain.copy();
            for (IntDomain validBinDomain : this.validBinDomains) {
                if ((defaultDomain = defaultDomain.remove(validBinDomain.getLowerBound(), validBinDomain.getUpperBound())).isEmpty()) break;
            }
            return defaultDomain;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                StringBuilder sb = new StringBuilder().append(this.binKind.name().toLowerCase()).append(" ");
                sb.append(this.id.getText());
                if (this.nofBinsExpr != null) {
                    sb.append("[").append(this.nofBinsExpr.toString(false)).append("]");
                }
                if (this.binExpr != null) {
                    sb.append(" = ").append(this.binExpr.toString(false));
                }
                return sb.toString();
            });
        }

        public BinKind getBinKind() {
            return this.binKind;
        }
    }

    public static class CrossDomain {
        private List<Expression.Value> values;

        public CrossDomain() {
            this.values = new ArrayList<Expression.Value>();
        }

        public CrossDomain(CrossDomain domain) {
            this.values = new ArrayList<Expression.Value>(domain.values);
        }

        public String toString() {
            return this.values.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CrossDomain other = (CrossDomain)obj;
            return !(this.values == null ? other.values != null : !this.values.equals(other.values));
        }

        public List<Expression.Value> getValues() {
            return this.values;
        }

        public CoverageModel.IntCrossDomain getDomain() {
            ArrayList<BigInteger> bigIntegerValues = new ArrayList<BigInteger>(this.values.size());
            for (Expression.Value value : this.values) {
                bigIntegerValues.add(value.getIntValue());
            }
            return new CoverageModel.IntCrossDomain(bigIntegerValues);
        }
    }

    public static class InlineCovergroup
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private String instanceName;
        private RfCovergroup rfCovergroup;
        private Expression.ListExpression bodyExpr;

        public InlineCovergroup(RfCovergroup rfCovergroup, String instanceName, Expression.ListExpression bodyExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.instanceName = instanceName;
            this.rfCovergroup = rfCovergroup;
            this.bodyExpr = bodyExpr;
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            block7: {
                CoverageModel covergeModel = scenario.getSolver().getCovergeModel();
                try {
                    covergeModel.startCovergroup(this.rfCovergroup, this.instanceName, currentInstanceScope, true);
                    NestedBlockContext covergroupCallContext = new NestedBlockContext("[block]", currentInstanceScope.runtimeId, currentInstanceScope, scenario);
                    this.bodyExpr.evaluate(scenario, covergroupCallContext);
                }
                catch (Solver.EvaluationException e) {
                    ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                    covergeModel.endCovergroup(this.rfCovergroup, currentInstanceScope);
                    break block7;
                }
                catch (Exception e) {
                    try {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        covergeModel.endCovergroup(this.rfCovergroup, currentInstanceScope);
                    }
                }
                covergeModel.endCovergroup(this.rfCovergroup, currentInstanceScope);
            }
            return Collections.singletonList(new Expression.ExprAndDep<Expression.Value>(Expression.Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                StringBuilder sb = new StringBuilder("covergroup ").append(this.rfCovergroup.getElabName()).append(this.bodyExpr.toString(false));
                return sb.toString();
            });
        }
    }

    public static class InstanceCovergroup
    extends CoverageExpression {
        private static final long serialVersionUID = 1L;
        private String instanceName;
        private RfCovergroup rfCovergroup;
        private Map<RfNamedElement, Expression> arguments;
        private Expression.ListExpression bodyExpr;
        private Expression.ListExpression options;

        public InstanceCovergroup(RfCovergroup rfCovergroup, String instanceName, Map<RfNamedElement, Expression> arguments, Expression.ListExpression bodyExpr, Expression.ListExpression options, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.instanceName = instanceName;
            this.rfCovergroup = rfCovergroup;
            this.arguments = arguments;
            this.bodyExpr = bodyExpr;
            this.options = options;
        }

        @Override
        public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            block8: {
                CoverageModel covergeModel = scenario.getSolver().getCovergeModel();
                try {
                    covergeModel.startCovergroup(this.rfCovergroup, this.instanceName, currentInstanceScope, false);
                    if (this.options != null) {
                        this.options.evaluate(scenario, currentInstanceScope);
                    }
                    CovergroupCallContext covergroupCallContext = CovergroupCallContext.create(scenario.getSolver(), currentInstanceScope, this.rfCovergroup, this.arguments);
                    this.bodyExpr.evaluate(scenario, covergroupCallContext);
                }
                catch (Solver.EvaluationException e) {
                    ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                    covergeModel.endCovergroup(this.rfCovergroup, currentInstanceScope);
                    break block8;
                }
                catch (Exception e) {
                    try {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        covergeModel.endCovergroup(this.rfCovergroup, currentInstanceScope);
                    }
                }
                covergeModel.endCovergroup(this.rfCovergroup, currentInstanceScope);
            }
            return Collections.singletonList(new Expression.ExprAndDep<Expression.Value>(Expression.Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                StringBuilder sb = new StringBuilder("covergroup ").append(ScenarioUtils.getDeduplicateName(this.rfCovergroup)).append("(");
                boolean isFirst = true;
                for (Map.Entry<RfNamedElement, Expression> argument : this.arguments.entrySet()) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(".").append(argument.getKey().getElabName()).append("(").append(argument.getValue().toString(false)).append(")");
                    isFirst = false;
                }
                sb.append(") ").append(this.bodyExpr.toString(false)).append(" with ").append(this.options.toString(false));
                return sb.toString();
            });
        }
    }
}

