/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.ConstraintDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.CoverageExpression;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.coverage.CoverageView;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.parser.BinKind;

public enum CoverageModel {
    INSTANCE;

    private Map<RfCovergroup, Covergroup> covergroups = new IdentityHashMap<RfCovergroup, Covergroup>();
    private Map<String, CoverpointInstance> perInstanceCoverpoints = new LinkedHashMap<String, CoverpointInstance>();
    private Map<RfField, CoverpointInstance> perScopeCoverpoints = new LinkedHashMap<RfField, CoverpointInstance>();
    private InstancesContainer coverpointInstance;
    private List<DataSample> coverageDataSamples = new ArrayList<DataSample>();
    private transient Covergroup currentCovergroup;
    private transient Coverpoint currentCoverpoint;
    private transient ICoverageMember currentCoverageMember;
    private RfStruct prevRootAction;

    public void reset() {
        this.coverpointInstance = null;
        this.currentCovergroup = null;
        this.currentCoverpoint = null;
        this.currentCoverageMember = null;
        this.covergroups.clear();
        this.coverageDataSamples.clear();
        this.perScopeCoverpoints.clear();
        this.perInstanceCoverpoints.clear();
        this.viewUpdate();
    }

    private final void viewUpdate() {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                CoverageView view = (CoverageView)ViewsUtils.getViewById((String)"ro.amiq.pssdt.coverage.ScenarioCoverageView", (boolean)true);
                if (view == null) {
                    return;
                }
                view.update(null);
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public final void resetOnChange(RfStruct rootAction) {
        if (rootAction == this.prevRootAction) {
            return;
        }
        this.reset();
        this.prevRootAction = rootAction;
    }

    public final void startCovergroup(RfCovergroup rfCovergroup, String instanceName, InstancesContainer currentInstanceScope, boolean isInlineCovergroup) {
        this.currentCovergroup = this.covergroups.get(rfCovergroup);
        if (this.currentCovergroup == null) {
            this.currentCovergroup = new Covergroup(instanceName, new Options());
        }
        this.currentCoverageMember = this.currentCovergroup;
        this.covergroups.put(rfCovergroup, this.currentCovergroup);
    }

    public final void endCovergroup(RfCovergroup rfCovergroup, InstancesContainer currentInstanceScope) {
        this.currentCovergroup = null;
        this.currentCoverageMember = this.currentCoverpoint;
    }

    public final boolean startCoverpoint(RfField rfCoverpoint, FieldInstance coverpointInstance) {
        this.coverpointInstance = coverpointInstance;
        this.currentCoverpoint = this.currentCovergroup.getCoverpoint(rfCoverpoint);
        if (this.currentCoverpoint != null) {
            this.currentCoverageMember = this.currentCoverpoint;
            return false;
        }
        this.currentCoverpoint = new Coverpoint(rfCoverpoint, this.currentCovergroup);
        this.currentCovergroup.addCoverpoint(rfCoverpoint, this.currentCoverpoint);
        this.currentCoverageMember = this.currentCoverpoint;
        return true;
    }

    public final void endCoverpoint(RfField rfCoverpoint, FieldInstance coverpointInstance) {
        if (this.currentCoverpoint.options.per_instance || this.currentCovergroup.options.per_instance) {
            CoverpointInstance coverpoint = CoverpointInstance.create(this.currentCoverpoint, coverpointInstance.getInstancePath().toString());
            if (!this.perInstanceCoverpoints.containsKey(coverpoint.getName())) {
                this.perInstanceCoverpoints.put(coverpoint.getName(), coverpoint);
                coverpoint.setPerInstanceScope(coverpointInstance);
            }
        } else if (!this.perScopeCoverpoints.containsKey(rfCoverpoint)) {
            RfStruct enclosingStruct = rfCoverpoint.getEnclosingScope(RfStruct.class);
            String name = Utils.append(enclosingStruct.getName(), ".", this.currentCoverpoint.covergroup.getName(), ".", rfCoverpoint.getName());
            CoverpointInstance coverpoint = CoverpointInstance.create(this.currentCoverpoint, name);
            this.perScopeCoverpoints.put(rfCoverpoint, coverpoint);
        }
        rfCoverpoint = null;
        this.currentCoverpoint = null;
        coverpointInstance = null;
        this.currentCoverageMember = this.currentCoverpoint;
    }

    public final void setOption(String optionName, Expression.Value optionValue) {
        this.currentCoverageMember.setOption(optionName, optionValue);
    }

    public final void addCoverpointSample(RfField rfCoverpoint, InstancesContainer coverpointInstance, Expression.Value sampleValue) {
        DataSample dataSample = new DataSample(rfCoverpoint, coverpointInstance.getInstancePath().toString(), rfCoverpoint.getElabName(), sampleValue);
        this.coverageDataSamples.add(dataSample);
    }

    public final void addCovercrossSample(RfField rfCovercross, InstancesContainer coverpointInstance, LinkedHashMap<RfField, Expression.Value> sampleValue) {
        DataSample dataSample = new DataSample(rfCovercross, coverpointInstance.getInstancePath().toString(), rfCovercross.getElabName(), sampleValue.values());
        this.coverageDataSamples.add(dataSample);
    }

    protected final InstancesContainer getCoverpointInstance() {
        return this.coverpointInstance;
    }

    public final int getAutoBinMax() {
        return this.currentCoverageMember.getOptions().auto_bin_max;
    }

    public final void addCoverpointBin(BinKind binKind, Expression coverpointExpr, String binName, IntDomain binDomain, int line, ParserPath parserPath) {
        Bin bin = new Bin(binKind, binName, binDomain, coverpointExpr, this.currentCoverpoint, line, parserPath);
        this.currentCoverpoint.addBin(bin);
        ScenarioUtils.print(Utils.append("\u2007   ", binName, " : ", binDomain));
    }

    public final void addCovercrossBin(BinKind binKind, Expression coverpointExpr, String binName, CoverageExpression.CrossDomain crossBinDomain, int line, ParserPath parserPath) {
        IntCrossDomain binDomain = crossBinDomain.getDomain();
        Bin bin = new Bin(binKind, binName, binDomain, coverpointExpr, this.currentCoverpoint, line, parserPath);
        this.currentCoverpoint.addBin(bin);
        ScenarioUtils.print(Utils.append(new Object[]{"\u2007   ", binName, " : ", binDomain}));
    }

    public final void init() {
        List<BinInstance> bins;
        for (CoverpointInstance coverpoint : this.perScopeCoverpoints.values()) {
            bins = coverpoint.getBins();
            for (BinInstance bin : bins) {
                if (!bin.createFillConstraint()) continue;
                return;
            }
        }
        for (CoverpointInstance coverpoint : this.perInstanceCoverpoints.values()) {
            bins = coverpoint.getBins();
            for (BinInstance bin : bins) {
                if (!bin.createFillConstraint()) continue;
                return;
            }
        }
    }

    public final void computeCoverage() {
        if (this.coverageDataSamples.isEmpty()) {
            return;
        }
        ScenarioUtils.print(Utils.append("*** Info: Coverage results (", this.coverageDataSamples.size(), " samples):"));
        for (DataSample dataSample : this.coverageDataSamples) {
            CoverpointInstance coverpoint = this.perScopeCoverpoints.get(dataSample.rfCoverpoint);
            if (coverpoint == null) {
                coverpoint = this.perInstanceCoverpoints.get(dataSample.instancePath);
            }
            coverpoint.addSample(dataSample.value);
        }
        for (CoverpointInstance coverpoint : this.perScopeCoverpoints.values()) {
            ScenarioUtils.print(Utils.append("*** Note: Cover point '", coverpoint.getName(), "' coverage: ", coverpoint.coverInfo().toString()));
            coverpoint.printCoverage();
        }
        for (CoverpointInstance coverpoint : this.perInstanceCoverpoints.values()) {
            ScenarioUtils.print(Utils.append("*** Note: Cover point '", coverpoint.getName(), "' coverage: ", coverpoint.coverInfo().toString()));
            coverpoint.printCoverage();
        }
        this.viewUpdate();
    }

    public final Collection<CoverpointInstance> getPerInstanceCoverpoints() {
        return this.perInstanceCoverpoints.values();
    }

    public final Collection<CoverpointInstance> getPerScopeCoverpoints() {
        return this.perScopeCoverpoints.values();
    }

    public final int getNofCoverpoints() {
        return this.perScopeCoverpoints.size() + this.perInstanceCoverpoints.size();
    }

    public final int getNofCovergroups() {
        int coverpointNameIndex;
        HashSet<String> covergroups = new HashSet<String>();
        for (CoverpointInstance coverpoint : this.perScopeCoverpoints.values()) {
            coverpointNameIndex = coverpoint.getName().lastIndexOf(46);
            covergroups.add(coverpoint.getName().substring(0, coverpointNameIndex));
        }
        for (CoverpointInstance coverpoint : this.perInstanceCoverpoints.values()) {
            coverpointNameIndex = coverpoint.getName().lastIndexOf(46);
            covergroups.add(coverpoint.getName().substring(0, coverpointNameIndex));
        }
        return covergroups.size();
    }

    public static class Bin {
        protected Coverpoint coverpoint;
        protected BinKind binKind;
        protected String name;
        protected Expression coverpointExpr;
        protected IntDomain binDomain;
        protected int line;
        protected ParserPath parserPath;

        public Bin(BinKind binKind, String name, IntDomain binDomain, Expression coverpointExpr, Coverpoint coverpoint, int line, ParserPath parserPath) {
            this.binKind = binKind;
            this.name = name;
            this.binDomain = binDomain;
            this.coverpointExpr = coverpointExpr;
            this.coverpoint = coverpoint;
            this.line = line;
            this.parserPath = parserPath;
        }

        public boolean isCoverCross() {
            return this.binDomain instanceof IntCrossDomain;
        }

        public String toString() {
            return Utils.append(this.name, ": domain ", this.binDomain);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class BinInstance
    extends Bin
    implements ICoverageInstanceElement {
        private IntDomain[] coverDomains;
        private boolean isEnableFill;

        public BinInstance(Bin bin) {
            super(bin.binKind, bin.name, bin.binDomain, bin.coverpointExpr, bin.coverpoint, bin.line, bin.parserPath);
            int atLeast = bin.coverpoint.options.at_least;
            boolean isCoverCross = bin.isCoverCross();
            this.coverDomains = isCoverCross ? new IntCrossDomain[atLeast] : new IntDomain[atLeast];
            int i = 0;
            while (i < atLeast) {
                this.coverDomains[i] = isCoverCross ? new IntCrossDomain() : new IntDomain();
                ++i;
            }
        }

        public void setPerInstanceScope(FieldInstance fieldInstance) {
        }

        @Override
        public CoverInfo coverInfo() {
            IntDomain coverDomain = this.coverDomains[0].copy();
            int i = 1;
            while (i < this.coverDomains.length) {
                coverDomain = (IntDomain)coverDomain.intersect((IDomain)this.coverDomains[i]);
                ++i;
            }
            return new CoverInfo((float)coverDomain.size().intValue() * 100.0f / (float)this.binDomain.size().intValue(), this.binDomain.size().intValue(), coverDomain.size().intValue());
        }

        public void addCrossSample(BigInteger[] value) {
            if (!((IntCrossDomain)this.binDomain).contains(value)) {
                return;
            }
            if (this.binKind == BinKind.ILLEGAL) {
                ScenarioUtils.printError(Utils.append("Illegal value ", value, " of '", this.coverpoint.getName(), "'"), false, this.line, this.parserPath);
                throw new Solver.InterruptException();
            }
            IntDomain[] intDomainArray = this.coverDomains;
            int n = this.coverDomains.length;
            int n2 = 0;
            while (n2 < n) {
                IntDomain coverDomain = intDomainArray[n2];
                if (!((IntCrossDomain)coverDomain).contains(value)) {
                    ScenarioUtils.print(Utils.append("*** Note: Hit bin '", this.name, "' value = ", Arrays.toString(value)));
                    ((IntCrossDomain)coverDomain).append(value);
                    break;
                }
                ++n2;
            }
        }

        public void addSample(BigInteger value) {
            if (!this.binDomain.contains(value)) {
                return;
            }
            if (this.binKind == BinKind.ILLEGAL) {
                ScenarioUtils.printError(Utils.append("Illegal value ", value, " of '", this.coverpoint.getName(), "'"), false, this.line, this.parserPath);
                throw new Solver.InterruptException();
            }
            IntDomain[] intDomainArray = this.coverDomains;
            int n = this.coverDomains.length;
            int n2 = 0;
            while (n2 < n) {
                IntDomain coverDomain = intDomainArray[n2];
                if (!coverDomain.contains(value)) {
                    ScenarioUtils.print(Utils.append("*** Note: Hit bin '", this.name, "' value = ", value));
                    coverDomain.append(value);
                    break;
                }
                ++n2;
            }
        }

        public IntDomain getCoveredDomain() {
            IntDomain result = this.coverDomains[0].copy();
            IntDomain[] intDomainArray = this.coverDomains;
            int n = this.coverDomains.length;
            int n2 = 0;
            while (n2 < n) {
                IntDomain coverDomain = intDomainArray[n2];
                result = (IntDomain)result.intersect((IDomain)coverDomain);
                ++n2;
            }
            return result;
        }

        @Override
        public Image getImage() {
            return DVTImages.imageCache.getImage(DVTImages.COVER_BIN);
        }

        @Override
        public RfNamedElement getRfElement() {
            return this.coverpoint.rfCoverpoint;
        }

        @Override
        public void enableFill(boolean isEnableFill) {
            this.isEnableFill = isEnableFill;
        }

        public boolean createFillConstraint() {
            if (!this.isEnableFill) {
                return false;
            }
            if (this.coverpointExpr == null) {
                return false;
            }
            IntDomain coverDomain = this.coverDomains[0].copy();
            int i = 1;
            while (i < this.coverDomains.length) {
                coverDomain = (IntDomain)coverDomain.intersect((IDomain)this.coverDomains[i]);
                ++i;
            }
            final IntDomain inDomain = this.binDomain.remove((IDomain)coverDomain);
            if (inDomain.isEmpty()) {
                return false;
            }
            ScenarioUtils.getSolver().addConstraintDescriptor(this.getRfElement().getEnclosingScope(RfStruct.class), new ConstraintDescriptor(this.getName(), null, false, 0, true){
                private static final long serialVersionUID = 1L;

                @Override
                public void apply(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, Map<Variable, Expression.CspConstraint> cspDefaultConstraintsMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap) {
                    try {
                        if (inDomain instanceof IntCrossDomain) {
                            List<Expression.ExprAndDep<IntVariable>> leftVars = coverpointExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, isEnableFill, this.maxTraversalIndex, true);
                            int i = 0;
                            while (i < leftVars.size()) {
                                Expression.ExprAndDep<IntVariable> leftVar = leftVars.get(i);
                                IntVariable intVariable = new IntVariable(model, true, 32);
                                IntDomain domainOfVariable = ((IntCrossDomain)inDomain).getDomainOfVariable(i);
                                intVariable.setDomain((IDomain)domainOfVariable);
                                AbstractConstraint constraint = ((IntVariable)leftVar.expr).eq(intVariable);
                                constraint.post();
                                if (cspToReadableTextMap != null) {
                                    cspToReadableTextMap.put(constraint, new ConstraintDescriptor.Text(LazyString.create(() -> Utils.append("constraint fill (", Utils.processHrText(exprAndDep.hrText.toString()), " in ", domainOfVariable, ")")), -1, null));
                                }
                                ++i;
                            }
                        } else {
                            List<Expression.ExprAndDep<IntVariable>> leftVars = coverpointExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, isEnableFill, this.maxTraversalIndex, true);
                            for (Expression.ExprAndDep<IntVariable> leftVar : leftVars) {
                                IntVariable intVariable = new IntVariable(model, true, 32);
                                intVariable.setDomain((IDomain)inDomain);
                                AbstractConstraint constraint = ((IntVariable)leftVar.expr).eq(intVariable);
                                constraint.post();
                                if (cspToReadableTextMap == null) continue;
                                String covergroupName = coverpoint.covergroup.getName();
                                String coverpointName = coverpoint.getName();
                                cspToReadableTextMap.put(constraint, new ConstraintDescriptor.Text(LazyString.create(() -> Utils.append("constraint fill ", Utils.append(covergroupName, ".", coverpointName, ".", this.getName()), " (", Utils.processHrText(exprAndDep.hrText.toString()), " in ", inDomain, ")")), -1, null));
                            }
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
            return true;
        }

        @Override
        public boolean isEnableFill() {
            return this.isEnableFill;
        }

        @Override
        public String getComment() {
            return null;
        }
    }

    public static class CoverInfo {
        private float percent;
        private int totalSamples;
        private int coveredSamples;

        public CoverInfo(float percent, int totalSamples, int coveredSamples) {
            this.percent = percent;
            this.totalSamples = totalSamples;
            this.coveredSamples = coveredSamples;
        }

        public float getPercent() {
            return this.percent;
        }

        public String toString() {
            return String.format("%.2f%% (%d/%d)", Float.valueOf(this.percent), this.coveredSamples, this.totalSamples);
        }
    }

    public static class Covergroup
    implements ICoverageMember {
        private String name;
        private Options options;
        private Map<RfField, Coverpoint> coverpoints;

        public Covergroup(String name, Options options) {
            this.name = name;
            this.options = options;
            this.coverpoints = new IdentityHashMap<RfField, Coverpoint>();
        }

        @Override
        public void setOption(String optionName, Expression.Value optionValue) {
            this.options.setOption(optionName, optionValue);
        }

        @Override
        public Options getOptions() {
            return this.options;
        }

        public String getName() {
            return this.options.name != null ? this.options.name : this.name;
        }

        public void addCoverpoint(RfField rfCoverpoint, Coverpoint coverpoint) {
            this.coverpoints.put(rfCoverpoint, coverpoint);
            coverpoint.covergroup = this;
        }

        public Coverpoint getCoverpoint(RfField rfCoverpoint) {
            return this.coverpoints.get(rfCoverpoint);
        }
    }

    public static class Coverpoint
    implements ICoverageMember {
        private Covergroup covergroup;
        private String name;
        private Options options;
        private List<Bin> bins;
        private RfField rfCoverpoint;

        public Coverpoint(RfField rfCoverpoint, Covergroup covergroup) {
            this.name = ScenarioUtils.getDeduplicateName(rfCoverpoint);
            this.covergroup = covergroup;
            this.options = Options.inheritFrom(covergroup.getOptions());
            this.bins = new ArrayList<Bin>();
            this.rfCoverpoint = rfCoverpoint;
        }

        public void addBin(Bin bin) {
            this.bins.add(bin);
            bin.coverpoint = this;
        }

        @Override
        public void setOption(String optionName, Expression.Value optionValue) {
            this.options.setOption(optionName, optionValue);
        }

        @Override
        public Options getOptions() {
            return this.options;
        }

        public String getName() {
            return this.options.name != null ? this.options.name : this.name;
        }

        public Covergroup getCovergroup() {
            return this.covergroup;
        }

        private Image getImage() {
            if (this.rfCoverpoint.getFieldModifier() == FieldModifier.COVERCROSS) {
                return DVTImages.imageCache.getImage(DVTImages.COVER_CROSS);
            }
            return DVTImages.imageCache.getImage(DVTImages.COVER_ITEM);
        }
    }

    public static class CoverpointInstance
    implements ICoverageInstanceElement {
        private Coverpoint coverpoint;
        private List<BinInstance> bins;
        private String instanceName;

        public static CoverpointInstance create(Coverpoint coverpoint, String instanceName) {
            return new CoverpointInstance(coverpoint, instanceName);
        }

        private CoverpointInstance(Coverpoint coverpoint, String instanceName) {
            this.coverpoint = coverpoint;
            this.bins = new ArrayList<BinInstance>(coverpoint.bins.size());
            this.instanceName = instanceName;
            for (Bin bin : coverpoint.bins) {
                this.bins.add(new BinInstance(bin));
            }
        }

        @Override
        public String getName() {
            return this.instanceName;
        }

        public void addSample(Expression.Value[] value) {
            BigInteger[] bigIntegerValue = new BigInteger[value.length];
            int i = 0;
            while (i < value.length) {
                bigIntegerValue[i] = value[i].getIntValue();
                ++i;
            }
            for (BinInstance bin : this.bins) {
                if (bin.isCoverCross()) {
                    bin.addCrossSample(bigIntegerValue);
                    continue;
                }
                bin.addSample(bigIntegerValue[0]);
            }
        }

        @Override
        public CoverInfo coverInfo() {
            float coverPercent = 0.0f;
            int nofSamples = 0;
            int nofCoveredSamples = 0;
            for (BinInstance bin : this.bins) {
                CoverInfo coverInfo = bin.coverInfo();
                coverPercent += coverInfo.percent;
                nofSamples += coverInfo.totalSamples;
                nofCoveredSamples += coverInfo.coveredSamples;
            }
            return new CoverInfo(coverPercent /= (float)this.bins.size(), nofSamples, nofCoveredSamples);
        }

        public void printCoverage() {
            for (BinInstance bin : this.bins) {
                CoverInfo binCoverInfo = bin.coverInfo();
                if (!(binCoverInfo.percent > 0.0f)) continue;
                ScenarioUtils.print(Utils.append("\u2007   ", "      Bin '", bin.name, "' coverage: ", binCoverInfo.toString()));
            }
        }

        public List<BinInstance> getBins() {
            return this.bins;
        }

        @Override
        public Image getImage() {
            return this.coverpoint.getImage();
        }

        @Override
        public RfNamedElement getRfElement() {
            return this.coverpoint.rfCoverpoint;
        }

        @Override
        public void enableFill(boolean isEnableFill) {
            if (this.isEnableFill() == isEnableFill) {
                return;
            }
            for (BinInstance bin : this.bins) {
                bin.enableFill(isEnableFill);
            }
        }

        @Override
        public boolean isEnableFill() {
            for (BinInstance bin : this.bins) {
                if (bin.isEnableFill) continue;
                return false;
            }
            return true;
        }

        public void setPerInstanceScope(FieldInstance fieldInstance) {
            for (BinInstance bin : this.bins) {
                bin.setPerInstanceScope(fieldInstance);
            }
        }

        @Override
        public String getComment() {
            return this.coverpoint.options.comment;
        }
    }

    private static class DataSample
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String instancePath;
        private String coverpointName;
        private Expression.Value[] value;
        private transient RfField rfCoverpoint;

        public DataSample(RfField rfCoverpoint, String instancePath, String coverpointName, Expression.Value value) {
            this.rfCoverpoint = rfCoverpoint;
            this.instancePath = instancePath;
            this.coverpointName = coverpointName;
            this.value = new Expression.Value[]{value};
        }

        public DataSample(RfField rfCoverpoint, String instancePath, String coverpointName, Collection<Expression.Value> value) {
            this.rfCoverpoint = rfCoverpoint;
            this.instancePath = instancePath;
            this.coverpointName = coverpointName;
            this.value = value.toArray(new Expression.Value[value.size()]);
        }

        public String getName() {
            return this.coverpointName;
        }
    }

    public static interface ICoverageInstanceElement {
        public String getName();

        public CoverInfo coverInfo();

        public Image getImage();

        public RfNamedElement getRfElement();

        public void enableFill(boolean var1);

        public boolean isEnableFill();

        public String getComment();
    }

    public static interface ICoverageMember {
        public void setOption(String var1, Expression.Value var2);

        public Options getOptions();
    }

    public static class IntCrossDomain
    extends IntDomain {
        private Set<List<BigInteger>> values = new LinkedHashSet<List<BigInteger>>();

        public IntCrossDomain() {
        }

        public IntCrossDomain(List<BigInteger> value) {
            this();
            this.values.add(value);
        }

        public void append(BigInteger[] value) {
            this.values.add(Arrays.asList(value));
        }

        public boolean contains(BigInteger[] values) {
            return this.values.contains(Arrays.asList(values));
        }

        public BigInteger size() {
            return BigInteger.valueOf(this.values.size());
        }

        public IntDomain copy() {
            IntCrossDomain result = new IntCrossDomain();
            result.values.addAll(this.values);
            return result;
        }

        public IDomain intersect(IDomain domain) {
            IntCrossDomain result = (IntCrossDomain)this.copy();
            result.values.retainAll(((IntCrossDomain)domain).values);
            return result;
        }

        public IntDomain remove(BigInteger value) {
            throw new UnsupportedOperationException();
        }

        public IntDomain remove(BigInteger lowerBound, BigInteger upperBound) {
            throw new UnsupportedOperationException();
        }

        public IntDomain remove(IDomain domain) {
            IntCrossDomain result = (IntCrossDomain)this.copy();
            result.values.removeAll(((IntCrossDomain)domain).values);
            return result;
        }

        public Iterator<BigInteger> iterator() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            if (this.values.size() == 1) {
                return this.values.iterator().next().toString();
            }
            return this.values.toString();
        }

        public IntDomain getDomainOfVariable(int index) {
            IntDomain result = new IntDomain();
            for (List<BigInteger> value : this.values) {
                result.addSubdomain(value.get(index), value.get(index));
            }
            result.updateBounds();
            return result;
        }
    }

    public static class Options {
        private int weight = 1;
        private int goal = 100;
        private String name;
        private String comment;
        private int at_least = 1;
        private boolean detect_overlap;
        private int auto_bin_max = 64;
        private boolean per_instance;

        public static Options inheritFrom(Options options) {
            Options result = new Options();
            result.weight = options.weight;
            result.goal = options.goal;
            result.at_least = options.at_least;
            result.detect_overlap = options.detect_overlap;
            result.auto_bin_max = options.auto_bin_max;
            return result;
        }

        public void setOption(String optionName, Expression.Value optionValue) {
            if (optionName.equals("weight")) {
                this.weight = optionValue.getIntValue().intValueExact();
            }
            if (optionName.equals("goal")) {
                this.goal = optionValue.getIntValue().intValueExact();
            }
            if (optionName.equals("name")) {
                this.name = optionValue.getStringValue();
            }
            if (optionName.equals("comment")) {
                this.comment = optionValue.getStringValue();
            }
            if (optionName.equals("at_least")) {
                this.at_least = optionValue.getIntValue().intValueExact();
            }
            if (optionName.equals("detect_overlap")) {
                boolean bl = this.detect_overlap = !optionValue.getIntValue().equals(BigInteger.ZERO);
            }
            if (optionName.equals("auto_bin_max")) {
                this.auto_bin_max = optionValue.getIntValue().intValueExact();
            }
            if (optionName.equals("per_instance")) {
                this.per_instance = !optionValue.getIntValue().equals(BigInteger.ZERO);
            }
        }
    }
}

