/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.NestedBlockContext;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.VariableInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class CovergroupCallContext
extends NestedBlockContext
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static CovergroupCallContext create(Solver solver, InstancesContainer currentInstanceScope, RfCovergroup rfCovergroup, Map<RfNamedElement, Expression> arguments) {
        String methodName = ScenarioUtils.getDeduplicateName(rfCovergroup);
        CovergroupCallContext context = new CovergroupCallContext(solver.getScenario(), currentInstanceScope.runtimeId, currentInstanceScope, methodName);
        for (Map.Entry<RfNamedElement, Expression> argumentEntry : arguments.entrySet()) {
            InstancesContainer referenceInstance;
            RfField rfArgument = (RfField)argumentEntry.getKey();
            Expression argExpr = argumentEntry.getValue();
            List argValueList = Expression.filterVacuous(argExpr.evaluate(solver.getScenario(), currentInstanceScope));
            if (argValueList == null || argValueList.size() != 1) {
                throw new Solver.EvaluationException(Utils.append("Fail to evaluate covergroup instance argument '", rfArgument.getElabName(), "'", argExpr.line, argExpr.parserPath));
            }
            Expression.Value argValue = (Expression.Value)argValueList.get((int)0).expr;
            InstancesContainer instancesContainer = referenceInstance = Expression.Value.isReference(argValue) ? argValue.getRefValue() : null;
            if (referenceInstance instanceof FieldInstance) {
                context.addReferenceChildFieldInstance(rfArgument.getElabName(), (FieldInstance)referenceInstance, false);
                continue;
            }
            DataType dataType = rfArgument.getDataType();
            RfField rfArgument2 = new RfField(rfArgument.getElabName(), dataType);
            rfArgument2.setAssociatedType(rfArgument.getAssociatedType());
            rfArgument2.setEnclosingScope(rfArgument.getEnclosingScope());
            VariableInstance argVariableInstance = context.createVariableInstance(rfArgument);
            if (Expression.Value.isReference(argValue)) {
                argVariableInstance.setVariableValue(argValue);
                continue;
            }
            if (Expression.Value.isInteger(argValue)) {
                argVariableInstance.setVariableValue(argValue);
                dataType.set(argValue.nofBits(), 0, argValue.hasSign());
                continue;
            }
            if (Expression.Value.isString(argValue)) {
                argVariableInstance.setVariableValue(argValue);
                continue;
            }
            solver.logError("*** Error: Internal error CCC_1");
        }
        return context;
    }

    @Override
    public VariableInstance createVariableInstance(RfField rfArgument) {
        int arraySize = Utils.getAssociatedTypeArrayDim(rfArgument);
        IdentityHashMap<RfNamedElement, InstancesContainer> backPointersMap = new IdentityHashMap<RfNamedElement, InstancesContainer>();
        RfNamedElement rfArgumentType = Utils.getAssociatedType(rfArgument);
        FieldInstance variableInstance = this.createFieldInstance(backPointersMap, null, rfArgument, rfArgumentType, arraySize, -1, true);
        return (VariableInstance)variableInstance;
    }

    private CovergroupCallContext(Scenario scenario, BigInteger runtimeId, InstancesContainer parentInstanceScope, String covergroupInstanceName) {
        super(Utils.append("[", covergroupInstanceName, "() covergroup instance call]"), runtimeId, parentInstanceScope, scenario);
    }
}

