/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.TypeInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class DummyFieldInstance
extends FieldInstance {
    private static final long serialVersionUID = 1L;
    private TypeInstance.TypeKind typeCategory;
    private String mapItemKey;
    private int line;
    private ParserPath parserPath;
    private List<Expression> arguments;
    private transient RfNamedElement rfFieldType;

    public DummyFieldInstance(RfField rfField, int arraySize, int arrayItemIndex) {
        this(rfField, Utils.getAssociatedType(rfField), arraySize, arrayItemIndex);
    }

    public DummyFieldInstance(RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex) {
        super(rfField, null, arraySize, arrayItemIndex, Solver.DEFAULT_RUNTIME_ID, null);
        this.typeCategory = Utils.getTypeKind(rfFieldType);
        this.rfFieldType = rfFieldType;
    }

    public DummyFieldInstance(RfField rfField, RfNamedElement rfFieldType, int arraySize, String mapItemKey) {
        super(rfField, null, arraySize, -1, Solver.DEFAULT_RUNTIME_ID, null);
        this.typeCategory = Utils.getTypeKind(rfFieldType);
        this.rfFieldType = rfFieldType;
        this.mapItemKey = mapItemKey;
    }

    @Override
    public boolean isArrayItem() {
        return super.isArrayItem() || this.mapItemKey != null;
    }

    public String getMapItemKey() {
        return this.mapItemKey;
    }

    @Override
    public void addChildFieldInstance(String instanceName, FieldInstance fieldInstance, boolean isAllowDuplicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, FieldInstance> getFieldInstances() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RfNamedElement getRfFieldType() {
        return this.rfFieldType;
    }

    @Override
    public ActionInstance getParentActionInstance() {
        return null;
    }

    @Override
    public ComponentInstance getParentComponentInstance() {
        return null;
    }

    @Override
    public InstancePath getInstancePath() {
        return new InstancePath().append(this);
    }

    @Override
    public InstancePath getHierarchicalPath() {
        return new InstancePath().append(this);
    }

    @Override
    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        String result = this.getDiagramName();
        if (this.mapItemKey != null) {
            result = Utils.append(result, "[", this.mapItemKey, "]");
        }
        return result;
    }

    @Override
    public IntVariable getVariable(Model model, String overrideVarName, InstancePath varHierarchicalPath, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, boolean printConnectMessage) {
        if (this.fieldModifier == FieldModifier.CONST || this.fieldModifier == FieldModifier.STATIC_CONST || this.fieldModifier == FieldModifier.INDEX || this.fieldModifier == FieldModifier.ITERATOR || this.isEnumType()) {
            return super.getVariable(model, overrideVarName, varHierarchicalPath, variableSolverMap, printConnectMessage);
        }
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int key = ScenarioUtils.getKeyOfRf(this.rfFieldType);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int key = in.readInt();
        this.rfFieldType = ScenarioUtils.getRfOfKey(key);
    }

    @Override
    public boolean isBooleanType() {
        return this.typeCategory == TypeInstance.TypeKind.BOOL;
    }

    @Override
    public boolean isStringType() {
        return this.typeCategory == TypeInstance.TypeKind.STRING;
    }

    @Override
    public boolean isEnumType() {
        return this.typeCategory == TypeInstance.TypeKind.ENUM;
    }

    @Override
    public boolean isStructType() {
        return this.typeCategory == TypeInstance.TypeKind.STRUCT;
    }

    @Override
    public boolean isCollectionType() {
        return this.typeCategory == TypeInstance.TypeKind.ARRAY || this.typeCategory == TypeInstance.TypeKind.LIST || this.typeCategory == TypeInstance.TypeKind.MAP || this.typeCategory == TypeInstance.TypeKind.SET;
    }

    @Override
    public boolean isArrayType() {
        return this.typeCategory == TypeInstance.TypeKind.ARRAY;
    }

    @Override
    public boolean isListType() {
        return this.typeCategory == TypeInstance.TypeKind.LIST;
    }

    @Override
    public boolean isVectorType() {
        return this.typeCategory == TypeInstance.TypeKind.ARRAY || this.typeCategory == TypeInstance.TypeKind.LIST;
    }

    @Override
    public boolean isIntegerType() {
        return this.typeCategory == TypeInstance.TypeKind.INT;
    }

    @Override
    public boolean isUintType() {
        return this.typeCategory == TypeInstance.TypeKind.UINT;
    }

    public boolean isMethodCall() {
        return this.arguments != null;
    }

    public void setMethodCallInstanceData(List<Expression> arguments, int line, ParserPath parserPath) {
        this.arguments = arguments;
        this.line = line;
        this.parserPath = parserPath;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public int getLine() {
        return this.line;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }
}

