/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.Stack;

public enum ExecutionManager {
    INSTANCE;


    public void run(Scenario scenario) {
        try {
            Sequential rootRunnable = new Sequential();
            final Stack<Sequential> parentStack = new Stack<Sequential>();
            parentStack.push(rootRunnable);
            InstanceVisitor<ActionInstance> visitor = new InstanceVisitor<ActionInstance>(){

                @Override
                public boolean visit(ActionInstance candidate) {
                    if (candidate instanceof ActionInstance.ParallelActionInstance) {
                        IListRunnable parentRunnable = (IListRunnable)parentStack.peek();
                        Parallel runnable = new Parallel();
                        parentRunnable.addRunnable(runnable);
                        parentStack.push(runnable);
                    } else if (candidate instanceof ActionInstance.SequenceActionInstance) {
                        IListRunnable parentRunnable = (IListRunnable)parentStack.peek();
                        Sequential runnable = new Sequential();
                        parentRunnable.addRunnable(runnable);
                        parentStack.push(runnable);
                    } else if (!candidate.isCompound()) {
                        IListRunnable parentRunnable = (IListRunnable)parentStack.peek();
                        Atomic runnable = new Atomic(candidate);
                        parentRunnable.addRunnable(runnable);
                    }
                    return true;
                }

                @Override
                public void postVisit(ActionInstance candidate) {
                    if (candidate instanceof ActionInstance.ParallelActionInstance) {
                        parentStack.pop();
                    } else if (candidate instanceof ActionInstance.SequenceActionInstance) {
                        parentStack.pop();
                    }
                }
            };
            ((ActionInstance)((Object)scenario.rootAction)).accept(visitor);
            rootRunnable.run();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static class Atomic
    implements Runnable {
        private ActionInstance actionInstance;

        public Atomic(ActionInstance actionInstance) {
            this.actionInstance = actionInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Scenario scenario = this.actionInstance.scenario;
            synchronized (scenario) {
                this.actionInstance.applyExecDescriptors(null, null, ExecBlockKind.BODY, this.actionInstance.getRfAction());
            }
        }
    }

    public static interface IListRunnable
    extends Runnable {
        public void addRunnable(Runnable var1);
    }

    public static class Parallel
    implements IListRunnable {
        private List<Runnable> runnables = new ArrayList<Runnable>();

        @Override
        public void run() {
            ExecutorService parallelExecutor = Executors.newCachedThreadPool();
            for (Runnable runnable : this.runnables) {
                parallelExecutor.execute(runnable);
            }
            parallelExecutor.shutdown();
        }

        @Override
        public void addRunnable(Runnable runnable) {
            this.runnables.add(runnable);
        }
    }

    public static class Sequential
    implements IListRunnable {
        private List<Runnable> runnables = new ArrayList<Runnable>();

        @Override
        public void run() {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
        }

        @Override
        public void addRunnable(Runnable runnable) {
            this.runnables.add(runnable);
        }
    }
}

