/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.constraints.Equals;
import ro.amiq.dvt.csp.constraints.ListConstraint;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.BoolVariable;
import ro.amiq.dvt.csp.variables.CompoundVariable;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.ReifBoolVariable;
import ro.amiq.dvt.csp.variables.StrVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.Endianness;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfPredefinedMethod;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ConstraintDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.DummyFieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.MethodCallContext;
import ro.amiq.pssdt.model.reflection.elaboration.MethodCallInstance;
import ro.amiq.pssdt.model.reflection.elaboration.NestedBlockContext;
import ro.amiq.pssdt.model.reflection.elaboration.RegionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.VariableInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfFieldWrapper;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.StringFormatter;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.ModelWalker;
import ro.amiq.pssdt.parser.SemanticWalker;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public abstract class Expression
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int line;
    protected ParserPath parserPath;

    protected Expression(int line, ParserPath parserPath) {
        this.line = line;
        this.parserPath = parserPath;
    }

    public String toString() {
        return this.toString(true).toString();
    }

    public int getLine() {
        return this.line;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public abstract LazyString toString(boolean var1);

    public abstract List<ExprAndDep<IntVariable>> getExpression(Scenario var1, Model var2, Map<String, InstancesContainer.GeneratedVar> var3, Map<AbstractConstraint, ConstraintDescriptor.Text> var4, InstancesContainer var5, InstancesContainer var6, boolean var7, int var8, boolean var9);

    @NotNull
    public abstract List<ExprAndDep<Value>> evaluate(Scenario var1, InstancesContainer var2);

    public static List<CspConstraint> toConstraint(Scenario scenario, Model model, Expression expression, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean ifThenCall, boolean keepClosestToMax, int maxTraversalIndex) {
        List<ExpressionError> errors;
        if (expression instanceof Scheduling) {
            expression.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, false, Integer.MAX_VALUE, false);
            return null;
        }
        if (!ifThenCall && !expression.isRand()) {
            ScenarioUtils.printWarning(Utils.append("Ignored constraint on non-rand expression: ", expression), true, expression.line, expression.parserPath);
            return null;
        }
        expression.cleanErrors();
        List<ExprAndDep<IntVariable>> arExprs = expression.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, false);
        if (arExprs == null || arExprs.isEmpty()) {
            return null;
        }
        if (!ifThenCall && (errors = expression.getErrors()) != null && !errors.isEmpty()) {
            scenario.addSolverExpressionsErrors(errors);
        }
        ArrayList<CspConstraint> result = new ArrayList<CspConstraint>(arExprs.size());
        for (ExprAndDep<IntVariable> arExpr : arExprs) {
            if (arExpr.isVacuous()) continue;
            AbstractConstraint constraint = null;
            if (arExpr.expr instanceof RunnableIntVariable) {
                result.add(new CspConstraint((AbstractConstraint)new RunnableConstraint(model, ((RunnableIntVariable)((Object)arExpr.expr)).runnable), arExpr.hrText));
                continue;
            }
            if (arExpr.expr instanceof ReifBoolVariable) {
                constraint = ((ReifBoolVariable)arExpr.expr).decompose();
            } else if (!ifThenCall) {
                ((IntVariable)arExpr.expr).setConstant(true).setDomain((IDomain)new IntDomain(BigInteger.ONE));
                constraint = ((IntVariable)arExpr.expr).eq(Value.from(BigInteger.ONE, 1, false).intVar(model));
            } else {
                constraint = ((IntVariable)arExpr.expr).eq(Value.from(BigInteger.ONE, 1, false).intVar(model));
            }
            constraint.unpost();
            if (cspToReadableTextMap != null) {
                cspToReadableTextMap.put(constraint, new ConstraintDescriptor.Text(LazyString.create(() -> Utils.append("constraint ", Utils.processHrText(exprAndDep.hrText.toString()))), arExpr.line, expression.parserPath));
            }
            result.add(new CspConstraint(constraint, arExpr.hrText));
        }
        return result;
    }

    protected int nofBits() {
        return -1;
    }

    public Endianness endianness() {
        return Endianness.LITTLE;
    }

    public abstract boolean isRand();

    public abstract boolean isRuntime();

    public abstract boolean isUninitActionHandle();

    public abstract boolean isIndex();

    public abstract boolean isConstant();

    public abstract List<ExpressionError> getErrors();

    public abstract void cleanErrors();

    public void evaluateUnintActionHandles(Solver solver) {
    }

    protected List<ExprAndDep<Value>> evaluateOperand(Scenario scenario, Expression operand, InstancesContainer currentInstanceScope) {
        List<ExprAndDep<Value>> vars = operand.evaluate(scenario, currentInstanceScope);
        if (vars == null || vars.isEmpty()) {
            if (operand.isUninitActionHandle()) {
                throw new Solver.EvaluationException(Utils.append("Cannot access attributes of uninitialized action-handle '", operand.toString(false), "'"), operand.line, operand.parserPath);
            }
            throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", operand.toString(false), "' expression"), operand.line, operand.parserPath);
        }
        return vars;
    }

    public static <T> List<ExprAndDep<T>> filterVacuous(List<ExprAndDep<T>> values) {
        ArrayList<ExprAndDep<T>> result = new ArrayList<ExprAndDep<T>>(values.size());
        for (ExprAndDep<T> value : values) {
            if (value == null || value.isVacuous()) continue;
            result.add(value);
        }
        return result;
    }

    protected ListConstraint toListConstraint(Model model, List<CspConstraint> cspConstraints) {
        if (cspConstraints == null) {
            return null;
        }
        AbstractConstraint[] constraints = new AbstractConstraint[cspConstraints.size()];
        int i = 0;
        while (i < cspConstraints.size()) {
            constraints[i] = cspConstraints.get((int)i).constraint;
            ++i;
        }
        return new ListConstraint(model, constraints);
    }

    protected String hrText(List<CspConstraint> cspConstraints) {
        StringBuilder hrText = new StringBuilder();
        boolean isFirst = true;
        for (CspConstraint cspConstraint : cspConstraints) {
            if (!isFirst) {
                hrText.append(" & ");
            }
            hrText.append(cspConstraint.hrText);
            isFirst = false;
        }
        return hrText.toString();
    }

    public static Expression not(Expression expr) {
        if (expr instanceof Logic && ((Logic)expr).op == Logic.Operator.EQ) {
            return new Logic(Logic.Operator.NOT_EQ, ((Logic)expr).left, ((Logic)expr).right, expr.line, expr.parserPath);
        }
        if (expr instanceof Logic && ((Logic)expr).op == Logic.Operator.NOT_EQ) {
            return new Logic(Logic.Operator.EQ, ((Logic)expr).left, ((Logic)expr).right, expr.line, expr.parserPath);
        }
        if (expr instanceof Logic && ((Logic)expr).op == Logic.Operator.LT) {
            return new Logic(Logic.Operator.GTE, ((Logic)expr).left, ((Logic)expr).right, expr.line, expr.parserPath);
        }
        if (expr instanceof Logic && ((Logic)expr).op == Logic.Operator.GT) {
            return new Logic(Logic.Operator.LTE, ((Logic)expr).left, ((Logic)expr).right, expr.line, expr.parserPath);
        }
        if (expr instanceof Logic && ((Logic)expr).op == Logic.Operator.LTE) {
            return new Logic(Logic.Operator.GT, ((Logic)expr).left, ((Logic)expr).right, expr.line, expr.parserPath);
        }
        if (expr instanceof Logic && ((Logic)expr).op == Logic.Operator.GTE) {
            return new Logic(Logic.Operator.LT, ((Logic)expr).left, ((Logic)expr).right, expr.line, expr.parserPath);
        }
        return new Logic(Logic.Operator.NOT, expr, null, expr.line, expr.parserPath);
    }

    public static class Arith
    extends Expression {
        private static final long serialVersionUID = 1L;
        protected Operator op;
        protected Expression left;
        protected Expression right;

        public Arith(Operator op, Expression left, Expression right, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.op = op;
            this.left = left;
            this.right = right;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            if (this.op == Operator.NEG) {
                return LazyString.create(() -> Utils.append(this.op.toString(), this.left.toString()));
            }
            return LazyString.create(() -> {
                String result = Utils.append(this.left.toString(), this.op.toString(), this.right.toString());
                return enclosed ? Utils.append("(", result, ")") : result;
            });
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            List<ExprAndDep<Value>> vars1 = this.evaluateOperand(scenario, this.left, currentInstanceScope);
            List<ExprAndDep> vars2 = this.right == null ? Collections.emptyList() : this.evaluateOperand(scenario, this.right, currentInstanceScope);
            ArrayList<ExprAndDep<Value>> result = new ArrayList<ExprAndDep<Value>>();
            block15: for (ExprAndDep<Value> var1 : vars1) {
                if (!Value.isInteger((Value)var1.expr) || var1.isVacuous()) continue;
                boolean hasSign1 = ((Value)var1.expr).hasSign();
                int nofBits1 = ((Value)var1.expr).nofBits();
                BigInteger leftValue = ((Value)var1.expr).getIntValue();
                switch (this.op) {
                    case NEG: {
                        BigInteger value = leftValue.negate();
                        result.add(new ExprAndDep<Value>(Value.from(value, nofBits1 + (hasSign1 ? 1 : 0), true).toUorS(hasSign1), var1.dependencies, LazyString.create(() -> Utils.append("-", exprAndDep.hrText)), this.line));
                        break;
                    }
                    default: {
                        for (ExprAndDep var2 : vars2) {
                            if (!Value.isInteger((Value)var2.expr) || var2.isVacuous()) continue;
                            boolean hasSign2 = ((Value)var1.expr).hasSign() & ((Value)var2.expr).hasSign();
                            int nofBits2 = Math.max(((Value)var1.expr).nofBits(), ((Value)var2.expr).nofBits());
                            BigInteger rightValue = ((Value)var2.expr).getIntValue();
                            switch (this.op) {
                                case PLUS: {
                                    BigInteger value = leftValue.add(rightValue);
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MINUS: {
                                    BigInteger value = leftValue.subtract(rightValue);
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case DIV: {
                                    BigInteger value = BigInteger.ZERO;
                                    if (rightValue.compareTo(BigInteger.ZERO) == 0) {
                                        ScenarioUtils.printError("Divide by zero is undefined", true, this.line, this.parserPath);
                                    } else {
                                        value = leftValue.divide(rightValue);
                                    }
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MUL: {
                                    BigInteger value = leftValue.multiply(rightValue);
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MOD: {
                                    BigInteger value = BigInteger.ZERO;
                                    if (rightValue.compareTo(BigInteger.ZERO) == 0) {
                                        ScenarioUtils.printError("Divide by zero is undefined", true, this.line, this.parserPath);
                                    } else {
                                        value = leftValue.mod(rightValue);
                                    }
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case POW: {
                                    int rightIntValue = rightValue.intValueExact();
                                    BigInteger value = BigInteger.ZERO;
                                    if (rightIntValue == 0) {
                                        value = BigInteger.ONE;
                                    } else if (rightIntValue < 0) {
                                        if (leftValue.compareTo(BigInteger.ZERO) == 0) {
                                            ScenarioUtils.printError("Divide by zero is undefined", true, this.line, this.parserPath);
                                        } else if (leftValue.compareTo(Utils.MINUS_ONE) == 0) {
                                            value = rightValue.testBit(0) ? Utils.MINUS_ONE : BigInteger.ONE;
                                        } else if (leftValue.compareTo(BigInteger.ONE) == 0) {
                                            value = BigInteger.ONE;
                                        }
                                    } else {
                                        value = leftValue.pow(rightIntValue);
                                    }
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case SL: {
                                    int rightOpValue = rightValue.intValueExact();
                                    hasSign2 = ((Value)var1.expr).hasSign();
                                    nofBits2 = ((Value)var1.expr).nofBits() + rightOpValue;
                                    if (rightOpValue < 0) {
                                        ScenarioUtils.printError(Utils.append("Negative right hand side shift operand ", rightOpValue, " is not allowed"), true, this.line, this.parserPath);
                                    }
                                    BigInteger value = leftValue.shiftLeft(rightOpValue);
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case SR: {
                                    int rightOpValue = rightValue.intValueExact();
                                    hasSign2 = ((Value)var1.expr).hasSign();
                                    nofBits2 = ((Value)var1.expr).nofBits() - rightOpValue;
                                    if (rightOpValue < 0) {
                                        ScenarioUtils.printError(Utils.append("Negative right hand side shift operand ", rightOpValue, " is not allowed"), true, this.line, this.parserPath);
                                    }
                                    BigInteger value = leftValue.shiftRight(rightOpValue);
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MIN: {
                                    BigInteger value = leftValue.min(rightValue);
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MAX: {
                                    BigInteger value = leftValue.max(rightValue);
                                    result.add(new ExprAndDep<Value>(Value.from(value, Math.max(nofBits2, value.bitLength() + (hasSign2 ? 1 : 0)), hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                default: {
                                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.toString(false), "' expression (OP)"), this.line, this.parserPath);
                                }
                            }
                        }
                        continue block15;
                    }
                }
            }
            return result;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars1 = this.left.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars1 == null || vars1.isEmpty()) {
                return null;
            }
            List<ExprAndDep<IntVariable>> vars2 = this.right == null ? null : this.right.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            block15: for (ExprAndDep<IntVariable> var1 : vars1) {
                if (var1.isVacuous()) continue;
                switch (this.op) {
                    case NEG: {
                        if (((IntVariable)var1.expr).isSigned()) {
                            result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).neg(), var1.dependencies, LazyString.create(() -> Utils.append("-", exprAndDep.hrText)), this.line));
                            break;
                        }
                        int nofBits = ((IntVariable)var1.expr).nofBits();
                        IntVariable temp = model.getCachedConstant(false, nofBits + 1, Utils.getPowerOfTwo(nofBits));
                        result.add(new ExprAndDep<IntVariable>(temp.sub((IntVariable)var1.expr).mod(temp), var1.dependencies, LazyString.create(() -> Utils.append("-", exprAndDep.hrText)), this.line));
                        break;
                    }
                    default: {
                        if (vars2 == null || vars2.isEmpty()) {
                            return null;
                        }
                        for (ExprAndDep<IntVariable> var2 : vars2) {
                            if (var1 == var2 || var2.isVacuous()) continue;
                            switch (this.op) {
                                case PLUS: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).add((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MINUS: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).sub((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case DIV: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).div((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MUL: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).mul((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MOD: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).mod((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case POW: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).pow((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case SL: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).sl((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case SR: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).sr((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MIN: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).min((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case MAX: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).max((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                            }
                        }
                        continue block15;
                    }
                }
            }
            return result;
        }

        private final LazyString hrText(LazyString hrLeftText, LazyString hrRightText) {
            LazyString hrText = null;
            switch (this.op) {
                case NEG: {
                    hrText = LazyString.create(() -> Utils.append(this.op.toString(), hrLeftText));
                    break;
                }
                case MIN: 
                case MAX: {
                    hrText = LazyString.create(() -> Utils.append(this.op.toString(), "(", hrLeftText, ", ", hrRightText, ")"));
                    break;
                }
                default: {
                    hrText = LazyString.create(() -> Utils.append("(", hrLeftText, this.op.toString(), hrRightText, ")"));
                }
            }
            return hrText;
        }

        @Override
        public boolean isRand() {
            return this.left.isRand() || this.right != null && this.right.isRand();
        }

        @Override
        public boolean isRuntime() {
            return this.left.isRuntime() || this.right != null && this.right.isRuntime();
        }

        @Override
        public boolean isUninitActionHandle() {
            return this.left.isUninitActionHandle() || this.right != null && this.right.isUninitActionHandle();
        }

        @Override
        public boolean isIndex() {
            return this.left.isIndex() || this.right != null && this.right.isIndex();
        }

        @Override
        public boolean isConstant() {
            return this.left.isConstant() && (this.right == null || this.right.isConstant());
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            if (this.left != null) {
                this.left.evaluateUnintActionHandles(solver);
            }
            if (this.right != null) {
                this.right.evaluateUnintActionHandles(solver);
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.left, this.right);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.left, this.right);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Operator {
            PLUS{

                public String toString() {
                    return " + ";
                }
            }
            ,
            MINUS{

                public String toString() {
                    return " - ";
                }
            }
            ,
            DIV{

                public String toString() {
                    return " / ";
                }
            }
            ,
            MUL{

                public String toString() {
                    return " * ";
                }
            }
            ,
            MOD{

                public String toString() {
                    return " % ";
                }
            }
            ,
            POW{

                public String toString() {
                    return " ** ";
                }
            }
            ,
            SL{

                public String toString() {
                    return " << ";
                }
            }
            ,
            SR{

                public String toString() {
                    return " >> ";
                }
            }
            ,
            NEG{

                public String toString() {
                    return "-";
                }
            }
            ,
            MIN{

                public String toString() {
                    return " min";
                }
            }
            ,
            MAX{

                public String toString() {
                    return " max";
                }
            };

        }
    }

    public static class Assign
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Expression left;
        private Expression right;

        public Assign(Expression leftExpr, Expression right, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.left = leftExpr;
            this.right = right;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append(this.left.toString(), " = ", this.right.toString()));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            Value rightValue;
            InstancesContainer leftInstance;
            block17: {
                scenario.debugBeginEvaluate(this, currentInstanceScope);
                Hid leftHid = null;
                if (this.left instanceof Hid) {
                    leftHid = (Hid)this.left;
                } else if (this.left instanceof BitSlice && ((BitSlice)this.left).expression instanceof Hid) {
                    leftHid = (Hid)((BitSlice)this.left).expression;
                } else {
                    throw new Solver.EvaluationException(Utils.append("Unsupported assign expression '", this.left.toString(false), "'"), this.line, this.parserPath);
                }
                List<InstancePath> leftInstancePath = leftHid.getVariablesPaths(scenario, false, currentInstanceScope, false, Integer.MAX_VALUE);
                if (leftInstancePath == null || leftInstancePath.size() != 1) {
                    if (leftHid.isUninitActionHandle()) {
                        throw new Solver.EvaluationException(Utils.append("Cannot access attributes of uninitialized action-handle '", this.left.toString(false), "'"), this.line, this.parserPath);
                    }
                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.left.toString(false), "' expression"), this.line, this.parserPath);
                }
                leftInstance = leftInstancePath.get(0).getInstance();
                List<ExprAndDep<Value>> rightResult = this.right.evaluate(scenario, currentInstanceScope);
                if (rightResult == null || rightResult.size() != 1) {
                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.right.toString(false), "' expression (RHS)"), this.line, this.parserPath);
                }
                rightValue = this.bitSlice(scenario, currentInstanceScope, leftInstance, (Value)rightResult.get((int)0).expr);
                if (!Value.isNull(rightValue)) break block17;
                List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
                scenario.debugFinishEvaluate(this, currentInstanceScope);
                return list;
            }
            try {
                try {
                    if (Value.isReference(rightValue) && rightValue.getRefValue().isCollectionType()) {
                        leftInstance.deepCopy(Utils.unwrapReferenceInstance(rightValue.getRefValue()), this.line, this.parserPath);
                    } else if (Value.isValueCopyAssignment(rightValue)) {
                        leftInstance.deepCopy(Utils.unwrapReferenceInstance(rightValue.getRefValue()), this.line, this.parserPath);
                    } else {
                        leftInstance.setVariableValue(rightValue);
                    }
                }
                catch (Solver.EvaluationException e) {
                    ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                    throw new Solver.InterruptException();
                }
                catch (Solver.SkipEvaluationException skipEvaluationException) {
                    ScenarioUtils.printWarning(Utils.append("Cannot evaluate '", this.toString(false), "' expression (ignored)"), true, this.line, this.parserPath);
                    scenario.debugFinishEvaluate(this, currentInstanceScope);
                }
            }
            catch (Throwable throwable) {
                scenario.debugFinishEvaluate(this, currentInstanceScope);
                throw throwable;
            }
            scenario.debugFinishEvaluate(this, currentInstanceScope);
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
        }

        private Value bitSlice(Scenario scenario, InstancesContainer currentInstanceScope, InstancesContainer leftInstance, Value rightValue) {
            if (!(this.left instanceof BitSlice)) {
                return rightValue;
            }
            Value leftValue = leftInstance.getVariableValue();
            int leftBit = ((Value)((BitSlice)this.left).leftRange.evaluate((Scenario)scenario, (InstancesContainer)currentInstanceScope).get((int)0).expr).getIntValue().intValueExact();
            int rightBit = ((Value)((BitSlice)this.left).rightRange.evaluate((Scenario)scenario, (InstancesContainer)currentInstanceScope).get((int)0).expr).getIntValue().intValueExact();
            int nofSliceBits = Math.abs(leftBit - rightBit) + 1;
            int nofBits = ((BitSlice)this.left).expression.nofBits();
            if (leftBit < rightBit) {
                if (nofBits < 0) {
                    throw new UnsupportedOperationException();
                }
                leftBit = nofBits - rightBit - 1;
                rightBit = leftBit + nofSliceBits - 1;
            }
            BigInteger rightIntValue = rightValue.getIntValue();
            BigInteger leftIntValue = leftValue.getIntValue();
            rightIntValue = rightIntValue.shiftLeft(Math.min(leftBit, rightBit));
            int i = 0;
            while (i < leftIntValue.bitLength()) {
                if ((i < Math.min(leftBit, rightBit) || i > Math.max(leftBit, rightBit)) && leftIntValue.testBit(i)) {
                    rightIntValue = rightIntValue.setBit(i);
                }
                ++i;
            }
            return Value.from(rightIntValue, nofBits, false);
        }

        @Override
        public boolean isRand() {
            return false;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.left, this.right);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.left, this.right);
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            if (this.left != null) {
                this.left.evaluateUnintActionHandles(solver);
            }
            if (this.right != null) {
                this.right.evaluateUnintActionHandles(solver);
            }
        }
    }

    public static class AttrDeclaration
    extends Assign {
        private static final long serialVersionUID = 1L;
        private transient RfField rfVar;

        public AttrDeclaration(RfField rfVar, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.rfVar = rfVar;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("var '", this.rfVar.getElabName(), "' declaration"));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            if (!(currentInstanceScope instanceof NestedBlockContext)) {
                throw new Solver.EvaluationException("Fail to create variable declaration context", this.line, this.parserPath);
            }
            RfNamedElement rfVarType = Utils.getAssociatedType(this.rfVar);
            int arraySize = Utils.getAssociatedTypeArrayDim(this.rfVar);
            currentInstanceScope.createFieldInstance(new IdentityHashMap<RfNamedElement, InstancesContainer>(), null, this.rfVar, rfVarType, arraySize, -1, false);
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
        }

        @Override
        public final List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            ComponentInstance parentComponentInstance = currentInstanceScope.getParentComponentInstance();
            if (parentComponentInstance == null) {
                return null;
            }
            FieldInstance fieldInstance = currentInstanceScope.getFieldInstance(this.rfVar.getElabName());
            if (fieldInstance == null) {
                throw new Solver.EvaluationException(Utils.append("Cannot find rand qualified field '", this.rfVar.getElabName(), "'"), this.line, this.parserPath);
            }
            if (fieldInstance.getRfField() != this.rfVar) {
                return null;
            }
            RfNamedElement rfFieldType = fieldInstance.getRfFieldType();
            if (Utils.isAddressClaimInstance(rfFieldType)) {
                ExprAndDep<IntVariable> claimExpression = this.getAddressClaimExpression(model, variableSolverMap, parentComponentInstance, fieldInstance);
                result.add(claimExpression);
            } else if (Utils.isExecutorClaimInstance(rfFieldType)) {
                ExprAndDep<IntVariable> claimExpression = this.getExecutorClaimExpression(model, variableSolverMap, parentComponentInstance, fieldInstance);
                result.add(claimExpression);
                scenario.executorAssignments.put(fieldInstance.getParentActionInstance(), fieldInstance);
            }
            return result;
        }

        private final ExprAndDep<IntVariable> getExecutorClaimExpression(Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, ComponentInstance parentComponentInstance, InstancesContainer claimInstance) {
            List<ComponentInstance> allocatableExecutors = parentComponentInstance.getAllocatableExecutors(claimInstance, this.line, this.parserPath);
            Object result = null;
            for (ComponentInstance executorInstance : allocatableExecutors) {
                FieldInstance claimTraitInstance = claimInstance.getFieldInstance("trait");
                FieldInstance executorTraitInstance = executorInstance.getFieldInstance("trait");
                IntVariable claimTrait = claimTraitInstance.getVariable(model, null, claimTraitInstance.getHierarchicalPath(), variableSolverMap, false);
                IntVariable executorTrait = executorTraitInstance.getVariable(model, null, executorTraitInstance.getHierarchicalPath(), variableSolverMap, false);
                ReifBoolVariable traitsEquals = claimTrait.eq(executorTrait).reify();
                result = result == null ? traitsEquals : result.or((IntVariable)traitsEquals);
            }
            return new ExprAndDep<Object>(result, null, LazyString.create(() -> Utils.append("executor claim '", this.rfVar.getElabName(), "' request")), this.line);
        }

        private final ExprAndDep<IntVariable> getAddressClaimExpression(Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, ComponentInstance parentComponentInstance, InstancesContainer claimInstance) {
            ComponentInstance.AllocatableRegions allocatableRegion = parentComponentInstance.getAllocatableRegions(claimInstance, this.line, this.parserPath);
            FieldInstance alignmentInstance = claimInstance.getFieldInstance("alignment");
            IntVariable addressAlignment = alignmentInstance.getVariable(model, null, alignmentInstance.getHierarchicalPath(), variableSolverMap, false);
            String claimHandleName = Utils.append(claimInstance.getHierarchicalPath(), ".[claimHandle]");
            FieldInstance claimAddressInstance = claimInstance.getFieldInstance("addr");
            IntVariable claimAddress = claimAddressInstance != null ? claimAddressInstance.getVariable(model, null, claimAddressInstance.getHierarchicalPath(), variableSolverMap, false) : (variableSolverMap.containsKey(claimHandleName) ? (IntVariable)((CompoundVariable)variableSolverMap.get((Object)claimHandleName).variable).getVariables().get("@addr") : model.intVar(claimHandleName, false, 64, BigInteger.ZERO, Utils.getPowerOfTwoMask(64)));
            ArrayList<CspConstraint> cspConstraints = new ArrayList<CspConstraint>();
            FieldInstance claimSizeInstance = claimInstance.getFieldInstance("size");
            IntVariable claimSize = claimSizeInstance.getVariable(model, null, claimSizeInstance.getHierarchicalPath(), variableSolverMap, false);
            FieldInstance claimPermanentInstance = claimInstance.getFieldInstance("permanent");
            IntVariable claimPermanent = claimPermanentInstance.getVariable(model, null, claimPermanentInstance.getHierarchicalPath(), variableSolverMap, false);
            CompoundVariable claimHandleVariable = new CompoundVariable(null, new LinkedHashMap(), null, false);
            claimHandleVariable.put("@addr", (Variable)claimAddress).put("@size", (Variable)claimSize).put("@permanent", (Variable)claimPermanent);
            IntVariable allocatableDomain = model.intVar("", false, 64, allocatableRegion.allocatableDomain);
            allocatableDomain.disable();
            variableSolverMap.put(claimHandleName, new InstancesContainer.GeneratedVar.ClaimGeneratedVar(claimInstance, claimHandleVariable, allocatableRegion.regionInstances));
            IntVariable allocAddress = allocatableDomain.claim(claimSize, addressAlignment);
            cspConstraints.add(new CspConstraint(claimAddress.eq(allocAddress), null));
            model.deferEvaluation(new Variable[]{allocAddress, addressAlignment});
            claimAddress.setSearchStrategy(IDomain.SearchStrategy.LOWER_BOUND);
            allocAddress.setSearchStrategy(IDomain.SearchStrategy.LOWER_BOUND);
            FieldInstance claimTraitInstance = claimInstance.getFieldInstance("trait");
            IntVariable claimTrait = claimTraitInstance.getVariable(model, null, claimTraitInstance.getHierarchicalPath(), variableSolverMap, false);
            IntVariable TRUE = model.getCachedConstant(false, 1, BigInteger.ONE);
            for (RegionInstance regionInstance : allocatableRegion.regionInstances) {
                FieldInstance regionTraitInstance = regionInstance.getFieldInstance("trait");
                IntVariable regionTrait = regionTraitInstance.getVariable(model, null, regionTraitInstance.getHierarchicalPath(), variableSolverMap, false);
                IntVariable lowerAddress = model.getCachedConstant(false, 64, regionInstance.getLowerAddress());
                IntVariable upperAddress = model.getCachedConstant(false, 64, regionInstance.getUpperAddress());
                IntVariable addrCompareVariable = claimAddress.ge(lowerAddress).reify().and((IntVariable)claimAddress.le(upperAddress).reify());
                addrCompareVariable.setNonRandom(true);
                AbstractConstraint ifCstr = claimTrait.eq(regionTrait);
                ifCstr.unpost();
                AbstractConstraint thenCstr = addrCompareVariable.eq(TRUE);
                thenCstr.unpost();
                cspConstraints.add(new CspConstraint(model.ifThen(ifCstr, thenCstr), null));
            }
            this.toListConstraint(model, cspConstraints);
            return new ExprAndDep<Object>(null, null, LazyString.create(() -> Utils.append("address claim '", this.rfVar.getElabName(), "' request")), this.line);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfVar);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfVar = (RfField)ScenarioUtils.getRfOfKey(key);
        }

        public RfField getRfVar() {
            return this.rfVar;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return null;
        }

        public final boolean isClaimExpr() {
            RfNamedElement rfVarType = Utils.getAssociatedType(this.rfVar);
            return rfVarType != null && rfVarType.isCoreLibInstanceOf("addr_claim_base_s", "executor_claim_s");
        }

        @Override
        public boolean isRand() {
            return this.isClaimExpr();
        }
    }

    public static class Before
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Hid beforeHid;
        private Hid afterHid;

        public Before(Hid beforeHid, Hid afterHid, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.beforeHid = beforeHid;
            this.afterHid = afterHid;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("solve ", this.beforeHid.toString(false), " before ", this.afterHid.toString(false)));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars1 = this.beforeHid.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars1 == null || vars1.isEmpty()) {
                return null;
            }
            List<ExprAndDep<IntVariable>> vars2 = this.afterHid.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars2 == null || vars2.isEmpty()) {
                return null;
            }
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            for (ExprAndDep<IntVariable> var1 : vars1) {
                if (var1.isVacuous()) continue;
                for (ExprAndDep<IntVariable> var2 : vars2) {
                    if (var1 == var2 || var2.isVacuous()) continue;
                    RunnableIntVariable solveBefore = new RunnableIntVariable(model, () -> model.solveBefore((Variable)exprAndDep.expr, (Variable)exprAndDep2.expr));
                    ExprAndDep<RunnableIntVariable> exprAndDep = new ExprAndDep<RunnableIntVariable>(solveBefore, var1.dependencies, var2.dependencies, this.toString(false), this.line);
                    result.add(exprAndDep);
                }
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRand() {
            return false;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.beforeHid, this.afterHid);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.beforeHid, this.afterHid);
        }
    }

    public static class Binary
    extends Expression {
        private static final long serialVersionUID = 1L;
        protected Operator op;
        protected Expression left;
        protected Expression right;

        public Binary(Operator op, Expression left, Expression right, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.op = op;
            this.left = left;
            this.right = right;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            if (this.op == Operator.U_AND || this.op == Operator.U_OR || this.op == Operator.U_XOR || this.op == Operator.U_NOT) {
                return LazyString.create(() -> Utils.append(this.op.toString(), this.left.toString()));
            }
            return LazyString.create(() -> {
                String result = Utils.append(this.left.toString(), this.op.toString(), this.right.toString());
                return enclosed ? Utils.append("(", result, ")") : result;
            });
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            List<ExprAndDep<Value>> vars1 = this.evaluateOperand(scenario, this.left, currentInstanceScope);
            List<ExprAndDep> vars2 = this.right == null ? Collections.emptyList() : this.evaluateOperand(scenario, this.right, currentInstanceScope);
            ArrayList<ExprAndDep<Value>> result = new ArrayList<ExprAndDep<Value>>();
            block11: for (ExprAndDep<Value> var1 : vars1) {
                if (!Value.isInteger((Value)var1.expr) || var1.isVacuous()) continue;
                int nofBits1 = ((Value)var1.expr).nofBits();
                switch (this.op) {
                    case U_NOT: {
                        result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().not(), nofBits1, false), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    case U_AND: {
                        result.add(new ExprAndDep<Value>(Value.from(Model.unaryAnd((BigInteger)((Value)var1.expr).getIntValue()), nofBits1, false), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    case U_OR: {
                        result.add(new ExprAndDep<Value>(Value.from(Model.unaryOr((BigInteger)((Value)var1.expr).getIntValue()), nofBits1, false), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    case U_XOR: {
                        result.add(new ExprAndDep<Value>(Value.from(Model.unaryXor((BigInteger)((Value)var1.expr).getIntValue()), nofBits1, false), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    default: {
                        for (ExprAndDep var2 : vars2) {
                            if (!Value.isInteger((Value)var2.expr) || var2.isVacuous()) continue;
                            int nofBits2 = Math.max(((Value)var1.expr).nofBits(), ((Value)var2.expr).nofBits());
                            boolean hasSign2 = ((Value)var1.expr).hasSign() & ((Value)var2.expr).hasSign();
                            switch (this.op) {
                                case AND: {
                                    result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().and(((Value)var2.expr).getIntValue()), nofBits2, hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case OR: {
                                    result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().or(((Value)var2.expr).getIntValue()), nofBits2, hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case XOR: {
                                    result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().xor(((Value)var2.expr).getIntValue()), nofBits2, hasSign2), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                default: {
                                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.toString(false), "' expression (OP)"), this.line, this.parserPath);
                                }
                            }
                        }
                        continue block11;
                    }
                }
            }
            return result;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars1 = this.left.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars1 == null || vars1.isEmpty()) {
                return null;
            }
            List<ExprAndDep<IntVariable>> vars2 = this.right == null ? null : this.right.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            block11: for (ExprAndDep<IntVariable> var1 : vars1) {
                if (var1.isVacuous()) continue;
                switch (this.op) {
                    case U_NOT: {
                        result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).not(), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    case U_AND: {
                        result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).uand(), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    case U_OR: {
                        result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).uor(), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    case U_XOR: {
                        result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).uxor(), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    default: {
                        if (vars2 == null || vars2.isEmpty()) {
                            return null;
                        }
                        for (ExprAndDep<IntVariable> var2 : vars2) {
                            if (var1 == var2 || var2.isVacuous()) continue;
                            switch (this.op) {
                                case AND: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).and((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case OR: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).or((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case XOR: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).xor((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                            }
                        }
                        continue block11;
                    }
                }
            }
            return result;
        }

        private final LazyString hrText(LazyString hrLeftText, LazyString hrRightText) {
            LazyString hrText = null;
            switch (this.op) {
                case U_NOT: 
                case U_OR: 
                case U_AND: 
                case U_XOR: {
                    hrText = LazyString.create(() -> Utils.append(this.op.toString(), hrLeftText));
                    break;
                }
                default: {
                    hrText = LazyString.create(() -> Utils.append("(", hrLeftText, this.op.toString(), hrRightText, ")"));
                }
            }
            return hrText;
        }

        @Override
        public boolean isRand() {
            return this.left.isRand() || this.right != null && this.right.isRand();
        }

        @Override
        public boolean isRuntime() {
            return this.left.isRuntime() || this.right != null && this.right.isRuntime();
        }

        @Override
        public boolean isUninitActionHandle() {
            return this.left.isUninitActionHandle() || this.right != null && this.right.isUninitActionHandle();
        }

        @Override
        public boolean isIndex() {
            return this.left.isIndex() || this.right != null && this.right.isIndex();
        }

        @Override
        public boolean isConstant() {
            return this.left.isConstant() && (this.right == null || this.right.isConstant());
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            if (this.left != null) {
                this.left.evaluateUnintActionHandles(solver);
            }
            if (this.right != null) {
                this.right.evaluateUnintActionHandles(solver);
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.left, this.right);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.left, this.right);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Operator {
            U_NOT{

                public String toString() {
                    return "~";
                }
            }
            ,
            U_OR{

                public String toString() {
                    return "|";
                }
            }
            ,
            U_AND{

                public String toString() {
                    return "&";
                }
            }
            ,
            U_XOR{

                public String toString() {
                    return "^";
                }
            }
            ,
            OR{

                public String toString() {
                    return " | ";
                }
            }
            ,
            AND{

                public String toString() {
                    return " & ";
                }
            }
            ,
            XOR{

                public String toString() {
                    return " ^ ";
                }
            };

        }
    }

    public static class BitSlice
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Expression expression;
        protected Expression leftRange;
        protected Expression rightRange;

        public BitSlice(Expression expression, Expression leftRange, Expression rightRange, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.expression = expression;
            this.leftRange = leftRange;
            this.rightRange = rightRange;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                StringBuilder result = new StringBuilder();
                result.append(this.expression.toString(false));
                result.append("[").append(this.leftRange.toString(false)).append(":").append(this.rightRange.toString(false)).append("]");
                return result.toString();
            });
        }

        @Override
        protected int nofBits() {
            return this.expression.nofBits();
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars = this.expression.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (this.leftRange == this.rightRange && this.leftRange.isRand()) {
                List<ExprAndDep<IntVariable>> leftVars = this.leftRange.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>(vars.size() * leftVars.size());
                IntVariable TRUE = model.getCachedConstant(false, 1, BigInteger.ONE);
                for (ExprAndDep<IntVariable> var1 : vars) {
                    IntVariable var1NofBits = model.getCachedConstant(true, 32, BigInteger.valueOf(((IntVariable)var1.expr).nofBits()));
                    for (ExprAndDep<IntVariable> var2 : leftVars) {
                        String bsText = Utils.append("[", var2.hrText, "]");
                        LazyString hrText = LazyString.create(() -> Utils.append(exprAndDep.hrText, bsText));
                        AbstractConstraint maxIndexValueConstraint = ((IntVariable)var2.expr).lt(var1NofBits);
                        IntVariable resultVariable = ((IntVariable)var1.expr).sr((IntVariable)var2.expr).and(TRUE).and((IntVariable)maxIndexValueConstraint.reify());
                        result.add(new ExprAndDep<IntVariable>(resultVariable, var1.dependencies, var2.dependencies, hrText, this.line));
                    }
                }
                return result;
            }
            List<ExprAndDep<Value>> leftValue = this.leftRange.evaluate(scenario, currentInstanceScope);
            List<ExprAndDep<Value>> rightValue = this.rightRange.evaluate(scenario, currentInstanceScope);
            int leftBit = ((Value)leftValue.get((int)0).expr).getIntValue().intValueExact();
            int rightBit = ((Value)rightValue.get((int)0).expr).getIntValue().intValueExact();
            if (this.endianness() == Endianness.LITTLE && rightBit > leftBit || this.endianness() == Endianness.BIG && leftBit > rightBit) {
                ScenarioUtils.printWarning(Utils.append("Bit-slice [", leftBit, ":", rightBit, "] of '", this.expression.toString(false), "' reversed to [", rightBit, ":", leftBit, "]"), true, this.leftRange.line, this.leftRange.parserPath);
            }
            int nofSliceBits = Math.abs(leftBit - rightBit) + 1;
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>(vars.size());
            String bsText = Utils.append("[", leftBit, ":", rightBit, "]");
            int nofBits = this.expression.nofBits();
            if (rightBit >= nofBits || leftBit >= nofBits || leftBit < 0 || rightBit < 0) {
                throw new Solver.EvaluationException(Utils.append("Bit-slice [", leftBit, ":", rightBit, "] is out of [", nofBits - 1, ":", 0, "] range"), this.leftRange.line, this.leftRange.parserPath);
            }
            if (this.endianness() == Endianness.BIG && leftBit < rightBit) {
                if (nofBits < 0) {
                    throw new UnsupportedOperationException();
                }
                leftBit = nofBits - rightBit - 1;
                rightBit = leftBit + nofSliceBits - 1;
            }
            int shiftBits = Math.min(rightBit, leftBit);
            BigInteger bitsMask = Utils.getPowerOfTwoMask(nofSliceBits);
            for (ExprAndDep<IntVariable> var1 : vars) {
                LazyString hrText = LazyString.create(() -> Utils.append(exprAndDep.hrText, bsText));
                IntVariable shiftedVar = shiftBits == 0 ? (IntVariable)var1.expr : ((IntVariable)var1.expr).sr(Value.from(BigInteger.valueOf(shiftBits), 32, true).intVar(model));
                IntVariable maskedVar = shiftedVar.and(Value.from(bitsMask, nofSliceBits, false).intVar(model));
                result.add(new ExprAndDep<IntVariable>(maskedVar, var1.dependencies, hrText, this.line));
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            List<ExprAndDep<Value>> exprValue = this.expression.evaluate(scenario, currentInstanceScope);
            List<ExprAndDep<Value>> leftValue = this.leftRange.evaluate(scenario, currentInstanceScope);
            List<ExprAndDep<Value>> rightValue = this.rightRange.evaluate(scenario, currentInstanceScope);
            int leftBit = ((Value)leftValue.get((int)0).expr).getIntValue().intValueExact();
            int rightBit = ((Value)rightValue.get((int)0).expr).getIntValue().intValueExact();
            if (this.endianness() == Endianness.LITTLE && rightBit > leftBit || this.endianness() == Endianness.BIG && leftBit > rightBit) {
                ScenarioUtils.printWarning(Utils.append("Bit-slice [", leftBit, ":", rightBit, "] of '", this.expression.toString(false), "' reversed to [", rightBit, ":", leftBit, "]"), true, this.leftRange.line, this.leftRange.parserPath);
            }
            int nofSliceBits = Math.abs(leftBit - rightBit) + 1;
            ArrayList<ExprAndDep<Value>> result = new ArrayList<ExprAndDep<Value>>(exprValue.size());
            int nofBits = this.expression.nofBits();
            if (rightBit >= nofBits || leftBit >= nofBits || leftBit < 0 || rightBit < 0) {
                throw new Solver.EvaluationException(Utils.append("Bit-slice [", leftBit, ":", rightBit, "] is out of [", nofBits - 1, ":", 0, "] range"), this.leftRange.line, this.leftRange.parserPath);
            }
            if (this.endianness() == Endianness.BIG && leftBit < rightBit) {
                if (nofBits < 0) {
                    throw new UnsupportedOperationException();
                }
                leftBit = nofBits - rightBit - 1;
                rightBit = leftBit + nofSliceBits - 1;
            }
            for (ExprAndDep<Value> value : exprValue) {
                if (Value.isInteger((Value)value.expr)) {
                    BigInteger intValue = ((Value)value.expr).getIntValue();
                    intValue = BitVectorInt.from(true, 0).setValue(intValue).getRange(Math.max(rightBit, leftBit), Math.min(rightBit, leftBit)).bigIntegerValue();
                    result.add(new ExprAndDep<Value>(Value.from(intValue, nofSliceBits, false), null, this.toString(true), this.line));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return result;
        }

        @Override
        public boolean isRand() {
            return this.expression.isRand();
        }

        @Override
        public boolean isRuntime() {
            return this.expression.isRuntime();
        }

        @Override
        public boolean isUninitActionHandle() {
            return this.expression.isUninitActionHandle();
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return this.expression.getErrors();
        }

        @Override
        public void cleanErrors() {
            this.expression.cleanErrors();
        }

        @Override
        public boolean isConstant() {
            return this.expression.isConstant();
        }

        @Override
        public Endianness endianness() {
            return this.expression.endianness();
        }
    }

    public static class BoolExpression
    extends PrimaryExpression {
        private static final long serialVersionUID = 1L;

        public BoolExpression(String value, int line, ParserPath parserPath) {
            super(value, line, parserPath);
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            return Collections.singletonList(new ExprAndDep<Value>(Value.from("true".equals(this.value)), null, LazyString.create(() -> this.value), this.line));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            return Collections.singletonList(new ExprAndDep<IntVariable>(model.boolVar("true".equals(this.value) ? BigInteger.ONE : BigInteger.ZERO), null, LazyString.create(() -> this.value), this.line));
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> this.value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class BreakAssign
    extends Assign {
        private static final long serialVersionUID = 1L;

        public BreakAssign(int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> "break");
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                scenario.debugBeginEvaluate(this, currentInstanceScope);
                throw new BreakException();
            }
            catch (Throwable throwable) {
                scenario.debugFinishEvaluate(this, currentInstanceScope);
                throw throwable;
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return null;
        }
    }

    public static class BreakException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class Conditional
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Expression condExpr;
        private Expression trueExpr;
        private Expression falseExpr;

        public Conditional(Expression condExpr, Expression trueExpr, Expression falseExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.condExpr = condExpr;
            this.trueExpr = trueExpr;
            this.falseExpr = falseExpr;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                String result = Utils.append(this.condExpr.toString(), " ? ", this.trueExpr.toString(false), " : ", this.falseExpr.toString(false));
                return enclosed ? Utils.append("(", result, ")") : result;
            });
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            List<ExprAndDep<Value>> condCstrs = this.condExpr.evaluate(scenario, currentInstanceScope);
            if (condCstrs == null || condCstrs.isEmpty()) {
                return Collections.singletonList(new ExprAndDep<Value.ErrorValue>(Value.errorValue(Utils.append("*** Error: Cannot evaluate '", this.condExpr.toString(false), "' expression"), this.line, this.parserPath), null, this.toString(true), this.line));
            }
            for (ExprAndDep<Value> condCstr : condCstrs) {
                if (!Value.isInteger((Value)condCstr.expr) || condCstr.isVacuous() || !((Value)condCstr.expr).getIntValue().equals(BigInteger.ONE)) continue;
                return this.trueExpr.evaluate(scenario, currentInstanceScope);
            }
            return this.falseExpr.evaluate(scenario, currentInstanceScope);
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> condVars = this.condExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            List<ExprAndDep<IntVariable>> trueCondVars = this.trueExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            List<ExprAndDep<IntVariable>> falseCondVars = this.falseExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            IntVariable zero = model.getCachedConstant(false, 1, BigInteger.ZERO);
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            for (ExprAndDep<IntVariable> condVar : condVars) {
                if (condVar == null || condVar.isVacuous()) continue;
                for (ExprAndDep<IntVariable> trueCondVar : trueCondVars) {
                    if (trueCondVar == null || trueCondVar.isVacuous()) continue;
                    for (ExprAndDep<IntVariable> falseCondVar : falseCondVars) {
                        if (falseCondVar == null || falseCondVar.isVacuous()) continue;
                        BoolVariable cond = condVar.expr instanceof BoolVariable ? (BoolVariable)condVar.expr : ((IntVariable)condVar.expr).ne(zero).reify();
                        IntVariable temp = cond.mux((IntVariable)trueCondVar.expr, (IntVariable)falseCondVar.expr);
                        LazyString hrText = LazyString.create(() -> Utils.append(Utils.processHrText(exprAndDep.hrText.toString()), " ? ", Utils.processHrText(exprAndDep2.hrText.toString()), " : ", Utils.processHrText(exprAndDep3.hrText.toString())));
                        result.add(new ExprAndDep<IntVariable>(temp, condVar.dependencies, trueCondVar.dependencies, falseCondVar.dependencies, hrText, this.line));
                    }
                }
            }
            return result;
        }

        @Override
        public boolean isRand() {
            return true;
        }

        @Override
        public boolean isRuntime() {
            return this.condExpr.isRuntime() || this.falseExpr.isRuntime();
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            if (this.condExpr != null) {
                this.condExpr.evaluateUnintActionHandles(solver);
            }
            if (this.trueExpr != null) {
                this.trueExpr.evaluateUnintActionHandles(solver);
            }
            if (this.falseExpr != null) {
                this.falseExpr.evaluateUnintActionHandles(solver);
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.condExpr, this.trueExpr, this.falseExpr);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.condExpr, this.trueExpr, this.falseExpr);
        }
    }

    public static class ContinueAssign
    extends Assign {
        private static final long serialVersionUID = 1L;

        public ContinueAssign(int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> "continue");
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                scenario.debugBeginEvaluate(this, currentInstanceScope);
                throw new ContinueException();
            }
            catch (Throwable throwable) {
                scenario.debugFinishEvaluate(this, currentInstanceScope);
                throw throwable;
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return null;
        }
    }

    public static class ContinueException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class CspConstraint {
        protected AbstractConstraint constraint;
        protected LazyString hrText;

        public CspConstraint(AbstractConstraint cspConstraint, LazyString hrText) {
            this.constraint = cspConstraint;
            this.hrText = hrText;
        }
    }

    public static class Default
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Hid hid;
        private Expression expression;

        public Default(Hid hid, Expression expression, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.hid = hid;
            this.expression = expression;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append(this.hid.toString(false), " == ", this.expression.toString(false)));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars1 = this.hid.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars1 == null || vars1.isEmpty()) {
                return null;
            }
            List<ExprAndDep<IntVariable>> vars2 = this.expression.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            for (ExprAndDep<IntVariable> var1 : vars1) {
                if (var1.isVacuous()) continue;
                if (vars2 == null || vars2.isEmpty()) {
                    return null;
                }
                for (ExprAndDep<IntVariable> var2 : vars2) {
                    if (var1 == var2 || var2.isVacuous()) continue;
                    result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).dflt((IntVariable)var2.expr).reify(), var1.dependencies, var2.dependencies, LazyString.create(() -> Utils.append(exprAndDep.hrText, " == ", exprAndDep2.hrText)), this.line));
                }
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRand() {
            return true;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return this.expression.getErrors();
        }

        @Override
        public void cleanErrors() {
            this.expression.cleanErrors();
        }
    }

    public static class Disable
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Hid hid;

        public Disable(Hid hid, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.hid = hid;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return null;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars1 = this.hid.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars1 == null || vars1.isEmpty()) {
                return null;
            }
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            for (ExprAndDep<IntVariable> var1 : vars1) {
                if (var1.isVacuous()) continue;
                result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).dsbl().reify(), var1.dependencies, LazyString.create(() -> Utils.append("disable ", exprAndDep.hrText)), this.line));
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRand() {
            return true;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return this.hid.getErrors();
        }

        @Override
        public void cleanErrors() {
            this.hid.cleanErrors();
        }
    }

    public static class DistRange
    extends InRange {
        private static final long serialVersionUID = 1L;
        private List<DistItem> distItems = new ArrayList<DistItem>();

        public DistRange(Expression inVarExpr, int line, ParserPath parserPath) {
            super(inVarExpr, line, parserPath);
        }

        @Override
        public void addInRange(Expression leftExpr, Expression rightExpr) {
            this.distItems.add(new DistItem(leftExpr, rightExpr));
        }

        public void addDistWeight(DistKind distKind, Expression weightExpr) {
            Utils.last(this.distItems).addDistWeight(distKind, weightExpr);
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            BigInteger[] weights = new BigInteger[this.distItems.size()];
            AbstractConstraint[] constraints = new AbstractConstraint[this.distItems.size()];
            IntVariable TRUE = model.getCachedConstant(false, 1, BigInteger.ONE);
            StringBuilder hrText = new StringBuilder();
            hrText.append(this.inVarExpr.toString()).append(" dist [");
            int i = 0;
            while (i < this.distItems.size()) {
                Logic inRangeSubExpr;
                DistItem distItem = this.distItems.get(i);
                if (distItem.leftExpr != null && distItem.rightExpr != null && distItem.leftExpr == distItem.rightExpr) {
                    inRangeSubExpr = new Logic(Logic.Operator.EQ, this.inVarExpr, distItem.leftExpr, Logic.TextKind.RHS_TEXT, this.line, this.parserPath);
                } else if (distItem.leftExpr != null && distItem.rightExpr != null) {
                    inRangeSubExpr = new Logic(Logic.Operator.AND, new Logic(Logic.Operator.GTE, this.inVarExpr, distItem.leftExpr, Logic.TextKind.RHS_TEXT, this.line, this.parserPath), new Logic(Logic.Operator.LTE, this.inVarExpr, distItem.rightExpr, Logic.TextKind.RHS_TEXT, this.line, this.parserPath), Logic.TextKind.RANGE_TEXT, this.line, this.parserPath);
                } else if (distItem.leftExpr != null && distItem.rightExpr == null) {
                    inRangeSubExpr = new Logic(Logic.Operator.GTE, this.inVarExpr, distItem.leftExpr, Logic.TextKind.RHS_RANGE_TEXT, this.line, this.parserPath);
                } else if (distItem.leftExpr == null && distItem.rightExpr != null) {
                    inRangeSubExpr = new Logic(Logic.Operator.LTE, this.inVarExpr, distItem.rightExpr, Logic.TextKind.RHS_RANGE_TEXT, this.line, this.parserPath);
                } else {
                    throw new UnsupportedOperationException();
                }
                if (i > 0) {
                    hrText.append(", ");
                }
                List<ExprAndDep<IntVariable>> vars = inRangeSubExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                hrText.append(vars.get((int)0).hrText).append(distItem.distKind == DistKind.SLASH ? " :/ " : " := ").append(distItem.weightExpr);
                List<ExprAndDep<Value>> weigth = distItem.weightExpr.evaluate(scenario, currentInstanceScope);
                weights[i] = ((Value)weigth.get((int)0).expr).getIntValue();
                if (distItem.distKind == DistKind.SLASH) {
                    weights[i] = weights[i].multiply(((IntVariable)vars.get((int)0).expr).getDomain().size());
                }
                ArrayList<AbstractConstraint> rangeConstraints = new ArrayList<AbstractConstraint>();
                for (ExprAndDep<IntVariable> var1 : vars) {
                    if (var1.isVacuous()) continue;
                    AbstractConstraint constraint = ((IntVariable)var1.expr).eq(TRUE);
                    constraint.unpost();
                    rangeConstraints.add(constraint);
                }
                constraints[i] = new ListConstraint(model, rangeConstraints.toArray(new AbstractConstraint[rangeConstraints.size()]));
                ++i;
            }
            String text = hrText.append("]").toString();
            ReifBoolVariable variable = model.dist(constraints, weights).reify();
            return Collections.singletonList(new ExprAndDep<ReifBoolVariable>(variable, null, LazyString.create(() -> text), this.line));
        }

        static class DistItem {
            private DistKind distKind;
            private Expression weightExpr;
            private Expression leftExpr;
            private Expression rightExpr;

            public DistItem(Expression leftExpr, Expression rightExpr) {
                this.leftExpr = leftExpr;
                this.rightExpr = rightExpr;
            }

            public void addDistWeight(DistKind distKind, Expression weightExpr) {
                this.distKind = distKind;
                this.weightExpr = weightExpr;
            }
        }

        public static enum DistKind {
            EQUAL,
            SLASH;

        }
    }

    public static class ExecBlockCall
    extends Assign {
        private static final long serialVersionUID = 1L;
        private ExecBlockKind execKind;
        private Expression execBody;
        private transient RfExecBlock rfExecBlock;

        public ExecBlockCall(RfExecBlock rfExecBlock, ExecBlockKind execKind, Expression execBody, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.rfExecBlock = rfExecBlock;
            this.execKind = execKind;
            this.execBody = execBody;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                scenario.debugBeginEvaluate(this, currentInstanceScope);
                List<ExprAndDep<Value>> list = this.execBody.evaluate(scenario, currentInstanceScope);
                return list;
            }
            finally {
                scenario.debugFinishEvaluate(this, currentInstanceScope);
            }
        }

        public ExecBlockKind getExecKind() {
            return this.execKind;
        }

        public RfExecBlock getRfExecBlock() {
            return this.rfExecBlock;
        }

        @Override
        public String toString() {
            return Utils.append("exec ", this.execKind.toString().toLowerCase(), " ", this.execBody.toString(false));
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfExecBlock);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfExecBlock = (RfExecBlock)ScenarioUtils.getRfOfKey(key);
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            this.execBody.evaluateUnintActionHandles(solver);
        }

        @Override
        public List<ExpressionError> getErrors() {
            return this.execBody.getErrors();
        }
    }

    public static class ExprAndDep<T> {
        protected T expr;
        protected List<InstancesContainer> dependencies;
        protected LazyString hrText;
        protected int line;

        public ExprAndDep(T expr, List<InstancesContainer> dependencies, LazyString hrText, int line) {
            this.expr = expr;
            this.hrText = hrText;
            this.line = line;
            if (dependencies != null) {
                this.dependencies = new ArrayList<InstancesContainer>(dependencies);
            }
        }

        public ExprAndDep(T expr, List<InstancesContainer> dependencies1, List<InstancesContainer> dependencies2, LazyString hrText, int line) {
            this.expr = expr;
            this.hrText = hrText;
            this.line = line;
            ArrayList<InstancesContainer> arrayList = this.dependencies = dependencies1 == null ? null : new ArrayList<InstancesContainer>(dependencies1);
            if (dependencies2 != null) {
                if (this.dependencies == null) {
                    this.dependencies = new ArrayList<InstancesContainer>(dependencies2);
                } else {
                    this.dependencies.addAll(dependencies2);
                }
            }
        }

        public ExprAndDep(T expr, List<InstancesContainer> dependencies1, List<InstancesContainer> dependencies2, List<InstancesContainer> dependencies3, LazyString hrText, int line) {
            this.expr = expr;
            this.hrText = hrText;
            this.line = line;
            ArrayList<InstancesContainer> arrayList = this.dependencies = dependencies1 == null ? null : new ArrayList<InstancesContainer>(dependencies1);
            if (dependencies2 != null) {
                if (this.dependencies == null) {
                    this.dependencies = new ArrayList<InstancesContainer>(dependencies2);
                } else {
                    this.dependencies.addAll(dependencies2);
                }
            }
            if (dependencies3 != null) {
                if (this.dependencies == null) {
                    this.dependencies = new ArrayList<InstancesContainer>(dependencies3);
                } else {
                    this.dependencies.addAll(dependencies3);
                }
            }
        }

        public ExprAndDep(T expr, InstancesContainer dependency, LazyString hrText, int line) {
            this.expr = expr;
            this.hrText = hrText;
            this.line = line;
            if (dependency != null) {
                this.dependencies = new ArrayList<InstancesContainer>();
                this.dependencies.add(dependency);
            }
        }

        public boolean isVacuous() {
            if (this.expr == null) {
                return true;
            }
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                return false;
            }
            int i = 0;
            while (i < this.dependencies.size()) {
                InstancesContainer dep1 = this.dependencies.get(i);
                int j = i + 1;
                while (j < this.dependencies.size()) {
                    InstancesContainer dep2 = this.dependencies.get(j);
                    if (dep1 != dep2) {
                        ActionInstance a1;
                        ActionInstance actionInstance = a1 = dep1 instanceof ActionInstance ? (ActionInstance)dep1 : dep1.getParentActionInstance();
                        if (a1 != null) {
                            ActionInstance a2;
                            ActionInstance actionInstance2 = a2 = dep2 instanceof ActionInstance ? (ActionInstance)dep2 : dep2.getParentActionInstance();
                            if (a2 != null && Utils.isVacuous(a1, a2)) {
                                return true;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }

        public T value() {
            return this.expr;
        }
    }

    public static class ExpressionError {
        protected int line;
        protected ParserPath parserPath;
        protected String message;

        public ExpressionError(String message, int line, ParserPath parserPath) {
            this.message = message;
            this.line = line;
            this.parserPath = parserPath;
        }

        public String getMessage() {
            return this.message;
        }

        public void printMessage() {
            ScenarioUtils.printError(this.message, true, this.line, this.parserPath);
        }

        public void logMessage() {
            ScenarioUtils.logError(this.message, this.line, this.parserPath);
            throw new Solver.SolverException();
        }
    }

    public static class ExpressionWarning
    extends ExpressionError {
        public ExpressionWarning(String message, int line, ParserPath parserPath) {
            super(message, line, parserPath);
        }

        @Override
        public void printMessage() {
            ScenarioUtils.printWarning(this.message, true, this.line, this.parserPath);
        }

        @Override
        public void logMessage() {
            ScenarioUtils.logWarning(this.message, this.line, this.parserPath);
            throw new Solver.SolverException();
        }
    }

    public static class Forall
    extends Expression {
        private static final long serialVersionUID = 1L;
        private transient RfField.RfIteratorField rfIteratorField;
        private transient RfNamedElement rfType;
        private Hid pathExpr;
        private Expression constraintExpr;

        public Forall(RfField.RfIteratorField rfIteratorField, RfNamedElement rfType, Hid pathExpr, Expression constraintExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.rfType = rfType;
            this.rfIteratorField = rfIteratorField;
            this.pathExpr = pathExpr;
            this.constraintExpr = constraintExpr;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return null;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            ArrayList<InstancesContainer> itemInstanceCandidates = new ArrayList<InstancesContainer>();
            if (this.pathExpr != null) {
                List<InstancePath> foreachInstancePath = this.pathExpr.getVariablesPaths(scenario, false, currentInstanceScope, false, Integer.MAX_VALUE);
                if (foreachInstancePath != null && !foreachInstancePath.isEmpty()) {
                    for (InstancePath instancePath : foreachInstancePath) {
                        instancePath.getInstance().collectInstancesOfType(itemInstanceCandidates, this.rfType);
                    }
                }
            } else {
                forallInstanceScope.collectInstancesOfType(itemInstanceCandidates, this.rfType);
            }
            NestedBlockContext blockInstanceScope = new NestedBlockContext("[block]", currentInstanceScope.runtimeId, currentInstanceScope, scenario);
            VariableInstance iteratorFieldInstance = new VariableInstance(this.rfIteratorField, this.rfIteratorField.getAssociatedType(), -1, -1, currentInstanceScope.runtimeId, scenario);
            blockInstanceScope.addChildFieldInstance(ScenarioUtils.getDeduplicateName(this.rfIteratorField), iteratorFieldInstance, false);
            for (InstancesContainer itemInstanceCandidate : itemInstanceCandidates) {
                iteratorFieldInstance.setVariableValue(Value.from(itemInstanceCandidate, -1, false));
                List<ExprAndDep<IntVariable>> variables = this.constraintExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, blockInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                result.addAll(variables);
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRand() {
            return true;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.pathExpr, this.constraintExpr);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.pathExpr, this.constraintExpr);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfIteratorField);
            out.writeInt(key);
            key = ScenarioUtils.getKeyOfRf(this.rfType);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfIteratorField = (RfField.RfIteratorField)ScenarioUtils.getRfOfKey(key);
            key = in.readInt();
            this.rfType = ScenarioUtils.getRfOfKey(key);
        }
    }

    public static class Foreach
    extends Expression {
        private static final long serialVersionUID = 1L;
        private transient RfField.RfIndexField rfIndexField;
        private transient RfField.RfIteratorField rfIteratorField;
        private Expression foreachExpr;
        private Expression constraintExpr;

        public Foreach(RfField.RfIndexField rfIndexField, RfField.RfIteratorField rfIteratorField, Expression foreachExpr, Expression constraintExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.rfIndexField = rfIndexField;
            this.foreachExpr = foreachExpr;
            this.rfIteratorField = rfIteratorField;
            this.constraintExpr = constraintExpr;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return null;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            Solver solver = scenario.getSolver();
            if (!(this.foreachExpr instanceof Hid) && !(this.foreachExpr instanceof IntExpression)) {
                throw new Solver.EvaluationException(Utils.append("Unsupported foreach expression '", this.foreachExpr, "'"), this.line, this.parserPath);
            }
            RfField rfField = ((Hid)this.foreachExpr).getLastField();
            if (rfField.isContainerType() && !rfField.isFixedSizeArray()) {
                throw new Solver.EvaluationException(Utils.append("Unsupported constraint foreach iterating on non-fixed size array expression '", this.foreachExpr, "'"), this.line, this.parserPath);
            }
            if (rfField.isActionHandle() && !(this.foreachExpr instanceof Hid)) {
                throw new Solver.EvaluationException(Utils.append("Unsupported constraint foreach iterating on array of action handle expression '", this.foreachExpr, "'"), this.line, this.parserPath);
            }
            int nofRepeats = 0;
            InstancesContainer collectionInstance = null;
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            NestedBlockContext blockInstanceScope = new NestedBlockContext("[block]", currentInstanceScope.runtimeId, currentInstanceScope, scenario);
            VariableInstance iteratorFieldInstance = null;
            if (this.rfIteratorField != null) {
                iteratorFieldInstance = new VariableInstance(this.rfIteratorField, this.rfIteratorField.getAssociatedType(), -1, -1, currentInstanceScope.runtimeId, scenario);
                blockInstanceScope.addChildFieldInstance(ScenarioUtils.getDeduplicateName(this.rfIteratorField), iteratorFieldInstance, false);
            }
            VariableInstance indexFieldInstance = null;
            if (this.rfIndexField != null) {
                indexFieldInstance = new VariableInstance(this.rfIndexField, solver.intType, -1, -1, currentInstanceScope.runtimeId, scenario);
                blockInstanceScope.addChildFieldInstance(ScenarioUtils.getDeduplicateName(this.rfIndexField), indexFieldInstance, false);
            }
            if (rfField.isActionHandle()) {
                nofRepeats = rfField.getAssociatedTypeArrayDimAsInteger();
                int i = 0;
                while (i < nofRepeats) {
                    List<InstancesContainer> list;
                    solver.checkInterrupted();
                    if (indexFieldInstance != null) {
                        indexFieldInstance.setVariableValue(Value.from(BigInteger.valueOf(i), 32, true));
                    }
                    ArrayList<Id> hid = new ArrayList<Id>(((Hid)this.foreachExpr).ids);
                    Hid iteratorExpr = new Hid(hid, this.foreachExpr.line, this.foreachExpr.parserPath);
                    Utils.last(iteratorExpr.getIds()).select = new IntExpression(Integer.toString(i), BigInteger.valueOf(i), true, this.foreachExpr.line, this.foreachExpr.parserPath);
                    InstancePath hidHierarchicalPath = iteratorExpr.getHierarchicalPath(scenario, false, blockInstanceScope);
                    if (hidHierarchicalPath != null && (list = InstancePath.getInstanceInScope(hidHierarchicalPath, blockInstanceScope, keepClosestToMax, maxTraversalIndex)) != null && !list.isEmpty()) {
                        for (InstancesContainer itemInstanceCandidate : list) {
                            if (iteratorFieldInstance != null) {
                                iteratorFieldInstance.setVariableValue(Value.from(itemInstanceCandidate, -1, false));
                            }
                            List<ExprAndDep<IntVariable>> variables = this.constraintExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, blockInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                            result.addAll(variables);
                        }
                    }
                    ++i;
                }
                return result;
            }
            List<InstancePath> foreachInstancePaths = ((Hid)this.foreachExpr).getVariablesPaths(scenario, false, blockInstanceScope, false, maxTraversalIndex);
            if (foreachInstancePaths == null || foreachInstancePaths.isEmpty()) {
                return null;
            }
            for (InstancePath foreachInstancePath : foreachInstancePaths) {
                collectionInstance = foreachInstancePath.getInstance();
                if (collectionInstance != null) {
                    int n = nofRepeats = !collectionInstance.isCollectionType() ? collectionInstance.nofBits() : collectionInstance.arraySize;
                }
                if (collectionInstance != null && collectionInstance.isCollectionType()) {
                    Collection<? extends InstancesContainer> itemInstanceCandidates = collectionInstance.getMembers();
                    for (InstancesContainer instancesContainer : itemInstanceCandidates) {
                        solver.checkInterrupted();
                        if (instancesContainer.arrayItemIndex < 0) continue;
                        if (indexFieldInstance != null) {
                            indexFieldInstance.setVariableValue(Value.from(BigInteger.valueOf(instancesContainer.arrayItemIndex), 32, true));
                        }
                        if (iteratorFieldInstance != null) {
                            iteratorFieldInstance.setVariableValue(Value.from(instancesContainer, -1, false));
                        }
                        List<ExprAndDep<IntVariable>> variables = this.constraintExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, blockInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                        result.addAll(variables);
                    }
                    continue;
                }
                int i = 0;
                while (i < nofRepeats) {
                    solver.checkInterrupted();
                    if (indexFieldInstance != null) {
                        indexFieldInstance.setVariableValue(Value.from(BigInteger.valueOf(i), 32, true));
                    }
                    if (iteratorFieldInstance != null) {
                        iteratorFieldInstance.setVariableValue(Value.from(BigInteger.valueOf(i), 32, true));
                    }
                    List<ExprAndDep<IntVariable>> list = this.constraintExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, blockInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    result.addAll(list);
                    ++i;
                }
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRand() {
            return true;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return this.foreachExpr.getErrors();
        }

        @Override
        public void cleanErrors() {
            this.foreachExpr.cleanErrors();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfIndexField);
            out.writeInt(key);
            key = ScenarioUtils.getKeyOfRf(this.rfIteratorField);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfIndexField = (RfField.RfIndexField)ScenarioUtils.getRfOfKey(key);
            key = in.readInt();
            this.rfIteratorField = (RfField.RfIteratorField)ScenarioUtils.getRfOfKey(key);
        }
    }

    public static class ForeachAssign
    extends Assign {
        private static final long serialVersionUID = 1L;
        protected Expression expression;
        protected Expression bodyExpression;
        private transient RfField.RfIndexField rfIndexField;
        private transient RfField.RfIteratorField rfIteratorField;
        private transient RfStruct rfStructType;

        public ForeachAssign(RfStruct rfStructType, Expression expression, RfField.RfIndexField rfIndexField, RfField.RfIteratorField rfIteratorField, Expression bodyExpression, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.expression = expression;
            this.rfIndexField = rfIndexField;
            this.rfIteratorField = rfIteratorField;
            this.bodyExpression = bodyExpression;
            this.rfStructType = rfStructType;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("foreach (", this.expression.toString(), ")"));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            block23: {
                block21: {
                    Solver solver = scenario.getSolver();
                    try {
                        try {
                            scenario.debugBeginEvaluate(this, currentInstanceScope);
                            NestedBlockContext blockInstanceScope = new NestedBlockContext("[block]", currentInstanceScope.runtimeId, currentInstanceScope, scenario);
                            if (this.rfIteratorField != null) {
                                List<ExprAndDep<Value>> value = this.expression.evaluate(scenario, currentInstanceScope);
                                if (value == null || value.size() != 1) {
                                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.expression.toString(false), "' expression"), this.line, this.parserPath);
                                }
                                InstancesContainer collectionInstance = Utils.unwrapReferenceInstance(((Value)value.get((int)0).expr).getRefValue());
                                Collection<? extends InstancesContainer> itemInstanceCandidates = collectionInstance.getMembers();
                                VariableInstance iteratorFieldInstance = new VariableInstance(this.rfIteratorField, this.rfIteratorField.getAssociatedType(), -1, -1, currentInstanceScope.runtimeId, scenario);
                                blockInstanceScope.addChildFieldInstance(ScenarioUtils.getDeduplicateName(this.rfIteratorField), iteratorFieldInstance, false);
                                VariableInstance indexFieldInstance = null;
                                if (this.rfIndexField != null) {
                                    indexFieldInstance = new VariableInstance(this.rfIndexField, solver.intType, -1, -1, currentInstanceScope.runtimeId, scenario);
                                    blockInstanceScope.addChildFieldInstance(ScenarioUtils.getDeduplicateName(this.rfIndexField), indexFieldInstance, false);
                                }
                                for (InstancesContainer instancesContainer : itemInstanceCandidates) {
                                    solver.checkInterrupted();
                                    if (instancesContainer.arrayItemIndex < 0) continue;
                                    if (indexFieldInstance != null) {
                                        indexFieldInstance.setVariableValue(Value.from(BigInteger.valueOf(instancesContainer.arrayItemIndex), 32, true));
                                    }
                                    iteratorFieldInstance.setVariableValue(Value.from(instancesContainer, -1, false));
                                    try {
                                        if (this.bodyExpression == null) continue;
                                        this.bodyExpression.evaluate(scenario, blockInstanceScope);
                                    }
                                    catch (BreakException breakException) {
                                        break block21;
                                    }
                                    catch (ContinueException continueException) {}
                                }
                                break block21;
                            }
                            int nofRepeats = this.getNofRepeats(scenario, currentInstanceScope);
                            VariableInstance indexFieldInstance = null;
                            if (this.rfIndexField != null) {
                                indexFieldInstance = new VariableInstance(this.rfIndexField, solver.intType, -1, -1, currentInstanceScope.runtimeId, scenario);
                                blockInstanceScope.addChildFieldInstance(this.rfIndexField.getElabName(), indexFieldInstance, false);
                            }
                            int i = 0;
                            while (i < nofRepeats) {
                                solver.checkInterrupted();
                                if (indexFieldInstance != null) {
                                    indexFieldInstance.setVariableValue(Value.from(BigInteger.valueOf(i), 32, true));
                                }
                                try {
                                    if (this.bodyExpression != null) {
                                        this.bodyExpression.evaluate(scenario, blockInstanceScope);
                                    }
                                }
                                catch (BreakException breakException) {
                                    break;
                                }
                                catch (ContinueException continueException) {}
                                ++i;
                            }
                        }
                        catch (Solver.EvaluationException e) {
                            ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                            throw new Solver.InterruptException();
                        }
                        catch (ReturnException | Solver.InterruptException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            scenario.debugFinishEvaluate(this, currentInstanceScope);
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        scenario.debugFinishEvaluate(this, currentInstanceScope);
                        throw throwable;
                    }
                }
                scenario.debugFinishEvaluate(this, currentInstanceScope);
            }
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
        }

        protected int getNofRepeats(Scenario scenario, InstancesContainer currentInstanceScope) {
            Solver solver = scenario.getSolver();
            return solver.evalForeach(currentInstanceScope, this.expression, false, this.line, this.parserPath);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfIndexField);
            out.writeInt(key);
            key = ScenarioUtils.getKeyOfRf(this.rfIteratorField);
            out.writeInt(key);
            key = ScenarioUtils.getKeyOfRf(this.rfStructType);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfIndexField = (RfField.RfIndexField)ScenarioUtils.getRfOfKey(key);
            key = in.readInt();
            this.rfIteratorField = (RfField.RfIteratorField)ScenarioUtils.getRfOfKey(key);
            key = in.readInt();
            this.rfStructType = (RfStruct)ScenarioUtils.getRfOfKey(key);
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            this.expression.evaluateUnintActionHandles(solver);
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.expression, this.bodyExpression);
        }
    }

    public static class Hid
    extends Expression {
        private static final long serialVersionUID = 1L;
        protected List<Id> ids;

        public Hid(List<Id> ids, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.ids = ids;
        }

        public Expression getFinalExpr() {
            Id lastId = Utils.last(this.ids);
            if (lastId == null) {
                return this;
            }
            if (lastId.select == null) {
                return this;
            }
            RfNamedElement rfFieldType = this.getAssociatedType(false);
            if (rfFieldType == null || !rfFieldType.isNumericType()) {
                return this;
            }
            Expression leftRange = lastId.select;
            if (lastId.rfField == null) {
                this.ids.remove(this.ids.size() - 1);
            } else {
                lastId.select = null;
            }
            return new BitSlice(this, leftRange, leftRange, this.line, this.parserPath);
        }

        public List<Id> getIds() {
            return this.ids;
        }

        public RfField getLastField() {
            int i = this.ids.size() - 1;
            while (i >= 0) {
                if (this.ids.get((int)i).rfField != null) {
                    return this.ids.get((int)i).rfField;
                }
                --i;
            }
            return null;
        }

        public boolean isEmpty() {
            return this.ids.isEmpty();
        }

        @Override
        public boolean isRuntime() {
            RfField rfField = this.getLastField();
            return rfField != null && rfField.isRuntime();
        }

        public boolean isStructType(StructKind structKind) {
            RfNamedElement rfFieldType = this.getAssociatedType(true);
            return rfFieldType instanceof RfStruct && (structKind == null || ((RfStruct)rfFieldType).getStructKind() == structKind);
        }

        public RfNamedElement getAssociatedType(boolean isUseLastSelect) {
            int size = this.ids.size();
            int i = size - 1;
            while (i >= 0) {
                if (this.ids.get((int)i).rfField != null) {
                    RfNamedElement rfFieldType = Utils.getAssociatedType(this.ids.get((int)i).rfField);
                    int j = i;
                    while (j < size) {
                        if (this.ids.get((int)j).select != null) {
                            boolean isLastSelect;
                            boolean bl = isLastSelect = j == size - 1;
                            if (isLastSelect && !isUseLastSelect) {
                                return rfFieldType;
                            }
                            if (isLastSelect && rfFieldType.isNumericType()) {
                                return rfFieldType;
                            }
                            if (!(rfFieldType instanceof IRfAssociatedType)) {
                                return null;
                            }
                            rfFieldType = Utils.getAssociatedType((IRfAssociatedType)((Object)rfFieldType));
                        }
                        ++j;
                    }
                    return rfFieldType;
                }
                --i;
            }
            return null;
        }

        public boolean isArrayType() {
            RfNamedElement rfFieldType = this.getAssociatedType(true);
            return rfFieldType instanceof RfCollectionType;
        }

        protected InstancePath getHierarchicalPath(Scenario scenario, boolean addUniqueIdForPointers, InstancesContainer currentInstanceScope) {
            InstancePath varHierarchicalPath = new InstancePath();
            RfNamedElement rfFieldType = null;
            for (Id id : this.ids) {
                DummyFieldInstance instance;
                if (id.isUndeclaredIdentifier()) {
                    throw new Solver.SkipEvaluationException();
                }
                if (id.rfField != null && id.isMethodCall()) {
                    instance = id.toInstance(scenario, currentInstanceScope, this.line, this.parserPath);
                    varHierarchicalPath.append(instance);
                    continue;
                }
                if (id.rfField != null) {
                    instance = id.toInstance(scenario, currentInstanceScope, this.line, this.parserPath);
                    varHierarchicalPath.append(instance);
                    rfFieldType = Utils.getAssociatedType(id.rfField);
                    rfFieldType = id.hasSelect() && rfFieldType instanceof RfCollectionType ? Utils.getArrayItemType((RfCollectionType)rfFieldType) : rfFieldType;
                    continue;
                }
                if (id.select == null) continue;
                Value value = id.toSelect(scenario, currentInstanceScope, this.line, this.parserPath);
                if (rfFieldType instanceof RfCollectionType && ((RfCollectionType)rfFieldType).isMapType()) {
                    String mapItemKey = value.getValue().toString();
                    varHierarchicalPath.append(mapItemKey);
                    rfFieldType = Utils.getArrayItemType((RfCollectionType)rfFieldType);
                    continue;
                }
                if (rfFieldType instanceof RfCollectionType && Value.isInteger(value)) {
                    int index = value.getIntValue().intValueExact();
                    varHierarchicalPath.append(index);
                    rfFieldType = Utils.getArrayItemType((RfCollectionType)rfFieldType);
                    continue;
                }
                throw new Solver.EvaluationException(Utils.append("Fail to evaluate '", this.toString(false), "'"), this.line, this.parserPath);
            }
            if (addUniqueIdForPointers && this.isPointer()) {
                DataType dataType = new DataType("int").set(31, 0, false);
                RfField rfField = new RfField("[unique_id]", dataType);
                RfPredefinedType rfUniqueFieldType = scenario.getSolver().intType;
                rfField.setAssociatedType(rfUniqueFieldType);
                varHierarchicalPath.append(new DummyFieldInstance(rfField, -1, -1));
            }
            return varHierarchicalPath;
        }

        private final boolean isPointer() {
            RfField rfField = this.getLastField();
            if (rfField == null) {
                return false;
            }
            FieldModifier fieldModifier = rfField.getFieldModifier();
            if (fieldModifier == FieldModifier.INPUT || fieldModifier == FieldModifier.OUTPUT || fieldModifier == FieldModifier.LOCK || fieldModifier == FieldModifier.SHARE) {
                return false;
            }
            RfNamedElement rfFieldType = this.getAssociatedType(true);
            if (!(rfFieldType instanceof RfStruct)) {
                return false;
            }
            StructKind structKind = ((RfStruct)rfFieldType).getStructKind();
            return structKind == StructKind.COMPONENT || structKind == StructKind.ACTION || structKind == StructKind.ACTION_ABSTRACT;
        }

        @Override
        public boolean isRand() {
            RfField rfField = this.getLastField();
            if (Utils.isRand(rfField)) {
                return true;
            }
            for (Id id : this.ids) {
                if (id.rfField == null || id.rfField instanceof RfFieldWrapper && ((RfFieldWrapper)id.rfField).getWrappedElement() instanceof RfBlock) continue;
                if (id.rfField instanceof RfFieldWrapper && ((RfFieldWrapper)id.rfField).getWrappedElement() instanceof RfMethod) {
                    return false;
                }
                if (!Utils.isRand(id.rfField)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            int i = 0;
            while (i < this.ids.size() - 1) {
                if (this.ids.get((int)i).isUninitActionHandle) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            for (Id id : this.ids) {
                id.isUninitActionHandle = solver.isUninitActionHandle(id.rfField);
            }
        }

        @Override
        public boolean isIndex() {
            if (this.isStructType(null) || this.isArrayType()) {
                return false;
            }
            RfField rfField = this.getLastField();
            return rfField != null && rfField.isIndex();
        }

        public boolean isActionHandle() {
            RfField rfField = this.getLastField();
            return rfField != null && rfField.isActionHandle();
        }

        @Override
        public LazyString toString(boolean enclosed) {
            StringBuilder result = new StringBuilder();
            for (Id id : this.ids) {
                if (id.rfField == null && id.hasSelect()) {
                    id.toString(result, true);
                    continue;
                }
                if (result.length() != 0) {
                    result.append(".");
                }
                id.toString(result, false);
            }
            return LazyString.create(() -> result.toString());
        }

        public List<InstancePath> getVariablesPaths(Scenario scenario, boolean addUniqueIdForPointers, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex) {
            List<InstancesContainer> instances;
            block11: {
                InstancePath hidHierarchicalPath;
                block10: {
                    block9: {
                        if (!this.isUninitActionHandle()) break block9;
                        return null;
                    }
                    if (this.isIndex()) {
                        InstancePath hidHierarchicalPath2 = this.getHierarchicalPath(scenario, addUniqueIdForPointers, currentInstanceScope);
                        return Collections.singletonList(hidHierarchicalPath2);
                    }
                    RfField rfField = this.ids.get((int)0).rfField;
                    if (rfField instanceof RfEnumItem) {
                        RfNamedElement enclosing1 = rfField.getEnclosingScope();
                        RfPredefinedField rfField1 = new RfPredefinedField(ScenarioUtils.getDeduplicateName(enclosing1), new DataType(ScenarioUtils.getDeduplicateName(enclosing1)), null);
                        rfField1.setAssociatedType(enclosing1);
                        RfNamedElement enclosing2 = enclosing1.getEnclosingScope();
                        RfPredefinedField rfField2 = new RfPredefinedField(ScenarioUtils.getDeduplicateName(enclosing2), new DataType(ScenarioUtils.getDeduplicateName(enclosing2)), null);
                        rfField2.setAssociatedType(enclosing2);
                        return Collections.singletonList(new InstancePath().append(new DummyFieldInstance(rfField2, -1, -1)).append(new DummyFieldInstance(rfField1, -1, -1)).append(new DummyFieldInstance(rfField, -1, -1)));
                    }
                    if (rfField instanceof RfTemplateParam.RfInstanceValueParam) {
                        DummyFieldInstance instance = new DummyFieldInstance(rfField, -1, -1);
                        instance.scenario = scenario;
                        return Collections.singletonList(new InstancePath().append(instance));
                    }
                    hidHierarchicalPath = this.getHierarchicalPath(scenario, addUniqueIdForPointers, currentInstanceScope);
                    if (hidHierarchicalPath != null) break block10;
                    return null;
                }
                instances = InstancePath.getInstanceInScope(hidHierarchicalPath, currentInstanceScope, keepClosestToMax, maxTraversalIndex);
                if (instances != null && !instances.isEmpty()) break block11;
                return null;
            }
            try {
                ArrayList<InstancePath> result = new ArrayList<InstancePath>(instances.size());
                for (InstancesContainer instance : instances) {
                    result.add(instance.getHierarchicalPath());
                }
                return result;
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                throw new Solver.InterruptException();
            }
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            List<InstancePath> varInstancePaths = this.getVarInstancePaths(scenario, false, currentInstanceScope, false, Integer.MAX_VALUE, true);
            if (varInstancePaths == null) {
                return null;
            }
            List<ExpressionError> errors = this.getErrors();
            if (errors != null && !errors.isEmpty()) {
                for (ExpressionError error : errors) {
                    error.printMessage();
                }
                return null;
            }
            ArrayList<ExprAndDep<Value>> result = new ArrayList<ExprAndDep<Value>>(varInstancePaths.size());
            for (InstancePath varInstancePath : varInstancePaths) {
                InstancesContainer fieldInstance = varInstancePath.getInstance();
                LazyString hrText = LazyString.create(() -> fieldInstance.toStringVariableValue());
                if (fieldInstance instanceof MethodCallInstance) {
                    Value value = ((MethodCallInstance)fieldInstance).evaluateMethodCall(currentInstanceScope);
                    if (value == null) continue;
                    result.add(new ExprAndDep<Value>(value, fieldInstance, hrText, this.line));
                    continue;
                }
                if (fieldInstance.isRef() && fieldInstance.getVariableValue() == null) {
                    result.add(new ExprAndDep<Value>(Value.from(null, -1, false), fieldInstance, hrText, this.line));
                    continue;
                }
                if (fieldInstance.isCollectionType() || fieldInstance.isStructType() || fieldInstance.isEnumType()) {
                    result.add(new ExprAndDep<Value>(Value.from(fieldInstance, fieldInstance.nofBits(), fieldInstance.hasSign()), fieldInstance, hrText, this.line));
                    continue;
                }
                if (fieldInstance.isStringType() || Value.isString(fieldInstance.getVariableValue())) {
                    result.add(new ExprAndDep<Value>(Value.from(fieldInstance.getStringVariableValue(), -1, false), fieldInstance, hrText, this.line));
                    continue;
                }
                if (fieldInstance.isHandleType()) {
                    result.add(new ExprAndDep<Value>(Value.from(fieldInstance.getVariableValue()), fieldInstance, hrText, this.line));
                    continue;
                }
                result.add(new ExprAndDep<Value>(Value.from(fieldInstance.getIntegerVariableValue(), fieldInstance.nofBits(), fieldInstance.hasSign()), fieldInstance, hrText, this.line));
            }
            return result.isEmpty() ? null : result;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            RfField rfField = this.getLastField();
            Expression namedConstraintExpr = this.getNamedConstraintExpression(scenario, rfField);
            if (namedConstraintExpr != null) {
                return namedConstraintExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            }
            List<InstancePath> varInstancePaths = this.getVarInstancePaths(scenario, true, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (varInstancePaths == null) {
                return null;
            }
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>(varInstancePaths.size());
            for (InstancePath varInstancePath : varInstancePaths) {
                InstancesContainer fieldInstance = varInstancePath.getInstance();
                LazyString hrText = LazyString.create(() -> "");
                if (fieldInstance instanceof MethodCallInstance) {
                    MethodCall methodCallExpr = ((MethodCallInstance)fieldInstance).toMethodCallExpr();
                    List<ExprAndDep<IntVariable>> vars = methodCallExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    result.addAll(vars);
                    continue;
                }
                RfField rfField2 = fieldInstance.getRfField();
                hrText = rfField2 != null && rfField2.isIndex() ? LazyString.create(() -> fieldInstance.toStringVariableValue()) : (fieldInstance.isUniqueIdField() && ((FieldInstance)fieldInstance).getParentInstance().isCollectionType() ? LazyString.create(() -> varInstancePath.removeLastSegment().asString()) : (rfField2 instanceof RfEnumItem ? LazyString.create(() -> rfField2.getElabName()) : LazyString.create(() -> varInstancePath.asString())));
                result.add(new ExprAndDep<IntVariable>(fieldInstance.getVariable(model, null, varInstancePath, variableSolverMap, true), fieldInstance, hrText, this.line));
            }
            return result;
        }

        private final Expression getNamedConstraintExpression(Scenario scenario, RfField rfField) {
            if (rfField instanceof RfFieldWrapper) {
                RfNamedElement wrappedElement = ((RfFieldWrapper)rfField).getWrappedElement();
                String constraintName = ScenarioUtils.getDeduplicateName(wrappedElement);
                if (wrappedElement instanceof RfBlock && ((RfBlock)wrappedElement).isConstraint()) {
                    RfNamedElement enclosingScope = wrappedElement.getEnclosingScope();
                    Object constraints = scenario.dynamicConstraintDescriptors.get(enclosingScope);
                    if (constraints != null && !constraints.isEmpty() && constraints.containsKey(constraintName)) {
                        return (Expression)constraints.get(constraintName);
                    }
                    constraints = scenario.constraintDescriptors.get(enclosingScope);
                    if (constraints != null && !constraints.isEmpty()) {
                        Iterator iterator = constraints.iterator();
                        while (iterator.hasNext()) {
                            ConstraintDescriptor constraint = (ConstraintDescriptor)iterator.next();
                            if (constraint.name == null || !constraint.name.equals(constraintName)) continue;
                            return constraint.expression;
                        }
                    }
                    throw new Solver.EvaluationException(Utils.append("Fail to evaluate '", this.toString(false), "' named constraint"), this.line, this.parserPath);
                }
            }
            return null;
        }

        public List<InstancePath> getVarInstancePaths(Scenario scenario, boolean addUniqueIdForPointers, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<InstancePath> varInstancePaths = this.getVariablesPaths(scenario, addUniqueIdForPointers, currentInstanceScope, keepClosestToMax, maxTraversalIndex);
            if (varInstancePaths == null || varInstancePaths.isEmpty()) {
                if (reportEvaluationError) {
                    if (this.isUninitActionHandle()) {
                        throw new Solver.EvaluationException(Utils.append("Cannot access attributes of uninitialized action-handle '", this.toString(false), "'"), this.line, this.parserPath);
                    }
                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.toString(false), "' variable instance"), this.line, this.parserPath);
                }
                return null;
            }
            return varInstancePaths;
        }

        @Override
        public List<ExpressionError> getErrors() {
            ArrayList<ExpressionError> result = null;
            for (Id id : this.ids) {
                List<ExpressionError> errors = id.getErrors();
                if (errors == null || errors.isEmpty()) continue;
                if (result == null) {
                    result = new ArrayList<ExpressionError>();
                }
                result.addAll(errors);
            }
            return result;
        }

        @Override
        public void cleanErrors() {
            for (Id id : this.ids) {
                id.cleanErrors();
            }
        }

        public int size() {
            return this.ids.size();
        }

        @Override
        public boolean isConstant() {
            RfField rfField = this.getLastField();
            return rfField != null && (rfField.getFieldModifier() == FieldModifier.CONST || rfField.getFieldModifier() == FieldModifier.STATIC_CONST);
        }

        @Override
        public Endianness endianness() {
            RfField lastField = this.getLastField();
            if (lastField == null) {
                return Endianness.LITTLE;
            }
            DataType dataType = lastField.getDataType();
            if (dataType == null) {
                return Endianness.LITTLE;
            }
            return dataType.endianness();
        }

        @Override
        protected int nofBits() {
            RfField lastField = this.getLastField();
            if (lastField == null) {
                throw new UnsupportedOperationException();
            }
            int nofBits = SemanticUtils.nofBits(lastField);
            if (nofBits <= 0) {
                throw new UnsupportedOperationException();
            }
            return nofBits;
        }
    }

    public static class Id
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Expression select;
        private transient RfField rfField;
        private transient ExpressionError evaluationError;
        private boolean isUninitActionHandle;
        private List<Expression> arguments;

        public Id(RfField rfField) {
            this(rfField, null);
        }

        public static Id undeclaredId(String name) {
            return new Id(new RfFieldWrapper(name, SemanticWalker.UNRESOLVED_ELEMENT));
        }

        public Id(RfField rfField, Expression select) {
            this.rfField = rfField;
            this.select = select;
        }

        public boolean hasSelect() {
            return this.select != null;
        }

        public void setSelect(Expression select) {
            Assert.isTrue((this.select == null ? 1 : 0) != 0);
            this.select = select;
        }

        public RfNamedElement getAssociatedType() {
            if (this.rfField == null) {
                return null;
            }
            RfNamedElement rfFieldType = Utils.getAssociatedType(this.rfField);
            if (this.isArrayItem()) {
                if (rfFieldType.isNumericType()) {
                    return rfFieldType;
                }
                return Utils.getArrayItemType((RfCollectionType)rfFieldType);
            }
            return rfFieldType;
        }

        public void setUninitActionHandle(boolean isUninitActionHandle) {
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            this.toString(result, false);
            return result.toString();
        }

        protected void toString(StringBuilder result, boolean isSelect) {
            if (!isSelect && this.rfField != null) {
                result.append(this.rfField.getElabName());
            }
            if (this.select != null) {
                result.append("[").append(this.select.toString(false)).append("]");
            }
        }

        protected Value toSelect(Scenario scenario, InstancesContainer currentInstanceScope, int line, ParserPath parserPath) {
            if (this.select == null) {
                return Value.from(-1, 32, true);
            }
            List<ExprAndDep<Value>> value = this.select.evaluate(scenario, currentInstanceScope);
            if (value.size() != 1) {
                this.evaluationError = new ExpressionError(Utils.append("*** Error: Cannot evaluate '", this.select.toString(false), "' expression", this, "'"), line, parserPath);
            }
            return (Value)value.get((int)0).expr;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected DummyFieldInstance toInstance(Scenario scenario, InstancesContainer currentInstanceScope, int line, ParserPath parserPath) {
            DummyFieldInstance instance;
            block8: {
                RfNamedElement rfFieldType;
                block9: {
                    RfNamedElement rfItemFieldType;
                    rfFieldType = Utils.getAssociatedType(this.rfField);
                    instance = null;
                    if (this.select == null) break block9;
                    if (this.rfField instanceof RfField.RfIteratorField) {
                        throw new UnsupportedOperationException("Select for iterator field should be created using createSelect()");
                    }
                    List<ExprAndDep<Value>> value = this.select.evaluate(scenario, currentInstanceScope);
                    if (value.size() != 1) {
                        this.evaluationError = new ExpressionError(Utils.append("*** Error: Cannot evaluate '", this.select.toString(false), "' expression", this, "'"), line, parserPath);
                    }
                    RfNamedElement rfNamedElement = rfItemFieldType = rfFieldType instanceof RfCollectionType ? Utils.getAssociatedType((RfCollectionType)rfFieldType) : null;
                    if (Value.isInteger((Value)value.get((int)0).expr)) {
                        int arrayItemIndex = ((Value)value.get((int)0).expr).getIntValue().intValueExact();
                        if (arrayItemIndex < 0) {
                            this.evaluationError = new ExpressionError(Utils.append("Index ", arrayItemIndex, " is out of bounds"), line, parserPath);
                        }
                        instance = new DummyFieldInstance(this.rfField, this.select == null ? rfFieldType : rfItemFieldType, -1, arrayItemIndex);
                        break block8;
                    } else if (((Value)value.get((int)0).expr).getValue() != null && rfFieldType instanceof RfCollectionType && (((RfCollectionType)rfFieldType).isMapType() || ((RfCollectionType)rfFieldType).isSetType())) {
                        instance = new DummyFieldInstance(this.rfField, this.select == null ? rfFieldType : rfItemFieldType, -1, ((Value)value.get((int)0).expr).getValue().toString());
                        break block8;
                    } else {
                        ScenarioUtils.print("*** Error: Internal error TOI_1");
                        throw new Solver.InterruptException();
                    }
                }
                instance = new DummyFieldInstance(this.rfField, rfFieldType, -1, -1);
            }
            instance.setMethodCallInstanceData(this.arguments, line, parserPath);
            if (this.rfField instanceof RfField.RfIndexField) {
                Value indexVariableValue = currentInstanceScope.getRepeatIndexValue((RfField.RfIndexField)this.rfField);
                instance.setVariableValue(indexVariableValue);
                return instance;
            }
            if (!(this.rfField instanceof RfField.RfIteratorField)) return instance;
            Value iteratorVariableValue = currentInstanceScope.getRepeatIteratorValue((RfField.RfIteratorField)this.rfField);
            instance.setVariableValue(iteratorVariableValue);
            return instance;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            if (this.isUndeclaredIdentifier()) {
                out.writeInt(-1);
                out.writeUTF(this.rfField.getElabName());
            } else {
                int key = ScenarioUtils.getKeyOfRf(this.rfField);
                out.writeInt(key);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            if (key == -1) {
                String name = in.readUTF();
                this.rfField = new RfFieldWrapper(name, SemanticWalker.UNRESOLVED_ELEMENT);
            } else {
                this.rfField = (RfField)ScenarioUtils.getRfOfKey(key);
            }
        }

        public RfField getRfField() {
            return this.rfField;
        }

        public List<ExpressionError> getErrors() {
            if (this.evaluationError == null) {
                return null;
            }
            return Collections.singletonList(this.evaluationError);
        }

        public void cleanErrors() {
            this.evaluationError = null;
        }

        public boolean isArrayItem() {
            return this.select != null;
        }

        public void setArguments(List<Expression> arguments) {
            this.arguments = arguments;
        }

        public boolean isMethodCall() {
            return this.arguments != null;
        }

        public boolean isUndeclaredIdentifier() {
            return this.rfField instanceof RfFieldWrapper && ((RfFieldWrapper)this.rfField).getWrappedElement() == SemanticWalker.UNRESOLVED_ELEMENT;
        }
    }

    public static class IfAssign
    extends Assign {
        private static final long serialVersionUID = 1L;
        private Expression ifExpr;
        private Expression thenExpr;
        private Expression elseExpr;

        public IfAssign(Expression expression, Expression thenExpr, Expression elseExpr, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.ifExpr = expression;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("if (", this.ifExpr.toString(), ")"));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            block9: {
                try {
                    try {
                        Expression expression;
                        scenario.debugBeginEvaluate(this, currentInstanceScope);
                        List<ExprAndDep<Value>> value = this.ifExpr.evaluate(scenario, currentInstanceScope);
                        if (value == null || value.size() != 1) {
                            throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.ifExpr.toString(false), "' expression"), this.line, this.parserPath);
                        }
                        boolean ifBranch = !((Value)value.get((int)0).expr).getIntValue().equals(BigInteger.ZERO);
                        Expression expression2 = expression = ifBranch ? this.thenExpr : this.elseExpr;
                        if (expression != null) {
                            expression.evaluate(scenario, currentInstanceScope);
                        }
                    }
                    catch (Solver.EvaluationException e) {
                        ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                        throw new Solver.InterruptException();
                    }
                    catch (BreakException | ContinueException | ReturnException | Solver.InterruptException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        scenario.debugFinishEvaluate(this, currentInstanceScope);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    scenario.debugFinishEvaluate(this, currentInstanceScope);
                    throw throwable;
                }
                scenario.debugFinishEvaluate(this, currentInstanceScope);
            }
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            this.ifExpr.evaluateUnintActionHandles(solver);
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.ifExpr, this.elseExpr, this.thenExpr);
        }
    }

    public static class IfThenElse
    extends Logic {
        private static final long serialVersionUID = 1L;

        public IfThenElse(Expression condExpr, Expression thenExpr, Expression elseExpr, int line, ParserPath parserPath) {
            super(Logic.Operator.AND, new Logic(Logic.Operator.IMPLY, condExpr, thenExpr, Logic.TextKind.IF_ELSE, line, parserPath), new Logic(Logic.Operator.OR, condExpr, elseExpr, Logic.TextKind.IF_ELSE, line, parserPath), Logic.TextKind.IF_ELSE, line, parserPath);
        }
    }

    public static class Imply
    extends Logic {
        private static final long serialVersionUID = 1L;

        public Imply(Expression condition, Expression expr, int line, ParserPath parserPath) {
            super(Logic.Operator.IMPLY, condition, expr, line, parserPath);
        }
    }

    public static class InRange
    extends Expression {
        private static final long serialVersionUID = 1L;
        private static final Expression INFINITY = new IntExpression("INFINITY", BigInteger.ZERO, true, -1, null);
        protected Expression inVarExpr;
        protected Logic inRangeExpr;
        private Expression lowerBoundExpr;
        private Expression upperBoundExpr;
        private ExpressionWarning evaluationWarning;

        public InRange(Expression inVarExpr, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.inVarExpr = inVarExpr;
        }

        public void addInRange(Expression leftExpr, Expression rightExpr) {
            Logic inRangeSubExpr;
            this.lowerBoundExpr = this.getMinOrMaxExpr(Arith.Operator.MIN, this.lowerBoundExpr, leftExpr);
            this.upperBoundExpr = this.getMinOrMaxExpr(Arith.Operator.MAX, this.upperBoundExpr, rightExpr);
            if (leftExpr != rightExpr && leftExpr instanceof IntExpression && rightExpr instanceof IntExpression && this.evaluationWarning == null && ((IntExpression)leftExpr).intValue.compareTo(((IntExpression)rightExpr).intValue) > 0) {
                this.evaluationWarning = new ExpressionWarning(Utils.append("Lower-bound bigger than upper-bound in sub-range [", leftExpr, "..", rightExpr, "] (zero length sub-range)"), leftExpr.line, leftExpr.parserPath);
            }
            if (leftExpr != null && rightExpr != null && leftExpr == rightExpr) {
                inRangeSubExpr = new Logic(Logic.Operator.EQ, this.inVarExpr, leftExpr, this.inRangeExpr == null ? Logic.TextKind.IN_TEXT : Logic.TextKind.RHS_TEXT, this.line, this.parserPath);
            } else if (leftExpr != null && rightExpr != null) {
                inRangeSubExpr = new Logic(Logic.Operator.AND, new Logic(Logic.Operator.GTE, this.inVarExpr, leftExpr, this.inRangeExpr == null ? Logic.TextKind.IN_TEXT : Logic.TextKind.RHS_TEXT, this.line, this.parserPath), new Logic(Logic.Operator.LTE, this.inVarExpr, rightExpr, Logic.TextKind.RHS_TEXT, this.line, this.parserPath), Logic.TextKind.RANGE_TEXT, this.line, this.parserPath);
            } else if (leftExpr != null && rightExpr == null) {
                inRangeSubExpr = new Logic(Logic.Operator.GTE, this.inVarExpr, leftExpr, this.inRangeExpr == null ? Logic.TextKind.IN_TEXT : Logic.TextKind.RHS_RANGE_TEXT, this.line, this.parserPath);
            } else if (leftExpr == null && rightExpr != null) {
                inRangeSubExpr = new Logic(Logic.Operator.LTE, this.inVarExpr, rightExpr, this.inRangeExpr == null ? Logic.TextKind.IN_TEXT : Logic.TextKind.RHS_RANGE_TEXT, this.line, this.parserPath);
            } else {
                throw new UnsupportedOperationException();
            }
            this.inRangeExpr = this.inRangeExpr == null ? inRangeSubExpr : new Logic(Logic.Operator.OR, this.inRangeExpr, inRangeSubExpr, Logic.TextKind.COMMA_TEXT, this.line, this.parserPath);
        }

        private final Expression getMinOrMaxExpr(Arith.Operator op, Expression minMaxExpr, Expression expr) {
            if (minMaxExpr == INFINITY) {
                return INFINITY;
            }
            if (expr == null) {
                return INFINITY;
            }
            if (minMaxExpr == null) {
                return expr;
            }
            if (op == Arith.Operator.MIN && minMaxExpr instanceof IntExpression && expr instanceof IntExpression) {
                return ((IntExpression)minMaxExpr).min((IntExpression)expr);
            }
            if (op == Arith.Operator.MAX && minMaxExpr instanceof IntExpression && expr instanceof IntExpression) {
                return ((IntExpression)minMaxExpr).max((IntExpression)expr);
            }
            return new Arith(op, minMaxExpr, expr, this.line, this.parserPath);
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            if (this.evaluationWarning != null) {
                this.evaluationWarning.printMessage();
            }
            List<ExprAndDep<Value>> value = this.inRangeExpr.evaluate(scenario, currentInstanceScope);
            return value;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars;
            if (this.evaluationWarning != null) {
                this.evaluationWarning.printMessage();
            }
            Logic rangeExpr = this.inRangeExpr;
            if (this.inRangeExpr.op == Logic.Operator.OR) {
                if (this.lowerBoundExpr != null && this.lowerBoundExpr != INFINITY) {
                    rangeExpr = new Logic(Logic.Operator.AND, new Logic(Logic.Operator.GTE, this.inVarExpr, this.lowerBoundExpr, this.line, this.parserPath), rangeExpr, Logic.TextKind.RHS_TEXT, this.line, this.parserPath);
                }
                if (this.upperBoundExpr != null && this.upperBoundExpr != INFINITY) {
                    rangeExpr = new Logic(Logic.Operator.AND, new Logic(Logic.Operator.LTE, this.inVarExpr, this.upperBoundExpr, this.line, this.parserPath), rangeExpr, Logic.TextKind.RHS_TEXT, this.line, this.parserPath);
                }
            }
            if ((vars = ((Expression)rangeExpr).getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError)) == null || vars.isEmpty()) {
                return null;
            }
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>(vars.size());
            for (ExprAndDep<IntVariable> var1 : vars) {
                result.add(new ExprAndDep<IntVariable>((IntVariable)var1.expr, var1.dependencies, LazyString.create(() -> Utils.append(exprAndDep.hrText, "])")), this.line));
            }
            return result;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> {
                String result = Utils.append(this.inVarExpr.toString(), " in [", this.inRangeExpr.toString(false), "]");
                return enclosed ? Utils.append("(", result, ")") : result;
            });
        }

        public String getRangeHrText() {
            String result = Utils.append("[", this.inRangeExpr.toString(false), "]");
            return result;
        }

        @Override
        public boolean isRand() {
            return this.inVarExpr.isRand();
        }

        @Override
        public boolean isRuntime() {
            return this.inVarExpr.isRuntime();
        }

        @Override
        public boolean isUninitActionHandle() {
            return this.inVarExpr.isUninitActionHandle();
        }

        @Override
        public boolean isIndex() {
            return this.inVarExpr.isIndex();
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            if (this.inVarExpr != null) {
                this.inVarExpr.evaluateUnintActionHandles(solver);
            }
            if (this.inRangeExpr != null) {
                this.inRangeExpr.evaluateUnintActionHandles(solver);
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return this.inVarExpr.getErrors();
        }

        @Override
        public void cleanErrors() {
            this.inVarExpr.cleanErrors();
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class InlineInit
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Kind initKind;
        private List<Expression> itemExprs;
        private transient RfField rfVar;
        private transient RfNamedElement rfVarType;

        public InlineInit(RfField rfVar, Kind initKind, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.rfVar = rfVar;
            this.rfVarType = Utils.getAssociatedType(rfVar);
            boolean isSetType = initKind == Kind.ARRAY_INIT && this.rfVarType instanceof RfCollectionType && ((RfCollectionType)this.rfVarType).isSetType();
            this.initKind = isSetType ? Kind.SET_INIT : initKind;
            this.itemExprs = new LinkedList<Expression>();
        }

        public void addItem(Expression itemExpr) {
            this.itemExprs.add(itemExpr);
        }

        public void addItem0(Expression itemExpr) {
            this.itemExprs.add(0, itemExpr);
        }

        public void removeItem0() {
            this.itemExprs.remove(0);
        }

        public void addItem(Expression itemKeyExpr, Expression itemValueExpr) {
            this.itemExprs.add(new Logic(null, itemKeyExpr, itemValueExpr, this.line, this.parserPath));
        }

        @Override
        public LazyString toString(boolean enclosed) {
            if (this.initKind == Kind.STRUCT_INIT && !(this.rfVarType instanceof RfStruct)) {
                throw new Solver.EvaluationException("Cannot evaluate 'inline struct' expression", this.line, this.parserPath);
            }
            if (this.initKind != Kind.STRUCT_INIT && this.initKind != Kind.EMPTY_INIT && !(this.rfVarType instanceof RfCollectionType)) {
                throw new Solver.EvaluationException(Utils.append("Cannot evaluate 'inline ", this.initKind.getName(), "' expression"), this.line, this.parserPath);
            }
            if (this.rfVarType instanceof RfStruct) {
                return LazyString.create(() -> this.rfVarType.getElabName());
            }
            DataType dataType = ((RfCollectionType)this.rfVarType).getDataType();
            String initialValueText = dataType.getInitialValueText();
            return LazyString.create(() -> initialValueText);
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            if (this.initKind == Kind.STRUCT_INIT && !(this.rfVarType instanceof RfStruct)) {
                throw new Solver.EvaluationException("Cannot evaluate 'inline struct' expression", this.line, this.parserPath);
            }
            if (this.initKind != Kind.STRUCT_INIT && this.initKind != Kind.EMPTY_INIT && !(this.rfVarType instanceof RfCollectionType)) {
                throw new Solver.EvaluationException(Utils.append("Cannot evaluate 'inline ", this.initKind.getName(), "' expression"), this.line, this.parserPath);
            }
            LinkedHashMap<String, Variable> variables = new LinkedHashMap<String, Variable>();
            StringBuilder hrText = new StringBuilder("{");
            boolean isFirst = true;
            for (Expression itemExpr : this.itemExprs) {
                if (this.initKind == Kind.STRUCT_INIT) {
                    String nameValue = ScenarioUtils.getDeduplicateName(((Hid)((Logic)itemExpr).left).getLastField());
                    value = ((Logic)itemExpr).right.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    variables.put(nameValue, (Variable)value.get((int)0).expr);
                    hrText.append(isFirst ? " ." : ", .").append(nameValue).append(" = ").append(value.get((int)0).hrText);
                } else if (this.initKind == Kind.MAP_INIT) {
                    List<ExprAndDep<IntVariable>> keyValue = ((Hid)((Logic)itemExpr).left).getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    value = ((Logic)itemExpr).right.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    variables.put(keyValue.get((int)0).hrText.toString(), (Variable)value.get((int)0).expr);
                    hrText.append(isFirst ? " " : ", ").append(keyValue.get((int)0).hrText).append(" : ").append(value.get((int)0).hrText);
                } else if (this.initKind == Kind.ARRAY_INIT) {
                    value = itemExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    variables.put(Utils.append("[", variables.size(), "]"), (Variable)value.get((int)0).expr);
                    hrText.append(isFirst ? " " : ", ").append(value.get((int)0).hrText);
                } else if (this.initKind == Kind.SET_INIT) {
                    value = itemExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    variables.put(value.get((int)0).hrText.toString(), (Variable)value.get((int)0).expr);
                    hrText.append(isFirst ? " " : ", ").append(value.get((int)0).hrText);
                }
                isFirst = false;
            }
            hrText.append(" }");
            CompoundVariable variable = new CompoundVariable(model, variables, Utils.append("[inline ", this.initKind.getName(), "]"), this.initKind != Kind.STRUCT_INIT);
            return Collections.singletonList(new ExprAndDep<CompoundVariable>(variable, null, LazyString.create(() -> hrText.toString()), this.line));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            if (this.initKind == Kind.STRUCT_INIT && !(this.rfVarType instanceof RfStruct)) {
                throw new Solver.EvaluationException("Cannot evaluate 'inline struct' expression", this.line, this.parserPath);
            }
            if (this.initKind != Kind.STRUCT_INIT && this.initKind != Kind.EMPTY_INIT && !(this.rfVarType instanceof RfCollectionType)) {
                throw new Solver.EvaluationException(Utils.append("Cannot evaluate 'inline ", this.initKind.getName(), "' expression"), this.line, this.parserPath);
            }
            FieldInstance fieldInstance = FieldInstance.create(this.rfVar, this.rfVarType, true, -1, -1, currentInstanceScope.runtimeId, scenario);
            StringBuilder hrText = new StringBuilder("{");
            boolean isFirst = true;
            for (Expression itemExpr : this.itemExprs) {
                if (this.initKind == Kind.STRUCT_INIT) {
                    RfField rfField = ((Hid)((Logic)itemExpr).left).getLastField();
                    String nameValue = ScenarioUtils.getDeduplicateName(rfField);
                    FieldInstance itemInstance = fieldInstance.createFieldInstance(new IdentityHashMap<RfNamedElement, InstancesContainer>(), nameValue, rfField, Utils.getAssociatedType(rfField), -1, -1, false, false);
                    List<ExprAndDep<Value>> value = ((Logic)itemExpr).right.evaluate(scenario, currentInstanceScope);
                    itemInstance.setVariableValue((Value)value.get((int)0).expr);
                    hrText.append(isFirst ? " ." : ", .").append(nameValue).append(" = ").append(value.get((int)0).hrText);
                } else if (this.initKind == Kind.MAP_INIT) {
                    List<ExprAndDep<Value>> keyValue = ((Logic)itemExpr).left.evaluate(scenario, currentInstanceScope);
                    itemInstance = fieldInstance.insertMapItem(keyValue.get((int)0).expr, null, this.line, this.parserPath);
                    List<ExprAndDep<Value>> value = ((Logic)itemExpr).right.evaluate(scenario, currentInstanceScope);
                    itemInstance.setVariableValue((Value)value.get((int)0).expr);
                    hrText.append(isFirst ? " " : ", ").append(keyValue.get((int)0).hrText).append(" : ").append(value.get((int)0).hrText);
                } else if (this.initKind == Kind.ARRAY_INIT) {
                    value = itemExpr.evaluate(scenario, currentInstanceScope);
                    itemInstance = fieldInstance.addListItem(null, this.line, this.parserPath);
                    itemInstance.setVariableValue((Value)value.get((int)0).expr);
                    hrText.append(isFirst ? " " : ", ").append(value.get((int)0).hrText);
                } else if (this.initKind == Kind.SET_INIT) {
                    value = itemExpr.evaluate(scenario, currentInstanceScope);
                    itemInstance = fieldInstance.insertMapItem(value.get((int)0).expr, null, this.line, this.parserPath);
                    itemInstance.setVariableValue((Value)value.get((int)0).expr);
                    hrText.append(isFirst ? " " : ", ").append(value.get((int)0).hrText);
                }
                isFirst = false;
            }
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(fieldInstance, -1, false), null, LazyString.create(() -> hrText.toString()), this.line));
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfVar);
            out.writeInt(key);
            key = ScenarioUtils.getKeyOfRf(this.rfVarType);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfVar = (RfField)ScenarioUtils.getRfOfKey(key);
            key = in.readInt();
            this.rfVarType = ScenarioUtils.getRfOfKey(key);
        }

        @Override
        public boolean isRand() {
            return false;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.itemExprs);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.itemExprs);
        }

        public static enum Kind {
            EMPTY_INIT("{}"),
            ARRAY_INIT("array"),
            MAP_INIT("map"),
            SET_INIT("set"),
            STRUCT_INIT("struct");

            private String name;

            private Kind(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public static class IntExpression
    extends PrimaryExpression {
        private static final long serialVersionUID = 1L;
        private int nofBits;
        private BigInteger intValue;
        private boolean hasSign;

        public IntExpression(String value, BigInteger intValue, boolean hasSign, int line, ParserPath parserPath) {
            super(value, line, parserPath);
            Value converted = Value.from(intValue, Math.max(32, intValue.bitLength() + (hasSign ? 1 : 0)), false).toUorS(hasSign);
            this.nofBits = converted.nofBits();
            this.intValue = converted.getIntValue();
            this.hasSign = hasSign;
        }

        public IntExpression(String value, BigInteger intValue, int nofBits, boolean hasSign, int line, ParserPath parserPath) {
            super(value, line, parserPath);
            Value converted = Value.from(intValue, nofBits, false).toUorS(hasSign);
            this.nofBits = converted.nofBits();
            this.intValue = converted.getIntValue();
            this.hasSign = hasSign;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(this.intValue, this.nofBits, this.hasSign), null, LazyString.create(() -> this.value), this.line));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            return Collections.singletonList(new ExprAndDep<IntVariable>(Value.from(this.intValue, this.nofBits, this.hasSign).intVar(model), null, LazyString.create(() -> this.value), this.line));
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> this.intValue.toString());
        }

        public Expression max(IntExpression expr) {
            if (this.intValue.compareTo(expr.intValue) > 0) {
                return this;
            }
            return expr;
        }

        public Expression min(IntExpression expr) {
            if (this.intValue.compareTo(expr.intValue) < 0) {
                return this;
            }
            return expr;
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class ListExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        private List<Expression> expressions = new ArrayList<Expression>();

        public ListExpression(int line, ParserPath parserPath) {
            super(line, parserPath);
        }

        public void addExpression(Expression expression) {
            this.expressions.add(expression);
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        public boolean isEmpty() {
            return this.expressions.isEmpty();
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> this.expressions.toString());
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            for (Expression expression : this.expressions) {
                try {
                    List<ExprAndDep<IntVariable>> expr = expression.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                    if (expr == null) continue;
                    result.addAll(expr);
                }
                catch (Solver.SkipEvaluationException skipEvaluationException) {
                    ScenarioUtils.printWarning(Utils.append("Cannot evaluate '", expression.toString(false), "' expression (ignored)"), true, expression.line, expression.parserPath);
                }
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            for (Expression expression : this.expressions) {
                try {
                    expression.evaluate(scenario, currentInstanceScope);
                }
                catch (Solver.SkipEvaluationException skipEvaluationException) {
                    ScenarioUtils.printWarning(Utils.append("Cannot evaluate '", expression.toString(false), "' expression (ignored)"), true, expression.line, expression.parserPath);
                }
            }
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
        }

        @Override
        public boolean isRand() {
            return true;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.expressions);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.expressions);
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            for (Expression expression : this.expressions) {
                expression.evaluateUnintActionHandles(solver);
            }
        }
    }

    public static class Logic
    extends Expression {
        private static final long serialVersionUID = 1L;
        protected Operator op;
        protected Expression left;
        protected Expression right;
        private TextKind hrTextKind;

        public Logic(Operator op, Expression left, Expression right, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.op = op;
            this.left = left;
            this.right = right;
            this.hrTextKind = TextKind.OP_TEXT;
        }

        public Logic(Operator op, Expression left, Expression right, TextKind hrTextKind, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.op = op;
            this.left = left;
            this.right = right;
            this.hrTextKind = hrTextKind;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            if (this.hrTextKind == TextKind.OP_TEXT) {
                switch (this.op) {
                    case NOT: {
                        return LazyString.create(() -> {
                            String result = Utils.append(this.op.toString(), this.left.toString());
                            return enclosed ? Utils.append("(", result, ")") : result;
                        });
                    }
                }
                return LazyString.create(() -> {
                    String result = Utils.append(this.left.toString(), this.op.toString(), this.right.toString());
                    return enclosed ? Utils.append("(", result, ")") : result;
                });
            }
            LazyString hrLeftText = this.left.toString(false);
            switch (this.op) {
                case NOT: {
                    return LazyString.create(() -> {
                        String result = Utils.append(this.op.toString(), hrLeftText);
                        return enclosed ? Utils.append("(", result, ")") : result;
                    });
                }
            }
            LazyString hrRightText = this.right.toString(false);
            switch (this.hrTextKind) {
                case IN_TEXT: {
                    return this.op == Operator.GTE ? LazyString.create(() -> Utils.append(hrRightText, "..")) : (this.op == Operator.LTE ? LazyString.create(() -> Utils.append("..", hrRightText)) : hrRightText);
                }
                case RANGE_TEXT: {
                    return LazyString.create(() -> {
                        String separator = hrLeftText.toString().endsWith("..") || hrRightText.toString().startsWith("..") ? "" : "..";
                        return Utils.append(hrLeftText, separator, hrRightText);
                    });
                }
                case COMMA_TEXT: {
                    return LazyString.create(() -> Utils.append(hrLeftText, ", ", hrRightText));
                }
                case LHS_TEXT: {
                    return hrLeftText;
                }
                case RHS_TEXT: {
                    return hrRightText;
                }
                case RHS_RANGE_TEXT: {
                    return this.op == Operator.GTE ? LazyString.create(() -> Utils.append(hrRightText, "..")) : (this.op == Operator.LTE ? LazyString.create(() -> Utils.append("..", hrRightText)) : hrRightText);
                }
                case IF_ELSE: {
                    if (this.op == Operator.IMPLY) {
                        return LazyString.create(() -> Utils.append("if ", hrLeftText, " ", hrRightText));
                    }
                    if (this.op == Operator.OR) {
                        return LazyString.create(() -> Utils.append(" else ", hrRightText));
                    }
                    return LazyString.create(() -> Utils.append(hrLeftText, hrRightText));
                }
            }
            return LazyString.create(() -> Utils.append("(", hrLeftText, this.op.toString(), hrRightText, ")"));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            ArrayList<ExprAndDep<Value>> result = new ArrayList<ExprAndDep<Value>>();
            List<ExprAndDep<Value>> vars1 = this.evaluateOperand(scenario, this.left, currentInstanceScope);
            if (this.op == Operator.AND && vars1.size() == 1 && ((Value)vars1.get((int)0).expr).getIntValue().equals(BigInteger.ZERO)) {
                result.add(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 1, false), vars1.get((int)0).dependencies, this.hrText(vars1.get((int)0).hrText, this.right.toString(true)), this.line));
                return result;
            }
            if (this.op == Operator.OR && vars1.size() == 1 && !((Value)vars1.get((int)0).expr).getIntValue().equals(BigInteger.ZERO)) {
                result.add(new ExprAndDep<Value>(Value.from(BigInteger.ONE, 1, false), vars1.get((int)0).dependencies, this.hrText(vars1.get((int)0).hrText, this.right.toString(true)), this.line));
                return result;
            }
            List<ExprAndDep> vars2 = this.right == null ? Collections.emptyList() : this.evaluateOperand(scenario, this.right, currentInstanceScope);
            block15: for (ExprAndDep<Value> var1 : vars1) {
                if (!Value.isInteger((Value)var1.expr) && this.op != Operator.IN && this.op != Operator.EQ && this.op != Operator.NOT_EQ || var1.isVacuous()) continue;
                switch (this.op) {
                    case NOT: {
                        result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().not(), 1, false), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    default: {
                        for (ExprAndDep var2 : vars2) {
                            if (!Value.isInteger((Value)var2.expr) && this.op != Operator.IN && this.op != Operator.EQ && this.op != Operator.NOT_EQ || var2.isVacuous()) continue;
                            switch (this.op) {
                                case LT: {
                                    result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().compareTo(((Value)var2.expr).getIntValue()) < 0), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case LTE: {
                                    result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().compareTo(((Value)var2.expr).getIntValue()) <= 0), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case GT: {
                                    result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().compareTo(((Value)var2.expr).getIntValue()) > 0), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case GTE: {
                                    result.add(new ExprAndDep<Value>(Value.from(((Value)var1.expr).getIntValue().compareTo(((Value)var2.expr).getIntValue()) >= 0), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case EQ: 
                                case NOT_EQ: {
                                    boolean isEquals = false;
                                    isEquals = Value.isReference((Value)var1.expr) && Value.isReference((Value)var2.expr) ? ((Value)var1.expr).getRefValue().deepCompare(((Value)var2.expr).getRefValue(), false, false, this.line, this.parserPath) : (Value.isNull((Value)var1.expr) && Value.isNull((Value)var2.expr) ? true : ((Value)var1.expr).equals(var2.expr));
                                    BigInteger value = isEquals ^ this.op == Operator.NOT_EQ ? BigInteger.ONE : BigInteger.ZERO;
                                    result.add(new ExprAndDep<Value>(Value.from(value, 1, false), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case IN: {
                                    for (FieldInstance arrayElement : Utils.unwrapReferenceInstance(((Value)var2.expr).getRefValue()).getFieldInstances().values()) {
                                        boolean isEquals;
                                        if (!arrayElement.isArrayItem()) continue;
                                        Value itemValue = arrayElement.getVariableValue(true);
                                        boolean bl = isEquals = Value.isReference((Value)var1.expr) && ((Value)var1.expr).getRefValue().deepCompare(itemValue.getRefValue(), true, false, this.line, this.parserPath) || ((Value)var1.expr).equals(itemValue);
                                        if (!isEquals) continue;
                                        result.clear();
                                        result.add(new ExprAndDep<Value>(Value.from(BigInteger.ONE, 32, false), var1.dependencies, var2.dependencies, LazyString.create(() -> Utils.append("(", exprAndDep.hrText, " in ", exprAndDep2.hrText, ")")), this.line));
                                        return result;
                                    }
                                    result.add(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), var1.dependencies, var2.dependencies, LazyString.create(() -> Utils.append("(", exprAndDep.hrText, " in ", exprAndDep2.hrText, ")")), this.line));
                                    break;
                                }
                                case IMPLY: {
                                    result.add(new ExprAndDep<Value>(Value.from(!((Value)var1.expr).getIntValue().not().or(((Value)var2.expr).getIntValue()).equals(BigInteger.ZERO)), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case OR: {
                                    result.add(new ExprAndDep<Value>(Value.from(!((Value)var1.expr).getIntValue().or(((Value)var2.expr).getIntValue()).equals(BigInteger.ZERO)), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case AND: {
                                    result.add(new ExprAndDep<Value>(Value.from(!((Value)var1.expr).getIntValue().and(((Value)var2.expr).getIntValue()).equals(BigInteger.ZERO)), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case XOR: {
                                    result.add(new ExprAndDep<Value>(Value.from(!((Value)var1.expr).getIntValue().xor(((Value)var2.expr).getIntValue()).equals(BigInteger.ZERO)), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                default: {
                                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.toString(false), "' expression (OP)"), this.line, this.parserPath);
                                }
                            }
                        }
                        continue block15;
                    }
                }
            }
            return result;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars1 = this.left.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars1 == null || vars1.isEmpty()) {
                return null;
            }
            List<ExprAndDep<IntVariable>> vars2 = this.right == null ? null : this.right.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            block16: for (ExprAndDep<IntVariable> var1 : vars1) {
                if (var1.isVacuous()) continue;
                switch (this.op) {
                    case NOT: {
                        result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).not(), var1.dependencies, this.hrText(var1.hrText, null), this.line));
                        break;
                    }
                    default: {
                        if (vars2 == null || vars2.isEmpty()) {
                            return null;
                        }
                        for (ExprAndDep<IntVariable> var2 : vars2) {
                            if (var1 == var2 || var2.isVacuous()) continue;
                            switch (this.op) {
                                case LT: {
                                    result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).lt((IntVariable)var2.expr).reify(), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case LTE: {
                                    result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).le((IntVariable)var2.expr).reify(), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case GT: {
                                    result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).gt((IntVariable)var2.expr).reify(), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case GTE: {
                                    result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).ge((IntVariable)var2.expr).reify(), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case EQ: {
                                    result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).eq((IntVariable)var2.expr).reify(), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case NOT_EQ: {
                                    result.add(new ExprAndDep<ReifBoolVariable>(((IntVariable)var1.expr).ne((IntVariable)var2.expr).reify(), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case IN: {
                                    IntVariable temp = null;
                                    for (Variable elementVariable : ((CompoundVariable)var2.expr).variables.values()) {
                                        ReifBoolVariable reif = ((IntVariable)var1.expr).eq((IntVariable)elementVariable).reify();
                                        Object object = temp = temp != null ? reif.or(temp) : reif;
                                    }
                                    temp = temp == null ? Value.from(BigInteger.ZERO, 1, false).intVar(model) : temp;
                                    result.add(new ExprAndDep<ReifBoolVariable>(temp.eq(Value.from(BigInteger.ONE, 1, false).intVar(model)).reify(), var1.dependencies, var2.dependencies, LazyString.create(() -> Utils.append("(", exprAndDep.hrText, " in ", exprAndDep2.hrText, ")")), this.line));
                                    break;
                                }
                                case IMPLY: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).not().or((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case AND: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).and((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case OR: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).or((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                                case XOR: {
                                    result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).xor((IntVariable)var2.expr), var1.dependencies, var2.dependencies, this.hrText(var1.hrText, var2.hrText), this.line));
                                    break;
                                }
                            }
                        }
                        continue block16;
                    }
                }
            }
            return result;
        }

        private final LazyString hrText(LazyString hrLeftText, LazyString hrRightText) {
            switch (this.op) {
                case NOT: {
                    return LazyString.create(() -> Utils.append(this.op.toString(), hrLeftText));
                }
            }
            switch (this.hrTextKind) {
                case IN_TEXT: {
                    return LazyString.create(() -> {
                        String hrRightText2 = this.op == Operator.GTE ? Utils.append(hrRightText, "..") : (this.op == Operator.LTE ? Utils.append("..", hrRightText) : hrRightText.toString());
                        return Utils.append("(", hrLeftText, " in [", hrRightText2);
                    });
                }
                case RANGE_TEXT: {
                    return LazyString.create(() -> {
                        String separator = hrLeftText.toString().endsWith("..") || hrRightText.toString().startsWith("..") ? "" : "..";
                        return Utils.append(hrLeftText, separator, hrRightText);
                    });
                }
                case COMMA_TEXT: {
                    return LazyString.create(() -> Utils.append(hrLeftText, ", ", hrRightText));
                }
                case LHS_TEXT: {
                    return hrLeftText;
                }
                case RHS_TEXT: {
                    return hrRightText;
                }
                case RHS_RANGE_TEXT: {
                    return LazyString.create(() -> this.op == Operator.GTE ? Utils.append(hrRightText, "..") : (this.op == Operator.LTE ? Utils.append("..", hrRightText) : hrRightText.toString()));
                }
                case IF_ELSE: {
                    if (this.op == Operator.IMPLY) {
                        return LazyString.create(() -> Utils.append("if ", hrLeftText, "\n        ", hrRightText));
                    }
                    if (this.op == Operator.OR) {
                        return LazyString.create(() -> Utils.append("\n    else\n        ", hrRightText));
                    }
                    return LazyString.create(() -> Utils.append(hrLeftText, hrRightText));
                }
            }
            return LazyString.create(() -> Utils.append("(", hrLeftText, this.op.toString(), hrRightText, ")"));
        }

        @Override
        public boolean isRand() {
            return this.left.isRand() || this.right != null && this.right.isRand();
        }

        @Override
        public boolean isRuntime() {
            return this.left.isRuntime() || this.right != null && this.right.isRuntime();
        }

        @Override
        public boolean isUninitActionHandle() {
            return this.left.isUninitActionHandle() || this.right != null && this.right.isUninitActionHandle();
        }

        @Override
        public boolean isIndex() {
            return this.left.isIndex() || this.right != null && this.right.isIndex();
        }

        @Override
        public boolean isConstant() {
            return this.left.isConstant() && (this.right == null || this.right.isConstant());
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            if (this.left != null) {
                this.left.evaluateUnintActionHandles(solver);
            }
            if (this.right != null) {
                this.right.evaluateUnintActionHandles(solver);
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.left, this.right);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.left, this.right);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Operator {
            LT{

                public String toString() {
                    return " < ";
                }
            }
            ,
            LTE{

                public String toString() {
                    return " <= ";
                }
            }
            ,
            GT{

                public String toString() {
                    return " > ";
                }
            }
            ,
            GTE{

                public String toString() {
                    return " >= ";
                }
            }
            ,
            EQ{

                public String toString() {
                    return " == ";
                }
            }
            ,
            NOT_EQ{

                public String toString() {
                    return " != ";
                }
            }
            ,
            IN{

                public String toString() {
                    return " in ";
                }
            }
            ,
            IMPLY{

                public String toString() {
                    return " -> ";
                }
            }
            ,
            NOT{

                public String toString() {
                    return "!";
                }
            }
            ,
            OR{

                public String toString() {
                    return " || ";
                }
            }
            ,
            AND{

                public String toString() {
                    return " && ";
                }
            }
            ,
            XOR{

                public String toString() {
                    return " ^^ ";
                }
            };

        }

        public static enum TextKind {
            IN_TEXT,
            RANGE_TEXT,
            COMMA_TEXT,
            RHS_TEXT,
            RHS_RANGE_TEXT,
            LHS_TEXT,
            OP_TEXT,
            IF_ELSE;

        }
    }

    public static class MatchAssign
    extends ListExpression {
        private static final long serialVersionUID = 1L;

        public MatchAssign(int line, ParserPath parserPath) {
            super(line, parserPath);
        }

        public void addBranch(Expression expr, Expression exec) {
            this.addExpression(new MatchBranch(expr, exec, exec.line, exec.parserPath));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                scenario.debugBeginEvaluate(this, currentInstanceScope);
                boolean skipDefaultBranch = false;
                MatchBranch defaultBranch = null;
                int matchBranchChoice = 0;
                List<Expression> expressions = this.getExpressions();
                int i = 0;
                while (i < expressions.size()) {
                    MatchBranch matchBranch = (MatchBranch)expressions.get(i);
                    if (matchBranch.isDefaultBranch()) {
                        defaultBranch = matchBranch;
                    } else {
                        List<ExprAndDep<Value>> value = matchBranch.evaluate(scenario, currentInstanceScope);
                        if (value == null || value.size() != 1) {
                            throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", matchBranch.toString(false), "' expression"), this.line, this.parserPath);
                        }
                        if (Value.isInteger((Value)value.get((int)0).expr) && BigInteger.ZERO.compareTo(((Value)value.get((int)0).expr).getIntValue()) < 0) {
                            if (skipDefaultBranch) {
                                throw new Solver.EvaluationException(Utils.append("Multiple branches ", matchBranchChoice, ", ", i + 1, ", and possibly others match"), this.line, this.parserPath);
                            }
                            matchBranchChoice = i + 1;
                            skipDefaultBranch = true;
                        }
                    }
                    ++i;
                }
                if (defaultBranch != null && !skipDefaultBranch) {
                    defaultBranch.evaluate(scenario, currentInstanceScope);
                }
                List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
                return list;
            }
            finally {
                scenario.debugFinishEvaluate(this, currentInstanceScope);
            }
        }

        public static class MatchBranch
        extends Expression {
            private static final long serialVersionUID = 1L;
            private Expression matchExpr;
            private Expression expression;

            public MatchBranch(Expression matchExpr, Expression expression, int line, ParserPath parserPath) {
                super(line, parserPath);
                this.matchExpr = matchExpr;
                this.expression = expression;
            }

            public boolean isDefaultBranch() {
                return this.matchExpr == null;
            }

            @Override
            public LazyString toString(boolean enclosed) {
                return LazyString.create(() -> Utils.append("match (", this.matchExpr == null ? "default" : this.matchExpr.toString(), ")"));
            }

            @Override
            public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
                return null;
            }

            @Override
            public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
                boolean isMatch;
                if (this.isDefaultBranch()) {
                    this.expression.evaluate(scenario, currentInstanceScope);
                    return Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ONE, 32, true), null, this.toString(true), this.line));
                }
                List<ExprAndDep<Value>> value = this.matchExpr.evaluate(scenario, currentInstanceScope);
                if (value == null || value.size() != 1) {
                    throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.matchExpr.toString(false), "' expression"), this.line, this.parserPath);
                }
                boolean bl = isMatch = Value.isInteger((Value)value.get((int)0).expr) && BigInteger.ZERO.compareTo(((Value)value.get((int)0).expr).getIntValue()) < 0;
                if (isMatch) {
                    this.expression.evaluate(scenario, currentInstanceScope);
                }
                return Collections.singletonList(new ExprAndDep<Value>(Value.from(isMatch), null, this.toString(true), this.line));
            }

            @Override
            public boolean isRand() {
                return false;
            }

            @Override
            public boolean isRuntime() {
                return false;
            }

            @Override
            public boolean isUninitActionHandle() {
                return false;
            }

            @Override
            public boolean isIndex() {
                return false;
            }

            @Override
            public boolean isConstant() {
                return false;
            }

            @Override
            public List<ExpressionError> getErrors() {
                return Utils.collectErrors(this.expression, this.matchExpr);
            }

            @Override
            public void cleanErrors() {
                Utils.cleanErrors(this.expression, this.matchExpr);
            }

            @Override
            public void evaluateUnintActionHandles(Solver solver) {
                this.expression.evaluateUnintActionHandles(solver);
            }
        }
    }

    public static class MethodCall
    extends Assign {
        private static final long serialVersionUID = 1L;
        private List<Expression> arguments;
        private Hid methodInstanceHierarchicalExpr;
        private ListExpression bodyExpressionList;
        private transient RfMethod rfMethod;

        public MethodCall(Hid hid, RfMethod rfMethod, List<Expression> arguments, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.methodInstanceHierarchicalExpr = hid;
            this.rfMethod = rfMethod;
            this.arguments = rfMethod == null ? null : arguments;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return this.rfMethod == null ? LazyString.create(() -> "[null]") : LazyString.create(() -> Utils.append(this.rfMethod.getElabName(), "()"));
        }

        public RfMethod getRfMethod() {
            return this.rfMethod;
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            List<ExprAndDep<Value>> value = this.evaluate(scenario, currentInstanceScope);
            if (value != null && value.size() == 1 && Value.isInteger((Value)value.get((int)0).expr)) {
                result.add(new ExprAndDep<IntVariable>(((Value)value.get((int)0).expr).intVar(model), currentInstanceScope, Utils.last(value).hrText, this.line));
                return result;
            }
            if (value != null && value.size() == 1 && Value.isString((Value)value.get((int)0).expr)) {
                String strValue = ((Value)value.get((int)0).expr).getStringValue();
                result.add(new ExprAndDep<StrVariable>(model.strVar(strValue, strValue), currentInstanceScope, Utils.last(value).hrText, this.line));
                return result;
            }
            if (value != null && value.size() == 1 && Value.isReference((Value)value.get((int)0).expr)) {
                FieldInstance fieldInstance = ((Value)value.get((int)0).expr).getRefValue().getFieldInstance("[unique_id]");
                IntVariable variable = fieldInstance.getVariable(model, null, fieldInstance.getHierarchicalPath(), variableSolverMap, false);
                result.add(new ExprAndDep<IntVariable>(variable, currentInstanceScope, Utils.last(value).hrText, this.line));
                return result;
            }
            throw new Solver.EvaluationException(Utils.append("Fail to evaluate method/function '", this.rfMethod.getElabName(), "' result"), this.line, this.parserPath);
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                scenario.debugBeginEvaluate(this, currentInstanceScope);
                InstancesContainer methodCallInstanceScope = currentInstanceScope;
                if (this.methodInstanceHierarchicalExpr != null) {
                    List<InstancePath> methodInstanceScopes = this.methodInstanceHierarchicalExpr.getVariablesPaths(scenario, false, currentInstanceScope, false, Integer.MAX_VALUE);
                    if (methodInstanceScopes == null || methodInstanceScopes.size() != 1) {
                        throw new Solver.EvaluationException(Utils.append("Fail to evaluate method/function '", this.rfMethod.getElabName(), "' scope"), this.line, this.parserPath);
                    }
                    currentInstanceScope = methodInstanceScopes.get(0).getInstance();
                }
                if (this.rfMethod == null) {
                    ScenarioUtils.printWarning(Utils.append("Fail to evaluate method/function '[null]' call"), true, this.line, this.parserPath);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                MethodCallContext methodCallContext = MethodCallContext.createMethodContext(scenario.getSolver(), methodCallInstanceScope, currentInstanceScope, this.rfMethod, this.arguments, this.line, this.parserPath);
                if (methodCallContext == null) {
                    ScenarioUtils.printWarning(Utils.append("Fail to evaluate method/function '", this.rfMethod.getElabName(), "' call"), true, this.line, this.parserPath);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                List<ExprAndDep<Value>> list = this.internalEvaluate(scenario, methodCallContext.getRfMethod(), methodCallInstanceScope, currentInstanceScope, methodCallContext);
                return list;
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                throw new Solver.InterruptException();
            }
            finally {
                scenario.debugFinishEvaluate(this, currentInstanceScope);
            }
        }

        public final List<ExprAndDep<Value>> internalEvaluate(Scenario scenario, RfMethod rfMethod, InstancesContainer methodCallInstanceScope, InstancesContainer methodInstanceScope, MethodCallContext methodCallContext) {
            List<Value> parameterValues;
            boolean isPureFunction = rfMethod.hasQualifier(1);
            if (!isPureFunction) {
                return this.internalEvaluateNoCache(scenario, rfMethod, methodCallInstanceScope, methodInstanceScope, methodCallContext);
            }
            Solver solver = scenario.getSolver();
            Value resultValue = solver.getPureFunctionCachedResult(rfMethod, parameterValues = methodCallContext.getParameterValues());
            if (resultValue != null) {
                return Collections.singletonList(new ExprAndDep<Value>(resultValue, null, this.toString(true), this.line));
            }
            List<ExprAndDep<Value>> result = this.internalEvaluateNoCache(scenario, rfMethod, methodCallInstanceScope, methodInstanceScope, methodCallContext);
            solver.setPureFunctionCachedResult(rfMethod, parameterValues, (Value)result.get((int)0).expr);
            return result;
        }

        private final List<ExprAndDep<Value>> internalEvaluateNoCache(Scenario scenario, RfMethod rfMethod, InstancesContainer methodCallInstanceScope, InstancesContainer methodInstanceScope, MethodCallContext methodCallContext) {
            try {
                ActionInstance parentActionInstance;
                InstancesContainer allocatedExecutor;
                scenario.stackTrace.push(new Scenario.TraceElement(this.line, this.parserPath));
                Solver solver = scenario.getSolver();
                if (!scenario.executorAssignments.isEmpty() && (allocatedExecutor = scenario.executorAssignments.get(parentActionInstance = methodInstanceScope.getParentActionInstance())) instanceof ComponentInstance) {
                    rfMethod = Utils.getExecutorOverriddenFunction(((ComponentInstance)allocatedExecutor).getRfComponent(), rfMethod);
                }
                boolean isStdPkgMember = rfMethod.isPackageMember("std_pkg");
                boolean isExecPkgMember = rfMethod.isPackageMember("executor_pkg");
                boolean isAddrRegPkgMember = rfMethod.isPackageMember("addr_reg_pkg");
                RfDefElement declaration = rfMethod.getDeclaration();
                RfNamedElement enclosingScope = rfMethod.getEnclosingScope();
                AST proceduralAST = rfMethod.getNodeAST();
                List<Value> parameterValues = methodCallContext.getParameterValues();
                String methodName = ScenarioUtils.getDeduplicateName(rfMethod);
                if (rfMethod instanceof RfPredefinedMethod && ("get_symbol".equals(methodName) || "getenv".equals(methodName))) {
                    String envVariableValue = Utils.append("\"", System.getenv(Utils.unquote(parameterValues.get(0).getStringValue())), "\"");
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(envVariableValue, -1, false), null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && "random".equals(methodName)) {
                    int random = solver.random(parameterValues.get(0).getIntValue().intValueExact(), parameterValues.get(1).getIntValue().intValueExact());
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(random, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && "print".equals(methodName)) {
                    String formatedMessage = new StringFormatter(this.line, this.parserPath).format(Utils.unquote(parameterValues.get(0).getStringValue()), parameterValues.subList(1, parameterValues.size()).toArray()).toString();
                    ScenarioUtils.print(formatedMessage);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && ("message".equals(methodName) || "appendf".equals(methodName))) {
                    if ("appendf".equals(methodName)) {
                        String formatedMessage = new StringFormatter(this.line, this.parserPath).format(parameterValues.get(0).getStringValue(), parameterValues.subList(1, parameterValues.size()).toArray()).toString();
                        List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(formatedMessage, -1, false), null, this.toString(true), this.line));
                        return list;
                    }
                    String formatedMessage = new StringFormatter(this.line, this.parserPath).format(Utils.unquote(parameterValues.get(1).getStringValue()), parameterValues.subList(2, parameterValues.size()).toArray()).toString();
                    ScenarioUtils.print(parameterValues.get(0).getIntValue().intValueExact(), formatedMessage);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && "is_before".equals(methodName)) {
                    boolean isBefore = scenario.isBefore((ActionInstance)parameterValues.get(0).getRefValue(), (ActionInstance)parameterValues.get(1).getRefValue());
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(isBefore ? BigInteger.ONE : BigInteger.ZERO, 1, false), null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && "is_parallel".equals(methodName)) {
                    boolean isParallel = scenario.isParallel((ActionInstance)parameterValues.get(0).getRefValue(), (ActionInstance)parameterValues.get(1).getRefValue());
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(isParallel ? BigInteger.ONE : BigInteger.ZERO, 1, false), null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && enclosingScope instanceof RfCollectionType && ((RfCollectionType)enclosingScope).isVectorType()) {
                    Value result = Value.from(BigInteger.ONE, 32, true);
                    if ("push_front".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).insertListItem(0, parameterValues.get(0), this.line, this.parserPath);
                    } else if ("push_back".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).addListItem(parameterValues.get(0), this.line, this.parserPath);
                    } else if ("insert".equals(methodName)) {
                        Value value = parameterValues.get(1);
                        ((FieldInstance)methodInstanceScope).insertListItem(parameterValues.get(0).getIntValue().intValueExact(), value, this.line, this.parserPath);
                    } else if ("clear".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).clearItems();
                    } else if ("delete".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).removeListItem(parameterValues.get(0).getIntValue().intValueExact(), this.line, this.parserPath);
                    } else if ("pop_front".equals(methodName)) {
                        FieldInstance itemInstance = ((FieldInstance)methodInstanceScope).removeListItem(0, this.line, this.parserPath);
                        result = itemInstance.variableValue;
                    } else if ("pop_back".equals(methodName)) {
                        FieldInstance itemInstance = ((FieldInstance)methodInstanceScope).removeListItem(((FieldInstance)methodInstanceScope).getCollectionSize() - 1, this.line, this.parserPath);
                        result = itemInstance.variableValue;
                    } else if ("set".equals(methodName)) {
                        FieldInstance itemInstance = ((FieldInstance)methodInstanceScope).getListItem(parameterValues.get(0).getIntValue().intValueExact(), this.line, this.parserPath);
                        Value value = parameterValues.get(1);
                        if (Value.isValueCopyAssignment(value)) {
                            itemInstance.deepCopy(value.getRefValue(), this.line, this.parserPath);
                        } else {
                            itemInstance.setVariableValue(value);
                        }
                    } else if ("shuffle".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).shuffleCollection(solver);
                    } else if ("size".equals(methodName)) {
                        result = Value.from(BigInteger.valueOf(((FieldInstance)methodInstanceScope).getCollectionSize()), 32, true);
                    } else if ("to_list".equals(methodName)) {
                        result = Value.from(methodInstanceScope, -1, false);
                    } else if ("to_set".equals(methodName)) {
                        FieldInstance toSetInstance = ((FieldInstance)methodInstanceScope).listToSet(this.line, this.parserPath);
                        result = Value.from(toSetInstance, -1, false);
                    } else {
                        throw new Solver.EvaluationException(Utils.append("'", this.toString(false), "' not supported by this version of the tool"), this.line, this.parserPath);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(result, null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && enclosingScope instanceof RfCollectionType && ((RfCollectionType)enclosingScope).isMapType()) {
                    Value result = Value.from(BigInteger.ONE, 32, true);
                    if ("insert".equals(methodName)) {
                        Value value = parameterValues.get(1);
                        ((FieldInstance)methodInstanceScope).insertMapItem(parameterValues.get(0).getValue(), value, this.line, this.parserPath);
                    } else if ("clear".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).clearItems();
                    } else if ("delete".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).removeMapItem(parameterValues.get(0).getValue());
                    } else if ("exists".equals(methodName)) {
                        FieldInstance itemInstance = ((FieldInstance)methodInstanceScope).getMapItem(parameterValues.get(0).getValue());
                        result = Value.from(itemInstance != null);
                    } else if ("size".equals(methodName)) {
                        result = Value.from(BigInteger.valueOf(((FieldInstance)methodInstanceScope).getCollectionSize()), 32, true);
                    } else if ("keys".equals(methodName)) {
                        FieldInstance keysInstance = ((FieldInstance)methodInstanceScope).getMapKeys(this.line, this.parserPath);
                        result = Value.from(keysInstance, -1, false);
                    } else if ("values".equals(methodName)) {
                        FieldInstance valuesInstance = ((FieldInstance)methodInstanceScope).getMapValues(this.line, this.parserPath);
                        result = Value.from(valuesInstance, -1, false);
                    } else {
                        throw new Solver.EvaluationException(Utils.append("'", this.toString(false), "' not supported by this version of the tool"), this.line, this.parserPath);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(result, null, this.toString(true), this.line));
                    return list;
                }
                if (rfMethod instanceof RfPredefinedMethod && enclosingScope instanceof RfCollectionType && ((RfCollectionType)enclosingScope).isSetType()) {
                    Value result = Value.from(BigInteger.ONE, 32, true);
                    if ("insert".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).insertMapItem(parameterValues.get(0).getValue(), parameterValues.get(0), this.line, this.parserPath);
                    } else if ("clear".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).clearItems();
                    } else if ("delete".equals(methodName)) {
                        ((FieldInstance)methodInstanceScope).removeMapItem(parameterValues.get(0));
                    } else if ("exists".equals(methodName)) {
                        FieldInstance itemInstance = ((FieldInstance)methodInstanceScope).getMapItem(parameterValues.get(0));
                        result = Value.from(itemInstance != null);
                    } else if ("size".equals(methodName)) {
                        result = Value.from(BigInteger.valueOf(((FieldInstance)methodInstanceScope).getCollectionSize()), 32, true);
                    } else if ("to_list".equals(methodName)) {
                        FieldInstance toSetInstance = ((FieldInstance)methodInstanceScope).setToList(this.line, this.parserPath);
                        result = Value.from(toSetInstance, -1, false);
                    } else {
                        throw new Solver.EvaluationException(Utils.append("'", this.toString(false), "' not supported by this version of the tool"), this.line, this.parserPath);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(result, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "pack".equals(methodName)) {
                    Value packValue = ((FieldInstance)methodInstanceScope).pack();
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(packValue, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "unpack".equals(methodName)) {
                    ((FieldInstance)methodInstanceScope).unpack(parameterValues.get(0));
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ONE, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "make_handle_from_claim".equals(methodName)) {
                    InstancesContainer claimInstance = parameterValues.get(0).getRefValue();
                    Value.HndlValue handleValue = (Value.HndlValue)claimInstance.getVariableValue();
                    if (handleValue == null) {
                        throw new Solver.EvaluationException(Utils.append("Cannot create handle from unresolved claim '", claimInstance, "'"), this.line, this.parserPath);
                    }
                    BigInteger offsetValue = parameterValues.get(1).getIntValue();
                    BigInteger sizeValue = Utils.intValue(claimInstance.getFieldInstance("size"));
                    if (sizeValue.compareTo(offsetValue) <= 0 && !sizeValue.equals(BigInteger.ZERO)) {
                        throw new Solver.EvaluationException(Utils.append("Offset '", offsetValue, "' is out of range (claim size is ", sizeValue, ")"), this.line, this.parserPath);
                    }
                    Value.HndlValue newHandleValue = Value.from(handleValue.region, handleValue.address, handleValue.offset.add(offsetValue), handleValue.size, handleValue.permanent);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value.HndlValue>(newHandleValue, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "make_handle_from_handle".equals(methodName)) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    BigInteger offsetValue = parameterValues.get(1).getIntValue();
                    BigInteger sizeValue = handleValue.getSize();
                    if (sizeValue.compareTo(offsetValue) <= 0 && !sizeValue.equals(BigInteger.ZERO)) {
                        throw new Solver.EvaluationException(Utils.append("Offset '", offsetValue, "' is out of range (handle size is ", sizeValue, ")"), this.line, this.parserPath);
                    }
                    Value.HndlValue newHandleValue = Value.from(handleValue.region, handleValue.address, handleValue.offset.add(offsetValue), handleValue.size, handleValue.permanent);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value.HndlValue>(newHandleValue, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "addr_value".equals(methodName)) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(handleValue.getLowerAddress(), 64, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "add_region".equals(methodName)) {
                    ComponentInstance parentComponent = methodCallContext.getParentComponentInstance();
                    InstancesContainer regionInstance = parameterValues.get(0).getRefValue();
                    parentComponent.addRegion((RegionInstance)regionInstance, true, this.line, this.parserPath);
                    Value.HndlValue newHandleValue = ((RegionInstance)regionInstance).getRegionHandle(BigInteger.ZERO);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value.HndlValue>(newHandleValue, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "add_nonallocatable_region".equals(methodName)) {
                    ComponentInstance parentComponent = methodCallContext.getParentComponentInstance();
                    InstancesContainer regionInstance = parameterValues.get(0).getRefValue();
                    parentComponent.addRegion((RegionInstance)regionInstance, false, this.line, this.parserPath);
                    Value.HndlValue newHandleValue = ((RegionInstance)regionInstance).getRegionHandle(BigInteger.ZERO);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value.HndlValue>(newHandleValue, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && ("read8".equals(methodName) || "read16".equals(methodName) || "read32".equals(methodName) || "read64".equals(methodName))) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    int nofBytes = Integer.parseInt(methodName.substring(4)) / 8;
                    Value readValue = handleValue.readBytes(nofBytes, 0);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(readValue, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "read_bytes".equals(methodName)) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    FieldInstance listInstance = (FieldInstance)parameterValues.get(1).getRefValue();
                    int size = parameterValues.get(2).getIntValue().intValueExact();
                    int i = 0;
                    while (i < size) {
                        Value readValue = handleValue.readBytes(1, i);
                        listInstance.addListItem(readValue, this.line, this.parserPath);
                        ++i;
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "read_struct".equals(methodName)) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    InstancesContainer packInstance = parameterValues.get(1).getRefValue();
                    int nofBytes = Utils.nofBytes(packInstance.getRfFieldType().sizeof());
                    Value packValue = handleValue.readBytes(nofBytes, 0);
                    packInstance.unpack(packValue);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && ("write8".equals(methodName) || "write16".equals(methodName) || "write32".equals(methodName) || "write64".equals(methodName))) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    Value writeValue = parameterValues.get(1);
                    int nofBytes = Integer.parseInt(methodName.substring(5)) / 8;
                    handleValue.writeBytes(nofBytes, 0, writeValue);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "write_bytes".equals(methodName)) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    InstancesContainer listInstance = parameterValues.get(1).getRefValue();
                    Map<String, FieldInstance> fieldInstances = listInstance.getFieldInstances();
                    if (fieldInstances != null && !fieldInstances.isEmpty()) {
                        for (FieldInstance fieldInstance : fieldInstances.values()) {
                            if (!fieldInstance.isArrayItem()) continue;
                            Value writeValue = fieldInstance.getVariableValue();
                            handleValue.writeBytes(1, fieldInstance.arrayItemIndex, writeValue);
                        }
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "write_struct".equals(methodName)) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    Value packValue = parameterValues.get(1).getRefValue().pack();
                    int nofBytes = Utils.nofBytes(packValue.nofBits());
                    handleValue.writeBytes(nofBytes, 0, packValue);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "read".equals(methodName)) {
                    Value accessValue;
                    ComponentInstance componentInstance = this.getParentComponentInstance(methodInstanceScope);
                    FieldInstance accessInstance = componentInstance.getFieldInstance("access");
                    Value value = accessValue = accessInstance == null ? null : accessInstance.getVariableValue();
                    if (accessValue instanceof Value.EnumValue && "WRITEONLY".equals(accessValue.getStringValue())) {
                        throw new Solver.EvaluationException(Utils.append("Illegal atempt to read '", componentInstance, "' write-only register"), this.line, this.parserPath);
                    }
                    int arraySize = Utils.getAssociatedTypeArrayDim(rfMethod);
                    RfNamedElement rfFieldType = Utils.getAssociatedType(rfMethod);
                    RfField rfField = new RfField("result", rfMethod.getDataType());
                    rfField.setAssociatedType(rfFieldType);
                    Value.HndlValue handleValue = componentInstance.getHandle(this.line, this.parserPath);
                    FieldInstance packInstance22 = FieldInstance.create(rfField, rfFieldType, true, arraySize, -1, methodInstanceScope.runtimeId, scenario);
                    ((InstancesContainer)packInstance22).createSubInstances(new IdentityHashMap<RfNamedElement, InstancesContainer>(), true);
                    int nofBytes = Utils.nofBytes(rfFieldType.sizeof());
                    Value packValue = handleValue.readBytes(nofBytes, 0);
                    packInstance22.unpack(packValue);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(packInstance22, -1, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "read_val".equals(methodName)) {
                    Value accessValue;
                    ComponentInstance componentInstance = this.getParentComponentInstance(methodInstanceScope);
                    FieldInstance accessInstance = componentInstance.getFieldInstance("access");
                    Value value = accessValue = accessInstance == null ? null : accessInstance.getVariableValue();
                    if (accessValue instanceof Value.EnumValue && "WRITEONLY".equals(accessValue.getStringValue())) {
                        throw new Solver.EvaluationException(Utils.append("Illegal atempt to read '", componentInstance, "' write-only register"), this.line, this.parserPath);
                    }
                    Value.HndlValue handleValue = componentInstance.getHandle(this.line, this.parserPath);
                    int nofBytes = Utils.nofBytes(rfMethod.sizeof());
                    Value packValue = handleValue.readBytes(nofBytes, 0);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(packValue, null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "write".equals(methodName)) {
                    Value accessValue;
                    ComponentInstance componentInstance = this.getParentComponentInstance(methodInstanceScope);
                    FieldInstance accessInstance = componentInstance.getFieldInstance("access");
                    Value value = accessValue = accessInstance == null ? null : accessInstance.getVariableValue();
                    if (accessValue instanceof Value.EnumValue && "READONLY".equals(accessValue.getStringValue())) {
                        throw new Solver.EvaluationException(Utils.append("Illegal atempt to write '", componentInstance, "' read-only register"), this.line, this.parserPath);
                    }
                    Value.HndlValue handleValue = componentInstance.getHandle(this.line, this.parserPath);
                    Value packValue = parameterValues.get(0).getRefValue().pack();
                    int nofBytes = Utils.nofBytes(packValue.nofBits());
                    handleValue.writeBytes(nofBytes, 0, packValue);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "write_val".equals(methodName)) {
                    Value accessValue;
                    ComponentInstance componentInstance = this.getParentComponentInstance(methodInstanceScope);
                    FieldInstance accessInstance = componentInstance.getFieldInstance("access");
                    Value value = accessValue = accessInstance == null ? null : accessInstance.getVariableValue();
                    if (accessValue instanceof Value.EnumValue && "READONLY".equals(accessValue.getStringValue())) {
                        throw new Solver.EvaluationException(Utils.append("Illegal atempt to write '", componentInstance, "' read-only register"), this.line, this.parserPath);
                    }
                    Value.HndlValue handleValue = componentInstance.getHandle(this.line, this.parserPath);
                    Value packValue = parameterValues.get(0);
                    int nofBytes = Utils.nofBytes(packValue.nofBits());
                    handleValue.writeBytes(nofBytes, 0, packValue);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isAddrRegPkgMember && "set_handle".equals(methodName)) {
                    Value.HndlValue handleValue = parameterValues.get(0).getHndlValue();
                    ((ComponentInstance)methodInstanceScope).setHandle(handleValue, this.line, this.parserPath);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isExecPkgMember && "add_executor".equals(methodName)) {
                    ComponentInstance parentComponent = methodCallContext.getParentComponentInstance();
                    InstancesContainer executorInstance = parameterValues.get(0).getRefValue();
                    parentComponent.addExecutor((ComponentInstance)executorInstance, this.line, this.parserPath);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Object>(null, null, this.toString(true), this.line));
                    return list;
                }
                if (isExecPkgMember && "executor".equals(methodName)) {
                    ActionInstance actionInstance = methodCallContext.getParentActionInstance();
                    InstancesContainer executorInstance = scenario.executorAssignments.get(actionInstance);
                    if (executorInstance instanceof ComponentInstance) {
                        List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(executorInstance, -1, false), null, this.toString(true), this.line));
                        return list;
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "error".equals(methodName)) {
                    String formatedMessage = new StringFormatter(this.line, this.parserPath).format(Utils.unquote(parameterValues.get(0).getStringValue()), parameterValues.subList(1, parameterValues.size()).toArray()).toString();
                    ScenarioUtils.printError(formatedMessage, false, this.line, this.parserPath);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "warning".equals(methodName)) {
                    String formatedMessage = new StringFormatter(this.line, this.parserPath).format(Utils.unquote(parameterValues.get(0).getStringValue()), parameterValues.subList(1, parameterValues.size()).toArray()).toString();
                    ScenarioUtils.printWarning(formatedMessage, false, this.line, this.parserPath);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "fatal".equals(methodName)) {
                    String formatedMessage = new StringFormatter(this.line, this.parserPath).format(Utils.unquote(parameterValues.get(1).getStringValue()), parameterValues.subList(2, parameterValues.size()).toArray()).toString();
                    throw new Solver.EvaluationException(Utils.append(formatedMessage, " (fatal error status = ", parameterValues.get(0).getStringValue(), ")"), this.line, this.parserPath);
                }
                if (isStdPkgMember && "file_exists".equals(methodName)) {
                    File file = new File(parameterValues.get(0).getStringValue());
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(file.exists()), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "file_open".equals(methodName)) {
                    RandomAccessFile randomAccessFile;
                    block228: {
                        String fileName = DVTStringUtil.unquote((String)parameterValues.get(0).getStringValue());
                        int accessType = parameterValues.get(1).getIntValue().intValue();
                        randomAccessFile = null;
                        try {
                            File file = new File(fileName);
                            if (!file.isAbsolute()) {
                                fileName = solver.getRfProject().getProject().getLocation().append(fileName).toOSString();
                                file = new File(fileName);
                            }
                            if (!file.exists()) {
                                if (!file.getParentFile().mkdirs() && !file.createNewFile()) {
                                    throw new Solver.EvaluationException(Utils.append("Failed to create file '", fileName, "'"), this.line, this.parserPath);
                                }
                            } else {
                                if (file.exists() && (accessType == 0 || accessType == 1) && !file.canWrite()) {
                                    throw new Solver.EvaluationException(Utils.append("Failed to write file '", fileName, "'"), this.line, this.parserPath);
                                }
                                if (file.exists() && accessType == 2 && !file.canRead()) {
                                    throw new Solver.EvaluationException(Utils.append("Failed to read file '", fileName, "'"), this.line, this.parserPath);
                                }
                            }
                            if (accessType == 0) {
                                randomAccessFile = new RandomAccessFile(fileName, "rw");
                                randomAccessFile.setLength(0L);
                                break block228;
                            }
                            if (accessType == 1) {
                                randomAccessFile = new RandomAccessFile(fileName, "rw");
                                randomAccessFile.seek(randomAccessFile.length());
                                break block228;
                            }
                            if (accessType == 2) {
                                randomAccessFile = new RandomAccessFile(fileName, "rw");
                                randomAccessFile.seek(randomAccessFile.length());
                                break block228;
                            }
                            throw new Solver.EvaluationException(Utils.append("Unsupported file access type '", parameterValues.get(1).getStringValue(), "'"), this.line, this.parserPath);
                        }
                        catch (Solver.EvaluationException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    int fileDescriptor = solver.getFileDescriptor(randomAccessFile);
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(fileDescriptor, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "file_close".equals(methodName)) {
                    int fileDescriptor = parameterValues.get(0).getIntValue().intValue();
                    RandomAccessFile randomAccessFile = solver.removeFile(fileDescriptor);
                    if (randomAccessFile == null) {
                        throw new Solver.EvaluationException(Utils.append("Failed to write file"), this.line, this.parserPath);
                    }
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "file_write".equals(methodName)) {
                    int fileDescriptor = parameterValues.get(0).getIntValue().intValue();
                    RandomAccessFile randomAccessFile = solver.getFile(fileDescriptor);
                    if (randomAccessFile == null) {
                        throw new Solver.EvaluationException(Utils.append("Failed to write file"), this.line, this.parserPath);
                    }
                    try {
                        String formatedMessage = new StringFormatter(this.line, this.parserPath).format(Utils.unquote(parameterValues.get(1).getStringValue()), parameterValues.subList(2, parameterValues.size()).toArray()).toString();
                        randomAccessFile.writeBytes(formatedMessage);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "file_read".equals(methodName)) {
                    RandomAccessFile randomAccessFile = solver.getFile(parameterValues.get(0).getIntValue().intValue());
                    if (randomAccessFile == null) {
                        throw new Solver.EvaluationException(Utils.append("Failed to read file"), this.line, this.parserPath);
                    }
                    StringBuilder readString = new StringBuilder();
                    try {
                        int size = parameterValues.get(1).getIntValue().intValue();
                        int i = 0;
                        while (size < 0 || i < size) {
                            char ch = randomAccessFile.readChar();
                            if (ch != '\uffffffff') {
                                readString.append(ch);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(readString.toString(), -1, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "file_read_lines".equals(methodName)) {
                    String fileName = DVTStringUtil.unquote((String)parameterValues.get(0).getStringValue());
                    File file = new File(fileName);
                    if (!file.isAbsolute()) {
                        fileName = solver.getRfProject().getProject().getLocation().append(fileName).toOSString();
                        file = new File(fileName);
                    }
                    if (!file.exists()) {
                        throw new Solver.EvaluationException(Utils.append("Failed to read file '", fileName, "'"), this.line, this.parserPath);
                    }
                    DataType dataType = new DataType("list<string>");
                    dataType.setItemDataType(null, new DataType("string"), DataType.CollectionKind.LIST);
                    RfField rfVar = new RfField("file_lines", dataType);
                    RfCollectionType rfVarType = RfCollectionType.createList(solver.getRfProject(), solver.stringType, dataType);
                    rfVar.setAssociatedType(rfVarType);
                    FieldInstance fieldInstance = FieldInstance.create(rfVar, rfVarType, true, -1, -1, methodInstanceScope.runtimeId, scenario);
                    try {
                        Throwable handleValue = null;
                        Object packInstance22 = null;
                        try (RandomAccessFile randomAccessFile = new RandomAccessFile(fileName, "rw");){
                            String lineText;
                            while ((lineText = randomAccessFile.readLine()) != null) {
                                List<ExprAndDep<Value>> value = Collections.singletonList(new ExprAndDep<Value>(Value.from(lineText, -1, false), null, LazyString.create(() -> lineText), this.line));
                                FieldInstance itemInstance = fieldInstance.addListItem(null, this.line, this.parserPath);
                                itemInstance.setVariableValue((Value)value.get((int)0).expr);
                            }
                        }
                        catch (Throwable packInstance22) {
                            if (handleValue == null) {
                                handleValue = packInstance22;
                            } else if (handleValue != packInstance22) {
                                handleValue.addSuppressed(packInstance22);
                            }
                            throw handleValue;
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(fieldInstance, -1, false), null, LazyString.create(() -> this.toString()), this.line));
                    return list;
                }
                if (isStdPkgMember && "file_write_lines".equals(methodName)) {
                    String fileName = DVTStringUtil.unquote((String)parameterValues.get(0).getStringValue());
                    FieldInstance lines = (FieldInstance)parameterValues.get(1).getRefValue();
                    int accessType = parameterValues.get(2).getIntValue().intValue();
                    try {
                        File file = new File(fileName);
                        if (!file.isAbsolute()) {
                            fileName = solver.getRfProject().getProject().getLocation().append(fileName).toOSString();
                            file = new File(fileName);
                        }
                        if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
                            throw new Solver.EvaluationException(Utils.append("Failed to write file '", fileName, "'"), this.line, this.parserPath);
                        }
                    }
                    catch (Solver.EvaluationException e) {
                        throw e;
                    }
                    catch (Exception exception) {
                        throw new Solver.EvaluationException(Utils.append("Failed to write file '", fileName, "'"), this.line, this.parserPath);
                    }
                    try {
                        Throwable e = null;
                        Object var19_202 = null;
                        try (RandomAccessFile randomAccessFile = new RandomAccessFile(fileName, "rw");){
                            if (accessType == 0) {
                                randomAccessFile.setLength(0L);
                            } else if (accessType == 1) {
                                randomAccessFile.seek(randomAccessFile.length());
                            } else {
                                throw new Solver.EvaluationException(Utils.append("Unsupported file access type '", parameterValues.get(1).getStringValue(), "'"), this.line, this.parserPath);
                            }
                            int i = 0;
                            while (i < lines.getArraySize()) {
                                FieldInstance lineItem = lines.getListItem(i, this.line, this.parserPath);
                                String lineText = DVTStringUtil.unquote((String)lineItem.getStringVariableValue());
                                randomAccessFile.writeBytes(lineText);
                                randomAccessFile.writeBytes("\n");
                                ++i;
                            }
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            throw e;
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "urandom".equals(methodName)) {
                    Random random = solver.getUrandomRandom();
                    long value = random.nextLong() & 0xFFFFL;
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.valueOf(value), 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (isStdPkgMember && "urandom_range".equals(methodName)) {
                    Value minValue = parameterValues.get(0);
                    Value maxValue = parameterValues.get(1);
                    Random random = solver.getUrandomRandom();
                    long value = minValue.getIntValue().longValue() + (random.nextLong() & 0xFFFFL) % (maxValue.getIntValue().longValue() - minValue.getIntValue().longValue());
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.valueOf(value), 32, false), null, this.toString(true), this.line));
                    return list;
                }
                if (declaration != null && proceduralAST != null) {
                    block233: {
                        ParserPath parserPath = declaration.getParserPath();
                        try {
                            try {
                                ListExpression bodyExpressions = this.getCachedMethodBodyExpressionList(solver, proceduralAST, parserPath);
                                try {
                                    scenario.debugBeginEvaluate(this, methodCallContext);
                                    List<ExprAndDep<Value>> value = bodyExpressions.evaluate(scenario, methodCallContext);
                                    if (value == null || value.size() != 1) {
                                        throw new Solver.EvaluationException(Utils.append("Cannot evaluate '", this.toString(false), "' expression"), this.line, parserPath);
                                    }
                                }
                                finally {
                                    scenario.debugFinishEvaluate(this, methodCallContext);
                                }
                            }
                            catch (RecognitionException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                methodCallContext.copyOutputArgumentValues(methodCallInstanceScope, this.arguments, this.line, parserPath);
                                break block233;
                            }
                        }
                        catch (Throwable throwable) {
                            methodCallContext.copyOutputArgumentValues(methodCallInstanceScope, this.arguments, this.line, parserPath);
                            throw throwable;
                        }
                        methodCallContext.copyOutputArgumentValues(methodCallInstanceScope, this.arguments, this.line, parserPath);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                if (ScenarioUtils.hasForeignEvaluator()) {
                    Class[] parameterTypes = new Class[parameterValues.size()];
                    int i = 0;
                    while (i < parameterTypes.length) {
                        parameterTypes[i] = Value.class;
                        ++i;
                    }
                    Object result = ScenarioUtils.invokeMethod(rfMethod.getForeignMethodName(), parameterTypes, parameterValues.toArray());
                    if (result instanceof Value) {
                        List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>((Value)result, null, this.toString(true), this.line));
                        return list;
                    }
                    if (result != null) {
                        ScenarioUtils.printError(Utils.append("Foreign function '", rfMethod.getForeignMethodName(), "' must return 'Value' instead of '", result.getClass().getSimpleName(), "'"), true, this.line, this.parserPath);
                    }
                    List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                    return list;
                }
                ScenarioUtils.printWarning(Utils.append("Method/function call cannot be executed (no procedural body or foreign implementation provided)"), true, this.line, this.parserPath);
                List<ExprAndDep<Value>> list = Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                return list;
            }
            catch (ReturnException e) {
                List<ExprAndDep<Value>> list = e.getReturnValue();
                return list;
            }
            finally {
                scenario.stackTrace.pop();
            }
        }

        private final ComponentInstance getParentComponentInstance(InstancesContainer instancesContainer) {
            return instancesContainer instanceof ComponentInstance ? (ComponentInstance)instancesContainer : instancesContainer.getParentComponentInstance();
        }

        private final ListExpression getCachedMethodBodyExpressionList(Solver solver, AST proceduralAST, ParserPath parserPath) throws RecognitionException {
            if (this.bodyExpressionList != null) {
                return this.bodyExpressionList;
            }
            ModelWalker modelWalker = new ModelWalker(solver, parserPath);
            this.bodyExpressionList = modelWalker.procedural_function_call(proceduralAST);
            return this.bodyExpressionList;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfMethod);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfMethod = (RfMethod)ScenarioUtils.getRfOfKey(key);
        }
    }

    public static class NestedBlockAssign
    extends ListExpression {
        private static final long serialVersionUID = 1L;

        public NestedBlockAssign(int line, ParserPath parserPath) {
            super(line, parserPath);
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            NestedBlockContext currentScopeContext = new NestedBlockContext("[block]", currentInstanceScope.runtimeId, currentInstanceScope, scenario);
            return super.evaluate(scenario, currentScopeContext);
        }
    }

    public static class NullExpression
    extends Expression {
        private static final long serialVersionUID = 1L;

        public NullExpression(int line, ParserPath parserPath) {
            super(line, parserPath);
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> "null");
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, LazyString.create(() -> "null"), this.line));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            return null;
        }

        @Override
        public boolean isRand() {
            return false;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return null;
        }

        @Override
        public void cleanErrors() {
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static abstract class PrimaryExpression
    extends Expression {
        private static final long serialVersionUID = 1L;
        protected String value;

        protected PrimaryExpression(String value, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.value = value;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> this.value);
        }

        @Override
        public boolean isRand() {
            return false;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return null;
        }

        @Override
        public void cleanErrors() {
        }
    }

    public static class Randomize
    extends Assign {
        private static final long serialVersionUID = 1L;
        private List<Hid> variables;
        private Expression expression;
        private long seed;

        public Randomize(RfStruct rfStructType, List<Hid> variables, Expression expression, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.variables = variables;
            this.expression = expression;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("randomize ", this.variables, " with ", this.expression));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            try {
                scenario.clearProceduralRand();
                scenario.initSolverExpressionsErrors();
                LinkedHashMap<String, FieldInstance> fieldInstances = new LinkedHashMap<String, FieldInstance>();
                for (Hid variable : this.variables) {
                    try {
                        List<InstancePath> varInstancePaths = variable.getVarInstancePaths(scenario, true, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
                        for (InstancePath varInstancePath : varInstancePaths) {
                            InstancesContainer fieldInstance = varInstancePath.getInstance();
                            fieldInstances.put(fieldInstance.getName(), (FieldInstance)fieldInstance);
                            scenario.addProceduralRand(fieldInstance);
                            fieldInstance.preSolve();
                            fieldInstance.getVariable(model, null, varInstancePath, variableSolverMap, reportEvaluationError);
                        }
                    }
                    catch (Solver.SkipEvaluationException skipEvaluationException) {
                        ScenarioUtils.printWarning(Utils.append("Cannot evaluate '", this.expression.toString(false), "' expression (ignored)"), true, this.expression.line, this.expression.parserPath);
                    }
                }
                Set<InstancesContainer> alreadyVisited = Utils.popReusableSet(InstancesContainer.class);
                try {
                    scenario.applyConstraints(model, variableSolverMap, alreadyVisited, fieldInstances, cspToReadableTextMap);
                }
                finally {
                    Utils.pushReusableSet(alreadyVisited);
                }
                ConstraintDescriptor constraintDescriptor = new ConstraintDescriptor(null, this.expression, true, -1, false);
                constraintDescriptor.apply(scenario, model, variableSolverMap, forallInstanceScope, currentInstanceScope, null, cspToReadableTextMap);
                scenario.solver.cspSolve(true, true, false, true, model, variableSolverMap, cspToReadableTextMap, this.seed);
                for (InstancesContainer fieldInstance : fieldInstances.values()) {
                    fieldInstance.postSolve();
                }
                List<ExprAndDep<IntVariable>> list = Collections.singletonList(new ExprAndDep<IntVariable>(Value.from(BigInteger.ZERO, 32, true).intVar(model), null, this.toString(true), this.line));
                return list;
            }
            finally {
                scenario.clearProceduralRand();
            }
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            Model model = new Model(() -> ((IProgressMonitor)scenario.getSolver().getMonitor()).isCanceled(), scenario.stringVariableMapping);
            LinkedHashMap<String, InstancesContainer.GeneratedVar> variableSolverMap = new LinkedHashMap<String, InstancesContainer.GeneratedVar>();
            IdentityHashMap<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap = new IdentityHashMap<AbstractConstraint, ConstraintDescriptor.Text>();
            ActionInstance parentActionInstance = currentInstanceScope instanceof ActionInstance ? (ActionInstance)currentInstanceScope : currentInstanceScope.getParentActionInstance();
            this.seed = Math.min(Long.MAX_VALUE, parentActionInstance.seed);
            this.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, currentInstanceScope, currentInstanceScope, true, -1, true);
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
        }
    }

    public static class RepeatAssign
    extends ForeachAssign {
        private static final long serialVersionUID = 1L;

        public RepeatAssign(RfStruct rfStructType, Expression expression, RfField.RfIndexField rfIndexField, Expression bodyExpression, int line, ParserPath parserPath) {
            super(rfStructType, expression, rfIndexField, null, bodyExpression, line, parserPath);
        }
    }

    public static class ReturnAssign
    extends Assign {
        private static final long serialVersionUID = 1L;
        private Expression expression;

        public ReturnAssign(Expression expression, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.expression = expression;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            if (this.expression == null) {
                return LazyString.create(() -> "return");
            }
            return LazyString.create(() -> Utils.append("return ", this.expression.toString(false)));
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                scenario.debugBeginEvaluate(this, currentInstanceScope);
                List<ExprAndDep<Value>> value = this.expression.evaluate(scenario, currentInstanceScope);
                throw new ReturnException(value);
            }
            catch (Throwable throwable) {
                scenario.debugFinishEvaluate(this, currentInstanceScope);
                throw throwable;
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return null;
        }
    }

    public static class ReturnException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final transient List<ExprAndDep<Value>> value;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }

        public ReturnException(List<ExprAndDep<Value>> value) {
            this.value = value;
        }

        public List<ExprAndDep<Value>> getReturnValue() {
            return this.value;
        }
    }

    static class RunnableConstraint
    extends Equals {
        private Runnable runnable;

        protected RunnableConstraint(Model model, Runnable runnable) {
            super(model, false, new Variable[0]);
            this.runnable = runnable;
        }

        public AbstractConstraint post() {
            this.runnable.run();
            return this;
        }
    }

    static class RunnableIntVariable
    extends IntVariable {
        private Runnable runnable;

        protected RunnableIntVariable(Model model, Runnable runnable) {
            super(model, false, 1);
            this.runnable = runnable;
        }
    }

    public static class Scheduling
    extends Expression {
        private static final long serialVersionUID = 1L;
        private Hid expr1;
        private Hid expr2;
        private Operator op;
        private boolean isSoft;

        public Scheduling(Operator op, Hid expr1, Hid expr2, boolean isSoft, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.op = op;
            this.expr1 = expr1;
            this.expr2 = expr2;
            this.isSoft = isSoft;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("'", this.expr1.toString(false), "' ", this.op.toString().toLowerCase(), " '", this.expr2.toString(false), "'"));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<InstancePath> actionInstancePaths1 = this.expr1.getVariablesPaths(scenario, false, currentInstanceScope, keepClosestToMax, maxTraversalIndex);
            if (actionInstancePaths1 == null || actionInstancePaths1.isEmpty()) {
                return null;
            }
            List<InstancePath> actionInstancePaths2 = this.expr2.getVariablesPaths(scenario, false, currentInstanceScope, keepClosestToMax, maxTraversalIndex);
            if (actionInstancePaths2 == null || actionInstancePaths2.isEmpty()) {
                return null;
            }
            for (InstancePath actionInstancePath1 : actionInstancePaths1) {
                InstancesContainer actionInstance1 = actionInstancePath1.getInstance();
                if (actionInstance1 instanceof FieldInstance) continue;
                for (InstancePath actionInstancePath2 : actionInstancePaths2) {
                    InstancesContainer actionInstance2 = actionInstancePath2.getInstance();
                    if (actionInstance2 instanceof FieldInstance) continue;
                    if (this.op == Operator.BEFORE) {
                        if (((ActionInstance)actionInstance1).isBefore((ActionInstance)actionInstance2)) {
                            scenario.scheduler.scheduleDependency((ActionInstance)actionInstance1, (ActionInstance)actionInstance2);
                            continue;
                        }
                        if (((ActionInstance)actionInstance1).canScheduleBefore((ActionInstance)actionInstance2)) {
                            ((ActionInstance)actionInstance1).scheduleBefore((ActionInstance)actionInstance2);
                            scenario.scheduler.scheduleDependency((ActionInstance)actionInstance1, (ActionInstance)actionInstance2);
                            continue;
                        }
                        if (!this.isSoft) {
                            ScenarioUtils.printError(Utils.append("Scheduling constraint ", this.toString(), " cannot be satisfied"), true, this.line, this.parserPath);
                            throw new Solver.SolverException();
                        }
                        ScenarioUtils.printWarning(Utils.append("Scheduling soft constraint ", this.toString(), " cannot be satisfied (ignored)"), true, this.line, this.parserPath);
                        continue;
                    }
                    if (((ActionInstance)actionInstance1).isParallel((ActionInstance)actionInstance2)) {
                        scenario.scheduler.scheduleDependency((ActionInstance)actionInstance1, (ActionInstance)actionInstance2);
                        continue;
                    }
                    if (((ActionInstance)actionInstance1).canScheduleParallel((ActionInstance)actionInstance2)) {
                        ((ActionInstance)actionInstance1).scheduleParallel((ActionInstance)actionInstance2);
                        scenario.scheduler.scheduleDependency((ActionInstance)actionInstance1, (ActionInstance)actionInstance2);
                        continue;
                    }
                    if (!this.isSoft) {
                        ScenarioUtils.printError(Utils.append("Scheduling constraint ", this.toString(), " cannot be satisfied"), true, this.line, this.parserPath);
                        throw new Solver.SolverException();
                    }
                    ScenarioUtils.printWarning(Utils.append("Scheduling soft constraint ", this.toString(), " cannot be satisfied (ignored)"), true, this.line, this.parserPath);
                }
            }
            return null;
        }

        @Override
        public boolean isRand() {
            return false;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public boolean isUninitActionHandle() {
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.expr1, this.expr2);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.expr1, this.expr2);
        }

        public static enum Operator {
            BEFORE,
            PARALLEL;

        }
    }

    public static class Soft
    extends Expression {
        private static final long serialVersionUID = 1L;
        protected Expression expr;

        public Soft(Expression expression, int line, ParserPath parserPath) {
            super(line, parserPath);
            this.expr = expression;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            LazyString result = this.expr.toString(false);
            return enclosed ? LazyString.create(() -> Utils.append("soft (", result, ")")) : LazyString.create(() -> Utils.append("soft ", result));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            List<ExprAndDep<IntVariable>> vars = this.expr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            if (vars == null || vars.isEmpty()) {
                return null;
            }
            ArrayList<ExprAndDep<IntVariable>> result = new ArrayList<ExprAndDep<IntVariable>>();
            for (ExprAndDep<IntVariable> var1 : vars) {
                result.add(new ExprAndDep<IntVariable>(((IntVariable)var1.expr).soft(), var1.dependencies, LazyString.create(() -> Utils.append("(soft ", Utils.processHrText(exprAndDep.hrText.toString()), ")")), this.line));
            }
            return result;
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            return this.expr.evaluate(scenario, currentInstanceScope);
        }

        @Override
        public boolean isRand() {
            return this.expr.isRand();
        }

        @Override
        public boolean isRuntime() {
            return this.expr.isRuntime();
        }

        @Override
        public boolean isUninitActionHandle() {
            return this.expr.isUninitActionHandle();
        }

        @Override
        public boolean isIndex() {
            return this.expr.isIndex();
        }

        @Override
        public boolean isConstant() {
            return this.expr.isConstant();
        }

        @Override
        public List<ExpressionError> getErrors() {
            return this.expr.getErrors();
        }

        @Override
        public void cleanErrors() {
            this.expr.cleanErrors();
        }
    }

    public static class StringExpression
    extends PrimaryExpression {
        private static final long serialVersionUID = 1L;

        public StringExpression(String value, int line, ParserPath parserPath) {
            super(value, line, parserPath);
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(this.toString(), -1, false), null, LazyString.create(() -> this.value), this.line));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            return Collections.singletonList(new ExprAndDep<StrVariable>(model.strVar(this.value, this.value), null, LazyString.create(() -> Utils.append("\"", this.value, "\"")), this.line));
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> this.value);
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }

    public static class Super
    extends Assign {
        private static final long serialVersionUID = 1L;
        private ExecBlockKind execKind;
        private Id superId;

        public Super(Id superId, ExecBlockKind execKind, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.execKind = execKind;
            this.superId = superId;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> "super");
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            RfStruct rfStructType = (RfStruct)Utils.getAssociatedType(this.superId.rfField);
            if (rfStructType == null) {
                throw new Solver.EvaluationException(Utils.append("Fail to evaluate '", this.toString(false), "'"), this.line, this.parserPath);
            }
            ListExpression superExpr = new ListExpression(this.line, this.parserPath);
            Scenario.ExecDescriptors superExecDescriptors = scenario.getExecDescriptors(rfStructType, this.execKind);
            if (superExecDescriptors != null && !superExecDescriptors.descriptors.isEmpty()) {
                for (ConstraintDescriptor.ExecStmtDescriptor superExecDescriptor : superExecDescriptors.descriptors) {
                    superExpr.addExpression(superExecDescriptor.expression);
                }
            }
            return superExpr.evaluate(scenario, currentInstanceScope);
        }
    }

    public static class Unique
    extends InRange {
        private static final long serialVersionUID = 1L;
        private List<Expression> uniques = new ArrayList<Expression>();

        public Unique(int line, ParserPath parserPath) {
            super(null, line, parserPath);
        }

        @Override
        public void addInRange(Expression left, Expression right) {
            if (left == null || right != null && left != right) {
                ScenarioUtils.print("*** Error: Internal error UNQ_1");
                throw new Solver.InterruptException();
            }
            this.uniques.add(left);
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            ListExpression uniqueExpr = new ListExpression(maxTraversalIndex, this.parserPath);
            int i = 0;
            while (i < this.uniques.size()) {
                Expression expr1 = this.uniques.get(i);
                int j = i + 1;
                while (j < this.uniques.size()) {
                    Expression expr2 = this.uniques.get(j);
                    uniqueExpr.addExpression(new Logic(Logic.Operator.NOT_EQ, expr1, expr2, this.line, this.parserPath));
                    ++j;
                }
                ++i;
            }
            if (uniqueExpr.getExpressions().isEmpty()) {
                return null;
            }
            List<ExprAndDep<IntVariable>> result = uniqueExpr.getExpression(scenario, model, variableSolverMap, cspToReadableTextMap, forallInstanceScope, currentInstanceScope, keepClosestToMax, maxTraversalIndex, reportEvaluationError);
            return result;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> this.uniques.toString());
        }

        @Override
        public boolean isRand() {
            for (Expression expression : this.uniques) {
                if (expression.isRand()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isUninitActionHandle() {
            for (Expression expression : this.uniques) {
                if (!expression.isUninitActionHandle()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isIndex() {
            return false;
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            for (Expression expression : this.uniques) {
                expression.evaluateUnintActionHandles(solver);
            }
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.uniques);
        }

        @Override
        public void cleanErrors() {
            Utils.cleanErrors(this.uniques);
        }
    }

    public static class Unsupported
    extends Assign {
        private static final long serialVersionUID = 1L;
        protected String message;

        public Unsupported(String message, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.message = message;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("Unsupported '", this.message, "'"));
        }

        @Override
        public List<ExprAndDep<IntVariable>> getExpression(Scenario scenario, Model model, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, Map<AbstractConstraint, ConstraintDescriptor.Text> cspToReadableTextMap, InstancesContainer forallInstanceScope, InstancesContainer currentInstanceScope, boolean keepClosestToMax, int maxTraversalIndex, boolean reportEvaluationError) {
            ScenarioUtils.printError(this.message, true, this.line, this.parserPath);
            return Collections.singletonList(new ExprAndDep<IntVariable>(Value.from(BigInteger.ZERO, 32, true).intVar(model), null, this.toString(true), this.line));
        }

        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            ScenarioUtils.printError(this.message, true, this.line, this.parserPath);
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
        }
    }

    public static class Value
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static Value from(Value value) {
            if (value == null) {
                return new NullValue();
            }
            if (value instanceof HndlValue) {
                return new HndlValue(((HndlValue)value).region, ((HndlValue)value).address, ((HndlValue)value).offset, ((HndlValue)value).size, ((HndlValue)value).permanent);
            }
            if (value instanceof EnumValue) {
                return new EnumValue(((EnumValue)value).enumItem, ((IntValue)value).nofBits());
            }
            if (value instanceof StringValue) {
                return new StringValue(((StringValue)value).value);
            }
            if (value instanceof RefValue) {
                return new RefValue(((RefValue)value).value);
            }
            if (value instanceof IntValue) {
                return IntValue.create(((IntValue)value).value, ((IntValue)value).nofBits(), ((IntValue)value).hasSign());
            }
            if (value instanceof NullValue) {
                return new NullValue();
            }
            throw new UnsupportedOperationException();
        }

        public IntVariable intVar(Model model) {
            throw new UnsupportedOperationException();
        }

        public static Value from(boolean value) {
            return value ? IntValue.TRUE : IntValue.FALSE;
        }

        public static Value from(Object value, int nofBits, boolean hasSign) {
            if (value == null) {
                return new NullValue();
            }
            if (value instanceof HndlValue) {
                return new HndlValue(((HndlValue)value).region, ((HndlValue)value).address, ((HndlValue)value).offset, ((HndlValue)value).size, ((HndlValue)value).permanent);
            }
            if (value instanceof EnumValue) {
                return new EnumValue(((EnumValue)value).enumItem, nofBits);
            }
            if (value instanceof StringValue) {
                return new StringValue(((StringValue)value).value);
            }
            if (value instanceof RefValue) {
                return new RefValue(((RefValue)value).value);
            }
            if (value instanceof IntValue) {
                return IntValue.create(((IntValue)value).value, nofBits, hasSign);
            }
            if (value instanceof NullValue) {
                return new NullValue();
            }
            if (value instanceof InstancesContainer && ((InstancesContainer)value).isEnumType()) {
                return new EnumValue((InstancesContainer)value, 32);
            }
            if (value instanceof BigInteger) {
                return IntValue.create((BigInteger)value, nofBits, hasSign);
            }
            if (value instanceof Long || value.getClass() == Long.TYPE) {
                return IntValue.create(BigInteger.valueOf((Long)value), nofBits, hasSign);
            }
            if (value instanceof Integer || value.getClass() == Integer.TYPE) {
                return IntValue.create(BigInteger.valueOf(((Integer)value).intValue()), nofBits, hasSign);
            }
            if (value instanceof String) {
                return new StringValue((String)value);
            }
            if (value instanceof InstancesContainer) {
                return new RefValue((InstancesContainer)value);
            }
            throw new UnsupportedOperationException();
        }

        public String toString() {
            Object value = this.getValue();
            return value == null ? "null" : value.toString();
        }

        public Object getValue() {
            return null;
        }

        public int nofBits() {
            return -1;
        }

        public boolean hasSign() {
            return true;
        }

        public static ErrorValue errorValue(String message, int line, ParserPath parserPath) {
            return new ErrorValue(message, line, parserPath);
        }

        public BigInteger getIntValue() {
            throw new UnsupportedOperationException();
        }

        public String getStringValue() {
            throw new UnsupportedOperationException();
        }

        public InstancesContainer getRefValue() {
            throw new UnsupportedOperationException();
        }

        public HndlValue getHndlValue() {
            throw new UnsupportedOperationException();
        }

        public Value[] getArrayValue() {
            throw new UnsupportedOperationException();
        }

        public static boolean isNull(Value value) {
            return value instanceof NullValue;
        }

        public static boolean isString(Value value) {
            return value instanceof StringValue;
        }

        public static boolean isInteger(Value value) {
            return value instanceof IntValue;
        }

        public static boolean isEnumItem(Value value) {
            return value instanceof EnumValue;
        }

        public static boolean isReference(Value value) {
            return value instanceof RefValue;
        }

        public static boolean isTrue(Value value) {
            return value instanceof IntValue && !BigInteger.ZERO.equals(value.getIntValue());
        }

        public static boolean isValueCopyAssignment(Value value) {
            if (!Value.isReference(value)) {
                return false;
            }
            InstancesContainer refValue = Utils.unwrapReferenceInstance(value.getRefValue());
            return refValue.isValueCopyAssignment();
        }

        public Value toUorS(boolean isSigned) {
            throw new UnsupportedOperationException();
        }

        public Value toUnsigned() {
            throw new UnsupportedOperationException();
        }

        public Value toSigned() {
            throw new UnsupportedOperationException();
        }

        public static HndlValue from(RegionInstance region, BigInteger address, BigInteger offset, BigInteger size, boolean permanent) {
            return new HndlValue(region, address, offset, size, permanent);
        }

        public static HndlValue from(HndlValue hndlValue, BigInteger offset, int line, ParserPath parserPath) {
            BigInteger size = hndlValue.getSize();
            if (size.compareTo(offset) < 0) {
                throw new Solver.EvaluationException("Offset value is out of handle range", line, parserPath);
            }
            return new HndlValue(hndlValue.region, hndlValue.getLowerAddress(), offset, size, hndlValue.permanent);
        }

        public static boolean isHandle(Value value) {
            return value instanceof HndlValue;
        }

        static class EnumValue
        extends IntValue {
            private static final long serialVersionUID = 1L;
            private InstancesContainer enumItem;

            public EnumValue(InstancesContainer enumItem, int nofBits) {
                super(enumItem.getIntegerVariableValue(), nofBits, true);
                this.enumItem = enumItem;
            }

            @Override
            public InstancesContainer getRefValue() {
                return this.enumItem;
            }

            @Override
            public Object getValue() {
                return super.getValue();
            }

            @Override
            public String getStringValue() {
                return this.enumItem.getName();
            }

            @Override
            public int hashCode() {
                return this.enumItem.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                EnumValue other = (EnumValue)obj;
                if (!this.enumItem.equals(other.enumItem)) {
                    return false;
                }
                return super.equals(obj);
            }
        }

        static class ErrorValue
        extends Value {
            private static final long serialVersionUID = 1L;
            private int line;
            private ParserPath parserPath;
            private String message;

            public ErrorValue(String message, int line, ParserPath parserPath) {
                this.message = message;
                this.line = line;
                this.parserPath = parserPath;
                this.print();
            }

            public void print() {
                ScenarioUtils.printError(this.message, false, this.line, this.parserPath);
            }
        }

        static final class HndlValue
        extends Value
        implements Comparable<HndlValue> {
            private static final long serialVersionUID = 1L;
            private RegionInstance region;
            private BigInteger address;
            private BigInteger offset;
            private BigInteger size;
            private boolean permanent;

            public HndlValue(RegionInstance region, BigInteger address, BigInteger offset, BigInteger size, boolean permanent) {
                this.region = region;
                this.address = address;
                this.offset = offset;
                this.size = size;
                this.permanent = permanent;
            }

            public Value readBytes(int nofBytes, int byteOffset) {
                BigInteger address = this.getLowerAddress().add(BigInteger.valueOf(byteOffset));
                return this.region.readBytes(nofBytes, address);
            }

            public void writeBytes(int nofBytes, int byteOffset, Value data) {
                BigInteger address = this.getLowerAddress().add(BigInteger.valueOf(byteOffset));
                if (this.region == null) {
                    throw new Solver.EvaluationException("Address handle is not valid (region is 'null')");
                }
                this.region.writeBytes(nofBytes, address, data);
            }

            public BigInteger getLowerAddress() {
                return this.address.add(this.offset);
            }

            public BigInteger getUpperAddress() {
                return this.address.add(this.size).subtract(BigInteger.ONE);
            }

            public BigInteger getSize() {
                return this.size.subtract(this.offset);
            }

            @Override
            public String getStringValue() {
                if (this.address == null) {
                    return "null";
                }
                return this.address.add(this.offset).toString(16);
            }

            @Override
            public Object getValue() {
                return this.address.add(this.offset);
            }

            @Override
            public HndlValue getHndlValue() {
                return this;
            }

            public boolean isPermanent() {
                return this.permanent;
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + this.region.hashCode();
                result = 31 * result + this.address.hashCode();
                result = 31 * result + this.offset.hashCode();
                result = 31 * result + this.size.hashCode();
                result = 31 * result + (this.permanent ? 1231 : 1237);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                HndlValue other = (HndlValue)obj;
                if (this.region != other.region) {
                    return false;
                }
                if (this.permanent != other.permanent) {
                    return false;
                }
                if (!this.address.equals(other.address)) {
                    return false;
                }
                if (!this.offset.equals(other.offset)) {
                    return false;
                }
                return this.size.equals(other.size);
            }

            @Override
            public int compareTo(HndlValue o) {
                return this.getLowerAddress().compareTo(o.getLowerAddress());
            }

            @Override
            public String toString() {
                return Utils.append("region = ", this.region == null ? null : this.region.getInstancePath(), ", address = ", this.address, ", offset = ", this.offset, ", size = ", this.size, ", permanent = ", this.permanent);
            }

            public RegionInstance getRegion() {
                return (RegionInstance)Utils.unwrapReferenceInstance(this.region);
            }
        }

        static class IntValue
        extends Value {
            private static final long serialVersionUID = 1L;
            private BigInteger value;
            private int nofBits;
            private boolean hasSign;
            private static final IntValue ONE = new IntValue(BigInteger.ONE, 32, true);
            private static final IntValue ZERO = new IntValue(BigInteger.ZERO, 32, true);
            private static final IntValue TRUE = new IntValue(BigInteger.ONE, 1, false);
            private static final IntValue FALSE = new IntValue(BigInteger.ZERO, 1, false);

            public static IntValue create(BigInteger value, int nofBits, boolean hasSign) {
                if (nofBits == 32 && hasSign && BigInteger.ONE.equals(value)) {
                    return ONE;
                }
                if (nofBits == 32 && hasSign && BigInteger.ZERO.equals(value)) {
                    return ZERO;
                }
                if (nofBits == 1 && !hasSign && BigInteger.ONE.equals(value)) {
                    return TRUE;
                }
                if (nofBits == 1 && !hasSign && BigInteger.ZERO.equals(value)) {
                    return FALSE;
                }
                return new IntValue(value, nofBits, hasSign);
            }

            private IntValue(BigInteger value, int nofBits, boolean hasSign) {
                this.nofBits = nofBits;
                this.hasSign = hasSign;
                if (nofBits <= 0) {
                    ScenarioUtils.print("*** Error: Internal error NBT_1");
                    this.value = value;
                    return;
                }
                this.value = Utils.truncate(value, nofBits, hasSign);
            }

            @Override
            public BigInteger getIntValue() {
                return this.value;
            }

            @Override
            public String getStringValue() {
                return this.value.toString();
            }

            @Override
            public Object getValue() {
                return this.getIntValue();
            }

            public boolean equals(Object obj) {
                if (this.value != null && obj != null && obj.getClass() == this.getClass()) {
                    return this.value.equals(((IntValue)obj).value);
                }
                return false;
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            @Override
            public Value toUorS(boolean isSigned) {
                if (!this.hasSign && isSigned) {
                    return Value.from(Utils.signed(this.value, this.nofBits), this.nofBits, true);
                }
                if (this.hasSign && !isSigned) {
                    return Value.from(Utils.unsigned(this.value, this.nofBits), this.nofBits, false);
                }
                return this;
            }

            @Override
            public Value toUnsigned() {
                if (this.hasSign) {
                    return Value.from(Utils.unsigned(this.value, this.nofBits), this.nofBits, false);
                }
                return this;
            }

            @Override
            public Value toSigned() {
                if (this.hasSign) {
                    return this;
                }
                return Value.from(Utils.signed(this.value, this.nofBits), this.nofBits, true);
            }

            @Override
            public int nofBits() {
                return this.nofBits;
            }

            @Override
            public boolean hasSign() {
                return this.hasSign;
            }

            @Override
            public IntVariable intVar(Model model) {
                return model.getCachedConstant(this.hasSign, this.nofBits, this.value);
            }
        }

        static class NullValue
        extends Value {
            private static final long serialVersionUID = 1L;

            NullValue() {
            }

            @Override
            public BigInteger getIntValue() {
                return null;
            }

            @Override
            public String getStringValue() {
                return "";
            }

            @Override
            public InstancesContainer getRefValue() {
                return null;
            }

            @Override
            public Value toUorS(boolean isSigned) {
                return this;
            }

            @Override
            public Value toUnsigned() {
                return this;
            }

            @Override
            public Value toSigned() {
                return this;
            }
        }

        static class RefValue
        extends Value {
            private static final long serialVersionUID = 1L;
            private InstancesContainer value;

            public RefValue(InstancesContainer value) {
                this.value = value;
            }

            @Override
            public BigInteger getIntValue() {
                throw new Solver.EvaluationException("The value of '" + this.value.name + "' cannot be represented as a number");
            }

            @Override
            public String getStringValue() {
                throw new Solver.EvaluationException("The value of '" + this.value.name + "' cannot be represented as a string");
            }

            @Override
            public InstancesContainer getRefValue() {
                return this.value;
            }

            @Override
            public Object getValue() {
                return this.getRefValue();
            }

            public boolean equals(Object obj) {
                if (obj instanceof RefValue) {
                    return this.value.equals(((RefValue)obj).value);
                }
                return false;
            }

            public int hashCode() {
                return this.value.hashCode();
            }
        }

        static final class StringValue
        extends Value {
            private static final long serialVersionUID = 1L;
            private String value;

            public StringValue(String value) {
                this.value = value;
            }

            @Override
            public String getStringValue() {
                return this.value;
            }

            @Override
            public Object getValue() {
                return this.getStringValue();
            }

            public boolean equals(Object obj) {
                if (obj instanceof StringValue) {
                    return this.value.equals(((StringValue)obj).value);
                }
                return false;
            }

            public int hashCode() {
                return this.value.hashCode();
            }
        }
    }

    public static class WhileAssign
    extends Assign {
        private static final long serialVersionUID = 1L;
        private Expression expression;
        private Expression bodyExpression;
        private boolean isRepeatWhile;
        private transient RfStruct rfStructType;

        public WhileAssign(RfStruct rfStructType, Expression expression, Expression bodyExpression, boolean isRepeatWhile, int line, ParserPath parserPath) {
            super(null, null, line, parserPath);
            this.expression = expression;
            this.bodyExpression = bodyExpression;
            this.isRepeatWhile = isRepeatWhile;
            this.rfStructType = rfStructType;
        }

        @Override
        public LazyString toString(boolean enclosed) {
            return LazyString.create(() -> Utils.append("while/repeat (", this.expression.toString(), ")"));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<ExprAndDep<Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
            try {
                solver = scenario.getSolver();
                nofRepeats = 0;
                while (true) {
                    block19: {
                        scenario.debugBeginEvaluate(this, currentInstanceScope);
                        value = this.expression.evaluate(scenario, currentInstanceScope);
                        if (value == null || value.size() != 1) {
                            throw new Solver.EvaluationException(Utils.append(new Object[]{"Cannot evaluate '", this.expression.toString(false), "' expression"}), this.line, this.parserPath);
                        }
                        if (!this.isRepeatWhile && this.isEqualsZero(((Value)value.get((int)0).expr).getIntValue())) {
                            scenario.debugFinishEvaluate(this, currentInstanceScope);
                            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
                        }
                        {
                            block18: {
                                catch (Throwable var6_9) {
                                    throw var6_9;
                                }
                                {
                                    if (nofRepeats < solver.CONFIG_REPEAT_LIMIT) break block18;
                                    ScenarioUtils.logWarning(Utils.append(new Object[]{"Repeat count ", nofRepeats, " exceeds ", solver.CONFIG_REPEAT_LIMIT, ". Limited to ", solver.CONFIG_REPEAT_LIMIT, "."}), this.line, this.parserPath);
                                    scenario.debugFinishEvaluate(this, currentInstanceScope);
                                    return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
                                }
                            }
                            ++nofRepeats;
                            solver.checkInterrupted();
                            try {
                                if (this.bodyExpression != null) {
                                    this.bodyExpression.evaluate(scenario, currentInstanceScope);
                                }
                                ** GOTO lbl-1000
                            }
                            catch (BreakException v0) {
                                scenario.debugFinishEvaluate(this, currentInstanceScope);
                                return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
                            }
                            catch (ContinueException v1) {}
                            ** try [egrp 5[TRYBLOCK] [5 : 251->252)] { 
lbl34:
                            // 1 sources

                            continue;
lbl35:
                            // 1 sources

                            finally {
                                scenario.debugFinishEvaluate(this, currentInstanceScope);
                                continue;
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            if (!this.isRepeatWhile || !this.isEqualsZero(((Value)value.get((int)0).expr).getIntValue())) break block19;
                            scenario.debugFinishEvaluate(this, currentInstanceScope);
                            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
                        }
                    }
                    scenario.debugFinishEvaluate(this, currentInstanceScope);
                }
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                throw new Solver.InterruptException();
            }
            catch (ReturnException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Collections.singletonList(new ExprAndDep<Value>(Value.from(null, -1, false), null, this.toString(true), this.line));
        }

        private boolean isEqualsZero(BigInteger value) {
            return value == null || value.equals(BigInteger.ZERO);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            int key = ScenarioUtils.getKeyOfRf(this.rfStructType);
            out.writeInt(key);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int key = in.readInt();
            this.rfStructType = (RfStruct)ScenarioUtils.getRfOfKey(key);
        }

        @Override
        public void evaluateUnintActionHandles(Solver solver) {
            this.expression.evaluateUnintActionHandles(solver);
        }

        @Override
        public List<ExpressionError> getErrors() {
            return Utils.collectErrors(this.expression, this.bodyExpression);
        }
    }
}

