/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import antlr.collections.AST;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Pool;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.RegionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.TypeInstance;
import ro.amiq.pssdt.model.reflection.elaboration.VariableInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Stack;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public class FieldInstance
extends InstancesContainer {
    private static final long serialVersionUID = 1L;
    protected static final EnumSet<FieldModifier> PORT_FIELD_MODIFIER = EnumSet.of(FieldModifier.INPUT, FieldModifier.OUTPUT, FieldModifier.SHARE, FieldModifier.LOCK);
    private transient RfField rfField;
    protected FieldModifier fieldModifier;
    private InstancesContainer parentInstance;
    private boolean isTraversed;

    public static FieldInstance create(RfField rfField, RfNamedElement rfFieldType, boolean isVariableInstance, int arraySize, int arrayItemIndex, BigInteger runtimeId, Scenario scenario) {
        if (Utils.isRegionInstance(rfFieldType)) {
            return new RegionInstance(rfField, rfFieldType, arraySize, arrayItemIndex, runtimeId, scenario);
        }
        if (isVariableInstance) {
            return new VariableInstance(rfField, rfFieldType, arraySize, arrayItemIndex, runtimeId, scenario);
        }
        if (PORT_FIELD_MODIFIER.contains(rfField.getFieldModifier())) {
            return new PortInstance(rfField, rfFieldType, arraySize, arrayItemIndex, runtimeId, scenario);
        }
        return new FieldInstance(rfField, rfFieldType, arraySize, arrayItemIndex, runtimeId, scenario);
    }

    protected FieldInstance(RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, BigInteger runtimeId, Scenario scenario) {
        super(ScenarioUtils.getDeduplicateName(rfField), arraySize, arrayItemIndex, runtimeId, rfFieldType, rfField.isRef(), scenario);
        this.rfField = rfField;
        this.fieldModifier = rfField.getFieldModifier();
    }

    public boolean isTraversed() {
        return this.isTraversed;
    }

    public void setTraversed(boolean isTraversed) {
        this.isTraversed = isTraversed;
    }

    protected FieldInstance(String name) {
        super(name, -1, -1, Solver.DEFAULT_RUNTIME_ID, null, false, null);
    }

    @Override
    public boolean isInitialStateObject() {
        if (this.parentInstance == null) {
            return false;
        }
        return this.parentInstance.isInitialStateObject();
    }

    @Override
    public InstancePath getInstancePath() {
        return new InstancePath(this.parentInstance.getInstancePath(), this.isArrayItem(), this);
    }

    @Override
    public InstancePath getHierarchicalPath() {
        if (this.isInitialStateObject()) {
            return new InstancePath(this.parentInstance.getHierarchicalPath(), this.isArrayItem(), this);
        }
        if (this.rfField == null) {
            return null;
        }
        if ("comp".equals(this.rfField.getElabName())) {
            return this.getParentComponentInstance().getHierarchicalPath();
        }
        return new InstancePath(this.parentInstance.getHierarchicalPath(), this.isArrayItem(), this);
    }

    protected boolean hasBinds(BigInteger runtimeId) {
        return false;
    }

    protected boolean hasHierarchicalBinds(BigInteger runtimeId, HierarchicalBindKind hierarchicalBindKind) {
        return false;
    }

    protected boolean hasPoolBinds(BigInteger runtimeId) {
        return false;
    }

    public List<PortInstance> getBinds() {
        return null;
    }

    public List<PortInstance> getPoolBinds() {
        return null;
    }

    public List<PortInstance> getHierarchicalBinds(HierarchicalBindKind hierarchicalBindKind) {
        return null;
    }

    public InstancesContainer getParentInstance() {
        return this.parentInstance;
    }

    @Override
    public ActionInstance getParentActionInstance() {
        InstancesContainer parent = this.parentInstance;
        do {
            if (!(parent instanceof ActionInstance)) continue;
            return (ActionInstance)parent;
        } while (parent instanceof FieldInstance && (parent = ((FieldInstance)parent).parentInstance) != null);
        return null;
    }

    @Override
    public RfField getRfField() {
        return this.rfField;
    }

    @Override
    public int nofBits() {
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            RfCollectionType rfCollectionType = (RfCollectionType)this.parentInstance.getRfFieldType();
            return SemanticUtils.nofBits(rfCollectionType.getItemField());
        }
        return SemanticUtils.nofBits(this.rfField);
    }

    @Override
    public boolean hasSign() {
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            RfCollectionType rfCollectionType = (RfCollectionType)this.parentInstance.getRfFieldType();
            return SemanticUtils.hasSign(rfCollectionType.getItemField());
        }
        return SemanticUtils.hasSign(this.rfField);
    }

    @Override
    public IntDomain getIntDomain() {
        IntDomain fullDomain = Utils.getFullIntDomain(this);
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            RfCollectionType rfCollectionType = (RfCollectionType)this.parentInstance.getRfFieldType();
            return SemanticUtils.toIntDomain(rfCollectionType.getItemField(), fullDomain);
        }
        return SemanticUtils.toIntDomain(this.rfField, fullDomain);
    }

    @Override
    protected DataType getDataType() {
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            DataType dataType = this.parentInstance.getDataType();
            if (dataType == null) {
                return null;
            }
            if (this.parentInstance.isSetType()) {
                return dataType.getKeyDataType();
            }
            return dataType.getValueDataType();
        }
        if (this.rfField == null) {
            return null;
        }
        return this.rfField.getDataType();
    }

    @Override
    protected RfNamedElement getAssociatedType() {
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            return ((RfCollectionType)this.parentInstance.getAssociatedType()).getAssociatedType();
        }
        if (this.rfField == null) {
            return null;
        }
        return this.rfField.getAssociatedType();
    }

    public DataType getKeyDataType() {
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            DataType dataType = this.parentInstance.getDataType();
            if (dataType == null) {
                return null;
            }
            return dataType.getKeyDataType();
        }
        return null;
    }

    public boolean requiresBind(BigInteger runtimeId) {
        return false;
    }

    public boolean isState() {
        return Solver.isStateType(this.typeInstance.rfInstanceType);
    }

    public boolean isStream() {
        return Solver.isStreamType(this.typeInstance.rfInstanceType);
    }

    public boolean isResource() {
        return Solver.isResourceType(this.typeInstance.rfInstanceType);
    }

    public boolean isBuffer() {
        return Solver.isBufferType(this.typeInstance.rfInstanceType);
    }

    public void connectTo(PortInstance candidate) {
        throw new UnsupportedOperationException();
    }

    public void scheduleConnectTo(PortInstance candidate) {
        throw new UnsupportedOperationException();
    }

    public void connectToPoolItem(PortInstance poolItem) {
        throw new UnsupportedOperationException();
    }

    protected void addBind(PortInstance candidate) {
        throw new UnsupportedOperationException();
    }

    protected void addPoolBind(PortInstance candidate) {
        throw new UnsupportedOperationException();
    }

    public void connectHierarchicalTo(PortInstance parentActionInstanceFieldCandidate) {
        throw new UnsupportedOperationException();
    }

    public Status canHierarchicallyBindTo(PortInstance compoundActionPortInstance) {
        throw new UnsupportedOperationException();
    }

    public boolean canBindTo(PortInstance candidate, boolean isDisableSchedulingChecks) {
        return false;
    }

    protected boolean canScheduleBefore(PortInstance candidate) {
        throw new UnsupportedOperationException();
    }

    protected boolean canScheduleParallel(PortInstance candidate) {
        throw new UnsupportedOperationException();
    }

    protected boolean canScheduleSequential(PortInstance candidate) {
        throw new UnsupportedOperationException();
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return false;
    }

    public boolean isLock() {
        return false;
    }

    public boolean isShare() {
        return false;
    }

    public boolean isLockOrShare() {
        return false;
    }

    public boolean isPort() {
        return false;
    }

    @Override
    public String toString() {
        if (this.isArrayItem()) {
            return Utils.append(this.parentInstance.toString(), this.getName());
        }
        return Utils.append(this.parentInstance.toString(), ".", this.getName());
    }

    @Override
    public ComponentInstance getParentComponentInstance() {
        if (this.parentInstance instanceof ComponentInstance) {
            return (ComponentInstance)this.parentInstance;
        }
        if (this.parentInstance instanceof ActionInstance) {
            return ((ActionInstance)this.parentInstance).parentComponentInstance;
        }
        if (this.parentInstance instanceof Pool) {
            return ((Pool)this.parentInstance).getParentComponentInstance();
        }
        if (this.parentInstance instanceof FieldInstance) {
            return ((FieldInstance)this.parentInstance).getParentComponentInstance();
        }
        return null;
    }

    public Set<Pool> getPoolCandidates() {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int key = ScenarioUtils.getKeyOfRf(this.rfField);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int key = in.readInt();
        this.rfField = (RfField)ScenarioUtils.getRfOfKey(key);
    }

    public void setParentInstance(InstancesContainer parentInstance) {
        this.parentInstance = parentInstance;
    }

    @Override
    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
        super.createSubInstances(backPointersMap, isVariableInstance);
        this.typeInstance.createSubInstances(backPointersMap, isVariableInstance, this.isOutput(), this.runtimeId);
    }

    public boolean isActionHandle() {
        return this.typeInstance != null && this.typeInstance.isActionHandle();
    }

    public boolean isActionHandleArray() {
        return this.typeInstance != null && this.typeInstance.isActionHandleArray();
    }

    @Override
    public void setVariableValue(Expression.Value value) {
        if (value == null || Expression.Value.isNull(value)) {
            super.setVariableValue(null);
        } else if (Expression.Value.isReference(value) || Expression.Value.isHandle(value)) {
            super.setVariableValue(value);
        } else {
            boolean isString = this.isStringType();
            value = isString && !Expression.Value.isString(value) ? Expression.Value.from(value.toString(), -1, false) : Expression.Value.from(value, this.nofBits(), this.hasSign());
            super.setVariableValue(value);
        }
    }

    @Override
    public IntVariable getVariable(Model model, String overrideVarName, InstancePath varHierarchicalPath, Map<String, InstancesContainer.GeneratedVar> variableSolverMap, boolean printConnectMessage) {
        if (varHierarchicalPath == null) {
            return null;
        }
        if (this.isRefTypeInstance()) {
            InstancesContainer refValue = this.variableValue.getRefValue();
            FieldInstance fieldInstance = refValue.getFieldInstance("[unique_id]");
            return fieldInstance.getVariable(model, overrideVarName, fieldInstance.getHierarchicalPath(), variableSolverMap, printConnectMessage);
        }
        if (this.isCollectionSize()) {
            int initValue = Math.max(0, this.parentInstance.arraySize);
            String varName = varHierarchicalPath.toString();
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", initValue));
            InstancesContainer.GeneratedVar result = new InstancesContainer.GeneratedVar(this, model.intVar(varName, true, 32, BigInteger.valueOf(initValue)), textVarValue);
            this.registerVariables(variableSolverMap, result, false, varName, overrideVarName, textVarValue);
            return result.getIntVariable();
        }
        if (this.isCollectionSum()) {
            if (this.parentInstance.isListType() || this.parentInstance.arraySize <= 0) {
                return model.intVar(this.getHierarchicalPath().toString(), true, Integer.MAX_VALUE, BigInteger.ZERO);
            }
            ArrayList<IntVariable> cspVariables = new ArrayList<IntVariable>(this.parentInstance.arraySize);
            Map<String, FieldInstance> fieldInstances = this.parentInstance.getFieldInstances();
            for (FieldInstance fieldInstance : fieldInstances.values()) {
                IntVariable cspVariable;
                if (!fieldInstance.isArrayItem() || !fieldInstance.name.equals(this.parentInstance.getName()) || (cspVariable = fieldInstance.getVariable(model, overrideVarName, fieldInstance.getHierarchicalPath(), variableSolverMap, true)) == null) continue;
                cspVariables.add(cspVariable);
            }
            IntVariable sumExpr = model.getCachedConstant(true, 1, BigInteger.ZERO);
            int i = 0;
            while (i < cspVariables.size()) {
                sumExpr = sumExpr.add((IntVariable)cspVariables.get(i));
                ++i;
            }
            IntVariable sumExprVar = super.getVariable(model, overrideVarName, varHierarchicalPath, variableSolverMap, true);
            sumExprVar.eq(sumExpr).post();
            return sumExprVar;
        }
        if (this.parentInstance instanceof FieldInstance && ((FieldInstance)this.parentInstance).isState() && "initial".equals(this.getName())) {
            boolean initValue = ((FieldInstance)this.parentInstance).isInitialStateObjectBind();
            String varName = varHierarchicalPath.toString();
            InstancesContainer.GeneratedVar result = variableSolverMap.get(varName);
            if (result != null) {
                return result.getIntVariable();
            }
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", initValue));
            result = new InstancesContainer.GeneratedVar(this, model.boolVar(varName, initValue ? BigInteger.ONE : BigInteger.ZERO), textVarValue);
            this.registerVariables(variableSolverMap, result, false, varName, overrideVarName, textVarValue);
            return result.getIntVariable();
        }
        if (this.parentInstance instanceof FieldInstance && ((FieldInstance)this.parentInstance).isResource() && "instance_id".equals(this.getName())) {
            PoolItem poolItem = ((FieldInstance)this.parentInstance).getResourcePoolItemBind();
            if (poolItem == null) {
                return null;
            }
            String varName = varHierarchicalPath.toString();
            InstancesContainer.GeneratedVar result = variableSolverMap.get(varName);
            if (result != null) {
                return result.getIntVariable();
            }
            int value = poolItem.arrayItemIndex;
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", value));
            result = new InstancesContainer.GeneratedVar(this, model.intVar(varName, true, 32, BigInteger.valueOf(value)), textVarValue);
            this.registerVariables(variableSolverMap, result, false, varName, overrideVarName, textVarValue);
            return result.getIntVariable();
        }
        return super.getVariable(model, overrideVarName, varHierarchicalPath, variableSolverMap, true);
    }

    @Override
    public Expression.Value getVariableDebuggerValue() {
        if (this.parentInstance != null && this.parentInstance.isVectorType() && "size".equals(this.getName())) {
            return Expression.Value.from(BigInteger.valueOf(Math.max(0, this.parentInstance.arraySize)), 32, true);
        }
        if (this.parentInstance instanceof FieldInstance && this.parentInstance.isVectorType() && "sum".equals(this.getName())) {
            boolean isIntegerType = this.isIntegerType();
            if (!isIntegerType) {
                return null;
            }
            BigInteger sumResult = BigInteger.ZERO;
            for (FieldInstance fieldInstance : this.parentInstance.getFieldInstances().values()) {
                if (!fieldInstance.isArrayItem()) continue;
                Expression.Value value = fieldInstance.getVariableDebuggerValue();
                if (value == null || !Expression.Value.isInteger(value)) {
                    return null;
                }
                sumResult = sumResult.add(value.getIntValue());
            }
            return Expression.Value.from(sumResult, Math.max(32, sumResult.bitLength()), true);
        }
        return super.getVariableDebuggerValue();
    }

    @Override
    public boolean isUniqueIdField() {
        return !this.isArrayItem() && "[unique_id]".equals(this.name);
    }

    public boolean isCollectionSize() {
        return this.parentInstance instanceof FieldInstance && this.parentInstance.isCollectionType() && "size".equals(this.getName());
    }

    public boolean isCollectionSum() {
        return this.parentInstance instanceof FieldInstance && this.parentInstance.isVectorType() && "sum".equals(this.getName());
    }

    protected boolean isLocalFieldRand() {
        Scenario scenario = ScenarioUtils.getScenario();
        return scenario.isProceduralRand(this) || Utils.isRand(this.rfField);
    }

    @Override
    public boolean isRand() {
        InstancesContainer instanceParent = this;
        while (instanceParent instanceof FieldInstance) {
            if (!instanceParent.isLocalFieldRand()) {
                return false;
            }
            instanceParent = instanceParent.parentInstance;
        }
        return true;
    }

    @Override
    public FieldInstance getFieldInstance(InstancesContainer instance) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        FieldInstance fieldInstance = this.isArrayItem() && instance.isArrayItem() ? typeInstance.getFieldInstance(instance.arrayItemIndex) : typeInstance.getFieldInstance(instance);
        return fieldInstance;
    }

    protected PoolItem getResourcePoolItemBind() {
        return null;
    }

    protected boolean isInitialStateObjectBind() {
        return false;
    }

    public PortInstance getStateOutputPortBefore() {
        return null;
    }

    public List<PortInstance> getStateOutputPortBeforeCandidates() {
        return Collections.emptyList();
    }

    public List<PortInstance> getStateParallelInputPorts() {
        return Collections.emptyList();
    }

    public boolean isInferred() {
        ActionInstance parentActionInstance = this.getParentActionInstance();
        return parentActionInstance != null && parentActionInstance.isInferred();
    }

    public boolean isBefore(PortInstance connectedFieldInstance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression.Value getVariableValue() {
        boolean isArraySum;
        boolean isArraySize;
        boolean bl = isArraySize = this.parentInstance != null && this.parentInstance.isVectorType() && "size".equals(this.getName());
        if (isArraySize) {
            int initValue = Math.max(0, this.parentInstance.arraySize);
            return Expression.Value.from(BigInteger.valueOf(initValue), 32, true);
        }
        boolean bl2 = isArraySum = this.parentInstance != null && this.parentInstance.isVectorType() && "sum".equals(this.getName());
        if (isArraySum) {
            BigInteger sumResult = BigInteger.ZERO;
            Map<String, FieldInstance> fieldInstances = this.parentInstance.getFieldInstances();
            for (FieldInstance fieldInstance : fieldInstances.values()) {
                if (!fieldInstance.isArrayItem() || !fieldInstance.name.equals(this.parentInstance.getName())) continue;
                sumResult = sumResult.add(fieldInstance.getIntegerVariableValue());
            }
            return Expression.Value.from(sumResult, Math.max(32, sumResult.bitLength()), true);
        }
        boolean isSizeofMember = Utils.isSizeofMember(this.rfField);
        if (isSizeofMember) {
            RfTemplateInstance rfTemplateInstance = (RfTemplateInstance)this.rfField.getEnclosingScope();
            RfNamedElement rfTemplateInstanceParam = rfTemplateInstance.getInstanceParameters().get(0);
            int sizeof = rfTemplateInstanceParam.sizeof();
            BigInteger intValue = BigInteger.valueOf("nbytes".equals(ScenarioUtils.getDeduplicateName(this.rfField)) ? Utils.nofBytes(sizeof) : sizeof);
            return Expression.Value.from(intValue, this.nofBits(), this.hasSign());
        }
        if (this.parentInstance instanceof FieldInstance && ((FieldInstance)this.parentInstance).isResource() && "instance_id".equals(this.getName())) {
            PoolItem poolItem = ((FieldInstance)this.parentInstance).getResourcePoolItemBind();
            if (poolItem == null) {
                return super.getVariableValue();
            }
            return Expression.Value.from(BigInteger.valueOf(poolItem.arrayItemIndex), 32, true);
        }
        if (this.parentInstance instanceof FieldInstance && ((FieldInstance)this.parentInstance).isState() && "initial".equals(this.getName())) {
            boolean initValue = ((FieldInstance)this.parentInstance).isInitialStateObjectBind();
            return Expression.Value.from(initValue ? BigInteger.ONE : BigInteger.ZERO, 1, false);
        }
        return super.getVariableValue();
    }

    @Override
    public void preSolve() {
        ExecBlockKind currentSolveState = this.getCurrentSolveState();
        if (currentSolveState != ExecBlockKind.NONE) {
            return;
        }
        ActionInstance parentActionInstance = this.getParentActionInstance();
        if (parentActionInstance == null || parentActionInstance.isCompoundAction()) {
            this.setCurrentSolveState(ExecBlockKind.SOLVE);
        } else {
            this.setCurrentSolveState(ExecBlockKind.PRE_SOLVE);
        }
        this.applyExecDescriptors(null, null, ExecBlockKind.PRE_SOLVE, this.getRfFieldType());
        this.preSolveFields();
    }

    @Override
    public void postSolve() {
        ExecBlockKind currentSolveState = this.getCurrentSolveState();
        if (currentSolveState == ExecBlockKind.NONE) {
            throw new UnsupportedOperationException(Utils.append(new Object[]{"Fail to execute POST_SOLVE on object in ", currentSolveState, " state"}));
        }
        if (currentSolveState != ExecBlockKind.PRE_SOLVE && currentSolveState != ExecBlockKind.SOLVE && currentSolveState != ExecBlockKind.SOLVE_COMPOUND) {
            return;
        }
        this.setCurrentSolveState(ExecBlockKind.POST_SOLVE);
        this.applyExecDescriptors(null, null, ExecBlockKind.POST_SOLVE, this.getRfFieldType());
        this.postSolveFields();
    }

    protected boolean hasPoolConnectedOutput() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecBlockKind solvedState() {
        InstancesContainer parent = this;
        do {
            if (parent instanceof ActionInstance) {
                return ((InstancesContainer)parent).solvedState();
            }
            ExecBlockKind currentSolveState = parent.getCurrentSolveState();
            if (currentSolveState != ExecBlockKind.POST_SOLVE) continue;
            return currentSolveState;
        } while (parent instanceof FieldInstance && (parent = parent.parentInstance) != null);
        return ExecBlockKind.NONE;
    }

    public String getInspectInfo(String fieldName) {
        return this.getInspectInfo(Collections.newSetFromMap(new IdentityHashMap()), fieldName, new Stack<String>());
    }

    private final String getInspectInfo(Set<String> visited, String fieldName, Stack<String> prefixStack) {
        if (visited.contains(fieldName)) {
            return "";
        }
        visited.add(fieldName);
        if ("[unique_id]".equals(fieldName)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            this.prefix(result, prefixStack);
            result.append(fieldName).append(" = ").append(this.toStringVariableValue()).append("\n").toString();
            return result.toString();
        }
        prefixStack.push(fieldName);
        if (this.isVectorType()) {
            StringBuilder arrayText = new StringBuilder();
            for (FieldInstance fieldInstance : fieldInstances.values()) {
                String inspectInfo;
                if (fieldInstance.isArrayItem()) {
                    prefixStack.pop();
                    if (fieldInstance.isStructType()) {
                        inspectInfo = fieldInstance.getInspectInfo(visited, fieldInstance.getName(), prefixStack);
                        result.append(inspectInfo);
                    } else {
                        String value = fieldInstance.toStringVariableValue();
                        if (arrayText.length() == 0) {
                            arrayText.append(value);
                        } else {
                            arrayText.append(", ").append(value);
                        }
                    }
                    prefixStack.push(fieldName);
                    continue;
                }
                inspectInfo = fieldInstance.getInspectInfo(visited, fieldInstance.getName(), prefixStack);
                result.append(inspectInfo);
            }
            if (arrayText.length() > 0) {
                prefixStack.pop();
                this.prefix(result, prefixStack);
                result.append(fieldName).append(" = { ").append((CharSequence)arrayText).append(" }\n");
                prefixStack.push(fieldName);
            }
        } else {
            for (FieldInstance fieldInstance : fieldInstances.values()) {
                if (this.isInput() && this.isState() && "prev".equals(fieldInstance.getName()) || fieldInstance instanceof PortInstance.StatePrevPortInstance) continue;
                String inspectInfo = fieldInstance.getInspectInfo(visited, fieldInstance.getName(), prefixStack);
                result.append(inspectInfo);
            }
        }
        prefixStack.pop();
        return result.toString();
    }

    private final void prefix(StringBuilder inspectInfo, Stack<String> prefixStack) {
        if (prefixStack == null || prefixStack.isEmpty()) {
            return;
        }
        Iterator iterator = prefixStack.iterator();
        while (iterator.hasNext()) {
            inspectInfo.append((String)iterator.next()).append(".");
        }
    }

    public PortInstance getPairPort() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initVariableValue() {
        this.variableValue = null;
        if (this.isCollectionType() || this.isStructType(StructKind.STRUCT)) {
            RfNamedElement rfFieldType = this.getRfFieldType();
            FieldInstance initFieldInstance = FieldInstance.create(this.rfField, rfFieldType, true, -1, -1, this.runtimeId, this.scenario);
            initFieldInstance.createSubInstances(new IdentityHashMap<RfNamedElement, InstancesContainer>(), false);
            RfDefElement declaration = this.rfField.getDeclaration();
            if (declaration == null) {
                return;
            }
            int line = declaration.getStartLine();
            ParserPath parserPath = declaration.getParserPath();
            DataType dataType = this.getDataType();
            if (dataType == null) {
                return;
            }
            AST initValueAST = dataType.getInitialValueAST();
            if (initValueAST == null) {
                return;
            }
            Expression.Value value = Utils.getInitialValue(this.scenario, this);
            if (!Expression.Value.isReference(value)) throw new Solver.EvaluationException("Internal error INT_1", line, parserPath);
            this.deepCopy(Utils.unwrapReferenceInstance(value.getRefValue()), line, parserPath);
            return;
        } else {
            if (this.arraySize >= 0 || this.arrayItemIndex >= 0) return;
            this.getVariableValue(true);
        }
    }

    public final FieldInstance insertListItem(int index, Expression.Value value, int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.ARRAY && typeInstance.typeCategory != TypeInstance.TypeKind.LIST && typeInstance.typeCategory != TypeInstance.TypeKind.SET) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index > Math.max(0, this.arraySize)) {
            return null;
        }
        this.arraySize = Math.max(0, this.arraySize) + 1;
        if (index == this.arraySize - 1) {
            return this.createItem(null, index, value, true, line, parserPath);
        }
        FieldInstance result = null;
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        ArrayList<FieldInstance> fieldInstancesCopy = new ArrayList<FieldInstance>(fieldInstances.values());
        for (FieldInstance fieldInstance : fieldInstancesCopy) {
            if (!fieldInstance.isArrayItem() || fieldInstance.arrayItemIndex < index) continue;
            if (fieldInstance.arrayItemIndex == index) {
                result = this.createItem(null, index, value, true, line, parserPath);
            }
            fieldInstance.arrayItemIndex = fieldInstance.arrayItemIndex + 1;
            this.addReferenceChildFieldInstance(fieldInstance.getName(), fieldInstance, true);
        }
        return result;
    }

    private final FieldInstance createItem(String nameOverride, int index, Expression.Value value, boolean isAllowDuplicate, int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        RfNamedElement rfItemInstanceType = Utils.getArrayItemType((RfCollectionType)typeInstance.rfInstanceType);
        if (Expression.Value.isReference(value)) {
            if (Expression.Value.isValueCopyAssignment(value)) {
                FieldInstance result = this.createFieldInstance(new IdentityHashMap<RfNamedElement, InstancesContainer>(), nameOverride, this.rfField, rfItemInstanceType, -1, index, this instanceof VariableInstance, isAllowDuplicate);
                result.deepCopy(value.getRefValue(), line, parserPath);
                return result;
            }
            FieldInstance result = this.createRefFieldInstance(nameOverride, this.rfField, rfItemInstanceType, -1, index, this instanceof VariableInstance);
            result.setVariableValue(value);
            return result;
        }
        FieldInstance result = this.createFieldInstance(new IdentityHashMap<RfNamedElement, InstancesContainer>(), nameOverride, this.rfField, rfItemInstanceType, -1, index, this instanceof VariableInstance, isAllowDuplicate);
        result.setVariableValue(value);
        return result;
    }

    public FieldInstance addListItem(Expression.Value value, int line, ParserPath parserPath) {
        return this.insertListItem(Math.max(0, this.arraySize), value, line, parserPath);
    }

    public final FieldInstance getListItem(int index, int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.LIST && typeInstance.typeCategory != TypeInstance.TypeKind.ARRAY) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.arraySize) {
            throw new Solver.EvaluationException(Utils.append("Index ", index, " is out of bounds (", typeInstance.typeCategory.toString().toLowerCase(), " size is ", Math.max(0, this.arraySize), ")"), line, parserPath);
        }
        return this.getFieldInstance(Utils.append("[", index, "]"));
    }

    public final void clearItems() {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.LIST && typeInstance.typeCategory != TypeInstance.TypeKind.ARRAY && typeInstance.typeCategory != TypeInstance.TypeKind.MAP && typeInstance.typeCategory != TypeInstance.TypeKind.SET) {
            throw new UnsupportedOperationException();
        }
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return;
        }
        this.arraySize = -1;
        Iterator<FieldInstance> iterator = fieldInstances.values().iterator();
        while (iterator.hasNext()) {
            FieldInstance fieldInstance = iterator.next();
            if (!fieldInstance.isArrayItem()) continue;
            iterator.remove();
        }
    }

    public final FieldInstance removeListItem(int index, int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.LIST && typeInstance.typeCategory != TypeInstance.TypeKind.ARRAY && typeInstance.typeCategory != TypeInstance.TypeKind.MAP && typeInstance.typeCategory != TypeInstance.TypeKind.SET) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.arraySize) {
            throw new Solver.EvaluationException(Utils.append("Index ", index, " is out of bounds (", typeInstance.typeCategory.toString().toLowerCase(), " size is ", Math.max(0, this.arraySize), ")"), line, parserPath);
        }
        this.arraySize = Math.max(0, this.arraySize) - 1;
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        FieldInstance result = fieldInstances.remove(Utils.append("[", index, "]"));
        if (index == this.arraySize) {
            return result;
        }
        ArrayList<FieldInstance> fieldInstancesCopy = new ArrayList<FieldInstance>(fieldInstances.values());
        for (FieldInstance fieldInstance : fieldInstancesCopy) {
            if (!fieldInstance.isArrayItem() || fieldInstance.arrayItemIndex < index) continue;
            fieldInstances.remove(fieldInstance.getName());
            fieldInstance.arrayItemIndex = fieldInstance.arrayItemIndex - 1;
            this.addReferenceChildFieldInstance(fieldInstance.getName(), fieldInstance, false);
        }
        return result;
    }

    public final FieldInstance listToSet(int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.LIST) {
            throw new UnsupportedOperationException();
        }
        RfNamedElement rfFieldType = Utils.getArrayItemType((RfCollectionType)typeInstance.rfInstanceType);
        rfFieldType = RfCollectionType.createSet(this.scenario.getSolver().getRfProject(), rfFieldType, new DataType(ScenarioUtils.getDeduplicateName(rfFieldType)));
        FieldInstance fieldInstance = FieldInstance.create(this.rfField, rfFieldType, true, -1, -1, this.runtimeId, this.scenario);
        fieldInstance.arraySize = 0;
        for (FieldInstance itemFieldInstance : this.getFieldInstances().values()) {
            if (!itemFieldInstance.isArrayItem()) continue;
            fieldInstance.insertMapItem(itemFieldInstance, Expression.Value.from(itemFieldInstance, -1, false), line, parserPath);
        }
        return fieldInstance;
    }

    public final FieldInstance setToList(int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.SET) {
            throw new UnsupportedOperationException();
        }
        RfNamedElement rfFieldType = Utils.getArrayItemType((RfCollectionType)typeInstance.rfInstanceType);
        rfFieldType = RfCollectionType.createSet(this.scenario.getSolver().getRfProject(), rfFieldType, new DataType(ScenarioUtils.getDeduplicateName(rfFieldType)));
        FieldInstance fieldInstance = FieldInstance.create(this.rfField, rfFieldType, true, -1, -1, this.runtimeId, this.scenario);
        fieldInstance.arraySize = 0;
        for (FieldInstance itemFieldInstance : this.getFieldInstances().values()) {
            if (!itemFieldInstance.isArrayItem()) continue;
            fieldInstance.insertListItem(fieldInstance.arraySize, Expression.Value.from(itemFieldInstance, -1, false), line, parserPath);
        }
        return fieldInstance;
    }

    public final int getCollectionSize() {
        return Math.max(0, this.arraySize);
    }

    public final FieldInstance getMapItem(Object key) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (key == null || typeInstance.typeCategory != TypeInstance.TypeKind.MAP && typeInstance.typeCategory != TypeInstance.TypeKind.SET) {
            throw new UnsupportedOperationException();
        }
        return this.getFieldInstance(key.toString());
    }

    public final FieldInstance insertMapItem(Object key, Expression.Value value, int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (key == null || typeInstance.typeCategory != TypeInstance.TypeKind.MAP && typeInstance.typeCategory != TypeInstance.TypeKind.SET) {
            throw new UnsupportedOperationException();
        }
        FieldInstance result = this.getFieldInstance(key.toString());
        if (result != null) {
            result.setVariableValue(value);
            return result;
        }
        this.arraySize = Math.max(0, this.arraySize) + 1;
        result = this.createItem(key.toString(), this.arraySize - 1, value, true, line, parserPath);
        return result;
    }

    public final FieldInstance removeMapItem(Object key) {
        if (this.arraySize <= 0) {
            return null;
        }
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        FieldInstance result = fieldInstances.remove(key.toString());
        if (result == null) {
            return null;
        }
        this.arraySize = Math.max(0, this.arraySize) - 1;
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if (!fieldInstance.isArrayItem() || fieldInstance.arrayItemIndex < result.arrayItemIndex) continue;
            fieldInstance.arrayItemIndex = fieldInstance.arrayItemIndex - 1;
        }
        return result;
    }

    public final FieldInstance getMapKeys(int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.MAP) {
            throw new UnsupportedOperationException();
        }
        RfNamedElement rfFieldType = Utils.getKeyItemType((RfCollectionType)typeInstance.rfInstanceType);
        rfFieldType = RfCollectionType.createSet(this.scenario.getSolver().getRfProject(), rfFieldType, new DataType(ScenarioUtils.getDeduplicateName(rfFieldType)));
        FieldInstance fieldInstance = FieldInstance.create(this.rfField, rfFieldType, true, -1, -1, this.runtimeId, this.scenario);
        fieldInstance.arraySize = 0;
        for (Map.Entry<String, FieldInstance> itemFieldEntry : this.getFieldInstances().entrySet()) {
            if (!itemFieldEntry.getValue().isArrayItem()) continue;
            fieldInstance.insertMapItem(itemFieldEntry.getKey(), Expression.Value.from(itemFieldEntry.getKey(), -1, false), line, parserPath);
        }
        return fieldInstance;
    }

    public final FieldInstance getMapValues(int line, ParserPath parserPath) {
        TypeInstance typeInstance = this.unwrapRefTypeInstance();
        if (typeInstance.typeCategory != TypeInstance.TypeKind.MAP) {
            throw new UnsupportedOperationException();
        }
        RfNamedElement rfFieldType = Utils.getArrayItemType((RfCollectionType)typeInstance.rfInstanceType);
        rfFieldType = RfCollectionType.createList(this.scenario.getSolver().getRfProject(), rfFieldType, new DataType(ScenarioUtils.getDeduplicateName(rfFieldType)));
        FieldInstance fieldInstance = FieldInstance.create(this.rfField, rfFieldType, true, -1, -1, this.runtimeId, this.scenario);
        fieldInstance.arraySize = 0;
        for (Map.Entry<String, FieldInstance> itemFieldEntry : this.getFieldInstances().entrySet()) {
            if (!itemFieldEntry.getValue().isArrayItem()) continue;
            fieldInstance.insertListItem(fieldInstance.arraySize, Expression.Value.from(itemFieldEntry.getValue(), -1, false), line, parserPath);
        }
        return fieldInstance;
    }

    public boolean isMapItem() {
        return this.isArrayItem() && this.parentInstance.typeInstance.typeCategory == TypeInstance.TypeKind.MAP;
    }

    public boolean isSetItem() {
        return this.isArrayItem() && this.parentInstance.typeInstance.typeCategory == TypeInstance.TypeKind.SET;
    }

    @Override
    protected Collection<? extends InstancesContainer> getMembers() {
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null) {
            return Collections.emptyList();
        }
        return fieldInstances.values();
    }

    @Override
    protected boolean isValueCopyAssignment() {
        return true;
    }

    public final void shuffleCollection(Solver solver) {
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return;
        }
        ArrayList<Expression.Value> itemValues = new ArrayList<Expression.Value>(fieldInstances.size());
        for (Map.Entry<String, FieldInstance> itemFieldEntry : fieldInstances.entrySet()) {
            FieldInstance itemField = itemFieldEntry.getValue();
            if (!itemField.isArrayItem()) continue;
            itemValues.add(itemField.getVariableValue());
        }
        Random random = solver.getListShuffleRandom(this.seed);
        Collections.shuffle(itemValues, random);
        Iterator itemValuesIterator = itemValues.iterator();
        for (Map.Entry<String, FieldInstance> itemFieldEntry : fieldInstances.entrySet()) {
            FieldInstance itemField = itemFieldEntry.getValue();
            if (!itemField.isArrayItem()) continue;
            itemField.setVariableValue((Expression.Value)itemValuesIterator.next());
        }
    }

    public static enum HierarchicalBindKind {
        UP,
        DOWN,
        BOTH;

    }

    public static class Status {
        private boolean isOK;
        private String failReason;

        public static Status OK() {
            return new Status(true, null);
        }

        public static Status FAIL(String message) {
            return new Status(false, message);
        }

        public Status(boolean isOK, String failReason) {
            this.isOK = isOK;
            this.failReason = failReason;
        }

        public String getFailReason() {
            return this.failReason;
        }

        public boolean isOK() {
            return this.isOK;
        }
    }
}

