/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.CompoundVariable;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.StrVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.ExecBlockKind;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ConstraintDescriptor;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.LabeledElement;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.RegionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.TypeInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public abstract class InstancesContainer
extends LabeledElement
implements ListContainer<InstancesContainer> {
    private static final long serialVersionUID = 1L;
    protected TypeInstance typeInstance;
    protected Scenario scenario;
    protected Expression.Value variableValue;
    protected Long seed;

    protected InstancesContainer(String name, int arraySize, int arrayItemIndex, BigInteger runtimeId, RfNamedElement rfFieldType, boolean isRef, Scenario scenario) {
        super(name, arraySize, arrayItemIndex, runtimeId);
        this.typeInstance = this.createTypeInstance(rfFieldType, isRef, scenario);
        this.scenario = scenario;
    }

    public final TypeInstance createTypeInstance(RfNamedElement rfFieldType, boolean isRef, Scenario scenario) {
        if (rfFieldType == null) {
            return null;
        }
        if (scenario == null) {
            return null;
        }
        return scenario.createTypeInstance(this, isRef, rfFieldType);
    }

    public int nofBits() {
        return -1;
    }

    public boolean hasSign() {
        return false;
    }

    public IntDomain getIntDomain() {
        return null;
    }

    public boolean isRefTypeInstance() {
        return this.typeInstance instanceof TypeInstance.RefTypeInstance;
    }

    public void addChildFieldInstance(String instanceName, FieldInstance fieldInstance, boolean isAllowDuplicate) {
        this.typeInstance.addChildFieldInstance(instanceName, fieldInstance, isAllowDuplicate);
    }

    public void addReferenceChildFieldInstance(String referenceName, FieldInstance fieldInstance, boolean isAllowDuplicate) {
        this.typeInstance.addReferenceChildFieldInstance(referenceName, fieldInstance, isAllowDuplicate);
    }

    public void setFieldInstances(Map<String, FieldInstance> fieldInstances) {
        this.typeInstance.setFieldInstances(fieldInstances);
    }

    public Map<String, FieldInstance> getFieldInstances() {
        return this.typeInstance == null ? Collections.emptyMap() : this.typeInstance.fieldInstances;
    }

    public Collection<? extends InstancesContainer> debuggerGetMembers() {
        if (this.typeInstance == null) {
            return Collections.emptyList();
        }
        if (this.typeInstance.fieldInstances == null) {
            return Collections.emptyList();
        }
        return this.typeInstance.fieldInstances.values();
    }

    public void clean() {
        this.typeInstance.clean();
    }

    public ComponentInstance getRootComponent() {
        return this.scenario == null ? null : this.scenario.rootComponent;
    }

    public Expression.Value getRepeatIndexValue(RfField.RfIndexField rfField) {
        throw new UnsupportedOperationException();
    }

    public Expression.Value getRepeatIteratorValue(RfField.RfIteratorField rfField) {
        throw new UnsupportedOperationException();
    }

    protected void hierarchicalSeeding(InstancesContainer candidate, int index) {
        if (candidate.seed != null) {
            return;
        }
        if (this.seed == null) {
            throw new UnsupportedOperationException();
        }
        candidate.seed = this.seed + (long)index;
        Map<String, FieldInstance> fieldInstances = candidate.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return;
        }
        int subindex = 0;
        for (InstancesContainer instancesContainer : fieldInstances.values()) {
            candidate.hierarchicalSeeding(instancesContainer, ++subindex);
        }
    }

    public abstract ActionInstance getParentActionInstance();

    public abstract ComponentInstance getParentComponentInstance();

    public abstract InstancePath getInstancePath();

    public abstract InstancePath getHierarchicalPath();

    public abstract RfField getRfField();

    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
        this.createUniqueId();
    }

    protected void internalCheckObsoleteScenario(InstancesContainer candidate) {
        if (this.scenario != null && candidate.scenario != null && this.scenario != candidate.scenario) {
            ScenarioUtils.logError("Internal fatal error OBS_1", -1, null);
            throw new Solver.InterruptException();
        }
    }

    public FieldInstance createRefFieldInstance(String nameOverride, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance) {
        return this.unwrapRefTypeInstance().createRefFieldInstance(nameOverride, rfField, rfFieldType, arraySize, arrayItemIndex, isVariableInstance, this.runtimeId);
    }

    public FieldInstance createFieldInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, String instanceName, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance) {
        return this.unwrapRefTypeInstance().createFieldInstance(backPointersMap, instanceName, rfField, rfFieldType, arraySize, arrayItemIndex, isVariableInstance, false, this.runtimeId);
    }

    public FieldInstance createFieldInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, String instanceName, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance, boolean isAllowDuplicate) {
        return this.unwrapRefTypeInstance().createFieldInstance(backPointersMap, instanceName, rfField, rfFieldType, arraySize, arrayItemIndex, isVariableInstance, isAllowDuplicate, this.runtimeId);
    }

    public FieldInstance getFieldInstance(InstancesContainer instance) {
        return this.unwrapRefTypeInstance().getFieldInstance(instance);
    }

    public FieldInstance getFieldInstance(String instanceName) {
        return this.unwrapRefTypeInstance().getFieldInstance(instanceName);
    }

    public FieldInstance getFieldInstance(int arrayItemIndex) {
        return this.unwrapRefTypeInstance().getFieldInstance(arrayItemIndex);
    }

    public String toStringVariableValue() {
        if (this.isCollectionType() || this.isStructType()) {
            return this.toStringArrayVariableValue();
        }
        if (this.isRefTypeInstance()) {
            return this.variableValue.getRefValue().toStringVariableValue();
        }
        if (this.isStringType()) {
            return this.getStringVariableValue();
        }
        if (this.isHandleType()) {
            return this.variableValue == null ? "0" : this.variableValue.getStringValue();
        }
        if (this.isUniqueIdField()) {
            return this.getHierarchicalPath().toString();
        }
        BigInteger value = this.getIntegerVariableValue();
        if (this.typeInstance != null && this.typeInstance.isBooleanType()) {
            return value.equals(BigInteger.ZERO) ? "false" : "true";
        }
        if (this.typeInstance != null && this.typeInstance.isEnumType()) {
            RfEnumItem rfEnumItem = ((RfEnumType)this.typeInstance.rfInstanceType).getEnumItem(value.intValueExact(), null);
            return rfEnumItem.getElabName();
        }
        return Utils.formatNumber(ScenarioUtils.getSolver().radix(), value, this.nofBits(), 4);
    }

    public String toStringArrayVariableValue() {
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null) {
            return "{ }";
        }
        StringBuilder result = new StringBuilder("{ ");
        boolean isFirst = true;
        boolean isArrayType = this.isCollectionType();
        boolean isStructType = this.isStructType();
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if (isArrayType && !fieldInstance.isArrayItem() || fieldInstance.isUniqueIdField()) continue;
            if (!isFirst) {
                result.append(", ");
            }
            isFirst = false;
            if (isStructType) {
                result.append(".").append(fieldInstance.getName()).append(" = ");
            }
            result.append(fieldInstance.toStringVariableValue());
        }
        return result.append(" }").toString();
    }

    protected TypeInstance unwrapRefTypeInstance() {
        if (this.isRefTypeInstance()) {
            if (this.variableValue == null || !Expression.Value.isReference(this.variableValue)) {
                throw new Solver.NullRefException(Utils.append("'", this.getHierarchicalPath(), "' is null"));
            }
            return this.variableValue.getRefValue().unwrapRefTypeInstance();
        }
        return this.typeInstance;
    }

    public final BigInteger getIntegerVariableValue() {
        Expression.Value value = this.getVariableValue();
        if (Expression.Value.isInteger(value)) {
            return value.getIntValue();
        }
        if (this.isArrayItem()) {
            return BigInteger.ZERO;
        }
        boolean isRand = this.isRand();
        value = Utils.getInitialValue(this.scenario, this);
        if (value == null || !Expression.Value.isInteger(value)) {
            if (!isRand) {
                this.setVariableValue(Expression.Value.from(BigInteger.ZERO, this.nofBits(), this.hasSign()));
            }
            return BigInteger.ZERO;
        }
        if (!isRand) {
            this.setVariableValue(value);
        }
        return value.getIntValue();
    }

    public String getStringVariableValue() {
        Expression.Value value = this.getVariableValue();
        if (Expression.Value.isString(value) || Expression.Value.isNull(value)) {
            return value.getStringValue();
        }
        if (this.isArrayItem()) {
            return null;
        }
        boolean isRand = this.isRand();
        value = Utils.getInitialValue(this.scenario, this);
        if (value == null || !Expression.Value.isString(value)) {
            if (!isRand) {
                this.setVariableValue(Expression.Value.from(null, -1, false));
            }
            return null;
        }
        if (!isRand) {
            this.setVariableValue(value);
        }
        return value.getStringValue();
    }

    protected void initVariableValue() {
        this.variableValue = null;
    }

    protected ExecBlockKind solvedState() {
        return this.getCurrentSolveState();
    }

    protected final ExecBlockKind getCurrentSolveState() {
        if (this.typeInstance == null) {
            return ExecBlockKind.NONE;
        }
        return this.typeInstance.currentSolveState;
    }

    protected final void setCurrentSolveState(ExecBlockKind currentSolveState) {
        if (this.typeInstance == null) {
            return;
        }
        this.typeInstance.currentSolveState = currentSolveState;
    }

    protected final void preSolveFields() {
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return;
        }
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if ((!fieldInstance.isRand() || !fieldInstance.isStructType()) && !fieldInstance.isPort()) continue;
            fieldInstance.preSolve();
        }
    }

    protected final void postSolveFields() {
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return;
        }
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if ((!fieldInstance.isRand() || !fieldInstance.isStructType()) && !fieldInstance.isPort()) continue;
            fieldInstance.postSolve();
        }
    }

    protected boolean isSolved() {
        switch (this.solvedState()) {
            case POST_SOLVE: 
            case BODY: 
            case RUN_START: 
            case RUN_END: 
            case SOLVE_COMPOUND: 
            case SOLVE: {
                return true;
            }
        }
        return false;
    }

    public void setVariableValue(Expression.Value value) {
        if (value != null && Expression.Value.isReference(value) && value.getRefValue() == this) {
            return;
        }
        this.variableValue = Expression.Value.isNull(value) ? null : value;
    }

    public Expression.Value getVariableValue() {
        return this.variableValue;
    }

    public void setDirectVariableValue(Expression.Value value) {
        this.variableValue = Expression.Value.from(value);
    }

    public boolean isRef() {
        RfField rfField = this.getRfField();
        return rfField != null && rfField.isRef();
    }

    public final Expression.Value getVariableValue(boolean initialize) {
        if (!initialize) {
            if (this.variableValue != null && Expression.Value.isReference(this.variableValue) && this.variableValue.getRefValue() == this) {
                return null;
            }
            return this.variableValue;
        }
        if (this.variableValue != null) {
            return this.variableValue;
        }
        if (this.isRefTypeInstance() && this.variableValue == null) {
            return Expression.Value.from(null, -1, false);
        }
        if (this.isStructType() || this.isCollectionType()) {
            return Expression.Value.from(this, -1, false);
        }
        if (this.isHandleType()) {
            return Expression.Value.from(null, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, false);
        }
        if (this.isRand()) {
            return this.variableValue;
        }
        this.variableValue = Utils.getInitialValue(this.scenario, this);
        return this.variableValue;
    }

    public Expression.Value getVariableDebuggerValue() {
        return this.getVariableValue(true);
    }

    public boolean isRand() {
        return false;
    }

    public IntVariable getVariable(Model model, String overrideVarName, InstancePath varHierarchicalPath, Map<String, GeneratedVar> variableSolverMap, boolean printConnectMessage) {
        LinkedHashMap<String, Variable> variables;
        InstancesContainer parentInstance;
        boolean isStructType;
        InstancesContainer instance = varHierarchicalPath.lastSegment().getInstance();
        if (instance != this) {
            ScenarioUtils.print(Utils.append("*** Error: Wrong field instance '", this.getHierarchicalPath(), "' vs '", varHierarchicalPath, "'"));
            throw new Solver.InterruptException();
        }
        String origVariableName = varHierarchicalPath.toString();
        String thisVariableName = overrideVarName == null ? origVariableName : overrideVarName;
        RfField rfField = this.getRfField();
        boolean isIndexVariable = rfField.isIndex();
        boolean isRand = this.isRand();
        if (isIndexVariable && this.variableValue != null) {
            thisVariableName = Utils.append(thisVariableName, "_", this.variableValue);
            origVariableName = Utils.append(origVariableName, "_", this.variableValue);
        }
        if ((isStructType = this.isStructType()) && !this.isStructType(StructKind.STRUCT)) {
            return null;
        }
        boolean isBooleanType = this.isBooleanType();
        boolean isStringType = this.isStringType();
        boolean isCollectionType = this.isCollectionType();
        ActionInstance parentActionInstance = isRand ? this.getParentActionInstance() : null;
        boolean isSolved = parentActionInstance != null && parentActionInstance.isSolved();
        boolean isResourcePoolReuseValue = isRand && !isSolved && this.isResourceReuseValue();
        GeneratedVar result = null;
        boolean isGenerated = isIndexVariable || !isRand || isSolved || isResourcePoolReuseValue;
        result = variableSolverMap.get(thisVariableName);
        if (result != null) {
            return result.getIntVariable();
        }
        result = variableSolverMap.get(origVariableName);
        if (result != null) {
            if (variableSolverMap.get(thisVariableName) == null && isGenerated) {
                this.declareExisting(model, thisVariableName, false, true, isIndexVariable, isBooleanType);
            }
            variableSolverMap.put(thisVariableName, result);
            return result.getIntVariable();
        }
        if (this.isUniqueIdField() && (parentInstance = ((FieldInstance)this).getParentInstance()).isCollectionType()) {
            String arrayVarName = thisVariableName.substring(0, thisVariableName.length() - "[unique_id]".length() - 1);
            return parentInstance.getVariable(model, arrayVarName, varHierarchicalPath.removeLastSegment(), variableSolverMap, printConnectMessage);
        }
        if (isCollectionType) {
            variables = this.getArrayVariables(model, variableSolverMap);
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", this.toStringVariableValue(variables.values())));
            result = new GeneratedVar(this, (IntVariable)new CompoundVariable(model, variables, thisVariableName, true), textVarValue);
            variableSolverMap.put(thisVariableName, result);
            variableSolverMap.put(origVariableName, result);
            return result.getIntVariable();
        }
        if (isStructType) {
            variables = this.getCompoundVariables(model, variableSolverMap);
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", this.toStringVariableValue(variables.values())));
            result = new GeneratedVar(this, (IntVariable)new CompoundVariable(model, variables, thisVariableName, false), textVarValue);
            variableSolverMap.put(thisVariableName, result);
            variableSolverMap.put(origVariableName, result);
            return result.getIntVariable();
        }
        boolean isDisablePrint = variableSolverMap.containsKey(thisVariableName);
        if (this.variableValue != null && !Expression.Value.isReference(this.variableValue) && isGenerated) {
            result = this.declareExisting(model, thisVariableName, isDisablePrint, false, isIndexVariable, isBooleanType);
            variableSolverMap.put(thisVariableName, result);
            variableSolverMap.put(origVariableName, result);
            if (result != null) {
                return result.getIntVariable();
            }
        }
        LazyString textVarValue = LazyString.create(() -> "");
        if (isRand) {
            DataType dataType = this.getDataType();
            if (isStringType) {
                if (isSolved && Expression.Value.isString(this.variableValue) && this.variableValue.getStringValue() != null) {
                    model.setIncrementalValue(thisVariableName, this.variableValue.getStringValue());
                }
                String[] inStrings = dataType.getInStrings();
                textVarValue = LazyString.create(() -> Utils.append(" in ", inStrings == null ? "STRING_DOMAIN" : this.toString(inStrings)));
                result = new GeneratedVar(this, (IntVariable)(inStrings == null ? model.strVar(thisVariableName) : model.strVar(thisVariableName, inStrings)), textVarValue);
            } else if (isBooleanType) {
                if (isSolved && Expression.Value.isInteger(this.variableValue) && this.variableValue.getIntValue() != null) {
                    model.setIncrementalValue(thisVariableName, this.variableValue.getIntValue());
                }
                textVarValue = LazyString.create(() -> " in [true, false]");
                result = new GeneratedVar(this, model.boolVar(thisVariableName), textVarValue);
            } else {
                if (isSolved && Expression.Value.isInteger(this.variableValue) && this.variableValue.getIntValue() != null) {
                    model.setIncrementalValue(thisVariableName, this.variableValue.getIntValue());
                }
                IntDomain intVarDomain = this.getVariableDomain(rfField);
                IntVariable intVar = model.intVar(thisVariableName, this.hasSign(), this.nofBits(), intVarDomain);
                intVar.setDiscreteAllowed(!isIndexVariable);
                textVarValue = LazyString.create(() -> Utils.append(" in ", this.toString(intVarDomain)));
                result = new GeneratedVar(this, intVar, textVarValue);
            }
        } else if (isStringType) {
            this.variableValue = Utils.getInitialValue(this.scenario, this);
            String strValue = this.variableValue.getStringValue() == null ? "[null]" : this.variableValue.getStringValue();
            textVarValue = LazyString.create(() -> Utils.append(" = ", strValue));
            result = new GeneratedVar(this, (IntVariable)model.strVar(thisVariableName, strValue).setConstant(true), textVarValue);
        } else if (isBooleanType) {
            this.variableValue = Utils.getInitialValue(this.scenario, this);
            boolean booleanValue = !this.variableValue.getIntValue().equals(BigInteger.ZERO);
            textVarValue = LazyString.create(() -> Utils.append(" = ", booleanValue ? "true" : "false"));
            result = new GeneratedVar(this, (IntVariable)model.boolVar(thisVariableName, booleanValue ? BigInteger.ONE : BigInteger.ZERO).setConstant(true), textVarValue);
        } else if (Utils.isSizeofMember(rfField)) {
            RfTemplateInstance rfTemplateInstance = (RfTemplateInstance)rfField.getEnclosingScope();
            RfNamedElement rfTemplateInstanceParam = rfTemplateInstance.getInstanceParameters().get(0);
            int sizeof = rfTemplateInstanceParam.sizeof();
            BigInteger intValue = BigInteger.valueOf("nbytes".equals(ScenarioUtils.getDeduplicateName(rfField)) ? Utils.nofBytes(sizeof) : sizeof);
            this.variableValue = Expression.Value.from(intValue, this.nofBits(), this.hasSign());
            textVarValue = LazyString.create(() -> Utils.append(" = ", intValue.toString()));
            result = new GeneratedVar(this, (IntVariable)model.intVar(thisVariableName, true, 32, intValue).setConstant(true), textVarValue);
        } else {
            this.variableValue = Utils.getInitialValue(this.scenario, this);
            textVarValue = LazyString.create(() -> Utils.append(" = ", this.variableValue.toString()));
            result = new GeneratedVar(this, (IntVariable)model.intVar(thisVariableName, this.hasSign(), this.nofBits(), this.variableValue.getIntValue()).setConstant(true), textVarValue);
            isDisablePrint = isDisablePrint || this.isEnumType();
        }
        this.registerVariables(variableSolverMap, result, isDisablePrint, thisVariableName, origVariableName, textVarValue);
        return result.getIntVariable();
    }

    private final boolean isResourceReuseValue() {
        InstancesContainer parentInstance = this;
        do {
            if (!(parentInstance instanceof PoolItem) || !((PoolItem)parentInstance).isResource()) continue;
            ExecBlockKind currentSolveState = parentInstance.getCurrentSolveState();
            return currentSolveState == ExecBlockKind.SOLVE_REUSE_VALUE;
        } while ((parentInstance = ((FieldInstance)parentInstance).getParentInstance()) instanceof FieldInstance);
        return false;
    }

    protected final void registerVariables(Map<String, GeneratedVar> variableSolverMap, GeneratedVar variableValue, boolean isDisablePrint, String variableName1, String variableName2, LazyString textVariableValue) {
        if (variableName1 != null && !variableSolverMap.containsKey(variableName1)) {
            variableSolverMap.put(variableName1, variableValue);
            if (!isDisablePrint) {
                ScenarioUtils.printDebug2(Utils.append("\u2007   ", "var ", variableName1, textVariableValue.toString()));
            }
        }
        if (variableName2 != null && !variableSolverMap.containsKey(variableName2) && !variableName2.equals(variableName1)) {
            variableSolverMap.put(variableName2, variableValue);
            if (!isDisablePrint) {
                ScenarioUtils.printDebug2(Utils.append("\u2007   ", "var ", variableName2, textVariableValue.toString()));
            }
        }
    }

    private String toStringVariableValue(Collection<Variable> variables) {
        StringBuilder result = new StringBuilder("{ ");
        boolean isFirst = true;
        for (Variable variable : variables) {
            if (!isFirst) {
                result.append(", ");
            }
            if (!variable.isInstantiated()) {
                return "";
            }
            String variableName = variable.getName();
            if (variableName != null && variableName.endsWith("[unique_id]")) {
                result.append(variableName);
            } else if (variable instanceof CompoundVariable) {
                result.append(" unsupported yet ");
            } else {
                result.append(variable.value());
            }
            isFirst = false;
        }
        return result.append(" }").toString();
    }

    public boolean isUniqueIdField() {
        return false;
    }

    public void getVariable(String varName, Map<String, GeneratedVar> variableSolverMap) {
        variableSolverMap.put(varName, new GeneratedVar(this, null, null));
    }

    private GeneratedVar declareExisting(Model model, String variableName, boolean isDisablePrint, boolean isPrintOnly, boolean isIndexVariable, boolean isBoolean) {
        GeneratedVar result = null;
        if (Expression.Value.isString(this.variableValue)) {
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", this.toStringVariableValue(), " (generated)"));
            if (!isDisablePrint) {
                ScenarioUtils.printDebug2(Utils.append("\u2007   ", "var ", variableName, textVarValue));
            }
            if (!isPrintOnly) {
                result = new GeneratedVar(this, (IntVariable)model.strVar(variableName, this.variableValue.getStringValue()).setConstant(true), textVarValue);
            }
        } else if (Expression.Value.isInteger(this.variableValue) && isBoolean) {
            boolean booleanValue = Expression.Value.isTrue(this.variableValue);
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", booleanValue ? "true" : "false", " (generated)"));
            if (!isDisablePrint) {
                ScenarioUtils.printDebug2(Utils.append("\u2007   ", "var ", variableName, textVarValue));
            }
            if (!isPrintOnly) {
                result = new GeneratedVar(this, (IntVariable)model.boolVar(variableName, booleanValue ? BigInteger.ONE : BigInteger.ZERO).setConstant(true), textVarValue);
            }
        } else if (Expression.Value.isInteger(this.variableValue)) {
            LazyString textVarValue = LazyString.create(() -> Utils.append(" = ", this.toStringVariableValue(), " (generated)"));
            if (!(isDisablePrint || isIndexVariable || this.isUniqueIdField() || Expression.Value.isEnumItem(this.variableValue))) {
                ScenarioUtils.printDebug2(Utils.append("\u2007   ", "var ", variableName, textVarValue));
            }
            if (!isPrintOnly) {
                result = new GeneratedVar(this, (IntVariable)model.intVar(variableName, this.hasSign(), this.nofBits(), this.variableValue.getIntValue()).setConstant(true), textVarValue);
            }
        }
        return result;
    }

    private LinkedHashMap<String, Variable> getArrayVariables(Model model, Map<String, GeneratedVar> variableSolverMap) {
        LinkedHashMap<String, Variable> result = new LinkedHashMap<String, Variable>();
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return result;
        }
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if (!fieldInstance.isArrayItem()) continue;
            IntVariable variable = fieldInstance.getVariable(model, null, fieldInstance.getHierarchicalPath(), variableSolverMap, false);
            result.put(fieldInstance.getName(), (Variable)variable);
        }
        return result;
    }

    private LinkedHashMap<String, Variable> getCompoundVariables(Model model, Map<String, GeneratedVar> variableSolverMap) {
        LinkedHashMap<String, Variable> result = new LinkedHashMap<String, Variable>();
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null || fieldInstances.isEmpty()) {
            return result;
        }
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            if (fieldInstance.isUniqueIdField()) continue;
            IntVariable variable = fieldInstance.getVariable(model, null, fieldInstance.getHierarchicalPath(), variableSolverMap, false);
            result.put(fieldInstance.getName(), (Variable)variable);
        }
        return result;
    }

    private final IntDomain getVariableDomain(RfField rfField) {
        IntDomain domain = this.getIntDomain();
        if (domain != null && domain.isEmpty()) {
            RfDefElement declaration = rfField.getDeclaration();
            ScenarioUtils.logError(Utils.append("Illegal empty domain for variable '", this, "'"), declaration.getStartLine(), declaration.getParserPath());
            throw new IllegalArgumentException();
        }
        return domain;
    }

    public boolean isInitialStateObject() {
        return false;
    }

    private String toString(IntDomain domain) {
        if (domain == null) {
            return null;
        }
        IntDomain.DomainValueNameProvider provider = new IntDomain.DomainValueNameProvider(){

            public String nameFor(BigInteger value) {
                if (InstancesContainer.this.typeInstance != null && InstancesContainer.this.typeInstance.isBooleanType()) {
                    return value.equals(BigInteger.ZERO) ? "false" : "true";
                }
                if (InstancesContainer.this.typeInstance != null && InstancesContainer.this.typeInstance.isEnumType()) {
                    RfEnumItem rfEnumItem = ((RfEnumType)InstancesContainer.this.typeInstance.rfInstanceType).getEnumItem(value.intValueExact(), null);
                    return rfEnumItem.getElabName();
                }
                return Utils.formatNumber(ScenarioUtils.getSolver().radix(), value, InstancesContainer.this.nofBits(), 4);
            }
        };
        return domain.toString(provider);
    }

    private String toString(String[] values) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (result.length() == 0) {
                result.append("[\"");
            } else {
                result.append("\", \"");
            }
            result.append((Object)value);
            ++n2;
        }
        result.append("\"]");
        return result.toString();
    }

    protected void createUniqueId() {
        this.typeInstance.createUniqueId(this.runtimeId);
    }

    public RfNamedElement getRfFieldType() {
        return this.typeInstance.rfInstanceType;
    }

    public static RestoreConnect connect(PortInstance portInstance1, PortInstance portInstance2) {
        TypeInstance restoreTypeInstance = portInstance1.typeInstance;
        List<InstancesContainer> references = restoreTypeInstance.getReferences();
        for (InstancesContainer fieldInstance : references) {
            if (fieldInstance.typeInstance == portInstance2.typeInstance) continue;
            fieldInstance.typeInstance = portInstance2.typeInstance;
            portInstance2.typeInstance.addReference(fieldInstance);
        }
        return new RestoreConnect(restoreTypeInstance, portInstance2);
    }

    public static void disconnect(RestoreConnect restoreConnect) {
        for (InstancesContainer fieldInstance : restoreConnect.typeInstance.getReferences()) {
            if (fieldInstance.typeInstance == restoreConnect.typeInstance) continue;
            fieldInstance.typeInstance = restoreConnect.typeInstance;
            restoreConnect.fieldInstance.typeInstance.removeReference(fieldInstance);
        }
    }

    private final RfNamedElement checkEqualsType(InstancesContainer from, String internalErrorPrefix, boolean isLikeReversed, boolean isSameType, int line, ParserPath parserPath) {
        RfNamedElement fromInstanceType;
        RfNamedElement thisInstanceType = this.getRfFieldType();
        if (SemanticUtils.isAssignmentCompatible(thisInstanceType, fromInstanceType = from.getRfFieldType())) {
            return thisInstanceType;
        }
        if (isSameType && thisInstanceType != fromInstanceType) {
            throw new Solver.EvaluationException("Internal error " + internalErrorPrefix + "_2", line, parserPath);
        }
        if (!isLikeReversed && SemanticUtils.isLike(fromInstanceType, thisInstanceType)) {
            return thisInstanceType;
        }
        if (isLikeReversed && SemanticUtils.isLike(thisInstanceType, fromInstanceType)) {
            return thisInstanceType;
        }
        if (thisInstanceType instanceof RfCollectionType && fromInstanceType instanceof RfCollectionType) {
            RfNamedElement thisArrayItemType = Utils.getArrayItemType((RfCollectionType)thisInstanceType);
            RfNamedElement fromArrayItemType = Utils.getArrayItemType((RfCollectionType)fromInstanceType);
            if (fromArrayItemType instanceof RfCollectionType) {
                this.arraySize = from.arraySize;
            } else if (fromArrayItemType != null && thisArrayItemType != fromArrayItemType) {
                if (SemanticUtils.isAssignmentCompatible(fromArrayItemType, thisArrayItemType)) {
                    return thisInstanceType;
                }
                if (SemanticUtils.isLike(fromArrayItemType, thisArrayItemType)) {
                    return thisInstanceType;
                }
                throw new Solver.EvaluationException("Internal error " + internalErrorPrefix + "_1", line, parserPath);
            }
            return thisInstanceType;
        }
        throw new Solver.EvaluationException("Internal error " + internalErrorPrefix + "_2", line, parserPath);
    }

    protected final void deepCopy(InstancesContainer from, int line, ParserPath parserPath) {
        block22: {
            try {
                this.checkEqualsType(from, "COP", false, false, line, parserPath);
                Map<String, FieldInstance> thisFieldInstances = this.getFieldInstances();
                Map<String, FieldInstance> fromFieldInstances = from.getFieldInstances();
                if (thisFieldInstances != null) {
                    if (this.isCollectionType() && !this.isArrayType()) {
                        ((FieldInstance)this).clearItems();
                        if (this.isListType()) {
                            int i = 0;
                            while (i < from.arraySize) {
                                ((FieldInstance)this).addListItem(Expression.Value.from(null, -1, false), line, parserPath);
                                ++i;
                            }
                        } else if (this.isMapType() && fromFieldInstances != null) {
                            for (Map.Entry<String, FieldInstance> fromFieldEntry : fromFieldInstances.entrySet()) {
                                fromFieldInstance = fromFieldEntry.getValue();
                                if (!fromFieldInstance.isArrayItem()) continue;
                                ((FieldInstance)this).insertMapItem(fromFieldEntry.getKey(), Expression.Value.from(null, -1, false), line, parserPath);
                            }
                        } else if (this.isSetType() && fromFieldInstances != null) {
                            for (Map.Entry<String, FieldInstance> fromFieldEntry : fromFieldInstances.entrySet()) {
                                fromFieldInstance = fromFieldEntry.getValue();
                                if (!fromFieldInstance.isArrayItem()) continue;
                                ((FieldInstance)this).insertMapItem(fromFieldEntry.getKey(), Expression.Value.from(null, -1, false), line, parserPath);
                            }
                        }
                        thisFieldInstances = this.getFieldInstances();
                    }
                    if (fromFieldInstances != null) {
                        RfNamedElement thisInstanceType = this.getRfFieldType();
                        for (Map.Entry<String, FieldInstance> fromFieldInstanceEntry : fromFieldInstances.entrySet()) {
                            FieldInstance thisField;
                            FieldInstance fromField = fromFieldInstanceEntry.getValue();
                            if (fromField == null) {
                                throw new Solver.EvaluationException("Internal error COP_3", line, parserPath);
                            }
                            String thisName = fromFieldInstanceEntry.getKey();
                            if (fromField.isArrayItem() && !fromField.isMapItem() && !fromField.isSetItem()) {
                                thisName = Utils.append("[", fromField.arrayItemIndex, "]");
                            }
                            if ((thisField = thisFieldInstances.get(thisName)) == null) {
                                RfField rfField = fromField.isArrayItem() ? new RfField(thisName, fromField.getRfField().getDataType()) : fromField.getRfField();
                                RfNamedElement rfFieldType = fromField.isArrayItem() ? Utils.getArrayItemType((RfCollectionType)thisInstanceType) : fromField.getRfFieldType();
                                rfField.setAssociatedType(rfFieldType);
                                thisField = this.createFieldInstance(new IdentityHashMap<RfNamedElement, InstancesContainer>(), fromField.isMapItem() ? thisName : null, rfField, rfFieldType, fromField.arraySize, fromField.arrayItemIndex, false);
                            }
                            this.arraySize = from.arraySize;
                            thisField.deepCopy(Utils.unwrapReferenceInstance(fromField), line, parserPath);
                        }
                    } else if (!this.isCollectionType() && !this.isStructType()) {
                        throw new Solver.EvaluationException("Internal error COP_4", line, parserPath);
                    }
                    break block22;
                }
                if (!this.isUniqueIdField()) {
                    if (fromFieldInstances != null) {
                        throw new Solver.EvaluationException("Internal error COP_5", line, parserPath);
                    }
                    this.variableValue = Expression.Value.from(from.variableValue);
                }
            }
            catch (Solver.EvaluationException e) {
                ScenarioUtils.print(e.getErrorMessage(this.scenario, line, parserPath));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected final boolean deepCompare(InstancesContainer from, boolean isLikeReversed, boolean isSameType, int line, ParserPath parserPath) {
        try {
            if (this == from) {
                return true;
            }
            this.checkEqualsType(from, "COM", isLikeReversed, isSameType, line, parserPath);
            Map<String, FieldInstance> thisFieldInstances = this.getFieldInstances();
            Map<String, FieldInstance> fromFieldInstances = from.getFieldInstances();
            if (thisFieldInstances != null) {
                if (this.arraySize != from.arraySize) {
                    return false;
                }
                if (fromFieldInstances != null) {
                    for (Map.Entry<String, FieldInstance> fromFieldEntry : fromFieldInstances.entrySet()) {
                        InstancesContainer unwrapInstance2;
                        FieldInstance thisField;
                        String fromName = fromFieldEntry.getKey();
                        FieldInstance fromField = fromFieldEntry.getValue();
                        if (fromField == null) {
                            throw new Solver.EvaluationException("Internal error COM_3");
                        }
                        String thisName = fromName;
                        if (fromField.isArrayItem()) {
                            thisName = Utils.append("[", fromField.arrayItemIndex, "]");
                        }
                        if ((thisField = thisFieldInstances.get(thisName)) == null) {
                            return false;
                        }
                        if (this.isCollectionType() && "size".equals(thisName) && this.arraySize != from.arraySize) {
                            return false;
                        }
                        InstancesContainer unwrapInstance1 = Utils.unwrapReferenceInstance(thisField);
                        if (unwrapInstance1.deepCompare(unwrapInstance2 = Utils.unwrapReferenceInstance(fromField), isLikeReversed, isSameType, line, parserPath)) continue;
                        return false;
                    }
                } else if (!this.isListType()) {
                    throw new Solver.EvaluationException("Internal error COM_4");
                }
            } else if (!this.isUniqueIdField()) {
                if (this.variableValue == null || fromFieldInstances != null) {
                    throw new Solver.EvaluationException("Internal error COM_5");
                }
                if (!this.variableValue.equals(from.variableValue)) {
                    return false;
                }
            }
        }
        catch (Solver.EvaluationException e) {
            ScenarioUtils.print(e.getErrorMessage(this.scenario, line, parserPath));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    protected void applyExecDescriptors(Model model, Map<String, GeneratedVar> variableSolverMap, ExecBlockKind execKind, RfNamedElement rfStructType) {
        if (!(rfStructType instanceof RfStruct)) {
            return;
        }
        Scenario.ExecDescriptors execDescriptors = this.scenario.getExecDescriptors((RfStruct)rfStructType, execKind);
        if (execDescriptors == null || execDescriptors.descriptors.isEmpty()) {
            return;
        }
        for (ConstraintDescriptor.ExecStmtDescriptor execDescriptor : execDescriptors.descriptors) {
            execDescriptor.apply(this.scenario, model, variableSolverMap, null, this, null, null);
        }
    }

    public void preSolve() {
        throw new UnsupportedOperationException();
    }

    public boolean solve() {
        throw new UnsupportedOperationException();
    }

    public void postSolve() {
        throw new UnsupportedOperationException();
    }

    public final void collectInstancesOfType(List<InstancesContainer> result, RfNamedElement rfNamedElement) {
        Map<String, FieldInstance> fieldInstances;
        if (rfNamedElement == null || this.typeInstance == null || this.typeInstance.rfInstanceType == null) {
            return;
        }
        if (this.isRefTypeInstance()) {
            return;
        }
        if (rfNamedElement == this.typeInstance.rfInstanceType) {
            result.add(this);
            if (this instanceof ActionInstance) {
                return;
            }
        }
        if ((fieldInstances = this.getFieldInstances()) == null || fieldInstances.isEmpty()) {
            return;
        }
        for (FieldInstance fieldInstance : fieldInstances.values()) {
            fieldInstance.collectInstancesOfType(result, rfNamedElement);
        }
    }

    public InstancesContainer internalThis() {
        return this;
    }

    public boolean isBooleanType() {
        return this.typeInstance != null && this.typeInstance.isBooleanType();
    }

    public boolean isStringType() {
        return this.typeInstance != null && this.typeInstance.isStringType();
    }

    public boolean isHandleType() {
        return this.typeInstance != null && this.typeInstance.isHandleType();
    }

    public boolean isEnumType() {
        return this.typeInstance != null && this.typeInstance.isEnumType();
    }

    public boolean isStructType() {
        return this.typeInstance != null && this.typeInstance.isStructType();
    }

    public boolean isStructType(StructKind structKind) {
        return this.typeInstance != null && this.typeInstance.isStructType(structKind);
    }

    public boolean isCollectionType() {
        return this.typeInstance != null && this.typeInstance.isCollectionType();
    }

    public boolean isArrayType() {
        return this.typeInstance != null && this.typeInstance.isArrayType();
    }

    public boolean isListType() {
        return this.typeInstance != null && this.typeInstance.isListType();
    }

    public boolean isMapType() {
        return this.typeInstance != null && this.typeInstance.isMapType();
    }

    public boolean isSetType() {
        return this.typeInstance != null && this.typeInstance.isSetType();
    }

    public boolean isVectorType() {
        return this.typeInstance != null && this.typeInstance.isVectorType();
    }

    public boolean isIntegerType() {
        return this.typeInstance == null || this.typeInstance.isIntType();
    }

    public boolean isUintType() {
        return this.typeInstance == null || this.typeInstance.isUintType();
    }

    public InstancesContainer getRange(int lsb, int msb) {
        if (lsb != msb || this.arraySize <= 0) {
            throw new Solver.EvaluationException("Cannot evaluate '" + this.toString() + "[" + lsb + "]' variable instance");
        }
        return this.getFieldInstance(lsb);
    }

    protected abstract Collection<? extends InstancesContainer> getMembers();

    protected abstract boolean isValueCopyAssignment();

    protected DataType getDataType() {
        throw new UnsupportedOperationException();
    }

    protected RfNamedElement getAssociatedType() {
        throw new UnsupportedOperationException();
    }

    public final Expression.Value pack() {
        BigInteger packResult = BigInteger.ZERO;
        int nofBits = 0;
        boolean isBinEndian = this.isBinEndianPacking();
        LinkedList<FieldInstance> childrenFieldInstances = new LinkedList<FieldInstance>();
        Utils.flattenFieldInstances(childrenFieldInstances, this, isBinEndian);
        for (FieldInstance childFieldInstances : childrenFieldInstances) {
            Expression.Value packValue = childFieldInstances.getVariableValue(true);
            if (!Expression.Value.isInteger(packValue)) {
                throw new UnsupportedOperationException();
            }
            int i = 0;
            while (i < packValue.nofBits()) {
                if (packValue.getIntValue().testBit(i)) {
                    packResult = packResult.setBit(i + nofBits);
                }
                ++i;
            }
            nofBits += packValue.nofBits();
        }
        if (isBinEndian) {
            int paddingBits = (8 - nofBits % 8) % 8;
            packResult = packResult.shiftLeft(paddingBits);
            nofBits += paddingBits;
        }
        return Expression.Value.from(packResult, nofBits, false);
    }

    public final void unpack(Expression.Value packValue) {
        boolean isBinEndian = this.isBinEndianPacking();
        int nofBits = isBinEndian ? packValue.nofBits() : 0;
        LinkedList<FieldInstance> childrenFieldInstances = new LinkedList<FieldInstance>();
        Utils.flattenFieldInstances(childrenFieldInstances, this, false);
        for (FieldInstance childFieldInstance : childrenFieldInstances) {
            BigInteger packResult = BigInteger.ZERO;
            int fieldInstanceNofBits = childFieldInstance.nofBits();
            boolean fieldInstanceHasSign = childFieldInstance.hasSign();
            int i = 0;
            while (i < fieldInstanceNofBits) {
                if (isBinEndian) {
                    if (packValue.getIntValue().testBit(nofBits - 1 - i)) {
                        packResult = packResult.setBit(fieldInstanceNofBits - 1 - i);
                    }
                } else if (packValue.getIntValue().testBit(i + nofBits)) {
                    packResult = packResult.setBit(i);
                }
                ++i;
            }
            nofBits = isBinEndian ? (nofBits -= fieldInstanceNofBits) : (nofBits += fieldInstanceNofBits);
            childFieldInstance.setVariableValue(Expression.Value.from(packResult, fieldInstanceNofBits, fieldInstanceHasSign));
        }
    }

    private final boolean isBinEndianPacking() {
        return this.isStructType() && ((RfStruct)this.typeInstance.rfInstanceType).isBinEndianPacking();
    }

    protected final boolean isTransparentClaim() {
        return this.typeInstance.rfInstanceType.isCoreLibInstanceOf("transparent_addr_claim_s");
    }

    public final Scenario getScenario() {
        return this.scenario;
    }

    public final BigInteger getRuntimeId() {
        return this.runtimeId;
    }

    public static class GeneratedVar {
        protected Variable variable;
        protected InstancesContainer instance;
        protected LazyString inDeclarationDomain;

        public GeneratedVar(InstancesContainer instance, IntVariable variable, LazyString inDeclarationDomain) {
            this.instance = instance;
            this.variable = variable;
            this.inDeclarationDomain = inDeclarationDomain;
        }

        public void storeValue(Scenario scenario) {
            if (this.instance == null) {
                return;
            }
            if (this.variable instanceof CompoundVariable) {
                return;
            }
            if (this.variable instanceof StrVariable) {
                this.instance.setVariableValue(Expression.Value.from(((StrVariable)this.variable).getValue(), -1, false));
            } else if (this.instance.isHandleType()) {
                this.instance.setVariableValue(Expression.Value.from(null, this.variable.value(), BigInteger.ZERO, BigInteger.ZERO, false));
            } else {
                this.instance.setVariableValue(Expression.Value.from(this.variable.value(), this.instance.nofBits(), this.instance.hasSign()));
            }
        }

        public InstancesContainer getInstance() {
            return this.instance;
        }

        public String toStringVariableValue() {
            return this.instance.toStringVariableValue();
        }

        public IntVariable getIntVariable() {
            return (IntVariable)this.variable;
        }

        public static class ClaimGeneratedVar
        extends GeneratedVar {
            private Collection<RegionInstance> regionInstances;

            public ClaimGeneratedVar(InstancesContainer instance, CompoundVariable variable, Collection<RegionInstance> regionInstances) {
                super(instance, null, null);
                this.variable = variable;
                this.regionInstances = regionInstances;
            }

            @Override
            public void storeValue(Scenario scenario) {
                if (this.instance == null) {
                    return;
                }
                Map variables = ((CompoundVariable)this.variable).getVariables();
                BigInteger addressValue = ((Variable)variables.get("@addr")).value();
                RegionInstance regionInstance = this.getRegion(addressValue);
                Expression.Value.HndlValue handleValue = Expression.Value.from(regionInstance, addressValue, BigInteger.ZERO, ((Variable)variables.get("@size")).value(), !BigInteger.ZERO.equals(((Variable)variables.get("@permanent")).value()));
                this.instance.setVariableValue(handleValue);
                scenario.alloc(this.instance);
            }

            private RegionInstance getRegion(BigInteger addressValue) {
                for (RegionInstance regionInstance : this.regionInstances) {
                    BigInteger lowerAddress = regionInstance.getLowerAddress();
                    BigInteger upperAddress = regionInstance.getUpperAddress();
                    if (addressValue.compareTo(lowerAddress) < 0 || addressValue.compareTo(upperAddress) > 0) continue;
                    return regionInstance;
                }
                RfDefElement declaration = this.instance.getRfField().getDeclaration();
                throw new Solver.EvaluationException("Internal error CLM_1", declaration.getStartLine(), declaration.getParserPath());
            }

            @Override
            public IntVariable getIntVariable() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class NullRefInstance
    extends InstancesContainer {
        private static final long serialVersionUID = 1L;
        private InstancesContainer instance;

        public NullRefInstance(InstancesContainer instance) {
            super(instance.getName(), -1, -1, Solver.DEFAULT_RUNTIME_ID, null, false, instance.scenario);
            this.instance = instance;
        }

        @Override
        public ActionInstance getParentActionInstance() {
            return this.instance.getParentActionInstance();
        }

        @Override
        public ComponentInstance getParentComponentInstance() {
            return this.instance.getParentComponentInstance();
        }

        @Override
        public InstancePath getInstancePath() {
            return this.instance.getInstancePath();
        }

        @Override
        public InstancePath getHierarchicalPath() {
            return this.instance.getHierarchicalPath();
        }

        @Override
        public RfField getRfField() {
            return this.instance.getRfField();
        }

        @Override
        protected Collection<? extends InstancesContainer> getMembers() {
            return this.instance.getMembers();
        }

        @Override
        protected boolean isValueCopyAssignment() {
            return false;
        }

        @Override
        public Expression.Value getVariableValue() {
            return Expression.Value.from(null, -1, false);
        }

        @Override
        public Expression.Value getVariableDebuggerValue() {
            return Expression.Value.from(null, -1, false);
        }
    }

    static class RestoreConnect {
        private TypeInstance typeInstance;
        private InstancesContainer fieldInstance;

        public RestoreConnect(TypeInstance typeInstance, InstancesContainer fieldInstance) {
            this.typeInstance = typeInstance;
            this.fieldInstance = fieldInstance;
        }
    }
}

