/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.Serializable;
import java.math.BigInteger;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public abstract class LabeledElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected int arraySize;
    protected int arrayItemIndex;
    protected BigInteger runtimeId;
    public int instanceIndex;

    protected LabeledElement(String name, int arraySize, int arrayItemIndex, BigInteger runtimeId) {
        this.name = name;
        this.arraySize = arraySize;
        this.arrayItemIndex = arrayItemIndex;
        this.instanceIndex = -1;
        this.runtimeId = runtimeId;
    }

    public String getName() {
        if (this.arrayItemIndex < 0) {
            return this.name;
        }
        return Utils.append("[", this.arrayItemIndex, "]");
    }

    public String getDiagramName() {
        if (this.arrayItemIndex < 0) {
            return this.name;
        }
        return Utils.append(this.name, "[", this.arrayItemIndex, "]");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRawName() {
        return this.name;
    }

    public boolean isArrayItem() {
        return this.arrayItemIndex >= 0;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public int getArrayItemIndex() {
        return this.arrayItemIndex;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public String toString() {
        return this.getDiagramName();
    }
}

