/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedMethod;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.NestedBlockContext;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.VariableInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfFieldWrapper;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public class MethodCallContext
extends NestedBlockContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, Integer> parameterReplacements;
    private List<Expression.Value> parameterValues;
    private transient RfMethod rfMethod;

    public static MethodCallContext createSymbolContext(Solver solver, InstancesContainer parentInstanceScope, RfMethod rfMethod, List<Expression> argumentExprs) {
        int rfArgumentsSize;
        boolean isSymbolCall = rfMethod.isSymbol();
        if (!isSymbolCall) {
            solver.logError("*** Error: Internal error SCC_1");
            throw new Solver.InterruptException();
        }
        MethodCallContext context = new MethodCallContext(solver.getScenario(), parentInstanceScope.runtimeId, parentInstanceScope, rfMethod);
        List<RfField> rfArguments = rfMethod.getArguments();
        int n = rfArgumentsSize = rfArguments == null ? 0 : rfArguments.size();
        if (rfArguments == null || argumentExprs == null) {
            return context;
        }
        int i = 0;
        while (i < rfArgumentsSize) {
            RfField rfArgument = rfArguments.get(i);
            Expression argumentExpr = argumentExprs.get(i);
            RfField rfActionHandle = ((Expression.Hid)argumentExpr).getLastField();
            context.addRfArgumentReplacement(rfArgument, rfActionHandle);
            ++i;
        }
        return context;
    }

    public static MethodCallContext createMethodContext(Solver solver, InstancesContainer methodCallInstanceScope, InstancesContainer parentInstanceScope, RfMethod rfMethod, List<Expression> argumentsExpr, int line, ParserPath parserPath) {
        boolean isPredefinedPrintMethod;
        int actualArgumentsSize;
        boolean isVariadic;
        boolean isSymbolCall = rfMethod.isSymbol();
        if (isSymbolCall) {
            solver.logError("*** Error: Internal error MCC_1");
            throw new Solver.InterruptException();
        }
        String methodName = ScenarioUtils.getDeduplicateName(rfMethod);
        MethodCallContext context = new MethodCallContext(solver.getScenario(), parentInstanceScope.runtimeId, parentInstanceScope, rfMethod);
        List<RfField> rfArguments = rfMethod.getArguments();
        int formalArgumentsSize = rfArguments == null ? 0 : rfArguments.size();
        int formalNoDefaultSize = SemanticUtils.getNofArgumentsNoDefault(rfArguments);
        if (formalNoDefaultSize - ((isVariadic = rfArguments != null && !rfArguments.isEmpty() && rfArguments.get(rfArguments.size() - 1).isVariadic()) ? 1 : 0) > (actualArgumentsSize = argumentsExpr == null ? 0 : argumentsExpr.size())) {
            solver.logError("*** Error: Internal error MCC_2");
            throw new Solver.InterruptException();
        }
        boolean bl = isPredefinedPrintMethod = rfMethod instanceof RfPredefinedMethod && ("print".equals(methodName) || "message".equals(methodName) || "appendf".equals(methodName));
        if (formalArgumentsSize < actualArgumentsSize && !isVariadic && !isPredefinedPrintMethod) {
            solver.logError("*** Error: Internal error MCC_3");
            throw new Solver.InterruptException();
        }
        if (rfArguments == null || argumentsExpr == null) {
            return context;
        }
        ArrayList<Expression.Value> parameterValues = new ArrayList<Expression.Value>(Math.max(actualArgumentsSize, formalArgumentsSize));
        VariableInstance variadicArgInstance = null;
        int i = 0;
        while (i < Math.max(actualArgumentsSize, formalArgumentsSize)) {
            if (i < actualArgumentsSize) {
                RfField rfArgument;
                Expression argumentExpr = argumentsExpr.get(i);
                List value = Expression.filterVacuous(argumentExpr.evaluate(solver.getScenario(), methodCallInstanceScope));
                argumentValue = (Expression.Value)value.get((int)0).expr;
                if (value == null || value.size() != 1 || argumentValue == null) {
                    throw new Solver.EvaluationException(Utils.append("Fail to evaluate method/function '", rfMethod.getElabName(), "' call argument expression '", argumentExpr, "'"), argumentExpr.line, argumentExpr.parserPath);
                }
                if (Expression.Value.isReference(argumentValue)) {
                    parameterValues.add(Expression.Value.from(Utils.unwrapReferenceInstance(argumentValue.getRefValue()), -1, false));
                } else {
                    parameterValues.add(argumentValue);
                }
                RfField rfField = rfArgument = i < formalArgumentsSize ? rfArguments.get(i) : rfArguments.get(formalArgumentsSize - 1);
                if (rfArgument != null) {
                    boolean isVariadicArg = rfArgument.isVariadic();
                    String argName = rfArgument.getElabName();
                    if (isVariadicArg) {
                        if (actualArgumentsSize == formalArgumentsSize && Expression.Value.isReference(argumentValue) && (argumentValue.getRefValue().isArrayType() || argumentValue.getRefValue().isListType())) {
                            context.addReferenceChildFieldInstance(argName, (FieldInstance)argumentValue.getRefValue(), false);
                        } else {
                            DataType valueDataType;
                            DataType dataType;
                            if (variadicArgInstance == null) {
                                variadicArgInstance = context.createVariableInstance(rfArgument);
                            }
                            if (Expression.Value.isInteger(argumentValue) && (dataType = rfArgument.getDataType()) != null && (valueDataType = dataType.getValueDataType()) != null) {
                                valueDataType.set(0, Math.max(valueDataType.right(), argumentValue.nofBits() - 1), true);
                            }
                            FieldInstance itemInstance = variadicArgInstance.addListItem(null, line, parserPath);
                            if (!rfArgument.isOutput()) {
                                MethodCallContext.setVariableValue(solver, argumentValue, true, itemInstance);
                            }
                        }
                    } else if (Expression.Value.isReference(argumentValue) && argumentValue.getRefValue() instanceof FieldInstance) {
                        context.addReferenceChildFieldInstance(argName, (FieldInstance)argumentValue.getRefValue(), false);
                    } else {
                        VariableInstance argVariableInstance = context.createVariableInstance(rfArgument);
                        if (!rfArgument.isOutput()) {
                            MethodCallContext.setVariableValue(solver, argumentValue, false, argVariableInstance);
                        }
                    }
                }
            } else {
                RfField rfArgument;
                RfField rfField = rfArgument = i < formalArgumentsSize ? rfArguments.get(i) : null;
                if (rfArgument != null) {
                    VariableInstance argVariableInstance = context.createVariableInstance(rfArgument);
                    argumentValue = argVariableInstance.getVariableValue(true);
                    if (argumentValue == null) {
                        throw new Solver.EvaluationException(Utils.append("Fail to evaluate method/function '", rfMethod.getElabName(), "' call argument default value"), line, parserPath);
                    }
                    if (Expression.Value.isReference(argumentValue)) {
                        parameterValues.add(Expression.Value.from(Utils.unwrapReferenceInstance(argumentValue.getRefValue()), -1, false));
                    } else {
                        parameterValues.add(argumentValue);
                    }
                }
            }
            ++i;
        }
        context.parameterValues = parameterValues;
        return context;
    }

    protected static void setVariableValue(Solver solver, Expression.Value variableValue, boolean isVariadicArg, FieldInstance variableInstance) {
        if (Expression.Value.isReference(variableValue)) {
            variableInstance.setVariableValue(variableValue);
        } else if (Expression.Value.isInteger(variableValue) && isVariadicArg) {
            variableInstance.setDirectVariableValue(variableValue);
        } else if (Expression.Value.isInteger(variableValue)) {
            variableInstance.setVariableValue(variableValue);
        } else if (Expression.Value.isString(variableValue) && isVariadicArg) {
            variableInstance.setDirectVariableValue(variableValue);
        } else if (Expression.Value.isString(variableValue)) {
            variableInstance.setVariableValue(variableValue);
        } else if (Expression.Value.isHandle(variableValue)) {
            variableInstance.setVariableValue(variableValue);
        } else {
            solver.logError("*** Error: Internal error MCC_4");
        }
    }

    public List<Expression.Value> getParameterValues() {
        return this.parameterValues;
    }

    public void copyOutputArgumentValues(InstancesContainer methodCallInstanceScope, List<Expression> argumentExprs, int line, ParserPath parserPath) {
        if (argumentExprs == null || this.typeInstance.fieldInstances == null || this.typeInstance.fieldInstances.isEmpty()) {
            return;
        }
        int i = 0;
        for (FieldInstance instance : this.typeInstance.fieldInstances.values()) {
            if (i >= argumentExprs.size()) {
                return;
            }
            RfField rfArgument = instance.getRfField();
            ++i;
            if (rfArgument == null || !rfArgument.isMethodParam() || !rfArgument.isOutput()) continue;
            Expression argumentExpr = argumentExprs.get(i - 1);
            List argValueList = Expression.filterVacuous(argumentExpr.evaluate(this.scenario, methodCallInstanceScope));
            if (argValueList == null || argValueList.size() != 1) {
                throw new Solver.EvaluationException(Utils.append("Cannot set value to '", argumentExpr, "'"), argumentExpr.line, argumentExpr.parserPath);
            }
            Expression.Value argValue = (Expression.Value)argValueList.get((int)0).expr;
            InstancesContainer argVariableInstance = argValue.getRefValue();
            if (argVariableInstance == null) {
                throw new Solver.EvaluationException(Utils.append("Cannot set value to '", argumentExpr, "'"), argumentExpr.line, argumentExpr.parserPath);
            }
            if (Expression.Value.isReference(argValue)) {
                argVariableInstance.deepCopy(instance, line, parserPath);
                continue;
            }
            if (Expression.Value.isInteger(argValue)) {
                argVariableInstance.setVariableValue(argValue);
                continue;
            }
            if (Expression.Value.isString(argValue)) {
                argVariableInstance.setVariableValue(argValue);
                continue;
            }
            throw new Solver.EvaluationException(Utils.append("Cannot set value to '", argumentExpr, "'"), argumentExpr.line, argumentExpr.parserPath);
        }
    }

    @Override
    public VariableInstance createVariableInstance(RfField rfArgument) {
        int arraySize = Utils.getAssociatedTypeArrayDim(rfArgument);
        IdentityHashMap<RfNamedElement, InstancesContainer> backPointersMap = new IdentityHashMap<RfNamedElement, InstancesContainer>();
        RfNamedElement rfArgumentType = Utils.getAssociatedType(rfArgument);
        FieldInstance variableInstance = this.createFieldInstance(backPointersMap, null, rfArgument, rfArgumentType, arraySize, -1, true);
        return (VariableInstance)variableInstance;
    }

    private MethodCallContext(Scenario scenario, BigInteger runtimeId, InstancesContainer parentInstanceScope, RfMethod rfMethod) {
        super(Utils.append("[", ScenarioUtils.getDeduplicateName(rfMethod), "() method call]"), runtimeId, parentInstanceScope, scenario);
        this.rfMethod = this.getMethodOverride(parentInstanceScope, rfMethod);
    }

    private final RfMethod getMethodOverride(InstancesContainer parentInstanceScope, RfMethod rfMethod) {
        RfNamedElement rfFieldType;
        if (parentInstanceScope instanceof NestedBlockContext) {
            return rfMethod;
        }
        if (parentInstanceScope instanceof ISchedulingInstance) {
            parentInstanceScope = parentInstanceScope.getParentActionInstance();
        }
        if ((rfFieldType = parentInstanceScope.getRfFieldType()) == null) {
            return rfMethod;
        }
        RfMethod rfMethodOverride = (RfMethod)rfFieldType.getLocalMember(null, SemanticUtils.MEMBER_METHODS, rfMethod.getElabName(), false, null);
        if (rfMethodOverride != null) {
            return rfMethodOverride;
        }
        return rfMethod;
    }

    @Override
    public RfField getRfField() {
        return new RfFieldWrapper(this.rfMethod);
    }

    public RfMethod getRfMethod() {
        return this.rfMethod;
    }

    public void addRfArgumentReplacement(RfField rfArgument, RfField rfActionHandle) {
        if (this.parameterReplacements == null) {
            this.parameterReplacements = new HashMap<Integer, Integer>();
        }
        int key = ScenarioUtils.getKeyOfRf(rfArgument);
        int value = ScenarioUtils.getKeyOfRf(rfActionHandle);
        this.parameterReplacements.put(key, value);
    }

    @Override
    public RfField getRfActionHandle(RfField rfArgument) {
        if (this.parameterReplacements == null) {
            return null;
        }
        int key = ScenarioUtils.getKeyOfRf(rfArgument);
        int value = this.parameterReplacements.get(key);
        return (RfField)ScenarioUtils.getRfOfKey(value);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int key = ScenarioUtils.getKeyOfRf(this.rfMethod);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int key = in.readInt();
        this.rfMethod = (RfMethod)ScenarioUtils.getRfOfKey(key);
    }
}

