/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.MethodCallContext;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.RfFieldWrapper;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;

public class MethodCallInstance
extends InstancesContainer {
    private static final long serialVersionUID = 1L;
    private int line;
    private ParserPath parserPath;
    private RfMethod rfMethod;
    private List<Expression> arguments;
    private InstancesContainer parentInstance;

    public MethodCallInstance(InstancesContainer parentInstance, RfMethod rfMethod, List<Expression> arguments, int line, ParserPath parserPath) {
        super(ScenarioUtils.getDeduplicateName(rfMethod), -1, -1, parentInstance.runtimeId, null, false, parentInstance.scenario);
        this.arguments = arguments;
        this.rfMethod = rfMethod;
        this.parentInstance = parentInstance;
        this.line = line;
        this.parserPath = parserPath;
    }

    @Override
    public ActionInstance getParentActionInstance() {
        return this.parentInstance.getParentActionInstance();
    }

    @Override
    public ComponentInstance getParentComponentInstance() {
        return this.parentInstance.getParentComponentInstance();
    }

    @Override
    public InstancePath getInstancePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstancePath getHierarchicalPath() {
        return new InstancePath(this.parentInstance.getHierarchicalPath(), false, this);
    }

    @Override
    public RfField getRfField() {
        return new RfFieldWrapper(this.rfMethod);
    }

    @Override
    protected Collection<? extends InstancesContainer> getMembers() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isValueCopyAssignment() {
        throw new UnsupportedOperationException();
    }

    public Expression.MethodCall toMethodCallExpr() {
        return new Expression.MethodCall(null, this.rfMethod, this.arguments, this.line, this.parserPath){
            private static final long serialVersionUID = 1L;

            @Override
            public List<Expression.ExprAndDep<Expression.Value>> evaluate(Scenario scenario, InstancesContainer currentInstanceScope) {
                if (MethodCallInstance.this.rfMethod == null) {
                    ScenarioUtils.printWarning(Utils.append("Fail to evaluate method/function '[null]' call"), true, this.line, this.parserPath);
                    return Collections.singletonList(new Expression.ExprAndDep<Expression.Value>(Expression.Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                }
                MethodCallContext methodCallContext = MethodCallContext.createMethodContext(scenario.getSolver(), currentInstanceScope, MethodCallInstance.this.parentInstance, MethodCallInstance.this.rfMethod, MethodCallInstance.this.arguments, this.line, this.parserPath);
                if (methodCallContext == null) {
                    ScenarioUtils.printWarning(Utils.append("Fail to evaluate method/function '", MethodCallInstance.this.rfMethod.getElabName(), "' call"), true, this.line, this.parserPath);
                    return Collections.singletonList(new Expression.ExprAndDep<Expression.Value>(Expression.Value.from(BigInteger.ZERO, 32, true), null, this.toString(true), this.line));
                }
                try {
                    scenario.debugBeginEvaluate(this, currentInstanceScope);
                    List<Expression.ExprAndDep<Expression.Value>> list = this.internalEvaluate(scenario, methodCallContext.getRfMethod(), currentInstanceScope, MethodCallInstance.this.parentInstance, methodCallContext);
                    scenario.debugFinishEvaluate(this, currentInstanceScope);
                    return list;
                }
                catch (Throwable throwable) {
                    try {
                        scenario.debugFinishEvaluate(this, currentInstanceScope);
                        throw throwable;
                    }
                    catch (Solver.EvaluationException e) {
                        ScenarioUtils.print(e.getErrorMessage(scenario, this.line, this.parserPath));
                        throw new Solver.InterruptException();
                    }
                }
            }
        };
    }

    public Expression.Value evaluateMethodCall(InstancesContainer methodCallArgumentsScope) {
        Expression.MethodCall methodCallExpr = this.toMethodCallExpr();
        List<Expression.ExprAndDep<Expression.Value>> vals = methodCallExpr.evaluate(this.scenario, methodCallArgumentsScope);
        if (vals == null || vals.size() != 1) {
            throw new Solver.EvaluationException(Utils.append("Fail to evaluate method/function '", this.rfMethod.getElabName(), "' result"), this.line, this.parserPath);
        }
        return (Expression.Value)vals.get((int)0).expr;
    }

    @Override
    public int nofBits() {
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            RfCollectionType rfCollectionType = (RfCollectionType)this.parentInstance.getRfFieldType();
            return SemanticUtils.nofBits(rfCollectionType.getItemField());
        }
        return SemanticUtils.nofBits(this.rfMethod);
    }

    @Override
    public boolean hasSign() {
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            RfCollectionType rfCollectionType = (RfCollectionType)this.parentInstance.getRfFieldType();
            return SemanticUtils.hasSign(rfCollectionType.getItemField());
        }
        return SemanticUtils.hasSign(this.rfMethod);
    }

    @Override
    public IntDomain getIntDomain() {
        IntDomain fullDomain = Utils.getFullIntDomain(this);
        if (this.isArrayItem() && this.parentInstance != null && this.parentInstance.isCollectionType()) {
            RfCollectionType rfCollectionType = (RfCollectionType)this.parentInstance.getRfFieldType();
            return SemanticUtils.toIntDomain(rfCollectionType.getItemField(), fullDomain);
        }
        return SemanticUtils.toIntDomain(this.rfMethod, fullDomain);
    }

    @Override
    protected DataType getDataType() {
        if (this.rfMethod == null) {
            return null;
        }
        return this.rfMethod.getDataType();
    }

    @Override
    protected RfNamedElement getAssociatedType() {
        if (this.rfMethod == null) {
            return null;
        }
        return this.rfMethod.getAssociatedType();
    }
}

