/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.VariableInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class NestedBlockContext
extends InstancesContainer {
    private static final long serialVersionUID = 1L;
    protected InstancesContainer parentInstanceScope;
    protected NestedBlockContext childInstanceScope;

    protected NestedBlockContext(String name, BigInteger runtimeId, InstancesContainer parentInstanceScope, Scenario scenario) {
        super(name, -1, -1, runtimeId, scenario.getSolver().voidType, false, scenario);
        this.parentInstanceScope = parentInstanceScope;
        if (parentInstanceScope instanceof NestedBlockContext) {
            ((NestedBlockContext)parentInstanceScope).childInstanceScope = this;
        }
    }

    @Override
    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
    }

    @Override
    public FieldInstance getFieldInstance(InstancesContainer instance) {
        FieldInstance fieldInstance = super.getFieldInstance(instance);
        if (fieldInstance != null) {
            return fieldInstance;
        }
        return this.parentInstanceScope.getFieldInstance(instance);
    }

    @Override
    public FieldInstance getFieldInstance(String instanceName) {
        FieldInstance fieldInstance = super.getFieldInstance(instanceName);
        if (fieldInstance != null) {
            return fieldInstance;
        }
        return this.parentInstanceScope.getFieldInstance(instanceName);
    }

    public VariableInstance createVariableInstance(RfField rfArgument) {
        int arraySize = Utils.getAssociatedTypeArrayDim(rfArgument);
        IdentityHashMap<RfNamedElement, InstancesContainer> backPointersMap = new IdentityHashMap<RfNamedElement, InstancesContainer>();
        RfNamedElement rfArgumentType = Utils.getAssociatedType(rfArgument);
        FieldInstance variableInstance = this.createFieldInstance(backPointersMap, null, rfArgument, rfArgumentType, arraySize, -1, true);
        return (VariableInstance)variableInstance;
    }

    public RfField getRfActionHandle(RfField rfArgument) {
        if (this.parentInstanceScope instanceof NestedBlockContext) {
            return ((NestedBlockContext)this.parentInstanceScope).getRfActionHandle(rfArgument);
        }
        return null;
    }

    public InstancesContainer getParentInstance() {
        return this.parentInstanceScope;
    }

    public NestedBlockContext getChildInstance() {
        return this.childInstanceScope;
    }

    @Override
    public Expression.Value getRepeatIndexValue(RfField.RfIndexField rfIndexField) {
        FieldInstance indexVariableInstance = this.getFieldInstance(ScenarioUtils.getDeduplicateName(rfIndexField));
        if (indexVariableInstance != null && indexVariableInstance.getRfField() == rfIndexField) {
            return indexVariableInstance.getVariableValue();
        }
        return this.parentInstanceScope.getRepeatIndexValue(rfIndexField);
    }

    @Override
    public Expression.Value getRepeatIteratorValue(RfField.RfIteratorField rfIteratorField) {
        FieldInstance iteratorVariableInstance = this.getFieldInstance(ScenarioUtils.getDeduplicateName(rfIteratorField));
        if (iteratorVariableInstance != null && iteratorVariableInstance.getRfField() == rfIteratorField) {
            return iteratorVariableInstance.getVariableValue();
        }
        return this.parentInstanceScope.getRepeatIteratorValue(rfIteratorField);
    }

    @Override
    public ActionInstance getParentActionInstance() {
        if (this.parentInstanceScope instanceof NestedBlockContext) {
            return ((NestedBlockContext)this.parentInstanceScope).getParentActionInstance();
        }
        if (this.parentInstanceScope instanceof ISchedulingInstance) {
            return ((ActionInstance)this.parentInstanceScope).getParentActionInstance();
        }
        if (this.parentInstanceScope instanceof ActionInstance) {
            return (ActionInstance)this.parentInstanceScope;
        }
        return null;
    }

    @Override
    public ComponentInstance getParentComponentInstance() {
        if (this.parentInstanceScope instanceof NestedBlockContext) {
            return ((NestedBlockContext)this.parentInstanceScope).getParentComponentInstance();
        }
        if (this.parentInstanceScope instanceof ActionInstance) {
            return ((ActionInstance)this.parentInstanceScope).getParentComponentInstance();
        }
        if (this.parentInstanceScope instanceof ComponentInstance) {
            return (ComponentInstance)this.parentInstanceScope;
        }
        return null;
    }

    @Override
    public InstancePath getInstancePath() {
        return this.parentInstanceScope.getInstancePath();
    }

    @Override
    public InstancePath getHierarchicalPath() {
        return null;
    }

    @Override
    public RfField getRfField() {
        return null;
    }

    @Override
    protected Collection<? extends InstancesContainer> getMembers() {
        return Collections.emptyList();
    }

    @Override
    protected boolean isValueCopyAssignment() {
        return false;
    }
}

