/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.pssdt.model.reflection.Determinant;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.InstancesContainer;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.SchedulerProxy;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstancePath;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class Pool
extends InstancesContainer {
    private static final long serialVersionUID = 1L;
    protected static final String INITIAL_STATE_OBJECT_NAME = "[initial state object]";
    protected ComponentInstance parentComponentInstance;
    private StructKind poolKind;
    private PortInstance initialStateObject;
    protected transient RfField rfPool;

    public Pool(Map<RfNamedElement, InstancesContainer> backPointersMap, ComponentInstance parentComponentInstance, RfField rfField, RfNamedElement rfFieldType, int poolSize, Scenario scenario) {
        super(ScenarioUtils.getDeduplicateName(rfField), -1, -1, Solver.DEFAULT_RUNTIME_ID, rfFieldType, false, scenario);
        this.rfPool = rfField;
        this.parentComponentInstance = parentComponentInstance;
        this.poolKind = Solver.getStructKind(this.typeInstance.rfInstanceType);
        poolSize = Math.max(1, poolSize);
        scenario.addRecoverableInstance(this);
        int i = 0;
        while (i < poolSize) {
            backPointersMap.remove(rfFieldType);
            this.createFieldInstance((Map)backPointersMap, (String)null, rfField, rfFieldType, -1, i, false);
            ++i;
        }
    }

    @Override
    public ComponentInstance getParentComponentInstance() {
        return this.parentComponentInstance;
    }

    @Override
    public ActionInstance getParentActionInstance() {
        return null;
    }

    @Override
    public InstancePath getInstancePath() {
        return new InstancePath(this.parentComponentInstance.getInstancePath(), false, this);
    }

    @Override
    public InstancePath getHierarchicalPath() {
        return this.getInstancePath();
    }

    public RfNamedElement getRfPoolType() {
        return this.typeInstance.rfInstanceType;
    }

    public RfStruct getRfComponent() {
        return this.parentComponentInstance.getRfComponent();
    }

    @Override
    public PoolItem createFieldInstance(Map<RfNamedElement, InstancesContainer> backPointersMap, String instanceName, RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, boolean isVariableInstance) {
        PoolItem fieldInstance = new PoolItem(rfField, rfFieldType, arraySize, arrayItemIndex, this.runtimeId, this.scenario);
        this.addChildFieldInstance(instanceName, fieldInstance, false);
        if (fieldInstance.isRefTypeInstance()) {
            return fieldInstance;
        }
        InstancesContainer backPointer = backPointersMap.get(rfFieldType);
        if (backPointer != null) {
            ScenarioUtils.printError(Utils.append("Infinite recursion detected for '", rfFieldType.getElabName(), "' instantiation"), true, rfField.getDeclaration());
            throw new Solver.InterruptException();
        }
        fieldInstance.createSubInstances(backPointersMap, false);
        return fieldInstance;
    }

    public Map<String, FieldInstance> getPoolItems() {
        return this.getFieldInstances();
    }

    @Override
    public String toString() {
        return Utils.append(this.getParentComponentInstance(), ".", this.getDiagramName());
    }

    public RfField getRfPool() {
        return this.rfPool;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int key = ScenarioUtils.getKeyOfRf(this.rfPool);
        out.writeInt(key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int key = in.readInt();
        this.rfPool = (RfField)ScenarioUtils.getRfOfKey(key);
    }

    @Override
    public void createSubInstances(Map<RfNamedElement, InstancesContainer> backPointersMap, boolean isVariableInstance) {
        super.createSubInstances(backPointersMap, isVariableInstance);
    }

    @Override
    public RfField getRfField() {
        return this.rfPool;
    }

    public boolean isState() {
        return this.poolKind == StructKind.STATE;
    }

    public boolean isResource() {
        return this.poolKind == StructKind.RESOURCE;
    }

    public boolean canInsertBefore(ActionInstance actionInstance1, ActionInstance actionInstance2) {
        if (!this.isState()) {
            return true;
        }
        PoolItem poolItem = (PoolItem)Utils.first(this.getPoolItems());
        boolean result = poolItem.canInsertBefore(actionInstance1, actionInstance2);
        return result;
    }

    @Override
    public FieldInstance getFieldInstance(InstancesContainer instance) {
        return this.typeInstance.getFieldInstance(instance);
    }

    public PortInstance getInitialStateObject() {
        if (!this.isState()) {
            return null;
        }
        if (this.initialStateObject != null) {
            return this.initialStateObject;
        }
        final RfField rfField = new RfField(INITIAL_STATE_OBJECT_NAME, null);
        rfField.setAssociatedType(this.getRfPoolType());
        rfField.setFieldModifier(FieldModifier.OUTPUT);
        RfStruct rfAction = new RfStruct("[initial state action]"){

            @Override
            public Collection<RfNamedElement> getMembersForElab(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter elementFilter) {
                return Collections.singletonList(rfField);
            }
        };
        rfAction.setStructKind(StructKind.ACTION);
        InitialStateActionInstance actionInstance = new InitialStateActionInstance(rfAction, this.parentComponentInstance, this.scenario);
        actionInstance.instanceIndex = 100000;
        InstanceVisitor<ComponentInstance> visitor = componentInstance -> {
            List<Pool> poolInstances = componentInstance.getPoolInstances();
            if (poolInstances == null) {
                return true;
            }
            for (Pool poolInstance : poolInstances) {
                if (poolInstance == this) {
                    return false;
                }
                actionInstance.instanceIndex = actionInstance.instanceIndex + 1;
            }
            return true;
        };
        this.scenario.rootComponent.accept(visitor);
        actionInstance.seed = this.seed;
        this.initialStateObject = (PortInstance)actionInstance.getFieldInstances().get(INITIAL_STATE_OBJECT_NAME);
        this.initialStateObject.connectToPoolItem((PortInstance)this.getPoolItems().values().iterator().next());
        this.scenario.solver.solveInitialStateObjectConstraints(this.initialStateObject, false, true, this.seed);
        return this.initialStateObject;
    }

    public void checkResourcePoolSchedulingConsistency() {
        if (!this.isResource()) {
            return;
        }
        for (FieldInstance poolItem : this.getPoolItems().values()) {
            List<PortInstance> binds = poolItem.getBinds();
            if (binds == null || binds.isEmpty()) continue;
            int i = 0;
            while (i < binds.size() - 1) {
                ActionInstance actionInstance1;
                FieldInstance fieldInstance1 = binds.get(i);
                if (fieldInstance1.isLock() && (actionInstance1 = fieldInstance1.getParentActionInstance()) != null) {
                    int j = i + 1;
                    while (j < binds.size()) {
                        ActionInstance.SchedulingParent commonSchedulingParent;
                        ActionInstance actionInstance2;
                        FieldInstance fieldInstance2 = binds.get(j);
                        if (fieldInstance2.isLock() && (actionInstance2 = fieldInstance2.getParentActionInstance()) != null && (commonSchedulingParent = ActionInstance.getCommonSchedulingParent(actionInstance1, actionInstance2)) != null && commonSchedulingParent.isParallelSchedulingParent()) {
                            throw new Solver.SolverException();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void collectInitialStatePoolConnectOptions(Collection<PortInstance> connectCandidates) {
        FieldInstance poolItem = Utils.first(this.getPoolItems());
        List<PortInstance> poolBinds = poolItem.getPoolBinds();
        if (poolBinds == null || poolBinds.isEmpty()) {
            return;
        }
        ActionInstance actionInstance = this.initialStateObject.getParentActionInstance();
        for (PortInstance fieldInstanceCandidate : poolBinds) {
            ActionInstance actionInstanceCandidate;
            if (this.initialStateObject == fieldInstanceCandidate || actionInstance == (actionInstanceCandidate = fieldInstanceCandidate.getParentActionInstance()) || fieldInstanceCandidate.isOutput() || !this.canScheduleBeforeAll(poolBinds, fieldInstanceCandidate, actionInstanceCandidate, false) || !this.scenario.solver.checkConnectConstraint(false, true, fieldInstanceCandidate, this.initialStateObject)) continue;
            connectCandidates.add(fieldInstanceCandidate);
        }
    }

    protected void collectStatePoolConnectOptions(Collection<PortInstance> connectCandidates, PortInstance fieldInstance) {
        ActionInstance actionInstance;
        List<PortInstance> poolBinds;
        block22: {
            FieldInstance poolItem = Utils.first(this.getPoolItems());
            poolBinds = poolItem.getPoolBinds();
            if (poolBinds == null || poolBinds.isEmpty()) {
                return;
            }
            actionInstance = fieldInstance.getParentActionInstance();
            if (fieldInstance.isInput() && fieldInstance != this.initialStateObject && this.canScheduleBeforeAll(poolBinds, fieldInstance, actionInstance, true)) {
                ISchedulerProxy prevScheduler = this.scenario.scheduler;
                try {
                    try {
                        this.scenario.scheduler = this.scenario.scheduler.copy();
                        for (FieldInstance fieldInstance2 : poolBinds) {
                            ActionInstance actionInstance2;
                            if (fieldInstance2 == this.initialStateObject || fieldInstance2.isInput() || fieldInstance == fieldInstance2 || actionInstance == (actionInstance2 = fieldInstance2.getParentActionInstance())) continue;
                            actionInstance.scheduleBefore(actionInstance2);
                        }
                        if (this.scenario.solver.checkConnectConstraint(false, true, fieldInstance, this.initialStateObject)) {
                            connectCandidates.add(this.initialStateObject);
                        }
                    }
                    catch (SchedulerProxy.SchedulingException schedulingException) {
                        this.scenario.scheduler = prevScheduler;
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    this.scenario.scheduler = prevScheduler;
                    throw throwable;
                }
                this.scenario.scheduler = prevScheduler;
            }
        }
        block9: for (PortInstance fieldInstanceCandidate : poolBinds) {
            ActionInstance actionInstanceCandidate;
            if (fieldInstanceCandidate == this.initialStateObject || fieldInstance == fieldInstanceCandidate || actionInstance == (actionInstanceCandidate = fieldInstanceCandidate.getParentActionInstance()) || fieldInstance.isInput() && fieldInstanceCandidate.isInput() || fieldInstance.isOutput() && fieldInstanceCandidate.isOutput()) continue;
            if (fieldInstance.isInput()) {
                if (!actionInstanceCandidate.canScheduleBefore(actionInstance)) continue;
                for (FieldInstance fieldInstance3 : poolBinds) {
                    ActionInstance actionInstanceCandidate2 = fieldInstance3.getParentActionInstance();
                    if (fieldInstance3.isOutput() && actionInstanceCandidate2.isBefore(actionInstance) && actionInstanceCandidate.isBefore(actionInstanceCandidate2)) continue block9;
                }
            }
            if (fieldInstance.isOutput() && !actionInstance.canScheduleBefore(actionInstanceCandidate)) continue;
            ISchedulerProxy iSchedulerProxy = this.scenario.scheduler;
            try {
                try {
                    this.scenario.scheduler = this.scenario.scheduler.copy();
                    if (fieldInstance.isInput()) {
                        actionInstanceCandidate.scheduleBefore(actionInstance);
                    } else {
                        actionInstance.scheduleBefore(actionInstanceCandidate);
                    }
                    if (fieldInstance.isInput() && fieldInstanceCandidate.isOutput()) {
                        if (this.scenario.solver.checkConnectConstraint(false, true, fieldInstance, fieldInstanceCandidate)) {
                            connectCandidates.add(fieldInstanceCandidate);
                        }
                    } else if (fieldInstance.isOutput() && fieldInstanceCandidate.isInput() && this.scenario.solver.checkConnectConstraint(false, true, fieldInstance, fieldInstanceCandidate)) {
                        connectCandidates.add(fieldInstanceCandidate);
                    }
                }
                catch (SchedulerProxy.SchedulingException schedulingException) {
                    this.scenario.scheduler = iSchedulerProxy;
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.scenario.scheduler = iSchedulerProxy;
                throw throwable;
            }
            this.scenario.scheduler = iSchedulerProxy;
        }
    }

    private boolean canScheduleBeforeAll(List<PortInstance> poolBinds, FieldInstance fieldInstance1, ActionInstance actionInstance1, boolean skipInputs) {
        if (actionInstance1.isInitialStateObject()) {
            return true;
        }
        for (FieldInstance fieldInstance : poolBinds) {
            ActionInstance actionInstance2;
            if (fieldInstance1 == fieldInstance || skipInputs && fieldInstance.isInput() || fieldInstance.isInitialStateObject() || actionInstance1 == (actionInstance2 = fieldInstance.getParentActionInstance()) || actionInstance1.canScheduleBefore(actionInstance2)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasPoolConnectedOutput(ActionInstance actionInstance) {
        for (FieldInstance poolItem : this.getPoolItems().values()) {
            List<PortInstance> poolBinds = poolItem.getPoolBinds();
            if (poolBinds == null || poolBinds.isEmpty()) continue;
            for (FieldInstance fieldInstance : poolBinds) {
                if (!fieldInstance.isOutput() || fieldInstance.getParentActionInstance() != actionInstance) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Collection<? extends InstancesContainer> getMembers() {
        Map<String, FieldInstance> fieldInstances = this.getFieldInstances();
        if (fieldInstances == null) {
            return Collections.emptyList();
        }
        return fieldInstances.values();
    }

    @Override
    protected boolean isValueCopyAssignment() {
        return false;
    }

    @Override
    public String toStringVariableValue() {
        return this.getInstancePath().toString();
    }

    class InitialStateActionInstance
    extends ActionInstance {
        private static final long serialVersionUID = 1L;

        public InitialStateActionInstance(RfStruct rfAction, ComponentInstance parentComponentInstance, Scenario scenario) {
            super("[initial state action]", -1, Solver.DEFAULT_RUNTIME_ID, rfAction, parentComponentInstance, scenario);
        }

        @Override
        public InstancePath getHierarchicalPath() {
            return Pool.this.getHierarchicalPath();
        }

        @Override
        public InstancePath getInstancePath() {
            return Pool.this.getInstancePath();
        }

        public Pool getPoolInstance() {
            return Pool.this;
        }

        @Override
        protected boolean canScheduleBefore(ActionInstance candidate) {
            return true;
        }

        @Override
        protected boolean canScheduleParallel(ActionInstance candidate) {
            return false;
        }

        @Override
        protected boolean canScheduleSequential(ActionInstance candidate) {
            return false;
        }

        @Override
        public void scheduleBefore(ActionInstance candidate) {
        }

        @Override
        public void scheduleParallel(ActionInstance candidate) {
        }

        @Override
        public void scheduleSequential(ActionInstance candidate) {
        }

        @Override
        public boolean isInitialStateObject() {
            return true;
        }

        @Override
        public boolean isBefore(ActionInstance actionInstance) {
            return true;
        }

        @Override
        public boolean isParallel(ActionInstance actionInstance) {
            return false;
        }

        @Override
        public boolean solve() {
            boolean hasSolution = this.scenario.solver.solveConstraints(true, true, false, true, this);
            return hasSolution;
        }
    }
}

