/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ISchedulingInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Pool;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class PoolItem
extends PortInstance {
    private static final long serialVersionUID = 1L;

    public PoolItem(RfField rfField, int arraySize, int arrayItemIndex, Scenario scenario) {
        super(rfField, Utils.getAssociatedType(rfField), arraySize, arrayItemIndex, Solver.DEFAULT_RUNTIME_ID, scenario);
    }

    public PoolItem(RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, BigInteger runtimeId, Scenario scenario) {
        super(rfField, rfFieldType, arraySize, arrayItemIndex, runtimeId, scenario);
    }

    @Override
    public ActionInstance getParentActionInstance() {
        return null;
    }

    @Override
    public String toString() {
        return Utils.append(this.getParentComponentInstance(), ".", this.getDiagramName());
    }

    @Override
    public boolean canBindTo(PortInstance candidate, boolean isDisableSchedulingChecks) {
        if (isDisableSchedulingChecks) {
            return true;
        }
        List<PortInstance> connectedFieldInstances = this.getBinds();
        if (connectedFieldInstances == null || connectedFieldInstances.isEmpty()) {
            return true;
        }
        for (FieldInstance fieldInstance : connectedFieldInstances) {
            if (!Solver.inSameRuntime(fieldInstance, candidate) || !fieldInstance.isLock() && !candidate.isLock() || fieldInstance.canScheduleSequential(candidate)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void addBind(PortInstance candidate) {
        List<PortInstance> fieldCandidates;
        if (this.isResource() && (fieldCandidates = this.getBinds()) != null && !fieldCandidates.isEmpty()) {
            ActionInstance parentActionInstance1 = candidate.getParentActionInstance();
            for (FieldInstance fieldInstance : fieldCandidates) {
                ActionInstance parentActionInstance2;
                if (!Solver.inSameRuntime(candidate, fieldInstance) || candidate.isShare() && fieldInstance.isShare() || !(parentActionInstance2 = fieldInstance.getParentActionInstance()).canScheduleParallel(parentActionInstance1)) continue;
                parentActionInstance2.scheduleSequential(parentActionInstance1);
            }
        }
        super.addBind(candidate);
    }

    @Override
    protected PoolItem getResourcePoolItemBind() {
        return this;
    }

    protected boolean canInsertBefore(ActionInstance actionInstance1, ActionInstance actionInstance2) {
        List<ActionInstance> children2;
        if (!this.isState()) {
            return true;
        }
        if (!Solver.inSameRuntime(actionInstance1, actionInstance2)) {
            return false;
        }
        List<PortInstance> poolBinds = this.getPoolBinds();
        if (poolBinds == null || poolBinds.isEmpty()) {
            return true;
        }
        ArrayList<PortInstance> connectedPortInstances1 = new ArrayList<PortInstance>();
        ArrayList<PortInstance> connectedPortInstances2 = new ArrayList<PortInstance>();
        for (PortInstance portInstance : poolBinds) {
            ActionInstance actionInstance = portInstance.getParentActionInstance();
            if (actionInstance == actionInstance1) {
                connectedPortInstances1.add(portInstance);
                continue;
            }
            if (actionInstance != actionInstance2) continue;
            connectedPortInstances2.add(portInstance);
        }
        if (!connectedPortInstances1.isEmpty() && !connectedPortInstances2.isEmpty()) {
            boolean hasOnlyInputs1 = true;
            boolean hasOnlyOutputs2 = true;
            for (PortInstance portInstance : connectedPortInstances1) {
                for (PortInstance portInstance2 : connectedPortInstances2) {
                    if (!Solver.inSameRuntime(portInstance, portInstance2)) continue;
                    if (portInstance.typeInstance == portInstance2.typeInstance) {
                        return portInstance.canScheduleBefore(portInstance2);
                    }
                    if (!portInstance2.isInput()) continue;
                    hasOnlyOutputs2 = false;
                }
                if (!portInstance.isOutput()) continue;
                hasOnlyInputs1 = false;
            }
            if ((hasOnlyInputs1 || hasOnlyOutputs2) && actionInstance1.canScheduleBefore(actionInstance2)) {
                return true;
            }
            for (FieldInstance fieldInstance : connectedPortInstances2) {
                if (!fieldInstance.isInput() || fieldInstance.typeInstance.getReferences().size() <= 1) continue;
                return false;
            }
            return true;
        }
        List<ActionInstance> children1 = this.getChildrenOfCompound(actionInstance1);
        if (children1.size() > 1) {
            children1.remove(actionInstance1);
        }
        if ((children2 = this.getChildrenOfCompound(actionInstance2)).size() > 1) {
            children2.remove(actionInstance2);
        }
        if (children1.size() == 1 && children2.size() == 1) {
            return true;
        }
        for (ActionInstance child1 : children1) {
            if (!Solver.inSameRuntime(child1, actionInstance1) && !Solver.inSameRuntime(child1, actionInstance2)) {
                return false;
            }
            if (child1 != actionInstance1 && !child1.isParallel(actionInstance1)) continue;
            for (ActionInstance actionInstance : children2) {
                if (!Solver.inSameRuntime(actionInstance, actionInstance1) && !Solver.inSameRuntime(actionInstance, actionInstance2)) {
                    return false;
                }
                if (actionInstance != actionInstance2 && !actionInstance.isParallel(actionInstance2) || this.canInsertBefore(child1, actionInstance)) continue;
                return false;
            }
        }
        return true;
    }

    private final List<ActionInstance> getChildrenOfCompound(ActionInstance ai) {
        ArrayList<ActionInstance> children = new ArrayList<ActionInstance>();
        InstanceVisitor<ActionInstance> visitor = instance -> {
            if (instance instanceof ISchedulingInstance) {
                return true;
            }
            children.add((ActionInstance)instance);
            return true;
        };
        ai.accept(visitor);
        return children;
    }

    @Override
    protected void addPoolBind(PortInstance candidate) {
        List<PortInstance> poolBinds;
        if (this.isState() && (poolBinds = this.getPoolBinds()) != null && !poolBinds.isEmpty()) {
            ActionInstance parentActionInstance1 = candidate.getParentActionInstance();
            for (PortInstance portInstance : poolBinds) {
                boolean solutionFound;
                ActionInstance parentActionInstance2;
                if (candidate == portInstance || !Solver.inSameRuntime(candidate, portInstance) || parentActionInstance1 == (parentActionInstance2 = portInstance.getParentActionInstance())) continue;
                boolean isParallel = parentActionInstance1.isParallel(parentActionInstance2);
                if (isParallel && (candidate.isOutput() || portInstance.isOutput())) {
                    ScenarioUtils.logError(Utils.append("Cannot connect '", candidate, "' and '", portInstance, "' to the same pool of state objects (parent actions in parallel)"), -1, null);
                    throw new Solver.SolverException();
                }
                if (isParallel && !(solutionFound = ScenarioUtils.getSolver().checkConnectConstraint(false, true, candidate, portInstance))) {
                    ScenarioUtils.logError(Utils.append("Cannot connect '", candidate, "' and '", portInstance, "' to the same pool of state objects (parallel consumers requesting different state object)"), -1, null);
                    throw new Solver.SolverException();
                }
                if (isParallel || !candidate.isOutput() && !portInstance.isOutput() || !parentActionInstance1.canScheduleParallel(parentActionInstance2)) continue;
                parentActionInstance1.scheduleSequential(parentActionInstance2);
            }
        }
        super.addPoolBind(candidate);
    }

    public PortInstance getInitialStateObject() {
        return this.getPool().getInitialStateObject();
    }

    public Pool getPool() {
        return (Pool)this.getParentInstance();
    }

    protected boolean hasPoolConnectedOutput(ActionInstance actionInstance) {
        return this.getPool().hasPoolConnectedOutput(actionInstance);
    }

    @Override
    protected boolean isValueCopyAssignment() {
        return false;
    }

    @Override
    public String toStringVariableValue() {
        return this.getInstancePath().toString();
    }
}

