/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection.elaboration;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Expression;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.Pool;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.Scenario;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.TypeInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.InstanceVisitor;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class PortInstance
extends FieldInstance {
    private static final long serialVersionUID = 1L;
    private List<PortInstance> binds;
    private List<PortInstance> poolBinds;
    private List<PortInstance> hierarchicalBinds;

    protected PortInstance(RfField rfField, RfNamedElement rfFieldType, int arraySize, int arrayItemIndex, BigInteger runtimeId, Scenario scenario) {
        super(rfField, rfFieldType, arraySize, arrayItemIndex, runtimeId, scenario);
        scenario.addRecoverableInstance(this);
    }

    protected PortInstance(String name) {
        super(name);
    }

    @Override
    public boolean isPort() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return this.fieldModifier == FieldModifier.OUTPUT;
    }

    @Override
    public boolean isInput() {
        return this.fieldModifier == FieldModifier.INPUT;
    }

    @Override
    public boolean isLock() {
        return this.fieldModifier == FieldModifier.LOCK;
    }

    @Override
    public boolean isShare() {
        return this.fieldModifier == FieldModifier.SHARE;
    }

    @Override
    public boolean isLockOrShare() {
        return this.fieldModifier == FieldModifier.LOCK || this.fieldModifier == FieldModifier.SHARE;
    }

    @Override
    protected boolean isLocalFieldRand() {
        return true;
    }

    @Override
    public boolean isRand() {
        return false;
    }

    @Override
    protected boolean hasBinds(BigInteger runtimeId) {
        if (this.binds == null || this.binds.isEmpty()) {
            return false;
        }
        for (PortInstance bind : this.binds) {
            if (!Solver.inSameRuntime(this, bind)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasHierarchicalBinds(BigInteger runtimeId, FieldInstance.HierarchicalBindKind hierarchicalBindKind) {
        if (this.hierarchicalBinds == null || this.hierarchicalBinds.isEmpty()) {
            return false;
        }
        boolean hasHierarchicalUpBinds = false;
        boolean hasHierarchicalDownBinds = false;
        for (PortInstance bind : this.hierarchicalBinds) {
            if (!Solver.inSameRuntime(this, bind)) continue;
            ActionInstance parentActionInstance1 = this.getParentActionInstance();
            ActionInstance parentActionInstance2 = bind.getParentActionInstance();
            if ((hierarchicalBindKind == FieldInstance.HierarchicalBindKind.UP || hierarchicalBindKind == FieldInstance.HierarchicalBindKind.BOTH) && parentActionInstance2.isParentInstanceOf(parentActionInstance1)) {
                if (hierarchicalBindKind == FieldInstance.HierarchicalBindKind.UP) {
                    return true;
                }
                if (hasHierarchicalDownBinds) {
                    return true;
                }
                hasHierarchicalUpBinds = true;
            }
            if (hierarchicalBindKind != FieldInstance.HierarchicalBindKind.DOWN && hierarchicalBindKind != FieldInstance.HierarchicalBindKind.BOTH || !parentActionInstance1.isParentInstanceOf(parentActionInstance2)) continue;
            if (hierarchicalBindKind == FieldInstance.HierarchicalBindKind.DOWN) {
                return true;
            }
            if (hasHierarchicalUpBinds) {
                return true;
            }
            hasHierarchicalDownBinds = true;
        }
        return false;
    }

    @Override
    protected boolean hasPoolBinds(BigInteger runtimeId) {
        if (this.poolBinds == null || this.poolBinds.isEmpty()) {
            return false;
        }
        for (PortInstance bind : this.poolBinds) {
            if (!Solver.inSameRuntime(this, bind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<PortInstance> getBinds() {
        return this.binds;
    }

    @Override
    public List<PortInstance> getPoolBinds() {
        return this.poolBinds;
    }

    @Override
    public List<PortInstance> getHierarchicalBinds(FieldInstance.HierarchicalBindKind hierarchicalBindKind) {
        if (this.hierarchicalBinds == null || this.hierarchicalBinds.isEmpty()) {
            return null;
        }
        if (hierarchicalBindKind == FieldInstance.HierarchicalBindKind.BOTH) {
            return this.hierarchicalBinds;
        }
        ArrayList<PortInstance> result = new ArrayList<PortInstance>(this.hierarchicalBinds.size());
        for (PortInstance bind : this.hierarchicalBinds) {
            if (!Solver.inSameRuntime(this, bind)) continue;
            ActionInstance parentActionInstance1 = this.getParentActionInstance();
            ActionInstance parentActionInstance2 = bind.getParentActionInstance();
            if (hierarchicalBindKind == FieldInstance.HierarchicalBindKind.UP && parentActionInstance2.isParentInstanceOf(parentActionInstance1)) {
                result.add(bind);
            }
            if (hierarchicalBindKind != FieldInstance.HierarchicalBindKind.DOWN || !parentActionInstance1.isParentInstanceOf(parentActionInstance2)) continue;
            result.add(bind);
        }
        return result;
    }

    @Override
    public boolean requiresBind(BigInteger runtimeId) {
        if (this.hasBinds(runtimeId)) {
            return false;
        }
        if (this.hasHierarchicalBinds(runtimeId, FieldInstance.HierarchicalBindKind.BOTH)) {
            return false;
        }
        StructKind objectKind = Solver.getStructKind(this.getRfFieldType());
        switch (objectKind) {
            case STATE: {
                if (!this.hasPoolBinds(runtimeId) && !this.hasHierarchicalBinds(runtimeId, FieldInstance.HierarchicalBindKind.UP)) {
                    return true;
                }
                if (!this.isInput() || this.hasHierarchicalBinds(runtimeId, FieldInstance.HierarchicalBindKind.UP)) break;
                return true;
            }
            case RESOURCE: {
                if (this.hasPoolBinds(runtimeId) || this.hasHierarchicalBinds(runtimeId, FieldInstance.HierarchicalBindKind.UP)) break;
                return true;
            }
            case STREAM: {
                if (this.hasHierarchicalBinds(runtimeId, FieldInstance.HierarchicalBindKind.UP)) break;
                return true;
            }
            case BUFFER: {
                if (!this.isInput() || this.hasHierarchicalBinds(runtimeId, FieldInstance.HierarchicalBindKind.UP)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void connectTo(PortInstance candidate) {
        this.internalCheckObsoleteScenario(candidate);
        this.scheduleConnectTo(candidate);
        this.addBind(candidate);
        candidate.addBind(this);
    }

    @Override
    public void scheduleConnectTo(PortInstance candidate) {
        this.internalCheckObsoleteScenario(candidate);
        if (this instanceof PoolItem || candidate instanceof PoolItem) {
            return;
        }
        ActionInstance candidateParentActionInstance = candidate.getParentActionInstance();
        ActionInstance parentActionInstance = this.getParentActionInstance();
        if (candidate.isInitialStateObject() || parentActionInstance.isInitialStateObject()) {
            return;
        }
        StructKind objectKind = Solver.getStructKind(this.getRfFieldType());
        switch (objectKind) {
            case BUFFER: {
                if (this.isInput()) {
                    candidateParentActionInstance.scheduleBefore(parentActionInstance);
                    break;
                }
                parentActionInstance.scheduleBefore(candidateParentActionInstance);
                break;
            }
            case STATE: {
                if (this.isInput()) {
                    candidateParentActionInstance.scheduleBefore(parentActionInstance);
                    this.scheduleRelativeToPoolBinds(this, candidate);
                    break;
                }
                parentActionInstance.scheduleBefore(candidateParentActionInstance);
                this.scheduleRelativeToPoolBinds(candidate, this);
                break;
            }
            case RESOURCE: {
                break;
            }
            case STREAM: {
                candidateParentActionInstance.scheduleParallel(parentActionInstance);
            }
        }
    }

    private void scheduleRelativeToPoolBinds(PortInstance inputStateFieldInstance, PortInstance outputStateFieldInstance) {
        if (this.poolBinds == null || this.poolBinds.isEmpty()) {
            return;
        }
        ActionInstance outputParentActionInstance = outputStateFieldInstance.getParentActionInstance();
        PortInstance poolBind = Utils.first(this.poolBinds);
        for (PortInstance portInstance : poolBind.poolBinds) {
            ActionInstance parentActionInstance = portInstance.getParentActionInstance();
            if (portInstance.isBefore(inputStateFieldInstance) && !portInstance.isInitialStateObject()) {
                if (portInstance.isInput() && !outputParentActionInstance.isBefore(parentActionInstance)) {
                    parentActionInstance.scheduleBefore(outputParentActionInstance);
                } else if (portInstance.isOutput()) {
                    parentActionInstance.scheduleBefore(outputParentActionInstance);
                }
            }
            if (!inputStateFieldInstance.isBefore(portInstance)) continue;
            outputParentActionInstance.scheduleBefore(parentActionInstance);
        }
    }

    @Override
    public void connectToPoolItem(PortInstance poolItem) {
        this.internalCheckObsoleteScenario(poolItem);
        this.addPoolBind(poolItem);
        poolItem.addPoolBind(this);
    }

    @Override
    protected void addBind(PortInstance candidate) {
        if (this == candidate) {
            return;
        }
        if (this.binds == null) {
            this.binds = new ArrayList<PortInstance>();
        }
        if (!this.binds.contains(candidate)) {
            this.binds.add(candidate);
        }
    }

    @Override
    protected void addPoolBind(PortInstance candidate) {
        if (this == candidate) {
            return;
        }
        if (this.poolBinds == null) {
            this.poolBinds = new ArrayList<PortInstance>();
        }
        if (!this.poolBinds.contains(candidate)) {
            this.poolBinds.add(candidate);
        }
    }

    @Override
    public void connectHierarchicalTo(PortInstance parentActionInstanceFieldCandidate) {
        this.addHierarchicalBind(parentActionInstanceFieldCandidate);
        parentActionInstanceFieldCandidate.addHierarchicalBind(this);
        if (this.isResource()) {
            for (PortInstance hierarchicalBind : this.hierarchicalBinds) {
                List<PortInstance> portCandidates = hierarchicalBind.hierarchicalBinds;
                if (portCandidates == null || portCandidates.isEmpty()) continue;
                ActionInstance parentActionInstance1 = this.getParentActionInstance();
                for (PortInstance fieldInstance : portCandidates) {
                    if (fieldInstance == this || this.isShare() && fieldInstance.isShare()) continue;
                    ActionInstance parentActionInstance2 = fieldInstance.getParentActionInstance();
                    if (parentActionInstance2.isParallel(parentActionInstance1)) {
                        ScenarioUtils.logError(Utils.append("Cannot connect '", this, "' and '", fieldInstance, "' in parallel to the same resource pool item"), -1, null);
                        throw new Solver.InterruptException();
                    }
                    if (!parentActionInstance2.canScheduleParallel(parentActionInstance1)) continue;
                    parentActionInstance2.scheduleSequential(parentActionInstance1);
                }
            }
        }
        if (parentActionInstanceFieldCandidate.binds == null) {
            parentActionInstanceFieldCandidate.binds = new ArrayList<PortInstance>();
        }
        this.binds = parentActionInstanceFieldCandidate.binds;
    }

    protected void addHierarchicalBind(PortInstance candidate) {
        if (this.hierarchicalBinds == null) {
            this.hierarchicalBinds = new ArrayList<PortInstance>();
        }
        if (!this.hierarchicalBinds.contains(candidate)) {
            this.hierarchicalBinds.add(candidate);
        }
    }

    @Override
    public FieldInstance.Status canHierarchicallyBindTo(PortInstance compoundActionPortInstance) {
        List<PortInstance> subActionPortBinds;
        if (compoundActionPortInstance == this) {
            return FieldInstance.Status.FAIL("cannot connect to itself");
        }
        ActionInstance compoundActionInstance = compoundActionPortInstance.getParentActionInstance();
        if (compoundActionInstance == null) {
            return FieldInstance.Status.FAIL("null");
        }
        ActionInstance subActionInstance = this.getParentActionInstance();
        if (subActionInstance == null) {
            return FieldInstance.Status.FAIL("null");
        }
        if (!compoundActionInstance.isParentInstanceOf(subActionInstance)) {
            this.scenario.getSolver().print("*** Error: Internal error CHB_1");
            return FieldInstance.Status.FAIL("null");
        }
        if (this.isOutput() && this.isState() && compoundActionPortInstance.hasHierarchicalBinds(this.runtimeId, FieldInstance.HierarchicalBindKind.DOWN)) {
            return FieldInstance.Status.FAIL("only one sub-action may be bound to the compound action\u2019s state object output");
        }
        if (!Solver.equals(this.getRfFieldType(), compoundActionPortInstance.getRfFieldType())) {
            return FieldInstance.Status.FAIL("the ports are not of the same type");
        }
        if (this.isOutput() && compoundActionPortInstance.isInput()) {
            return FieldInstance.Status.FAIL("the ports direction does not match");
        }
        if (this.isInput() && compoundActionPortInstance.isOutput()) {
            return FieldInstance.Status.FAIL("the ports direction does not match");
        }
        if (this.isLock() && compoundActionPortInstance.isShare()) {
            return FieldInstance.Status.FAIL("the lock port of the sub-action cannot be bound to a compound action share port");
        }
        if (this.isStream() && !compoundActionInstance.canScheduleParallel(subActionInstance)) {
            return FieldInstance.Status.FAIL("the sub-action is not in parallel with the compound action");
        }
        if (this.isLock() && (subActionPortBinds = compoundActionPortInstance.getHierarchicalBinds(FieldInstance.HierarchicalBindKind.DOWN)) != null && !subActionPortBinds.isEmpty()) {
            for (PortInstance subActionPortInstance : subActionPortBinds) {
                if (!subActionInstance.isParallel(subActionPortInstance.getParentActionInstance())) continue;
                return FieldInstance.Status.FAIL(Utils.append("multiple parallel sub-actions requesting lock cannot hierarchically bind to same compound action lock"));
            }
        }
        return FieldInstance.Status.OK();
    }

    @Override
    public boolean canBindTo(PortInstance candidate, boolean isDisableSchedulingChecks) {
        ActionInstance parentActionInstance2;
        this.internalCheckObsoleteScenario(candidate);
        if (candidate == this) {
            return false;
        }
        switch (this.fieldModifier) {
            case INPUT: {
                if (candidate.isOutput()) break;
                return false;
            }
            case OUTPUT: {
                if (candidate.isInput()) break;
                return false;
            }
            case LOCK: 
            case SHARE: {
                if (candidate.isLockOrShare()) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if (!Solver.equals(this.getRfFieldType(), candidate.getRfFieldType())) {
            return false;
        }
        if (this.hasHierarchicalBinds(this.runtimeId, FieldInstance.HierarchicalBindKind.UP)) {
            return false;
        }
        ActionInstance parentActionInstance1 = this.getParentActionInstance();
        if (parentActionInstance1.isParentInstanceOf(parentActionInstance2 = candidate.getParentActionInstance()) || parentActionInstance2.isParentInstanceOf(parentActionInstance1)) {
            return false;
        }
        StructKind objectKind = Solver.getStructKind(this.getRfFieldType());
        if (objectKind == StructKind.STREAM && this.hasBinds(this.runtimeId)) {
            return false;
        }
        if (isDisableSchedulingChecks) {
            return true;
        }
        if (this.isInput()) {
            switch (objectKind) {
                case BUFFER: 
                case STATE: {
                    return candidate.canScheduleBefore(this);
                }
                case STREAM: {
                    return this.canScheduleParallel(candidate);
                }
            }
            return false;
        }
        if (this.isOutput()) {
            switch (objectKind) {
                case BUFFER: 
                case STATE: {
                    return this.canScheduleBefore(candidate);
                }
                case STREAM: {
                    return this.canScheduleParallel(candidate);
                }
            }
            return false;
        }
        if (this.isLockOrShare() && candidate.isLockOrShare()) {
            if (this.canScheduleParallel(candidate)) {
                return true;
            }
            if (this.canScheduleBefore(candidate)) {
                return true;
            }
            if (candidate.canScheduleBefore(this)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean canScheduleBefore(PortInstance candidate) {
        this.internalCheckObsoleteScenario(candidate);
        ActionInstance candidateParentActionInstance = candidate.getParentActionInstance();
        ActionInstance parentActionInstance = this.getParentActionInstance();
        return parentActionInstance.canScheduleBefore(candidateParentActionInstance);
    }

    @Override
    protected boolean canScheduleParallel(PortInstance candidate) {
        this.internalCheckObsoleteScenario(candidate);
        ActionInstance candidateParentActionInstance = candidate.getParentActionInstance();
        ActionInstance parentActionInstance = this.getParentActionInstance();
        return parentActionInstance.canScheduleParallel(candidateParentActionInstance);
    }

    @Override
    protected boolean canScheduleSequential(PortInstance candidate) {
        this.internalCheckObsoleteScenario(candidate);
        ActionInstance candidateParentActionInstance = candidate.getParentActionInstance();
        ActionInstance parentActionInstance = this.getParentActionInstance();
        return parentActionInstance.canScheduleSequential(candidateParentActionInstance);
    }

    @Override
    public Set<Pool> getPoolCandidates() {
        final LinkedHashSet<Pool> result = new LinkedHashSet<Pool>();
        ComponentInstance parentComponentInstance = this.getParentComponentInstance();
        InstanceVisitor<ComponentInstance> visitor = new InstanceVisitor<ComponentInstance>(){

            @Override
            public boolean visit(ComponentInstance instance) {
                instance.collectPoolCandidates(result, PortInstance.this);
                return true;
            }
        };
        parentComponentInstance.accept(visitor);
        do {
            parentComponentInstance.collectPoolCandidates(result, this);
        } while ((parentComponentInstance = parentComponentInstance.getParentComponentInstance()) != null);
        return result;
    }

    @Override
    public boolean isUniqueIdField() {
        return false;
    }

    @Override
    public PortInstance getStateOutputPortBefore() {
        if (!this.isState() || this.poolBinds == null || this.poolBinds.isEmpty()) {
            return null;
        }
        PortInstance outputPortBefore = ((PoolItem)Utils.first(this.poolBinds)).getInitialStateObject();
        ActionInstance parentActionInstance = this.getParentActionInstance();
        for (PortInstance poolBind : this.poolBinds) {
            List<PortInstance> portInstances;
            if (!(poolBind instanceof PoolItem) || (portInstances = ((PoolItem)poolBind).getPoolBinds()) == null || portInstances.isEmpty()) continue;
            for (PortInstance candidate : portInstances) {
                ActionInstance candidateParentActionInstance;
                if (candidate == this || (candidateParentActionInstance = candidate.getParentActionInstance()) == parentActionInstance || candidateParentActionInstance.isOrphan() && !candidateParentActionInstance.isInferred() || candidate.isInput() || this.isBefore(candidate) || outputPortBefore != null && !outputPortBefore.isBefore(candidate)) continue;
                outputPortBefore = candidate;
            }
        }
        return outputPortBefore;
    }

    @Override
    public List<PortInstance> getStateOutputPortBeforeCandidates() {
        if (!this.isState() || this.poolBinds == null || this.poolBinds.isEmpty()) {
            return null;
        }
        PortInstance outputPortBefore = ((PoolItem)Utils.first(this.poolBinds)).getInitialStateObject();
        ActionInstance parentActionInstance = this.getParentActionInstance();
        ArrayList<PortInstance> outputCandidates = new ArrayList<PortInstance>();
        for (PortInstance poolBind : this.poolBinds) {
            ActionInstance candidateParentActionInstance;
            List<PortInstance> portInstances;
            if (!(poolBind instanceof PoolItem) || (portInstances = ((PoolItem)poolBind).getPoolBinds()) == null || portInstances.isEmpty()) continue;
            for (PortInstance candidate : portInstances) {
                if (candidate == this || !Solver.inSameRuntime(this, candidate) || (candidateParentActionInstance = candidate.getParentActionInstance()) == parentActionInstance || candidateParentActionInstance.isOrphan() && !candidateParentActionInstance.isInferred() || candidate.isInput() || this.isBefore(candidate) || outputPortBefore != null && !outputPortBefore.isBefore(candidate)) continue;
                outputPortBefore = candidate;
            }
            if (outputPortBefore == null) {
                return outputCandidates;
            }
            outputCandidates.add(outputPortBefore);
            for (PortInstance candidate : portInstances) {
                if (candidate == this || !Solver.inSameRuntime(this, candidate) || (candidateParentActionInstance = candidate.getParentActionInstance()) == parentActionInstance || candidate.isInput() || this.isBefore(candidate) || outputCandidates.contains(candidate) || !outputPortBefore.isBefore(candidate) && !outputPortBefore.canScheduleBefore(candidate)) continue;
                outputCandidates.add(outputPortBefore);
            }
        }
        return outputCandidates;
    }

    @Override
    public List<PortInstance> getStateParallelInputPorts() {
        if (!this.isState() || this.poolBinds == null || this.poolBinds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PortInstance> inputPortParallel = new ArrayList<PortInstance>();
        ActionInstance parentActionInstance = this.getParentActionInstance();
        for (PortInstance poolBind : this.poolBinds) {
            List<PortInstance> fieldInstances;
            if (!(poolBind instanceof PoolItem) || (fieldInstances = ((PoolItem)poolBind).getPoolBinds()) == null || fieldInstances.isEmpty()) continue;
            for (PortInstance candidate : fieldInstances) {
                ActionInstance candidateParentActionInstance;
                if (candidate == this || candidate.isOutput() || !parentActionInstance.isParallel(candidateParentActionInstance = candidate.getParentActionInstance())) continue;
                inputPortParallel.add(candidate);
            }
        }
        return inputPortParallel;
    }

    @Override
    protected PoolItem getResourcePoolItemBind() {
        if (this.binds == null) {
            return null;
        }
        for (PortInstance bind : this.binds) {
            if (!(bind instanceof PoolItem)) continue;
            return (PoolItem)bind;
        }
        return null;
    }

    @Override
    protected boolean isInitialStateObjectBind() {
        if (this.isInitialStateObject()) {
            return true;
        }
        if (this.binds == null) {
            return false;
        }
        for (PortInstance bind : this.binds) {
            if (!bind.isInitialStateObject()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInferred() {
        ActionInstance parentActionInstance = this.getParentActionInstance();
        return parentActionInstance != null && parentActionInstance.isInferred();
    }

    @Override
    public boolean isBefore(PortInstance connectedFieldInstance) {
        if (this.isInitialStateObject()) {
            return true;
        }
        if (connectedFieldInstance.isInitialStateObject()) {
            return false;
        }
        return this.getParentActionInstance().isBefore(connectedFieldInstance.getParentActionInstance());
    }

    @Override
    protected boolean hasPoolConnectedOutput() {
        PortInstance poolItem = Utils.first(this.getPoolBinds());
        if (poolItem == null) {
            return false;
        }
        return ((PoolItem)poolItem).hasPoolConnectedOutput(this.getParentActionInstance());
    }

    @Override
    public PortInstance getPairPort() {
        ActionInstance actionInstance = this.getParentActionInstance();
        if (actionInstance == null) {
            return null;
        }
        for (FieldInstance candidate : actionInstance.getFieldInstances().values()) {
            if (!candidate.isInput() && !candidate.isOutput() || candidate.isInput() && this.isInput() || candidate.isOutput() && this.isOutput() || candidate.typeInstance.rfInstanceType != this.typeInstance.rfInstanceType) continue;
            return (PortInstance)candidate;
        }
        return null;
    }

    @Override
    protected boolean isValueCopyAssignment() {
        return false;
    }

    public static class StatePrevPortInstance
    extends PortInstance {
        private static final long serialVersionUID = 1L;

        public StatePrevPortInstance(String name, PortInstance portInstance) {
            super(name);
            this.variableValue = Expression.Value.from(portInstance, -1, false);
            this.scenario = portInstance.scenario;
        }

        @Override
        protected void addBind(PortInstance candidate) {
            throw new UnsupportedOperationException();
        }

        public PortInstance getStatePrevFieldInstance() {
            return (PortInstance)this.variableValue.getRefValue();
        }

        @Override
        protected void addPoolBind(PortInstance candidate) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void addHierarchicalBind(PortInstance candidate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPort() {
            return false;
        }

        @Override
        public String toStringVariableValue() {
            return this.variableValue.getRefValue().toStringVariableValue();
        }

        @Override
        protected TypeInstance unwrapRefTypeInstance() {
            return this.variableValue.getRefValue().unwrapRefTypeInstance();
        }

        @Override
        public RfNamedElement getRfFieldType() {
            return this.variableValue.getRefValue().getRfFieldType();
        }

        @Override
        public String getInspectInfo(String fieldName) {
            return "";
        }
    }
}

